/*
 * dip		A program for handling dialup IP connecions.
 *		This module handles setting the interface and
 *		its routing table entry.
 *
 * Version:	@(#)attach.c	3.3.3	08/16/93
 *
 * Author:      Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 */
#include "dip.h"
#include <netinet/in.h>

static struct in_addr remote_ip;
static char if_name[255];

int
attach(char *name, struct dip *dip)
{
  char buff[1024];

  remote_ip=dip->rmt_ip;
  strcpy(if_name, name);

  /* Set up for "upping" the desired interface. */
  sprintf(buff, "%s %s %s pointopoint ", _PATH_BIN_IFCONFIG,
	name, inet_ntoa(dip->loc_ip));
  sprintf(&buff[strlen(buff)], "%s mtu %d", inet_ntoa(dip->rmt_ip), dip->mtu);
#ifdef DEBUG
  syslog(LOG_ERR, ">>> ATTACH \"%s\"\n", buff);
#endif
  if (system(buff) != 0) return(-1);

  sprintf(buff, "%s add -host %s", _PATH_BIN_ROUTE, inet_ntoa(dip->rmt_ip));
#ifdef DEBUG
  syslog(LOG_ERR, ">>> ATTACH \"%s\"\n", buff);
#endif
  if (system(buff) != 0) return(-1);
 
  if (dip->rtdefault == 1) sprintf(buff, "%s add default gw %s dev %s",
		_PATH_BIN_ROUTE, inet_ntoa(dip->rmt_ip), name);
    else {
	sprintf(buff, "%s add %s", _PATH_BIN_ROUTE, inet_ntoa(dip->rmt_ip));
	sprintf(&buff[strlen(buff)], " gw %s", inet_ntoa(dip->rmt_ip));
    }
#ifdef DEBUG
  syslog(LOG_ERR, ">>> ATTACH \"%s\"\n", buff);
#endif
  if (system(buff) != 0) return(-1);
  return(0);
}


void
detach(void)
{
  char buff[1024];

  /* Set up for "downing" the desired interface. */
  sprintf(buff, "%s %s down", _PATH_BIN_IFCONFIG, if_name);
  syslog(LOG_ERR, ">>> DETACH \"%s\"\n", buff);
  (void) system(buff);
}
