/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	mnuarbtn.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_menu_arrow_button class header
 *
 *	RCSid = "$Id: mnuarbtn.H,v 4.4.1.1 1993/06/01 22:55:34 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_mnuarbtn_H
#define OI_mnuarbtn_H

#ifndef OI_arbtn_H
#include <OI/arbtn.H>
#endif /* OI_arbtn_H */

	// class forward reference declaration
	class	OI_menu_cell;
	class	OI_menu_arrow_button;
	class	OI_mdl_menu_arrow_button;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		

	class OI_menu_arrow_button : public OI_arrow_button {
			OI_mdl_menu_arrow_button	*mdl_dep ;	/* ptr to model dependent aspects of OI_menu_arrow_button object */
			unsigned long	ctl_bits;
			OI_direction	dir;
			OI_xy		cell_sp;			/* space for cell */
			OI_xy		cell_loc;			/* location of cell */
		protected:
					OI_menu_arrow_button(OI_class*, const char*, OI_direction);
		virtual	void		new_model(OI_model_type) ;
		public:
		static	OI_class		*clsp ;			/* ptr to class record */
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_menu_arrow_button(const char*, OI_direction);
					~OI_menu_arrow_button() ;
			void		construct();
		static	OI_bool		init(OI_connection*);
		virtual	void		paint_arrow(Window,int,int);			/* paint in a window */
		virtual	void		paint_outline(Window,int,int);			/* paint in a window */
			void		paint_cell(OI_menu_cell*);
			void		set_cell_space(OI_number, OI_number);
			void		set_cell_loc(OI_number x, OI_number y)		{ cell_loc.x = x; cell_loc.y = y; }
			OI_number	cell_space_x();
			OI_number	cell_space_y();

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			// OI_stat		set_state(OI_state) ;
 		virtual	void		deactivate(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
 		virtual	void		focus_in(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 		virtual	void		focus_out(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
 			void		fire(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
 			void		popup(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_menu_arrow_button	*oi_create_menu_arrow_button(const char *, OI_direction);

#endif /* OI_mnuarbtn_H */
