/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	msdlg.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_ms_dialog_box class header
 *
 *	RCSid = "$Id: msdlg.H,v 4.3.1.1 1993/06/01 22:55:45 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef	OI_msdlg_H
#define	OI_msdlg_H

#ifndef OI_dlgbox_H
#include <OI/dlgbox.H>
#endif /* OI_dlgbox_H */

	// class forward reference declarations
	class OI_mdl_ms_dialog_box;
	class OI_base_text;
	class OI_glyph;

#define	MAXHT_OF_VP	20		/* Maximum height of the multitext region. */
#define	MAXWID_OF_VP	80		/* Maximum width of the multitext region. */

#define	OI_MS_DIALOG_BOX_MT_ROW		10000
#define	OI_MS_DIALOG_BOX_SEPARATOR_ROW	OI_MS_DIALOG_BOX_MT_ROW+1000
#define	OI_MS_DIALOG_BOX_GLYPH_COLUMN	10000
#define	OI_MS_DIALOG_BOX_MT_COLUMN	OI_MS_DIALOG_BOX_GLYPH_COLUMN+5000

class OI_ms_dialog_box : public OI_dialog_box {
			OI_mdl_ms_dialog_box	*mdl_dep;	/* pointer to model dependent ms dlg box. */
			OI_bool			def_menu;	/* True if menu is default. */
	 public:
		static	OI_class		*clsp ;		/* ptr to class record */
	 private:
			void			construct(OI_number, const char*, OI_glyph*) ;
	 protected:
						OI_ms_dialog_box(OI_class*, const char*, const char* =NULL, OI_number =-1,
							OI_menu_cell** =NULL, OI_glyph* =NULL) ;
						OI_ms_dialog_box(OI_class *, const char *, const char *, OI_number, OI_cell_spec *,
							OI_glyph *) ;
		virtual	void			new_model(OI_model_type) ;
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_ms_dialog_box(const char *, const char * = NULL, OI_number =-1, OI_menu_cell ** = NULL,
							OI_glyph * = NULL);
						OI_ms_dialog_box(const char *, const char *, OI_number, OI_cell_spec *, OI_glyph *);
						~OI_ms_dialog_box();
			OI_base_text		*base_text() ;
		virtual	void			clone_adjust(OI_d_tech*) ;
			OI_glyph		*glyph() ;
		static	OI_bool			init(OI_connection*) ;
			OI_bool			is_default_menu()		{return(def_menu);}

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_d_tech		*next_child(OI_d_tech*);			/* get child from property list */
		virtual	OI_number		num_props() ;
		virtual	OI_d_tech		*numbered_child(OI_number n) ;
		virtual	OI_bool			user_layout_ok() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_stat			append_file(const char *fn, OI_bool scroll=OI_no) ;
												/* append contents of file to text */
			OI_stat			append_file(FILE *fp, OI_bool scroll=OI_no) ;	/* append contents of file to text */
			OI_stat			append_string(const char *str,OI_bool scroll=OI_no) ;
												/* append contents of string to text */
			OI_stat			set_text(OI_text_fnp);
			OI_stat			set_text(OI_callback *, OI_text_memfnp);
			OI_stat			set_text_to_file(const char *fn) ;
			OI_stat			set_text_to_file(FILE *fp) ;
			OI_stat			set_text_to_string(const char *str) ;
};

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

#endif /* OI_msdlg_H */
