/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	scrlbox.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_scroll_box class header
 *
 *	RCSid = "$Id: scrlbox.H,v 4.18.1.1 1993/06/01 22:56:34 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_scrlbox_H
#define OI_scrlbox_H

#ifndef OI_box_H
#include <OI/box.H>
#endif /* OI_box_H */

	// class forward reference declarations
	class OI_mdl_scroll_box;
	class OI_heading_box;
	class OI_scroll_bar;
	class OI_panner;

 /* ctl_bits private bits */
#define			OI_SCROLL_BOX_PAN_MOVE		0x1	/* 1 => 2D panner move, don't do single dimensional moves */
#define			OI_SCROLL_BOX_MOTION_CALLBACK	0x10	/* 1 => controlled object callbacks for motion events */
#define			OI_SCROLL_BOX_SPAN_UPDATE	0x20	/* 1 => update span/viewport/handle appearance when span/view changes */
#define			OI_SCROLL_BOX_UNIT_ADJ		0x40	/* 1 => in process of updating units */

	class OI_scroll_box : public OI_box {	/* scrollable box */
			OI_mdl_scroll_box		*mdl_dep ;	// ptr to model dependent aspects of object
			unsigned long			ctl_bits ;	// object specific control bits
			OI_controller_visibility	ctlr_vis;	// controller visibility mode
			OI_number			in_my_cnstr ;	// >0 => in some op which forces parenting objects to self, not obj box
			OI_number			ctlr_typ ;	// types of controllers present
			OI_number			scrl_org_x ;	// actual X window origin for objectbox
			OI_number			scrl_org_y ;
			OI_number			delta_x ;	// # pixels to scroll per unit in x direction
			OI_number			delta_y ;	// # pixels to scroll per unit in y direction
			OI_number			obj_spn_x ;	// logical span of scroll box, user units
			OI_number			obj_spn_y ;	// logical span of scroll box, user units
			OI_number			nom_vw_x ;	// nominal viewport size, user units
			OI_number			nom_vw_y ;	// nominal viewport size, user units
	 public:
		static	OI_class			*clsp ;		// ptr to class record

	 private:
			OI_bool				adjusting_units() ;		/* OI_yes => in process of udjusting units */
			void				adj_headings() ;
			OI_heading_box			*bottom_heading_box() ;
			void				clear_adjusting_units() ;
			void				clear_in_my_constructor()		{in_my_cnstr--;}
			void				construct(OI_number, OI_number, OI_number, OI_number, OI_number, OI_number, OI_number) ;
			void				heading_chg(OI_d_tech*,void*) ;
			OI_bool				in_my_constructor()		{return((OI_bool)in_my_cnstr);}
			OI_heading_box			*left_heading_box() ;
			void				make_outside_size_consistent() ;
			OI_number			min_view_x(OI_number,OI_number) ;
			OI_number			min_view_y(OI_number,OI_number) ;
			void				viewport_metrics(OI_number*,OI_number*,OI_number*,OI_number*) ;	/* determine viewport size metrics */
			void				res_auto_controller_visibility(void*);	// OBSOLETE
			OI_bool				res_collapse(void *);			// OBSOLETE
			void				res_motion_callback(void*);
			void				res_span_update(void*);
			void				res_controllers(void*);
			void				res_object_size_x(void*);
			void				res_object_size_y(void*);
			void				res_units_x(void*);
			void				res_units_y(void*);
			void				res_view_size_x(void*);
			void				res_view_size_y(void*);
			OI_heading_box			*right_heading_box() ;
			void				set_adjusting_units() ;
			void				set_in_my_constructor()	{in_my_cnstr++;}
			OI_heading_box			*top_heading_box() ;
	 protected:
							OI_scroll_box(OI_class *clsp, const char *usr_namp, OI_number ct, OI_number vw, OI_number vh,
								OI_number ow, OI_number oh, OI_number uw=1, OI_number uh=1) ;
			OI_bool				adj_ctlr_vis(OI_controller_visibility) ;	/* adjust ctlr visibility based on viewport, obj box size */
		virtual	OI_d_tech			*callback_object(XrmQuark) ;
		virtual	void				controller_space(OI_number*, OI_number*);
			void				heading_minimum_space(OI_number*, OI_number*);
		virtual	void				heading_space(OI_number*, OI_number*);
		virtual	void				new_model(OI_model_type) ;
			void				object_box_resize(OI_d_tech*,void*) ;		/* resize because of change in underlying menu */
			void				resize(OI_d_tech*,void*) ;			/* resize callback */
		virtual	OI_d_tech			*val_assoc(OI_d_tech*) ;
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
							OI_scroll_box(const char*, OI_number,OI_number,OI_number,OI_number,OI_number,OI_number=1,OI_number=1) ;
							~OI_scroll_box() ;
		virtual	void				allow_abs_associate();
		virtual	OI_d_tech			*associate_parent(OI_d_tech* =NULL) ;
		virtual	void				change_controllers(OI_number) ;				/* change which controllers are present */
		virtual	void				clone_adjust(OI_d_tech*) ;
		virtual	OI_number			default_horz_space();
		virtual	OI_number			default_vert_space();
		virtual	void				disallow_abs_associate();
		static	OI_bool				init(OI_connection*) ;
			OI_d_tech			*interior_obj(const char *namp) ;
		virtual	OI_bool				is_write_resq(XrmQuark);
		virtual	OI_layout_method		*layout_method() ;
		static	OI_scroll_box			*make_minimal(const char*,OI_minimal_type) ;
			void				make_visible(long,long,OI_number,OI_number,OI_bool) ;	/* force given rectangle to be visible */
		virtual	void				min_outside_size(OI_number,OI_number,OI_number*,OI_number*) ;
		virtual	void				new_bkg_pixmap(OI_pixmap*);
		virtual	void				new_bvl_width(OI_number bw) ;
		virtual	void				new_def_horz_space(OI_number);
		virtual	void				new_def_vert_space(OI_number);
		virtual	void				new_layout(OI_layout, OI_number= -1, OI_number= -1) ;
		virtual	OI_stat				new_size(OI_number,OI_number);
			OI_stat				new_view_size(OI_number,OI_number) ;		/* change size of viewport */
		virtual	void				nominal_outside_size(OI_number*,OI_number*);
			OI_number			nominal_view_size_x()		{ return(nom_vw_x); }
			OI_number			nominal_view_size_y()		{ return(nom_vw_y); }
			OI_bool				res_controller_visibility(void*);		// needed by scroll_menu
			void				set_nominal_view_size(OI_number,OI_number) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_number			first_column(OI_number r= OI_undefined) ;
		virtual	OI_number			first_row(OI_number c= OI_undefined) ;
		virtual	OI_number			in_column(OI_number c, long x, OI_number r= OI_undefined, OI_number pct=100) ;
		virtual	OI_number			in_row(OI_number r, long y, OI_number c= OI_undefined, OI_number pct=100) ;
		virtual	OI_number			last_column(OI_number r= OI_undefined) ;
		virtual	OI_number			last_row(OI_number c= OI_undefined) ;
		virtual	void				new_column(OI_number c, OI_number r= OI_undefined) ;
		virtual	void				new_row(OI_number r, OI_number c= OI_undefined) ;
		virtual	OI_number			next_column(OI_number c, OI_number r= OI_undefined) ;
		virtual	OI_number			next_row(OI_number r, OI_number c= OI_undefined) ;
		virtual	OI_number			prev_column(OI_number c, OI_number r= OI_undefined) ;
		virtual	OI_number			prev_row(OI_number r, OI_number c= OI_undefined) ;
			void				allow_auto_controller_visibility(OI_bool=OI_yes) ;
			void				allow_collapse() ;			// use set_controller_visibility()
			void				disallow_auto_controller_visibility() ;	// use set_controller_visibility
			void				disallow_collapse() ;			// use set_controller_visibility()
			OI_bool				is_auto_controller_visibility() ;	// use controller_visibility()
			OI_bool				is_collapse() ;				// use controller_visibility()

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void				avail_loc(OI_number *lxp, OI_number *lyp) ; 	/* next available location */
		virtual	OI_number			avail_loc_x() ;					/* next available location in x direction */
		virtual	OI_number			avail_loc_y() ;					/* next available location in y direction */
		virtual	OI_pixmap			*bkg_pixmap();
			OI_number			controllers()			{return(ctlr_typ);}
		virtual	OI_layout			layout() ;
		virtual	OI_d_tech			*next_child(OI_d_tech*);			/* get child from property list */
		virtual	OI_number			num_props();
		virtual	OI_d_tech			*numbered_child(OI_number n);
		virtual	void				resume_layout(OI_bool=OI_YES);
		virtual	void				set_avail_loc(OI_number x, OI_number y) ; 	/* set upper left corner of available space */
		virtual	void				set_avail_loc_x(OI_number x) ; 			/* set ULC of available space in x direction */
		virtual	void				set_avail_loc_y(OI_number y) ; 			/* set ULC of available space in y direction */
		virtual	void				set_click(OI_click_fnp fp, void *argp=NULL) ;
		virtual	void				set_click(OI_callback *objp, OI_click_memfnp mfp, void *argp=NULL) ;
		virtual	void				set_expose(OI_obj_event_fnp fp, void *argp=NULL) ;
		virtual	void				set_expose(OI_callback *objp, OI_obj_event_memfnp mfp, void *argp=NULL) ;
		virtual	OI_d_tech			*subobject(const char*) ;
		virtual	OI_d_tech			*subobject(XrmQuark) ;
		virtual	void				suspend_layout();
		virtual	Window 				X_window() ;   					/* get object's X_window id */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void				allow_motion_callback()	;
			void				allow_span_update() ;
			OI_d_tech			*bottom_heading() ;
			OI_scroll_bar			*bottom_scroll_bar() ;
			OI_controller_visibility	controller_visibility() ;		/* controller visibility mode */
			void				disallow_motion_callback() ;
			void				disallow_span_update() ;
			void				handle_loc(long*,long*) ;
			long				handle_loc_x() ;
			long				handle_loc_y() ;
			OI_scroll_bar			*horz_scroll_bar() ;
			OI_bool				is_bottom_heading() ;
			OI_bool				is_left_heading() ;
			OI_bool				is_motion_callback()		{ return(OI_bool)((ctl_bits&OI_SCROLL_BOX_MOTION_CALLBACK)!=0); }
			OI_bool				is_right_heading() ;
			OI_bool				is_span_update()		{ return(OI_bool)((ctl_bits&OI_SCROLL_BOX_SPAN_UPDATE)!=0); }
			OI_bool				is_top_heading() ;
			OI_d_tech			*left_heading() ;
			OI_scroll_bar			*left_scroll_bar() ;
			OI_box				*object_box() ;
			void				object_size(OI_number*,OI_number*) ;		/* get size of object box */
			OI_number			object_size_x() ;				/* get x size of object box */
			OI_number			object_size_y() ;				/* get y size of object box */
			OI_panner			*panner() ;
			OI_d_tech			*right_heading() ;
			OI_scroll_bar			*right_scroll_bar() ;
			void				scroll(OI_ctlr_1d*,void*,OI_scroll_event,long) ;	/* scroll object in 1 dimension */
			void				scroll_2d(OI_panner*,void*,OI_scroll_event,long,long) ;	/* scroll object in 2 dimensions */
			void				set_controller_visibility(OI_controller_visibility) ;	/* set controller_visibility mode */
			OI_stat				set_handle_loc(long,long) ;			/* position horizontally and vertically */
			OI_stat				set_handle_loc_x(long) ;			/* position horizontally */
			OI_stat				set_handle_loc_y(long) ;			/* position vertically */
			OI_stat				set_object_size(OI_number,OI_number) ;		/* change size of object box */
			OI_stat				set_units(OI_number,OI_number) ;		/* set user units for object being scrolled */
			OI_stat				set_view_size(OI_number,OI_number) ;		/* change size of viewport */
			OI_d_tech			*top_heading() ;
			OI_scroll_bar			*top_scroll_bar() ;
			void				units(OI_number *x, OI_number *y)	{*x = delta_x; *y = delta_y;}
			OI_number			units_x()				{return(delta_x);}
			OI_number			units_y()				{return(delta_y);}
			void				view_size(OI_number *x, OI_number *y) ;
			OI_number			view_size_x() ;
			OI_number			view_size_y() ;
			OI_box				*viewport() ;
			OI_scroll_bar			*vert_scroll_bar() ;
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_scroll_box	*oi_create_scroll_box(const char*, OI_number,OI_number,OI_number,OI_number,OI_number,OI_number=1,OI_number=1) ;

#endif /* OI_scrlbox_H */
