
#line 1 "act2.mt"

#include <u.h>
#include <libc.h>
#include <stdio.h>
#include "dat.h"

typedef struct Cost {
	int gate;
	int pin;
} Cost;
Cost gatecost = {1,0};
Cost pincost = {0,1};
Cost zerocost = {0,0};
Cost infinity = {1000000,0};
Cost bigcost = {1000,0};

#define COST		Cost
#define INFINITY	infinity
#define ZEROCOST	gatecost	/* default cost of a rule */
#define ADDCOST(x,y)	(x.gate += y.gate, x.pin += y.pin)
#define COSTLESS(x,y)	((x.gate)<(y.gate) || (x.gate==y.gate && x.pin<y.pin))
#line 1 "/sys/lib/twig/walker.stdio"
/*
 * The machine is laid out as a sequence of integers in the walker.
 * The form described above is only used inside the preprocessor.
 * Each machine state is one of the following sequence:
 *
 * TABLE <value_1><index_1>...<value_n><index_n> -1 [FAIL <fail_index>] -1
 * or
 * TABLE2 <value_1><index_1>...<value_n><index_n> -1 [FAIL <fail_index>] -1
 * or
 * ACCEPT <accept table index> -1
 *
 * The accept table is in the form:
 *
 * <tree index_1> ...<tree_index_m> -1
 *
 */

enum{
	FASTLIM,
	TABLE,
	FAIL,
	ACCEPT,
	TABLE2,
	EOT	= -1,

	/* special machine state */
	HANG	= -1,
};

/*
 * In order for the walker to access the labelled leaves of a pattern,
 * a table (mistakenly) called the path table is generated (see sym.c).
 * This table contains the following possible values:
 *
 * ePush	follow the children link in the walker skeleton.
 * ePop		Pop up to parent.
 * eNext	follow  the siblings link.
 * eEval <arg>	The current node is a labelled leaf whose label id
 *		is the integer <arg>.
 * eStop	All done. stop!
 *
 * The table is interpreted by the _getleaves routine in the walker.
 */
enum{
	eSTOP		= 0,
	ePOP		= -1,
	eEVAL		= -2,
	eNEXT		= -3,
	ePUSH		= -4,

	/*
	 * Tags that indicate the type of a value
	 * max values for shorts
	 * CHANGE CAREFULLY!!!
	 */
	M_BRANCH	= 0x4000,
	M_NODE		= 0,
	M_LABEL		= 0x2000,
	MAX_NODE_VALUE	= 0x1fff,
	MTAG_SHIFT	= 9,
};

#define M_DETAG(x)	((x)&~(M_BRANCH|M_LABEL|M_NODE))

/* predicates to tell whether a value x is of type NODE, BRANCH, or LABEL */
#define MI_NODE(x)	(((x)&(M_BRANCH|M_LABEL))==0)
#define MI_DEFINED(x)	((x)!=-1)
#define MI_LABEL(x)	(((x)&M_LABEL)!=0)
#define MI_BRANCH(x)	(((x)&M_BRANCH)!=0)

/* build a tagged value */
#define MV_NODE(x)	(x)
#define MV_BRANCH(x)	((x)|M_BRANCH)
#define MV_LABEL(x)	((x)|M_LABEL)

#include "symbols.h"

/* limits */
/*
 * The depth of a pattern must be 7 or less.  Otherwise the type of he
 * partial mask in skeleton must be changed
 */
#define MAXDEPTH	7

/* modes */
#define xTOPDOWN	3
#define xABORT		2
#define xREWRITE	1
#define xDEFER		0

/* macros */
#define tDO(m)	_do((m)->skel, (m), 1)
#define REWRITE	return(_m->cost = cost, xREWRITE)
#define TOPDOWN return(_m->cost = cost, xTOPDOWN)
#define ABORT return(xABORT)

/*
 * REORDER macro allows a knowledgeable user to change the order
 * of evaluation of the leaves.
 */
#ifndef REORDER
#define REORDER(list)	_evalleaves(list)
#endif
#define EVAL	REORDER(_ll)

#define mpush(s,m)	(m)->next = s, s = m

/* skeleton structure */
typedef struct skeleton		skeleton;
typedef struct __match		__match;
typedef struct __partial	__partial;
typedef int			labelset;	/* a bit vector of labels */

struct __partial {
	short		treeno;
	short		bits;
};

struct skeleton {
	skeleton	*sibling;
	skeleton	*leftchild;		/* leftmost child */
	skeleton	*rightchild;		/* rightmost child */
	NODEPTR		root;
	NODEPTR		parent;			/* our parent */
	int		nson;
	int		treecnt;
	__match		*succ[MAXLABELS];
	__partial	*partial;
	__match		*winner;
	COST		mincost;
};

struct __match {
	__match		**lleaves;	/* labelled leaves */
	skeleton	*skel;		/* back pointer to skeleton node */
	COST		cost;
	short		tree;
	short		mode;
};

/* ZEROCOST, and ADDCOST allows easy implementation of the common
 * operation of just equating the cost of a match to be the sum
 * of the costs of the labelled leaves.
 */
#ifdef ADDCOST
#define DEFAULT_COST sumleaves(_ll)
COST sumleaves(__match **list)
{
	COST cost;
	cost = ZEROCOST;
	for(; *list; list++)
		ADDCOST((cost),(*list)->cost);
	return cost;
}
#endif
/*
 * See Aho, Corasick Comm ACM 18:6, and Hoffman and O'Donell JACM 29:1
 * for detail of the matching algorithm
 */

#ifndef va_start
#include <stdarg.h>
#endif
/* from libc.h */
extern	void*	malloc(long);
extern	void	free(void*);
extern	void	abort(void);
#define _twig_assert(a,str) \
	do{if(!(a)){\
		fprintf(stderr, "twig internal error %s\n", (str));\
		abort();\
	}}while(0)

/* these are user defined, so can be macros */
#ifndef mtValue
int		mtValue(NODEPTR);
#endif
#ifndef mtSetNodes
void		mtSetNodes(NODEPTR, int, NODEPTR);
#endif
#ifndef mtGetNodes
NODEPTR		mtGetNodes(NODEPTR, int);
#endif

/* made by twig proper */
NODEPTR		mtAction(int, __match **, skeleton *);
short		mtEvalCost(__match *, __match **, skeleton *);

/* stuff defined here */
void		_addmatches(int, skeleton *, __match *);
void		_closure(int, int, skeleton *);
void		_do(skeleton *, __match *, int);
void		_evalleaves(__match **);
__match		**_getleaves(__match *, skeleton *);
int		_machstep(short, short);
void		_match(void);
void		_matchinit(void);
void		_merge(skeleton *, skeleton *);
NODEPTR		_mtG(NODEPTR, ...);
skeleton	*_walk(skeleton *, int);
__match		*_allocmatch(void);
skeleton	*_allocskel(void);
__partial	*_allocpartial(void);
void		_freematch(__match *);
void		_freeskel(skeleton *);
void		_freepartial(__partial *);
void		_prskel(skeleton *, int);

int mtDebug = 0;
int treedebug = 0;
extern short mtStart;
extern short mtTable[], mtAccept[], mtMap[], mtPaths[], mtPathStart[];
#ifdef LINE_XREF
	extern short mtLine[];
#endif

#ifndef MPBLOCKSIZ
#define MPBLOCKSIZ 10000
#endif
__match *_mpblock[MPBLOCKSIZ], **_mpbtop;

/*
 * See sym.h in the preprocessor for details
 * Basically used to support eh $%n$ construct.
 */
__match **
_getleaves(__match *mp, skeleton *skp)
{
	skeleton *stack[MAXDEPTH];
	skeleton **stp = stack;
	short *sip = &mtPaths[mtPathStart[mp->tree]];
	__match **mmp = _mpbtop;

	__match **mmp2 = mmp;
	_mpbtop += *sip++ + 1;
	_twig_assert(_mpbtop <= &_mpblock[MPBLOCKSIZ], "match block overflow");

	for(;;)
		switch(*sip++){
		case ePUSH:
			*stp++ = skp;
			skp = skp->leftchild;
			break;
		case eNEXT:
			skp = skp->sibling;
			break;
		case eEVAL:
			mp = skp->succ[M_DETAG(*sip++)];
			_twig_assert(mp != 0, "bad eEVAL");
			*mmp++ = mp;
			break;
		case ePOP:
			skp = *--stp;
			break;
		case eSTOP:
			*mmp = 0;
			return mmp2;
		}
}

void
_do(skeleton *sp, __match *winner, int evalall)
{
	skeleton *skel;

	if(winner == 0) {
		_prskel(sp, 0);
		fprintf(stderr, "no winner");
		return;
	}

	skel = winner->skel;
	if(winner->mode == xDEFER || evalall && winner->mode != xTOPDOWN)
		REORDER(winner->lleaves);
	skel->root = mtAction(winner->tree, winner->lleaves, sp);
	mtSetNodes(skel->parent, skel->nson, skel->root);
}

void
_evalleaves(__match **mpp)
{
	__match *mp;
	while(*mpp){
		mp = *mpp++;
		_do(mp->skel, mp, 1);
	}
}

skeleton *
_walk(skeleton *sp, int ostate)
{
	int state, nstate, nson;
	__partial *pp;
	__match *mp;
	skeleton *nsp, *lastchild = 0;
	NODEPTR son, root;

	root = sp->root;
	nson = 1;
	sp->mincost = INFINITY;
	state = _machstep(ostate, mtValue(root));

	while(son = mtGetNodes(root, nson)){
		nstate = _machstep(state, MV_BRANCH(nson));
		nsp = _allocskel();
		nsp->root = son;
		nsp->parent = root;
		nsp->nson = nson;
		_walk(nsp, nstate);
		if(COSTLESS(nsp->mincost, INFINITY)){
			_twig_assert(nsp->winner->mode == xREWRITE, "bad mode");
			if(mtDebug || treedebug) {
				fprintf(stderr, "rewrite\n");
				_prskel(nsp, 0);
			}
			_do(nsp, nsp->winner, 0);
			_freeskel(nsp);
			continue;
		}
		_merge(sp, nsp);
		if(lastchild == 0)
			sp->leftchild = nsp;
		else
			lastchild->sibling = nsp;
		lastchild = nsp;
		nson++;
	}

	for(pp = sp->partial; pp < &sp->partial[sp->treecnt]; pp++)
		if(pp->bits & 01){
			mp = _allocmatch();
			mp->tree = pp->treeno;
			_addmatches(ostate, sp, mp);
		}
	if(son == 0 && nson == 1)
		_closure(state, ostate, sp);

	sp->rightchild = lastchild;
	if(root == 0){
		COST c;
		__match *win;
		int i;

		nsp = sp->leftchild;
		c = INFINITY;
		win = 0;
		for(i = 0; i < MAXLABELS; i++){
			mp = nsp->succ[i];
			if(mp != 0 && COSTLESS(mp->cost, c)){
				c = mp->cost;
				win = mp;
			}
		}
		if(mtDebug || treedebug)
			_prskel(nsp, 0);
		_do(nsp, win, 0);
	}
	if(mtDebug)
		_prskel(sp, 0);
	return sp;
}

static short _nodetab[MAXNDVAL], _labeltab[MAXLABELS];

/*
 * Convert the start state which has a large branching factor into
 * a index table.  This must be called before the matcher is used.
 */
void
_matchinit(void)
{
	short *sp;

	for(sp = _nodetab; sp < &_nodetab[MAXNDVAL]; sp++)
		*sp = HANG;
	for(sp = _labeltab; sp < &_labeltab[MAXLABELS]; sp++)
		*sp = HANG;
	sp = &mtTable[mtStart];
	_twig_assert(*sp == TABLE, "mtTable[mtStart]!=TABLE");
	for(++sp; *sp != -1; sp += 2){
		if(MI_NODE(*sp))
			_nodetab[M_DETAG(*sp)] = sp[1];
		else if(MI_LABEL(*sp))
			_labeltab[M_DETAG(*sp)] = sp[1];
	}
}

int
_machstep(short state, short input)
{
	short *stp = &mtTable[state];
	int start = 0;

	if(state == HANG)
		return input == MV_BRANCH(1) ? mtStart : HANG;
rescan:
	if(stp == &mtTable[mtStart]){
		if(MI_NODE(input))
			return _nodetab[M_DETAG(input)];
		if(MI_LABEL(input))
			return _labeltab[M_DETAG(input)];
	}
	
	for(;;){
		if(*stp == ACCEPT)
			stp += 2;
		if(*stp == TABLE){
			stp++;
			while(*stp != -1)
				if(input == *stp)
					return stp[1];
				else
					stp += 2;
			stp++;
		}
		if(*stp != FAIL){
			if(start)
				return HANG;
			else{
				stp = &mtTable[mtStart];
				start = 1;
				goto rescan;
			}
		}else{
			stp = &mtTable[stp[1]];
			goto rescan;
		}
	}
}

void
_addmatches(int ostate, skeleton *sp, __match *np)
{
	int label;
	int state;
	__match *mp;

        label = mtMap[np->tree];

	/*
	 * this is a very poor substitute for good design of the DFA.
	 * What we need is a special case that allows any label to be accepted
	 * by the start state but we don't want the start state to recognize
	 * them after a failure.
	 */
	state = _machstep(ostate, MV_LABEL(label));
	if(ostate != mtStart && state == HANG){
		_freematch(np);
		return;
	}

	np->lleaves = _getleaves(np, sp);
	np->skel = sp;
        if((np->mode = mtEvalCost(np, np->lleaves, sp)) == xABORT){
		_freematch(np);
		return;
	}

	if(mp = sp->succ[label]){
		if(!COSTLESS(np->cost, mp->cost)){
			_freematch(np);
			return;
		}
		_freematch(mp);
	}
	if(COSTLESS(np->cost, sp->mincost)){
		if(np->mode == xREWRITE){
			sp->mincost = np->cost;
			sp->winner = np;
		}else{
			sp->mincost = INFINITY;
			sp->winner = 0;
		}
	}
	sp->succ[label] = np;
	_closure(state, ostate, sp);
}

void
_closure(int state, int ostate, skeleton *skp)
{
	short *sp = &mtTable[state];
	__match *mp;

	if(state == HANG || *sp != ACCEPT)
		return;

	for(sp = &mtAccept[sp[1]]; *sp != -1; sp += 2)
		if(sp[1] == 0){
			mp = _allocmatch();	
			mp->tree = *sp;
			_addmatches(ostate, skp, mp);
		}else{
			__partial *pp;
			__partial *lim = &skp->partial[skp->treecnt];
			for(pp = skp->partial; pp < lim; pp++)
				if(pp->treeno == *sp)
					break;
			if(pp == lim){
				skp->treecnt++;
				pp->treeno = *sp;
				pp->bits = 1 << sp[1];
			}else
				pp->bits |= 1 << sp[1];
		}
}

void
_merge(skeleton *old, skeleton *new)
{
	__partial *op = old->partial, *np = new->partial;
	int nson = new->nson;
	__partial *lim = np + new->treecnt;
	if(nson == 1){
		old->treecnt = new->treecnt;
		for(; np < lim; op++, np++) {
			op->treeno = np->treeno;
			op->bits = np->bits / 2;
		}
	}else{
		__partial *newer = _allocpartial();
		__partial *newerp = newer;
		int cnt;
		lim = op + old->treecnt;
		for(cnt = new->treecnt; cnt-- ; np++){
			for(op = old->partial; op < lim; op++)
				if(op->treeno == np->treeno){
					newerp->treeno = op->treeno;
					newerp++->bits = op->bits & np->bits / 2;
					break;
				}
		}
		_freepartial(old->partial);
		old->partial = newer;
		old->treecnt = newerp-newer;
	}
}
 
/* memory management */

#define BLKF	100

typedef union __matchalloc{
	__match			it;
	union __matchalloc	*next;
}__matchalloc;
static __matchalloc *__matchfree = 0;
#ifdef CHECKMEM
staic int a_matches;
#endif

__match *
_allocmatch(void)
{
	static int count = 0;
	static __matchalloc *block = 0;
	__matchalloc *m;

	if(__matchfree){
		m = __matchfree;
		__matchfree = __matchfree->next;
	}else{
		if(count == 0){
			block = (void *)malloc(BLKF * sizeof *block);
			count = BLKF;
		}
		m = block++;
		count--;
	}
#ifdef CHECKMEM
		a_matches++;
#endif
	return (__match *)m;
}

void
_freematch(__match *mp)
{
	__matchalloc *m = (__matchalloc *)mp;
	m->next = __matchfree;
	__matchfree = m;
#ifdef CHECKMEM
	a_matches--;
#endif
}

typedef union __partalloc{
	__partial		it[MAXTREES];
	union __partalloc	*next;
}__partalloc;
static __partalloc *__partfree = 0;
#ifdef CHECKMEM
static int a_partials;
#endif

__partial *
_allocpartial(void)
{
	static int count = 0;
	static __partalloc *block = 0;
	__partalloc *p;

	if(__partfree != 0){
		p = __partfree;
		__partfree = __partfree->next;
	}else{
		if(count == 0){
			block = (void *)malloc(BLKF * sizeof *block);
			count = BLKF;
		}
		p = block++;
		count--;
	}
#ifdef CHECKMEM
		a_partials++;
#endif
	return (__partial *)p;
}

void
_freepartial(__partial *pp)
{
	__partalloc *p = (__partalloc *)pp;
	p->next = __partfree;
	__partfree = p;
#ifdef CHECKMEM
	a_partials--;
#endif
}

typedef union __skelalloc{
	skeleton		it;
	union __skelalloc	*next;
}__skelalloc;
static __skelalloc *__skelfree = 0;

skeleton *
_allocskel(void)
{
	static int count = 0;
	static __skelalloc *block = 0;
	__skelalloc *sf;
	skeleton *s;
	int i;

	if(__skelfree){
		sf = __skelfree;
		__skelfree = sf->next;
	}else{
		if(count == 0){
			block = (void *)malloc(BLKF * sizeof *block);
			count = BLKF;
		}
		sf = block++;
		count--;
	}
	s = (skeleton *)sf;
	s->sibling = 0;
	s->leftchild = 0;
	i = 0;
	while(i < MAXLABELS)
		s->succ[i++] = 0;
	s->treecnt = 0;
	s->partial = _allocpartial();
	return s;
}

void
_freeskel(skeleton *s)
{
	int i;
	__match *mp;
	__skelalloc *sf;

	if(s == 0)
		return;
	if(s->leftchild)
		_freeskel(s->leftchild);
	if(s->sibling)
		_freeskel(s->sibling);
	_freepartial(s->partial);
	i = 0;
	while(i < MAXLABELS)
		if(mp = s->succ[i++])
			_freematch(mp);
	sf = (__skelalloc *)s;
	sf->next = __skelfree;
	__skelfree = sf;
}

void
_match(void)
{
	skeleton *sp;
	sp = _allocskel();
	sp->root = 0;
	_mpbtop = _mpblock;
	_freeskel(_walk(sp, HANG));
#ifdef CHECKMEM
	_twig_assert(a_matches == 0, "__match memory leak");
	_twig_assert(a_partials == 0, "__partial memory leak");
#endif
}

NODEPTR
_mtG(NODEPTR root, ...)
{
	va_list a;
	int i;

	va_start(a, root);
	while((i = va_arg(a, int)) != -1)
		root = mtGetNodes(root, i);
	va_end(a);
	return root;
}

/* diagnostic routines */
void
_prskel(skeleton *skp, int lvl)
{
	int i;
	__match *mp;
	__partial *pp;
	if(skp==0)
		return;
	for(i = lvl; i > 0; i--)
		fprintf(stderr, "  ");
	fprintf(stderr, "###\n");
	for(i = lvl; i > 0; i--)
		fprintf(stderr, "  ");
	for(i = 0; i < MAXLABELS; i++)
		if(mp = skp->succ[i])
#ifdef LINE_XREF
			fprintf(stderr, "[%d<%d> %d]", mp->tree,
				mtLine[mp->tree], mp->cost);
#else
			fprintf(stderr, "[%d %d]", mp->tree, mp->cost);
#endif
	fprintf(stderr, "\n");
	for(i = lvl; i > 0; i--)
		fprintf(stderr, "  ");
	for(i = 0, pp=skp->partial; i < skp->treecnt; i++, pp++)
#ifdef LINE_XREF
			fprintf(stderr, "(%d<%d> %x)", pp->treeno, mtLine[pp->treeno],
				pp->bits);
#else
			fprintf(stderr, "(%d %x)", pp->treeno, pp->bits);
#endif
	fprintf(stderr, "\n");
	_prskel(skp->leftchild, lvl + 2);
	_prskel(skp->sibling, lvl);
}
short mtTable[] = {
3,0,-1,3,3,-1,3,6,-1,3,
9,-1,3,12,-1,3,15,-1,3,18,
2,12,-1,3,23,2,15,-1,3,28,
2,47,-1,1,0x2000,28,-1,2,2462,-1,
1,0x4001,33,-1,2,2483,-1,3,35,2,
3,-1,3,40,-1,3,43,2,2901,-1,
1,0x2000,55,-1,2,2906,-1,1,0x4001,60,
-1,2,2913,-1,3,78,2,2901,-1,1,
0x2000,74,-1,2,2906,-1,1,0x4001,79,-1,
2,2913,-1,1,0x4,86,-1,2,2930,-1,
3,91,2,3320,-1,1,0x2000,100,-1,2,
2956,-1,3,148,2,3435,-1,1,0x2000,112,
-1,2,2982,-1,3,213,2,3454,-1,1,
0x2000,124,-1,2,3459,-1,1,0x4001,129,-1,
2,3466,-1,1,0x4,136,-1,2,2994,-1,
1,0x4001,117,0x4002,143,-1,2,3001,-1,1,
0x6,150,-1,2,3010,-1,1,0x4001,105,0x4002,
159,-1,2,3017,-1,1,0x6,166,-1,2,
3026,-1,1,0x4001,93,0x4002,175,-1,2,3033,
-1,3,244,2,2642,-1,1,0x2000,191,-1,
2,2647,-1,1,0x4001,196,-1,2,2654,-1,
3,345,2,2637,-1,1,0x4,203,0x2000,210,
-1,2,2661,-1,3,416,2,2802,-1,1,
0x2000,224,-1,2,2807,-1,1,0x4001,229,-1,
2,2814,-1,1,0x4,236,-1,2,2826,-1,
3,445,2,2842,-1,1,0x2000,250,-1,2,
2847,-1,1,0x4001,255,-1,2,2854,-1,1,
0x4,262,-1,2,2861,-1,1,0x4001,243,0x4002,
269,-1,2,2870,-1,3,476,2,2675,-1,
1,0x2000,285,-1,2,2680,-1,1,0x4001,290,
-1,2,2687,-1,3,517,2,2670,-1,3,
578,2,2694,-1,3,631,2,2699,-1,1,
0x2000,314,-1,2,2704,-1,1,0x4001,319,-1,
2,2711,-1,1,0x2000,309,0x4,326,-1,2,
2718,-1,3,678,2,2727,-1,3,717,2,
2732,-1,1,0x2000,347,-1,2,2737,-1,1,
0x4001,352,-1,2,2744,-1,1,0x2000,342,0x4,
359,-1,2,2751,-1,1,0x4001,333,0x4002,366,
-1,2,2760,-1,1,0x6,276,0x4,297,0x2000,
304,0x5,375,-1,2,2879,-1,1,0x4001,215,
0x4002,384,-1,2,2892,-1,3,734,2,2920,
-1,1,0x4,67,0x6,182,0x5,397,0x2000,406,
-1,2,3042,-1,3,769,2,3301,-1,1,
0x2000,424,-1,2,3306,-1,1,0x4001,429,-1,
2,3313,-1,3,806,2,3320,-1,1,0x4,
436,0x2000,443,-1,2,3386,-1,3,875,2,
3416,-1,1,0x2000,457,-1,2,3421,-1,1,
0x4001,462,-1,2,3428,-1,3,912,2,3435,
-1,1,0x4,469,0x2000,476,-1,2,3440,-1,
3,979,2,3454,-1,1,0x2000,490,-1,2,
3459,-1,1,0x4001,495,-1,2,3466,-1,3,
1014,2,3449,-1,1,0x4,502,0x2000,509,-1,
2,3473,-1,1,0x4001,481,0x4002,514,-1,2,
3482,-1,3,1065,2,3397,-1,1,0x2000,532,
-1,2,3402,-1,1,0x4001,537,-1,2,3409,
-1,3,1100,2,3491,-1,1,0x6,523,0x4,
544,0x2000,551,-1,2,3496,-1,1,0x4001,448,
0x4002,556,-1,2,3507,-1,3,1145,2,3282,
-1,1,0x2000,576,-1,2,3287,-1,1,0x4001,
581,-1,2,3294,-1,3,1176,2,3053,-1,
1,0x2000,595,-1,2,3058,-1,1,0x4001,600,
-1,2,3065,-1,3,1223,2,3072,-1,1,
0x4,607,0x2000,614,-1,2,3077,-1,3,1274,
2,3124,-1,1,0x2000,628,-1,2,3129,-1,
1,0x4001,633,-1,2,3136,-1,1,0x4,640,
-1,2,3148,-1,3,1307,2,3164,-1,1,
0x2000,654,-1,2,3169,-1,1,0x4001,659,-1,
2,3176,-1,3,1340,2,3301,-1,1,0x2000,
673,-1,2,3306,-1,1,0x4001,678,-1,2,
3313,-1,1,0x4,685,-1,2,4266,-1,3,
1369,2,3397,-1,1,0x2000,699,-1,2,3402,
-1,1,0x4001,704,-1,2,3409,-1,1,0x4,
711,-1,2,4278,-1,1,0x4001,692,0x4002,718,
-1,2,4285,-1,1,0x4,666,0x6,725,-1,
2,3183,-1,1,0x4001,647,0x4002,734,-1,2,
3192,-1,3,1398,2,3086,-1,3,1425,2,
4031,-1,1,0x2000,757,-1,2,4036,-1,1,
0x4001,762,-1,2,4045,-1,1,0x6,743,0x2000,
752,0x4,769,-1,2,3262,-1,1,0x4001,619,
0x4002,776,-1,2,3273,-1,3,1436,2,3516,
-1,3,1471,2,3521,-1,1,0x2000,801,-1,
2,3526,-1,3,1498,2,3857,-1,1,0x2000,
813,-1,2,3867,-1,1,0x4001,818,-1,2,
3876,-1,1,0x4,825,-1,2,3538,-1,3,
1529,2,3545,-1,1,0x2000,839,-1,2,3550,
-1,1,0x4001,844,-1,2,3557,-1,1,0x4,
851,-1,2,3564,-1,3,1554,2,3571,-1,
1,0x2000,865,-1,2,3576,-1,1,0x4001,870,
-1,2,3583,-1,1,0x4,877,-1,2,3590,
-1,1,0x4001,858,0x4002,884,-1,2,3597,-1,
1,0x6,891,-1,2,3606,-1,1,0x4001,832,
0x4002,900,-1,2,3613,-1,3,1579,2,4487,
-1,1,0x2000,916,-1,2,4492,-1,1,0x4001,
921,-1,2,4501,-1,1,0x5,907,0x4,928,
-1,2,3627,-1,3,1592,2,4648,-1,1,
0x2000,944,-1,2,4653,-1,1,0x4001,949,-1,
2,4660,-1,1,0x4,956,-1,2,3641,-1,
1,0x4001,806,0x4002,935,0x4003,963,-1,2,3648,
-1,3,1605,2,3659,-1,1,0x2000,981,-1,
2,3664,-1,3,1628,2,3676,-1,1,0x2000,
993,-1,2,3681,-1,1,0x4001,998,-1,2,
3688,-1,3,1639,2,3671,-1,1,0x4,1005,
0x2000,1012,-1,2,3695,-1,1,0x4001,986,0x4002,
1017,-1,2,3704,-1,1,0x6,567,0x4,588,
0x5,787,0x2000,796,0xf,970,0x7,1026,-1,2,
3713,-1,1,0x4001,411,0x4002,1035,-1,2,3728,
-1,3,1654,2,3849,-1,3,1701,2,3888,
-1,1,0x2000,1066,-1,2,3893,-1,1,0x4001,
1071,-1,2,3900,-1,1,0x4,1078,-1,2,
3907,-1,3,1752,2,3921,-1,1,0x2000,1092,
-1,2,3926,-1,1,0x4001,1097,-1,2,3933,
-1,3,1807,2,3916,-1,1,0x4,1104,0x2000,
1111,-1,2,3940,-1,3,1856,2,3949,-1,
3,1893,2,3954,-1,1,0x2000,1130,-1,2,
3959,-1,1,0x4001,1135,-1,2,3966,-1,1,
0x2000,1125,0x4,1142,-1,2,3973,-1,1,0x4001,
1116,0x4002,1149,-1,2,3982,-1,1,0x5,1158,
-1,2,3991,-1,1,0x4001,1085,0x4002,1167,-1,
2,3998,-1,3,1916,2,3857,-1,1,0x2000,
1183,-1,2,3867,-1,1,0x4001,1188,-1,2,
3876,-1,1,0x2000,1061,0x5,1174,0x4,1195,-1,
2,4007,-1,3,1995,2,4021,-1,3,2026,
2,4052,-1,3,2083,2,4057,-1,1,0x2000,
1223,-1,2,4062,-1,1,0x4001,1228,-1,2,
4069,-1,1,0x2000,1218,0x4,1235,-1,2,4076,
-1,3,2136,2,4085,-1,3,2169,2,4090,
-1,3,2230,2,4095,-1,1,0x2000,1261,-1,
2,4100,-1,1,0x4001,1266,-1,2,4107,-1,
1,0x2000,1256,0x4,1273,-1,2,4114,-1,3,
2259,2,4142,-1,3,2310,2,3301,-1,1,
0x2000,1294,-1,2,3306,-1,1,0x4001,1299,-1,
2,3313,-1,1,0x4,1306,-1,2,4266,-1,
3,2339,2,3397,-1,1,0x2000,1320,-1,2,
3402,-1,1,0x4001,1325,-1,2,3409,-1,1,
0x4,1332,-1,2,4278,-1,1,0x4001,1313,0x4002,
1339,-1,2,4285,-1,3,2368,2,4123,-1,
1,0x2000,1355,-1,2,4128,-1,1,0x4001,1360,
-1,2,4135,-1,1,0x2000,1289,0x6,1346,0x4,
1367,-1,2,4147,-1,1,0x4001,1280,0x4002,1374,
-1,2,4156,-1,3,2395,2,4057,-1,1,
0x2000,1394,-1,2,4062,-1,1,0x4001,1399,-1,
2,4069,-1,1,0x4,1406,-1,2,4076,-1,
3,2434,2,4095,-1,1,0x2000,1420,-1,2,
4100,-1,1,0x4001,1425,-1,2,4107,-1,1,
0x4,1432,-1,2,4114,-1,3,2459,2,4123,
-1,1,0x2000,1446,-1,2,4128,-1,1,0x4001,
1451,-1,2,4135,-1,1,0x4,1458,-1,2,
4147,-1,1,0x4001,1439,0x4002,1465,-1,2,4156,
-1,1,0x6,1472,-1,2,4184,-1,1,0x4001,
1413,0x4002,1481,-1,2,4195,-1,3,2484,2,
4165,-1,1,0x2000,1497,-1,2,4170,-1,1,
0x4001,1502,-1,2,4177,-1,1,0x2000,1251,0x6,
1385,0x5,1488,0x4,1509,-1,2,4184,-1,1,
0x4001,1242,0x4002,1516,-1,2,4195,-1,3,2497,
2,4204,-1,1,0x2000,1538,-1,2,4209,-1,
1,0x4001,1543,-1,2,4216,-1,3,2530,2,
2637,-1,3,2597,2,2642,-1,1,0x2000,1562,
-1,2,2647,-1,1,0x4001,1567,-1,2,2654,
-1,1,0x2000,1557,0x4,1574,-1,2,2661,-1,
3,2658,2,2802,-1,1,0x2000,1590,-1,2,
2807,-1,1,0x4001,1595,-1,2,2814,-1,1,
0x4,1602,-1,2,2826,-1,3,2683,2,2842,
-1,1,0x2000,1616,-1,2,2847,-1,1,0x4001,
1621,-1,2,2854,-1,1,0x4,1628,-1,2,
2861,-1,1,0x4001,1609,0x4002,1635,-1,2,2870,
-1,3,2710,2,2675,-1,1,0x2000,1651,-1,
2,2680,-1,1,0x4001,1656,-1,2,2687,-1,
1,0x6,1642,0x4,1663,-1,2,2879,-1,1,
0x4001,1581,0x4002,1670,-1,2,2892,-1,3,2733,
2,4223,-1,1,0x4,1550,0x5,1679,0x2000,1688,
-1,2,4228,-1,3,2784,2,3301,-1,1,
0x2000,1704,-1,2,3306,-1,1,0x4001,1709,-1,
2,3313,-1,3,2813,2,4261,-1,1,0x4,
1716,0x2000,1723,-1,2,4266,-1,3,2880,2,
3397,-1,1,0x2000,1737,-1,2,3402,-1,1,
0x4001,1742,-1,2,3409,-1,3,2911,2,4273,
-1,1,0x4,1749,0x2000,1756,-1,2,4278,-1,
1,0x4001,1728,0x4002,1761,-1,2,4285,-1,3,
2958,2,3072,-1,1,0x2000,1779,-1,2,3077,
-1,3,3009,2,3124,-1,1,0x2000,1791,-1,
2,3129,-1,1,0x4001,1796,-1,2,3136,-1,
1,0x4,1803,-1,2,3148,-1,3,3034,2,
3164,-1,1,0x2000,1817,-1,2,3169,-1,1,
0x4001,1822,-1,2,3176,-1,1,0x4,1829,-1,
2,3183,-1,1,0x4001,1810,0x4002,1836,-1,2,
3192,-1,1,0x6,1843,-1,2,3262,-1,1,
0x4001,1784,0x4002,1852,-1,2,3273,-1,3,3061,
2,4237,-1,1,0x2000,1868,-1,2,4242,-1,
1,0x4001,1873,-1,2,4249,-1,3,3090,2,
4256,-1,1,0x6,1770,0x5,1859,0x4,1880,0x2000,
1887,-1,2,4294,-1,1,0x4001,1693,0x4002,1892,
-1,2,4305,-1,3,3127,2,4031,-1,1,
0x2000,1914,-1,2,4036,-1,1,0x4001,1919,-1,
2,4045,-1,3,3140,2,4314,-1,1,0x2000,
1933,-1,2,4319,-1,3,3163,2,4331,-1,
1,0x2000,1945,-1,2,4336,-1,1,0x4001,1950,
-1,2,4343,-1,3,3174,2,4326,-1,1,
0x4,1957,0x2000,1964,-1,2,4350,-1,1,0x4001,
1938,0x4002,1969,-1,2,4359,-1,3,3189,2,
4368,-1,1,0x2000,1987,-1,2,4373,-1,3,
3212,2,4487,-1,1,0x2000,1999,-1,2,4492,
-1,1,0x4001,2004,-1,2,4501,-1,1,0x4,
2011,-1,2,4385,-1,3,3225,2,4648,-1,
1,0x2000,2025,-1,2,4653,-1,1,0x4001,2030,
-1,2,4660,-1,1,0x4,2037,-1,2,4397,
-1,1,0x4001,1992,0x4002,2018,0x4003,2044,-1,2,
4404,-1,1,0x2000,1213,0x5,1529,0x6,1905,0x4,
1926,0x7,1978,0xf,2051,-1,2,4415,-1,1,
0x4001,1202,0x4002,2062,-1,2,4432,-1,3,3236,
2,2498,-1,1,0x2000,2088,-1,2,2506,-1,
3,3261,2,2920,-1,3,3296,2,2901,-1,
1,0x2000,2105,-1,2,2906,-1,1,0x4001,2110,
-1,2,2913,-1,1,0x2000,2100,0x4,2117,-1,
2,3042,-1,3,3309,2,3282,-1,1,0x2000,
2133,-1,2,3287,-1,1,0x4001,2138,-1,2,
3294,-1,3,3328,2,3516,-1,1,0x4,2145,
0x2000,2152,-1,2,3713,-1,1,0x4001,2124,0x4002,
2157,-1,2,3728,-1,3,3351,2,2600,-1,
1,0x2000,2175,-1,2,2605,-1,1,0x4001,2180,
-1,2,2612,-1,3,3360,2,2517,-1,1,
0x6,2166,0x4,2187,0x2000,2194,-1,2,2619,-1,
1,0x4001,2093,0x4002,2199,-1,2,2630,-1,3,
3373,2,4468,-1,1,0x2000,2219,-1,2,4473,
-1,3,3402,2,4487,-1,1,0x2000,2231,-1,
2,4492,-1,1,0x4001,2236,-1,2,4501,-1,
3,3417,2,4565,-1,3,3430,2,4508,-1,
1,0x2000,2255,-1,2,4518,-1,3,3455,2,
4487,-1,1,0x2000,2267,-1,2,4492,-1,1,
0x4001,2272,-1,2,4501,-1,1,0x4,2279,-1,
2,4532,-1,3,3468,2,4648,-1,1,0x2000,
2293,-1,2,4653,-1,1,0x4001,2298,-1,2,
4660,-1,1,0x4,2305,-1,2,4544,-1,1,
0x4001,2260,0x4002,2286,0x4003,2312,-1,2,4551,-1,
1,0x4,2243,0x2000,2250,0xf,2319,-1,2,4570,
-1,3,3479,2,4648,-1,1,0x2000,2341,-1,
2,4653,-1,1,0x4001,2346,-1,2,4660,-1,
3,3492,2,4640,-1,3,3505,2,4586,-1,
1,0x2000,2365,-1,2,4596,-1,3,3530,2,
4487,-1,1,0x2000,2377,-1,2,4492,-1,1,
0x4001,2382,-1,2,4501,-1,1,0x4,2389,-1,
2,4610,-1,3,3543,2,4648,-1,1,0x2000,
2403,-1,2,4653,-1,1,0x4001,2408,-1,2,
4660,-1,1,0x4,2415,-1,2,4622,-1,1,
0x4001,2370,0x4002,2396,0x4003,2422,-1,2,4629,-1,
1,0x4,2353,0x2000,2360,0xf,2429,-1,2,4667,
-1,1,0x4001,2224,0x4002,2330,0x4003,2440,-1,2,
4680,-1,1,0x0,18,0x1,23,0x4,40,0x2000,
47,0x2001,52,0x6,1052,0x5,2079,0x7,2210,0xf,
2451,-1,-1,1,0x4001,2462,-1,-1,3,3554,
2,12,-1,3,3559,2,15,-1,3,3564,
2,3,-1,3,3579,-1,1,0x0,2488,0x1,
2493,0x2000,2498,0x2001,2503,-1,-1,3,3582,2,
3,-1,3,3593,-1,3,3596,2,3857,-1,
1,0x2000,2525,-1,2,3867,-1,1,0x4001,2530,
-1,2,3876,-1,3,3629,2,3849,-1,1,
0x4,2537,0x2000,2544,-1,2,4007,-1,3,3664,
2,4021,-1,3,3685,2,4031,-1,1,0x2000,
2563,-1,2,4036,-1,1,0x4001,2568,-1,2,
4045,-1,1,0x2000,2558,0x4,2575,-1,2,4415,
-1,1,0x4001,2549,0x4002,2582,-1,2,4432,-1,
3,3696,2,47,-1,1,0x2000,2600,-1,2,
2462,-1,1,0x4001,2605,-1,2,2483,-1,1,
0x2000,2517,0x2001,2522,0x5,2591,0x4,2612,-1,-1,
1,0x4001,2506,0x4002,2619,-1,-1,3,3703,2,
3849,-1,3,3768,2,3857,-1,1,0x2000,2642,
-1,2,3867,-1,1,0x4001,2647,-1,2,3876,
-1,1,0x2000,2637,0x4,2654,-1,2,4007,-1,
3,3827,2,4021,-1,3,3872,2,4031,-1,
1,0x2000,2675,-1,2,4036,-1,1,0x4001,2680,
-1,2,4045,-1,3,3893,2,4052,-1,3,
3944,2,4057,-1,1,0x2000,2699,-1,2,4062,
-1,1,0x4001,2704,-1,2,4069,-1,1,0x2000,
2694,0x4,2711,-1,2,4076,-1,3,3987,2,
4085,-1,3,4022,2,4165,-1,1,0x2000,2732,
-1,2,4170,-1,1,0x4001,2737,-1,2,4177,
-1,1,0x2000,2727,0x4,2744,-1,2,4184,-1,
1,0x4001,2718,0x4002,2751,-1,2,4195,-1,3,
4037,2,2637,-1,1,0x2000,2769,-1,2,2661,
-1,3,4104,2,2670,-1,1,0x2000,2781,-1,
2,2879,-1,1,0x4001,2774,0x4002,2786,-1,2,
2892,-1,3,4151,2,4204,-1,1,0x2000,2802,
-1,2,4209,-1,1,0x4001,2807,-1,2,4216,
-1,3,4174,2,4223,-1,1,0x5,2793,0x4,
2814,0x2000,2821,-1,2,4228,-1,3,4221,2,
4256,-1,3,4258,2,4237,-1,1,0x2000,2842,
-1,2,4242,-1,1,0x4001,2847,-1,2,4249,
-1,1,0x2000,2837,0x4,2854,-1,2,4294,-1,
1,0x4001,2826,0x4002,2861,-1,2,4305,-1,1,
0x2000,2670,0x4,2687,0x5,2760,0x6,2870,-1,2,
4415,-1,1,0x4001,2661,0x4002,2879,-1,2,4432,
-1,3,4283,2,47,-1,1,0x2000,2901,-1,
2,2462,-1,1,0x4001,2906,-1,2,2483,-1,
3,4294,2,3,-1,3,4325,2,2920,-1,
1,0x2000,2925,-1,2,3042,-1,3,4358,2,
3301,-1,1,0x2000,2937,-1,2,3306,-1,1,
0x4001,2942,-1,2,3313,-1,1,0x4,2949,-1,
2,3386,-1,3,4387,2,3416,-1,1,0x2000,
2963,-1,2,3421,-1,1,0x4001,2968,-1,2,
3428,-1,1,0x4,2975,-1,2,3440,-1,3,
4422,2,3449,-1,1,0x2000,2989,-1,2,3473,
-1,1,0x4001,2982,0x4002,2994,-1,2,3482,-1,
1,0x6,3001,-1,2,3496,-1,1,0x4001,2956,
0x4002,3010,-1,2,3507,-1,1,0x6,3017,-1,
2,3713,-1,1,0x4001,2930,0x4002,3026,-1,2,
3728,-1,1,0x5,2892,0x4,2913,0x2000,2920,0x6,
3033,-1,-1,3,4473,2,3857,-1,1,0x2000,
3053,-1,2,3867,-1,1,0x4001,3058,-1,2,
3876,-1,3,4506,2,3849,-1,1,0x4,3065,
0x2000,3072,-1,2,4007,-1,3,4555,2,4021,
-1,3,4578,2,2637,-1,1,0x2000,3091,-1,
2,2661,-1,3,4645,2,2670,-1,1,0x2000,
3103,-1,2,2879,-1,1,0x4001,3096,0x4002,3108,
-1,2,2892,-1,3,4692,2,4204,-1,1,
0x2000,3124,-1,2,4209,-1,1,0x4001,3129,-1,
2,4216,-1,3,4715,2,4223,-1,1,0x5,
3115,0x4,3136,0x2000,3143,-1,2,4228,-1,3,
4766,2,4256,-1,3,4807,2,4237,-1,1,
0x2000,3164,-1,2,4242,-1,1,0x4001,3169,-1,
2,4249,-1,1,0x2000,3159,0x4,3176,-1,2,
4294,-1,1,0x4001,3148,0x4002,3183,-1,2,4305,
-1,3,4832,2,4052,-1,1,0x2000,3201,-1,
2,4076,-1,3,4877,2,4090,-1,1,0x2000,
3213,-1,2,4114,-1,3,4928,2,4142,-1,
1,0x2000,3225,-1,2,4147,-1,1,0x4001,3218,
0x4002,3230,-1,2,4156,-1,1,0x6,3237,-1,
2,4184,-1,1,0x4001,3206,0x4002,3246,-1,2,
4195,-1,1,0x2000,3086,0x6,3192,0x5,3253,-1,
2,4415,-1,1,0x4001,3077,0x4002,3262,-1,2,
4432,-1,3,4969,2,47,-1,1,0x2000,3282,
-1,2,2462,-1,1,0x4001,3287,-1,2,2483,
-1,3,4984,2,2901,-1,1,0x2000,3301,-1,
2,2906,-1,1,0x4001,3306,-1,2,2913,-1,
3,5011,2,2920,-1,3,5066,2,2642,-1,
1,0x2000,3325,-1,2,2647,-1,1,0x4001,3330,
-1,2,2654,-1,1,0x4,3337,-1,2,2661,
-1,3,5127,2,2675,-1,1,0x2000,3351,-1,
2,2680,-1,1,0x4001,3356,-1,2,2687,-1,
1,0x4,3363,-1,2,2879,-1,1,0x4001,3344,
0x4002,3370,-1,2,2892,-1,1,0x4,3313,0x2000,
3320,0x5,3377,-1,2,3042,-1,3,5150,2,
3282,-1,1,0x2000,3397,-1,2,3287,-1,1,
0x4001,3402,-1,2,3294,-1,3,5177,2,3301,
-1,1,0x2000,3416,-1,2,3306,-1,1,0x4001,
3421,-1,2,3313,-1,3,5210,2,3320,-1,
1,0x4,3428,0x2000,3435,-1,2,3386,-1,3,
5273,2,3491,-1,3,5322,2,3397,-1,1,
0x2000,3454,-1,2,3402,-1,1,0x4001,3459,-1,
2,3409,-1,1,0x2000,3449,0x4,3466,-1,2,
3496,-1,1,0x4001,3440,0x4002,3473,-1,2,3507,
-1,3,5351,2,3516,-1,1,0x4,3409,0x6,
3482,0x2000,3491,-1,2,3713,-1,1,0x4001,3386,
0x4002,3496,-1,2,3728,-1,3,5388,2,3,
-1,3,5409,2,4468,-1,1,0x2000,3521,-1,
2,4473,-1,3,5432,2,3849,-1,1,0x2000,
3533,-1,2,4007,-1,3,5467,2,4204,-1,
1,0x2000,3545,-1,2,4209,-1,1,0x4001,3550,
-1,2,4216,-1,1,0x4,3557,-1,2,4228,
-1,3,5490,2,4237,-1,1,0x2000,3571,-1,
2,4242,-1,1,0x4001,3576,-1,2,4249,-1,
1,0x4,3583,-1,2,4294,-1,1,0x4001,3564,
0x4002,3590,-1,2,4305,-1,1,0x6,3597,-1,
2,4415,-1,1,0x4001,3538,0x4002,3606,-1,2,
4432,-1,3,5513,2,4565,-1,1,0x5,3613,
0x2000,3622,-1,2,4570,-1,3,5524,2,4640,
-1,1,0x2000,3636,-1,2,4667,-1,1,0x4001,
3526,0x4002,3627,0x4003,3641,-1,2,4680,-1,3,
5537,2,2498,-1,1,0x2000,3659,-1,2,2506,
-1,3,5556,2,2517,-1,3,5569,2,2600,
-1,1,0x2000,3676,-1,2,2605,-1,1,0x4001,
3681,-1,2,2612,-1,1,0x2000,3671,0x4,3688,
-1,2,2619,-1,1,0x4001,3664,0x4002,3695,-1,
2,2630,-1,1,0x5,3273,0x4,3294,0x6,3507,
0x2000,3516,0xf,3648,0x7,3704,-1,-1,1,0x4001,
3042,0x4002,3713,-1,-1,3,5578,2,3,-1,
1,0x2000,3735,-1,-1,1,0x4001,3740,-1,-1,
3,5583,2,3,-1,1,0x2000,3750,-1,-1,
1,0x4001,3755,-1,-1,3,5588,2,3,-1,
1,0x2000,3765,-1,-1,1,0x4001,3770,-1,-1,
3,5593,2,3,-1,1,0x2000,3780,-1,-1,
3,5598,2,3,-1,1,0x2000,3790,-1,-1,
1,0x4001,3785,0x4002,3795,-1,-1,3,5603,2,
3,-1,1,0x2000,3807,-1,-1,3,5608,2,
3,-1,1,0x2000,3817,-1,-1,1,0x4001,3812,
0x4002,3822,-1,-1,3,5613,2,3,-1,1,
0x2000,3834,-1,-1,1,0x4001,3839,-1,-1,3,
5618,2,3,-1,3,5651,-1,3,5654,2,
47,-1,3,5683,2,52,-1,1,0x2000,3857,
0x2001,3862,-1,2,2462,-1,1,0x4001,3867,-1,
2,2483,-1,3,5688,2,3849,-1,3,5723,
2,3857,-1,1,0x2000,3888,-1,2,3867,-1,
1,0x4001,3893,-1,2,3876,-1,1,0x2000,3883,
0x4,3900,-1,2,4007,-1,3,5760,2,4052,
-1,3,5807,2,4057,-1,1,0x2000,3921,-1,
2,4062,-1,1,0x4001,3926,-1,2,4069,-1,
1,0x2000,3916,0x4,3933,-1,2,4076,-1,3,
5850,2,4085,-1,3,5883,2,4165,-1,1,
0x2000,3954,-1,2,4170,-1,1,0x4001,3959,-1,
2,4177,-1,1,0x2000,3949,0x4,3966,-1,2,
4184,-1,1,0x4001,3940,0x4002,3973,-1,2,4195,
-1,1,0x5,3982,-1,2,4415,-1,1,0x4001,
3907,0x4002,3991,-1,2,4432,-1,1,0x2000,3849,
0x2001,3854,0x4,3876,0x5,3998,-1,-1,3,5896,
-1,3,5899,2,3,-1,3,5916,2,52,
-1,3,5921,2,47,-1,1,0x2001,4026,0x2000,
4031,-1,2,2462,-1,1,0x4001,4036,-1,2,
2483,-1,3,5930,2,3849,-1,3,5973,2,
3857,-1,1,0x2000,4057,-1,2,3867,-1,1,
0x4001,4062,-1,2,3876,-1,1,0x2000,4052,0x4,
4069,-1,2,4007,-1,3,6010,2,4021,-1,
3,6035,2,4223,-1,3,6084,2,4204,-1,
1,0x2000,4095,-1,2,4209,-1,1,0x4001,4100,
-1,2,4216,-1,1,0x2000,4090,0x4,4107,-1,
2,4228,-1,3,6107,2,4237,-1,1,0x2000,
4123,-1,2,4242,-1,1,0x4001,4128,-1,2,
4249,-1,3,6130,2,4256,-1,1,0x4,4135,
0x2000,4142,-1,2,4294,-1,1,0x4001,4114,0x4002,
4147,-1,2,4305,-1,3,6169,2,4031,-1,
1,0x2000,4165,-1,2,4036,-1,1,0x4001,4170,
-1,2,4045,-1,1,0x2000,4085,0x6,4156,0x4,
4177,-1,2,4415,-1,1,0x4001,4076,0x4002,4184,
-1,2,4432,-1,3,6180,2,2901,-1,1,
0x2000,4204,-1,2,2906,-1,1,0x4001,4209,-1,
2,2913,-1,3,6201,2,2920,-1,1,0x4,
4216,0x2000,4223,-1,2,3042,-1,3,6244,2,
3282,-1,1,0x2000,4237,-1,2,3287,-1,1,
0x4001,4242,-1,2,3294,-1,3,6265,2,3516,
-1,3,6298,2,3320,-1,1,0x2000,4261,-1,
2,3386,-1,3,6357,2,3491,-1,1,0x2000,
4273,-1,2,3496,-1,1,0x4001,4266,0x4002,4278,
-1,2,3507,-1,1,0x4,4249,0x2000,4256,0x6,
4285,-1,2,3713,-1,1,0x4001,4228,0x4002,4294,
-1,2,3728,-1,3,6398,2,2498,-1,1,
0x2000,4314,-1,2,2506,-1,3,6417,2,2517,
-1,3,6430,2,2600,-1,1,0x2000,4331,-1,
2,2605,-1,1,0x4001,4336,-1,2,2612,-1,
1,0x2000,4326,0x4,4343,-1,2,2619,-1,1,
0x4001,4319,0x4002,4350,-1,2,2630,-1,3,6439,
2,4468,-1,1,0x2000,4368,-1,2,4473,-1,
3,6460,2,4565,-1,1,0x2000,4380,-1,2,
4570,-1,3,6471,2,4640,-1,1,0x2000,4392,
-1,2,4667,-1,1,0x4001,4373,0x4002,4385,0x4003,
4397,-1,2,4680,-1,1,0x2001,4018,0x2000,4021,
0x4,4045,0x5,4195,0x6,4305,0x7,4359,0xf,4404,
-1,-1,1,0x4001,4007,0x4002,4415,-1,-1,3,
6482,2,47,-1,3,6489,2,52,-1,1,
0x2000,4439,0x2001,4444,-1,2,2462,-1,1,0x4001,
4449,-1,2,2483,-1,3,6494,-1,3,6497,
2,3,-1,1,0x4,4458,0x2001,4465,0x2000,4468,
-1,-1,3,6516,2,52,-1,3,6521,2,
47,-1,1,0x2001,4482,0x2000,4487,-1,2,2462,
-1,1,0x4001,4492,-1,2,2483,-1,3,6532,
2,4468,-1,3,6555,2,4465,-1,1,0x2000,
4508,0x2001,4513,-1,2,4473,-1,3,6560,2,
4565,-1,1,0x2000,4527,-1,2,4570,-1,3,
6575,2,4640,-1,1,0x2000,4539,-1,2,4667,
-1,1,0x4001,4518,0x4002,4532,0x4003,4544,-1,2,
4680,-1,3,6590,-1,3,6593,2,3,-1,
1,0x4,4501,0xf,4551,0x2001,4562,0x2000,4565,-1,
-1,3,6602,2,15,-1,3,6609,2,4468,
-1,3,6632,2,4465,-1,1,0x2000,4586,0x2001,
4591,-1,2,4473,-1,3,6637,2,4565,-1,
1,0x2000,4605,-1,2,4570,-1,3,6652,2,
4640,-1,1,0x2000,4617,-1,2,4667,-1,1,
0x4001,4596,0x4002,4610,0x4003,4622,-1,2,4680,-1,
3,6667,2,3,-1,3,6676,-1,3,6679,
2,47,-1,1,0x2000,4648,-1,2,2462,-1,
1,0x4001,4653,-1,2,2483,-1,1,0x1,4581,
0xf,4629,0x2000,4640,0x2001,4645,0x4,4660,-1,-1,
1,0x4001,4473,0x4002,4570,0x4003,4667,-1,-1,3,
6688,2,6,-1,3,6699,2,3,-1,3,
6726,2,47,-1,1,0x2000,4699,-1,2,2462,
-1,1,0x4001,4704,-1,2,2483,-1,3,6743,
2,3849,-1,3,6782,2,3857,-1,1,0x2000,
4723,-1,2,3867,-1,1,0x4001,4728,-1,2,
3876,-1,1,0x2000,4718,0x4,4735,-1,2,4007,
-1,3,6815,2,4021,-1,1,0x2000,4751,-1,
2,4415,-1,1,0x4001,4742,0x4002,4756,-1,2,
4432,-1,3,6842,2,2920,-1,1,0x2000,4772,
-1,2,3042,-1,3,6875,2,3516,-1,1,
0x2000,4784,-1,2,3713,-1,1,0x4001,4777,0x4002,
4789,-1,2,3728,-1,3,6898,2,4468,-1,
1,0x2000,4805,-1,2,4473,-1,3,6929,2,
4565,-1,3,6948,2,4508,-1,1,0x2000,4822,
-1,2,4518,-1,3,6973,2,4527,-1,1,
0x2000,4834,-1,2,4532,-1,3,6990,2,4539,
-1,1,0x2000,4846,-1,2,4544,-1,1,0x4001,
4827,0x4002,4839,0x4003,4851,-1,2,4551,-1,1,
0x2000,4817,0xf,4858,-1,2,4570,-1,3,7007,
2,4640,-1,3,7026,2,4586,-1,1,0x2000,
4883,-1,2,4596,-1,3,7051,2,4605,-1,
1,0x2000,4895,-1,2,4610,-1,3,7068,2,
4617,-1,1,0x2000,4907,-1,2,4622,-1,1,
0x4001,4888,0x4002,4900,0x4003,4912,-1,2,4629,-1,
1,0x2000,4878,0xf,4919,-1,2,4667,-1,1,
0x4001,4810,0x4002,4869,0x4003,4930,-1,2,4680,-1,
1,0x2002,4689,0x2000,4694,0x4,4711,0x5,4763,0x6,
4796,0xf,4939,-1,-1,3,7085,-1,3,7136,
2,52,-1,1,0x2001,4968,-1,2,2462,-1,
1,0x4001,4973,-1,2,2483,-1,1,0x2001,4965,
0x4,4980,-1,-1,3,7157,2,15,-1,3,
7216,2,3,-1,3,7225,2,47,-1,1,
0x2000,5004,-1,2,2462,-1,1,0x4001,5009,-1,
2,2483,-1,1,0x1,4994,0x2000,4999,0x4,5016,
-1,-1,3,7236,2,12,-1,3,7281,2,
47,-1,1,0x2000,5037,-1,2,2462,-1,1,
0x4001,5042,-1,2,2483,-1,3,7304,2,3,
-1,1,0x0,5032,0x4,5049,0x2000,5056,-1,-1,
3,7315,2,12,-1,3,7362,2,3,-1,
3,7385,2,47,-1,1,0x2000,5080,-1,2,
2462,-1,1,0x4001,5085,-1,2,2483,-1,1,
0x0,5070,0x2000,5075,0x4,5092,-1,-1,1,0x4001,
4950,0x4002,4987,0x4003,5023,0x4004,5061,0x4005,5099,-1,
-1,3,7394,2,6,-1,3,7401,2,3,
-1,3,7420,2,4468,-1,1,0x2000,5131,-1,
2,4473,-1,3,7445,2,4565,-1,1,0x2000,
5143,-1,2,4570,-1,3,7460,2,4640,-1,
1,0x2000,5155,-1,2,4667,-1,1,0x4001,5136,
0x4002,5148,0x4003,5160,-1,2,4680,-1,1,0x2002,
5121,0x2000,5126,0xf,5167,-1,-1,3,7475,-1,
3,7488,2,52,-1,1,0x2001,5190,-1,2,
2462,-1,1,0x4001,5195,-1,2,2483,-1,1,
0x2001,5187,0x4,5202,-1,-1,3,7505,2,15,
-1,3,7524,2,3,-1,3,7531,2,47,
-1,1,0x2000,5226,-1,2,2462,-1,1,0x4001,
5231,-1,2,2483,-1,1,0x1,5216,0x2000,5221,
0x4,5238,-1,-1,3,7542,2,12,-1,3,
7567,2,47,-1,1,0x2000,5259,-1,2,2462,
-1,1,0x4001,5264,-1,2,2483,-1,1,0x0,
5254,0x4,5271,-1,-1,1,0x4001,5178,0x4002,5209,
0x4003,5245,0x4004,5278,-1,-1,1,0x3,0,0x2000,
3,0x2002,6,0x2,9,0x0,12,0x1,15,0x4,
2483,0x7,2630,0x6,3728,0xa,3745,0x10,3760,0xb,
3775,0xc,3800,0xd,3827,0xe,3844,0x5,4432,0xf,
4680,0x8,5108,0x9,5285,-1,-1,};
short mtAccept[] = {
0,0,-1,1,0,-1,2,0,-1,3,
0,-1,4,0,-1,5,0,-1,4,0,
6,1,-1,5,0,7,1,-1,17,1,
1,0,8,2,-1,1,0,17,1,-1,
19,1,-1,85,2,87,2,203,2,1,
0,17,1,212,3,172,3,170,3,156,
3,154,3,144,3,142,3,140,3,132,
3,130,3,82,3,80,3,-1,85,2,
87,2,203,2,1,0,17,1,84,4,
-1,107,2,111,2,147,2,157,2,191,
2,193,2,195,2,197,2,199,2,201,
2,203,2,243,2,1,0,237,1,213,
1,201,1,167,1,165,1,159,1,157,
1,151,1,149,1,147,1,137,1,135,
1,91,1,89,1,84,4,-1,111,3,
157,3,159,3,203,3,89,1,91,1,
135,1,137,1,147,1,149,1,151,1,
157,1,159,1,165,1,167,1,201,1,
213,1,237,1,1,0,243,2,203,2,
201,2,199,2,197,2,195,2,193,2,
191,2,157,2,147,2,111,2,107,2,
84,5,-1,91,4,85,2,137,2,179,
2,181,2,239,2,1,0,17,1,199,
3,197,3,151,3,123,3,99,3,87,
3,84,6,-1,99,3,105,3,123,3,
177,3,181,3,193,3,195,3,197,3,
199,3,205,3,207,3,209,3,239,3,
241,3,243,3,17,1,1,0,223,2,
221,2,187,2,183,2,145,2,143,2,
141,2,133,2,131,2,117,2,115,2,
24,2,236,4,234,4,232,4,230,4,
228,4,226,4,224,4,222,4,220,4,
218,4,216,4,190,4,188,4,184,4,
128,4,126,4,122,4,120,4,118,4,
114,4,104,4,-1,11,2,101,2,103,
2,107,2,109,2,111,2,113,2,119,
2,125,2,127,2,175,2,179,2,191,
2,215,2,225,2,227,2,1,0,235,
1,233,1,231,1,229,1,219,1,217,
1,211,1,189,1,185,1,171,1,169,
1,139,1,129,1,121,1,20,1,186,
3,116,3,106,3,-1,119,4,85,2,
87,2,203,2,1,0,17,1,235,3,
219,3,185,3,183,3,115,3,128,5,
106,5,104,5,-1,119,4,227,4,85,
2,137,2,179,2,181,2,239,2,1,
0,17,1,223,3,185,3,115,3,128,
5,106,5,104,5,-1,99,3,123,3,
195,3,199,3,239,3,243,3,17,1,
1,0,133,2,25,2,232,4,230,4,
228,4,226,4,222,4,218,4,216,4,
190,4,188,4,114,4,-1,11,2,103,
2,105,2,109,2,111,2,127,2,175,
2,177,2,179,2,181,2,191,2,193,
2,197,2,215,2,1,0,155,1,153,
1,131,1,129,1,81,1,79,1,21,
1,224,3,220,3,186,3,184,3,122,
3,120,3,118,3,116,3,-1,101,3,
107,3,125,3,205,3,20,1,121,1,
129,1,139,1,169,1,171,1,185,1,
189,1,211,1,217,1,219,1,229,1,
231,1,233,1,235,1,1,0,229,2,
141,2,139,2,117,2,83,2,126,4,
-1,207,4,209,4,241,4,24,2,115,
2,117,2,131,2,133,2,141,2,143,
2,145,2,183,2,187,2,221,2,223,
2,1,0,17,1,231,3,145,3,143,
3,121,3,236,5,234,5,-1,101,3,
107,3,125,3,205,3,207,3,21,1,
79,1,81,1,129,1,131,1,153,1,
155,1,1,0,143,2,141,2,139,2,
83,2,236,4,126,4,-1,209,4,241,
4,25,2,133,2,1,0,17,1,145,
3,234,5,-1,89,1,91,1,135,1,
137,1,147,1,149,1,151,1,157,1,
159,1,165,1,167,1,201,1,213,1,
237,1,1,0,146,2,134,2,-1,87,
3,89,3,91,3,99,3,123,3,149,
3,151,3,159,3,17,1,1,0,203,
2,87,2,85,2,232,4,230,4,140,
4,122,4,80,4,-1,107,2,111,2,
147,2,157,2,191,2,193,2,195,2,
197,2,199,2,201,2,203,2,243,2,
1,0,237,1,213,1,201,1,167,1,
165,1,159,1,157,1,151,1,149,1,
147,1,137,1,135,1,91,1,89,1,
156,3,154,3,146,3,144,3,142,3,
118,3,82,3,-1,89,4,91,4,201,
4,85,2,87,2,203,2,1,0,17,
1,159,3,151,3,149,3,123,3,99,
3,91,3,89,3,87,3,82,5,80,
5,-1,111,3,157,3,159,3,203,3,
89,1,91,1,135,1,137,1,147,1,
149,1,151,1,157,1,159,1,165,1,
167,1,201,1,213,1,237,1,1,0,
243,2,203,2,201,2,199,2,197,2,
195,2,193,2,191,2,157,2,147,2,
111,2,107,2,156,4,154,4,-1,91,
4,85,2,137,2,179,2,181,2,239,
2,1,0,17,1,199,3,197,3,151,
3,123,3,99,3,87,3,154,5,82,
5,80,5,-1,89,3,111,3,157,3,
159,3,201,3,203,3,93,1,101,1,
135,1,175,1,177,1,205,1,207,1,
209,1,241,1,1,0,243,2,195,2,
193,2,191,2,149,2,147,2,109,2,
107,2,156,4,-1,87,3,99,3,123,
3,151,3,197,3,199,3,17,1,1,
0,239,2,181,2,179,2,137,2,85,
2,230,4,142,4,140,4,118,4,-1,
107,2,109,2,147,2,149,2,191,2,
193,2,195,2,243,2,1,0,241,1,
209,1,207,1,205,1,177,1,175,1,
135,1,101,1,93,1,232,3,146,3,
144,3,122,3,-1,85,2,137,2,179,
2,181,2,239,2,1,0,17,1,236,
3,234,3,220,3,218,3,190,3,186,
3,130,3,84,3,-1,11,3,119,3,
17,1,1,0,223,2,221,2,187,2,
183,2,145,2,143,2,141,2,133,2,
131,2,117,2,115,2,24,2,228,4,
226,4,216,4,128,4,114,4,106,4,
104,4,-1,103,2,105,2,113,2,127,
2,215,2,225,2,227,2,237,2,1,
0,235,1,233,1,231,1,229,1,219,
1,217,1,211,1,189,1,185,1,171,
1,169,1,139,1,129,1,121,1,20,
1,120,3,-1,119,4,85,2,87,2,
203,2,1,0,17,1,235,3,219,3,
185,3,183,3,115,3,216,5,128,5,
114,5,106,5,104,5,-1,119,4,227,
4,85,2,137,2,179,2,181,2,239,
2,1,0,17,1,223,3,185,3,115,
3,216,5,114,5,106,5,104,5,-1,
87,3,89,3,91,3,99,3,123,3,
149,3,151,3,159,3,17,1,1,0,
203,2,87,2,85,2,128,6,-1,87,
3,99,3,123,3,151,3,197,3,199,
3,17,1,1,0,239,2,181,2,179,
2,137,2,85,2,128,6,-1,11,2,
103,2,105,2,1,0,155,1,153,1,
131,1,129,1,81,1,79,1,21,1,
228,3,120,3,-1,25,2,133,2,1,
0,17,1,226,4,-1,93,1,101,1,
135,1,175,1,177,1,205,1,207,1,
209,1,241,1,1,0,224,2,222,2,
188,2,184,2,134,2,132,2,116,2,
-1,125,2,213,2,1,0,253,1,251,
1,249,1,247,1,245,1,31,1,30,
1,29,1,212,3,126,3,-1,24,2,
115,2,117,2,131,2,133,2,141,2,
143,2,145,2,183,2,187,2,221,2,
223,2,1,0,17,1,126,5,-1,125,
5,85,2,87,2,203,2,1,0,17,
1,235,3,219,3,185,3,183,3,115,
3,126,6,-1,125,5,85,2,137,2,
179,2,181,2,239,2,1,0,17,1,
223,3,185,3,115,3,126,6,-1,23,
2,247,2,251,2,1,0,17,1,212,
4,-1,249,2,251,2,1,0,17,1,
212,4,126,4,-1,165,2,167,2,1,
0,173,1,163,1,161,1,97,1,95,
1,26,1,172,3,170,3,-1,167,3,
17,1,1,0,163,2,170,4,-1,165,
2,1,0,161,1,27,1,10,1,9,
1,172,3,-1,20,1,121,1,129,1,
139,1,169,1,171,1,185,1,189,1,
211,1,217,1,219,1,229,1,231,1,
233,1,235,1,1,0,240,2,182,2,
180,2,124,2,100,2,88,2,86,2,
-1,81,3,83,3,153,3,155,3,17,
1,1,0,223,2,221,2,187,2,183,
2,145,2,143,2,141,2,133,2,131,
2,117,2,115,2,24,2,204,4,202,
4,160,4,158,4,94,4,92,4,90,
4,-1,83,4,153,4,155,4,24,2,
115,2,117,2,131,2,133,2,141,2,
143,2,145,2,183,2,187,2,221,2,
223,2,1,0,17,1,231,3,145,3,
143,3,121,3,204,5,202,5,160,5,
158,5,94,5,90,5,-1,79,3,81,
3,20,1,121,1,129,1,139,1,169,
1,171,1,185,1,189,1,211,1,217,
1,219,1,229,1,231,1,233,1,235,
1,1,0,229,2,141,2,139,2,117,
2,83,2,92,4,-1,79,3,81,3,
83,3,153,3,21,1,79,1,81,1,
129,1,131,1,153,1,155,1,1,0,
143,2,141,2,139,2,83,2,92,4,
90,4,-1,155,4,25,2,133,2,1,
0,17,1,145,3,204,5,202,5,160,
5,158,5,94,5,-1,24,2,115,2,
117,2,131,2,133,2,141,2,143,2,
145,2,183,2,187,2,221,2,223,2,
1,0,17,1,244,3,242,3,238,3,
214,3,210,3,208,3,206,3,200,3,
198,3,196,3,194,3,192,3,178,3,
176,3,168,3,166,3,152,3,150,3,
148,3,138,3,136,3,112,3,110,3,
108,3,102,3,-1,21,1,79,1,81,
1,129,1,131,1,153,1,155,1,1,
0,204,2,202,2,160,2,138,2,92,
2,90,2,86,2,-1,83,2,117,2,
139,2,141,2,229,2,1,0,235,1,
233,1,231,1,229,1,219,1,217,1,
211,1,189,1,185,1,171,1,169,1,
139,1,129,1,121,1,20,1,200,3,
198,3,152,3,124,3,100,3,94,3,
88,3,-1,121,3,143,3,145,3,231,
3,17,1,1,0,223,2,221,2,187,
2,183,2,145,2,143,2,141,2,133,
2,131,2,117,2,115,2,24,2,244,
4,196,4,194,4,192,4,150,4,148,
4,112,4,108,4,-1,83,2,139,2,
141,2,143,2,1,0,155,1,153,1,
131,1,129,1,81,1,79,1,21,1,
152,3,150,3,94,3,88,3,-1,117,
3,229,3,231,3,89,1,91,1,135,
1,137,1,147,1,149,1,151,1,157,
1,159,1,165,1,167,1,201,1,213,
1,237,1,1,0,233,2,223,2,221,
2,217,2,189,2,187,2,244,4,200,
4,198,4,196,4,124,4,100,4,-1,
121,4,85,2,87,2,203,2,1,0,
17,1,235,3,219,3,185,3,183,3,
115,3,194,5,192,5,108,5,-1,121,
3,229,3,231,3,93,1,101,1,135,
1,175,1,177,1,205,1,207,1,209,
1,241,1,1,0,221,2,219,2,217,
2,189,2,187,2,183,2,244,4,200,
4,196,4,194,4,124,4,100,4,-1,
87,3,89,3,91,3,99,3,123,3,
149,3,151,3,159,3,17,1,1,0,
203,2,87,2,85,2,108,6,-1,87,
3,99,3,123,3,151,3,197,3,199,
3,17,1,1,0,239,2,181,2,179,
2,137,2,85,2,108,6,-1,117,4,
85,2,137,2,179,2,181,2,239,2,
1,0,17,1,223,3,185,3,115,3,
198,5,192,5,-1,121,3,143,3,145,
3,231,3,17,1,1,0,223,2,221,
2,187,2,183,2,145,2,143,2,141,
2,133,2,131,2,117,2,115,2,24,
2,112,5,-1,121,4,85,2,87,2,
203,2,1,0,17,1,235,3,219,3,
185,3,183,3,115,3,112,6,-1,117,
4,85,2,137,2,179,2,181,2,239,
2,1,0,17,1,223,3,185,3,115,
3,112,6,-1,145,3,17,1,1,0,
133,2,25,2,148,4,-1,115,3,183,
3,185,3,219,3,235,3,17,1,1,
0,203,2,87,2,85,2,208,4,206,
4,180,4,178,4,176,4,102,4,-1,
11,2,101,2,103,2,107,2,109,2,
111,2,113,2,119,2,125,2,127,2,
175,2,179,2,191,2,215,2,225,2,
227,2,1,0,235,1,233,1,231,1,
229,1,219,1,217,1,211,1,189,1,
185,1,171,1,169,1,139,1,129,1,
121,1,20,1,110,4,-1,99,3,105,
3,123,3,177,3,181,3,193,3,195,
3,197,3,199,3,205,3,207,3,209,
3,239,3,241,3,243,3,17,1,1,
0,223,2,221,2,187,2,183,2,145,
2,143,2,141,2,133,2,131,2,117,
2,115,2,24,2,238,5,-1,119,4,
85,2,87,2,203,2,1,0,17,1,
235,3,219,3,185,3,183,3,115,3,
110,6,-1,119,4,227,4,85,2,137,
2,179,2,181,2,239,2,1,0,17,
1,223,3,185,3,115,3,110,6,-1,
99,3,123,3,195,3,199,3,239,3,
243,3,17,1,1,0,133,2,25,2,
238,5,-1,187,2,189,2,217,2,221,
2,223,2,233,2,1,0,237,1,213,
1,201,1,167,1,165,1,159,1,157,
1,151,1,149,1,147,1,137,1,135,
1,91,1,89,1,242,3,240,3,210,
3,182,3,-1,87,3,89,3,91,3,
99,3,123,3,149,3,151,3,159,3,
17,1,1,0,203,2,87,2,85,2,
102,5,-1,233,3,235,3,89,1,91,
1,135,1,137,1,147,1,149,1,151,
1,157,1,159,1,165,1,167,1,201,
1,213,1,237,1,1,0,243,2,203,
2,201,2,199,2,197,2,195,2,193,
2,191,2,157,2,147,2,111,2,107,
2,242,4,210,4,208,4,206,4,-1,
87,3,99,3,123,3,151,3,197,3,
199,3,17,1,1,0,239,2,181,2,
179,2,137,2,85,2,206,5,102,5,
-1,233,3,235,3,93,1,101,1,135,
1,175,1,177,1,205,1,207,1,209,
1,241,1,1,0,243,2,195,2,193,
2,191,2,149,2,147,2,109,2,107,
2,242,4,210,4,208,4,-1,103,2,
105,2,113,2,127,2,215,2,225,2,
227,2,237,2,1,0,235,1,233,1,
231,1,229,1,219,1,217,1,211,1,
189,1,185,1,171,1,169,1,139,1,
129,1,121,1,20,1,110,4,-1,119,
4,85,2,87,2,203,2,1,0,17,
1,235,3,219,3,185,3,183,3,115,
3,110,6,-1,119,4,227,4,85,2,
137,2,179,2,181,2,239,2,1,0,
17,1,223,3,185,3,115,3,110,6,
-1,115,3,185,3,223,3,17,1,1,
0,239,2,181,2,179,2,137,2,85,
2,238,4,182,4,180,4,176,4,-1,
183,2,187,2,189,2,217,2,219,2,
221,2,1,0,241,1,209,1,207,1,
205,1,177,1,175,1,135,1,101,1,
93,1,240,3,178,3,-1,25,2,133,
2,1,0,17,1,158,3,136,3,-1,
169,2,171,2,1,0,173,1,163,1,
161,1,97,1,95,1,26,1,168,3,
166,3,-1,171,3,17,1,1,0,163,
2,166,4,-1,169,2,1,0,161,1,
27,1,10,1,9,1,168,3,-1,211,
2,1,0,253,1,251,1,249,1,247,
1,245,1,31,1,30,1,29,1,214,
3,-1,23,2,247,2,251,2,1,0,
17,1,214,4,-1,249,2,251,2,1,
0,17,1,214,4,-1,26,1,95,1,
97,1,161,1,163,1,173,1,1,0,
174,2,164,2,162,2,98,2,96,2,
-1,89,1,91,1,135,1,137,1,147,
1,149,1,151,1,157,1,159,1,165,
1,167,1,201,1,213,1,237,1,1,
0,174,3,96,3,-1,85,2,87,2,
203,2,1,0,17,1,98,4,-1,85,
2,137,2,179,2,181,2,239,2,1,
0,17,1,98,4,96,4,-1,93,1,
101,1,135,1,175,1,177,1,205,1,
207,1,209,1,241,1,1,0,174,3,
-1,163,2,1,0,17,1,162,3,-1,
9,1,10,1,27,1,161,1,1,0,
164,2,-1,29,1,30,1,31,1,245,
1,247,1,249,1,251,1,253,1,1,
0,254,2,252,2,250,2,248,2,246,
2,-1,23,2,247,2,251,2,1,0,
17,1,250,3,246,3,-1,31,1,245,
1,249,1,1,0,252,2,248,2,-1,
28,2,253,2,1,0,253,1,251,1,
249,1,247,1,245,1,31,1,30,1,
29,1,254,3,-1,23,2,247,2,251,
2,1,0,17,1,254,4,-1,249,2,
251,2,1,0,17,1,254,4,-1,249,
2,251,2,1,0,17,1,248,3,246,
3,-1,30,1,245,1,247,1,1,0,
252,2,250,2,-1,28,2,253,2,1,
0,253,1,251,1,249,1,247,1,245,
1,31,1,30,1,29,1,254,3,-1,
23,2,247,2,251,2,1,0,17,1,
254,4,-1,249,2,251,2,1,0,17,
1,254,4,-1,4,0,9,1,-1,5,
0,10,1,-1,1,0,173,1,163,1,
161,1,97,1,95,1,26,1,-1,27,
1,-1,1,0,161,1,27,1,10,1,
9,1,-1,26,1,-1,24,2,115,2,
117,2,131,2,133,2,141,2,143,2,
145,2,183,2,187,2,221,2,223,2,
1,0,17,1,173,3,95,3,-1,20,
1,121,1,129,1,139,1,169,1,171,
1,185,1,189,1,211,1,217,1,219,
1,229,1,231,1,233,1,235,1,1,
0,97,2,-1,21,1,79,1,81,1,
129,1,131,1,153,1,155,1,1,0,
97,2,95,2,-1,25,2,133,2,1,
0,17,1,173,3,-1,17,1,1,0,
163,2,-1,20,1,121,1,129,1,139,
1,169,1,171,1,185,1,189,1,211,
1,217,1,219,1,229,1,231,1,233,
1,235,1,1,0,227,2,225,2,215,
2,191,2,179,2,175,2,127,2,125,
2,119,2,113,2,111,2,109,2,107,
2,103,2,101,2,11,2,-1,24,2,
115,2,117,2,131,2,133,2,141,2,
143,2,145,2,183,2,187,2,221,2,
223,2,1,0,17,1,243,3,241,3,
239,3,209,3,207,3,205,3,199,3,
197,3,195,3,193,3,181,3,177,3,
123,3,105,3,99,3,-1,21,1,79,
1,81,1,129,1,131,1,153,1,155,
1,1,0,215,2,197,2,193,2,191,
2,181,2,179,2,177,2,175,2,127,
2,111,2,109,2,105,2,103,2,11,
2,-1,25,2,133,2,1,0,17,1,
243,3,239,3,199,3,195,3,123,3,
99,3,-1,83,2,117,2,139,2,141,
2,229,2,1,0,235,1,233,1,231,
1,229,1,219,1,217,1,211,1,189,
1,185,1,171,1,169,1,139,1,129,
1,121,1,20,1,205,3,125,3,107,
3,101,3,-1,121,3,143,3,145,3,
231,3,17,1,1,0,223,2,221,2,
187,2,183,2,145,2,143,2,141,2,
133,2,131,2,117,2,115,2,24,2,
241,4,209,4,207,4,-1,83,2,139,
2,141,2,143,2,1,0,155,1,153,
1,131,1,129,1,81,1,79,1,21,
1,207,3,205,3,125,3,107,3,101,
3,-1,145,3,17,1,1,0,133,2,
25,2,241,4,209,4,-1,11,2,101,
2,103,2,107,2,109,2,111,2,113,
2,119,2,125,2,127,2,175,2,179,
2,191,2,215,2,225,2,227,2,1,
0,235,1,233,1,231,1,229,1,219,
1,217,1,211,1,189,1,185,1,171,
1,169,1,139,1,129,1,121,1,20,
1,113,4,-1,11,2,103,2,105,2,
109,2,111,2,127,2,175,2,177,2,
179,2,181,2,191,2,193,2,197,2,
215,2,1,0,155,1,153,1,131,1,
129,1,81,1,79,1,21,1,113,4,
-1,115,3,183,3,185,3,219,3,235,
3,17,1,1,0,203,2,87,2,85,
2,119,4,-1,187,2,189,2,217,2,
221,2,223,2,233,2,1,0,237,1,
213,1,201,1,167,1,165,1,159,1,
157,1,151,1,149,1,147,1,137,1,
135,1,91,1,89,1,227,3,225,3,
-1,183,2,187,2,189,2,217,2,219,
2,221,2,1,0,241,1,209,1,207,
1,205,1,177,1,175,1,135,1,101,
1,93,1,225,3,113,3,-1,115,3,
185,3,223,3,17,1,1,0,239,2,
181,2,179,2,137,2,85,2,227,4,
119,4,-1,17,1,1,0,203,2,87,
2,85,2,-1,1,0,237,1,213,1,
201,1,167,1,165,1,159,1,157,1,
151,1,149,1,147,1,137,1,135,1,
91,1,89,1,-1,89,1,91,1,135,
1,137,1,147,1,149,1,151,1,157,
1,159,1,165,1,167,1,201,1,213,
1,237,1,1,0,93,2,-1,87,3,
89,3,91,3,99,3,123,3,149,3,
151,3,159,3,17,1,1,0,203,2,
87,2,85,2,93,4,-1,89,4,91,
4,201,4,85,2,87,2,203,2,1,
0,17,1,159,3,151,3,149,3,123,
3,99,3,91,3,89,3,87,3,93,
5,-1,89,3,111,3,157,3,159,3,
201,3,203,3,93,1,101,1,135,1,
175,1,177,1,205,1,207,1,209,1,
241,1,1,0,243,2,195,2,193,2,
191,2,149,2,147,2,109,2,107,2,
93,4,-1,24,2,115,2,117,2,131,
2,133,2,141,2,143,2,145,2,183,
2,187,2,221,2,223,2,1,0,17,
1,119,3,11,3,-1,20,1,121,1,
129,1,139,1,169,1,171,1,185,1,
189,1,211,1,217,1,219,1,229,1,
231,1,233,1,235,1,1,0,237,2,
227,2,225,2,215,2,127,2,113,2,
105,2,103,2,-1,21,1,79,1,81,
1,129,1,131,1,153,1,155,1,1,
0,105,2,103,2,11,2,-1,11,2,
101,2,103,2,107,2,109,2,111,2,
113,2,119,2,125,2,127,2,175,2,
179,2,191,2,215,2,225,2,227,2,
1,0,235,1,233,1,231,1,229,1,
219,1,217,1,211,1,189,1,185,1,
171,1,169,1,139,1,129,1,121,1,
20,1,113,4,-1,11,2,103,2,105,
2,109,2,111,2,127,2,175,2,177,
2,179,2,181,2,191,2,193,2,197,
2,215,2,1,0,155,1,153,1,131,
1,129,1,81,1,79,1,21,1,113,
4,-1,115,3,183,3,185,3,219,3,
235,3,17,1,1,0,203,2,87,2,
85,2,119,4,-1,187,2,189,2,217,
2,221,2,223,2,233,2,1,0,237,
1,213,1,201,1,167,1,165,1,159,
1,157,1,151,1,149,1,147,1,137,
1,135,1,91,1,89,1,237,3,227,
3,225,3,215,3,-1,183,2,187,2,
189,2,217,2,219,2,221,2,1,0,
241,1,209,1,207,1,205,1,177,1,
175,1,135,1,101,1,93,1,237,3,
225,3,215,3,113,3,-1,115,3,185,
3,223,3,17,1,1,0,239,2,181,
2,179,2,137,2,85,2,227,4,119,
4,-1,83,2,117,2,139,2,141,2,
229,2,1,0,235,1,233,1,231,1,
229,1,219,1,217,1,211,1,189,1,
185,1,171,1,169,1,139,1,129,1,
121,1,20,1,127,3,-1,117,3,229,
3,231,3,89,1,91,1,135,1,137,
1,147,1,149,1,151,1,157,1,159,
1,165,1,167,1,201,1,213,1,237,
1,1,0,233,2,223,2,221,2,217,
2,189,2,187,2,127,4,-1,121,3,
229,3,231,3,93,1,101,1,135,1,
175,1,177,1,205,1,207,1,209,1,
241,1,1,0,221,2,219,2,217,2,
189,2,187,2,183,2,127,4,-1,17,
1,1,0,239,2,181,2,179,2,137,
2,85,2,-1,85,2,87,2,203,2,
1,0,17,1,159,3,151,3,149,3,
123,3,99,3,91,3,89,3,87,3,
-1,89,1,91,1,135,1,137,1,147,
1,149,1,151,1,157,1,159,1,165,
1,167,1,201,1,213,1,237,1,1,
0,243,2,203,2,201,2,199,2,197,
2,195,2,193,2,191,2,157,2,147,
2,111,2,107,2,-1,99,3,105,3,
123,3,177,3,181,3,193,3,195,3,
197,3,199,3,205,3,207,3,209,3,
239,3,241,3,243,3,17,1,1,0,
223,2,221,2,187,2,183,2,145,2,
143,2,141,2,133,2,131,2,117,2,
115,2,24,2,109,4,-1,99,3,123,
3,195,3,199,3,239,3,243,3,17,
1,1,0,133,2,25,2,109,4,-1,
85,2,137,2,179,2,181,2,239,2,
1,0,17,1,199,3,197,3,151,3,
123,3,99,3,87,3,-1,87,3,89,
3,91,3,99,3,123,3,149,3,151,
3,159,3,17,1,1,0,203,2,87,
2,85,2,201,4,91,4,89,4,-1,
107,2,111,2,147,2,157,2,191,2,
193,2,195,2,197,2,199,2,201,2,
203,2,243,2,1,0,237,1,213,1,
201,1,167,1,165,1,159,1,157,1,
151,1,149,1,147,1,137,1,135,1,
91,1,89,1,203,3,159,3,157,3,
111,3,-1,107,2,109,2,147,2,149,
2,191,2,193,2,195,2,243,2,1,
0,241,1,209,1,207,1,205,1,177,
1,175,1,135,1,101,1,93,1,203,
3,201,3,159,3,157,3,111,3,89,
3,-1,87,3,99,3,123,3,151,3,
197,3,199,3,17,1,1,0,239,2,
181,2,179,2,137,2,85,2,91,4,
-1,93,1,101,1,135,1,175,1,177,
1,205,1,207,1,209,1,241,1,1,
0,243,2,195,2,193,2,191,2,149,
2,147,2,109,2,107,2,-1,1,0,
241,1,209,1,207,1,205,1,177,1,
175,1,135,1,101,1,93,1,-1,29,
1,30,1,31,1,245,1,247,1,249,
1,251,1,253,1,1,0,213,2,125,
2,-1,20,1,121,1,129,1,139,1,
169,1,171,1,185,1,189,1,211,1,
217,1,219,1,229,1,231,1,233,1,
235,1,1,0,125,3,-1,115,3,183,
3,185,3,219,3,235,3,17,1,1,
0,203,2,87,2,85,2,125,5,-1,
115,3,185,3,223,3,17,1,1,0,
239,2,181,2,179,2,137,2,85,2,
125,5,-1,31,1,245,1,249,1,1,
0,213,2,-1,30,1,245,1,247,1,
1,0,213,2,125,2,-1,26,1,95,
1,97,1,161,1,163,1,173,1,1,
0,167,2,165,2,-1,9,1,10,1,
27,1,161,1,1,0,165,2,-1,163,
2,1,0,17,1,167,3,-1,1,0,
12,1,-1,1,0,13,1,-1,1,0,
14,1,-1,1,0,15,1,-1,1,0,
15,1,-1,1,0,16,1,-1,1,0,
16,1,-1,1,0,18,1,-1,1,0,
235,1,233,1,231,1,229,1,219,1,
217,1,211,1,189,1,185,1,171,1,
169,1,139,1,129,1,121,1,20,1,
-1,21,1,-1,17,1,1,0,223,2,
221,2,187,2,183,2,145,2,143,2,
141,2,133,2,131,2,117,2,115,2,
24,2,-1,19,1,25,2,-1,20,1,
121,1,129,1,139,1,169,1,171,1,
185,1,189,1,211,1,217,1,219,1,
229,1,231,1,233,1,235,1,1,0,
79,2,-1,24,2,115,2,117,2,131,
2,133,2,141,2,143,2,145,2,183,
2,187,2,221,2,223,2,1,0,17,
1,155,3,153,3,83,3,81,3,-1,
83,2,117,2,139,2,141,2,229,2,
1,0,235,1,233,1,231,1,229,1,
219,1,217,1,211,1,189,1,185,1,
171,1,169,1,139,1,129,1,121,1,
20,1,81,3,79,3,-1,121,3,143,
3,145,3,231,3,17,1,1,0,223,
2,221,2,187,2,183,2,145,2,143,
2,141,2,133,2,131,2,117,2,115,
2,24,2,155,4,153,4,83,4,-1,
83,2,139,2,141,2,143,2,1,0,
155,1,153,1,131,1,129,1,81,1,
79,1,21,1,153,3,83,3,81,3,
79,3,-1,145,3,17,1,1,0,133,
2,25,2,155,4,-1,20,1,-1,1,
0,155,1,153,1,131,1,129,1,81,
1,79,1,21,1,-1,19,1,24,2,
-1,17,1,1,0,133,2,25,2,-1,
20,1,121,1,129,1,139,1,169,1,
171,1,185,1,189,1,211,1,217,1,
219,1,229,1,231,1,233,1,235,1,
1,0,229,2,141,2,139,2,117,2,
83,2,-1,24,2,115,2,117,2,131,
2,133,2,141,2,143,2,145,2,183,
2,187,2,221,2,223,2,1,0,17,
1,231,3,145,3,143,3,121,3,-1,
21,1,79,1,81,1,129,1,131,1,
153,1,155,1,1,0,143,2,141,2,
139,2,83,2,-1,187,2,189,2,217,
2,221,2,223,2,233,2,1,0,237,
1,213,1,201,1,167,1,165,1,159,
1,157,1,151,1,149,1,147,1,137,
1,135,1,91,1,89,1,231,3,229,
3,117,3,-1,115,3,183,3,185,3,
219,3,235,3,17,1,1,0,203,2,
87,2,85,2,121,4,-1,115,3,185,
3,223,3,17,1,1,0,239,2,181,
2,179,2,137,2,85,2,117,4,-1,
183,2,187,2,189,2,217,2,219,2,
221,2,1,0,241,1,209,1,207,1,
205,1,177,1,175,1,135,1,101,1,
93,1,231,3,229,3,121,3,-1,25,
2,133,2,1,0,17,1,145,3,-1,
85,2,87,2,203,2,1,0,17,1,
235,3,219,3,185,3,183,3,115,3,
-1,89,1,91,1,135,1,137,1,147,
1,149,1,151,1,157,1,159,1,165,
1,167,1,201,1,213,1,237,1,1,
0,233,2,223,2,221,2,217,2,189,
2,187,2,-1,85,2,137,2,179,2,
181,2,239,2,1,0,17,1,223,3,
185,3,115,3,-1,93,1,101,1,135,
1,175,1,177,1,205,1,207,1,209,
1,241,1,1,0,221,2,219,2,217,
2,189,2,187,2,183,2,-1,107,2,
111,2,147,2,157,2,191,2,193,2,
195,2,197,2,199,2,201,2,203,2,
243,2,1,0,237,1,213,1,201,1,
167,1,165,1,159,1,157,1,151,1,
149,1,147,1,137,1,135,1,91,1,
89,1,235,3,233,3,-1,107,2,109,
2,147,2,149,2,191,2,193,2,195,
2,243,2,1,0,241,1,209,1,207,
1,205,1,177,1,175,1,135,1,101,
1,93,1,235,3,233,3,-1,26,1,
95,1,97,1,161,1,163,1,173,1,
1,0,171,2,169,2,-1,9,1,10,
1,27,1,161,1,1,0,169,2,-1,
163,2,1,0,17,1,171,3,-1,29,
1,30,1,31,1,245,1,247,1,249,
1,251,1,253,1,1,0,211,2,-1,
31,1,245,1,249,1,1,0,211,2,
-1,30,1,245,1,247,1,1,0,211,
2,-1,17,1,1,0,22,2,-1,19,
1,23,2,-1,28,1,-1,1,0,253,
1,251,1,249,1,247,1,245,1,31,
1,30,1,29,1,-1,19,1,22,2,
-1,17,1,1,0,251,2,247,2,23,
2,-1,29,1,30,1,31,1,245,1,
247,1,249,1,251,1,253,1,1,0,
253,2,28,2,-1,28,1,29,2,-1,
31,1,245,1,249,1,1,0,253,2,
29,2,28,2,-1,30,1,245,1,247,
1,1,0,253,2,29,2,28,2,-1,
30,1,-1,1,0,249,1,245,1,31,
1,-1,5,0,23,1,22,1,-1,29,
1,30,1,31,1,245,1,247,1,249,
1,251,1,253,1,1,0,253,2,28,
2,-1,28,1,29,2,-1,31,1,245,
1,249,1,1,0,253,2,29,2,28,
2,-1,30,1,245,1,247,1,1,0,
253,2,29,2,28,2,-1,1,0,247,
1,245,1,30,1,-1,31,1,-1,17,
1,1,0,251,2,249,2,-1,2,0,
35,1,34,1,33,1,32,1,-1,1,
0,66,1,65,1,63,1,61,1,59,
1,57,1,56,1,55,1,54,1,53,
1,51,1,49,1,-1,17,1,1,0,
64,2,62,2,60,2,58,2,52,2,
50,2,-1,20,1,121,1,129,1,139,
1,169,1,171,1,185,1,189,1,211,
1,217,1,219,1,229,1,231,1,233,
1,235,1,1,0,70,2,69,2,67,
2,-1,24,2,115,2,117,2,131,2,
133,2,141,2,143,2,145,2,183,2,
187,2,221,2,223,2,1,0,17,1,
71,3,68,3,-1,21,1,79,1,81,
1,129,1,131,1,153,1,155,1,1,
0,71,2,70,2,69,2,68,2,67,
2,-1,89,1,91,1,135,1,137,1,
147,1,149,1,151,1,157,1,159,1,
165,1,167,1,201,1,213,1,237,1,
1,0,72,2,-1,93,1,101,1,135,
1,175,1,177,1,205,1,207,1,209,
1,241,1,1,0,72,2,-1,29,1,
30,1,31,1,245,1,247,1,249,1,
251,1,253,1,1,0,78,2,77,2,
76,2,75,2,74,2,73,2,-1,31,
1,245,1,249,1,1,0,77,2,76,
2,75,2,74,2,73,2,-1,28,2,
253,2,1,0,253,1,251,1,249,1,
247,1,245,1,31,1,30,1,29,1,
78,3,-1,28,2,29,2,253,2,1,
0,249,1,245,1,31,1,78,3,-1,
28,2,29,2,253,2,1,0,247,1,
245,1,30,1,78,3,-1,30,1,245,
1,247,1,1,0,77,2,76,2,75,
2,74,2,73,2,-1,28,2,253,2,
1,0,253,1,251,1,249,1,247,1,
245,1,31,1,30,1,29,1,78,3,
-1,28,2,29,2,253,2,1,0,249,
1,245,1,31,1,78,3,-1,28,2,
29,2,253,2,1,0,247,1,245,1,
30,1,78,3,-1,78,1,77,1,76,
1,75,1,74,1,73,1,72,1,71,
1,70,1,69,1,68,1,67,1,65,
1,62,1,61,1,58,1,57,1,56,
1,55,1,54,1,53,1,50,1,49,
1,34,1,32,1,-1,19,1,66,2,
64,2,63,2,60,2,59,2,52,2,
51,2,35,2,33,2,-1,5,0,78,
1,77,1,75,1,74,1,73,1,72,
1,71,1,70,1,69,1,66,1,65,
1,64,1,63,1,62,1,61,1,60,
1,59,1,58,1,57,1,56,1,52,
1,51,1,50,1,49,1,35,1,34,
1,33,1,32,1,-1,1,0,55,1,
54,1,53,1,-1,17,1,1,0,76,
2,68,2,67,2,-1,4,0,77,1,
76,1,73,1,72,1,71,1,70,1,
68,1,67,1,64,1,62,1,60,1,
58,1,56,1,54,1,53,1,52,1,
51,1,50,1,49,1,33,1,32,1,
-1,17,1,1,0,78,2,74,2,66,
2,65,2,63,2,61,2,55,2,35,
2,34,2,-1,1,0,75,1,69,1,
59,1,57,1,-1,4,0,78,1,77,
1,76,1,75,1,74,1,69,1,68,
1,67,1,63,1,61,1,59,1,57,
1,55,1,53,1,52,1,51,1,50,
1,49,1,35,1,34,1,33,1,32,
1,-1,1,0,73,1,72,1,71,1,
70,1,66,1,65,1,60,1,58,1,
56,1,54,1,-1,17,1,1,0,64,
2,62,2,-1,2,0,37,1,36,1,
-1,1,0,45,1,44,1,43,1,42,
1,41,1,40,1,39,1,38,1,-1,
29,1,30,1,31,1,245,1,247,1,
249,1,251,1,253,1,1,0,48,2,
47,2,46,2,-1,31,1,245,1,249,
1,1,0,48,2,47,2,46,2,-1,
30,1,245,1,247,1,1,0,48,2,
47,2,46,2,-1,46,1,44,1,41,
1,40,1,38,1,36,1,-1,19,1,
48,2,47,2,45,2,43,2,42,2,
39,2,37,2,-1,5,0,47,1,46,
1,45,1,44,1,39,1,38,1,37,
1,36,1,-1,1,0,42,1,40,1,
-1,17,1,1,0,48,2,43,2,41,
2,-1,4,0,48,1,47,1,46,1,
43,1,42,1,41,1,40,1,39,1,
38,1,37,1,36,1,-1,17,1,1,
0,45,2,44,2,-1,};
short mtStart = 5296;
short mtMap[] = {
0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,
0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,
0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,
0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,
0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,
0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,
0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,
0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,
0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,
0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,
0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,
0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,
0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,
0x2,0x2,0x2,0x2,0x2,};
short mtPaths[] = {
7,-4,-4,-4,-4,-2,0x2000,-1,-3,-4,
-4,-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,
-1,-3,-4,-4,-2,0x2000,-1,-3,-4,-4,
-2,0x2000,-1,-3,-4,-4,-2,0x2000,-1,-3,
-4,-2,0x2000,-1,-1,-1,-1,-1,-1,0,
6,-4,-4,-2,0x2000,-3,-2,0x2000,-1,-3,
-4,-2,0x2000,-3,-4,-2,0x2000,-3,-4,-2,
0x2000,-3,-2,0x2000,-1,-1,-1,-1,0,8,
-4,-4,-4,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-3,-2,0x2000,-1,-1,-3,-4,-2,0x2000,
-3,-4,-4,-2,0x2000,-1,-3,-4,-4,-2,
0x2000,-1,-3,-4,-2,0x2000,-1,-1,-1,-3,
-4,-2,0x2000,-1,-1,-1,-1,0,8,-4,
-4,-2,0x2000,-3,-4,-2,0x2000,-3,-2,0x2000,
-1,-1,-3,-4,-2,0x2000,-3,-4,-2,0x2000,
-3,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-1,-1,-1,-3,-2,0x2000,-1,-1,0,4,
-4,-4,-2,0x2000,-3,-4,-2,0x2000,-3,-4,
-2,0x2000,-3,-2,0x2000,-1,-1,-1,-1,0,
4,-4,-4,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-1,-1,-3,-4,-4,-2,0x2000,-1,-3,
-4,-2,0x2000,-1,-1,-1,0,4,-4,-4,
-4,-4,-2,0x2000,-1,-3,-2,0x2000,-1,-3,
-4,-4,-2,0x2000,-1,-3,-2,0x2000,-1,-1,
-1,0,4,-4,-2,0x2000,-3,-4,-4,-2,
0x2000,-1,-3,-4,-4,-2,0x2000,-1,-3,-2,
0x2000,-1,-1,-1,0,4,-4,-4,-4,-4,
-2,0x2000,-1,-3,-2,0x2000,-1,-3,-4,-2,
0x2000,-3,-2,0x2000,-1,-1,-1,0,6,-4,
-4,-2,0x2000,-3,-4,-4,-2,0x2000,-1,-3,
-4,-2,0x2000,-1,-1,-1,-3,-4,-4,-2,
0x2000,-1,-3,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2000,-1,-1,-1,-1,0,4,-4,-4,
-4,-4,-2,0x2000,-1,-3,-2,0x2000,-1,-3,
-4,-2,0x2000,-3,-4,-2,0x2000,-1,-1,-1,
-1,0,4,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2000,-3,-4,-2,0x2000,-3,-4,-2,0x2000,
-1,-1,-1,-1,0,3,-4,-4,-4,-2,
0x2000,-3,-2,0x2000,-1,-3,-2,0x2000,-1,-1,
0,3,-4,-4,-2,0x2000,-1,-3,-4,-4,
-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,-1,
0,5,-4,-4,-4,-4,-2,0x2000,-1,-3,
-4,-2,0x2000,-1,-1,-3,-4,-4,-2,0x2000,
-1,-3,-4,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-1,-1,-1,-1,-1,0,8,-4,-4,
-2,0x2000,-3,-4,-4,-2,0x2000,-3,-2,0x2000,
-1,-3,-2,0x2000,-1,-1,-3,-4,-2,0x2000,
-3,-4,-4,-2,0x2000,-3,-2,0x2000,-1,-3,
-2,0x2000,-1,-1,-1,0,5,-4,-4,-4,
-2,0x2000,-1,-3,-4,-4,-2,0x2000,-1,-3,
-4,-4,-2,0x2000,-1,-3,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-1,-1,-1,-1,-1,
-1,0,5,-4,-4,-2,0x2000,-3,-2,0x2000,
-1,-3,-4,-2,0x2000,-3,-4,-2,0x2000,-3,
-2,0x2000,-1,-1,-1,0,7,-4,-4,-4,
-2,0x2000,-1,-3,-4,-4,-2,0x2000,-3,-4,
-4,-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,
-1,-3,-4,-2,0x2000,-3,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-1,-1,-1,-1,-1,
-1,0,5,-4,-4,-2,0x2000,-3,-2,0x2000,
-1,-3,-4,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2000,-1,-1,-3,-2,0x2000,-1,-1,0,
5,-4,-4,-4,-2,0x2000,-1,-3,-4,-4,
-2,0x2000,-1,-3,-4,-4,-2,0x2000,-1,-3,
-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,-1,
-1,-1,-1,-1,-1,0,5,-4,-4,-2,
0x2000,-3,-4,-2,0x2000,-3,-2,0x2000,-1,-1,
-3,-4,-2,0x2000,-3,-2,0x2000,-1,-1,0,
6,-4,-4,-4,-2,0x2000,-3,-4,-4,-2,
0x2000,-1,-3,-4,-2,0x2000,-1,-1,-1,-3,
-4,-4,-2,0x2000,-1,-3,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-1,-1,-1,-1,-1,
0,4,-4,-4,-4,-2,0x2000,-1,-3,-2,
0x2000,-1,-3,-4,-2,0x2000,-3,-2,0x2000,-1,
-1,0,6,-4,-4,-4,-4,-2,0x2000,-1,
-3,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-1,-1,-1,-3,-4,-4,-2,0x2000,-1,-3,
-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,-1,
-1,-1,-1,-1,0,4,-4,-4,-2,0x2000,
-3,-2,0x2000,-1,-3,-4,-2,0x2000,-3,-2,
0x2000,-1,-1,0,4,-4,-4,-4,-2,0x2000,
-1,-3,-4,-4,-2,0x2000,-1,-3,-4,-4,
-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,-1,
-1,-1,0,4,-4,-4,-2,0x2000,-3,-4,
-2,0x2000,-3,-2,0x2000,-1,-1,-3,-2,0x2000,
-1,0,4,-4,-4,-2,0x2000,-3,-4,-2,
0x2000,-3,-4,-2,0x2000,-3,-2,0x2000,-1,-1,
-1,-1,0,4,-4,-4,-4,-2,0x2000,-1,
-3,-4,-2,0x2000,-1,-1,-3,-4,-4,-2,
0x2000,-1,-3,-4,-2,0x2000,-1,-1,-1,0,
3,-4,-4,-2,0x2000,-3,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-1,-1,-1,-1,0,
3,-4,-2,0x2000,-3,-4,-2,0x2000,-3,-2,
0x2000,-1,-1,0,3,-4,-4,-2,0x2000,-3,
-4,-2,0x2000,-3,-4,-2,0x2000,-1,-1,-1,
-1,0,3,-4,-2,0x2000,-3,-4,-4,-2,
0x2000,-1,-3,-2,0x2000,-1,-1,0,5,-4,
-4,-4,-4,-2,0x2000,-1,-3,-4,-4,-2,
0x2000,-1,-3,-4,-2,0x2000,-1,-1,-1,-3,
-4,-2,0x2000,-3,-2,0x2000,-1,-1,-1,0,
5,-4,-4,-2,0x2000,-3,-4,-4,-2,0x2000,
-1,-3,-4,-4,-2,0x2000,-1,-3,-2,0x2000,
-1,-1,-1,-3,-2,0x2000,-1,0,4,-4,
-4,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-3,-2,0x2000,-1,-1,-3,-2,0x2000,-1,-1,
0,4,-4,-2,0x2000,-3,-4,-4,-2,0x2000,
-1,-3,-4,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-1,-1,-1,-1,0,4,-4,-4,-4,
-4,-2,0x2000,-1,-3,-4,-4,-2,0x2000,-1,
-3,-2,0x2000,-1,-1,-3,-2,0x2000,-1,-1,
0,4,-4,-2,0x2000,-3,-4,-4,-2,0x2000,
-1,-3,-4,-4,-2,0x2000,-1,-3,-2,0x2000,
-1,-1,-1,0,3,-4,-4,-2,0x2000,-3,
-4,-2,0x2000,-3,-2,0x2000,-1,-1,-1,0,
3,-4,-4,-2,0x2000,-1,-3,-4,-4,-2,
0x2000,-1,-3,-4,-2,0x2000,-1,-1,-1,0,
2,-4,-4,-2,0x2000,-3,-2,0x2000,-1,-1,
0,2,-4,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-1,-1,0,5,-4,-4,-4,-4,-2,
0x2000,-1,-3,-4,-2,0x2000,-3,-4,-2,0x2000,
-3,-4,-2,0x2000,-1,-1,-1,-1,-3,-4,
-2,0x2000,-1,-1,-1,0,5,-4,-4,-4,
-2,0x2000,-1,-3,-4,-4,-2,0x2000,-1,-3,
-2,0x2000,-1,-1,-3,-4,-2,0x2000,-3,-2,
0x2000,-1,-1,0,4,-4,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-3,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-1,-1,-1,-1,-1,
0,4,-4,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2000,-3,-2,0x2000,-1,-1,-3,-2,0x2000,
-1,0,4,-4,-4,-4,-2,0x2000,-1,-3,
-4,-4,-2,0x2000,-1,-3,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-1,-1,-1,-1,-1,
0,4,-4,-4,-2,0x2000,-3,-4,-2,0x2000,
-3,-2,0x2000,-1,-1,-3,-2,0x2000,-1,0,
9,-4,-4,-2,0x2000,-3,-4,-2,0x2000,-3,
-2,0x2000,-3,-2,0x2000,-1,-3,-4,-2,0x2000,
-3,-2,0x2000,-3,-2,0x2000,-1,-1,-3,-2,
0x2001,-3,-3,-4,-2,0x2000,-1,-3,-1,0,
4,-4,-4,-2,0x2000,-3,-2,0x2000,-3,-2,
0x2000,-1,-3,-2,0x2001,-3,-3,-3,-1,0,
5,-4,-4,-2,0x2000,-3,-2,0x2000,-3,-2,
0x2000,-1,-3,-2,0x2001,-3,-4,-2,0x2000,-1,
-3,-3,-1,0,5,-4,-4,-2,0x2000,-3,
-2,0x2000,-3,-2,0x2000,-1,-3,-2,0x2001,-3,
-3,-2,0x2000,-3,-1,0,5,-4,-4,-2,
0x2000,-3,-2,0x2000,-3,-2,0x2000,-1,-3,-2,
0x2001,-3,-3,-4,-2,0x2000,-1,-3,-1,0,
5,-4,-4,-2,0x2000,-3,-2,0x2000,-3,-2,
0x2000,-1,-3,-2,0x2001,-3,-3,-3,-2,0x2000,
-1,0,4,-4,-4,-2,0x2000,-3,-2,0x2000,
-1,-3,-2,0x2001,-3,-3,-3,-2,0x2000,-1,
0,4,-4,-4,-4,-2,0x2000,-1,-3,-2,
0x2000,-1,-3,-2,0x2001,-3,-3,-3,-2,0x2000,
-1,0,4,-4,-4,-2,0x2000,-3,-2,0x2000,
-1,-3,-2,0x2001,-3,-3,-3,-2,0x2000,-1,
0,4,-4,-4,-2,0x2000,-3,-2,0x2000,-1,
-3,-2,0x2001,-3,-3,-2,0x2000,-3,-1,0,
4,-4,-4,-4,-2,0x2000,-1,-3,-2,0x2000,
-1,-3,-2,0x2001,-3,-4,-2,0x2000,-1,-3,
-3,-1,0,4,-4,-4,-2,0x2000,-3,-2,
0x2000,-1,-3,-2,0x2001,-3,-4,-2,0x2000,-1,
-3,-3,-1,0,4,-4,-2,0x2000,-3,-4,
-2,0x2001,-1,-3,-3,-4,-2,0x2000,-1,-3,
-2,0x2000,-1,0,4,-4,-2,0x2000,-3,-2,
0x2001,-3,-3,-4,-2,0x2000,-1,-3,-2,0x2000,
-1,0,3,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2001,-1,-3,-3,-3,-4,-2,0x2000,-1,
-1,0,3,-4,-2,0x2000,-3,-4,-2,0x2001,
-1,-3,-3,-4,-2,0x2000,-1,-3,-1,0,
3,-4,-4,-2,0x2000,-1,-3,-2,0x2001,-3,
-3,-3,-4,-2,0x2000,-1,-1,0,3,-4,
-2,0x2000,-3,-2,0x2001,-3,-3,-4,-2,0x2000,
-1,-3,-1,0,3,-4,-4,-2,0x2000,-1,
-3,-4,-2,0x2001,-1,-3,-3,-3,-2,0x2000,
-1,0,3,-4,-2,0x2000,-3,-4,-2,0x2001,
-1,-3,-3,-2,0x2000,-3,-1,0,3,-4,
-4,-2,0x2000,-1,-3,-2,0x2001,-3,-3,-3,
-2,0x2000,-1,0,3,-4,-2,0x2000,-3,-2,
0x2001,-3,-3,-2,0x2000,-3,-1,0,3,-4,
-2,0x2000,-3,-2,0x2001,-3,-3,-3,-2,0x2000,
-1,0,4,-4,-2,0x2000,-3,-2,0x2001,-3,
-2,0x2000,-3,-4,-2,0x2000,-1,-3,-1,0,
4,-4,-2,0x2000,-3,-2,0x2001,-3,-2,0x2000,
-3,-3,-2,0x2000,-1,0,3,-4,-2,0x2000,
-3,-2,0x2001,-3,-2,0x2000,-3,-3,-1,0,
2,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2001,
-1,-3,-3,-3,-1,0,2,-4,-2,0x2000,
-3,-4,-2,0x2001,-1,-3,-3,-3,-1,0,
2,-4,-4,-2,0x2000,-1,-3,-2,0x2001,-3,
-3,-3,-1,0,2,-4,-2,0x2000,-3,-2,
0x2001,-3,-3,-3,-1,0,5,-4,-4,-2,
0x2000,-3,-2,0x2000,-3,-2,0x2000,-1,-3,-4,
-2,0x2001,-1,-3,-4,-2,0x2000,-1,-3,-1,
0,4,-4,-4,-2,0x2000,-3,-2,0x2000,-3,
-2,0x2000,-1,-3,-4,-2,0x2001,-1,-3,-3,
-1,0,4,-4,-4,-2,0x2000,-3,-2,0x2000,
-3,-2,0x2000,-1,-3,-2,0x2001,-3,-3,-1,
0,3,-4,-2,0x2000,-3,-4,-2,0x2001,-1,
-3,-3,-4,-2,0x2000,-1,-1,0,3,-4,
-2,0x2000,-3,-2,0x2001,-3,-3,-4,-2,0x2000,
-1,-1,0,3,-4,-2,0x2000,-3,-4,-2,
0x2001,-1,-3,-4,-2,0x2000,-1,-3,-1,0,
3,-4,-2,0x2000,-3,-4,-2,0x2001,-1,-3,
-2,0x2000,-3,-1,0,3,-4,-2,0x2000,-3,
-2,0x2001,-3,-4,-2,0x2000,-1,-3,-1,0,
3,-4,-2,0x2000,-3,-2,0x2001,-3,-2,0x2000,
-3,-1,0,2,-4,-2,0x2000,-3,-4,-2,
0x2001,-1,-3,-3,-1,0,2,-4,-2,0x2000,
-3,-2,0x2001,-3,-3,-1,0,2,-4,-2,
0x2002,-3,-4,-2,0x2001,-1,-3,-3,-1,0,
2,-4,-2,0x2002,-3,-2,0x2001,-3,-3,-1,
0,3,-4,-2,0x2002,-3,-4,-2,0x2001,-1,
-3,-3,-4,-2,0x2000,-1,-3,-1,0,3,
-4,-2,0x2002,-3,-2,0x2001,-3,-3,-4,-2,
0x2000,-1,-3,-1,0,2,-4,-2,0x2002,-3,
-4,-2,0x2001,-1,-3,-3,-3,-1,0,2,
-4,-2,0x2002,-3,-2,0x2001,-3,-3,-3,-1,
0,3,-4,-2,0x2000,-3,-2,0x2000,-3,-2,
0x2001,-1,0,3,-4,-2,0x2000,-3,-2,0x2001,
-3,-2,0x2000,-1,0,7,-4,-2,0x2000,-3,
-4,-2,0x2001,-3,-2,0x2000,-3,-2,0x2000,-1,
-3,-4,-2,0x2001,-3,-2,0x2000,-3,-2,0x2000,
-1,-1,0,7,-4,-2,0x2001,-3,-4,-2,
0x2000,-3,-2,0x2000,-3,-2,0x2000,-1,-3,-4,
-2,0x2000,-3,-2,0x2000,-3,-2,0x2000,-1,-1,
0,2,-4,-2,0x2001,-3,-2,0x2000,-1,0,
2,-4,-2,0x2000,-3,-2,0x2001,-1,0,2,
-4,-4,-2,0x2001,-1,-3,-4,-2,0x2000,-1,
-1,0,2,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2001,-1,-1,0,2,-4,-4,-2,0x2001,
-1,-3,-4,-2,0x2000,-1,-3,-1,0,2,
-4,-4,-2,0x2000,-1,-3,-4,-2,0x2001,-1,
-3,-1,0,2,-4,-2,0x2001,-3,-2,0x2000,
-1,0,2,-4,-2,0x2000,-3,-2,0x2001,-1,
0,1,-4,-2,0x2001,-1,0,1,-4,-2,
0x2000,-1,0,1,-4,-2,0x2000,-1,0,2,
-4,-2,0x2000,-3,-2,0x2000,-1,0,2,-4,
-2,0x2000,-3,-2,0x2000,-1,0,1,-4,-2,
0x2000,-1,0,1,-4,-2,0x2000,-1,0,1,
-4,-2,0x2000,-1,0,4,-4,-4,-2,0x2000,
-3,-2,0x2000,-1,-3,-4,-4,-2,0x2000,-1,
-3,-2,0x2000,-1,-1,0,1,-4,-3,-2,
0x2000,-1,0,1,-4,-3,-2,0x2000,-1,0,
1,-4,-4,-2,0x2000,-1,-1,0,0,0,
0,0,0,0,0,0,0,0,1,-2,
0x2002,0,1,-2,0x2000,0,0,0,7,-4,
-4,-2,0x2000,-3,-4,-2,0x2000,-3,-4,-2,
0x2000,-1,-3,-4,-2,0x2000,-1,-1,-3,-4,
-2,0x2000,-3,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-1,-1,-1,-1,0,7,-4,-2,0x2000,
-3,-4,-2,0x2000,-3,-2,0x2000,-3,-2,0x2000,
-1,-3,-4,-2,0x2000,-3,-2,0x2000,-3,-2,
0x2000,-1,-1,0,3,-4,-4,-2,0x2000,-3,
-2,0x2000,-3,-2,0x2000,-1,-1,0,3,-4,
-2,0x2000,-3,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-1,-1,0,3,-4,-4,-2,0x2000,-3,
-4,-2,0x2000,-1,-3,-2,0x2000,-1,-1,0,
3,-4,-2,0x2000,-3,-2,0x2000,-3,-4,-2,
0x2000,-1,-1,0,3,-4,-4,-2,0x2000,-3,
-2,0x2000,-3,-4,-2,0x2000,-1,-1,-1,0,
3,-4,-2,0x2000,-3,-4,-2,0x2000,-1,-3,
-2,0x2000,-1,0,3,-4,-4,-2,0x2000,-3,
-4,-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,
-1,0,3,-4,-2,0x2000,-3,-2,0x2000,-3,
-2,0x2000,-1,0,4,-4,-4,-4,-2,0x2000,
-1,-3,-4,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-3,-2,0x2000,-1,-1,-1,-1,0,4,
-4,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-1,-1,-3,-4,-2,0x2000,-3,-2,0x2000,-1,
-1,0,4,-4,-4,-4,-2,0x2000,-1,-3,
-4,-2,0x2000,-3,-4,-2,0x2000,-3,-2,0x2000,
-1,-1,-1,-1,0,4,-4,-4,-4,-2,
0x2000,-1,-3,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2000,-1,-1,-1,-3,-2,0x2000,-1,0,
3,-4,-4,-2,0x2000,-3,-4,-2,0x2000,-3,
-2,0x2000,-1,-1,-1,0,3,-4,-4,-4,
-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,-3,
-4,-2,0x2000,-1,-1,0,4,-4,-4,-4,
-2,0x2000,-1,-3,-4,-4,-4,-2,0x2000,-1,
-3,-4,-2,0x2000,-1,-1,-3,-4,-2,0x2000,
-1,-1,-1,-1,0,4,-4,-2,0x2000,-3,
-4,-2,0x2000,-3,-4,-2,0x2000,-3,-2,0x2000,
-1,-1,-1,0,4,-4,-4,-4,-4,-2,
0x2000,-1,-3,-4,-4,-2,0x2000,-1,-3,-2,
0x2000,-1,-1,-3,-4,-2,0x2000,-1,-1,-1,
0,4,-4,-2,0x2000,-3,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-3,-2,0x2000,-1,-1,
-1,0,4,-4,-4,-4,-4,-2,0x2000,-1,
-3,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-1,-1,-1,-3,-4,-2,0x2000,-1,-1,-1,
0,4,-4,-2,0x2000,-3,-4,-2,0x2000,-3,
-4,-2,0x2000,-3,-2,0x2000,-1,-1,-1,0,
4,-4,-4,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2000,-1,-1,-3,-4,-4,-2,0x2000,-1,
-3,-2,0x2000,-1,-1,-1,0,4,-4,-2,
0x2000,-3,-4,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-3,-2,0x2000,-1,-1,-1,0,4,-4,
-4,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-1,-1,-3,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2000,-1,-1,-1,-1,0,4,-4,-2,
0x2000,-3,-4,-2,0x2000,-3,-4,-2,0x2000,-3,
-2,0x2000,-1,-1,-1,0,4,-4,-4,-4,
-4,-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,
-3,-4,-4,-2,0x2000,-1,-3,-2,0x2000,-1,
-1,-1,0,6,-4,-4,-2,0x2000,-3,-4,
-2,0x2000,-3,-4,-2,0x2000,-1,-1,-1,-3,
-4,-2,0x2000,-3,-4,-2,0x2000,-3,-4,-2,
0x2000,-1,-1,-1,-1,0,4,-4,-4,-4,
-4,-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,
-3,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-1,-1,-1,-1,0,6,-4,-4,-2,0x2000,
-3,-4,-2,0x2000,-3,-2,0x2000,-1,-1,-3,
-4,-2,0x2000,-3,-4,-2,0x2000,-3,-2,0x2000,
-1,-1,-1,0,3,-4,-4,-4,-4,-2,
0x2000,-1,-3,-2,0x2000,-1,-3,-2,0x2000,-1,
-1,0,3,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2000,-3,-4,-2,0x2000,-1,-1,-1,0,
3,-4,-4,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2000,-1,-1,-3,-2,0x2000,-1,-1,0,
3,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-3,-2,0x2000,-1,-1,0,3,-4,-4,-4,
-4,-2,0x2000,-1,-3,-2,0x2000,-1,-3,-4,
-2,0x2000,-1,-1,-1,0,3,-4,-2,0x2000,
-3,-4,-4,-2,0x2000,-1,-3,-2,0x2000,-1,
-1,0,3,-4,-4,-4,-4,-2,0x2000,-1,
-3,-4,-2,0x2000,-1,-1,-3,-4,-2,0x2000,
-1,-1,-1,0,3,-4,-2,0x2000,-3,-4,
-2,0x2000,-3,-2,0x2000,-1,-1,0,5,-4,
-4,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-1,-1,-3,-4,-4,-2,0x2000,-1,-3,-4,
-4,-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,
-1,-1,-1,0,5,-4,-4,-2,0x2000,-3,
-2,0x2000,-1,-3,-4,-2,0x2000,-3,-4,-2,
0x2000,-3,-2,0x2000,-1,-1,-1,0,4,-4,
-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,-3,
-4,-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,
-1,-1,0,4,-4,-2,0x2000,-3,-4,-2,
0x2000,-3,-2,0x2000,-3,-2,0x2000,-1,-1,0,
4,-4,-4,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-3,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-1,-1,-1,-1,0,4,-4,-2,0x2000,-3,
-4,-2,0x2000,-3,-2,0x2000,-3,-2,0x2000,-1,
-1,0,4,-4,-4,-4,-2,0x2000,-1,-3,
-4,-2,0x2000,-3,-4,-2,0x2000,-3,-2,0x2000,
-1,-1,-1,-1,0,4,-4,-4,-4,-2,
0x2000,-1,-3,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2000,-1,-1,-1,-3,-2,0x2000,-1,0,
4,-4,-4,-4,-2,0x2000,-1,-3,-4,-4,
-2,0x2000,-1,-3,-4,-2,0x2000,-3,-2,0x2000,
-1,-1,-1,-1,0,4,-4,-4,-4,-2,
0x2000,-1,-3,-4,-4,-2,0x2000,-1,-3,-2,
0x2000,-1,-1,-3,-2,0x2000,-1,0,4,-4,
-4,-4,-2,0x2000,-1,-3,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-3,-4,-2,0x2000,-1,
-1,-1,-1,-1,0,4,-4,-4,-4,-2,
0x2000,-1,-3,-4,-2,0x2000,-3,-2,0x2000,-1,
-1,-3,-2,0x2000,-1,0,4,-4,-4,-4,
-4,-2,0x2000,-1,-3,-4,-4,-2,0x2000,-1,
-3,-4,-2,0x2000,-1,-1,-1,-3,-2,0x2000,
-1,-1,0,4,-4,-4,-2,0x2000,-1,-3,
-4,-2,0x2000,-3,-4,-2,0x2000,-3,-2,0x2000,
-1,-1,-1,0,4,-4,-4,-4,-4,-2,
0x2000,-1,-3,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2000,-1,-1,-1,-3,-2,0x2000,-1,-1,
0,4,-4,-2,0x2000,-3,-4,-2,0x2000,-3,
-4,-4,-2,0x2000,-1,-3,-2,0x2000,-1,-1,
-1,0,4,-4,-4,-4,-2,0x2000,-1,-3,
-4,-2,0x2000,-3,-4,-2,0x2000,-3,-2,0x2000,
-1,-1,-1,-1,0,4,-4,-4,-4,-2,
0x2000,-1,-3,-4,-2,0x2000,-1,-1,-3,-4,
-2,0x2000,-3,-4,-2,0x2000,-1,-1,-1,0,
4,-4,-4,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-3,-4,-2,0x2000,-3,-4,-2,0x2000,-1,
-1,-1,-1,-1,0,4,-4,-4,-4,-2,
0x2000,-1,-3,-2,0x2000,-1,-3,-4,-2,0x2000,
-3,-4,-2,0x2000,-1,-1,-1,0,4,-4,
-4,-4,-2,0x2000,-1,-3,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-3,-2,0x2000,-1,-1,
-1,-1,0,4,-4,-4,-4,-2,0x2000,-1,
-3,-4,-2,0x2000,-1,-1,-3,-4,-2,0x2000,
-3,-2,0x2000,-1,-1,0,4,-4,-4,-4,
-2,0x2000,-1,-3,-4,-4,-2,0x2000,-1,-3,
-4,-4,-2,0x2000,-1,-3,-2,0x2000,-1,-1,
-1,-1,0,4,-4,-4,-4,-2,0x2000,-1,
-3,-2,0x2000,-1,-3,-4,-2,0x2000,-3,-2,
0x2000,-1,-1,0,4,-4,-4,-4,-2,0x2000,
-1,-3,-4,-4,-2,0x2000,-1,-3,-4,-4,
-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,-1,
-1,-1,0,4,-4,-4,-2,0x2000,-3,-2,
0x2000,-1,-3,-4,-2,0x2000,-3,-2,0x2000,-1,
-1,0,3,-4,-4,-4,-4,-2,0x2000,-1,
-3,-4,-2,0x2000,-1,-1,-3,-4,-2,0x2000,
-1,-1,-1,0,3,-4,-2,0x2000,-3,-4,
-2,0x2000,-3,-2,0x2000,-1,-1,0,3,-4,
-4,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-1,-1,-3,-2,0x2000,-1,-1,0,3,-4,
-4,-2,0x2000,-1,-3,-4,-2,0x2000,-3,-2,
0x2000,-1,-1,0,3,-4,-4,-4,-2,0x2000,
-3,-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,
-1,0,3,-4,-2,0x2000,-3,-4,-4,-2,
0x2000,-1,-3,-4,-2,0x2000,-1,-1,-1,0,
3,-4,-4,-4,-4,-2,0x2000,-1,-3,-2,
0x2000,-1,-3,-2,0x2000,-1,-1,0,3,-4,
-4,-2,0x2000,-1,-3,-4,-4,-2,0x2000,-1,
-3,-2,0x2000,-1,-1,0,3,-4,-4,-2,
0x2000,-3,-4,-2,0x2000,-3,-4,-2,0x2000,-1,
-1,-1,-1,0,3,-4,-4,-4,-2,0x2000,
-1,-3,-2,0x2000,-1,-3,-4,-2,0x2000,-1,
-1,0,3,-4,-4,-2,0x2000,-3,-4,-4,
-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,-1,
-1,0,3,-4,-4,-2,0x2000,-3,-2,0x2000,
-1,-3,-4,-2,0x2000,-1,-1,0,3,-4,
-4,-4,-2,0x2000,-1,-3,-4,-4,-2,0x2000,
-1,-3,-2,0x2000,-1,-1,-1,0,3,-4,
-4,-4,-2,0x2000,-1,-3,-2,0x2000,-1,-3,
-2,0x2000,-1,0,3,-4,-4,-4,-2,0x2000,
-1,-3,-4,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-1,-1,-1,-1,0,3,-4,-4,-2,
0x2000,-3,-2,0x2000,-1,-3,-2,0x2000,-1,0,
3,-4,-4,-2,0x2000,-3,-4,-2,0x2000,-3,
-2,0x2000,-1,-1,-1,0,3,-4,-2,0x2000,
-3,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-1,-1,-1,0,3,-4,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-3,-2,0x2000,-1,-1,
-1,0,3,-4,-2,0x2000,-3,-4,-2,0x2000,
-3,-4,-2,0x2000,-1,-1,-1,0,3,-4,
-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,-3,
-4,-2,0x2000,-1,-1,-1,-1,0,3,-4,
-2,0x2000,-3,-4,-2,0x2000,-3,-2,0x2000,-1,
-1,0,3,-4,-4,-4,-2,0x2000,-1,-3,
-4,-2,0x2000,-3,-2,0x2000,-1,-1,-1,0,
3,-4,-2,0x2000,-3,-4,-2,0x2000,-3,-4,
-2,0x2000,-1,-1,-1,0,3,-4,-4,-4,
-2,0x2000,-1,-3,-4,-2,0x2000,-3,-4,-2,
0x2000,-1,-1,-1,-1,0,3,-4,-2,0x2000,
-3,-4,-2,0x2000,-3,-2,0x2000,-1,-1,0,
2,-4,-4,-2,0x2000,-3,-2,0x2000,-1,-1,
0,2,-4,-2,0x2000,-3,-4,-2,0x2000,-1,
-1,0,2,-4,-4,-2,0x2000,-3,-4,-2,
0x2000,-1,-1,-1,0,2,-4,-2,0x2000,-3,
-2,0x2000,-1,0,4,-4,-4,-4,-4,-2,
0x2000,-1,-3,-4,-4,-2,0x2000,-1,-3,-4,
-2,0x2000,-1,-1,-1,-3,-2,0x2000,-1,-1,
0,4,-4,-2,0x2000,-3,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-3,-2,0x2000,-1,-1,
-1,0,4,-4,-4,-4,-4,-2,0x2000,-1,
-3,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-1,-1,-1,-3,-4,-2,0x2000,-1,-1,-1,
0,4,-4,-2,0x2000,-3,-4,-2,0x2000,-3,
-4,-2,0x2000,-3,-2,0x2000,-1,-1,-1,0,
4,-4,-4,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-3,-4,-2,0x2000,-3,-2,0x2000,-1,-1,
-1,-1,0,4,-4,-4,-4,-2,0x2000,-1,
-3,-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,
-1,-1,-1,-3,-2,0x2000,-1,0,4,-4,
-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,-3,
-4,-2,0x2000,-3,-4,-2,0x2000,-1,-1,-1,
-1,-1,0,4,-4,-4,-4,-2,0x2000,-1,
-3,-4,-4,-2,0x2000,-1,-3,-2,0x2000,-1,
-1,-3,-2,0x2000,-1,0,3,-4,-4,-4,
-2,0x2000,-1,-3,-4,-2,0x2000,-3,-2,0x2000,
-1,-1,-1,0,3,-4,-2,0x2000,-3,-4,
-4,-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,
-1,0,3,-4,-4,-4,-2,0x2000,-1,-3,
-4,-4,-2,0x2000,-1,-3,-2,0x2000,-1,-1,
-1,0,3,-4,-2,0x2000,-3,-4,-4,-2,
0x2000,-1,-3,-2,0x2000,-1,-1,0,3,-4,
-4,-4,-2,0x2000,-1,-3,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-1,-1,-1,-1,0,
3,-4,-2,0x2000,-3,-4,-2,0x2000,-3,-2,
0x2000,-1,-1,0,3,-4,-4,-2,0x2000,-3,
-4,-2,0x2000,-3,-2,0x2000,-1,-1,-1,0,
3,-4,-4,-2,0x2000,-1,-3,-4,-4,-2,
0x2000,-1,-3,-4,-2,0x2000,-1,-1,-1,0,
3,-4,-4,-4,-2,0x2000,-1,-3,-4,-2,
0x2000,-3,-2,0x2000,-1,-1,-1,0,3,-4,
-4,-2,0x2000,-1,-3,-4,-4,-2,0x2000,-1,
-3,-2,0x2000,-1,-1,0,3,-4,-4,-4,
-2,0x2000,-1,-3,-4,-2,0x2000,-3,-4,-2,
0x2000,-1,-1,-1,-1,0,3,-4,-4,-2,
0x2000,-1,-3,-4,-2,0x2000,-3,-2,0x2000,-1,
-1,0,3,-4,-4,-4,-2,0x2000,-1,-3,
-4,-4,-2,0x2000,-1,-3,-4,-2,0x2000,-1,
-1,-1,-1,0,3,-4,-2,0x2000,-3,-4,
-2,0x2000,-3,-2,0x2000,-1,-1,0,2,-4,
-4,-4,-2,0x2000,-1,-3,-2,0x2000,-1,-1,
0,2,-4,-2,0x2000,-3,-4,-2,0x2000,-1,
-1,0,2,-4,-4,-4,-2,0x2000,-1,-3,
-4,-2,0x2000,-1,-1,-1,0,2,-4,-2,
0x2000,-3,-2,0x2000,-1,0,2,-4,-4,-2,
0x2000,-3,-2,0x2000,-1,-1,0,2,-4,-4,
-2,0x2000,-1,-3,-4,-2,0x2000,-1,-1,0,
2,-4,-4,-4,-2,0x2000,-1,-3,-2,0x2000,
-1,-1,0,2,-4,-4,-2,0x2000,-1,-3,
-2,0x2000,-1,0,2,-4,-4,-4,-2,0x2000,
-1,-3,-4,-2,0x2000,-1,-1,-1,0,2,
-4,-2,0x2000,-3,-2,0x2000,-1,0, };
short int mtPathStart[] = {
2456,2452,2448,2446,2444,2442,2440,2438,2430,2423,
2416,2395,2389,2383,2377,2368,2359,2353,2347,2341,
2332,2323,2309,2295,2282,2269,2260,2251,2223,2195,
2183,2171,2159,2145,2129,2111,2100,2087,2076,2063,
2050,2035,2020,2003,1988,1971,1952,1931,1906,1894,
1880,1866,1850,1836,1820,1802,1788,1774,1758,1742,
1724,1708,1690,1672,1652,1634,1614,1593,1570,1551,
1532,1511,1492,1470,1446,1424,1400,1380,1340,1321,
1292,1271,1244,1216,1184,1171,1160,1140,1124,1101,
1076,1051,1028,1000,968,952,934,920,900,873,
852,833,804,785,742,721,680,656,620,592,
546,522,486,447,411,391,375,352,327,288,
265,242,217,190,169,128,79,50,0,4959,
4944,4933,4920,4907,4896,4887,4872,4861,4848,4834,
4812,4796,4776,4758,4740,4720,4704,4690,4668,4652,
4632,4614,4596,4573,4548,4523,4500,4481,4452,4431,
4404,4395,4382,4371,4360,4346,4326,4310,4292,4278,
4258,4242,4224,4206,4190,4176,4154,4138,4118,4102,
4082,4064,4046,4028,4010,3992,3974,3958,3938,3924,
3902,3883,3854,3833,3806,3783,3758,3735,3710,3685,
3662,3641,3614,3593,3566,3545,3518,3495,3470,3445,
3422,3405,3380,3363,3338,3314,3278,3264,3242,3226,
3206,3190,3170,3152,3134,3105,3076,3043,3016,2997,
2968,2947,2920,2901,2872,2851,2824,2805,2776,2756,
2740,2715,2692,2669,2644,2632,2614,2600,2584,2570,
2554,2538,2524,2496,2458,};
NODEPTR
mtAction (int _t, __match **_ll, skeleton *_s)
{ NODEPTR root = _s->root;
switch (_t) {
case 0:{

#line 28 "act2.mt"

		push(root);
	} break;
case 1:{

#line 34 "act2.mt"

	} break;
case 2:{

#line 39 "act2.mt"

	} break;
case 3:{

#line 44 "act2.mt"

		push(root);
	} break;
case 4:{

#line 50 "act2.mt"

		push(root);
	} break;
case 5:{

#line 56 "act2.mt"

		push(root);
	} break;
case 6:{

#line 62 "act2.mt"

		push(ONE);
	} break;
case 7:{

#line 68 "act2.mt"

		push(ZERO);
	} break;
case 8:{

#line 74 "act2.mt"

		tDO(_ll[(1)-1]);
	} break;
case 9:{

#line 107 "act2.mt"

		return _mtG(root,2, -1);
	} break;
case 10:{

#line 113 "act2.mt"

		return notnode(_mtG(root,2, -1));
	} break;
case 11:{

#line 127 "act2.mt"

		return nameit(root->id,ornode(andnode(notnode(_mtG(root,2,1,1, -1)),_mtG(root,2,2, -1)),andnode(_mtG(root,1,1, -1),_mtG(root,1,2, -1))));
	} break;
case 12:{

#line 134 "act2.mt"

		tDO(_ll[(1)-1]); namepin("PAD", 0);
		func(root,"INBUF",1,"Y","PAD");
	} break;
case 13:{

#line 141 "act2.mt"

		tDO(_ll[(1)-1]); namepin("PAD", 0);
		func(root,"CLKBUF",1,"Y","PAD");
	} break;
case 14:{

#line 148 "act2.mt"

		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OUTBUF",1,"PAD","D");
	} break;
case 15:{

#line 155 "act2.mt"

		tDO(_ll[(2)-1]); namepin("E", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"BIBUF",2,"PADY","D","E");
	} break;
case 16:{

#line 163 "act2.mt"

		tDO(_ll[(2)-1]); namepin("E", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"TRIBUFF",2,"PAD","D","E");
	} break;
case 17:{

#line 171 "act2.mt"

		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"INV",1,"Y","A");
	} break;
case 18:{

#line 178 "act2.mt"

		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"BUF",1,"Y","A");
	} break;
case 19:{

#line 185 "act2.mt"

		push(ONE); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("G", 0);
		func(root,"GNAND2",2,"Y","G","A");
	} break;
case 20:{

#line 193 "act2.mt"

		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"GAND2",2,"Y","A","G");
	} break;
case 21:{

#line 201 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("G", 0);
		func(root,"GAND2",2,"Y","G","A");
	} break;
case 22:{

#line 209 "act2.mt"

		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"GNAND2",2,"Y","A","G");
	} break;
case 23:{

#line 217 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("G", 0);
		func(root,"GNAND2",2,"Y","G","A");
	} break;
case 24:{

#line 225 "act2.mt"

		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"GNOR2",2,"Y","A","G");
	} break;
case 25:{

#line 233 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("G", 0);
		func(root,"GNOR2",2,"Y","G","A");
	} break;
case 26:{

#line 241 "act2.mt"

		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"GXOR2",2,"Y","A","G");
	} break;
case 27:{

#line 249 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("G", 0);
		func(root,"GXOR2",2,"Y","G","A");
	} break;
case 28:{

#line 262 "act2.mt"

		tDO(_ll[(7)-1]); namepin("D3", 0);
		tDO(_ll[(6)-1]); namepin("D2", 0);
		tDO(_ll[(4)-1]); namepin("D1", 0);
		tDO(_ll[(3)-1]); namepin("D0", 0);
		tDO(_ll[(2)-1]); namepin("S0", 0);
		tDO(_ll[(1)-1]); namepin("G", 0);
		func(root,"GMX4",6,"Y","G","S0","D0","D1","D2","D3");
	} break;
case 29:{

#line 279 "act2.mt"

		tDO(_ll[(7)-1]); namepin("D3", 0);
		tDO(_ll[(6)-1]); namepin("D1", 0);
		tDO(_ll[(4)-1]); namepin("D2", 0);
		tDO(_ll[(3)-1]); namepin("D0", 0);
		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("S0", 0);
		func(root,"GMX4",6,"Y","S0","G","D0","D2","D1","D3");
	} break;
case 30:{

#line 291 "act2.mt"

		tDO(_ll[(3)-1]); namepin("D1", 0);
		push(ONE); namepin("D2", 0);
		tDO(_ll[(3)-1]); namepin("D1", 0);
		push(ZERO); namepin("D0", 0);
		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("S0", 0);
		func(root,"GMX4",6,"Y","S0","G","D0","D1","D2","D3");
	} break;
case 31:{

#line 303 "act2.mt"

		push(ONE); namepin("D3", 0);
		tDO(_ll[(2)-1]); namepin("D0", 0);
		push(ZERO); namepin("D1", 0);
		tDO(_ll[(2)-1]); namepin("D0", 0);
		tDO(_ll[(1)-1]); namepin("S0", 0);
		func(root,"GMX4",5,"Y","S0","D0","D1","D2","D3");
	} break;
case 32:{

#line 314 "act2.mt"

		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DF1",2,"Q","D","CLK");
	} break;
case 33:{

#line 322 "act2.mt"

		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DF1B",2,"Q","D","CLK");
	} break;
case 34:{

#line 330 "act2.mt"

		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFC1B",3,"Q","D","CLK","CLR");
	} break;
case 35:{

#line 339 "act2.mt"

		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFC1D",3,"Q","D","CLK","CLR");
	} break;
case 36:{

#line 348 "act2.mt"

		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DL1",2,"Q","D","G");
	} break;
case 37:{

#line 356 "act2.mt"

		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DL1B",2,"Q","D","G");
	} break;
case 38:{

#line 364 "act2.mt"

		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DL1",2,"Q","D","G");
	} break;
case 39:{

#line 372 "act2.mt"

		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DL1B",2,"Q","D","G");
	} break;
case 40:{

#line 380 "act2.mt"

		tDO(_ll[(3)-1]); namepin("E", 0);
		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DLE",3,"Q","D","G","E");
	} break;
case 41:{

#line 389 "act2.mt"

		tDO(_ll[(3)-1]); namepin("E", 0);
		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DLEA",3,"Q","D","G","E");
	} break;
case 42:{

#line 398 "act2.mt"

		tDO(_ll[(3)-1]); namepin("E", 0);
		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DLEB",3,"Q","D","G","E");
	} break;
case 43:{

#line 407 "act2.mt"

		tDO(_ll[(3)-1]); namepin("E", 0);
		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DLEC",3,"Q","D","G","E");
	} break;
case 44:{

#line 416 "act2.mt"

		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DLC",3,"Q","D","G","CLR");
	} break;
case 45:{

#line 425 "act2.mt"

		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("G", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DLCA",3,"Q","D","G","CLR");
	} break;
case 46:{

#line 434 "act2.mt"

		tDO(_ll[(4)-1]); namepin("G", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DLM",4,"Q","S","A","B","G");
	} break;
case 47:{

#line 444 "act2.mt"

		tDO(_ll[(4)-1]); namepin("G", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DLMA",4,"Q","S","A","B","G");
	} break;
case 48:{

#line 454 "act2.mt"

		tDO(_ll[(5)-1]); namepin("E", 0);
		tDO(_ll[(4)-1]); namepin("G", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DLME1A",5,"Q","S","A","B","G","E");
	} break;
case 49:{

#line 465 "act2.mt"

		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DF1",2,"Q","D","CLK");
	} break;
case 50:{

#line 473 "act2.mt"

		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DF1A",2,"QN","D","CLK");
	} break;
case 51:{

#line 481 "act2.mt"

		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DF1B",2,"Q","D","CLK");
	} break;
case 52:{

#line 489 "act2.mt"

		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DF1C",2,"QN","D","CLK");
	} break;
case 53:{

#line 497 "act2.mt"

		tDO(_ll[(3)-1]); namepin("E", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFE",3,"Q","D","CLK","E");
	} break;
case 54:{

#line 506 "act2.mt"

		tDO(_ll[(4)-1]); namepin("PRE", 0);
		tDO(_ll[(3)-1]); namepin("E", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFE4",4,"Q","D","CLK","E","PRE");
	} break;
case 55:{

#line 516 "act2.mt"

		tDO(_ll[(4)-1]); namepin("CLR", 0);
		tDO(_ll[(3)-1]); namepin("E", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFE3A",4,"Q","D","CLK","E","CLR");
	} break;
case 56:{

#line 526 "act2.mt"

		tDO(_ll[(3)-1]); namepin("PRE", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFP1",3,"Q","D","CLK","PRE");
	} break;
case 57:{

#line 535 "act2.mt"

		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFC1",3,"Q","D","CLK","CLR");
	} break;
case 58:{

#line 544 "act2.mt"

		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFC1C",3,"QN","D","CLK","CLR");
	} break;
case 59:{

#line 553 "act2.mt"

		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFC1A",3,"Q","D","CLK","CLR");
	} break;
case 60:{

#line 562 "act2.mt"

		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFC1F",3,"QN","D","CLK","CLR");
	} break;
case 61:{

#line 571 "act2.mt"

		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFC1B",3,"Q","D","CLK","CLR");
	} break;
case 62:{

#line 580 "act2.mt"

		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFC1E",3,"QN","D","CLK","CLR");
	} break;
case 63:{

#line 589 "act2.mt"

		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFC1D",3,"Q","D","CLK","CLR");
	} break;
case 64:{

#line 598 "act2.mt"

		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFC1G",3,"QN","D","CLK","CLR");
	} break;
case 65:{

#line 607 "act2.mt"

		tDO(_ll[(4)-1]); namepin("PRE", 0);
		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFPC",4,"Q","D","CLK","CLR","PRE");
	} break;
case 66:{

#line 617 "act2.mt"

		tDO(_ll[(4)-1]); namepin("PRE", 0);
		tDO(_ll[(3)-1]); namepin("CLR", 0);
		tDO(_ll[(2)-1]); namepin("CLK", 1);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"DFPCA",4,"Q","D","CLK","CLR","PRE");
	} break;
case 67:{

#line 627 "act2.mt"

		tDO(_ll[(4)-1]); namepin("E", 0);
		tDO(_ll[(3)-1]); namepin("CLK", 1);
		tDO(_ll[(2)-1]); namepin("B", 0);
		push(ZERO); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DFME1A",5,"Q","S","A","B","CLK","E");
	} break;
case 68:{

#line 638 "act2.mt"

		tDO(_ll[(4)-1]); namepin("E", 0);
		tDO(_ll[(3)-1]); namepin("CLK", 1);
		push(ZERO); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DFME1A",5,"Q","S","A","B","CLK","E");
	} break;
case 69:{

#line 649 "act2.mt"

		tDO(_ll[(4)-1]); namepin("CLR", 0);
		tDO(_ll[(3)-1]); namepin("CLK", 1);
		tDO(_ll[(2)-1]); namepin("B", 0);
		push(ZERO); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DFM3",5,"Q","S","A","B","CLK","CLR");
	} break;
case 70:{

#line 660 "act2.mt"

		tDO(_ll[(4)-1]); namepin("PRE", 0);
		tDO(_ll[(3)-1]); namepin("CLK", 1);
		tDO(_ll[(2)-1]); namepin("B", 0);
		push(ZERO); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DFM4",5,"Q","S","A","B","CLK","PRE");
	} break;
case 71:{

#line 671 "act2.mt"

		tDO(_ll[(4)-1]); namepin("PRE", 0);
		tDO(_ll[(3)-1]); namepin("CLK", 1);
		push(ZERO); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DFM4",5,"Q","S","A","B","CLK","PRE");
	} break;
case 72:{

#line 682 "act2.mt"

		tDO(_ll[(4)-1]); namepin("PRE", 0);
		tDO(_ll[(3)-1]); namepin("CLK", 1);
		push(ONE); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DFM4",5,"Q","S","A","B","CLK","PRE");
	} break;
case 73:{

#line 693 "act2.mt"

		tDO(_ll[(5)-1]); namepin("PRE", 0);
		tDO(_ll[(4)-1]); namepin("CLK", 1);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DFM4",5,"Q","S","A","B","CLK","PRE");
	} break;
case 74:{

#line 704 "act2.mt"

		tDO(_ll[(5)-1]); namepin("CLR", 0);
		tDO(_ll[(4)-1]); namepin("CLK", 1);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DFMB",5,"Q","S","A","B","CLK","CLR");
	} break;
case 75:{

#line 715 "act2.mt"

		tDO(_ll[(5)-1]); namepin("CLR", 0);
		tDO(_ll[(4)-1]); namepin("CLK", 1);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DFM3",5,"Q","S","A","B","CLK","CLR");
	} break;
case 76:{

#line 726 "act2.mt"

		tDO(_ll[(5)-1]); namepin("E", 0);
		tDO(_ll[(4)-1]); namepin("CLK", 1);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DFME1A",5,"Q","S","A","B","CLK","E");
	} break;
case 77:{

#line 737 "act2.mt"

		tDO(_ll[(4)-1]); namepin("CLK", 1);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"DFM",4,"Q","S","A","B","CLK");
	} break;
case 78:{

#line 751 "act2.mt"

		tDO(_ll[(9)-1]); namepin("CLR", 0);
		tDO(_ll[(8)-1]); namepin("CLK", 1);
		tDO(_ll[(7)-1]); namepin("D3", 0);
		tDO(_ll[(6)-1]); namepin("D2", 0);
		tDO(_ll[(4)-1]); namepin("D1", 0);
		tDO(_ll[(3)-1]); namepin("D0", 0);
		tDO(_ll[(2)-1]); namepin("S0", 0);
		tDO(_ll[(1)-1]); namepin("S1", 0);
		func(root,"DFM6A",8,"Q","S1","S0","D0","D1","D2","D3","CLK","CLR");
	} break;
case 79:{

#line 765 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AND4",4,"Y","A","B","C","D");
	} break;
case 80:{

#line 775 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AND4",4,"Y","D","A","B","C");
	} break;
case 81:{

#line 785 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AND4A",4,"Y","A","B","C","D");
	} break;
case 82:{

#line 795 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AND4A",4,"Y","D","A","B","C");
	} break;
case 83:{

#line 805 "act2.mt"

		tDO(_ll[(5)-1]); namepin("E", 0);
		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AND5B",5,"Y","A","B","C","D","E");
	} break;
case 84:{

#line 816 "act2.mt"

		tDO(_ll[(5)-1]); namepin("D", 0);
		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("E", 0);
		func(root,"AND5B",5,"Y","E","A","B","C","D");
	} break;
case 85:{

#line 827 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"OR2B",2,"Y","B","A");
	} break;
case 86:{

#line 835 "act2.mt"

		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OR2B",2,"Y","A","B");
	} break;
case 87:{

#line 843 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OR3C",3,"Y","C","A","B");
	} break;
case 88:{

#line 852 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OR3C",3,"Y","A","B","C");
	} break;
case 89:{

#line 861 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OR4B",4,"Y","D","A","B","C");
	} break;
case 90:{

#line 871 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("D", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OR4B",4,"Y","C","D","A","B");
	} break;
case 91:{

#line 881 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OR4C",4,"Y","D","A","B","C");
	} break;
case 92:{

#line 891 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OR4C",4,"Y","D","A","B","C");
	} break;
case 93:{

#line 901 "act2.mt"

		tDO(_ll[(5)-1]); namepin("D", 0);
		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("E", 0);
		func(root,"OR5B",5,"Y","E","A","B","C","D");
	} break;
case 94:{

#line 912 "act2.mt"

		tDO(_ll[(5)-1]); namepin("B", 0);
		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("E", 0);
		tDO(_ll[(2)-1]); namepin("D", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OR5B",5,"Y","C","D","E","A","B");
	} break;
case 95:{

#line 923 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AX1",3,"Y","C","A","B");
	} break;
case 96:{

#line 932 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AX1",3,"Y","C","A","B");
	} break;
case 97:{

#line 941 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AX1C",3,"Y","C","A","B");
	} break;
case 98:{

#line 950 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AX1C",3,"Y","C","A","B");
	} break;
case 99:{

#line 959 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO2E",4,"Y","A","B","D","C");
	} break;
case 100:{

#line 969 "act2.mt"

		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO2E",4,"Y","D","C","B","A");
	} break;
case 101:{

#line 979 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO3A",4,"Y","A","B","C","D");
	} break;
case 102:{

#line 989 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO3A",4,"Y","D","C","A","B");
	} break;
case 103:{

#line 999 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("D", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AO6",4,"Y","C","D","A","B");
	} break;
case 104:{

#line 1014 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AO6",4,"Y","C","A","B","D");
	} break;
case 105:{

#line 1024 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO6A",4,"Y","D","C","A","B");
	} break;
case 106:{

#line 1039 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO6A",4,"Y","D","B","A","C");
	} break;
case 107:{

#line 1049 "act2.mt"

		tDO(_ll[(5)-1]); namepin("D", 0);
		tDO(_ll[(4)-1]); namepin("E", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO7",5,"Y","A","B","C","E","D");
	} break;
case 108:{

#line 1060 "act2.mt"

		tDO(_ll[(5)-1]); namepin("B", 0);
		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("D", 0);
		tDO(_ll[(1)-1]); namepin("E", 0);
		func(root,"AO7",5,"Y","E","D","C","A","B");
	} break;
case 109:{

#line 1071 "act2.mt"

		tDO(_ll[(5)-1]); namepin("E", 0);
		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO8",5,"Y","A","B","C","D","E");
	} break;
case 110:{

#line 1087 "act2.mt"

		tDO(_ll[(5)-1]); namepin("D", 0);
		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("E", 0);
		func(root,"AO8",5,"Y","E","C","B","A","D");
	} break;
case 111:{

#line 1098 "act2.mt"

		tDO(_ll[(5)-1]); namepin("C", 0);
		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("E", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO9",5,"Y","A","B","E","D","C");
	} break;
case 112:{

#line 1109 "act2.mt"

		tDO(_ll[(5)-1]); namepin("A", 0);
		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("D", 0);
		tDO(_ll[(1)-1]); namepin("E", 0);
		func(root,"AO9",5,"Y","E","D","C","B","A");
	} break;
case 113:{

#line 1126 "act2.mt"

		tDO(_ll[(5)-1]); namepin("E", 0);
		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO10",5,"Y","D","A","B","C","E");
	} break;
case 114:{

#line 1137 "act2.mt"

		tDO(_ll[(5)-1]); namepin("A", 0);
		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("E", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO10",5,"Y","D","E","C","B","A");
	} break;
case 115:{

#line 1148 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AOI1",3,"Y","C","B","A");
	} break;
case 116:{

#line 1157 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AOI1",3,"Y","A","B","C");
	} break;
case 117:{

#line 1166 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AOI2B",4,"Y","D","C","A","B");
	} break;
case 118:{

#line 1176 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AOI2B",4,"Y","A","B","D","C");
	} break;
case 119:{

#line 1191 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AOI4A",4,"Y","C","B","A","D");
	} break;
case 120:{

#line 1201 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("D", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AOI4A",4,"Y","C","D","A","B");
	} break;
case 121:{

#line 1211 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OA3B",4,"Y","D","C","A","B");
	} break;
case 122:{

#line 1221 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"OA3B",4,"Y","B","A","D","C");
	} break;
case 123:{

#line 1231 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OAI3",4,"Y","A","B","D","C");
	} break;
case 124:{

#line 1241 "act2.mt"

		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OAI3",4,"Y","D","C","B","A");
	} break;
case 125:{

#line 1257 "act2.mt"

		tDO(_ll[(5)-1]); namepin("C", 0);
		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"CS1",5,"Y","S","B","D","A","C");
	} break;
case 126:{

#line 1274 "act2.mt"

		tDO(_ll[(5)-1]); namepin("C", 0);
		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("S", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"CS1",5,"Y","D","S","B","A","C");
	} break;
case 127:{

#line 1290 "act2.mt"

		tDO(_ll[(4)-1]); namepin("A0", 0);
		tDO(_ll[(3)-1]); namepin("B0", 0);
		tDO(_ll[(2)-1]); namepin("B1", 0);
		tDO(_ll[(1)-1]); namepin("A1", 0);
		func(root,"CY2A",4,"Y","A1","B1","B0","A0");
	} break;
case 128:{

#line 1306 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B1", 0);
		tDO(_ll[(3)-1]); namepin("A0", 0);
		tDO(_ll[(2)-1]); namepin("B0", 0);
		tDO(_ll[(1)-1]); namepin("A1", 0);
		func(root,"CY2A",4,"Y","A1","B0","A0","B1");
	} break;
case 129:{

#line 1316 "act2.mt"

		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AND2",2,"Y","A","B");
	} break;
case 130:{

#line 1324 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"AND2",2,"Y","B","A");
	} break;
case 131:{

#line 1332 "act2.mt"

		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AND2A",2,"Y","A","B");
	} break;
case 132:{

#line 1340 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"AND2A",2,"Y","B","A");
	} break;
case 133:{

#line 1348 "act2.mt"

		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AND2B",2,"Y","A","B");
	} break;
case 134:{

#line 1356 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"AND2B",2,"Y","B","A");
	} break;
case 135:{

#line 1364 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"OR2",2,"Y","B","A");
	} break;
case 136:{

#line 1372 "act2.mt"

		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OR2",2,"Y","A","B");
	} break;
case 137:{

#line 1380 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"OR2A",2,"Y","B","A");
	} break;
case 138:{

#line 1388 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"OR2A",2,"Y","B","A");
	} break;
case 139:{

#line 1396 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AND3",3,"Y","A","B","C");
	} break;
case 140:{

#line 1405 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AND3",3,"Y","C","A","B");
	} break;
case 141:{

#line 1414 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AND3A",3,"Y","A","B","C");
	} break;
case 142:{

#line 1423 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AND3A",3,"Y","C","A","B");
	} break;
case 143:{

#line 1432 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AND3B",3,"Y","A","B","C");
	} break;
case 144:{

#line 1441 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AND3B",3,"Y","C","A","B");
	} break;
case 145:{

#line 1450 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AND3C",3,"Y","A","B","C");
	} break;
case 146:{

#line 1459 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AND3C",3,"Y","C","A","B");
	} break;
case 147:{

#line 1468 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OR3",3,"Y","C","A","B");
	} break;
case 148:{

#line 1477 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OR3",3,"Y","A","B","C");
	} break;
case 149:{

#line 1486 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OR3A",3,"Y","C","A","B");
	} break;
case 150:{

#line 1495 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"OR3A",3,"Y","B","C","A");
	} break;
case 151:{

#line 1504 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OR3B",3,"Y","C","A","B");
	} break;
case 152:{

#line 1513 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OR3B",3,"Y","C","A","B");
	} break;
case 153:{

#line 1522 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AND4B",4,"Y","A","B","C","D");
	} break;
case 154:{

#line 1532 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AND4B",4,"Y","D","A","B","C");
	} break;
case 155:{

#line 1542 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AND4C",4,"Y","A","B","C","D");
	} break;
case 156:{

#line 1552 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AND4C",4,"Y","D","A","B","C");
	} break;
case 157:{

#line 1562 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OR4",4,"Y","D","A","B","C");
	} break;
case 158:{

#line 1572 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OR4",4,"Y","A","B","C","D");
	} break;
case 159:{

#line 1582 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OR4A",4,"Y","D","A","B","C");
	} break;
case 160:{

#line 1592 "act2.mt"

		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"OR4A",4,"Y","B","C","D","A");
	} break;
case 161:{

#line 1602 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"XOR",2,"Y","B","A");
	} break;
case 162:{

#line 1610 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"XOR",2,"Y","B","A");
	} break;
case 163:{

#line 1618 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"XNOR",2,"Y","B","A");
	} break;
case 164:{

#line 1626 "act2.mt"

		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"XNOR",2,"Y","B","A");
	} break;
case 165:{

#line 1634 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"XO1",3,"Y","C","B","A");
	} break;
case 166:{

#line 1643 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"XO1",3,"Y","C","B","A");
	} break;
case 167:{

#line 1652 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"XO1A",3,"Y","C","B","A");
	} break;
case 168:{

#line 1661 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"XO1A",3,"Y","C","B","A");
	} break;
case 169:{

#line 1670 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"XA1",3,"Y","C","B","A");
	} break;
case 170:{

#line 1679 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"XA1",3,"Y","C","B","A");
	} break;
case 171:{

#line 1688 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"XA1A",3,"Y","C","B","A");
	} break;
case 172:{

#line 1697 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"XA1A",3,"Y","C","B","A");
	} break;
case 173:{

#line 1706 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AX1B",3,"Y","C","A","B");
	} break;
case 174:{

#line 1715 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AX1B",3,"Y","C","A","B");
	} break;
case 175:{

#line 1724 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO1",3,"Y","A","B","C");
	} break;
case 176:{

#line 1733 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AO1",3,"Y","C","B","A");
	} break;
case 177:{

#line 1742 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO1A",3,"Y","A","B","C");
	} break;
case 178:{

#line 1751 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AO1A",3,"Y","C","B","A");
	} break;
case 179:{

#line 1760 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO1B",3,"Y","A","B","C");
	} break;
case 180:{

#line 1769 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AO1B",3,"Y","C","A","B");
	} break;
case 181:{

#line 1778 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO1C",3,"Y","A","B","C");
	} break;
case 182:{

#line 1787 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AO1C",3,"Y","C","A","B");
	} break;
case 183:{

#line 1796 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AOI1A",3,"Y","C","B","A");
	} break;
case 184:{

#line 1805 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AOI1A",3,"Y","A","B","C");
	} break;
case 185:{

#line 1814 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AOI1B",3,"Y","C","A","B");
	} break;
case 186:{

#line 1823 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AOI1B",3,"Y","A","B","C");
	} break;
case 187:{

#line 1832 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AOI1C",3,"Y","C","B","A");
	} break;
case 188:{

#line 1841 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AOI1C",3,"Y","A","B","C");
	} break;
case 189:{

#line 1850 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AOI1D",3,"Y","C","A","B");
	} break;
case 190:{

#line 1859 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AOI1D",3,"Y","A","B","C");
	} break;
case 191:{

#line 1868 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO2",4,"Y","A","B","D","C");
	} break;
case 192:{

#line 1878 "act2.mt"

		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO2",4,"Y","D","C","B","A");
	} break;
case 193:{

#line 1888 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO2A",4,"Y","A","B","D","C");
	} break;
case 194:{

#line 1898 "act2.mt"

		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO2A",4,"Y","D","C","B","A");
	} break;
case 195:{

#line 1908 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO2B",4,"Y","A","B","D","C");
	} break;
case 196:{

#line 1918 "act2.mt"

		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO2B",4,"Y","D","C","B","A");
	} break;
case 197:{

#line 1928 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO2C",4,"Y","A","B","D","C");
	} break;
case 198:{

#line 1938 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO2C",4,"Y","D","C","A","B");
	} break;
case 199:{

#line 1948 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO2D",4,"Y","A","B","D","C");
	} break;
case 200:{

#line 1958 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO2D",4,"Y","D","C","A","B");
	} break;
case 201:{

#line 1968 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AOI2A",4,"Y","D","A","B","C");
	} break;
case 202:{

#line 1978 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AOI2A",4,"Y","A","C","D","B");
	} break;
case 203:{

#line 1988 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AOI3A",4,"Y","D","C","A","B");
	} break;
case 204:{

#line 1998 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AOI3A",4,"Y","A","B","C","D");
	} break;
case 205:{

#line 2008 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO3",4,"Y","A","B","C","D");
	} break;
case 206:{

#line 2018 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO3",4,"Y","D","C","A","B");
	} break;
case 207:{

#line 2028 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO3B",4,"Y","A","B","C","D");
	} break;
case 208:{

#line 2038 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO3B",4,"Y","D","C","A","B");
	} break;
case 209:{

#line 2048 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"AO3C",4,"Y","A","B","C","D");
	} break;
case 210:{

#line 2058 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO3C",4,"Y","D","C","A","B");
	} break;
case 211:{

#line 2068 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AO4A",4,"Y","C","A","B","D");
	} break;
case 212:{

#line 2078 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"AO4A",4,"Y","C","A","B","D");
	} break;
case 213:{

#line 2088 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO5A",4,"Y","D","A","B","C");
	} break;
case 214:{

#line 2098 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"AO5A",4,"Y","D","A","B","C");
	} break;
case 215:{

#line 2113 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"MAJ3",3,"Y","A","B","C");
	} break;
case 216:{

#line 2127 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"MAJ3",3,"Y","A","B","C");
	} break;
case 217:{

#line 2136 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OA1",3,"Y","C","A","B");
	} break;
case 218:{

#line 2145 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OA1",3,"Y","A","B","C");
	} break;
case 219:{

#line 2154 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OA1A",3,"Y","C","A","B");
	} break;
case 220:{

#line 2163 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"OA1A",3,"Y","B","A","C");
	} break;
case 221:{

#line 2172 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OA1B",3,"Y","C","B","A");
	} break;
case 222:{

#line 2181 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OA1B",3,"Y","A","B","C");
	} break;
case 223:{

#line 2190 "act2.mt"

		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OA1C",3,"Y","C","B","A");
	} break;
case 224:{

#line 2199 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("B", 0);
		func(root,"OA1C",3,"Y","B","A","C");
	} break;
case 225:{

#line 2213 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OA2",4,"Y","C","B","A","D");
	} break;
case 226:{

#line 2223 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("D", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OA2",4,"Y","C","D","A","B");
	} break;
case 227:{

#line 2238 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OA2A",4,"Y","C","B","A","D");
	} break;
case 228:{

#line 2248 "act2.mt"

		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("D", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OA2A",4,"Y","C","D","B","A");
	} break;
case 229:{

#line 2258 "act2.mt"

		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OA3",4,"Y","D","C","B","A");
	} break;
case 230:{

#line 2268 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OA3",4,"Y","A","B","D","C");
	} break;
case 231:{

#line 2278 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OA3A",4,"Y","D","C","A","B");
	} break;
case 232:{

#line 2288 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OA3A",4,"Y","A","B","D","C");
	} break;
case 233:{

#line 2298 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OA4",4,"Y","D","A","B","C");
	} break;
case 234:{

#line 2308 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OA4",4,"Y","A","B","C","D");
	} break;
case 235:{

#line 2318 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OA4A",4,"Y","D","C","A","B");
	} break;
case 236:{

#line 2328 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OA4A",4,"Y","A","B","C","D");
	} break;
case 237:{

#line 2338 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("D", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OA5",4,"Y","A","D","C","B");
	} break;
case 238:{

#line 2348 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OA5",4,"Y","A","B","C","D");
	} break;
case 239:{

#line 2358 "act2.mt"

		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OAI1",3,"Y","A","B","C");
	} break;
case 240:{

#line 2367 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("C", 0);
		func(root,"OAI1",3,"Y","C","A","B");
	} break;
case 241:{

#line 2376 "act2.mt"

		tDO(_ll[(4)-1]); namepin("D", 0);
		tDO(_ll[(3)-1]); namepin("C", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OAI2A",4,"Y","A","B","C","D");
	} break;
case 242:{

#line 2386 "act2.mt"

		tDO(_ll[(4)-1]); namepin("B", 0);
		tDO(_ll[(3)-1]); namepin("A", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OAI2A",4,"Y","D","C","A","B");
	} break;
case 243:{

#line 2396 "act2.mt"

		tDO(_ll[(4)-1]); namepin("C", 0);
		tDO(_ll[(3)-1]); namepin("D", 0);
		tDO(_ll[(2)-1]); namepin("B", 0);
		tDO(_ll[(1)-1]); namepin("A", 0);
		func(root,"OAI3A",4,"Y","A","B","D","C");
	} break;
case 244:{

#line 2406 "act2.mt"

		tDO(_ll[(4)-1]); namepin("A", 0);
		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("C", 0);
		tDO(_ll[(1)-1]); namepin("D", 0);
		func(root,"OAI3A",4,"Y","D","C","B","A");
	} break;
case 245:{

#line 2416 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"MX2",3,"Y","S","A","B");
	} break;
case 246:{

#line 2425 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"MX2",3,"Y","S","A","B");
	} break;
case 247:{

#line 2434 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"MX2A",3,"Y","S","A","B");
	} break;
case 248:{

#line 2443 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"MX2A",3,"Y","S","A","B");
	} break;
case 249:{

#line 2452 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"MX2B",3,"Y","S","A","B");
	} break;
case 250:{

#line 2461 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"MX2B",3,"Y","S","A","B");
	} break;
case 251:{

#line 2470 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"MX2C",3,"Y","S","A","B");
	} break;
case 252:{

#line 2479 "act2.mt"

		tDO(_ll[(3)-1]); namepin("B", 0);
		tDO(_ll[(2)-1]); namepin("A", 0);
		tDO(_ll[(1)-1]); namepin("S", 0);
		func(root,"MX2C",3,"Y","S","A","B");
	} break;
case 253:{

#line 2492 "act2.mt"

		tDO(_ll[(7)-1]); namepin("D3", 0);
		tDO(_ll[(6)-1]); namepin("D2", 0);
		tDO(_ll[(4)-1]); namepin("D1", 0);
		tDO(_ll[(3)-1]); namepin("D0", 0);
		tDO(_ll[(2)-1]); namepin("S0", 0);
		tDO(_ll[(1)-1]); namepin("S1", 0);
		func(root,"MX4",6,"Y","S1","S0","D0","D1","D2","D3");
	} break;
case 254:{

#line 2508 "act2.mt"

		tDO(_ll[(7)-1]); namepin("D3", 0);
		tDO(_ll[(6)-1]); namepin("D2", 0);
		tDO(_ll[(4)-1]); namepin("D1", 0);
		tDO(_ll[(3)-1]); namepin("D0", 0);
		tDO(_ll[(2)-1]); namepin("S0", 0);
		tDO(_ll[(1)-1]); namepin("S1", 0);
		func(root,"MX4",6,"Y","S1","S0","D0","D1","D2","D3");
	} break;
} return(_s->root);}
short
mtEvalCost(__match *_m, __match **_ll, skeleton *_s)
{ NODEPTR root = _s->root;
COST cost; cost = DEFAULT_COST;
switch(_m->tree) {
case 0:{

#line 27 "act2.mt"
cost = pincost;} break;
case 1:{

#line 33 "act2.mt"
} break;
case 2:{

#line 38 "act2.mt"
cost.gate -= 1;} break;
case 3:{

#line 43 "act2.mt"
cost = pincost;} break;
case 4:{

#line 49 "act2.mt"
cost = zerocost;} break;
case 5:{

#line 55 "act2.mt"
cost = zerocost;} break;
case 6:{

#line 61 "act2.mt"
cost = zerocost;} break;
case 7:{

#line 67 "act2.mt"
cost = zerocost;} break;
case 8:{

#line 73 "act2.mt"
cost.gate -= 2; TOPDOWN;} break;
case 9:{

#line 106 "act2.mt"
REWRITE;} break;
case 10:{

#line 112 "act2.mt"
REWRITE;} break;
case 11:{

#line 122 "act2.mt"

		if (_mtG(root,1,1, -1)->op == not)
			ABORT;
		REWRITE;
	} break;
case 12:{

#line 133 "act2.mt"
TOPDOWN;} break;
case 13:{

#line 140 "act2.mt"
TOPDOWN;} break;
case 14:{

#line 147 "act2.mt"
TOPDOWN;} break;
case 15:{

#line 154 "act2.mt"
TOPDOWN;} break;
case 16:{

#line 162 "act2.mt"
TOPDOWN;} break;
case 17:{

#line 170 "act2.mt"
TOPDOWN;} break;
case 18:{

#line 177 "act2.mt"
TOPDOWN;} break;
case 19:{

#line 184 "act2.mt"
cost.gate += 1000; TOPDOWN;} break;
case 20:{

#line 192 "act2.mt"
cost.gate += 1000; TOPDOWN;} break;
case 21:{

#line 200 "act2.mt"
cost.gate += 1000; TOPDOWN;} break;
case 22:{

#line 208 "act2.mt"
cost.gate += 1000; TOPDOWN;} break;
case 23:{

#line 216 "act2.mt"
cost.gate += 1000; TOPDOWN;} break;
case 24:{

#line 224 "act2.mt"
cost.gate += 1000; TOPDOWN;} break;
case 25:{

#line 232 "act2.mt"
cost.gate += 1000; TOPDOWN;} break;
case 26:{

#line 240 "act2.mt"
cost.gate += 1000; TOPDOWN;} break;
case 27:{

#line 248 "act2.mt"
cost.gate += 1000; TOPDOWN;} break;
case 28:{

#line 256 "act2.mt"

		cost.gate += 1000;
		if (!eq(_mtG(root,2,1, -1),_mtG(root,3,1, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 29:{

#line 273 "act2.mt"

		cost.gate += 1000;
		if (!eq(_mtG(root,2,1, -1),_mtG(root,3,1, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 30:{

#line 290 "act2.mt"
cost.gate += 1000; TOPDOWN;} break;
case 31:{

#line 302 "act2.mt"
cost.gate += 1000; TOPDOWN;} break;
case 32:{

#line 313 "act2.mt"
cost.gate -= 1; TOPDOWN;} break;
case 33:{

#line 321 "act2.mt"
cost.gate -= 1; TOPDOWN;} break;
case 34:{

#line 329 "act2.mt"
cost.gate -= 1; TOPDOWN;} break;
case 35:{

#line 338 "act2.mt"
cost.gate -= 1; TOPDOWN;} break;
case 36:{

#line 347 "act2.mt"
cost.gate -= 1; TOPDOWN;} break;
case 37:{

#line 355 "act2.mt"
cost.gate -= 1; TOPDOWN;} break;
case 38:{

#line 363 "act2.mt"
TOPDOWN;} break;
case 39:{

#line 371 "act2.mt"
TOPDOWN;} break;
case 40:{

#line 379 "act2.mt"
TOPDOWN;} break;
case 41:{

#line 388 "act2.mt"
TOPDOWN;} break;
case 42:{

#line 397 "act2.mt"
TOPDOWN;} break;
case 43:{

#line 406 "act2.mt"
TOPDOWN;} break;
case 44:{

#line 415 "act2.mt"
TOPDOWN;} break;
case 45:{

#line 424 "act2.mt"
TOPDOWN;} break;
case 46:{

#line 433 "act2.mt"
TOPDOWN;} break;
case 47:{

#line 443 "act2.mt"
TOPDOWN;} break;
case 48:{

#line 453 "act2.mt"
TOPDOWN;} break;
case 49:{

#line 464 "act2.mt"
TOPDOWN;} break;
case 50:{

#line 472 "act2.mt"
TOPDOWN;} break;
case 51:{

#line 480 "act2.mt"
TOPDOWN;} break;
case 52:{

#line 488 "act2.mt"
TOPDOWN;} break;
case 53:{

#line 496 "act2.mt"
TOPDOWN;} break;
case 54:{

#line 505 "act2.mt"
TOPDOWN;} break;
case 55:{

#line 515 "act2.mt"
TOPDOWN;} break;
case 56:{

#line 525 "act2.mt"
TOPDOWN;} break;
case 57:{

#line 534 "act2.mt"
TOPDOWN;} break;
case 58:{

#line 543 "act2.mt"
TOPDOWN;} break;
case 59:{

#line 552 "act2.mt"
TOPDOWN;} break;
case 60:{

#line 561 "act2.mt"
TOPDOWN;} break;
case 61:{

#line 570 "act2.mt"
TOPDOWN;} break;
case 62:{

#line 579 "act2.mt"
TOPDOWN;} break;
case 63:{

#line 588 "act2.mt"
TOPDOWN;} break;
case 64:{

#line 597 "act2.mt"
TOPDOWN;} break;
case 65:{

#line 606 "act2.mt"
TOPDOWN;} break;
case 66:{

#line 616 "act2.mt"
TOPDOWN;} break;
case 67:{

#line 626 "act2.mt"
TOPDOWN;} break;
case 68:{

#line 637 "act2.mt"
TOPDOWN;} break;
case 69:{

#line 648 "act2.mt"
TOPDOWN;} break;
case 70:{

#line 659 "act2.mt"
TOPDOWN;} break;
case 71:{

#line 670 "act2.mt"
TOPDOWN;} break;
case 72:{

#line 681 "act2.mt"
TOPDOWN;} break;
case 73:{

#line 692 "act2.mt"
TOPDOWN;} break;
case 74:{

#line 703 "act2.mt"
TOPDOWN;} break;
case 75:{

#line 714 "act2.mt"
TOPDOWN;} break;
case 76:{

#line 725 "act2.mt"
TOPDOWN;} break;
case 77:{

#line 736 "act2.mt"
TOPDOWN;} break;
case 78:{

#line 746 "act2.mt"

		if (!eq(_mtG(root,1,2,1, -1),_mtG(root,1,3,1, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 79:{

#line 764 "act2.mt"
TOPDOWN;} break;
case 80:{

#line 774 "act2.mt"
TOPDOWN;} break;
case 81:{

#line 784 "act2.mt"
TOPDOWN;} break;
case 82:{

#line 794 "act2.mt"
TOPDOWN;} break;
case 83:{

#line 804 "act2.mt"
TOPDOWN;} break;
case 84:{

#line 815 "act2.mt"
TOPDOWN;} break;
case 85:{

#line 826 "act2.mt"
TOPDOWN;} break;
case 86:{

#line 834 "act2.mt"
TOPDOWN;} break;
case 87:{

#line 842 "act2.mt"
TOPDOWN;} break;
case 88:{

#line 851 "act2.mt"
TOPDOWN;} break;
case 89:{

#line 860 "act2.mt"
TOPDOWN;} break;
case 90:{

#line 870 "act2.mt"
TOPDOWN;} break;
case 91:{

#line 880 "act2.mt"
TOPDOWN;} break;
case 92:{

#line 890 "act2.mt"
TOPDOWN;} break;
case 93:{

#line 900 "act2.mt"
TOPDOWN;} break;
case 94:{

#line 911 "act2.mt"
TOPDOWN;} break;
case 95:{

#line 922 "act2.mt"
TOPDOWN;} break;
case 96:{

#line 931 "act2.mt"
TOPDOWN;} break;
case 97:{

#line 940 "act2.mt"
TOPDOWN;} break;
case 98:{

#line 949 "act2.mt"
TOPDOWN;} break;
case 99:{

#line 958 "act2.mt"
TOPDOWN;} break;
case 100:{

#line 968 "act2.mt"
TOPDOWN;} break;
case 101:{

#line 978 "act2.mt"
TOPDOWN;} break;
case 102:{

#line 988 "act2.mt"
TOPDOWN;} break;
case 103:{

#line 998 "act2.mt"
TOPDOWN;} break;
case 104:{

#line 1008 "act2.mt"

		if (!eq(_mtG(root,1,1,2,1,1, -1),_mtG(root,1,2,2,1,1, -1)) ||
			!eq(_mtG(root,1,1,2,2,1, -1),_mtG(root,1,2,2,2,1, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 105:{

#line 1023 "act2.mt"
TOPDOWN;} break;
case 106:{

#line 1033 "act2.mt"

		if (!eq(_mtG(root,1,1,2,1,1, -1),_mtG(root,1,2,2,2,1, -1)) ||
			!eq(_mtG(root,1,1,2,2,1, -1),_mtG(root,1,2,2,1,1, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 107:{

#line 1048 "act2.mt"
TOPDOWN;} break;
case 108:{

#line 1059 "act2.mt"
TOPDOWN;} break;
case 109:{

#line 1070 "act2.mt"
TOPDOWN;} break;
case 110:{

#line 1081 "act2.mt"

		if (!eq(_mtG(root,1,2,1,2,1,1, -1),_mtG(root,1,2,2,2,1,1, -1)) ||
			!eq(_mtG(root,1,2,1,2,2,1, -1),_mtG(root,1,2,2,2,2,1, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 111:{

#line 1097 "act2.mt"
TOPDOWN;} break;
case 112:{

#line 1108 "act2.mt"
TOPDOWN;} break;
case 113:{

#line 1119 "act2.mt"

		if (!eq(_mtG(root,1,2,1,1, -1),_mtG(root,2,2,1,1, -1)) ||
			!eq(_mtG(root,1,2,1,2, -1),_mtG(root,2,2,1,2, -1)) ||
			!eq(_mtG(root,1,2,2, -1),_mtG(root,2,2,2, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 114:{

#line 1136 "act2.mt"
TOPDOWN;} break;
case 115:{

#line 1147 "act2.mt"
TOPDOWN;} break;
case 116:{

#line 1156 "act2.mt"
TOPDOWN;} break;
case 117:{

#line 1165 "act2.mt"
TOPDOWN;} break;
case 118:{

#line 1175 "act2.mt"
TOPDOWN;} break;
case 119:{

#line 1185 "act2.mt"

		if (!eq(_mtG(root,1,2,1,1, -1),_mtG(root,2,2,2,1, -1)) ||
			!eq(_mtG(root,1,2,2,1, -1),_mtG(root,2,2,1,1, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 120:{

#line 1200 "act2.mt"
TOPDOWN;} break;
case 121:{

#line 1210 "act2.mt"
TOPDOWN;} break;
case 122:{

#line 1220 "act2.mt"
TOPDOWN;} break;
case 123:{

#line 1230 "act2.mt"
TOPDOWN;} break;
case 124:{

#line 1240 "act2.mt"
TOPDOWN;} break;
case 125:{

#line 1250 "act2.mt"

		if (!eq(_mtG(root,1,1, -1),_mtG(root,2,2,2,1,1, -1)) ||
			!eq(_mtG(root,1,2,1, -1),_mtG(root,2,2,2,2,1, -1)) ||
			!eq(_mtG(root,1,2,2, -1),_mtG(root,2,3, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 126:{

#line 1267 "act2.mt"

		if (!eq(_mtG(root,1,1,1,1, -1),_mtG(root,1,2,3,1, -1)) ||
			!eq(_mtG(root,1,1,2,1, -1),_mtG(root,1,2,2,2,2,1, -1)) ||
			!eq(_mtG(root,1,1,2,2, -1),_mtG(root,1,2,2,2,1,1, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 127:{

#line 1284 "act2.mt"

		if (!eq(_mtG(root,1,1, -1),_mtG(root,2,2,2,1, -1)) ||
			!eq(_mtG(root,1,2, -1),_mtG(root,2,2,2,2, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 128:{

#line 1299 "act2.mt"

		if (!eq(_mtG(root,1,1,1,1, -1),_mtG(root,1,2,2,1,1, -1)) ||
			!eq(_mtG(root,1,1,2,1,1, -1),_mtG(root,1,2,2,2,2,1, -1)) ||
			!eq(_mtG(root,1,1,2,2,1, -1),_mtG(root,1,2,2,2,1,1, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 129:{

#line 1315 "act2.mt"
TOPDOWN;} break;
case 130:{

#line 1323 "act2.mt"
TOPDOWN;} break;
case 131:{

#line 1331 "act2.mt"
TOPDOWN;} break;
case 132:{

#line 1339 "act2.mt"
TOPDOWN;} break;
case 133:{

#line 1347 "act2.mt"
TOPDOWN;} break;
case 134:{

#line 1355 "act2.mt"
TOPDOWN;} break;
case 135:{

#line 1363 "act2.mt"
TOPDOWN;} break;
case 136:{

#line 1371 "act2.mt"
TOPDOWN;} break;
case 137:{

#line 1379 "act2.mt"
TOPDOWN;} break;
case 138:{

#line 1387 "act2.mt"
TOPDOWN;} break;
case 139:{

#line 1395 "act2.mt"
TOPDOWN;} break;
case 140:{

#line 1404 "act2.mt"
TOPDOWN;} break;
case 141:{

#line 1413 "act2.mt"
TOPDOWN;} break;
case 142:{

#line 1422 "act2.mt"
TOPDOWN;} break;
case 143:{

#line 1431 "act2.mt"
TOPDOWN;} break;
case 144:{

#line 1440 "act2.mt"
TOPDOWN;} break;
case 145:{

#line 1449 "act2.mt"
TOPDOWN;} break;
case 146:{

#line 1458 "act2.mt"
TOPDOWN;} break;
case 147:{

#line 1467 "act2.mt"
TOPDOWN;} break;
case 148:{

#line 1476 "act2.mt"
TOPDOWN;} break;
case 149:{

#line 1485 "act2.mt"
TOPDOWN;} break;
case 150:{

#line 1494 "act2.mt"
TOPDOWN;} break;
case 151:{

#line 1503 "act2.mt"
TOPDOWN;} break;
case 152:{

#line 1512 "act2.mt"
TOPDOWN;} break;
case 153:{

#line 1521 "act2.mt"
TOPDOWN;} break;
case 154:{

#line 1531 "act2.mt"
TOPDOWN;} break;
case 155:{

#line 1541 "act2.mt"
TOPDOWN;} break;
case 156:{

#line 1551 "act2.mt"
TOPDOWN;} break;
case 157:{

#line 1561 "act2.mt"
TOPDOWN;} break;
case 158:{

#line 1571 "act2.mt"
TOPDOWN;} break;
case 159:{

#line 1581 "act2.mt"
TOPDOWN;} break;
case 160:{

#line 1591 "act2.mt"
TOPDOWN;} break;
case 161:{

#line 1601 "act2.mt"
TOPDOWN;} break;
case 162:{

#line 1609 "act2.mt"
TOPDOWN;} break;
case 163:{

#line 1617 "act2.mt"
TOPDOWN;} break;
case 164:{

#line 1625 "act2.mt"
TOPDOWN;} break;
case 165:{

#line 1633 "act2.mt"
TOPDOWN;} break;
case 166:{

#line 1642 "act2.mt"
TOPDOWN;} break;
case 167:{

#line 1651 "act2.mt"
TOPDOWN;} break;
case 168:{

#line 1660 "act2.mt"
TOPDOWN;} break;
case 169:{

#line 1669 "act2.mt"
TOPDOWN;} break;
case 170:{

#line 1678 "act2.mt"
TOPDOWN;} break;
case 171:{

#line 1687 "act2.mt"
TOPDOWN;} break;
case 172:{

#line 1696 "act2.mt"
TOPDOWN;} break;
case 173:{

#line 1705 "act2.mt"
TOPDOWN;} break;
case 174:{

#line 1714 "act2.mt"
TOPDOWN;} break;
case 175:{

#line 1723 "act2.mt"
TOPDOWN;} break;
case 176:{

#line 1732 "act2.mt"
TOPDOWN;} break;
case 177:{

#line 1741 "act2.mt"
TOPDOWN;} break;
case 178:{

#line 1750 "act2.mt"
TOPDOWN;} break;
case 179:{

#line 1759 "act2.mt"
TOPDOWN;} break;
case 180:{

#line 1768 "act2.mt"
TOPDOWN;} break;
case 181:{

#line 1777 "act2.mt"
TOPDOWN;} break;
case 182:{

#line 1786 "act2.mt"
TOPDOWN;} break;
case 183:{

#line 1795 "act2.mt"
TOPDOWN;} break;
case 184:{

#line 1804 "act2.mt"
TOPDOWN;} break;
case 185:{

#line 1813 "act2.mt"
TOPDOWN;} break;
case 186:{

#line 1822 "act2.mt"
TOPDOWN;} break;
case 187:{

#line 1831 "act2.mt"
TOPDOWN;} break;
case 188:{

#line 1840 "act2.mt"
TOPDOWN;} break;
case 189:{

#line 1849 "act2.mt"
TOPDOWN;} break;
case 190:{

#line 1858 "act2.mt"
TOPDOWN;} break;
case 191:{

#line 1867 "act2.mt"
TOPDOWN;} break;
case 192:{

#line 1877 "act2.mt"
TOPDOWN;} break;
case 193:{

#line 1887 "act2.mt"
TOPDOWN;} break;
case 194:{

#line 1897 "act2.mt"
TOPDOWN;} break;
case 195:{

#line 1907 "act2.mt"
TOPDOWN;} break;
case 196:{

#line 1917 "act2.mt"
TOPDOWN;} break;
case 197:{

#line 1927 "act2.mt"
TOPDOWN;} break;
case 198:{

#line 1937 "act2.mt"
TOPDOWN;} break;
case 199:{

#line 1947 "act2.mt"
TOPDOWN;} break;
case 200:{

#line 1957 "act2.mt"
TOPDOWN;} break;
case 201:{

#line 1967 "act2.mt"
TOPDOWN;} break;
case 202:{

#line 1977 "act2.mt"
TOPDOWN;} break;
case 203:{

#line 1987 "act2.mt"
TOPDOWN;} break;
case 204:{

#line 1997 "act2.mt"
TOPDOWN;} break;
case 205:{

#line 2007 "act2.mt"
TOPDOWN;} break;
case 206:{

#line 2017 "act2.mt"
TOPDOWN;} break;
case 207:{

#line 2027 "act2.mt"
TOPDOWN;} break;
case 208:{

#line 2037 "act2.mt"
TOPDOWN;} break;
case 209:{

#line 2047 "act2.mt"
TOPDOWN;} break;
case 210:{

#line 2057 "act2.mt"
TOPDOWN;} break;
case 211:{

#line 2067 "act2.mt"
TOPDOWN;} break;
case 212:{

#line 2077 "act2.mt"
TOPDOWN;} break;
case 213:{

#line 2087 "act2.mt"
TOPDOWN;} break;
case 214:{

#line 2097 "act2.mt"
TOPDOWN;} break;
case 215:{

#line 2107 "act2.mt"

		if (!eq(_mtG(root,1,1, -1),_mtG(root,2,2,1, -1)) ||
			!eq(_mtG(root,1,2, -1),_mtG(root,2,2,2, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 216:{

#line 2121 "act2.mt"

		if (!eq(_mtG(root,1,1,1,1, -1),_mtG(root,1,2,2,2,1, -1)) ||
			!eq(_mtG(root,1,1,2,1, -1),_mtG(root,1,2,2,1,1, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 217:{

#line 2135 "act2.mt"
TOPDOWN;} break;
case 218:{

#line 2144 "act2.mt"
TOPDOWN;} break;
case 219:{

#line 2153 "act2.mt"
TOPDOWN;} break;
case 220:{

#line 2162 "act2.mt"
TOPDOWN;} break;
case 221:{

#line 2171 "act2.mt"
TOPDOWN;} break;
case 222:{

#line 2180 "act2.mt"
TOPDOWN;} break;
case 223:{

#line 2189 "act2.mt"
TOPDOWN;} break;
case 224:{

#line 2198 "act2.mt"
TOPDOWN;} break;
case 225:{

#line 2207 "act2.mt"

		if (!eq(_mtG(root,1,2,1, -1),_mtG(root,2,2,1, -1)) ||
			!eq(_mtG(root,1,2,2, -1),_mtG(root,2,2,2, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 226:{

#line 2222 "act2.mt"
TOPDOWN;} break;
case 227:{

#line 2232 "act2.mt"

		if (!eq(_mtG(root,1,2,1, -1),_mtG(root,2,2,1, -1)) ||
			!eq(_mtG(root,1,2,2,1, -1),_mtG(root,2,2,2,1, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 228:{

#line 2247 "act2.mt"
TOPDOWN;} break;
case 229:{

#line 2257 "act2.mt"
TOPDOWN;} break;
case 230:{

#line 2267 "act2.mt"
TOPDOWN;} break;
case 231:{

#line 2277 "act2.mt"
TOPDOWN;} break;
case 232:{

#line 2287 "act2.mt"
TOPDOWN;} break;
case 233:{

#line 2297 "act2.mt"
TOPDOWN;} break;
case 234:{

#line 2307 "act2.mt"
TOPDOWN;} break;
case 235:{

#line 2317 "act2.mt"
TOPDOWN;} break;
case 236:{

#line 2327 "act2.mt"
TOPDOWN;} break;
case 237:{

#line 2337 "act2.mt"
TOPDOWN;} break;
case 238:{

#line 2347 "act2.mt"
TOPDOWN;} break;
case 239:{

#line 2357 "act2.mt"
TOPDOWN;} break;
case 240:{

#line 2366 "act2.mt"
TOPDOWN;} break;
case 241:{

#line 2375 "act2.mt"
TOPDOWN;} break;
case 242:{

#line 2385 "act2.mt"
TOPDOWN;} break;
case 243:{

#line 2395 "act2.mt"
TOPDOWN;} break;
case 244:{

#line 2405 "act2.mt"
TOPDOWN;} break;
case 245:{

#line 2415 "act2.mt"
TOPDOWN;} break;
case 246:{

#line 2424 "act2.mt"
TOPDOWN;} break;
case 247:{

#line 2433 "act2.mt"
TOPDOWN;} break;
case 248:{

#line 2442 "act2.mt"
TOPDOWN;} break;
case 249:{

#line 2451 "act2.mt"
TOPDOWN;} break;
case 250:{

#line 2460 "act2.mt"
TOPDOWN;} break;
case 251:{

#line 2469 "act2.mt"
TOPDOWN;} break;
case 252:{

#line 2478 "act2.mt"
TOPDOWN;} break;
case 253:{

#line 2487 "act2.mt"

		if (!eq(_mtG(root,2,1, -1),_mtG(root,3,1, -1)))
			ABORT;
		TOPDOWN;
	} break;
case 254:{

#line 2503 "act2.mt"

		if (!eq(_mtG(root,1,2,1, -1),_mtG(root,1,3,1, -1)))
			ABORT;
		TOPDOWN;
	} break;
}
_m->cost = cost; return xDEFER;}
