/*
 * adb - common definitions
 * something of a grab-bag
 */

#include <u.h>
#include <libc.h>
#include <bio.h>
#include <ctype.h>

#include <mach.h>

typedef long WORD;
typedef ulong ADDR;

#define	HUGEINT	0x7fffffff	/* enormous WORD */

#define	MAXOFF	0x1000000
#define	INCDIR	"/usr/lib/adb"
#define	DBNAME	"db\n"
#define CMD_VERBS	"?/=>!$: \t"

typedef	int	BOOL;

#define	NVARS	36
#define MAXPOS	80
#define MAXLIN	128
#define	ARB	512
#define MAXCOM	64
#define MAXARG	32
#define LINSIZ	4096
#define	MAXSYM	255

#define EOR	'\n'
#define SPC	' '
#define TB	'\t'

#define	STDIN	0
#define	STDOUT	1

#define	TRUE	(-1)
#define	FALSE	0


/*
 * run modes
 */

#define	SINGLE	1
#define	CONTIN	2

/*
 * breakpoints
 */

#define	BKPTCLR	0	/* not a real breakpoint */
#define BKPTSET	1	/* real, ready to trap */
#define BKPTSKIP 2	/* real, skip over it next time */
#define	BKPTTMP	3	/* temporary; clear when it happens */

struct bkpt {
	ADDR	loc;
	uchar	save[4];
	int	count;
	int	initcnt;
	int	flag;
	char	comm[MAXCOM];
	struct bkpt *nxtbkpt;
};
typedef struct bkpt	BKPT;

#define	BADREG	(-1)

/*
 * common globals
 */

extern	WORD	expv, adrval;
extern	int	expsp;
extern	int	adrflg;
extern	WORD	cntval;
extern	int	cntflg;
extern	WORD	loopcnt;
extern	ADDR	maxoff;
extern	ADDR	localval;
extern	ADDR	maxfile;
extern	ADDR	maxstor;

extern	ADDR	dot;
extern	int	dotsp;
extern	WORD	dotinc;

extern	WORD	var[];

extern	int	xargc;

extern	BOOL	wtflag;
extern	char	*corfil, *symfil;
extern	int	fcor, fsym;
extern	BOOL	mkfault;
extern	BOOL	regdirty;

extern	int	pid;
extern	int	pcsactive;
#define	NNOTE 10
extern	int	nnote;
extern	char	note[NNOTE][ERRLEN];

extern	char	*errflg;
extern	int	ending;
extern	Map	*cormap, *symmap;

extern	BKPT	*bkpthead;
extern	int	dascase;
extern	int	kflag;
