#include <u.h>
#include <libc.h>
#include <libg.h>
#include <frame.h>
#include "dat.h"
#include "fns.h"

/*
 * when called, (button&mask) == mask
 */
void
pick(Frame *f, Mouse *m, int mask)
{
	ulong p0, p1, q;
	Point mp, pt0, pt1, qt;

	mp = m->xy;

    Again:
	f->modified = 0;
	frselectp(f, F&~D);
	p0 = p1 = frcharofpt(f, mp);
	pt0 = frptofchar(f, p0);
	pt1 = frptofchar(f, p1);
	frselectf(f, pt0, pt1, F&~D);
	do{
		if(f->modified)	/* special hack so 8.5 can select in parallel */
			goto Again;
		q = frcharofpt(f, m->xy);
		if(p1 != q){
			if(p0 == p1)
				frselectf(f, pt0, pt1, F&~D);
			qt = frptofchar(f, q);
			if(p1 < q)
				frselectf(f, pt1, qt, F&~D);
			else
				frselectf(f, qt, pt1, F&~D);
			p1 = q;
			pt1 = qt;
			if(p0 == p1)
				frselectf(f, pt0, pt1, F&~D);
		}
		f->modified = 0;
		if(p0 < p1)
			f->p0 = p0, f->p1 = p1;
		else
			f->p0 = p1, f->p1 = p0;
		frgetmouse();
	}while(m->buttons == mask);
}

/*
 * It is assumed in all these routines that
 * p0<=p1 and both were generated by ptofchar()
 */
void
selectf1(Frame *f, Point p0, Point p1, Fcode c)
{
	int n;
	Point q0, q1;

	p0.x--;
	p1.x--;
	q0 = p0;
	q1 = p1;
	q0.y += f->font->height;
	q1.y += f->font->height;
	n = (p1.y-p0.y)/f->font->height;
	if(f->b == 0)
		berror("selectf b==0");
	if(p0.y == f->r.max.y)
		return;
	if(n == 0){
		if(p0.x == p1.x)
			q1.x++;
		bitblt(f->b, p0, f->b, Rpt(p0, q1), c);
	}else{
		bitblt(f->b, p0, f->b, Rect(p0.x, p0.y, f->r.max.x, q0.y), c);
		if(n > 1)
			bitblt(f->b, Pt(f->r.min.x, q0.y),
				f->b, Rect(f->r.min.x, q0.y, f->r.max.x, p1.y), c);
		bitblt(f->b, Pt(f->r.min.x, p1.y),
				f->b, Rect(f->r.min.x, p1.y, q1.x, q1.y), c);
	}
}

void
outline(Frame *f, Point p0, Point p1)
{
	int n;
	Point q0, q1;
	Rectangle r;

	p0.x--;
	p1.x--;
	q0 = p0;
	q1 = p1;
	q0.y += f->font->height;
	q1.y += f->font->height;
	n = (p1.y-p0.y)/f->font->height;
	if(f->b == 0)
		berror("outline b==0");
	if(p0.y==f->r.max.y)
		return;
	if(n == 0){
		if(p0.x == p1.x)
			q1.x++;
		r = inset(Rpt(p0, q1), 1);
		bitblt(f->b, r.min, f->b, r, F&~D);
	}else{
		r = inset(Rect(p0.x, p0.y, f->r.max.x, q0.y), 1);
		bitblt(f->b, r.min, f->b, r, F&~D);
		if(n > 1){
			/* erase extra above */
			r.min.x = p0.x+1;
			r.min.y = q0.y-1;
			r.max.x = f->r.max.x-1;
			r.max.y = q0.y+1;
			bitblt(f->b, r.min, f->b, r, F&~D);
			/* main part */
			r = inset(Rect(f->r.min.x, q0.y, f->r.max.x, p1.y), 1);
			bitblt(f->b, r.min, f->b, r, F&~D);
			/* erase extra below */
			r.min.x = f->r.min.x+1;
			r.min.y = p1.y-1;
			r.max.x = q1.x-1;
			r.max.y = p1.y+1;
			bitblt(f->b, r.min, f->b, r, F&~D);
		}else{
			r.min.x = p0.x+1;
			r.min.y = p1.y-1;
			r.max.x = q1.x-1;
			r.max.y = p1.y+1;
			bitblt(f->b, r.min, f->b, r, F&~D);
		}
		r = inset(Rect(f->r.min.x, p1.y, q1.x, q1.y), 1);
		bitblt(f->b, r.min, f->b, r, F&~D);
	}
}

void
frselectf(Frame *f, Point p0, Point p1, Fcode c)
{
	Text *t;

	t = (Text*)f;
	if(c && t->outline){
		if(c != (F&~D))
			error("selectf");
		outline(f, p0, p1);
	}
	selectf1(f, p0, p1, c);
}

void
frselectp(Frame *f, Fcode c)
{
	Point pt0, pt1;

	pt0 = frptofchar(f, f->p0);
	pt1 = (f->p0==f->p1)? pt0 : frptofchar(f, f->p1);
	frselectf(f, pt0, pt1, c);
}

void
setoutline(Text *t, int g)
{
	Point pt0, pt1;

	if(t->outline == g)
		return;
	pt0 = frptofchar(t, t->p0);
	pt1 = (t->p0==t->p1)? pt0 : frptofchar(t, t->p1);
	outline(t, pt0, pt1);
	t->outline = g;
}

/* it is assumed p0<=p1 and both were generated by ptofchar() */
void
underf(Frame *f, Point p0, Point p1, Fcode c)
{
	int n;
	Point q0, q1;

	p0.x--;
	p1.x--;
	p0.y += f->font->height-1;
	p1.y += f->font->height-1;
	q0 = p0;
	q1 = p1;
	p0.y -= 2;
	p1.y -= 2;
	n = (p1.y-p0.y)/f->font->height;
	if(f->b == 0)
		berror("underf b==0");
	if(p0.y == f->r.max.y)
		return;
	if(n == 0){
		if(p0.x == p1.x)
			q1.x++;
		bitblt(f->b, p0, f->b, Rpt(p0, q1), c);
	}else{
		bitblt(f->b, p0, f->b, Rect(p0.x, p0.y, f->r.max.x, q0.y), c);
		while(n-- > 1){
			p0.y += f->font->height;
			q0.y += f->font->height;
			bitblt(f->b, Pt(f->r.min.x, p0.y),
				f->b, Rect(f->r.min.x, p0.y, f->r.max.x, q0.y), c);
		}
		bitblt(f->b, Pt(f->r.min.x, p1.y),
				f->b, Rect(f->r.min.x, p1.y, q1.x, q1.y), c);
	}
}

/*
 * when called, (button&mask) == mask
 */
void
pick2(Frame *f, Mouse *m, int mask, ulong *pp0, ulong *pp1)
{
	ulong p0, p1, q;
	Point mp, pt0, pt1, qt;

	mp = m->xy;

    Again:
	f->modified = 0;
	p0 = p1 = frcharofpt(f, mp);
	pt0 = frptofchar(f, p0);
	pt1 = frptofchar(f, p1);
	underf(f, pt0, pt1, F&~D);
	do{
		if(f->modified)	/* special hack so 8.5 can select in parallel */
			goto Again;
		q = frcharofpt(f, m->xy);
		if(p1 != q){
			if(p0 == p1)
				underf(f, pt0, pt1, F&~D);
			qt = frptofchar(f, q);
			if(p1 < q)
				underf(f, pt1, qt, F&~D);
			else
				underf(f, qt, pt1, F&~D);
			p1 = q;
			pt1 = qt;
			if(p0 == p1)
				underf(f, pt0, pt1, F&~D);
		}
		f->modified = 0;
		if(p0 < p1)
			*pp0 = p0, *pp1 = p1;
		else
			*pp0 = p1, *pp1 = p0;
		frgetmouse();
	}while(m->buttons == mask);
	pt0 = frptofchar(f, *pp0);
	pt1 = frptofchar(f, *pp1);
	underf(f, pt0, pt1, F&~D);
}
