/*
 * edge2 -- Sobel operator edge filter
 */
#include "filter.cc"
int ihypot(int, int);
void filter(unsigned char *l0, unsigned char *l1, unsigned char *l2, int nchan, int npix){
	unsigned char *op=outline;
	int v;
	npix*=nchan;
	if(npix==0) return;
	do{
		v=ihypot((l0[-nchan]+2*l0[0]+l0[nchan])
			-(l2[-nchan]+2*l2[0]+l2[nchan]),
			 (l0[-nchan]+2*l1[-nchan]+l2[-nchan])
			-(l0[ nchan]+2*l1[ nchan]+l2[ nchan]));
		*op++=v<0?0:v<256?v:255;
		l0++;
		l1++;
		l2++;
	}while(--npix!=0);
}
#define	NTABLE	10
#define	NSHIFT	21		/* NSHIFT+NTABLE==# bits in a positive int */
static int table[1<<NTABLE]={
1449,	2048,	2509,	2897,	3239,	3548,	3832,	4096,
4345,	4580,	4803,	5017,	5222,	5419,	5609,	5793,
5971,	6144,	6313,	6477,	6637,	6793,	6946,	7095,
7241,	7385,	7525,	7663,	7799,	7932,	8063,	8192,
8320,	8445,	8568,	8689,	8809,	8928,	9044,	9159,
9273,	9386,	9497,	9606,	9715,	9822,	9929,	10034,
10138,	10240,	10342,	10443,	10543,	10642,	10740,	10837,
10934,	11029,	11124,	11218,	11311,	11403,	11495,	11586,
11676,	11765,	11854,	11942,	12030,	12117,	12203,	12288,
12374,	12458,	12542,	12625,	12708,	12790,	12872,	12953,
13034,	13114,	13194,	13273,	13352,	13430,	13508,	13585,
13662,	13739,	13815,	13891,	13966,	14041,	14115,	14189,
14263,	14336,	14409,	14482,	14554,	14626,	14698,	14769,
14840,	14910,	14980,	15050,	15120,	15189,	15258,	15326,
15395,	15463,	15530,	15598,	15665,	15731,	15798,	15864,
15930,	15996,	16061,	16126,	16191,	16256,	16320,	16384,
16448,	16512,	16575,	16639,	16701,	16764,	16827,	16889,
16951,	17012,	17074,	17135,	17196,	17257,	17318,	17378,
17439,	17499,	17558,	17618,	17677,	17737,	17796,	17855,
17913,	17972,	18030,	18088,	18146,	18204,	18261,	18318,
18376,	18432,	18489,	18546,	18602,	18659,	18715,	18771,
18827,	18882,	18938,	18993,	19048,	19103,	19158,	19212,
19267,	19321,	19375,	19430,	19483,	19537,	19591,	19644,
19698,	19751,	19804,	19857,	19909,	19962,	20014,	20067,
20119,	20171,	20223,	20275,	20326,	20378,	20429,	20480,
20532,	20583,	20634,	20684,	20735,	20785,	20836,	20886,
20936,	20986,	21036,	21086,	21136,	21185,	21235,	21284,
21333,	21382,	21431,	21480,	21529,	21578,	21626,	21674,
21723,	21771,	21819,	21867,	21915,	21963,	22011,	22058,
22106,	22153,	22200,	22247,	22295,	22342,	22388,	22435,
22482,	22528,	22575,	22621,	22668,	22714,	22760,	22806,
22852,	22898,	22944,	22989,	23035,	23080,	23126,	23171,
23216,	23261,	23306,	23351,	23396,	23441,	23486,	23530,
23575,	23619,	23664,	23708,	23752,	23796,	23840,	23884,
23928,	23972,	24015,	24059,	24103,	24146,	24189,	24233,
24276,	24319,	24362,	24405,	24448,	24491,	24534,	24576,
24619,	24662,	24704,	24747,	24789,	24831,	24873,	24915,
24958,	25000,	25041,	25083,	25125,	25167,	25208,	25250,
25291,	25333,	25374,	25416,	25457,	25498,	25539,	25580,
25621,	25662,	25703,	25743,	25784,	25825,	25865,	25906,
25946,	25987,	26027,	26067,	26107,	26148,	26188,	26228,
26268,	26308,	26347,	26387,	26427,	26466,	26506,	26546,
26585,	26624,	26664,	26703,	26742,	26782,	26821,	26860,
26899,	26938,	26977,	27015,	27054,	27093,	27132,	27170,
27209,	27247,	27286,	27324,	27363,	27401,	27439,	27477,
27515,	27554,	27592,	27630,	27667,	27705,	27743,	27781,
27819,	27856,	27894,	27931,	27969,	28006,	28044,	28081,
28119,	28156,	28193,	28230,	28267,	28304,	28341,	28378,
28415,	28452,	28489,	28526,	28563,	28599,	28636,	28672,
28709,	28746,	28782,	28818,	28855,	28891,	28927,	28964,
29000,	29036,	29072,	29108,	29144,	29180,	29216,	29252,
29288,	29323,	29359,	29395,	29430,	29466,	29502,	29537,
29573,	29608,	29643,	29679,	29714,	29749,	29785,	29820,
29855,	29890,	29925,	29960,	29995,	30030,	30065,	30100,
30135,	30169,	30204,	30239,	30274,	30308,	30343,	30377,
30412,	30446,	30481,	30515,	30549,	30584,	30618,	30652,
30686,	30720,	30755,	30789,	30823,	30857,	30891,	30925,
30959,	30992,	31026,	31060,	31094,	31127,	31161,	31195,
31228,	31262,	31295,	31329,	31362,	31396,	31429,	31462,
31496,	31529,	31562,	31596,	31629,	31662,	31695,	31728,
31761,	31794,	31827,	31860,	31893,	31926,	31958,	31991,
32024,	32057,	32089,	32122,	32155,	32187,	32220,	32252,
32285,	32317,	32350,	32382,	32415,	32447,	32479,	32511,
32544,	32576,	32608,	32640,	32672,	32704,	32736,	32768,
32800,	32832,	32864,	32896,	32928,	32960,	32992,	33024,
33055,	33087,	33119,	33150,	33182,	33213,	33245,	33277,
33308,	33340,	33371,	33402,	33434,	33465,	33496,	33528,
33559,	33590,	33621,	33653,	33684,	33715,	33746,	33777,
33808,	33839,	33870,	33901,	33932,	33963,	33994,	34024,
34055,	34086,	34117,	34147,	34178,	34209,	34239,	34270,
34301,	34331,	34362,	34392,	34423,	34453,	34484,	34514,
34544,	34575,	34605,	34635,	34666,	34696,	34726,	34756,
34786,	34816,	34847,	34877,	34907,	34937,	34967,	34997,
35027,	35057,	35087,	35116,	35146,	35176,	35206,	35236,
35265,	35295,	35325,	35354,	35384,	35414,	35443,	35473,
35502,	35532,	35561,	35591,	35620,	35650,	35679,	35709,
35738,	35767,	35797,	35826,	35855,	35884,	35914,	35943,
35972,	36001,	36030,	36059,	36088,	36117,	36146,	36175,
36204,	36233,	36262,	36291,	36320,	36349,	36378,	36407,
36435,	36464,	36493,	36522,	36550,	36579,	36608,	36636,
36665,	36693,	36722,	36751,	36779,	36808,	36836,	36864,
36893,	36921,	36950,	36978,	37006,	37035,	37063,	37091,
37120,	37148,	37176,	37204,	37232,	37261,	37289,	37317,
37345,	37373,	37401,	37429,	37457,	37485,	37513,	37541,
37569,	37597,	37625,	37653,	37680,	37708,	37736,	37764,
37792,	37819,	37847,	37875,	37902,	37930,	37958,	37985,
38013,	38040,	38068,	38096,	38123,	38151,	38178,	38205,
38233,	38260,	38288,	38315,	38342,	38370,	38397,	38424,
38452,	38479,	38506,	38533,	38561,	38588,	38615,	38642,
38669,	38696,	38723,	38750,	38778,	38805,	38832,	38859,
38886,	38912,	38939,	38966,	38993,	39020,	39047,	39074,
39101,	39127,	39154,	39181,	39208,	39235,	39261,	39288,
39315,	39341,	39368,	39395,	39421,	39448,	39474,	39501,
39527,	39554,	39580,	39607,	39633,	39660,	39686,	39713,
39739,	39765,	39792,	39818,	39844,	39871,	39897,	39923,
39950,	39976,	40002,	40028,	40054,	40081,	40107,	40133,
40159,	40185,	40211,	40237,	40263,	40289,	40315,	40341,
40367,	40393,	40419,	40445,	40471,	40497,	40523,	40549,
40575,	40601,	40626,	40652,	40678,	40704,	40729,	40755,
40781,	40807,	40832,	40858,	40884,	40909,	40935,	40960,
40986,	41012,	41037,	41063,	41088,	41114,	41139,	41165,
41190,	41216,	41241,	41267,	41292,	41317,	41343,	41368,
41393,	41419,	41444,	41469,	41495,	41520,	41545,	41570,
41596,	41621,	41646,	41671,	41696,	41721,	41747,	41772,
41797,	41822,	41847,	41872,	41897,	41922,	41947,	41972,
41997,	42022,	42047,	42072,	42097,	42122,	42147,	42171,
42196,	42221,	42246,	42271,	42296,	42320,	42345,	42370,
42395,	42419,	42444,	42469,	42493,	42518,	42543,	42567,
42592,	42617,	42641,	42666,	42690,	42715,	42739,	42764,
42789,	42813,	42837,	42862,	42886,	42911,	42935,	42960,
42984,	43008,	43033,	43057,	43082,	43106,	43130,	43155,
43179,	43203,	43227,	43252,	43276,	43300,	43324,	43348,
43373,	43397,	43421,	43445,	43469,	43493,	43517,	43542,
43566,	43590,	43614,	43638,	43662,	43686,	43710,	43734,
43758,	43782,	43806,	43830,	43854,	43877,	43901,	43925,
43949,	43973,	43997,	44021,	44044,	44068,	44092,	44116,
44140,	44163,	44187,	44211,	44234,	44258,	44282,	44306,
44329,	44353,	44376,	44400,	44424,	44447,	44471,	44494,
44518,	44542,	44565,	44589,	44612,	44636,	44659,	44683,
44706,	44729,	44753,	44776,	44800,	44823,	44847,	44870,
44893,	44917,	44940,	44963,	44987,	45010,	45033,	45056,
45080,	45103,	45126,	45149,	45173,	45196,	45219,	45242,
45265,	45289,	45312,	45335,	45358,	45381,	45404,	45427,
45450,	45473,	45497,	45520,	45543,	45566,	45589,	45612,
45635,	45658,	45681,	45703,	45726,	45749,	45772,	45795,
45818,	45841,	45864,	45887,	45910,	45932,	45955,	45978,
46001,	46024,	46046,	46069,	46092,	46115,	46137,	46160,
46183,	46205,	46228,	46251,	46274,	46296,	46319,	46341,
};
int ihypot(int a, int b){
	register x, y;
	a=a*a+b*b;
	if(a<=0)return(0);
/*	for(y=a,x=1;y!=0;y>>=2,x<<=1); */
	x=table[a>>NSHIFT];
	while((y=(a/x+x)>>1)<x)x=y;
	return(x);
}
