#include <u.h>
#include <libc.h>
#include <../boot/boot.h>

static char diskname[2*NAMELEN];
static char *disk;

/*
 *  This is complete black magic to guess what physical disk the file
 *  system is on.  The reason for all the variation is because the
 *  info comes in totally different forms from each type of system.
 */
void
configlocal(Method *mp)
{
	char *p;
	int n;

	if(*sys == '/' || *sys == '#'){
		/*
		 *  if the user specifies the disk in the boot cmd or
		 * 'root is from' prompt, use it
		 */
		disk = sys;
	} else if(strncmp(argv0, "dksc(0,", 7) == 0){
		/*
		 *  on many mips arg0 of the boot command specifies the
		 *  scsi logical unit number
		 */
		p = strchr(argv0, ',');
		n = strtoul(p+1, 0, 10);
		sprint(diskname, "#w%d/sd%dfs", n, n);
		disk = diskname;
	} else if(mp->arg){
		/*
		 *  a default is supplied when the kernel is made
		 */
		disk = mp->arg;
	} else if(*bootdisk){
		/*
		 *  an environment variable from a pc's plan9.ini or
		 *  from the mips nvram or generated by the kernel
		 *  is the last resort.
		 */
		disk = bootdisk;
	}

	/* if we've decided on one, pass it on to all programs */
	if(disk)
		setenv("bootdisk", disk);

	USED(mp);
}

int
authlocal(void)
{
	return -1;
}

int
connectlocal(void)
{
	int p[2];
	char d[DIRLEN];
	char partition[2*NAMELEN];
	char *args[16], **argp;
	char *dfl;

	dfl = "/fs";

	sprint(partition, "%sfs", disk);
	if(stat(partition, d) < 0){
		strcpy(partition, disk);
		if(stat(partition, d) < 0) {
			return -1;
		}
	}

	print("fs...");
	if(bind("#c", "/dev", MREPL) < 0)
		fatal("bind #c");
	if(bind("#p", "/proc", MREPL) < 0)
		fatal("bind #p");
	if(pipe(p)<0)
		fatal("pipe");
	switch(fork()){
	case -1:
		fatal("fork");
	case 0:
		dup(p[0], 0);
		dup(p[1], 1);
		close(p[0]);
		close(p[1]);
		argp = args;
		*argp++ = "fs";
		*argp++ = "-f";
		*argp++ = partition;
		*argp++ = "-s";
		*argp = 0;
		exec(dfl, args);
		fatal("can't exec fs");
	default:
		break;
	}

	close(p[1]);
	return p[0];
}
