#include <u.h>
#include <libc.h>
#include <bio.h>

#define	GSHORT(p)	((p)[0]|((p)[1]<<8))

void	mkbytes(uchar*, int, int, int, int);

/*
 * In `enhanced color mode', the 4-bit EGA pixel is mapped through
 * the 16 palette registers to one of 64 possible bytes:  xxrgbrgb
 * (msb...lsb, but the less significant color bits are in the more
 * significant bits of the byte.)  Rgbpalette maps these into the
 * standard Plan 9 color map.
 */
uchar rgbpalette[64] = {
	0x00, 0x02, 0x14, 0x16, 0xa0, 0xa2, 0xb4, 0xb6,
	0x01, 0x03, 0x15, 0x17, 0xa1, 0xa3, 0xb5, 0xb7,
	0x0c, 0x0e, 0x1c, 0x1e, 0xac, 0xae, 0xbc, 0xbe,
	0x0d, 0x0f, 0x1d, 0x1f, 0xad, 0xaf, 0xbd, 0xbf,
	0x60, 0x62, 0x74, 0x76, 0xe0, 0xe2, 0xf4, 0xf6,
	0x61, 0x63, 0x75, 0x77, 0xe1, 0xe3, 0xf5, 0xf7,
	0x6c, 0x6e, 0x7c, 0x7e, 0xec, 0xee, 0xfc, 0xfe,
	0x6d, 0x6f, 0x7d, 0x7f, 0xed, 0xef, 0xfd, 0xff,
};

uchar stdp9cmap[256][3] = {
	0x00,0x00,0x00, 0x00,0x00,0x55, 0x00,0x00,0xaa, 0x00,0x00,0xff,
	0x00,0x25,0x00, 0x00,0x25,0x55, 0x00,0x25,0xaa, 0x00,0x25,0xff,
	0x00,0x49,0x00, 0x00,0x49,0x55, 0x00,0x49,0xaa, 0x00,0x49,0xff,
	0x00,0x6e,0x00, 0x00,0x6e,0x55, 0x00,0x6e,0xaa, 0x00,0x6e,0xff,
	0x00,0x92,0x00, 0x00,0x92,0x55, 0x00,0x92,0xaa, 0x00,0x92,0xff,
	0x00,0xb7,0x00, 0x00,0xb7,0x55, 0x00,0xb7,0xaa, 0x00,0xb7,0xff,
	0x00,0xdb,0x00, 0x00,0xdb,0x55, 0x00,0xdb,0xaa, 0x00,0xdb,0xff,
	0x00,0xff,0x00, 0x00,0xff,0x55, 0x00,0xff,0xaa, 0x00,0xff,0xff,
	0x25,0x00,0x00, 0x25,0x00,0x55, 0x25,0x00,0xaa, 0x25,0x00,0xff,
	0x25,0x25,0x00, 0x25,0x25,0x55, 0x25,0x25,0xaa, 0x25,0x25,0xff,
	0x25,0x49,0x00, 0x25,0x49,0x55, 0x25,0x49,0xaa, 0x25,0x49,0xff,
	0x25,0x6e,0x00, 0x25,0x6e,0x55, 0x25,0x6e,0xaa, 0x25,0x6e,0xff,
	0x25,0x92,0x00, 0x25,0x92,0x55, 0x25,0x92,0xaa, 0x25,0x92,0xff,
	0x25,0xb7,0x00, 0x25,0xb7,0x55, 0x25,0xb7,0xaa, 0x25,0xb7,0xff,
	0x25,0xdb,0x00, 0x25,0xdb,0x55, 0x25,0xdb,0xaa, 0x25,0xdb,0xff,
	0x25,0xff,0x00, 0x25,0xff,0x55, 0x25,0xff,0xaa, 0x25,0xff,0xff,
	0x49,0x00,0x00, 0x49,0x00,0x55, 0x49,0x00,0xaa, 0x49,0x00,0xff,
	0x49,0x25,0x00, 0x49,0x25,0x55, 0x49,0x25,0xaa, 0x49,0x25,0xff,
	0x49,0x49,0x00, 0x49,0x49,0x55, 0x49,0x49,0xaa, 0x49,0x49,0xff,
	0x49,0x6e,0x00, 0x49,0x6e,0x55, 0x49,0x6e,0xaa, 0x49,0x6e,0xff,
	0x49,0x92,0x00, 0x49,0x92,0x55, 0x49,0x92,0xaa, 0x49,0x92,0xff,
	0x49,0xb7,0x00, 0x55,0x55,0x55, 0x49,0xb7,0xaa, 0x49,0xb7,0xff,
	0x49,0xdb,0x00, 0x49,0xdb,0x55, 0x49,0xdb,0xaa, 0x49,0xdb,0xff,
	0x49,0xff,0x00, 0x49,0xff,0x55, 0x49,0xff,0xaa, 0x49,0xff,0xff,
	0x6e,0x00,0x00, 0x6e,0x00,0x55, 0x6e,0x00,0xaa, 0x6e,0x00,0xff,
	0x6e,0x25,0x00, 0x6e,0x25,0x55, 0x6e,0x25,0xaa, 0x6e,0x25,0xff,
	0x6e,0x49,0x00, 0x6e,0x49,0x55, 0x6e,0x49,0xaa, 0x6e,0x49,0xff,
	0x6e,0x6e,0x00, 0x6e,0x6e,0x55, 0x6e,0x6e,0xaa, 0x6e,0x6e,0xff,
	0x6e,0x92,0x00, 0x6e,0x92,0x55, 0x6e,0x92,0xaa, 0x6e,0x92,0xff,
	0x6e,0xb7,0x00, 0x6e,0xb7,0x55, 0x6e,0xb7,0xaa, 0x6e,0xb7,0xff,
	0x6e,0xdb,0x00, 0x6e,0xdb,0x55, 0x6e,0xdb,0xaa, 0x6e,0xdb,0xff,
	0x6e,0xff,0x00, 0x6e,0xff,0x55, 0x6e,0xff,0xaa, 0x6e,0xff,0xff,
	0x92,0x00,0x00, 0x92,0x00,0x55, 0x92,0x00,0xaa, 0x92,0x00,0xff,
	0x92,0x25,0x00, 0x92,0x25,0x55, 0x92,0x25,0xaa, 0x92,0x25,0xff,
	0x92,0x49,0x00, 0x92,0x49,0x55, 0x92,0x49,0xaa, 0x92,0x49,0xff,
	0x92,0x6e,0x00, 0x92,0x6e,0x55, 0x92,0x6e,0xaa, 0x92,0x6e,0xff,
	0x92,0x92,0x00, 0x92,0x92,0x55, 0x92,0x92,0xaa, 0x92,0x92,0xff,
	0x92,0xb7,0x00, 0x92,0xb7,0x55, 0x92,0xb7,0xaa, 0x92,0xb7,0xff,
	0x92,0xdb,0x00, 0x92,0xdb,0x55, 0x92,0xdb,0xaa, 0x92,0xdb,0xff,
	0x92,0xff,0x00, 0x92,0xff,0x55, 0x92,0xff,0xaa, 0x92,0xff,0xff,
	0xb7,0x00,0x00, 0xb7,0x00,0x55, 0xb7,0x00,0xaa, 0xb7,0x00,0xff,
	0xb7,0x25,0x00, 0xb7,0x25,0x55, 0xb7,0x25,0xaa, 0xb7,0x25,0xff,
	0xb7,0x49,0x00, 0xb7,0x49,0x55, 0xaa,0xaa,0xaa, 0xb7,0x49,0xff,
	0xb7,0x6e,0x00, 0xb7,0x6e,0x55, 0xb7,0x6e,0xaa, 0xb7,0x6e,0xff,
	0xb7,0x92,0x00, 0xb7,0x92,0x55, 0xb7,0x92,0xaa, 0xb7,0x92,0xff,
	0xb7,0xb7,0x00, 0xb7,0xb7,0x55, 0xb7,0xb7,0xaa, 0xb7,0xb7,0xff,
	0xb7,0xdb,0x00, 0xb7,0xdb,0x55, 0xb7,0xdb,0xaa, 0xb7,0xdb,0xff,
	0xb7,0xff,0x00, 0xb7,0xff,0x55, 0xb7,0xff,0xaa, 0xb7,0xff,0xff,
	0xdb,0x00,0x00, 0xdb,0x00,0x55, 0xdb,0x00,0xaa, 0xdb,0x00,0xff,
	0xdb,0x25,0x00, 0xdb,0x25,0x55, 0xdb,0x25,0xaa, 0xdb,0x25,0xff,
	0xdb,0x49,0x00, 0xdb,0x49,0x55, 0xdb,0x49,0xaa, 0xdb,0x49,0xff,
	0xdb,0x6e,0x00, 0xdb,0x6e,0x55, 0xdb,0x6e,0xaa, 0xdb,0x6e,0xff,
	0xdb,0x92,0x00, 0xdb,0x92,0x55, 0xdb,0x92,0xaa, 0xdb,0x92,0xff,
	0xdb,0xb7,0x00, 0xdb,0xb7,0x55, 0xdb,0xb7,0xaa, 0xdb,0xb7,0xff,
	0xdb,0xdb,0x00, 0xdb,0xdb,0x55, 0xdb,0xdb,0xaa, 0xdb,0xdb,0xff,
	0xdb,0xff,0x00, 0xdb,0xff,0x55, 0xdb,0xff,0xaa, 0xdb,0xff,0xff,
	0xff,0x00,0x00, 0xff,0x00,0x55, 0xff,0x00,0xaa, 0xff,0x00,0xff,
	0xff,0x25,0x00, 0xff,0x25,0x55, 0xff,0x25,0xaa, 0xff,0x25,0xff,
	0xff,0x49,0x00, 0xff,0x49,0x55, 0xff,0x49,0xaa, 0xff,0x49,0xff,
	0xff,0x6e,0x00, 0xff,0x6e,0x55, 0xff,0x6e,0xaa, 0xff,0x6e,0xff,
	0xff,0x92,0x00, 0xff,0x92,0x55, 0xff,0x92,0xaa, 0xff,0x92,0xff,
	0xff,0xb7,0x00, 0xff,0xb7,0x55, 0xff,0xb7,0xaa, 0xff,0xb7,0xff,
	0xff,0xdb,0x00, 0xff,0xdb,0x55, 0xff,0xdb,0xaa, 0xff,0xdb,0xff,
	0xff,0xff,0x00, 0xff,0xff,0x55, 0xff,0xff,0xaa, 0xff,0xff,0xff,
};

int	debug;
char *	infile;
Biobuf *in;
uchar	hdr[128];
int	palette[16];
int	rgbmap[16];
Biobuf *out;

void
main(int argc, char **argv)
{
	uchar *inrow, *outrow, *ip, *op;
	int i, width, height, wd2, wd8, x, y;
	char **cmd = argv;
	char *name=0;

	ARGBEGIN{
	default:
		fprint(2, "Usage: %s [-n name] [-D] [file]\n", argv0);
		exits("usage");
	case 'n':
		name=ARGF();
		break;
	case 'D':
		++debug;
		break;
	}ARGEND
	if(argc == 0)
		infile = "/fd/0";
	else
		infile = argv[0];
	in = Bopen(infile, OREAD);
	if(in == 0){
		fprint(2, "%s: can't open %s: %r\n", argv0, infile);
		exits("open");
	}
	out = Bopen("/fd/1", OWRITE);
	if(out == 0){
		fprint(2, "%s: can't open /fd/1: %r\n", argv0, infile);
		exits("open");
	}
	Bread(in, hdr, sizeof hdr);
	width = GSHORT(&hdr[0]);
	height = GSHORT(&hdr[2]);
	for(i=0; i<16; i++){
		x = hdr[16+2*i];
		palette[i] = x;
		rgbmap[i] = rgbpalette[x&0x3f];
	}
	Bprint(out, "TYPE=dump\nWINDOW=0 0 %d %d\n", width, height);
	Bprint(out, "NCHAN=1\nCHAN=m\nCOMMAND=%s", *cmd++);
	while(*cmd)
		Bprint(out, " %s", *cmd++);
	if(name) Bprint(out, "NAME=%s\n", name);
	else if(argc>1) Bprint(out, "NAME=%s\n", argv[0]);
	Bprint(out, "\nCMAP=\n\n");
	Bwrite(out, stdp9cmap, sizeof stdp9cmap);
	wd8 = (width+7)/8;
	wd2 = 4*wd8;
	inrow = malloc(wd2);
	outrow = malloc(width);
	if(inrow == 0 || outrow == 0){
		fprint(2, "%s: no memory, width=%d\n", argv0, width);
		exits("malloc");
	}
	if(debug){
		fprint(2, "width=%d, height=%d\n", width, height);
		fprint(2, "palette=");
		for(i=0; i<16; i++)
			fprint(2, " %.2ux", palette[i]);
		fprint(2, "\nrgbmap =");
		for(i=0; i<16; i++)
			fprint(2, " %.2ux", rgbmap[i]);
		fprint(2, "\n");
	}
	for(y=0; y<height; y++){
		Bread(in, inrow, wd2);
		ip = inrow;
		op = outrow;
		for(x=0; x<width; x+=8, op+=8, ip++)
			mkbytes(op, ip[0], ip[wd8], ip[2*wd8], ip[3*wd8]);
		Bwrite(out, outrow, width);
	}
	exits(0);
}

void
mkbytes(uchar *p, int n0, int n1, int n2, int n3)
{
	long mask, c;

	for(mask=0x80; mask; mask>>=1){
		c = 0;
		if(n0&mask)
			c |= 1;
		if(n1&mask)
			c |= 2;
		if(n2&mask)
			c |= 4;
		if(n3&mask)
			c |= 8;
		*p++ = rgbmap[c];
	}
}
