#include "all.h"
#include "io.h"
#include "mem.h"

enum {
	Paddr=		0x70,	/* address port */
	Pdata=		0x71,	/* data port */

	Seconds=	0x00,
	Minutes=	0x02,
	Hours=		0x04, 
	Mday=		0x07,
	Month=		0x08,
	Year=		0x09,
	Status=		0x0A,

	Nbcd=		6,
};

#define GETBCD(o) ((bcdclock[o]&0xf) + 10*(bcdclock[o]>>4))

long	 
rtctime(void)
{
	uchar bcdclock[Nbcd];
	Rtc rtc;
	int i;

	for(i = 0; i < 10000; i++){
		outb(Paddr, Status);
		if((inb(Pdata) & 1) == 0)
			break;
	}
	outb(Paddr, Seconds);	bcdclock[0] = inb(Pdata);
	outb(Paddr, Minutes);	bcdclock[1] = inb(Pdata);
	outb(Paddr, Hours);	bcdclock[2] = inb(Pdata);
	outb(Paddr, Mday);	bcdclock[3] = inb(Pdata);
	outb(Paddr, Month);	bcdclock[4] = inb(Pdata);
	outb(Paddr, Year);	bcdclock[5] = inb(Pdata);

	/*
	 *  convert from BCD
	 */
	rtc.sec = GETBCD(0);
	rtc.min = GETBCD(1);
	rtc.hour = GETBCD(2);
	rtc.mday = GETBCD(3);
	rtc.mon = GETBCD(4);
	rtc.year = GETBCD(5);

	/*
	 *  the world starts jan 1 1970
	 */
	if(rtc.year < 70)
		rtc.year += 2000;
	else
		rtc.year += 1900;
	return rtc2sec(&rtc);
}

uchar
nvramread(int offset)
{
	outb(Paddr, offset);
	return inb(Pdata);
}
