#include	"type.h"

ushort	hyptab[128+2];

long
ihyp(long x, long y)
{
	Fract f, a, b;
	int i;

	if(x < 0)
		x = -x;
	if(y < 0)
		y = -y;
	if(x > y)
		f = fdiv(y, x);
	else
		f = fdiv(x, y);
	i = f >> 8;
	a = hyptab[i];
	b = a - hyptab[i+1];
	i = f & 0377;
	a -= (unsigned)(b*i + 128) >> 8;
	return fmul(x+y, a);
}

ushort	hyptab[128+2] =
{
	32767,	32515,	32268,	32026,	31791,	31560,	31335,	31115,	30901,
	30691,	30486,	30286,	30091,	29900,	29714,	29532,	29354,	29180,
	29011,	28845,	28684,	28526,	28372,	28222,	28075,	27932,	27792,
	27655,	27522,	27392,	27266,	27142,	27021,	26903,	26789,	26677,
	26567,	26461,	26357,	26256,	26157,	26060,	25967,	25875,	25786,
	25699,	25615,	25532,	25452,	25374,	25297,	25223,	25151,	25081,
	25013,	24946,	24881,	24818,	24757,	24697,	24640,	24583,	24529,
	24475,	24424,	24374,	24325,	24278,	24232,	24187,	24144,	24102,
	24062,	24022,	23984,	23947,	23911,	23877,	23843,	23811,	23779,
	23749,	23720,	23692,	23664,	23638,	23613,	23588,	23564,	23542,
	23520,	23499,	23479,	23459,	23441,	23423,	23406,	23389,	23374,
	23359,	23345,	23331,	23318,	23306,	23294,	23283,	23273,	23263,
	23254,	23245,	23237,	23229,	23222,	23215,	23209,	23204,	23198,
	23194,	23190,	23186,	23183,	23180,	23177,	23175,	23173,	23172,
	23171,	23171,	23170,	23170,
};
