#include <u.h>
#include <libc.h>

/*
 * some lines commented 4APE have been changed to
 * make them the same as plan9 error messages.  This is not
 * a problem for native programs but those built on APE
 * will give unhelpful errors if this is not done
 */

static struct {
	char	*msg;
	int	err;
} NTerrs[] = {
	{ "success",					0x0 },
	{ "wait 1",					0x1 },
	{ "wait 2",					0x2 },
	{ "wait 3",					0x3 },
	{ "wait 63",					0x3f },
	{ "abandoned",					0x80 },
	{ "abandoned wait 63",				0xbf },
	{ "user apc",					0xc0 },
	{ "kernel apc",					0x100 },
	{ "alerted",					0x101 },
	{ "timeout",					0x102 },
	{ "pending",					0x103 },
	{ "reparse",					0x104 },
	{ "more entries",				0x105 },
	{ "not all assigned",				0x106 },
	{ "some not mapped",				0x107 },
	{ "oplock break in progress",			0x108 },
	{ "volume mounted",				0x109 },
	{ "rxact committed",				0x10a },
	{ "notify cleanup",				0x10b },
	{ "notify enum dir",				0x10c },
	{ "no quotas for account",			0x10d },
	{ "primary transport connect failed",		0x10e },
	{ "page fault transition",			0x110 },
	{ "page fault demand zero",			0x111 },
	{ "page fault copy on write",			0x112 },
	{ "page fault guard page",			0x113 },
	{ "page fault paging file",			0x114 },
	{ "cache page locked",				0x115 },
	{ "crash dump",					0x116 },
	{ "buffer all zeros",				0x117 },
	{ "reparse object",				0x118 },
	{ "resource requirements changed",		0x119 },
	{ "translation complete",			0x120 },
	{ "ds membership evaluated locally",		0x121 },
	{ "nothing to terminate",			0x122 },
	{ "process not in job",				0x123 },
	{ "process in job",				0x124 },
	{ "wait for oplock",				0x367 },
	{ "object name exists",				0x40000000 },
	{ "thread was suspended",			0x40000001 },
	{ "working set limit range",			0x40000002 },
	{ "image not at base",				0x40000003 },
	{ "rxact state created",			0x40000004 },
	{ "segment notification",			0x40000005 },
	{ "local user session key",			0x40000006 },
	{ "bad current directory",			0x40000007 },
	{ "serial more writes",				0x40000008 },
	{ "registry recovered",				0x40000009 },
	{ "ft read recovery from backup",		0x4000000a },
	{ "ft write recovery",				0x4000000b },
	{ "serial counter timeout",			0x4000000c },
	{ "null LM password",				0x4000000d },
	{ "image machine type mismatch",		0x4000000e },
	{ "receive partial",				0x4000000f },
	{ "receive expedited",				0x40000010 },
	{ "receive partial expedited",			0x40000011 },
	{ "event done",					0x40000012 },
	{ "event pending",				0x40000013 },
	{ "checking file system",			0x40000014 },
	{ "fatal app exit",				0x40000015 },
	{ "predefined handle",				0x40000016 },
	{ "was unlocked",				0x40000017 },
	{ "service notification",			0x40000018 },
	{ "was locked",					0x40000019 },
	{ "log hard error",				0x4000001a },
	{ "already win32",				0x4000001b },
	{ "wx86 unsimulate",				0x4000001c },
	{ "wx86 continue",				0x4000001d },
	{ "wx86 single step",				0x4000001e },
	{ "wx86 breakpoint",				0x4000001f },
	{ "wx86 exception continue",			0x40000020 },
	{ "wx86 exception lastchance",			0x40000021 },
	{ "wx86 exception chain",			0x40000022 },
	{ "image machine type mismatch exe",		0x40000023 },
	{ "no yield performed",				0x40000024 },
	{ "timer resume ignored",			0x40000025 },
	{ "arbitration unhandled",			0x40000026 },
	{ "cardbus not supported",			0x40000027 },
	{ "wx86 createwx86tib",				0x40000028 },
	{ "MP processor mismatch",			0x40000029 },
	{ "hibernated",					0x4000002a },
	{ "resume hibernation",				0x4000002b },
	{ "wake system",				0x40000294 },
	{ "ds shutting down",				0x40000370 },
	{ "CTX cdm connect",				0x400a0004 },
	{ "CTX cdm disconnect",				0x400a0005 },
	{ "SXS release activation context",		0x4015000d },
	{ "guard page violation",			0x80000001 },
	{ "datatype misalignment",			0x80000002 },
	{ "breakpoint",					0x80000003 },
	{ "single step",				0x80000004 },
	{ "buffer overflow",				0x80000005 },
	{ "no more files",				0x80000006 },
	{ "wake system debugger",			0x80000007 },
	{ "handles closed",				0x8000000a },
	{ "no inheritance",				0x8000000b },
	{ "GUID substitution made",			0x8000000c },
	{ "partial copy",				0x8000000d },
	{ "device paper empty",				0x8000000e },
	{ "device powered off",				0x8000000f },
	{ "device off line",				0x80000010 },
	{ "device busy",				0x80000011 },
	{ "no more EAs",				0x80000012 },
	{ "invalid EA name",				0x80000013 },
	{ "ea list inconsistent",			0x80000014 },
	{ "invalid ea flag",				0x80000015 },
	{ "verify required",				0x80000016 },
	{ "extraneous information",			0x80000017 },
	{ "rxact commit necessary",			0x80000018 },
	{ "no more entries",				0x8000001a },
	{ "filemark detected",				0x8000001b },
	{ "media changed",				0x8000001c },
	{ "bus reset",					0x8000001d },
	{ "end of media",				0x8000001e },
	{ "beginning of media",				0x8000001f },
	{ "media check",				0x80000020 },
	{ "setmark detected",				0x80000021 },
	{ "no data detected",				0x80000022 },
	{ "redirector has open handles",		0x80000023 },
	{ "server has open handles",			0x80000024 },
	{ "already disconnected",			0x80000025 },
	{ "longjump",					0x80000026 },
	{ "cleaner cartridge installed",		0x80000027 },
	{ "plugplay query vetoed",			0x80000028 },
	{ "unwind consolidate",				0x80000029 },
	{ "device requires cleaning",			0x80000288 },
	{ "device door open",				0x80000289 },
	{ "cluster node already up",			0x80130001 },
	{ "cluster node already down",			0x80130002 },
	{ "cluster network already online",		0x80130003 },
	{ "cluster network already offline",		0x80130004 },
	{ "cluster node already member",		0x80130005 },
	{ "unsuccessful",				0xc0000001 },
	{ "not implemented",				0xc0000002 },
	{ "invalid info class",				0xc0000003 },
	{ "info length mismatch",			0xc0000004 },
	{ "access violation",				0xc0000005 },
	{ "in page error",				0xc0000006 },
	{ "pagefile quota",				0xc0000007 },
	{ "invalid handle",				0xc0000008 },
	{ "bad initial stack",				0xc0000009 },
	{ "bad initial PC",				0xc000000a },
	{ "invalid CID",				0xc000000b },
	{ "timer not canceled",				0xc000000c },
	{ "invalid parameter",				0xc000000d },
	{ "no such device",				0xc000000e },
	{ "no such file",				0xc000000f },
	{ "invalid device request",			0xc0000010 },
	{ "end of file",				0xc0000011 },
	{ "wrong volume",				0xc0000012 },
	{ "no media in device",				0xc0000013 },
	{ "unrecognized media",				0xc0000014 },
	{ "nonexistent sector",				0xc0000015 },
	{ "more processing required",			0xc0000016 },
	{ "no memory",					0xc0000017 },
	{ "conflicting addresses",			0xc0000018 },
	{ "not mapped view",				0xc0000019 },
	{ "unable to free VM",				0xc000001a },
	{ "unable to delete section",			0xc000001b },
	{ "invalid system service",			0xc000001c },
	{ "illegal instruction",			0xc000001d },
	{ "invalid lock sequence",			0xc000001e },
	{ "invalid view size",				0xc000001f },
	{ "invalid file for section",			0xc0000020 },
	{ "already committed",				0xc0000021 },
	{ "permission denied",				0xc0000022 },
//4APE	{ "access denied",				0xc0000022 },
	{ "buffer too small",				0xc0000023 },
	{ "object type mismatch",			0xc0000024 },
	{ "noncontinuable exception",			0xc0000025 },
	{ "invalid disposition",			0xc0000026 },
	{ "unwind",					0xc0000027 },
	{ "bad stack",					0xc0000028 },
	{ "invalid unwind target",			0xc0000029 },
	{ "not locked",					0xc000002a },
	{ "parity error",				0xc000002b },
	{ "unable to decommit VM",			0xc000002c },
	{ "not committed",				0xc000002d },
	{ "invalid port attributes",			0xc000002e },
	{ "port message too long",			0xc000002f },
	{ "invalid parameter mix",			0xc0000030 },
	{ "invalid quota lower",			0xc0000031 },
	{ "disk corrupt error",				0xc0000032 },
	{ "file name syntax",				0xc0000033 },
//4APE	{ "object name invalid",			0xc0000033 },
	{ "does not exist",				0xc0000034 },
//4APE	{ "object name not found",			0xc0000034 },
	{ "create -- file exists",			0xc0000035 },
//4APE	{ "object name collision",			0xc0000035 },
	{ "port disconnected",				0xc0000037 },
	{ "device already attached",			0xc0000038 },
	{ "does not exist",				0xc0000039 },
//4APE	{ "object path invalid",			0xc0000039 },
	{ "does not exist",				0xc000003a },
//4APE	{ "object path not found",			0xc000003a },
	{ "file name syntax",				0xc000003b },
//4APE	{ "object path syntax bad",			0xc000003b },
	{ "data overrun",				0xc000003c },
	{ "data late error",				0xc000003d },
	{ "data error",					0xc000003e },
	{ "crc error",					0xc000003f },
	{ "section too big",				0xc0000040 },
	{ "port connection refused",			0xc0000041 },
	{ "invalid port handle",			0xc0000042 },
	{ "sharing violation",				0xc0000043 },
	{ "quota exceeded",				0xc0000044 },
	{ "invalid page protection",			0xc0000045 },
	{ "mutant not owned",				0xc0000046 },
	{ "semaphore limit exceeded",			0xc0000047 },
	{ "port already set",				0xc0000048 },
	{ "section not image",				0xc0000049 },
	{ "suspend count exceeded",			0xc000004a },
	{ "thread is terminating",			0xc000004b },
	{ "bad working set limit",			0xc000004c },
	{ "incompatible file map",			0xc000004d },
	{ "section protection",				0xc000004e },
	{ "EAs not supported",				0xc000004f },
	{ "EA too large",				0xc0000050 },
	{ "nonexistent ea entry",			0xc0000051 },
	{ "no EAs on file",				0xc0000052 },
	{ "EA corrupt error",				0xc0000053 },
	{ "file lock conflict",				0xc0000054 },
	{ "lock not granted",				0xc0000055 },
	{ "delete pending",				0xc0000056 },
	{ "ctl file not supported",			0xc0000057 },
	{ "unknown revision",				0xc0000058 },
	{ "revision mismatch",				0xc0000059 },
	{ "invalid owner",				0xc000005a },
	{ "invalid primary group",			0xc000005b },
	{ "no impersonation token",			0xc000005c },
	{ "cant disable mandatory",			0xc000005d },
	{ "no logon servers",				0xc000005e },
	{ "no such logon session",			0xc000005f },
	{ "no such privilege",				0xc0000060 },
	{ "privilege not held",				0xc0000061 },
	{ "invalid account name",			0xc0000062 },
	{ "user exists",				0xc0000063 },
	{ "no such user",				0xc0000064 },
	{ "group exists",				0xc0000065 },
	{ "no such group",				0xc0000066 },
	{ "member in group",				0xc0000067 },
	{ "member not in group",			0xc0000068 },
	{ "last admin",					0xc0000069 },
	{ "wrong password",				0xc000006a },
	{ "ill-formed password",			0xc000006b },
	{ "password restriction",			0xc000006c },
	{ "logon failure",				0xc000006d },
	{ "account restriction",			0xc000006e },
	{ "invalid logon hours",			0xc000006f },
	{ "invalid workstation",			0xc0000070 },
	{ "password expired",				0xc0000071 },
	{ "account disabled",				0xc0000072 },
	{ "none mapped",				0xc0000073 },
	{ "too many luids requested",			0xc0000074 },
	{ "luids exhausted",				0xc0000075 },
	{ "invalid sub authority",			0xc0000076 },
	{ "invalid ACL",				0xc0000077 },
	{ "invalid SID",				0xc0000078 },
	{ "invalid security descr",			0xc0000079 },
	{ "procedure not found",			0xc000007a },
	{ "invalid image format",			0xc000007b },
	{ "no token",					0xc000007c },
	{ "bad inheritance ACL",			0xc000007d },
	{ "range not locked",				0xc000007e },
	{ "disk full",					0xc000007f },
	{ "server disabled",				0xc0000080 },
	{ "server not disabled",			0xc0000081 },
	{ "too many guids requested",			0xc0000082 },
	{ "guids exhausted",				0xc0000083 },
	{ "invalid id authority",			0xc0000084 },
	{ "agents exhausted",				0xc0000085 },
	{ "invalid volume label",			0xc0000086 },
	{ "section not extended",			0xc0000087 },
	{ "not mapped data",				0xc0000088 },
	{ "resource data not found",			0xc0000089 },
	{ "resource type not found",			0xc000008a },
	{ "resource name not found",			0xc000008b },
	{ "array bounds exceeded",			0xc000008c },
	{ "float denormal operand",			0xc000008d },
	{ "float divide by zero",			0xc000008e },
	{ "float inexact result",			0xc000008f },
	{ "float invalid operation",			0xc0000090 },
	{ "float overflow",				0xc0000091 },
	{ "float stack check",				0xc0000092 },
	{ "float underflow",				0xc0000093 },
	{ "integer divide by zero",			0xc0000094 },
	{ "integer overflow",				0xc0000095 },
	{ "privileged instruction",			0xc0000096 },
	{ "too many paging files",			0xc0000097 },
	{ "file invalid",				0xc0000098 },
	{ "allotted space exceeded",			0xc0000099 },
	{ "insufficient resources",			0xc000009a },
	{ "dfs exit path found",			0xc000009b },
	{ "device data error",				0xc000009c },
	{ "device not connected",			0xc000009d },
	{ "device power failure",			0xc000009e },
	{ "free VM not at base",			0xc000009f },
	{ "memory not allocated",			0xc00000a0 },
	{ "working set quota",				0xc00000a1 },
	{ "media write protected",			0xc00000a2 },
	{ "device not ready",				0xc00000a3 },
	{ "invalid group attributes",			0xc00000a4 },
	{ "bad impersonation level",			0xc00000a5 },
	{ "cant open anonymous",			0xc00000a6 },
	{ "bad validation class",			0xc00000a7 },
	{ "bad token type",				0xc00000a8 },
	{ "bad master boot record",			0xc00000a9 },
	{ "instruction misalignment",			0xc00000aa },
	{ "instance not available",			0xc00000ab },
	{ "pipe not available",				0xc00000ac },
	{ "invalid pipe state",				0xc00000ad },
	{ "pipe busy",					0xc00000ae },
	{ "illegal function",				0xc00000af },
	{ "pipe disconnected",				0xc00000b0 },
	{ "pipe closing",				0xc00000b1 },
	{ "pipe connected",				0xc00000b2 },
	{ "pipe listening",				0xc00000b3 },
	{ "invalid read mode",				0xc00000b4 },
	{ "IO timeout",					0xc00000b5 },
	{ "file forced closed",				0xc00000b6 },
	{ "profiling not started",			0xc00000b7 },
	{ "profiling not stopped",			0xc00000b8 },
	{ "could not interpret",			0xc00000b9 },
	{ "file is a directory",			0xc00000ba },
	{ "not supported",				0xc00000bb },
	{ "remote not listening",			0xc00000bc },
	{ "duplicate name",				0xc00000bd },
	{ "bad network path",				0xc00000be },
	{ "network busy",				0xc00000bf },
	{ "device does not exist",			0xc00000c0 },
	{ "too many commands",				0xc00000c1 },
	{ "adapter hardware error",			0xc00000c2 },
	{ "invalid network response",			0xc00000c3 },
	{ "unexpected network error",			0xc00000c4 },
	{ "bad remote adapter",				0xc00000c5 },
	{ "print queue full",				0xc00000c6 },
	{ "no spool space",				0xc00000c7 },
	{ "print cancelled",				0xc00000c8 },
	{ "network name deleted",			0xc00000c9 },
	{ "network access denied",			0xc00000ca },
	{ "bad device type",				0xc00000cb },
	{ "bad network name",				0xc00000cc },
	{ "too many names",				0xc00000cd },
	{ "too many sessions",				0xc00000ce },
	{ "sharing paused",				0xc00000cf },
	{ "request not accepted",			0xc00000d0 },
	{ "redirector paused",				0xc00000d1 },
	{ "net write fault",				0xc00000d2 },
	{ "profiling at limit",				0xc00000d3 },
	{ "not same device",				0xc00000d4 },
	{ "file renamed",				0xc00000d5 },
	{ "virtual circuit closed",			0xc00000d6 },
	{ "no security on object",			0xc00000d7 },
	{ "cant wait",					0xc00000d8 },
	{ "pipe empty",					0xc00000d9 },
	{ "cant access domain info",			0xc00000da },
	{ "cant terminate self",			0xc00000db },
	{ "invalid server state",			0xc00000dc },
	{ "invalid domain state",			0xc00000dd },
	{ "invalid domain role",			0xc00000de },
	{ "no such domain",				0xc00000df },
	{ "domain exists",				0xc00000e0 },
	{ "domain limit exceeded",			0xc00000e1 },
	{ "oplock not granted",				0xc00000e2 },
	{ "invalid oplock protocol",			0xc00000e3 },
	{ "internal DB corruption",			0xc00000e4 },
	{ "internal error",				0xc00000e5 },
	{ "generic not mapped",				0xc00000e6 },
	{ "bad descriptor format",			0xc00000e7 },
	{ "invalid user buffer",			0xc00000e8 },
	{ "unexpected io error",			0xc00000e9 },
	{ "unexpected MM create err",			0xc00000ea },
	{ "unexpected MM map error",			0xc00000eb },
	{ "unexpected MM extend err",			0xc00000ec },
	{ "not logon process",				0xc00000ed },
	{ "logon session exists",			0xc00000ee },
	{ "invalid parameter 1",			0xc00000ef },
	{ "invalid parameter 2",			0xc00000f0 },
	{ "invalid parameter 3",			0xc00000f1 },
	{ "invalid parameter 4",			0xc00000f2 },
	{ "invalid parameter 5",			0xc00000f3 },
	{ "invalid parameter 6",			0xc00000f4 },
	{ "invalid parameter 7",			0xc00000f5 },
	{ "invalid parameter 8",			0xc00000f6 },
	{ "invalid parameter 9",			0xc00000f7 },
	{ "invalid parameter 10",			0xc00000f8 },
	{ "invalid parameter 11",			0xc00000f9 },
	{ "invalid parameter 12",			0xc00000fa },
	{ "redirector not started",			0xc00000fb },
	{ "redirector started",				0xc00000fc },
	{ "stack overflow",				0xc00000fd },
	{ "no such package",				0xc00000fe },
	{ "bad function table",				0xc00000ff },
	{ "variable not found",				0xc0000100 },
	{ "directory not empty",			0xc0000101 },
	{ "file corrupt error",				0xc0000102 },
	{ "not a directory",				0xc0000103 },
	{ "bad logon session state",			0xc0000104 },
	{ "logon session collision",			0xc0000105 },
	{ "name too long",				0xc0000106 },
	{ "files open",					0xc0000107 },
	{ "connection in use",				0xc0000108 },
	{ "message not found",				0xc0000109 },
	{ "process is terminating",			0xc000010a },
	{ "invalid logon type",				0xc000010b },
	{ "no guid translation",			0xc000010c },
	{ "cannot impersonate",				0xc000010d },
	{ "image already loaded",			0xc000010e },
	{ "abios not present",				0xc000010f },
	{ "abios lid not exist",			0xc0000110 },
	{ "abios lid already owned",			0xc0000111 },
	{ "abios not lid owner",			0xc0000112 },
	{ "abios invalid command",			0xc0000113 },
	{ "abios invalid lid",				0xc0000114 },
	{ "abios selector not available",		0xc0000115 },
	{ "abios invalid selector",			0xc0000116 },
	{ "no LDT",					0xc0000117 },
	{ "invalid LDT size",				0xc0000118 },
	{ "invalid LDT offset",				0xc0000119 },
	{ "invalid LDT descriptor",			0xc000011a },
	{ "invalid image NE format",			0xc000011b },
	{ "rxact invalid state",			0xc000011c },
	{ "rxact commit failure",			0xc000011d },
	{ "mapped file size zero",			0xc000011e },
	{ "too many opened files",			0xc000011f },
	{ "cancelled",					0xc0000120 },
	{ "permission denied",				0xc0000121 },
//	{ "cannot delete",				0xc0000121 },
	{ "invalid computer name",			0xc0000122 },
	{ "file deleted",				0xc0000123 },
	{ "special account",				0xc0000124 },
	{ "special group",				0xc0000125 },
	{ "special user",				0xc0000126 },
	{ "members primary group",			0xc0000127 },
	{ "file closed",				0xc0000128 },
	{ "too many threads",				0xc0000129 },
	{ "thread not in process",			0xc000012a },
	{ "token already in use",			0xc000012b },
	{ "pagefile quota exceeded",			0xc000012c },
	{ "commitment limit",				0xc000012d },
	{ "invalid image le format",			0xc000012e },
	{ "invalid image not MZ",			0xc000012f },
	{ "invalid image protect",			0xc0000130 },
	{ "invalid image win 16",			0xc0000131 },
	{ "logon server conflict",			0xc0000132 },
	{ "time difference at DC",			0xc0000133 },
	{ "synchronization required",			0xc0000134 },
	{ "DLL not found",				0xc0000135 },
	{ "open failed",				0xc0000136 },
	{ "IO privilege failed",			0xc0000137 },
	{ "ordinal not found",				0xc0000138 },
	{ "entrypoint not found",			0xc0000139 },
	{ "control-C exit",				0xc000013a },
	{ "local disconnect",				0xc000013b },
	{ "remote disconnect",				0xc000013c },
	{ "remote resources",				0xc000013d },
	{ "link failed",				0xc000013e },
	{ "link timeout",				0xc000013f },
	{ "invalid connection",				0xc0000140 },
	{ "invalid address",				0xc0000141 },
	{ "DLL init failed",				0xc0000142 },
	{ "missing systemfile",				0xc0000143 },
	{ "unhandled exception",			0xc0000144 },
	{ "application init failure",			0xc0000145 },
	{ "pagefile create failed",			0xc0000146 },
	{ "no pagefile",				0xc0000147 },
	{ "invalid level",				0xc0000148 },
	{ "wrong password core",			0xc0000149 },
	{ "illegal float context",			0xc000014a },
	{ "pipe broken",				0xc000014b },
	{ "registry corrupt",				0xc000014c },
	{ "registry io failed",				0xc000014d },
	{ "no event pair",				0xc000014e },
	{ "unrecognized volume",			0xc000014f },
	{ "serial no device inited",			0xc0000150 },
	{ "no such alias",				0xc0000151 },
	{ "member not in alias",			0xc0000152 },
	{ "member in alias",				0xc0000153 },
	{ "alias exists",				0xc0000154 },
	{ "logon not granted",				0xc0000155 },
	{ "too many secrets",				0xc0000156 },
	{ "secret too long",				0xc0000157 },
	{ "internal db error",				0xc0000158 },
	{ "fullscreen mode",				0xc0000159 },
	{ "too many context IDs",			0xc000015a },
	{ "logon type not granted",			0xc000015b },
	{ "not registry file",				0xc000015c },
	{ "NT cross encryption required",		0xc000015d },
	{ "domain ctrlr config error",			0xc000015e },
	{ "ft missing member",				0xc000015f },
	{ "ill formed service entry",			0xc0000160 },
	{ "illegal character",				0xc0000161 },
	{ "unmappable character",			0xc0000162 },
	{ "undefined character",			0xc0000163 },
	{ "floppy volume",				0xc0000164 },
	{ "floppy id mark not found",			0xc0000165 },
	{ "floppy wrong cylinder",			0xc0000166 },
	{ "floppy unknown error",			0xc0000167 },
	{ "floppy bad registers",			0xc0000168 },
	{ "disk recalibrate failed",			0xc0000169 },
	{ "disk operation failed",			0xc000016a },
	{ "disk reset failed",				0xc000016b },
	{ "shared IRQ busy",				0xc000016c },
	{ "FT orphaning",				0xc000016d },
	{ "BIOS failed to connect interrupt",		0xc000016e },
	{ "partition failure",				0xc0000172 },
	{ "invalid block length",			0xc0000173 },
	{ "device not partitioned",			0xc0000174 },
	{ "unable to lock media",			0xc0000175 },
	{ "unable to unload media",			0xc0000176 },
	{ "eom overflow",				0xc0000177 },
	{ "no media",					0xc0000178 },
	{ "no such member",				0xc000017a },
	{ "invalid member",				0xc000017b },
	{ "key deleted",				0xc000017c },
	{ "no log space",				0xc000017d },
	{ "too many SIDs",				0xc000017e },
	{ "LM cross encryption required",		0xc000017f },
	{ "key has children",				0xc0000180 },
	{ "child must be volatile",			0xc0000181 },
	{ "device configuration error",			0xc0000182 },
	{ "driver internal error",			0xc0000183 },
	{ "invalid device state",			0xc0000184 },
	{ "io device error",				0xc0000185 },
	{ "device protocol error",			0xc0000186 },
	{ "backup controller",				0xc0000187 },
	{ "log file full",				0xc0000188 },
	{ "too late",					0xc0000189 },
	{ "no trust LSA secret",			0xc000018a },
	{ "no trust SAM account",			0xc000018b },
	{ "trusted domain failure",			0xc000018c },
	{ "trusted relationship failure",		0xc000018d },
	{ "eventlog file corrupt",			0xc000018e },
	{ "eventlog cant start",			0xc000018f },
	{ "trust failure",				0xc0000190 },
	{ "mutant limit exceeded",			0xc0000191 },
	{ "netlogon not started",			0xc0000192 },
	{ "account expired",				0xc0000193 },
	{ "possible deadlock",				0xc0000194 },
	{ "network credential conflict",		0xc0000195 },
	{ "remote session limit",			0xc0000196 },
	{ "eventlog file changed",			0xc0000197 },
	{ "nologon interdomain trust account",		0xc0000198 },
	{ "nologon workstation trust account",		0xc0000199 },
	{ "nologon server trust account",		0xc000019a },
	{ "domain trust inconsistent",			0xc000019b },
	{ "fs driver required",				0xc000019c },
	{ "no user session key",			0xc0000202 },
	{ "user session deleted",			0xc0000203 },
	{ "resource lang not found",			0xc0000204 },
	{ "insuff server resources",			0xc0000205 },
	{ "invalid buffer size",			0xc0000206 },
	{ "invalid address component",			0xc0000207 },
	{ "invalid address wildcard",			0xc0000208 },
	{ "too many addresses",				0xc0000209 },
	{ "address already exists",			0xc000020a },
	{ "address closed",				0xc000020b },
	{ "connection disconnected",			0xc000020c },
	{ "connection reset",				0xc000020d },
	{ "too many nodes",				0xc000020e },
	{ "transaction aborted",			0xc000020f },
	{ "transaction timed out",			0xc0000210 },
	{ "transaction no release",			0xc0000211 },
	{ "transaction no match",			0xc0000212 },
	{ "transaction responded",			0xc0000213 },
	{ "transaction invalid id",			0xc0000214 },
	{ "transaction invalid type",			0xc0000215 },
	{ "not server session",				0xc0000216 },
	{ "not client session",				0xc0000217 },
	{ "cannot load registry file",			0xc0000218 },
	{ "debug attach failed",			0xc0000219 },
	{ "system process terminated",			0xc000021a },
	{ "data not accepted",				0xc000021b },
	{ "no browser servers found",			0xc000021c },
	{ "VDM hard error",				0xc000021d },
	{ "driver cancel timeout",			0xc000021e },
	{ "reply message mismatch",			0xc000021f },
	{ "mapped alignment",				0xc0000220 },
	{ "image checksum mismatch",			0xc0000221 },
	{ "lost writebehind data",			0xc0000222 },
	{ "client server parameters invalid",		0xc0000223 },
	{ "password must change",			0xc0000224 },
	{ "not found",					0xc0000225 },
	{ "not tiny stream",				0xc0000226 },
	{ "recovery failure",				0xc0000227 },
	{ "stack overflow read",			0xc0000228 },
	{ "fail check",					0xc0000229 },
	{ "duplicate objectid",				0xc000022a },
	{ "objectid exists",				0xc000022b },
	{ "convert to large",				0xc000022c },
	{ "retry",					0xc000022d },
	{ "found out of scope",				0xc000022e },
	{ "allocate bucket",				0xc000022f },
	{ "propset not found",				0xc0000230 },
	{ "marshall overflow",				0xc0000231 },
	{ "invalid variant",				0xc0000232 },
	{ "domain controller not found",		0xc0000233 },
	{ "account locked out",				0xc0000234 },
	{ "handle not closable",			0xc0000235 },
	{ "connection refused",				0xc0000236 },
	{ "graceful disconnect",			0xc0000237 },
	{ "address already associated",			0xc0000238 },
	{ "address not associated",			0xc0000239 },
	{ "connection invalid",				0xc000023a },
	{ "connection active",				0xc000023b },
	{ "network unreachable",			0xc000023c },
	{ "host unreachable",				0xc000023d },
	{ "protocol unreachable",			0xc000023e },
	{ "port unreachable",				0xc000023f },
	{ "request aborted",				0xc0000240 },
	{ "connection aborted",				0xc0000241 },
	{ "bad compression buffer",			0xc0000242 },
	{ "user mapped file",				0xc0000243 },
	{ "audit failed",				0xc0000244 },
	{ "timer resolution not set",			0xc0000245 },
	{ "connection count limit",			0xc0000246 },
	{ "login time restriction",			0xc0000247 },
	{ "login wkstation restriction",		0xc0000248 },
	{ "image mp up mismatch",			0xc0000249 },
	{ "insufficient logon info",			0xc0000250 },
	{ "bad DLL entrypoint",				0xc0000251 },
	{ "bad service entrypoint",			0xc0000252 },
	{ "lpc reply lost",				0xc0000253 },
	{ "IP address conflict1",			0xc0000254 },
	{ "IP address conflict2",			0xc0000255 },
	{ "registry quota limit",			0xc0000256 },
	{ "path not covered",				0xc0000257 },
	{ "no callback active",				0xc0000258 },
	{ "license quota exceeded",			0xc0000259 },
	{ "password too short",				0xc000025a },
	{ "password too recent",			0xc000025b },
	{ "password history conflict",			0xc000025c },
	{ "plugplay no device",				0xc000025e },
	{ "unsupported compression",			0xc000025f },
	{ "invalid hw profile",				0xc0000260 },
	{ "invalid plugplay device path",		0xc0000261 },
	{ "driver ordinal not found",			0xc0000262 },
	{ "driver entrypoint not found",		0xc0000263 },
	{ "resource not owned",				0xc0000264 },
	{ "too many links",				0xc0000265 },
	{ "quota list inconsistent",			0xc0000266 },
	{ "file is offline",				0xc0000267 },
	{ "evaluation expiration",			0xc0000268 },
	{ "illegal DLL relocation",			0xc0000269 },
	{ "license violation",				0xc000026a },
	{ "DLL init failed logoff",			0xc000026b },
	{ "driver unable to load",			0xc000026c },
	{ "dfs unavailable",				0xc000026d },
	{ "volume dismounted",				0xc000026e },
	{ "wx86 internal error",			0xc000026f },
	{ "wx86 float stack check",			0xc0000270 },
	{ "validate continue",				0xc0000271 },
	{ "no match",					0xc0000272 },
	{ "no more matches",				0xc0000273 },
	{ "not a reparse point",			0xc0000275 },
	{ "IO reparse tag invalid",			0xc0000276 },
	{ "IO reparse tag mismatch",			0xc0000277 },
	{ "IO reparse data invalid",			0xc0000278 },
	{ "IO reparse tag not handled",			0xc0000279 },
	{ "reparse point not resolved",			0xc0000280 },
	{ "directory is a reparse point",		0xc0000281 },
	{ "range list conflict",			0xc0000282 },
	{ "source element empty",			0xc0000283 },
	{ "destination element full",			0xc0000284 },
	{ "illegal element address",			0xc0000285 },
	{ "magazine not present",			0xc0000286 },
	{ "reinitialization needed",			0xc0000287 },
	{ "encryption failed",				0xc000028a },
	{ "decryption failed",				0xc000028b },
	{ "range not found",				0xc000028c },
	{ "no recovery policy",				0xc000028d },
	{ "no EFS",					0xc000028e },
	{ "wrong EFS",					0xc000028f },
	{ "no user keys",				0xc0000290 },
	{ "file not encrypted",				0xc0000291 },
	{ "not export format",				0xc0000292 },
	{ "file encrypted",				0xc0000293 },
	{ "WMI guid not found",				0xc0000295 },
	{ "WMI instance not found",			0xc0000296 },
	{ "WMI itemid not found",			0xc0000297 },
	{ "WMI try again",				0xc0000298 },
	{ "shared policy",				0xc0000299 },
	{ "policy object not found",			0xc000029a },
	{ "policy only in DS",				0xc000029b },
	{ "volume not upgraded",			0xc000029c },
	{ "remote storage not active",			0xc000029d },
	{ "remote storage media error",			0xc000029e },
	{ "no tracking service",			0xc000029f },
	{ "server SID mismatch",			0xc00002a0 },
	{ "DS no attribute or value",			0xc00002a1 },
	{ "DS invalid attribute syntax",		0xc00002a2 },
	{ "DS attribute type undefined",		0xc00002a3 },
	{ "DS attribute or value exists",		0xc00002a4 },
	{ "DS busy",					0xc00002a5 },
	{ "DS unavailable",				0xc00002a6 },
	{ "DS no RIDs allocated",			0xc00002a7 },
	{ "DS no more RIDs",				0xc00002a8 },
	{ "DS incorrect role owner",			0xc00002a9 },
	{ "DS ridmgr init error",			0xc00002aa },
	{ "DS obj class violation",			0xc00002ab },
	{ "DS cant on non leaf",			0xc00002ac },
	{ "DS cant on RDN",				0xc00002ad },
	{ "DS cant mod obj class",			0xc00002ae },
	{ "DS cross dom move failed",			0xc00002af },
	{ "DS GC not available",			0xc00002b0 },
	{ "directory service required",			0xc00002b1 },
	{ "reparse attribute conflict",			0xc00002b2 },
	{ "cant enable deny only",			0xc00002b3 },
	{ "float multiple faults",			0xc00002b4 },
	{ "float multiple traps",			0xc00002b5 },
	{ "device removed",				0xc00002b6 },
	{ "journal delete in progress",			0xc00002b7 },
	{ "journal not active",				0xc00002b8 },
	{ "nointerface",				0xc00002b9 },
	{ "DS admin limit exceeded",			0xc00002c1 },
	{ "driver failed sleep",			0xc00002c2 },
	{ "mutual authentication failed",		0xc00002c3 },
	{ "corrupt system file",			0xc00002c4 },
	{ "datatype misalignment error",		0xc00002c5 },
	{ "WMI read only",				0xc00002c6 },
	{ "WMI set failure",				0xc00002c7 },
	{ "commitment minimum",				0xc00002c8 },
	{ "reg NAT consumption",			0xc00002c9 },
	{ "transport full",				0xc00002ca },
	{ "DS SAM init failure",			0xc00002cb },
	{ "only if connected",				0xc00002cc },
	{ "DS sensitive group violation",		0xc00002cd },
	{ "PNP restart enumeration",			0xc00002ce },
	{ "journal entry deleted",			0xc00002cf },
	{ "DS cant mod primarygroupid",			0xc00002d0 },
	{ "system image bad signature",			0xc00002d1 },
	{ "PNP reboot required",			0xc00002d2 },
	{ "power state invalid",			0xc00002d3 },
	{ "DS invalid group type",			0xc00002d4 },
	{ "DS no nest globalgroup in mixeddomain",	0xc00002d5 },
	{ "DS no nest localgroup in mixeddomain",	0xc00002d6 },
	{ "DS global can't have local member",		0xc00002d7 },
	{ "DS global can't have universal member",	0xc00002d8 },
	{ "DS universal can't have local member",	0xc00002d9 },
	{ "DS global can't have crossdomain member",	0xc00002da },
	{ "DS local can't have crossdomain local member",0xc00002db },
	{ "DS have primary members",			0xc00002dc },
	{ "WMI not supported",				0xc00002dd },
	{ "insufficient power",				0xc00002de },
	{ "SAM need bootkey password",			0xc00002df },
	{ "SAM need bootkey floppy",			0xc00002e0 },
	{ "DS cant start",				0xc00002e1 },
	{ "DS init failure",				0xc00002e2 },
	{ "SAM init failure",				0xc00002e3 },
	{ "DS gc required",				0xc00002e4 },
	{ "DS local member of local only",		0xc00002e5 },
	{ "DS no FPO in universal groups",		0xc00002e6 },
	{ "DS machine account quota exceeded",		0xc00002e7 },
	{ "multiple fault violation",			0xc00002e8 },
	{ "current domain not allowed",			0xc00002e9 },
	{ "cannot make",				0xc00002ea },
	{ "system shutdown",				0xc00002eb },
	{ "DS init failure console",			0xc00002ec },
	{ "DS sam init failure console",		0xc00002ed },
	{ "unfinished context deleted",			0xc00002ee },
	{ "no TGT reply",				0xc00002ef },
	{ "objectid not found",				0xc00002f0 },
	{ "no IP addresses",				0xc00002f1 },
	{ "wrong credential handle",			0xc00002f2 },
	{ "crypto system invalid",			0xc00002f3 },
	{ "max referrals exceeded",			0xc00002f4 },
	{ "must be kdc",				0xc00002f5 },
	{ "strong crypto not supported",		0xc00002f6 },
	{ "too many principals",			0xc00002f7 },
	{ "no PA data",					0xc00002f8 },
	{ "pkinit name mismatch",			0xc00002f9 },
	{ "smartcard logon required",			0xc00002fa },
	{ "KDC invalid request",			0xc00002fb },
	{ "KDC unable to refer",			0xc00002fc },
	{ "KDC unknown etype",				0xc00002fd },
	{ "shutdown in progress",			0xc00002fe },
	{ "server shutdown in progress",		0xc00002ff },
	{ "not supported on sbs",			0xc0000300 },
	{ "WMI GUID disconnected",			0xc0000301 },
	{ "WMI already disabled",			0xc0000302 },
	{ "WMI already enabled",			0xc0000303 },
	{ "mft too fragmented",				0xc0000304 },
	{ "copy protection failure",			0xc0000305 },
	{ "CSS authentication failure",			0xc0000306 },
	{ "CSS key not present",			0xc0000307 },
	{ "CSS key not established",			0xc0000308 },
	{ "CSS scrambled sector",			0xc0000309 },
	{ "CSS region mismatch",			0xc000030a },
	{ "CSS resets exhausted",			0xc000030b },
	{ "pkinit failure",				0xc0000320 },
	{ "smartcard subsystem failure",		0xc0000321 },
	{ "no kerb key",				0xc0000322 },
	{ "host down",					0xc0000350 },
	{ "unsupported preauth",			0xc0000351 },
	{ "EFS alg blob too big",			0xc0000352 },
	{ "port not set",				0xc0000353 },
	{ "debugger inactive",				0xc0000354 },
	{ "ds version check failure",			0xc0000355 },
	{ "auditing disabled",				0xc0000356 },
	{ "prent4 machine account",			0xc0000357 },
	{ "DS AG can't have universal member",		0xc0000358 },
	{ "invalid image Win 32",			0xc0000359 },
	{ "invalid image Win 64",			0xc000035a },
	{ "bad bindings",				0xc000035b },
	{ "network session expired",			0xc000035c },
	{ "apphelp block",				0xc000035d },
	{ "all SIDs filtered",				0xc000035e },
	{ "not safe mode driver",			0xc000035f },
	{ "access disabled by policy default",		0xc0000361 },
	{ "access disabled by policy path",		0xc0000362 },
	{ "access disabled by policy publisher",	0xc0000363 },
	{ "access disabled by policy other",		0xc0000364 },
	{ "failed driver entry",			0xc0000365 },
	{ "device enumeration error",			0xc0000366 },
	{ "mount point not resolved",			0xc0000368 },
	{ "invalid device object parameter",		0xc0000369 },
	{ "mca occured",				0xc000036a },
	{ "driver blocked critical",			0xc000036b },
	{ "driver blocked",				0xc000036c },
	{ "driver database error",			0xc000036d },
	{ "system hive too large",			0xc000036e },
	{ "invalid import of non DLL",			0xc000036f },
	{ "smartcard wrong pin",			0xc0000380 },
	{ "smartcard card blocked",			0xc0000381 },
	{ "smartcard card not authenticated",		0xc0000382 },
	{ "smartcard no card",				0xc0000383 },
	{ "smartcard no key container",			0xc0000384 },
	{ "smartcard no certificate",			0xc0000385 },
	{ "smartcard no keyset",			0xc0000386 },
	{ "smartcard io error",				0xc0000387 },
	{ "downgrade detected",				0xc0000388 },
	{ "smartcard cert revoked",			0xc0000389 },
	{ "issuing CA untrusted",			0xc000038a },
	{ "revocation offline c",			0xc000038b },
	{ "pkinit client failure",			0xc000038c },
	{ "smartcard cert expired",			0xc000038d },
	{ "driver failed prior unload",			0xc000038e },
	{ "wow assertion",				0xc0009898 },
	{ "PNP bad MPS table",				0xc0040035 },
	{ "PNP translation failed",			0xc0040036 },
	{ "PNP IRQ translation failed",			0xc0040037 },
	{ "CTX winstation name invalid",		0xc00a0001 },
	{ "CTX invalid PD",				0xc00a0002 },
	{ "CTX PD not found",				0xc00a0003 },
	{ "CTX close pending",				0xc00a0006 },
	{ "CTX no outbuf",				0xc00a0007 },
	{ "CTX modem inf not found",			0xc00a0008 },
	{ "CTX invalid modemname",			0xc00a0009 },
	{ "CTX response error",				0xc00a000a },
	{ "CTX modem response timeout",			0xc00a000b },
	{ "CTX modem response no carrier",		0xc00a000c },
	{ "CTX modem response no dialtone",		0xc00a000d },
	{ "CTX modem response busy",			0xc00a000e },
	{ "CTX modem response voice",			0xc00a000f },
	{ "CTX TD error",				0xc00a0010 },
	{ "CTX license client invalid",			0xc00a0012 },
	{ "CTX license not available",			0xc00a0013 },
	{ "CTX license expired",			0xc00a0014 },
	{ "CTX winstation not found",			0xc00a0015 },
	{ "CTX winstation name collision",		0xc00a0016 },
	{ "CTX winstation busy",			0xc00a0017 },
	{ "CTX bad video mode",				0xc00a0018 },
	{ "CTX graphics invalid",			0xc00a0022 },
	{ "CTX not console",				0xc00a0024 },
	{ "CTX client query timeout",			0xc00a0026 },
	{ "CTX console disconnect",			0xc00a0027 },
	{ "CTX console connect",			0xc00a0028 },
	{ "CTX shadow denied",				0xc00a002a },
	{ "CTX winstation access denied",		0xc00a002b },
	{ "CTX invalid wd",				0xc00a002e },
	{ "CTX WD not found",				0xc00a002f },
	{ "CTX shadow invalid",				0xc00a0030 },
	{ "CTX shadow disabled",			0xc00a0031 },
	{ "RDP protocol error",				0xc00a0032 },
	{ "CTX client license not set",			0xc00a0033 },
	{ "CTX client license in use",			0xc00a0034 },
	{ "CTX shadow ended by mode change",		0xc00a0035 },
	{ "CTX shadow not running",			0xc00a0036 },
	{ "cluster invalid node",			0xc0130001 },
	{ "cluster node exists",			0xc0130002 },
	{ "cluster join in progress",			0xc0130003 },
	{ "cluster node not found",			0xc0130004 },
	{ "cluster local node not found",		0xc0130005 },
	{ "cluster network exists",			0xc0130006 },
	{ "cluster network not found",			0xc0130007 },
	{ "cluster netinterface exists",		0xc0130008 },
	{ "cluster netinterface not found",		0xc0130009 },
	{ "cluster invalid request",			0xc013000a },
	{ "cluster invalid network provider",		0xc013000b },
	{ "cluster node down",				0xc013000c },
	{ "cluster node unreachable",			0xc013000d },
	{ "cluster node not member",			0xc013000e },
	{ "cluster join not in progress",		0xc013000f },
	{ "cluster invalid network",			0xc0130010 },
	{ "cluster no net adapters",			0xc0130011 },
	{ "cluster node up",				0xc0130012 },
	{ "cluster node paused",			0xc0130013 },
	{ "cluster node not paused",			0xc0130014 },
	{ "cluster no security context",		0xc0130015 },
	{ "cluster network not internal",		0xc0130016 },
	{ "cluster poisoned",				0xc0130017 },
	{ "ACPI invalid opcode",			0xc0140001 },
	{ "ACPI stack overflow",			0xc0140002 },
	{ "ACPI assert failed",				0xc0140003 },
	{ "ACPI invalid index",				0xc0140004 },
	{ "ACPI invalid argument",			0xc0140005 },
	{ "ACPI fatal",					0xc0140006 },
	{ "ACPI invalid supername",			0xc0140007 },
	{ "ACPI invalid argtype",			0xc0140008 },
	{ "ACPI invalid objtype",			0xc0140009 },
	{ "ACPI invalid targettype",			0xc014000a },
	{ "ACPI incorrect argument count",		0xc014000b },
	{ "ACPI address not mapped",			0xc014000c },
	{ "ACPI invalid eventtype",			0xc014000d },
	{ "ACPI handler collision",			0xc014000e },
	{ "ACPI invalid data",				0xc014000f },
	{ "ACPI invalid region",			0xc0140010 },
	{ "ACPI invalid access size",			0xc0140011 },
	{ "ACPI acquire global lock",			0xc0140012 },
	{ "ACPI already initialized",			0xc0140013 },
	{ "ACPI not initialized",			0xc0140014 },
	{ "ACPI invalid mutex level",			0xc0140015 },
	{ "ACPI mutex not owned",			0xc0140016 },
	{ "ACPI mutex not owner",			0xc0140017 },
	{ "ACPI rs access",				0xc0140018 },
	{ "ACPI invalid table",				0xc0140019 },
	{ "ACPI reg handler failed",			0xc0140020 },
	{ "ACPI power request failed",			0xc0140021 },
	{ "SXS section not found",			0xc0150001 },
	{ "SXS cant gen actctx",			0xc0150002 },
	{ "SXS invalid actctx data format",		0xc0150003 },
	{ "SXS assembly not found",			0xc0150004 },
	{ "SXS manifest format error",			0xc0150005 },
	{ "SXS manifest parse error",			0xc0150006 },
	{ "SXS activation context disabled",		0xc0150007 },
	{ "SXS key not found",				0xc0150008 },
	{ "SXS version conflict",			0xc0150009 },
	{ "SXS wrong section type",			0xc015000a },
	{ "SXS thread queries disabled",		0xc015000b },
	{ "SXS assembly missing",			0xc015000c },
	{ "SXS process default already set",		0xc015000e },
	{ "SXS early deactivation",			0xc015000f },
	{ "SXS invalid deactivation",			0xc0150010 },
	{ "SXS multiple deactivation",			0xc0150011 },
	{ "SXS system default activation context empty",0xc0150012 },
	{ "SXS process termination requested",		0xc0150013 },
};

char *
nterrstr(uint err)
{
	int i, f, match;
	char *why, *facility, tmp[32];
	static char buf[0xff];

	f = (err >> 16) & 0x7ff;
	switch(f){
	case 0:
		facility = "";
		break;
	case 1:
		facility = " (hardware), ";
		break;
	case 2:
		facility = " (dispatch), ";
		break;
	case 3:
		facility = " (storage), ";
		break;
	case 4:
		facility = " (itf), ";
		break;
	case 7:
		facility = " (win32), ";
		break;
 	case 8:
		facility = " (windows), ";
		break;
	case 0x0a:
		facility = " (control), ";
		break;
	default:
		snprint(tmp, sizeof(tmp), " (facility=%d), ", f);
		facility = tmp;
		break;
	}

	match = -1;
	for(i = 0; i < nelem(NTerrs); i++)
		if(NTerrs[i].err == err)
			match = i;

	why = "";
	if(!(err & 0x80000000))
		why = "warning, ";

	if(match != -1)
		snprint(buf, sizeof buf, "%s%s%s", why, facility,
			NTerrs[match].msg);
	else
		snprint(buf, sizeof buf, "%s%s%d/0x%ux - unknown NT error",
			why, facility, err, err);
	return buf;
}
