#include <u.h>
#include <libc.h>

static struct {
	int	err;
	char	*msg;
} RAPerrs[] = {
	{ 0,	"ok" },
	{ 5,	"permission denied" },
	{ 50,	"request not supported" },
	{ 65,	"access denied" },
	{ 86,	"password invalid" },
	{ 128,  "not listening on called name" },
	{ 129,  "not listening for calling name" },
	{ 130,  "called name not present" },
	{ 131,  "called name present, but insufficient resources" },
	{ 234,	"more data" },

	{ 2102, "workstation driver is not installed" },
	{ 2103, "server could not be located" },
	{ 2104, "network cannot access a shared memory segment" },
	{ 2105, "A network resource shortage occurred" },
	{ 2106, "This operation is not supported on workstations" },
	{ 2107, "device is not connected" },
	{ 2114, "Server service is not started" },
	{ 2115, "queue is empty" },
	{ 2116, "device or directory does not exist" },
	{ 2117, "operation is invalid on a redirected resource" },
	{ 2118, "name has already been shared" },
	{ 2119, "server is currently out of the requested resource" },
	{ 2121, "Requested addition of items exceeds the maximum allowed" },
	{ 2122, "Peer service supports only two simultaneous users" },
	{ 2123, "API return buffer is too small" },
	{ 2127, "remote API error occurred" },
	{ 2131, "cannot open or read the configuration file" },
	{ 2136, "general network error occurred" },
	{ 2137, "Workstation service is corrupted" },
	{ 2138, "Workstation service has not been started" },
	{ 2139, "requested information is not available" },
	{ 2140, "internal error" },
	{ 2141, "server is not configured for transactions" },
	{ 2142, "requested API is not supported on the remote server" },
	{ 2143, "event name is invalid" },
	{ 2144, "computer name already exists on the network" },
	{ 2146, "specified component could not be found in the config info" },
	{ 2147, "specified parameter could not be found in the config info" },
	{ 2149, "A line in the configuration file is too long" },
	{ 2150, "printer does not exist" },
	{ 2151, "print job does not exist" },
	{ 2152, "printer destination cannot be found" },
	{ 2153, "printer destination already exists" },
	{ 2154, "printer queue already exists" },
	{ 2155, "no more printers can be added" },
	{ 2156, "no more print jobs can be added" },
	{ 2157, "no more printer destinations can be added" },
	{ 2158, "printer idle and cannot accept control operations" },
	{ 2159, "invalid control function in printer request" },
	{ 2160, "print processor not responding" },
	{ 2161, "spooler not running" },
	{ 2162, "operation cannot be performed on the print destination in its current state" },
	{ 2163, "operation cannot be performed on the printer queue in its current state" },
	{ 2164, "operation cannot be performed on the print job in its current state" },
	{ 2165, "spooler - no memory" },
	{ 2166, "device driver does not exist" },
	{ 2167, "data type not supported by the print processor" },
	{ 2168, "print processor is not installed" },
	{ 2180, "service database is locked" },
	{ 2181, "service table full" },
	{ 2182, "requested service already started" },
	{ 2183, "service does not responding" },
	{ 2184, "service not started" },
	{ 2185, "service name invalid" },
	{ 2186, "service is not responding to the control function" },
	{ 2187, "service control is busy" },
	{ 2188, "configuration file contains an invalid service program name" },
	{ 2189, "service could not be controlled in its present state" },
	{ 2190, "service ended abnormally" },
	{ 2191, "requested pause or stop is not valid for this service" },
	{ 2192, "could not find the service name in the dispatch table" },
	{ 2193, "service control dispatcher pipe read failed" },
	{ 2194, "thread create for the new service could not be created" },
	{ 2200, "This workstation is already logged on to the local-area network" },
	{ 2201, "workstation is not logged on to the local-area network" },
	{ 2202, "user name or group name parameter is invalid" },
	{ 2203, "password parameter is invalid" },
	{ 2204, "logon processor did not add the message alias" },
	{ 2205, "logon processor did not add the message alias" },
	{ 2206, "logoff processor did not delete the message alias" },
	{ 2207, "logoff processor did not delete the message alias" },
	{ 2209, "Network logons are paused" },
	{ 2210, "a centralized logon-server conflict occurred" },
	{ 2211, "server is configured without a valid user path" },
	{ 2212, "cannot run logon script" },
	{ 2214, "logon server was not specified. computer will be logged on as STANDALONE" },
	{ 2215, "logon server could not be found" },
	{ 2216, "already a logon domain for this computer" },
	{ 2217, "logon server could not validate the logon" },
	{ 2219, "security database could not be found" },
	{ 2220, "group name could not be found" },
	{ 2221, "user name could not be found" },
	{ 2222, "resource name could not be found" },
	{ 2223, "group already exists" },
	{ 2224, "user account already exists" },
	{ 2225, "resource permission list already exists" },
	{ 2226, "This operation is only allowed on the PDC of the domain" },
	{ 2227, "security database has not been started" },
	{ 2228, "There are too many names in the user accounts database" },
	{ 2229, "disk I/O failure occurred" },
	{ 2230, "limit of 64 entries per resource was exceeded" },
	{ 2231, "Deleting a user with a session is not allowed" },
	{ 2232, "parent directory could not be located" },
	{ 2233, "Unable to add to the security database session cache segment" },
	{ 2234, "This operation is not allowed on this special group" },
	{ 2235, "This user is not cached in user accounts database session cache" },
	{ 2236, "user already belongs to this group" },
	{ 2237, "user does not belong to this group" },
	{ 2238, "This user account is undefined" },
	{ 2239, "This user account has expired" },
	{ 2240, "user is not allowed to log on from this workstation" },
	{ 2241, "user is not allowed to log on at this time" },
	{ 2242, "password of this user has expired" },
	{ 2243, "password of this user cannot change" },
	{ 2244, "This password cannot be used now" },
	{ 2245, "password does not meet the password policy requirements" },
	{ 2246, "password of this user is too recent to change" },
	{ 2247, "security database is corrupted" },
	{ 2248, "No updates are necessary to this replicant network/local security database" },
	{ 2249, "This replicant database is outdated; synchronization is required" },
	{ 2250, "network connection could not be found" },
	{ 2251, "This asg_type is invalid" },
	{ 2252, "This device is currently being shared" },
	{ 2270, "computer name cannot be added - name may already exist" },
	{ 2271, "Messenger service is already started" },
	{ 2272, "Messenger service failed to start" },
	{ 2273, "message alias could not be found on the network" },
	{ 2274, "This message alias has already been forwarded" },
	{ 2275, "This message alias has been added but is still forwarded" },
	{ 2276, "This message alias already exists locally" },
	{ 2277, "maximum number of added message aliases has been exceeded" },
	{ 2278, "computer name could not be deleted" },
	{ 2279, "Messages cannot be forwarded back to the same workstation" },
	{ 2280, "An error occurred in the domain message processor" },
	{ 2281, "message was sent, but the recipient has paused the Messenger service" },
	{ 2282, "message was sent but not received" },
	{ 2283, "message alias is currently in use. Try again later" },
	{ 2284, "Messenger service has not been started" },
	{ 2285, "name is not on the local computer" },
	{ 2286, "forwarded message alias could not be found on the network" },
	{ 2287, "message alias table on the remote station is full" },
	{ 2288, "Messages for this alias are not currently being forwarded" },
	{ 2289, "broadcast message was truncated" },
	{ 2294, "This is an invalid device name" },
	{ 2295, "A write fault occurred" },
	{ 2297, "A duplicate message alias exists on the network" },
	{ 2298, "This message alias will be deleted later" },
	{ 2299, "message alias was not successfully deleted from all networks" },
	{ 2300, "This operation is not supported on computers with multiple networks" },
	{ 2310, "This shared resource does not exist" },
	{ 2311, "This device is not shared" },
	{ 2312, "A session does not exist with that computer name" },
	{ 2314, "There is not an open file with that identification number" },
	{ 2315, "A failure occurred when executing a remote administration command" },
	{ 2316, "A failure occurred when opening a remote temporary file" },
	{ 2317, "Data returned from a RAP command has been truncated to 64K" },
	{ 2318, "This device cannot be shared as both a spooled and a non-spooled resource" },
	{ 2319, "information in the list of servers may be incorrect" },
	{ 2320, "computer is not active in this domain" },
	{ 2321, "share must be removed from DFS before it can be deleted" },
	{ 2331, "operation is invalid for this device" },
	{ 2332, "This device cannot be shared" },
	{ 2333, "This device was not open" },
	{ 2334, "This device name list is invalid" },
	{ 2335, "queue priority is invalid" },
	{ 2337, "There are no shared communication devices" },
	{ 2338, "queue you specified does not exist" },
	{ 2340, "This list of devices is invalid" },
	{ 2341, "requested device is invalid" },
	{ 2342, "This device is already in use by the spooler" },
	{ 2343, "This device is already in use as a communication device" },
	{ 2351, "This computer name is invalid" },
	{ 2354, "string and prefix specified are too long" },
	{ 2356, "This path component is invalid" },
	{ 2357, "Could not determine the type of input" },
	{ 2362, "buffer for types is not big enough" },
	{ 2370, "Profile files cannot exceed 64K" },
	{ 2371, "start offset is out of range" },
	{ 2372, "system cannot delete current connections to network resources" },
	{ 2373, "system was unable to parse the command line in this file" },
	{ 2374, "An error occurred while loading the profile file" },
	{ 2375, "Errors occurred while saving the profile file" },
	{ 2377, "Log file %1 is full" },
	{ 2378, "This log file has changed between reads" },
	{ 2379, "Log file %1 is corrupt" },
	{ 2380, "source path cannot be a directory" },
	{ 2381, "source path is illegal" },
	{ 2382, "destination path is illegal" },
	{ 2383, "source and destination paths are on different servers" },
	{ 2385, "Run server you requested is paused" },
	{ 2389, "An error occurred when communicating with a Run server" },
	{ 2391, "An error occurred when starting a background process" },
	{ 2392, "shared resource you are connected to could not be found" },
	{ 2400, "LAN adapter number is invalid" },
	{ 2401, "There are open files on the connection" },
	{ 2402, "Active connections still exist" },
	{ 2403, "This share name or password is invalid" },
	{ 2404, "device is being accessed by an active process" },
	{ 2405, "drive letter is in use locally" },
	{ 2430, "specified client is already registered for the specified event" },
	{ 2431, "alert table is full" },
	{ 2432, "An invalid or nonexistent alert name was raised" },
	{ 2433, "alert recipient is invalid" },
	{ 2434, "A user's session with this server has been deleted" },
	{ 2440, "log file does not contain the requested record number" },
	{ 2450, "user accounts database is not configured correctly" },
	{ 2451, "This operation is not permitted when the Netlogon service is running" },
	{ 2452, "This operation is not allowed on the last administrative account" },
	{ 2453, "Could not find DC for this domain" },
	{ 2454, "Could not set logon information for this user" },
	{ 2455, "Netlogon service has not been started" },
	{ 2456, "Unable to add to the user accounts database" },
	{ 2457, "This server's clock is not synchronized with the PDC's clock" },
	{ 2458, "A password mismatch has been detected" },
	{ 2460, "server identification does not specify a valid server" },
	{ 2461, "session identification does not specify a valid session" },
	{ 2462, "connection identification does not specify a valid connection" },
	{ 2463, "There is no space for another entry in the table of available servers" },
	{ 2464, "server has reached the maximum number of sessions it supports" },
	{ 2465, "server has reached the maximum number of connections it supports" },
	{ 2466, "server cannot open more files because it has reached its maximum number" },
	{ 2467, "There are no alternate servers registered on this server" },
	{ 2470, "Try down-level (remote admin protocol) version of API instead" },
	{ 2480, "UPS driver could not be accessed by the UPS service" },
	{ 2481, "UPS service is not configured correctly" },
	{ 2482, "UPS service could not access the specified Comm Port" },
	{ 2483, "UPS indicated a line fail or low battery situation. Service not started" },
	{ 2484, "UPS service failed to perform a system shut down" },
	{ 2500, "program below returned an MS-DOS error code" },
	{ 2501, "program below needs more memory" },
	{ 2502, "program below called an unsupported MS-DOS function" },
	{ 2503, "workstation failed to boot" },
	{ 2504, "file below is corrupt" },
	{ 2505, "No loader is specified in the boot-block definition file" },
	{ 2506, "NetBIOS returned an error: The NCB and SMB are dumped above" },
	{ 2507, "A disk I/O error occurred" },
	{ 2508, "Image parameter substitution failed" },
	{ 2509, "Too many image parameters cross disk sector boundaries" },
	{ 2510, "image was not generated from an MS-DOS diskette formatted with /S" },
	{ 2511, "Remote boot will be restarted later" },
	{ 2512, "call to the Remoteboot server failed" },
	{ 2513, "Cannot connect to the Remoteboot server" },
	{ 2514, "Cannot open image file on the Remoteboot server" },
	{ 2515, "Connecting to the Remoteboot server..." },
	{ 2516, "Connecting to the Remoteboot server..." },
	{ 2517, "Remote boot service was stopped" },
	{ 2518, "Remote boot startup failed; check the error log" },
	{ 2519, "A second connection to a Remoteboot resource is not allowed" },
	{ 2550, "browser service was configured with MaintainServerList=No" },
	{ 2610, "Service failed to startas no network adapters started with this service" },
	{ 2611, "Service failed to start due to bad startup information in the registry" },
	{ 2612, "Service failed to start because its database is absent or corrupt" },
	{ 2613, "Service failed to start because RPLFILES share is absent" },
	{ 2614, "Service failed to start because RPLUSER group is absent" },
	{ 2615, "Cannot enumerate service records" },
	{ 2616, "Workstation record information has been corrupted" },
	{ 2617, "Workstation record was not found" },
	{ 2618, "Workstation name is in use by some other workstation" },
	{ 2619, "Profile record information has been corrupted" },
	{ 2620, "Profile record was not found" },
	{ 2621, "Profile name is in use by some other profile" },
	{ 2622, "There are workstations using this profile" },
	{ 2623, "Configuration record information has been corrupted" },
	{ 2624, "Configuration record was not found" },
	{ 2625, "Adapter ID record information has been corrupted" },
	{ 2626, "An internal service error has occurred" },
	{ 2627, "Vendor ID record information has been corrupted" },
	{ 2628, "Boot block record information has been corrupted" },
	{ 2629, "user account for this workstation record is missing" },
	{ 2630, "RPLUSER local group could not be found" },
	{ 2631, "Boot block record was not found" },
	{ 2632, "Chosen profile is incompatible with this workstation" },
	{ 2633, "Chosen network adapter ID is in use by some other workstation" },
	{ 2634, "There are profiles using this configuration" },
	{ 2635, "There are workstations, profiles, or configurations using this boot block" },
	{ 2636, "Service failed to backup Remoteboot database" },
	{ 2637, "Adapter record was not found" },
	{ 2638, "Vendor record was not found" },
	{ 2639, "Vendor name is in use by some other vendor record" },
	{ 2640, "(boot name, vendor ID) is in use by some other boot block record" },
	{ 2641, "Configuration name is in use by some other configuration" },
	{ 2660, "internal database maintained by the Dfs service is corrupt" },
	{ 2661, "One of the records in the internal Dfs database is corrupt" },
	{ 2662, "There is no DFS name whose entry path matches the input Entry Path" },
	{ 2663, "A root or link with the given name already exists" },
	{ 2664, "server share specified is already shared in the Dfs" },
	{ 2665, "indicated server share does not support the indicated DFS namespace" },
	{ 2666, "operation is not valid on this portion of the namespace" },
	{ 2667, "operation is not valid on this portion of the namespace" },
	{ 2668, "operation is ambiguous because the link has multiple servers" },
	{ 2669, "Unable to create a link" },
	{ 2670, "server is not Dfs Aware" },
	{ 2671, "specified rename target path is invalid" },
	{ 2672, "specified DFS link is offline" },
	{ 2673, "specified server is not a server for this link" },
	{ 2674, "A cycle in the Dfs name was detected" },
	{ 2675, "operation is not supported on a server-based Dfs" },
	{ 2676, "This link is already supported by the specified server-share" },
	{ 2677, "Can't remove the last server-share supporting this root or link" },
	{ 2678, "operation is not supported for an Inter-DFS link" },
	{ 2679, "internal state of the Dfs Service has become inconsistent" },
	{ 2680, "Dfs Service has been installed on the specified server" },
	{ 2681, "Dfs data being reconciled is identical" },
	{ 2682, "DFS root cannot be deleted. Uninstall DFS if required" },
	{ 2683, "A child or parent directory of the share is already in a Dfs" },
	{ 2690, "Dfs internal error" },
	{ 2691, "This machine is already joined to a domain" },
	{ 2692, "This machine is not currently joined to a domain" },
	{ 2693, "This machine is a DC and cannot be unjoined from a domain" },
	{ 2694, "destination DC does not support creating machine accounts in OUs" },
	{ 2695, "specified workgroup name is invalid" },
	{ 2696, "specified computer name is incompatible with the default language used on the DC" },
	{ 2697, "specified computer account could not be found" },
	{ 2698, "This version of Windows cannot be joined to a domain" },
	{ 2701, "password must change at the next logon" },
	{ 2702, "account is locked out" },
	{ 2703, "password is too long" },
	{ 2704, "password does not meet the complexity policy" },
	{ 2705, "password does not meet the requirements of the password filter DLLs" },
};

char *
raperrstr(uint err)
{
	int i, match;
	static char buf[0xff];

	match = -1;
	for(i = 0; i < nelem(RAPerrs); i++)
		if(RAPerrs[i].err == err)
			match = i;
	if(match != -1)
		snprint(buf, sizeof buf, "rap: %s", RAPerrs[match].msg);
	else
		snprint(buf, sizeof buf, "rap: %ud/0x%ux - unknown error",
			err, err);
	return buf;
}
