echo x - Makefile
sed '/^X/s///' > Makefile << '/'
X# Makefile for aal
X
XCC=exec cc
XCFLAGS=-I. -wo -DAAL -DSTB -DNDEBUG -DDISTRIBUTION -D_POSIX_SOURCE -D_MINIX
XLDFLAGS=-i -s
X
X.SUFFIXES: .c .o
XO=o
X.c.$O:
X	$(CC) -c $(CFLAGS) $< ;
X
XOFILES=	archiver.$O \
X	print.$O \
X	rd.$O \
X	rd_arhdr.$O \
X	rd_unsig2.$O \
X	sprint.$O \
X	wr_arhdr.$O \
X	wr_bytes.$O \
X	wr_int2.$O \
X	wr_long.$O \
X	wr_ranlib.$O \
X	format.$O \
X	rd_bytes.$O \
X	system.$O \
X	write.$O \
X	long2str.$O
X
Xaal: $(OFILES)
X	$(CC) $(LDFLAGS) -o aal $(OFILES) ;
X
Xarchiver.$O:
Xprint.$O:
Xrd.$O:
Xrd_arhdr.$O:
Xrd_unsig2.$O:
Xsprint.$O:
Xwr_arhdr.$O:
Xwr_bytes.$O:
Xwr_int2.$O:
Xwr_long.$O:
Xwr_ranlib.$O:
Xformat.$O:
Xrd_bytes.$O:
Xsystem.$O:
Xwrite.$O:
Xlong2str.$O:
X
Xclean:	
X	@rm -f *.s *.o core *.bak aal
/
echo x - arch.h
sed '/^X/s///' > arch.h << '/'
X/* $Header: arch.h,v 1.6 91/06/06 11:47:23 ceriel Exp $ */
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X
X#ifndef __ARCH_H_INCLUDED
X#define __ARCH_H_INCLUDED
X
X#define	ARMAG	0177545
X#define AALMAG	0177454
X
Xstruct	ar_hdr {
X	char	ar_name[14];
X	long	ar_date;
X	char	ar_uid;
X	char	ar_gid;
X	short	ar_mode;
X	long	ar_size;
X};
X
X#define AR_TOTAL	26
X#define AR_SIZE		22
X
X#endif /* __ARCH_H_INCLUDED */
/
echo x - archiver.c
sed '/^X/s///' > archiver.c << '/'
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* ar - archiver		Author: Michiel Huisjes */
X/* Made into arch/aal by Ceriel Jacobs
X */
X
Xstatic char RcsId[] = "$Header: archiver.c,v 1.23 91/06/20 14:22:37 ceriel Exp $";
X
X/*
X * Usage: [arch|aal] [adprtvx] archive [file] ...
X *	  v: verbose
X *	  x: extract
X *	  a: append
X *	  r: replace (append when not in archive)
X *	  d: delete
X *	  t: print contents of archive
X *	  p: print named files
X *	  l: temporaries in current directory instead of /tmp
X *	  c: don't give "create" message
X#ifdef DISTRIBUTION
X *	  D: make distribution: use distr_time, uid=2, gid=2, mode=0644
X#endif
X */
X
X#include <sys/types.h>
X#include <sys/stat.h>
X#ifndef	S_IREAD
X#define	S_IREAD		S_IRUSR
X#endif
X#ifndef	S_IWRITE
X#define	S_IWRITE	S_IWUSR
X#endif
X#ifndef	S_IEXEC
X#define	S_IEXEC		S_IXUSR
X#endif
X#include <signal.h>
X#include <arch.h>
X#ifdef AAL
X#include <ranlib.h>
X#include <out.h>
X#define MAGIC_NUMBER	AALMAG
Xlong	offset;
Xstruct ranlib *tab;
Xunsigned int	tnum = 0;
Xchar	*tstrtab;
Xunsigned int	tssiz = 0;
Xchar	*malloc(), *realloc(), *strcpy(), *strncpy();
Xlong	time();
Xunsigned int tabsz, strtabsz;
X#else
X#define MAGIC_NUMBER	ARMAG
X#endif
Xlong	lseek();
X
X#define odd(nr)		(nr & 01)
X#define even(nr)	(odd(nr) ? nr + 1 : nr)
X
Xtypedef char BOOL;
X#define FALSE		0
X#define TRUE		1
X
X#define READ		0
X#define APPEND		2
X#define CREATE		1
X
X#define MEMBER		struct ar_hdr
X
X#define NIL_PTR		((char *) 0)
X#define NIL_MEM		((MEMBER *) 0)
X#define NIL_LONG	((long *) 0)
X
X#define IO_SIZE		(10 * 1024)
X
X#define equal(str1, str2)	(!strncmp((str1), (str2), 14))
X#ifndef S_ISDIR
X#define S_ISDIR(m)	(m & S_IFDIR)		/* is a directory */
X#endif
X
XBOOL verbose;
XBOOL app_fl;
XBOOL ex_fl;
XBOOL show_fl;
XBOOL pr_fl;
XBOOL rep_fl;
XBOOL del_fl;
XBOOL nocr_fl;
XBOOL local_fl;
X#ifdef DISTRIBUTION
XBOOL distr_fl;
Xlong distr_time;
X#endif
X
Xint ar_fd;
X
Xchar io_buffer[IO_SIZE];
X
Xchar *progname;
X
Xchar temp_buf[32];
Xchar *temp_arch = &temp_buf[0];
Xextern char *mktemp();
Xextern char *ctime();
X
Xusage()
X{
X	error(TRUE, "usage: %s %s archive [file] ...\n",
X		progname,
X#ifdef AAL
X		"[acdrtxvl]"
X#else
X		"[acdprtxvl]"
X#endif
X		);
X}
X
X/*VARARGS2*/
Xerror(quit, str1, str2, str3, str4)
XBOOL quit;
Xchar *str1, *str2, *str3, *str4;
X{
X	char errbuf[256];
X
X	sprint(errbuf, str1, str2, str3, str4);
X	write(2, errbuf, strlen(errbuf));
X  	if (quit) {
X		unlink(temp_arch);
X		_exit(1);
X  	}
X}
X
Xchar *basename(path)
Xchar *path;
X{
X  register char *ptr = path;
X  register char *last = NIL_PTR;
X
X  while (*ptr != '\0') {
X	if (*ptr == '/')
X		last = ptr;
X	ptr++;
X  }
X  if (last == NIL_PTR)
X	return path;
X  if (*(last + 1) == '\0') {
X	*last = '\0';
X	return basename(path);
X  }
X  return last + 1;
X}
X
Xextern unsigned int rd_unsigned2();
X
Xopen_archive(name, mode)
Xregister char *name;
Xregister int mode;
X{
X  unsigned short magic = 0;
X  int fd;
X
X  if (mode == CREATE) {
X	if ((fd = creat(name, 0666)) < 0)
X		error(TRUE, "cannot creat %s\n", name);
X	magic = MAGIC_NUMBER;
X	wr_int2(fd, magic);
X	return fd;
X  }
X
X  if ((fd = open(name, mode)) < 0) {
X	if (mode == APPEND) {
X		close(open_archive(name, CREATE));
X		if (!nocr_fl) error(FALSE, "%s: creating %s\n", progname, name);
X		return open_archive(name, APPEND);
X	}
X	error(TRUE, "cannot open %s\n", name);
X  }
X  lseek(fd, 0L, 0);
X  magic = rd_unsigned2(fd);
X  if (magic != AALMAG && magic != ARMAG)
X	error(TRUE, "%s is not in ar format\n", name);
X  
X  return fd;
X}
X
Xcatch()
X{
X	unlink(temp_arch);
X	_exit (2);
X}
X
Xmain(argc, argv)
Xint argc;
Xchar *argv[];
X{
X  register char *ptr;
X  int needs_arg = 0;
X
X  progname = argv[0];
X
X  if (argc < 3)
X	usage();
X  
X  for (ptr = argv[1]; *ptr; ptr++) {
X	switch (*ptr) {
X		case 't' :
X			show_fl = TRUE;
X			break;
X		case 'v' :
X			verbose = TRUE;
X			break;
X		case 'x' :
X			ex_fl = TRUE;
X			break;
X		case 'a' :
X			needs_arg = 1;
X			app_fl = TRUE;
X			break;
X		case 'c' :
X			nocr_fl = TRUE;
X			break;
X#ifndef AAL
X		case 'p' :
X			needs_arg = 1;
X			pr_fl = TRUE;
X			break;
X#endif
X		case 'd' :
X			needs_arg = 1;
X			del_fl = TRUE;
X			break;
X		case 'r' :
X			needs_arg = 1;
X			rep_fl = TRUE;
X			break;
X		case 'l' :
X			local_fl = TRUE;
X			break;
X#ifdef DISTRIBUTION
X		case 'D' :
X			distr_fl = TRUE;
X			break;
X#endif
X		default :
X			usage();
X	}
X  }
X
X  if (needs_arg && argc <= 3)
X	usage();
X#ifdef DISTRIBUTION
X  if (distr_fl) {
X	struct stat statbuf;
X
X	stat(progname, &statbuf);
X	distr_time = statbuf.st_mtime;
X  }
X#endif
X  if (local_fl) strcpy(temp_arch, "ar.XXXXXX");
X  else	strcpy(temp_arch, "/tmp/ar.XXXXXX");
X
X  if (app_fl + ex_fl + del_fl + rep_fl + show_fl + pr_fl != 1)
X	usage();
X  
X  if (rep_fl || del_fl
X#ifdef AAL
X	|| app_fl
X#endif
X     ) {
X	mktemp(temp_arch);
X  }
X#ifdef AAL
X  tab = (struct ranlib *) malloc(512 * sizeof(struct ranlib));
X  tstrtab = malloc(4096);
X  if (!tab || !tstrtab) error(TRUE,"Out of core\n");
X  tabsz = 512;
X  strtabsz = 4096;
X#endif
X
X  signal(SIGINT, catch);
X  get(argc, argv);
X  
X  return 0;
X}
X
XMEMBER *
Xget_member()
X{
X  static MEMBER member;
X
Xagain:
X  if (rd_arhdr(ar_fd, &member) == 0)
X	return NIL_MEM;
X  if (member.ar_size < 0) {
X	error(TRUE, "archive has member with negative size\n");
X  }
X#ifdef AAL
X  if (equal(SYMDEF, member.ar_name)) {
X	lseek(ar_fd, member.ar_size, 1);
X	goto again;
X  }
X#endif
X  return &member;
X}
X
Xchar *get_mode();
X
Xget(argc, argv)
Xint argc;
Xregister char *argv[];
X{
X  register MEMBER *member;
X  int i = 0;
X  int temp_fd, read_chars;
X
X  ar_fd = open_archive(argv[2], (show_fl || pr_fl || ex_fl) ? READ : APPEND);
X  if (rep_fl || del_fl
X#ifdef AAL
X	|| app_fl
X#endif
X  )
X	temp_fd = open_archive(temp_arch, CREATE);
X  while ((member = get_member()) != NIL_MEM) {
X	if (argc > 3) {
X		for (i = 3; i < argc; i++) {
X			if (equal(basename(argv[i]), member->ar_name))
X				break;
X		}
X		if (i == argc || app_fl) {
X			if (rep_fl || del_fl
X#ifdef AAL
X				|| app_fl
X#endif
X			) {
X#ifdef AAL
X				if (i != argc) {
X					print("%s: already in archive\n", argv[i]);
X					argv[i] = "";
X				}
X#endif
X				wr_arhdr(temp_fd, member);
X				copy_member(member, ar_fd, temp_fd, 0);
X			}
X			else {
X#ifndef AAL
X				if (app_fl && i != argc) {
X					print("%s: already in archive\n", argv[i]);
X					argv[i] = "";
X				}
X#endif
X				lseek(ar_fd, even(member->ar_size),1);
X			}
X			continue;
X		}
X	}
X	if (ex_fl || pr_fl)
X		extract(member);
X	else {
X		if (rep_fl)
X			add(argv[i], temp_fd, "r - %s\n");
X		else if (show_fl) {
X			char buf[sizeof(member->ar_name) + 2];
X			register char *p = buf, *q = member->ar_name;
X
X			while (q <= &member->ar_name[sizeof(member->ar_name)-1] && *q) {
X				*p++ = *q++;
X			}
X			*p++ = '\n';
X			*p = '\0';
X			if (verbose) {
X				char *mode = get_mode(member->ar_mode);
X				char *date = ctime(&(member->ar_date));
X
X				*(date + 16) = '\0';
X				*(date + 24) = '\0';
X
X				print("%s%3u/%u%7ld %s %s %s",
X					mode,
X					(unsigned) (member->ar_uid & 0377),
X					(unsigned) (member->ar_gid & 0377),
X					member->ar_size,
X					date+4,
X					date+20,
X					buf);
X			}
X			else	print(buf);
X		}
X		else if (del_fl)
X			show("d - %s\n", member->ar_name);
X		lseek(ar_fd, even(member->ar_size), 1);
X	}
X	argv[i] = "";
X  }
X
X  if (argc > 3) {
X	for (i = 3; i < argc; i++)
X		if (argv[i][0] != '\0') {
X#ifndef AAL
X			if (app_fl)
X				add(argv[i], ar_fd, "a - %s\n");
X			else
X#endif
X			if (rep_fl
X#ifdef AAL
X				|| app_fl
X#endif
X			)
X				add(argv[i], temp_fd, "a - %s\n");
X			else {
X				print("%s: not found\n", argv[i]);
X			}
X		}
X  }
X
X  if (rep_fl || del_fl
X#ifdef AAL
X		|| app_fl
X#endif
X  ) {
X	signal(SIGINT, SIG_IGN);
X	close(ar_fd);
X	close(temp_fd);
X	ar_fd = open_archive(argv[2], CREATE);
X	temp_fd = open_archive(temp_arch, APPEND);
X#ifdef AAL
X	write_symdef();
X#endif
X	while ((read_chars = read(temp_fd, io_buffer, IO_SIZE)) > 0)
X		mwrite(ar_fd, io_buffer, read_chars);
X	close(temp_fd);
X	unlink(temp_arch);
X  }
X  close(ar_fd);
X}
X
Xadd(name, fd, mess)
Xchar *name;
Xint fd;
Xchar *mess;
X{
X  static MEMBER member;
X  register int read_chars;
X  struct stat status;
X  int src_fd;
X
X  if (stat(name, &status) < 0) {
X	error(FALSE, "cannot find %s\n", name);
X	return;
X  }
X  else if (S_ISDIR(status.st_mode)) {
X	error(FALSE, "%s is a directory (ignored)\n", name);
X	return;
X  }
X  else if ((src_fd = open(name, 0)) < 0) {
X	error(FALSE, "cannot open %s\n", name);
X	return;
X  }
X
X  strncpy (member.ar_name, basename (name), sizeof(member.ar_name));
X  member.ar_uid = status.st_uid;
X  member.ar_gid = status.st_gid;
X  member.ar_mode = status.st_mode;
X  member.ar_date = status.st_mtime;
X  member.ar_size = status.st_size;
X#ifdef DISTRIBUTION
X  if (distr_fl) {
X	member.ar_uid = 2;
X	member.ar_gid = 2;
X	member.ar_mode = 0644;
X	member.ar_date = distr_time;
X  }
X#endif
X  wr_arhdr(fd, &member);
X#ifdef AAL
X  do_object(src_fd, member.ar_size);
X  lseek(src_fd, 0L, 0);
X  offset += AR_TOTAL + even(member.ar_size);
X#endif
X  while (status.st_size > 0) {
X	int x = IO_SIZE;
X
X	read_chars = x;
X	if (status.st_size < x) {
X		x = status.st_size;
X		read_chars = x;
X		status.st_size = 0;
X		x = even(x);
X	}
X	else	status.st_size -= x;
X  	if (read(src_fd, io_buffer, read_chars) != read_chars) {
X		error(FALSE,"%s seems to shrink\n", name);
X		break;
X	}
X	mwrite(fd, io_buffer, x);
X  }
X
X  if (verbose)
X	show(mess, member.ar_name);
X  close(src_fd);
X}
X
Xextract(member)
Xregister MEMBER *member;
X{
X  int fd = 1;
X  char buf[sizeof(member->ar_name) + 1];
X
X  strncpy(buf, member->ar_name, sizeof(member->ar_name));
X  buf[sizeof(member->ar_name)] = 0;
X  if (pr_fl == FALSE && (fd = creat(buf, 0666)) < 0) {
X	error(FALSE, "cannot create %s\n", buf);
X	fd = -1;
X  }
X
X  if (verbose) {
X	if (pr_fl == FALSE) show("x - %s\n", buf);
X	else show("\n<%s>\n\n", buf);
X  }
X
X  copy_member(member, ar_fd, fd, 1);
X
X  if (fd >= 0 && fd != 1)
X  	close(fd);
X  if (pr_fl == FALSE) chmod(buf, member->ar_mode);
X}
X
Xcopy_member(member, from, to, extracting)
Xregister MEMBER *member;
Xint from, to;
X{
X  register int rest;
X  long mem_size = member->ar_size;
X  BOOL is_odd = odd(mem_size) ? TRUE : FALSE;
X
X#ifdef AAL
X  if (! extracting) {
X  	long pos = lseek(from, 0L, 1);
X
X	do_object(from, mem_size);
X	offset += AR_TOTAL + even(mem_size);
X  	lseek(from, pos, 0);
X  }
X#endif
X  do {
X	rest = mem_size > (long) IO_SIZE ? IO_SIZE : (int) mem_size;
X	if (read(from, io_buffer, rest) != rest) {
X		char buf[sizeof(member->ar_name) + 1];
X
X		strncpy(buf, member->ar_name, sizeof(member->ar_name));
X		buf[sizeof(member->ar_name)] = 0;
X		error(TRUE, "read error on %s\n", buf);
X	}
X	if (to >= 0) mwrite(to, io_buffer, rest);
X	mem_size -= (long) rest;
X  } while (mem_size > 0L);
X
X  if (is_odd) {
X	lseek(from, 1L, 1);
X	if (to >= 0 && ! extracting)
X		lseek(to, 1L, 1);
X  }
X}
X
Xchar *
Xget_mode(mode)
Xregister int mode;
X{
X  static char mode_buf[11];
X  register int tmp = mode;
X  int i;
X
X  mode_buf[9] = ' ';
X  for (i = 0; i < 3; i++) {
X	mode_buf[i * 3] = (tmp & S_IREAD) ? 'r' : '-';
X	mode_buf[i * 3 + 1] = (tmp & S_IWRITE) ? 'w' : '-';
X	mode_buf[i * 3 + 2] = (tmp & S_IEXEC) ? 'x' : '-';
X	tmp <<= 3;
X  }
X  if (mode & S_ISUID)
X	mode_buf[2] = 's';
X  if (mode & S_ISGID)
X	mode_buf[5] = 's';
X  return mode_buf;
X}
X
Xwr_fatal()
X{
X	error(TRUE, "write error\n");
X}
X
Xrd_fatal()
X{
X	error(TRUE, "read error\n");
X}
X
Xmwrite(fd, address, bytes)
Xint fd;
Xregister char *address;
Xregister int bytes;
X{
X  if (write(fd, address, bytes) != bytes)
X	error(TRUE, "write error\n");
X}
X
Xshow(s, name)
Xchar *s, *name;
X{
X  MEMBER x;
X  char buf[sizeof(x.ar_name)+1];
X  register char *p = buf, *q = name;
X
X  while (q <= &name[sizeof(x.ar_name)-1] && *q) *p++ = *q++;
X  *p++ = '\0';
X  print(s, buf);
X}
X
X#ifdef AAL
X/*
X * Write out the ranlib table: first 4 bytes telling how many ranlib structs
X * there are, followed by the ranlib structs,
X * then 4 bytes giving the size of the string table, followed by the string
X * table itself.
X */
Xwrite_symdef()
X{
X	register struct ranlib	*ran;
X	register int	i;
X	register long	delta;
X	MEMBER	arbuf;
X
X	if (odd(tssiz))
X		tstrtab[tssiz++] = '\0';
X	for (i = 0; i < sizeof(arbuf.ar_name); i++)
X		arbuf.ar_name[i] = '\0';
X	strcpy(arbuf.ar_name, SYMDEF);
X	arbuf.ar_size = 4 + 2 * 4 * (long)tnum + 4 + (long)tssiz;
X	time(&arbuf.ar_date);
X	arbuf.ar_uid = getuid();
X	arbuf.ar_gid = getgid();
X	arbuf.ar_mode = 0444;
X#ifdef DISTRIBUTION
X	if (distr_fl) {
X		arbuf.ar_uid = 2;
X		arbuf.ar_gid = 2;
X		arbuf.ar_date = distr_time;
X	}
X#endif
X	wr_arhdr(ar_fd,&arbuf);
X	wr_long(ar_fd, (long) tnum);
X	/*
X	 * Account for the space occupied by the magic number
X	 * and the ranlib table.
X	 */
X	delta = 2 + AR_TOTAL + arbuf.ar_size;
X	for (ran = tab; ran < &tab[tnum]; ran++) {
X		ran->ran_pos += delta;
X	}
X
X	wr_ranlib(ar_fd, tab, (long) tnum);
X	wr_long(ar_fd, (long) tssiz);
X	wr_bytes(ar_fd, tstrtab, (long) tssiz);
X}
X
X/*
X * Return whether the bytes in `buf' form a good object header. 
X * The header is put in `headp'.
X */
Xint
Xis_outhead(headp)
X	register struct outhead	*headp;
X{
X
X	return !BADMAGIC(*headp) && headp->oh_nname != 0;
X}
X
Xdo_object(f, size)
X	long size;
X{
X	struct outhead	headbuf;
X
X	if (size < SZ_HEAD) {
X		/* It can't be an object file. */
X		return;
X	}
X	/*
X	 * Read a header to see if it is an object file.
X	 */
X	if (! rd_fdopen(f)) {
X		rd_fatal();
X	}
X	rd_ohead(&headbuf);
X	if (!is_outhead(&headbuf)) {
X		return;
X	}
X	do_names(&headbuf);
X}
X
X/*
X * First skip the names and read in the string table, then seek back to the
X * name table and read and write the names one by one. Update the ranlib table
X * accordingly.
X */
Xdo_names(headp)
X	struct outhead	*headp;
X{
X	register char	*strings;
X	register int	nnames = headp->oh_nname;
X#define NNAMES 100
X	struct outname	namebuf[NNAMES];
X	long xxx = OFF_CHAR(*headp);
X
X	if (	headp->oh_nchar != (unsigned int)headp->oh_nchar ||
X		(strings = malloc((unsigned int)headp->oh_nchar)) == (char *)0
X	   ) {
X		error(TRUE, "string table too big\n");
X	}
X	rd_string(strings, headp->oh_nchar);
X	while (nnames) {
X		int i = nnames >= NNAMES ? NNAMES : nnames;
X		register struct outname *p = namebuf;
X
X		nnames -= i;
X		rd_name(namebuf, i);
X		while (i--) {
X			long off = p->on_foff - xxx;
X			if (p->on_foff == (long)0) {
X				p++;
X				continue; /* An unrecognizable name. */
X			}
X			p->on_mptr = strings + off;
X			/*
X			 * Only enter names that are exported and are really
X			 * defined. Also enter common names. Note, that
X			 * this might cause problems when the name is really
X			 * defined in a later file, with a value != 0.
X			 * However, this problem also exists on the Unix
X			 * ranlib archives.
X			 */
X			if (	(p->on_type & S_EXT) &&
X				(p->on_type & S_TYP) != S_UND
X			   )
X				enter_name(p);
X			p++;
X		}
X	}
X	free(strings);
X}
X
Xenter_name(namep)
X	struct outname *namep;
X{
X	register char	*cp;
X
X	if (tnum >= tabsz) {
X		tab = (struct ranlib *)
X			realloc((char *) tab, (tabsz += 512) * sizeof(struct ranlib));
X		if (! tab) error(TRUE, "Out of core\n");
X	}
X	tab[tnum].ran_off = tssiz;
X	tab[tnum].ran_pos = offset;
X
X	for (cp = namep->on_mptr;; cp++) {
X		if (tssiz >= strtabsz) {
X			tstrtab = realloc(tstrtab, (strtabsz += 4096));
X			if (! tstrtab) error(TRUE, "string table overflow\n");
X		}
X		tstrtab[tssiz++]  = *cp;
X		if (!*cp) break;
X	}
X	tnum++;
X}
X#endif AAL
/
echo x - byte_order.h
sed '/^X/s///' > byte_order.h << '/'
X#if defined(mc68020) || defined(mc68000) || defined(sparc)
X#define BYTES_REVERSED 1
X#define WORDS_REVERSED 1
X#define CHAR_UNSIGNED 0
X#else
X#define BYTES_REVERSED 0
X#define WORDS_REVERSED 0
X#define CHAR_UNSIGNED 0
X#endif
/
echo x - format.c
sed '/^X/s///' > format.c << '/'
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* $Header: format.c,v 1.6 91/03/11 14:32:41 ceriel Exp $ */
X
X#include <varargs.h>
X
Xextern char *long2str();
X
Xstatic int
Xintegral(c)
X{
X	switch (c) {
X	case 'b':
X		return -2;
X	case 'd':
X		return 10;
X	case 'o':
X		return -8;
X	case 'u':
X		return -10;
X	case 'x':
X		return -16;
X	}
X	return 0;
X}
X
X/*VARARGS2*/
X/*FORMAT1 $
X	%s = char *
X	%l = long
X	%c = int
X	%[uxbo] = unsigned int
X	%d = int
X$ */
Xint
X_format(buf, fmt, argp)
X	char *buf, *fmt;
X	register va_list argp;
X{
X	register char *pf = fmt;
X	register char *pb = buf;
X
X	while (*pf) {
X		if (*pf == '%') {
X			register width, base, pad, npad;
X			char *arg;
X			char cbuf[2];
X			char *badformat = "<bad format>";
X			
X			/* get padder */
X			if (*++pf == '0') {
X				pad = '0';
X				++pf;
X			}
X			else
X				pad = ' ';
X			
X			/* get width */
X			width = 0;
X			while (*pf >= '0' && *pf <= '9')
X				width = 10 * width + *pf++ - '0';
X			
X			if (*pf == 's') {
X				arg = va_arg(argp, char *);
X			}
X			else
X			if (*pf == 'c') {
X				cbuf[0] = va_arg(argp, int);
X				cbuf[1] = '\0';
X				arg = &cbuf[0];
X			}
X			else
X			if (*pf == 'l') {
X				/* alignment ??? */
X				if (base = integral(*++pf)) {
X					arg = long2str(va_arg(argp,long), base);
X				}
X				else {
X					pf--;
X					arg = badformat;
X				}
X			}
X			else
X			if (base = integral(*pf)) {
X				arg = long2str((long)va_arg(argp,int), base);
X			}
X			else
X			if (*pf == '%')
X				arg = "%";
X			else
X				arg = badformat;
X
X			npad = width - strlen(arg);
X
X			while (npad-- > 0)
X				*pb++ = pad;
X			
X			while (*pb++ = *arg++);
X			pb--;
X			pf++;
X		}
X		else
X			*pb++ = *pf++;
X	}
X	return pb - buf;
X}
/
echo x - local.h
sed '/^X/s///' > local.h << '/'
X/* $Header: local.h,v 2.7 88/07/08 10:33:53 ceriel Exp $ */
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* collection of options, selected by including or excluding 'defines' */
X
X/* Version number of the EM object code */
X#	define	VERSION		3	/* 16 bits number */
X
X/* The default machine used by ack, acc, apc */
X#	define	ACKM		"minix"
X
X/* size of local machine, either 0 (for 16 bit address space), or 1 */
X#	undef BIGMACHINE	1
X
X/* operating system, SYS_5, V7, BSD4_1 or BSD4_2; Do NOT delete the comment
X   in the next line! */
X#	define V7  1       /* SYSTEM */
/
echo x - long2str.c
sed '/^X/s///' > long2str.c << '/'
X/* $Header: long2str.c,v 1.4 90/02/27 14:30:10 ceriel Exp $ */
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* Integer to String translator
X	-> base is a value from [-16,-2] V [2,16]
X	-> base < 0: see 'val' as unsigned value
X	-> no checks for buffer overflow and illegal parameters
X	(1985, EHB)
X*/
X
X#define MAXWIDTH 32
X
Xchar *
Xlong2str(val, base)
X	register long val;
X	register base;
X{
X	static char numbuf[MAXWIDTH];
X	static char vec[] = "0123456789ABCDEF";
X	register char *p = &numbuf[MAXWIDTH];
X	int sign = (base > 0);
X
X	*--p = '\0';		/* null-terminate string	*/
X	if (val) {
X		if (base > 0) {
X			if (val < 0L) {
X				long v1 = -val;
X				if (v1 == val)
X					goto overflow;
X				val = v1;
X			}
X			else
X				sign = 0;
X		}
X		else
X		if (base < 0) {			/* unsigned */
X			base = -base;
X			if (val < 0L) {	/* taken from Amoeba src */
X				register mod, i;
X			overflow:
X				mod = 0;
X				for (i = 0; i < 8 * sizeof val; i++) {
X					mod <<= 1;
X					if (val < 0)
X						mod++;
X					val <<= 1;
X					if (mod >= base) {
X						mod -= base;
X						val++;
X					}
X				}
X				*--p = vec[mod];
X			}
X		}
X		do {
X			*--p = vec[(int) (val % base)];
X			val /= base;
X		} while (val != 0L);
X		if (sign)
X			*--p = '-';	/* don't forget it !!	*/
X	}
X	else
X		*--p = '0';		/* just a simple 0	*/
X	return p;
X}
/
echo x - object.h
sed '/^X/s///' > object.h << '/'
X/* $Header: object.h,v 1.7 91/01/18 09:54:23 ceriel Exp $ */
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X#include "byte_order.h"
X#include <local.h>
X#include <stdio.h>
X
X#if CHAR_UNSIGNED
X#define Xchar(ch)	(ch)
X#else
X#define Xchar(ch)	((ch) & 0377)
X#endif
X
X#if ! defined(BYTES_REVERSED)
X#define BYTES_REVERSED 1
X#endif
X
X#if ! defined(WORDS_REVERSED)
X#define WORDS_REVERSED 1
X#endif
X
X#if BYTES_REVERSED
X#define uget2(c)	(Xchar((c)[0]) | ((unsigned) Xchar((c)[1]) << 8))
X#define Xput2(i, c)	(((c)[0] = (i)), ((c)[1] = (i) >> 8))
X#define put2(i, c)	{ register int j = (i); Xput2(j, c); }
X#else
X#define uget2(c)	(* ((unsigned short *) (c)))
X#define Xput2(i, c)	(* ((short *) (c)) = (i))
X#define put2(i, c)	Xput2(i, c)
X#endif
X
X#define get2(c)		((short) uget2(c))
X
X#if WORDS_REVERSED || BYTES_REVERSED
X#define get4(c)		(uget2(c) | ((long) uget2((c)+2) << 16))
X#define put4(l, c)	{ register long x=(l); \
X			  Xput2((int)x,c); \
X			  Xput2((int)(x>>16),(c)+2); \
X			}
X#else
X#define get4(c)		(* ((long *) (c)))
X#define put4(l, c)	(* ((long *) (c)) = (l))
X#endif
X
X#define SECTCNT	3	/* number of sections with own output buffer */
X#if BIGMACHINE
X#define WBUFSIZ	(8*BUFSIZ)
X#else
X#define WBUFSIZ	BUFSIZ
X#endif
X
Xstruct fil {
X	int	cnt;
X	char	*pnow;
X	char	*pbegin;
X	long	currpos;
X	int	fd;
X	char	pbuf[WBUFSIZ];
X};
X
Xextern struct fil __parts[];
X
X#define	PARTEMIT	0
X#define	PARTRELO	(PARTEMIT+SECTCNT)
X#define	PARTNAME	(PARTRELO+1)
X#define	PARTCHAR	(PARTNAME+1)
X#ifdef SYMDBUG
X#define PARTDBUG	(PARTCHAR+1)
X#else
X#define PARTDBUG	(PARTCHAR+0)
X#endif
X#define	NPARTS		(PARTDBUG + 1)
X
X#define getsect(s)      (PARTEMIT+((s)>=(SECTCNT-1)?(SECTCNT-1):(s)))
/
echo x - out.h
sed '/^X/s///' > out.h << '/'
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* $Header: out.h,v 2.5 90/10/25 11:18:20 ceriel Exp $ */
X
X#ifndef __OUT_H_INCLUDED
X#define __OUT_H_INCLUDED
X/*
X * output format for ACK assemblers
X */
X#ifndef ushort
X#define ushort	unsigned short
X#endif /* ushort */
X
Xstruct outhead {
X	ushort 	oh_magic;	/* magic number */
X	ushort 	oh_stamp;	/* version stamp */
X	ushort	oh_flags;	/* several format flags */
X	ushort	oh_nsect;	/* number of outsect structures */
X	ushort	oh_nrelo;	/* number of outrelo structures */
X	ushort	oh_nname;	/* number of outname structures */
X	long	oh_nemit;	/* sum of all os_flen */
X	long	oh_nchar;	/* size of string area */
X};
X
X#define O_MAGIC	0x0201		/* magic number of output file */
X#define	O_STAMP	0		/* version stamp */
X#define MAXSECT	64		/* Maximum number of sections */
X
X#define	HF_LINK	0x0004		/* unresolved references left */
X#define	HF_8086	0x0008		/* os_base specially encoded */
X
Xstruct outsect {
X	long 	os_base;	/* startaddress in machine */
X	long	os_size;	/* section size in machine */
X	long	os_foff;	/* startaddress in file */
X	long	os_flen;	/* section size in file */
X	long	os_lign;	/* section alignment */
X};
X
Xstruct outrelo {
X	char	or_type;	/* type of reference */
X	char	or_sect;	/* referencing section */
X	ushort	or_nami;	/* referenced symbol index */
X	long	or_addr;	/* referencing address */
X};
X
Xstruct outname {
X	union {
X	  char	*on_ptr;	/* symbol name (in core) */
X	  long	on_off;		/* symbol name (in file) */
X	}	on_u;
X#define on_mptr	on_u.on_ptr
X#define on_foff	on_u.on_off
X	ushort	on_type;	/* symbol type */
X	ushort	on_desc;	/* debug info */
X	long	on_valu;	/* symbol value */
X};
X
X/*
X * relocation type bits
X */
X#define RELSZ	0x07		/* relocation length */
X#define RELO1	   1		/* 1 byte */
X#define RELO2	   2		/* 2 bytes */
X#define RELO4	   4		/* 4 bytes */
X#define RELPC	0x08		/* pc relative */
X#define RELBR	0x10		/* High order byte lowest address. */
X#define RELWR	0x20		/* High order word lowest address. */
X
X/*
X * section type bits and fields
X */
X#define S_TYP	0x007F		/* undefined, absolute or relative */
X#define S_EXT	0x0080		/* external flag */
X#define S_ETC	0x7F00		/* for symbolic debug, bypassing 'as' */
X
X/*
X * S_TYP field values
X */
X#define S_UND	0x0000		/* undefined item */
X#define S_ABS	0x0001		/* absolute item */
X#define S_MIN	0x0002		/* first user section */
X#define S_MAX	(S_TYP-1)	/* last user section */
X#define S_CRS	S_TYP		/* on_valu is symbol index which contains value */
X
X/*
X * S_ETC field values
X */
X#define S_SCT	0x0100		/* section names */
X#define S_LIN	0x0200		/* hll source line item */
X#define S_FIL	0x0300		/* hll source file item */
X#define S_MOD	0x0400		/* ass source file item */
X#define S_COM	0x1000		/* Common name. */
X#define S_STB	0xe000		/* entries with any of these bits set are
X				   reserved for debuggers
X				*/
X
X/*
X * structure format strings
X */
X#define SF_HEAD		"22222244"
X#define SF_SECT		"44444"
X#define SF_RELO		"1124"
X#define SF_NAME		"4224"
X
X/*
X * structure sizes (bytes in file; add digits in SF_*)
X */
X#define SZ_HEAD		20
X#define SZ_SECT		20
X#define SZ_RELO		8
X#define SZ_NAME		12
X
X/*
X * file access macros
X */
X#define BADMAGIC(x)	((x).oh_magic!=O_MAGIC)
X#define OFF_SECT(x)	SZ_HEAD
X#define OFF_EMIT(x)	(OFF_SECT(x) + ((long)(x).oh_nsect * SZ_SECT))
X#define OFF_RELO(x)	(OFF_EMIT(x) + (x).oh_nemit)
X#define OFF_NAME(x)	(OFF_RELO(x) + ((long)(x).oh_nrelo * SZ_RELO))
X#define OFF_CHAR(x)	(OFF_NAME(x) + ((long)(x).oh_nname * SZ_NAME))
X
X#endif /* __OUT_H_INCLUDED */
/
echo x - param.h
sed '/^X/s///' > param.h << '/'
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* $Header: param.h,v 1.2 87/03/09 14:51:35 ceriel Exp $ */
X
X#define SSIZE 1024
/
echo x - print.c
sed '/^X/s///' > print.c << '/'
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* $Header: print.c,v 1.6 91/03/11 14:33:01 ceriel Exp $ */
X
X#include <varargs.h>
X#include <system.h>
X#include "param.h"
X
X/*VARARGS*/
X/*FORMAT0v $
X	%s = char *
X	%l = long
X	%c = int
X	%[uxbo] = unsigned int
X	%d = int
X$ */
Xprint(va_alist)
X	va_dcl
X{
X	char *fmt;
X	va_list args;
X	char buf[SSIZE];
X
X	va_start(args);
X	fmt = va_arg(args, char *);
X	sys_write(STDOUT, buf, _format(buf, fmt, args));
X	va_end(args);
X}
/
echo x - ranlib.h
sed '/^X/s///' > ranlib.h << '/'
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* $Header: ranlib.h,v 2.3 90/10/25 11:18:34 ceriel Exp $ */
X
X#ifndef __RANLIB_H_INCLUDED
X#define __RANLIB_H_INCLUDED
X
X#ifndef SYMDEF
X#	define SYMDEF	"__.SYMDEF"
X#endif /* SYMDEF */
X
X/*
X * Structure of the SYMDEF table of contents for an archive.
X * SYMDEF begins with a long giving the number of ranlib
X * structures that immediately follow, and then continues with a string
X * table consisting of a long giving the number of bytes of
X * strings that follow and then the strings themselves.
X */
Xstruct ranlib {
X	union {
X	  char	*ran__ptr;	/* symbol name (in core) */
X	  long	ran__off;	/* symbol name (in file) */
X	}	ran_u;
X#define ran_ptr ran_u.ran__ptr
X#define ran_off ran_u.ran__off
X	long	ran_pos;	/* library member is at this position */
X};
X
X#define SZ_RAN	8
X#define SF_RAN	"44"
X
X#endif /* __RANLIB_H_INCLUDED */
/
echo x - rd.c
sed '/^X/s///' > rd.c << '/'
X/* $Header: rd.c,v 1.7 91/01/18 09:54:34 ceriel Exp $ */
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X#include <out.h>
X#include "object.h"
X
Xextern long		lseek();
X
X/*
X * Parts of the output file.
X */
X#undef PARTEMIT
X#undef PARTRELO
X#undef PARTNAME
X#undef PARTCHAR
X#undef PARTDBUG
X#undef NPARTS
X
X#define	PARTEMIT	0
X#define	PARTRELO	1
X#define	PARTNAME	2
X#define	PARTCHAR	3
X#ifdef SYMDBUG
X#define PARTDBUG	4
X#else
X#define PARTDBUG	3
X#endif
X#define	NPARTS		(PARTDBUG + 1)
X
Xstatic long		offset[MAXSECT];
X
Xstatic int		outfile;
Xstatic long		outseek[NPARTS];
Xstatic long		currpos;
Xstatic long		rd_base;
X#define OUTSECT(i) \
X	(outseek[PARTEMIT] = offset[i])
X#define BEGINSEEK(p, o) \
X	(outseek[(p)] = (o))
X
Xstatic int sectionnr;
X
Xstatic
XOUTREAD(p, b, n)
X	char *b;
X	long n;
X{
X	register long l = outseek[p];
X
X	if (currpos != l) {
X		lseek(outfile, l, 0);
X	}
X	rd_bytes(outfile, b, n);
X	l += n;
X	currpos = l;
X	outseek[p] = l;
X}
X
X/*
X * Open the output file according to the chosen strategy.
X */
Xint
Xrd_open(f)
X	char *f;
X{
X
X	if ((outfile = open(f, 0)) < 0)
X		return 0;
X	return rd_fdopen(outfile);
X}
X
Xstatic int offcnt;
X
Xrd_fdopen(fd)
X{
X	register int i;
X
X	for (i = 0; i < NPARTS; i++) outseek[i] = 0;
X	offcnt = 0;
X	rd_base = lseek(fd, 0L, 1);
X	if (rd_base < 0) {
X		return 0;
X	}
X	currpos = rd_base;
X	outseek[PARTEMIT] = currpos;
X	outfile = fd;
X	sectionnr = 0;
X	return 1;
X}
X
Xrd_close()
X{
X
X	close(outfile);
X	outfile = -1;
X}
X
Xrd_fd()
X{
X	return outfile;
X}
X
Xrd_ohead(head)
X	register struct outhead	*head;
X{
X	register long off;
X
X	OUTREAD(PARTEMIT, (char *) head, (long) SZ_HEAD);
X#if ! (BYTES_REVERSED || WORDS_REVERSED)
X	if (sizeof(struct outhead) != SZ_HEAD)
X#endif
X	{
X		register char *c = (char *) head + (SZ_HEAD-4);
X		
X		head->oh_nchar = get4(c);
X		c -= 4; head->oh_nemit = get4(c);
X		c -= 2; head->oh_nname = uget2(c);
X		c -= 2; head->oh_nrelo = uget2(c);
X		c -= 2; head->oh_nsect = uget2(c);
X		c -= 2; head->oh_flags = uget2(c);
X		c -= 2; head->oh_stamp = uget2(c);
X		c -= 2; head->oh_magic = uget2(c);
X	}
X	off = OFF_RELO(*head) + rd_base;
X	BEGINSEEK(PARTRELO, off);
X	off += (long) head->oh_nrelo * SZ_RELO;
X	BEGINSEEK(PARTNAME, off);
X	off += (long) head->oh_nname * SZ_NAME;
X	BEGINSEEK(PARTCHAR, off);
X#ifdef SYMDBUG
X	off += head->oh_nchar;
X	BEGINSEEK(PARTDBUG, off);
X#endif
X}
X
Xrd_rew_relos(head)
X	register struct outhead *head;
X{
X	register long off = OFF_RELO(*head) + rd_base;
X
X	BEGINSEEK(PARTRELO, off);
X}
X
Xrd_sect(sect, cnt)
X	register struct outsect	*sect;
X	register unsigned int	cnt;
X{
X	register char *c = (char *) sect + cnt * SZ_SECT;
X
X	OUTREAD(PARTEMIT, (char *) sect, (long)cnt * SZ_SECT);
X	sect += cnt;
X	offcnt += cnt;
X	while (cnt--) {
X		sect--;
X#if ! (BYTES_REVERSED || WORDS_REVERSED)
X		if (sizeof(struct outsect) != SZ_SECT)
X#endif
X		{
X			c -= 4; sect->os_lign = get4(c);
X			c -= 4; sect->os_flen = get4(c);
X			c -= 4; sect->os_foff = get4(c);
X		}
X		offset[--offcnt] = sect->os_foff + rd_base;
X#if ! (BYTES_REVERSED || WORDS_REVERSED)
X		if (sizeof(struct outsect) != SZ_SECT)
X#endif
X		{
X			c -= 4; sect->os_size = get4(c);
X			c -= 4; sect->os_base = get4(c);
X		}
X	}
X}
X
Xrd_outsect(s)
X{
X	OUTSECT(s);
X	sectionnr = s;
X}
X
X/*
X * We don't have to worry about byte order here.
X */
Xrd_emit(emit, cnt)
X	char		*emit;
X	long		cnt;
X{
X	OUTREAD(PARTEMIT, emit, cnt);
X	offset[sectionnr] += cnt;
X}
X
Xrd_relo(relo, cnt)
X	register struct outrelo	*relo;
X	register unsigned int cnt;
X{
X
X	OUTREAD(PARTRELO, (char *) relo, (long) cnt * SZ_RELO);
X#if ! (BYTES_REVERSED || WORDS_REVERSED)
X	if (sizeof(struct outrelo) != SZ_RELO)
X#endif
X	{
X		register char *c = (char *) relo + (long) cnt * SZ_RELO;
X
X		relo += cnt;
X		while (cnt--) {
X			relo--;
X			c -= 4; relo->or_addr = get4(c);
X			c -= 2; relo->or_nami = uget2(c);
X			relo->or_sect = *--c;
X			relo->or_type = *--c;
X		}
X	}
X}
X
Xrd_name(name, cnt)
X	register struct outname	*name;
X	register unsigned int cnt;
X{
X
X	OUTREAD(PARTNAME, (char *) name, (long) cnt * SZ_NAME);
X#if ! (BYTES_REVERSED || WORDS_REVERSED)
X	if (sizeof(struct outname) != SZ_NAME)
X#endif
X	{
X		register char *c = (char *) name + (long) cnt * SZ_NAME;
X
X		name += cnt;
X		while (cnt--) {
X			name--;
X			c -= 4; name->on_valu = get4(c);
X			c -= 2; name->on_desc = uget2(c);
X			c -= 2; name->on_type = uget2(c);
X			c -= 4; name->on_foff = get4(c);
X		}
X	}
X}
X
Xrd_string(addr, len)
X	char *addr;
X	long len;
X{
X	
X	OUTREAD(PARTCHAR, addr, len);
X}
X
X#ifdef SYMDBUG
Xrd_dbug(buf, size)
X	char		*buf;
X	long		size;
X{
X	OUTREAD(PARTDBUG, buf, size);
X}
X#endif
/
echo x - rd_arhdr.c
sed '/^X/s///' > rd_arhdr.c << '/'
X/* $Header: rd_arhdr.c,v 1.8 91/01/18 09:54:49 ceriel Exp $ */
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X#include <arch.h>
X#include "object.h"
X
Xint
Xrd_arhdr(fd, arhdr)
X	register struct ar_hdr	*arhdr;
X{
X	char buf[AR_TOTAL];
X	register char *c = buf;
X	register char *p = arhdr->ar_name;
X	register int i;
X
X	i = read(fd, c, AR_TOTAL);
X	if (i == 0) return 0;
X	if (i != AR_TOTAL) {
X		rd_fatal();
X	}
X	i = 14;
X	while (i--) {
X		*p++ = *c++;
X	}
X	arhdr->ar_date = ((long) get2(c)) << 16; c += 2;
X	arhdr->ar_date |= ((long) get2(c)) & 0xffff; c += 2;
X	arhdr->ar_uid = *c++;
X	arhdr->ar_gid = *c++;
X	arhdr->ar_mode = get2(c); c += 2;
X	arhdr->ar_size = (long) get2(c) << 16; c += 2;
X	arhdr->ar_size |= (long) get2(c) & 0xffff;
X	return 1;
X}
/
echo x - rd_bytes.c
sed '/^X/s///' > rd_bytes.c << '/'
X/* $Header: rd_bytes.c,v 1.5 87/03/10 09:15:39 ceriel Exp $ */
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X#define MININT		(1 << (sizeof(int) * 8 - 1))
X#define MAXCHUNK	(~MININT)	/* Highest count we read(2).	*/
X/* Unfortunately, MAXCHUNK is too large with some  compilers. Put it in
X   an int!
X*/
X
Xstatic int maxchunk = MAXCHUNK;
X
X/*
X * We don't have to worry about byte order here.
X * Just read "cnt" bytes from file-descriptor "fd".
X */
Xint 
Xrd_bytes(fd, string, cnt)
X	register char	*string;
X	register long	cnt;
X{
X
X	while (cnt) {
X		register int n = cnt >= maxchunk ? maxchunk : cnt;
X
X		if (read(fd, string, n) != n)
X			rd_fatal();
X		string += n;
X		cnt -= n;
X	}
X}
/
echo x - rd_unsig2.c
sed '/^X/s///' > rd_unsig2.c << '/'
X/* $Header: rd_unsig2.c,v 1.3 87/03/10 09:16:26 ceriel Exp $ */
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X#include "object.h"
X
Xunsigned int
Xrd_unsigned2(fd)
X{
X	char buf[2];
X
X	rd_bytes(fd, buf, 2L);
X	return uget2(buf);
X}
/
echo x - sprint.c
sed '/^X/s///' > sprint.c << '/'
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* $Header: sprint.c,v 1.6 91/03/11 14:33:13 ceriel Exp $ */
X
X#include <varargs.h>
X#include <system.h>
X#include "param.h"
X
X/*VARARGS*/
X/*FORMAT1v $
X	%s = char *
X	%l = long
X	%c = int
X	%[uxbo] = unsigned int
X	%d = int
X$ */
Xchar *
Xsprint(va_alist)
X	va_dcl
X{
X	char *buf, *fmt;
X	va_list args;
X
X	va_start(args);
X	buf = va_arg(args, char *);
X	fmt = va_arg(args, char *);
X	buf[_format(buf, fmt, args)] = '\0';
X	va_end(args);
X	return buf;
X}
/
echo x - system.c
sed '/^X/s///' > system.c << '/'
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* RCS: $Header: system.c,v 1.2 87/03/09 15:05:46 ceriel Exp $ */
X
X#include <system.h>
X
XFile _sys_ftab[SYS_NOPEN] = {
X	{ 0, OP_READ},
X	{ 1, OP_APPEND},
X	{ 2, OP_APPEND}
X};
X
XFile *
X_get_entry()
X{
X	register File *fp;
X
X	for (fp = &_sys_ftab[0]; fp < &_sys_ftab[SYS_NOPEN]; fp++)
X		if (fp->o_flags == 0)
X			return fp;
X	return (File *)0;
X}
/
echo x - system.h
sed '/^X/s///' > system.h << '/'
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* RCS: $Header: system.h,v 1.3 88/09/27 09:48:10 ceriel Exp $ */
X#ifndef __SYSTEM_INCLUDED__
X#define __SYSTEM_INCLUDED__
X
Xstruct _sys_fildes {
X	int o_fd;	/* UNIX filedescriptor */
X	int o_flags;	/* flags for open; 0 if not used */
X};
X
Xtypedef struct _sys_fildes File;
X
Xextern File _sys_ftab[];
X
X/* flags for sys_open() */
X#define OP_READ		01
X#define OP_WRITE	02
X#define OP_APPEND	04
X
X/* flags for sys_access() */
X#define AC_EXIST	00
X#define AC_READ		04
X#define AC_WRITE	02
X#define AC_EXEC		01
X
X/* flags for sys_stop() */
X#define S_END	0
X#define S_EXIT	1
X#define S_ABORT	2
X
X/* standard file decsriptors */
X#define STDIN	&_sys_ftab[0]
X#define STDOUT	&_sys_ftab[1]
X#define STDERR	&_sys_ftab[2]
X
X/* maximum number of open files */
X#define SYS_NOPEN	20
X
X/* return value for sys_break */
X#define ILL_BREAK	((char *)0)
X
X/* system's idea of block */
X#define BUFSIZ	1024
X#endif __SYSTEM_INCLUDED__
/
echo x - varargs.h
sed '/^X/s///' > varargs.h << '/'
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* $Header: varargs.h,v 1.1 91/02/20 14:53:23 ceriel Exp $ */
X
X#ifndef _VARARGS_H
X#define _VARARGS_H
X
Xtypedef char *va_list;
X# define __va_sz(mode)	(((sizeof(mode) + sizeof(int) - 1) / sizeof(int)) * sizeof(int))
X# define va_dcl int va_alist;
X# define va_start(list) (list = (char *) &va_alist)
X# define va_end(list)
X# define va_arg(list,mode) (*((mode *)((list += __va_sz(mode)) - __va_sz(mode))))
X#endif /* _VARARGS_H */
/
echo x - wr_arhdr.c
sed '/^X/s///' > wr_arhdr.c << '/'
X/* $Header: wr_arhdr.c,v 1.6 91/01/18 09:54:56 ceriel Exp $ */
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X#include <arch.h>
X#include "object.h"
X
Xwr_arhdr(fd, arhdr)
X	register struct ar_hdr	*arhdr;
X{
X	char buf[AR_TOTAL];
X	register char *c = buf;
X	register char *p = arhdr->ar_name;
X	register int i = 14;
X
X	while (i--) {
X		*c++ = *p++;
X	}
X	put2((int)(arhdr->ar_date>>16),c); c += 2;
X	put2((int)(arhdr->ar_date),c); c += 2;
X	*c++ = arhdr->ar_uid;
X	*c++ = arhdr->ar_gid;
X	put2(arhdr->ar_mode,c); c += 2;
X	put2((int)(arhdr->ar_size>>16),c); c += 2;
X	put2((int)(arhdr->ar_size),c);
X	wr_bytes(fd, buf, (long) AR_TOTAL);
X}
/
echo x - wr_bytes.c
sed '/^X/s///' > wr_bytes.c << '/'
X/* $Header: wr_bytes.c,v 1.5 87/03/10 09:17:12 ceriel Exp $ */
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X#define MININT		(1 << (sizeof(int) * 8 - 1))
X#define MAXCHUNK	(~MININT)	/* Highest count we write(2).	*/
X/* Notice that MAXCHUNK itself might be too large with some compilers.
X   You have to put it in an int!
X*/
X
Xstatic int maxchunk = MAXCHUNK;
X
X/*
X * Just write "cnt" bytes to file-descriptor "fd".
X */
Xwr_bytes(fd, string, cnt)
X	register char	*string;
X	register long	cnt;
X{
X
X	while (cnt) {
X		register int n = cnt >= maxchunk ? maxchunk : cnt;
X
X		if (write(fd, string, n) != n)
X			wr_fatal();
X		string += n;
X		cnt -= n;
X	}
X}
/
echo x - wr_int2.c
sed '/^X/s///' > wr_int2.c << '/'
X/* $Header: wr_int2.c,v 1.3 87/03/10 09:17:23 ceriel Exp $ */
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X#include "object.h"
X
Xwr_int2(fd, i)
X{
X	char buf[2];
X
X	put2(i, buf);
X	wr_bytes(fd, buf, 2L);
X}
/
echo x - wr_long.c
sed '/^X/s///' > wr_long.c << '/'
X/* $Header: wr_long.c,v 1.3 87/03/10 09:17:35 ceriel Exp $ */
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X#include "object.h"
X
Xwr_long(fd, l)
X	long l;
X{
X	char buf[4];
X
X	put4(l, buf);
X	wr_bytes(fd, buf, 4L);
X}
/
echo x - wr_ranlib.c
sed '/^X/s///' > wr_ranlib.c << '/'
X/* $Header: wr_ranlib.c,v 1.4 87/03/10 09:18:01 ceriel Exp $ */
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X#include <ranlib.h>
X#include "object.h"
X
Xwr_ranlib(fd, ran, cnt)
X	register struct ranlib	*ran;
X	register long	cnt;
X{
X#if ! (BYTES_REVERSED || WORDS_REVERSED)
X	if (sizeof (struct ranlib) != SZ_RAN)
X#endif
X	{
X		char buf[100 * SZ_RAN];
X
X		while (cnt) {
X			register int i = (cnt > 100) ? 100 : cnt;
X			register char *c = buf;
X			long j = i * SZ_RAN;
X
X			cnt -= i;
X			while (i--) {
X				put4(ran->ran_off,c); c += 4;
X				put4(ran->ran_pos,c); c += 4;
X				ran++;
X			}
X			wr_bytes(fd, buf, j);
X		}
X	}
X#if ! (BYTES_REVERSED || WORDS_REVERSED)
X	else	wr_bytes(fd, (char *) ran, cnt * SZ_RAN);
X#endif
X}
/
echo x - write.c
sed '/^X/s///' > write.c << '/'
X/*
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* $Header: write.c,v 1.3 89/06/30 14:46:27 ceriel Exp $ */
X
X#include <system.h>
X
Xint
Xsys_write(fp, bufptr, nbytes)
X	File *fp;
X	char *bufptr;
X	int nbytes;
X{
X	if (! fp) return 0;
X	return write(fp->o_fd, bufptr, nbytes) == nbytes;
X}
/
