echo x - Makefile
sed '/^X/s///' > Makefile << '/'
X# Makefile for advent
X
XCFLAGS	= -m -D_POSIX_SOURCE -D_MINIX
XO=o
X
XOBJS   = advent.$O database.$O english.$O itverb.$O turn.$O verb.$O
X
Xadvent:	$(OBJS)
X	cc -i -o advent $(OBJS)
X
Xadvent0: advent0.$O
X	cc -o advent0 advent0.$O
X 
Xadvent.$O: advent.h advword.h advtext.h advdef.h
Xdatabase.$O: advent.h advdec.h advcave.h
Xenglish.$O itverb.$O turn.$O verb.$O: advent.h advdec.h
X
Xclean:	
X	@rm -rf *.o *.s *.bak core advent
/
echo x - advcave.h
sed '/^X/s///' > advcave.h << '/'
X
X/*	header ADVCAVE.H					*/
X
X
X/*	WARNING: the travel array for the cave is stored as MAXLOC
X           strings.  the strings are an array of 1..MAXTRAV
X           LONG INTEGERS.  this requires 32 bit LONG INTEGERS.
X           these values are used in database.c "gettrav".
X           tdset*1000000 + tverb*1000 + tcond = value stored
X*/
X
Xstatic long room1[MAXTRAV] = {2002000, 2044000, 2029000, 3003000, 3012000,
X        3019000, 3043000, 4005000, 4013000, 4014000, 4046000, 4030000,
X		      5006000, 5045000, 5043000, 8063000};
Xstatic long room2[MAXTRAV] = {1002000, 1012000, 1007000, 1043000, 1045000,
X		      1030000, 5006000, 5045000, 5046000};
Xstatic long room3[MAXTRAV] = {1003000, 1011000, 1032000, 1044000, 11062000,
X		      33065000, 79005000, 79014000};
Xstatic long room4[MAXTRAV] = {1004000, 1012000, 1045000, 5006000, 5043000,
X	      5044000, 5029000, 7005000, 7046000, 7030000, 8063000};
Xstatic long room5[MAXTRAV] = {4009000, 4043000, 4030000, 5006050, 5007050,
X		      5045050, 6006000, 5044000, 5046000};
Xstatic long room6[MAXTRAV] = {1002000, 1045000, 4009000, 4043000, 4044000,
X		      4030000, 5006000, 5046000};
Xstatic long room7[MAXTRAV] = {1012000, 4004000, 4045000, 5006000, 5043000,
X    5044000, 8005000, 8015000, 8016000, 8046000, 595060000, 595014000,
X		      595030000};
Xstatic long room8[MAXTRAV] = {5006000, 5043000, 5046000, 5044000, 1012000,
X     7004000, 7013000, 7045000, 9003303, 9019303, 9030303, 593003000};
Xstatic long room9[MAXTRAV] = {8011303, 8029303, 593011000, 10017000, 10018000,
X		      10019000, 10044000, 14031000, 11051000};
Xstatic long room10[MAXTRAV] = {9011000, 9020000, 9021000, 9043000, 11019000,
X		       11022000, 11044000, 11051000, 14031000};
Xstatic long room11[MAXTRAV] = {8063303, 9064000, 10017000, 10018000, 10023000,
X  10024000, 10043000, 12025000, 12019000, 12029000, 12044000, 3062000,
X		       14031000};
Xstatic long room12[MAXTRAV] = {8063303, 9064000, 11030000, 11043000, 11051000,
X		       13019000, 13029000, 13044000, 14031000};
Xstatic long room13[MAXTRAV] = {8063303, 9064000, 11051000, 12025000, 12043000,
X		       14023000, 14031000, 14044000};
Xstatic long room14[MAXTRAV] = {8063303, 9064000, 11051000, 13023000, 13043000,
X	20030150, 20031150, 20034150, 15030000, 16033000, 16044000};
Xstatic long room15[MAXTRAV] = {18036000, 18046000, 17007000, 17038000,
X	 17044000, 19010000, 19030000, 19045000, 22029150, 22031150,
X	22034150, 22035150, 22023150, 22043150, 14029000, 34055000};
Xstatic long room16[MAXTRAV] = {14001000};
Xstatic long room17[MAXTRAV] = {15038000, 15043000, 596039312, 21007412,
X	      597041412, 597042412, 597044412, 597069412, 27041000};
Xstatic long room18[MAXTRAV] = {15038000, 15011000, 15045000};
Xstatic long room19[MAXTRAV] = {15010000, 15029000, 15043000, 28045311,
X	 28036311, 29046311, 29037311, 30044311, 30007311, 32045000,
X		       74049035, 32049211, 74066000};
Xstatic long room20[MAXTRAV] = {001000};
Xstatic long room21[MAXTRAV] = {001000};
Xstatic long room22[MAXTRAV] = {15001000};
Xstatic long room23[MAXTRAV] = {67043000, 67042000, 68044000, 68061000,
X		       25030000, 25031000, 648052000};
Xstatic long room24[MAXTRAV] = {67029000, 67011000};
Xstatic long room25[MAXTRAV] = {23029000, 23011000, 31056724, 26056000};
Xstatic long room26[MAXTRAV] = {88001000};
Xstatic long room27[MAXTRAV] = {596039312, 21007412, 597041412, 597042412,
X		597043412, 597069412, 17041000, 40045000, 41044000};
Xstatic long room28[MAXTRAV] = {19038000, 19011000, 19046000, 33045000,
X		       33055000, 36030000, 36052000};
Xstatic long room29[MAXTRAV] = {19038000, 19011000, 19045000};
Xstatic long room30[MAXTRAV] = {19038000, 19011000, 19043000, 62044000,
X		       62029000};
Xstatic long room31[MAXTRAV] = {89001524, 90001000};
Xstatic long room32[MAXTRAV] = {19001000};
Xstatic long room33[MAXTRAV] = {3065000, 28046000, 34043000, 34053000,
X		       34054000, 35044000, 302071159, 100071000};
Xstatic long room34[MAXTRAV] = {33030000, 33055000, 15029000};
Xstatic long room35[MAXTRAV] = {33043000, 33055000, 20039000};
Xstatic long room36[MAXTRAV] = {37043000, 37017000, 28029000, 28052000,
X		       39044000, 65070000};
Xstatic long room37[MAXTRAV] = {36044000, 36017000, 38030000, 38031000,
X		       38056000};
Xstatic long room38[MAXTRAV] = {37056000, 37029000, 37011000, 595060000,
X		       595014000, 595030000, 595004000, 595005000};
Xstatic long room39[MAXTRAV] = {36043000, 36023000, 64030000, 64052000,
X		       64058000, 65070000};
Xstatic long room40[MAXTRAV] = {41001000};
Xstatic long room41[MAXTRAV] = {42046000, 42029000, 42023000, 42056000,
X		       27043000, 59045000, 60044000, 60017000};
Xstatic long room42[MAXTRAV] = {41029000, 42045000, 43043000, 45046000,
X		       80044000};
Xstatic long room43[MAXTRAV] = {42044000, 44046000, 45043000};
Xstatic long room44[MAXTRAV] = {43043000, 48030000, 50046000, 82045000};
Xstatic long room45[MAXTRAV] = {42044000, 43045000, 46043000, 47046000,
X		       87029000, 87030000};
Xstatic long room46[MAXTRAV] = {45044000, 45011000};
Xstatic long room47[MAXTRAV] = {45043000, 45011000};
Xstatic long room48[MAXTRAV] = {44029000, 44011000};
Xstatic long room49[MAXTRAV] = {50043000, 51044000};
Xstatic long room50[MAXTRAV] = {44043000, 49044000, 51030000, 52046000};
Xstatic long room51[MAXTRAV] = {49044000, 50029000, 52043000, 53046000};
Xstatic long room52[MAXTRAV] = {50044000, 51043000, 52046000, 53029000,
X		       55045000, 86030000};
Xstatic long room53[MAXTRAV] = {51044000, 52045000, 54046000};
Xstatic long room54[MAXTRAV] = {53044000, 53011000};
Xstatic long room55[MAXTRAV] = {52044000, 55045000, 56030000, 57043000};
Xstatic long room56[MAXTRAV] = {55029000, 55011000};
Xstatic long room57[MAXTRAV] = {13030000, 13056000, 55044000, 58046000,
X		       83045000, 84043000};
Xstatic long room58[MAXTRAV] = {57043000, 57011000};
Xstatic long room59[MAXTRAV] = {27001000};
Xstatic long room60[MAXTRAV] = {41043000, 41029000, 41017000, 61044000,
X		       62045000, 62030000, 62052000};
Xstatic long room61[MAXTRAV] = {60043000, 62045000, 107046100};
Xstatic long room62[MAXTRAV] = {60044000, 63045000, 30043000, 61046000};
Xstatic long room63[MAXTRAV] = {62046000, 62011000};
Xstatic long room64[MAXTRAV] = {39029000, 39056000, 39059000, 65044000,
X		       65070000, 103045000, 103074000, 106043000};
Xstatic long room65[MAXTRAV] = {64043000, 66044000, 556046080, 68061000,
X         556029080, 70029050, 39029000, 556045060, 72045075, 71045000,
X		       556030080, 106030000};
Xstatic long room66[MAXTRAV] = {65047000, 67044000, 556046080, 77025000,
X		       96043000, 556050050, 97072000};
Xstatic long room67[MAXTRAV] = {66043000, 23044000, 23042000, 24030000,
X		       24031000};
Xstatic long room68[MAXTRAV] = {23046000, 69029000, 69056000, 65045000};
Xstatic long room69[MAXTRAV] = {68030000, 68061000, 120046331, 119046000,
X		       109045000, 113075000};
Xstatic long room70[MAXTRAV] = {71045000, 65030000, 65023000, 111046000};
Xstatic long room71[MAXTRAV] = {65048000, 70046000, 110045000};
Xstatic long room72[MAXTRAV] = {65070000, 118049000, 73045000, 97048000,
X		       97072000};
Xstatic long room73[MAXTRAV] = {72046000, 72017000, 72011000};
Xstatic long room74[MAXTRAV] = {19043000, 120044331, 121044000, 75030000};
Xstatic long room75[MAXTRAV] = {76046000, 77045000};
Xstatic long room76[MAXTRAV] = {75045000};
Xstatic long room77[MAXTRAV] = {75043000, 78044000, 66045000, 66017000};
Xstatic long room78[MAXTRAV] = {77046000};
Xstatic long room79[MAXTRAV] = {3001000};
Xstatic long room80[MAXTRAV] = {42045000, 80044000, 80046000, 81043000};
Xstatic long room81[MAXTRAV] = {80044000, 80011000};
Xstatic long room82[MAXTRAV] = {44046000, 44011000};
Xstatic long room83[MAXTRAV] = {57046000, 84043000, 85044000};
Xstatic long room84[MAXTRAV] = {57045000, 83044000, 114050000};
Xstatic long room85[MAXTRAV] = {83043000, 83011000};
Xstatic long room86[MAXTRAV] = {52029000, 52011000};
Xstatic long room87[MAXTRAV] = {45029000, 45030000};
Xstatic long room88[MAXTRAV] = {25030000, 25056000, 25043000, 20039000,
X		       92044000, 92027000};
Xstatic long room89[MAXTRAV] = {25001000};
Xstatic long room90[MAXTRAV] = {23001000};
Xstatic long room91[MAXTRAV] = {95045000, 95073000, 95023000, 72030000,
X		       72056000};
Xstatic long room92[MAXTRAV] = {88046000, 93043000, 94045000};
Xstatic long room93[MAXTRAV] = {92046000, 92027000, 92011000};
Xstatic long room94[MAXTRAV] = {92046000, 92027000, 92023000, 95045309,
X		       95003309, 95073309, 611045000};
Xstatic long room95[MAXTRAV] = {94046000, 94011000, 92027000, 91044000};
Xstatic long room96[MAXTRAV] = {66044000, 66011000};
Xstatic long room97[MAXTRAV] = {66048000, 72044000, 72017000, 98029000,
X		       98045000, 98073000};
Xstatic long room98[MAXTRAV] = {97046000, 97072000, 99044000};
Xstatic long room99[MAXTRAV] = {98050000, 98073000, 301043000, 301023000,
X		       100043000};
Xstatic long room100[MAXTRAV] = {301044000, 301023000, 301011000, 99044000,
X			302071159, 33071000, 101047000, 101022000};
Xstatic long room101[MAXTRAV] = {100046000, 100071000, 100011000};
Xstatic long room102[MAXTRAV] = {103030000, 103074000, 103011000};
Xstatic long room103[MAXTRAV] = {102029000, 102038000, 104030000, 618046114,
X			619046115, 64046000};
Xstatic long room104[MAXTRAV] = {103029000, 103074000, 105030000};
Xstatic long room105[MAXTRAV] = {104029000, 104011000, 103074000};
Xstatic long room106[MAXTRAV] = {64029000, 65044000, 108043000};
Xstatic long room107[MAXTRAV] = {131046000, 132049000, 133047000, 134048000,
X     135029000, 136050000, 137043000, 138044000, 139045000, 61030000};
Xstatic long room108[MAXTRAV] = {556043095, 556045095, 556046095, 556047095,
X     556048095, 556049095, 556050095, 556029095, 556030095, 106043000,
X			626044000};
Xstatic long room109[MAXTRAV] = {69046000, 113045000, 113075000};
Xstatic long room110[MAXTRAV] = {71044000, 20039000};
Xstatic long room111[MAXTRAV] = {70045000, 50030040, 50039040, 50056040,
X			53030050, 45030000};
Xstatic long room112[MAXTRAV] = {131049000, 132045000, 133043000, 134050000,
X    135048000, 136047000, 137044000, 138030000, 139029000, 140046000};
Xstatic long room113[MAXTRAV] = {109046000, 109011000, 109109000};
Xstatic long room114[MAXTRAV] = {84048000};
Xstatic long room115[MAXTRAV] = {116049000};
Xstatic long room116[MAXTRAV] = {115047000, 593030000};
Xstatic long room117[MAXTRAV] = {118049000, 660041233, 660042233, 660069233,
X	      660047233, 661041332, 303041000, 21039332, 596039000};
Xstatic long room118[MAXTRAV] = {72030000, 117029000};
Xstatic long room119[MAXTRAV] = {69045000, 69011000, 653043000, 65307000};
Xstatic long room120[MAXTRAV] = {69045000, 74043000};
Xstatic long room121[MAXTRAV] = {74043000, 74011000, 653045000, 653007000};
Xstatic long room122[MAXTRAV] = {123047000, 660041233, 660042233, 660069233,
X    660049233, 303041000, 596039000, 124077000, 126028000, 129040000};
Xstatic long room123[MAXTRAV] = {122044000, 124043000, 124077000, 126028000,
X			129040000};
Xstatic long room124[MAXTRAV] = {123044000, 125047000, 125036000, 128048000,
X			128037000, 128030000, 126028000, 129040000};
Xstatic long room125[MAXTRAV] = {124046000, 124077000, 126045000, 126028000,
X			127043000, 127017000};
Xstatic long room126[MAXTRAV] = {125046000, 125023000, 125011000, 124077000,
X			610030000, 610039000};
Xstatic long room127[MAXTRAV] = {125044000, 125011000, 125017000, 124077000,
X			126028000};
Xstatic long room128[MAXTRAV] = {124045000, 124029000, 124077000, 129046000,
X			129030000, 129040000, 126028000};
Xstatic long room129[MAXTRAV] = {128044000, 128029000, 124077000, 130043000,
X			130019000, 130040000, 130003000, 126028000};
Xstatic long room130[MAXTRAV] = {129044000, 124077000, 126028000};
Xstatic long room131[MAXTRAV] = {107044000, 132048000, 133050000, 134049000,
X    135047000, 136029000, 137030000, 138045000, 139046000, 112043000};
Xstatic long room132[MAXTRAV] = {107050000, 131029000, 133045000, 134046000,
X    135044000, 136049000, 137047000, 138043000, 139030000, 112048000};
Xstatic long room133[MAXTRAV] = {107029000, 131030000, 132044000, 134047000,
X    135049000, 136043000, 137045000, 138050000, 139048000, 112046000};
Xstatic long room134[MAXTRAV] = {107047000, 131045000, 132050000, 133048000,
X    135043000, 136030000, 137046000, 138029000, 139044000, 112049000};
Xstatic long room135[MAXTRAV] = {107045000, 131048000, 132030000, 133046000,
X    134043000, 136044000, 137049000, 138047000, 139050000, 112029000};
Xstatic long room136[MAXTRAV] = {107043000, 131044000, 132029000, 133049000,
X    134030000, 135046000, 137050000, 138048000, 139047000, 112045000};
Xstatic long room137[MAXTRAV] = {107048000, 131047000, 132046000, 133030000,
X    134029000, 135050000, 136045000, 138049000, 139043000, 112044000};
Xstatic long room138[MAXTRAV] = {107030000, 131043000, 132047000, 133029000,
X    134044000, 135045000, 136046000, 137048000, 139049000, 112050000};
Xstatic long room139[MAXTRAV] = {107049000, 131050000, 132043000, 133044000,
X    134045000, 135030000, 136048000, 137029000, 138046000, 112047000};
Xstatic long room140[MAXTRAV] = {112045000, 112011000};
X
Xstatic long *cave[MAXLOC] = {
X      room1, room2, room3, room4, room5, room6, room7, room8, room9, room10,
X     room11, room12, room13, room14, room15, room16, room17, room18, room19,
X     room20, room21, room22, room23, room24, room25, room26, room27, room28,
X     room29, room30, room31, room32, room33, room34, room35, room36, room37,
X     room38, room39, room40, room41, room42, room43, room44, room45, room46,
X     room47, room48, room49, room50, room51, room52, room53, room54, room55,
X     room56, room57, room58, room59, room60, room61, room62, room63, room64,
X     room65, room66, room67, room68, room69, room70, room71, room72, room73,
X     room74, room75, room76, room77, room78, room79, room80, room81, room82,
X     room83, room84, room85, room86, room87, room88, room89, room90, room91,
X    room92, room93, room94, room95, room96, room97, room98, room99, room100,
X     room101, room102, room103, room104, room105, room106, room107, room108,
X     room109, room110, room111, room112, room113, room114, room115, room116,
X     room117, room118, room119, room120, room121, room122, room123, room124,
X     room125, room126, room127, room128, room129, room130, room131, room132,
X    room133, room134, room135, room136, room137, room138, room139, room140};
/
echo x - advdec.h
sed '/^X/s///' > advdec.h << '/'
X
X/*	header ADVDEC.H						*\
X\*	WARNING: GLOBAL EXTERNAL declarations for adventure	*/
X
X
X/*
X  Database variables
X*/
Xextern struct wac wc[];		/* see ADVWORD.H		 */
Xextern long idx1[];		/* see ADVTEXT.H		 */
Xextern long idx2[];		/* see ADVTEXT.H		 */
Xextern long idx3[];		/* see ADVTEXT.H		 */
Xextern long idx4[];		/* see ADVTEXT.H		 */
X
X
X
Xextern struct trav travel[];
Xextern FILE *fd1, *fd2, *fd3, *fd4;
Xextern int actmsg[];		/* action messages	 */
X
X/*
X  English variables
X*/
Xextern int verb, object, motion;
Xextern char word1[], word2[];
X
X/*
X  Play variables
X*/
Xextern struct {
X  int turns;
X  int loc, oldloc, oldloc2, newloc;	/* location variables */
X  int cond[MAXLOC];		/* location status	 */
X  int place[MAXOBJ];		/* object location	 */
X  int fixed[MAXOBJ];		/* second object loc	 */
X  int visited[MAXLOC];		/* >0 if has been here	 */
X  int prop[MAXOBJ];		/* status of object	 */
X  int tally, tally2;		/* item counts		 */
X  int limit;			/* time limit		 */
X  int lmwarn;			/* lamp warning flag	 */
X  int wzdark, closing, closed;	/* game state flags	 */
X  int holding;			/* count of held items	 */
X  int detail;			/* LOOK count		 */
X  int knfloc;			/* knife location	 */
X  int clock, clock2, panic;	/* timing variables	 */
X  int dloc[DWARFMAX];		/* dwarf locations	 */
X  int dflag;			/* dwarf flag		 */
X  int dseen[DWARFMAX];		/* dwarf seen flag	 */
X  int odloc[DWARFMAX];		/* dwarf old locations	 */
X  int daltloc;			/* alternate appearance	 */
X  int dkill;			/* dwarves killed	 */
X  int chloc, chloc2;		/* chest locations	 */
X  int bonus;			/* to pass to end	 */
X  int numdie;			/* number of deaths	 */
X  int object1;			/* to help intrans.	 */
X  int gaveup;			/* 1 if he quit early	 */
X  int foobar;			/* fee fie foe foo...	 */
X  int saveflg;			/* if game being saved	 */
X  int dbugflg;			/* if game is in debug	 */
X
X
X  int lastglob;			/* to get space req.	 */
X} g;
/
echo x - advdef.h
sed '/^X/s///' > advdef.h << '/'
X
X/*	header ADVDEF.H						*\
X\*	WARNING: GLOBAL variable allocations for adventure	*/
X
X
X/*
X  Database variables
X*/
Xstruct trav travel[MAXTRAV+1];
XFILE *fd1, *fd2, *fd3, *fd4;
Xint actmsg[32];			/* action messages	 */
X
X/*
X  English variables
X*/
Xint verb, object, motion;
Xchar word1[WORDSIZE], word2[WORDSIZE];
X
X/*
X  Play variables
X*/
Xstruct {
X  int turns;
X  int loc, oldloc, oldloc2, newloc;	/* location variables */
X  int cond[MAXLOC];		/* location status	 */
X  int place[MAXOBJ];		/* object location	 */
X  int fixed[MAXOBJ];		/* second object loc	 */
X  int visited[MAXLOC];		/* >0 if has been here	 */
X  int prop[MAXOBJ];		/* status of object	 */
X  int tally, tally2;		/* item counts		 */
X  int limit;			/* time limit		 */
X  int lmwarn;			/* lamp warning flag	 */
X  int wzdark, closing, closed;	/* game state flags	 */
X  int holding;			/* count of held items	 */
X  int detail;			/* LOOK count		 */
X  int knfloc;			/* knife location	 */
X  int clock, clock2, panic;	/* timing variables	 */
X  int dloc[DWARFMAX];		/* dwarf locations	 */
X  int dflag;			/* dwarf flag		 */
X  int dseen[DWARFMAX];		/* dwarf seen flag	 */
X  int odloc[DWARFMAX];		/* dwarf old locations	 */
X  int daltloc;			/* alternate appearance	 */
X  int dkill;			/* dwarves killed	 */
X  int chloc, chloc2;		/* chest locations	 */
X  int bonus;			/* to pass to end	 */
X  int numdie;			/* number of deaths	 */
X  int object1;			/* to help intrans.	 */
X  int gaveup;			/* 1 if he quit early	 */
X  int foobar;			/* fee fie foe foo...	 */
X  int saveflg;			/* if game being saved	 */
X  int dbugflg;			/* if game is in debug	 */
X
X
X  int lastglob;			/* to get space req.	 */
X} g;
/
echo x - advent.c
sed '/^X/s///' > advent.c << '/'
X/**	Adventure ported to Minix by:
X  Robert R. Hall (hall@nosc.mil)
X  Naval Ocean Center
X  San Diego,  Calif
X */
X
X/**	program ADVENT.C					*
X *	WARNING: "advent.c" allocates GLOBAL storage space by	*
X *		including "advdef.h".				*
X *		All other modules use "advdec.h"		*/
X
X
X#include	<sys/types.h>
X#include        <string.h>
X#include	<ctype.h>
X#include	<unistd.h>	/* drv = 1.1st file 2.def 3.A	 */
X#include	<stdio.h>	/* drv = 1.1st file 2.def 3.A	 */
X#include	"advent.h"	/* #define preprocessor equates	 */
X#include	"advword.h"	/* definition of "word" array	 */
X#include	"advtext.h"	/* definition of "text" arrays	 */
X#include	"advdef.h"
X
X_PROTOTYPE (void exit, (int status));
X
Xchar *textdir = "/usr/src/data";/* directory where text files live. */
X
Xint main(argc, argv)
Xint argc;
Xchar **argv;
X{
X  int n, rflag;			/* user restore request option	 */
X
X  n = chdir(textdir);		/* all the goodies are kept there. */
X  if (n < 0) {
X	printf("Unable to chdir(%s) where text files must be kept\n", textdir);
X	exit(1);
X  }
X  rflag = 0;
X  g.dbugflg = 0;
X  while (--argc > 0) {
X	++argv;
X	if (**argv != '-') break;
X	switch (tolower(argv[0][1])) {
X	    case 'r':
X		++rflag;
X		continue;
X	    case 'd':
X		++g.dbugflg;
X		continue;
X	    default:
X		printf("unknown flag: %c\n", argv[0][1]);
X		continue;
X	}			/* switch	 */
X  }				/* while	 */
X  if (g.dbugflg < 2) g.dbugflg = 0;	/* must request three times	 */
X  opentxt();
X  initplay();
X  if (rflag)
X	restore();
X  else if (yes(65, 1, 0))
X	g.limit = 1000;
X  else
X	g.limit = 330;
X  g.saveflg = 0;
X  srand(511);			/* seed random	 */
X  while (!g.saveflg) turn();
X  if (g.saveflg) saveadv();
X  fclose(fd1);
X  fclose(fd2);
X  fclose(fd3);
X  fclose(fd4);
X  exit(0);			/* exit = ok	 */
X}				/* main		 */
X
X/* ************************************************************	*/
X
X/*
X  Initialize integer arrays with sscanf
X*/
Xvoid scanint(pi, str)
Xint *pi;
Xchar *str;
X{
X
X  while (*str) {
X	if ((sscanf(str, "%d,", pi++)) < 1)
X		bug(41);	/* failed before EOS		 */
X	while (*str++ != ',')	/* advance str pointer	 */
X		;
X  }
X  return;
X}
X
X/*
X  Initialization of adventure play variables
X*/
Xvoid initplay()
X{
X  g.turns = 0;
X
X  /* Initialize location status array */
X  memset(g.cond, 0, (sizeof(int)) * MAXLOC);
X  scanint(&g.cond[1], "5,1,5,5,1,1,5,17,1,1,");
X  scanint(&g.cond[13], "32,0,0,2,0,0,64,2,");
X  scanint(&g.cond[21], "2,2,0,6,0,2,");
X  scanint(&g.cond[31], "2,2,0,0,0,0,0,4,0,2,");
X  scanint(&g.cond[42], "128,128,128,128,136,136,136,128,128,");
X  scanint(&g.cond[51], "128,128,136,128,136,0,8,0,2,");
X  scanint(&g.cond[79], "2,128,128,136,0,0,8,136,128,0,2,2,");
X  scanint(&g.cond[95], "4,0,0,0,0,1,");
X  scanint(&g.cond[113], "4,0,1,1,");
X  scanint(&g.cond[122], "8,8,8,8,8,8,8,8,8,");
X
X  /* Initialize object locations */
X  memset(g.place, 0, (sizeof(int)) * MAXOBJ);
X  scanint(&g.place[1], "3,3,8,10,11,115,14,13,94,96,");
X  scanint(&g.place[11], "19,17,101,103,0,106,0,0,3,3,");
X  scanint(&g.place[23], "109,25,23,111,35,0,97,");
X  scanint(&g.place[31], "119,117,117,0,130,0,126,140,0,96,");
X  scanint(&g.place[50], "18,27,28,29,30,");
X  scanint(&g.place[56], "92,95,97,100,101,0,119,127,130,");
X
X  /* Initialize second (fixed) locations */
X  memset(g.fixed, 0, (sizeof(int)) * MAXOBJ);
X  scanint(&g.fixed[3], "9,0,0,0,15,0,-1,");
X  scanint(&g.fixed[11], "-1,27,-1,0,0,0,-1,");
X  scanint(&g.fixed[23], "-1,-1,67,-1,110,0,-1,-1,");
X  scanint(&g.fixed[31], "121,122,122,0,-1,-1,-1,-1,0,-1,");
X  scanint(&g.fixed[62], "121,");
X
X  /* Initialize default verb messages */
X  scanint(actmsg, "0,24,29,0,33,0,33,38,38,42,14,");
X  scanint(&actmsg[11], "43,110,29,110,73,75,29,13,59,59,");
X  scanint(&actmsg[21], "174,109,67,13,147,155,195,146,110,13,13,");
X
X  /* Initialize various flags and other variables */
X  memset(g.visited, 0, (sizeof(int)) * MAXLOC);
X  memset(g.prop, 0, (sizeof(int)) * MAXOBJ);
X  memset(&g.prop[50], 0xff, (sizeof(int)) * (MAXOBJ - 50));
X  g.wzdark = g.closed = g.closing = g.holding = g.detail = 0;
X  g.limit = 100;
X  g.tally = 15;
X  g.tally2 = 0;
X  g.newloc = 1;
X  g.loc = g.oldloc = g.oldloc2 = 3;
X  g.knfloc = 0;
X  g.chloc = 114;
X  g.chloc2 = 140;
X/*	g.dloc[DWARFMAX-1] = chloc				*/
X  scanint(g.dloc, "0,19,27,33,44,64,114,");
X  scanint(g.odloc, "0,0,0,0,0,0,0,");
X  g.dkill = 0;
X  scanint(g.dseen, "0,0,0,0,0,0,0,");
X  g.clock = 30;
X  g.clock2 = 50;
X  g.panic = 0;
X  g.bonus = 0;
X  g.numdie = 0;
X  g.daltloc = 18;
X  g.lmwarn = 0;
X  g.foobar = 0;
X  g.dflag = 0;
X  g.gaveup = 0;
X  g.saveflg = 0;
X  return;
X}
X
X/*
X  Open advent?.txt files
X*/
Xvoid opentxt()
X{
X  fd1 = fopen("advent1.txt", "r");
X  if (!fd1) {
X	printf("Sorry, I can't open advent1.txt...\n");
X	exit(1);
X  }
X  fd2 = fopen("advent2.txt", "r");
X  if (!fd2) {
X	printf("Sorry, I can't open advent2.txt...\n");
X	exit(1);
X  }
X  fd3 = fopen("advent3.txt", "r");
X  if (!fd3) {
X	printf("Sorry, I can't open advent3.txt...\n");
X	exit(1);
X  }
X  fd4 = fopen("advent4.txt", "r");
X  if (!fd4) {
X	printf("Sorry, I can't open advent4.txt...\n");
X	exit(1);
X  }
X}
X
X/*
X	save adventure game
X*/
Xvoid saveadv()
X{
X  char *sptr;
X  FILE *savefd;
X  char username[13];
X
X  printf("What do you want to name the saved game? \n");
X  scanf("%s", username);
X  if (sptr = strchr(username, '.'))
X	*sptr = '\0';		/* kill extension	 */
X  if (strlen(username) > 8)
X	username[8] = '\0';	/* max 8 char filename	 */
X  strcat(username, ".adv");
X  savefd = fopen(username, "wb");
X  if (savefd == NULL) {
X	printf("Sorry, I can't create the file...%s\n",
X	       username);
X	exit(1);
X  }
X  for (sptr = (char *) &g.turns; sptr < (char *) &g.lastglob; sptr++) {
X	if (fputc(*sptr, savefd) == EOF) {
X		printf("Write error on save file...%s\n",
X		       username);
X		exit(1);
X	}
X  }
X  if (fclose(savefd) == -1) {
X	printf("Sorry, I can't close the file...%s\n",
X	       username);
X	exit(1);
X  }
X  printf("OK -- \"C\" you later...\n");
X}
X
X/*
X  restore saved game handler
X*/
Xvoid restore()
X{
X  char username[13];
X  int c;
X  FILE *restfd;
X  char *sptr;
X
X  printf("What is the name of the saved game? \n");
X  scanf("%s", username);
X  if (sptr = strchr(username, '.'))
X	*sptr = '\0';		/* kill extension	 */
X  if (strlen(username) > 8)
X	username[8] = '\0';	/* max 8 char filename	 */
X  strcat(username, ".adv");
X  restfd = fopen(username, "rb");
X  if (restfd == NULL) {
X	printf("Sorry, I can't open the file...%s\n",
X	       username);
X	exit(1);
X  }
X  for (sptr = (char *) &g.turns; sptr < (char *) &g.lastglob; sptr++) {
X	if ((c = fgetc(restfd)) == -1) {
X		printf("Read error on save file...%s\n",
X		       username);
X		exit(1);
X	}
X	*sptr = c;
X  }
X  if (fclose(restfd) == -1) {
X	printf("Warning -- can't close save file...%s\n",
X	       username);
X  }
X}
/
echo x - advent.doc
sed '/^X/s///' > advent.doc << '/'
X
X
X							12 JUNE 1984
X
X		Notes on ADVENTURE  (for IBM PC)
X
X
X    1)  TO PLAY ADVENTURE
X	The ADVENTURE game requires one single sided drive & 96K of
X	memory. The following files  MUST  reside in the save directory:
X
X	ADVENT, ADVENT1.TXT, ADVENT2.TXT, ADVENT3.TXT, ADVENT4.TXT
X
X
X	The game may be started by typing       "ADVENT<cr>".
X	A saved game may be restarted by typing "ADVENT -r<cr>".
X	Debug data will be output by typing     "ADVENT -d -d -d<cr>".
X
X
X    2)  TO HACK ADVENTURE
X	The ADVENTURE game source files are either, header, code or
X	text files.
X
X	ADVENT	.C	- initialization, save game, restore game
X	ENGLISH	.C	- interpret game player's commands
X	DATABASE.C	- text file management & output
X	ITVERB	.C	- intransitive verbs execution
X	VERB	.C	-   transitive verbs execution
X	TURN	.C	- analysis & execution of player's command
X
X	ADVENT0	.C	- utility to create "ADVTEXT.H" file
X	ADVENT1	.TXT	- long  cave description
X	ADVENT2	.TXT	- short cave description
X	ADVENT3	.TXT	- long & short object description
X	ADVENT4	.TXT	- conversational descriptions & responses
X	ADVENT	.DOC	- this ADVENTURE documentation file
X
X	ADVENT	.H	- #define & structure statements
X	ADVWORD	.H	- words & codes array
X	ADVCAVE	.H	- cave & travel arrays
X	ADVTEXT	.H	- TXT file message indexes
X	ADVDEF	.H	- data constants & variables definitions
X	ADVDEC	.H	- data constants & variables declarations
X
X	WARNING:
X	The TXT files are the ASCII text messages used throughout the
X	game.  They may be modified ONLY if you have the utility
X	program, "ADVENT0" or the source "ADVENT0.C".  This program
X	creates the header file "ADVTEXT.H" which is "#include"ed into
X	"ADVENT.C" during compilation.  After ANY changes to the "TXT"
X	files, recreate a new "ADVTEXT.H" file.  Make sure that the
X	four "TXT" files and the utility "ADVENT0" are in the same
X	directory, then type "ADVENT0<cr>".
X
X
X	The game was translated from BDS C to CII C86 and standardized
X	as per UNIX standard i/o library functions.  The following
X	changes were instituted:
X
X	0) UNIX standard i/o
X	1) "include"d header files & "extern"al statements added
X	2) cave/travel  data arrays are now internal
X	3) word/code    data arrays are now internal
X	4) TXT message index arrays are now internal
X	5) TXT file format doesn't require # terminator character
X	6) save & restore game overlays intergrated with "ADVENT.C"
X	7) word/code syntax parsing optimized in "ENGLISH.C"
X	   BINARY LEX-ORDERED WORD LOOK-UP added in "DATABASE.C"
X	8) TXT message indexing & output optimized in "DATABASE.C"
X	9) TXT message typos corrected
X	A) created "ADVENT0.C" utility (cf. #1, #4 & #5)
X	B) created "ADVENT.DOC" documentation file
X
X
X	The modifications described above were implemented by:
X	Jerry D. Pohl
X	1922 Junction Avenue
X	San Jose, CA 95131
X	(408) 298-1262 / (408) 298-3185		(both 8..6, m..f)
X	
X	Ported to Minix and debugged May 1990 by:
X	Robert R. Hall (hall@nosc.mil)
X	Naval Ocean System Center
X	San Diego, Calif
X
/
echo x - advent.h
sed '/^X/s///' > advent.h << '/'
X/*	header ADVENT.H						*\
X\*	WARNING: HEADER file for all adventure modules		*/
X
X
X#define	MAXOBJ	100		/* max # of objects in cave	 */
X#define	MAXWC	301		/* max # of adventure words	 */
X#define	MAXLOC	140		/* max # of cave locations	 */
X#define	WORDSIZE	20	/* max # of chars in commands	 */
X#define	MAXMSG	201		/* max # of long location descr	 */
X
X#define	MAXTRAV	(16+1)		/* max # of travel directions from loc	 */
X /* +1 for terminator travel[x].tdest=-1	 */
X#define	DWARFMAX	7	/* max # of nasty dwarves	 */
X#define	MAXDIE	3		/* max # of deaths before close	 */
X#define	MAXTRS	79		/* max # of			 */
X
X/*
X  Object definitions
X*/
X#define	KEYS	1
X#define	LAMP	2
X#define	GRATE	3
X#define	CAGE	4
X#define	ROD	5
X#define	ROD2	6
X#define	STEPS	7
X#define	BIRD	8
X#define	DOOR	9
X#define	PILLOW	10
X#define	SNAKE	11
X#define	FISSURE	12
X#define	TABLET	13
X#define	CLAM	14
X#define	OYSTER	15
X#define	MAGAZINE	16
X#define	DWARF	17
X#define	KNIFE	18
X#define	FOOD	19
X#define	BOTTLE	20
X#define	WATER	21
X#define	OIL	22
X#define	MIRROR	23
X#define	PLANT	24
X#define	PLANT2	25
X#define	AXE	28
X#define	DRAGON	31
X#define	CHASM	32
X#define	TROLL	33
X#define	TROLL2	34
X#define	BEAR	35
X#define	MESSAGE	36
X#define	VEND	38
X#define	BATTERIES	39
X#define	NUGGET	50
X#define	COINS	54
X#define	CHEST	55
X#define	EGGS	56
X#define	TRIDENT	57
X#define	VASE	58
X#define	EMERALD	59
X#define	PYRAMID	60
X#define	PEARL	61
X#define	RUG	62
X#define	SPICES	63
X#define	CHAIN	64
X
X/*
X  Verb definitions
X*/
X#define	NULLX	21
X#define	BACK	8
X#define	LOOK	57
X#define	CAVE	67
X#define	ENTRANCE	64
X#define	DEPRESSION	63
X
X/*
X  Action verb definitions
X*/
X#define	TAKE	1
X#define	DROP	2
X#define	SAY	3
X#define	OPEN	4
X#define	NOTHING	5
X#define	LOCK	6
X#define	ON	7
X#define	OFF	8
X#define	WAVE	9
X#define	CALM	10
X#define	WALK	11
X#define	KILL	12
X#define	POUR	13
X#define	EAT	14
X#define	DRINK	15
X#define	RUB	16
X#define	THROW	17
X#define	QUIT	18
X#define	FIND	19
X#define	INVENTORY	20
X#define	FEED	21
X#define	FILL	22
X#define	BLAST	23
X#define	SCORE	24
X#define	FOO	25
X#define	BRIEF	26
X#define	READ	27
X#define	BREAK	28
X#define	WAKE	29
X#define	SUSPEND	30
X#define	HOURS	31
X#define	LOG	32
X
X/*
X  BIT mapping of "cond" array which indicates location status
X*/
X#define	LIGHT	1
X#define	WATOIL	2
X#define	LIQUID	4
X#define	NOPIRAT	8
X#define	HINTC	16
X#define	HINTB	32
X#define	HINTS	64
X#define	HINTM	128
X#define	HINT	240
X
X/*
X  Structure definitions
X*/
Xstruct wac {
X  char *aword;
X  int acode;
X};
X
Xstruct trav {
X  int tdest;
X  int tverb;
X  int tcond;
X};
X
X/* function prototypes */
X
X/* advent.c */
X
X_PROTOTYPE(int main, (int argc, char **argv ));
X_PROTOTYPE(void scanint, (int *pi, char *str ));
X_PROTOTYPE(void initplay, (void));
X_PROTOTYPE(void opentxt, (void));
X_PROTOTYPE(void saveadv, (void));
X_PROTOTYPE(void restore, (void));
X
X/* advent0.c */
X
X_PROTOTYPE(int main, (int argc, char **argv ));
X
X/* database.c */
X
X_PROTOTYPE(void gettrav, (int loc ));
X_PROTOTYPE(int rdupto, (FILE *fdi, int uptoc, int print, char *string ));
X_PROTOTYPE(void rdskip, (FILE *fdi, int skipc, int n, int rewind_ ));
X_PROTOTYPE(int yes, (int msg1, int msg2, int msg3 ));
X_PROTOTYPE(void rspeak, (int msg ));
X_PROTOTYPE(void pspeak, (int item, int state ));
X_PROTOTYPE(void desclg, (int loc ));
X_PROTOTYPE(void descsh, (int loc ));
X_PROTOTYPE(int vocab, (char *word, int val ));
X_PROTOTYPE(int binary, (char *w, struct wac wctable [], int maxwc ));
X_PROTOTYPE(int dark, (void));
X_PROTOTYPE(int here, (int item ));
X_PROTOTYPE(int toting, (int item ));
X_PROTOTYPE(int forced, (int atloc ));
X_PROTOTYPE(int pct, (int x ));
X_PROTOTYPE(int at, (int item ));
X_PROTOTYPE(void dstroy, (int obj ));
X_PROTOTYPE(void move, (int obj, int where ));
X_PROTOTYPE(void juggle, (int loc ));
X_PROTOTYPE(void carry, (int obj, int where ));
X_PROTOTYPE(void drop, (int obj, int where ));
X_PROTOTYPE(int put, (int obj, int where, int pval ));
X_PROTOTYPE(int dcheck, (void));
X_PROTOTYPE(int liq, (void));
X_PROTOTYPE(int liqloc, (int loc ));
X_PROTOTYPE(int liq2, (int pbottle ));
X_PROTOTYPE(void bug, (int n ));
X
X/* english.c */
X
X_PROTOTYPE(int english, (void));
X_PROTOTYPE(int analyze, (char *word, int *type, int *value ));
X_PROTOTYPE(void getwords, (void));
X_PROTOTYPE(void outwords, (void));
X
X/* itverb.c */
X
X_PROTOTYPE(void itverb, (void));
X_PROTOTYPE(void ivtake, (void));
X_PROTOTYPE(void ivopen, (void));
X_PROTOTYPE(void ivkill, (void));
X_PROTOTYPE(void ivdrink, (void));
X_PROTOTYPE(void ivquit, (void));
X_PROTOTYPE(void ivfoo, (void));
X_PROTOTYPE(void inventory, (void));
X_PROTOTYPE(void addobj, (int obj ));
X
X/* turn.c */
X
X_PROTOTYPE(void turn, (void));
X_PROTOTYPE(void describe, (void));
X_PROTOTYPE(void descitem, (void));
X_PROTOTYPE(void domove, (void));
X_PROTOTYPE(void goback, (void));
X_PROTOTYPE(void copytrv, (struct trav *trav1, struct trav *trav2 ));
X_PROTOTYPE(void dotrav, (void));
X_PROTOTYPE(void badmove, (void));
X_PROTOTYPE(void spcmove, (int rdest ));
X_PROTOTYPE(void dwarfend, (void));
X_PROTOTYPE(void normend, (void));
X_PROTOTYPE(void score, (void));
X_PROTOTYPE(void death, (void));
X_PROTOTYPE(char *probj, (int object ));
X_PROTOTYPE(void doobj, (void));
X_PROTOTYPE(void trobj, (void));
X_PROTOTYPE(void dwarves, (void));
X_PROTOTYPE(void dopirate, (void));
X_PROTOTYPE(int stimer, (void));
X_PROTOTYPE(void srand, (int n ));
X_PROTOTYPE(int rand, (void));
X
X/* verb.c */
X
X_PROTOTYPE(void trverb, (void));
X_PROTOTYPE(void vtake, (void));
X_PROTOTYPE(void vdrop, (void));
X_PROTOTYPE(void vopen, (void));
X_PROTOTYPE(void vsay, (void));
X_PROTOTYPE(void von, (void));
X_PROTOTYPE(void voff, (void));
X_PROTOTYPE(void vwave, (void));
X_PROTOTYPE(void vkill, (void));
X_PROTOTYPE(void vpour, (void));
X_PROTOTYPE(void veat, (void));
X_PROTOTYPE(void vdrink, (void));
X_PROTOTYPE(void vthrow, (void));
X_PROTOTYPE(void vfind, (void));
X_PROTOTYPE(void vfill, (void));
X_PROTOTYPE(void vfeed, (void));
X_PROTOTYPE(void vread, (void));
X_PROTOTYPE(void vblast, (void));
X_PROTOTYPE(void vbreak, (void));
X_PROTOTYPE(void vwake, (void));
X_PROTOTYPE(void actspk, (int verb ));
X_PROTOTYPE(void needobj, (void));
/
echo x - advent0.c
sed '/^X/s///' > advent0.c << '/'
X
X/**	program ADVENT0.C					*
X *	execution will read the four adventure text files	*
X *	files; "advent1.txt", "advent2.txt", "advent3.txt" &	*
X *	"advent4.txt".  it will create the file "advtext.h"	*
X *	which is an Index Sequential Access Method (ISAM)	*
X *	header to be #included into "advent.c" before the	*
X *	header "advdef.h" is #included.				*/
X
X
X#include	<stdio.h>
X#include	"advent.h"
X
Xmain(argc, argv)
Xint argc;
Xchar **argv;
X{
X
X  FILE *isam, *fd1, *fd2, *fd3, *fd4;
X  char itxt[255];
X  int cnt;
X  long llen;
X
X  isam = fopen("advtext.h", "w");
X  if (!isam) {
X	printf("Sorry, I can't open advtext.h...\n");
X	exit();
X  }
X  fd1 = fopen("advent1.txt", "r");
X  if (!fd1) {
X	printf("Sorry, I can't open advent1.txt...\n");
X	exit();
X  }
X  fd2 = fopen("advent2.txt", "r");
X  if (!fd2) {
X	printf("Sorry, I can't open advent2.txt...\n");
X	exit();
X  }
X  fd3 = fopen("advent3.txt", "r");
X  if (!fd3) {
X	printf("Sorry, I can't open advent3.txt...\n");
X	exit();
X  }
X  fd4 = fopen("advent4.txt", "r");
X  if (!fd4) {
X	printf("Sorry, I can't open advent4.txt...\n");
X	exit();
X  }
X  fprintf(isam, "\n/");
X  fprintf(isam, "*\theader: ADVTEXT.H\t\t\t\t\t*/\n\n\n");
X
X
X  cnt = -1;
X  llen = 0L;
X  fprintf(isam, "long\tidx1[MAXLOC] = {\n\t");
X  while (fgets(itxt, 255, fd1)) {
X	printf("%s", itxt);
X	if (itxt[0] == '#') {
X		if (llen) fprintf(isam, "%D,", llen);
X		llen = ftell(fd1);
X		if (!llen) {
X			printf("ftell err in advent1.txt\n");
X			exit();
X		}		/* if (!llen)	 */
X		if (++cnt == 5) {
X			fprintf(isam, "\n\t");
X			cnt = 0;
X		}		/* if (cnt)	 */
X	}			/* if (itxt[0])	 */
X  }				/* while fgets	 */
X  fprintf(isam, "%D\n\t};\n\n", llen);
X  fclose(fd1);
X
X  cnt = -1;
X  llen = 0L;
X  fprintf(isam, "long\tidx2[MAXLOC] = {\n\t");
X  while (fgets(itxt, 255, fd2)) {
X	printf("%s", itxt);
X	if (itxt[0] == '#') {
X		if (llen) fprintf(isam, "%D,", llen);
X		llen = ftell(fd2);
X		if (!llen) {
X			printf("ftell err in advent2.txt\n");
X			exit();
X		}		/* if (!llen)	 */
X		if (++cnt == 5) {
X			fprintf(isam, "\n\t");
X			cnt = 0;
X		}		/* if (cnt)	 */
X	}			/* if (itxt[0])	 */
X  }				/* while fgets	 */
X  fprintf(isam, "%D\n\t};\n\n", llen);
X  fclose(fd2);
X
X  cnt = -1;
X  llen = 0L;
X  fprintf(isam, "long\tidx3[MAXOBJ] = {\n\t");
X  while (fgets(itxt, 255, fd3)) {
X	printf("%s", itxt);
X	if (itxt[0] == '#') {
X		if (llen) fprintf(isam, "%D,", llen);
X		llen = ftell(fd3);
X		if (!llen) {
X			printf("ftell err in advent3.txt\n");
X			exit();
X		}		/* if (!llen)	 */
X		if (++cnt == 5) {
X			fprintf(isam, "\n\t");
X			cnt = 0;
X		}		/* if (cnt)	 */
X	}			/* if (itxt[0])	 */
X  }				/* while fgets	 */
X  fprintf(isam, "%D\n\t};\n\n", llen);
X  fclose(fd3);
X
X  cnt = -1;
X  llen = 0L;
X  fprintf(isam, "long\tidx4[MAXMSG] = {\n\t");
X  while (fgets(itxt, 255, fd4)) {
X	printf("%s", itxt);
X	if (itxt[0] == '#') {
X		if (llen) fprintf(isam, "%D,", llen);
X		llen = ftell(fd4);
X		if (!llen) {
X			printf("ftell err in advent4.txt\n");
X			exit();
X		}		/* if (!llen)	 */
X		if (++cnt == 5) {
X			fprintf(isam, "\n\t");
X			cnt = 0;
X		}		/* if (cnt)	 */
X	}			/* if (itxt[0])	 */
X  }				/* while fgets	 */
X  fprintf(isam, "%D\n\t};\n\n", llen);
X  fclose(fd4);
X
X  fclose(isam);
X}				/* main		 */
/
echo x - advent1.txt
sed '/^X/s///' > advent1.txt << '/'
X#1
XYou are standing at the end of a road before a small brick
Xbuilding.  Around you is a forest.  A small stream flows out
Xof the building and down a gully.
X#2
XYou have walked up a hill, still in the forest.  The road
Xslopes back down the other side of the hill.  There is a
Xbuilding in the distance.
X#3
XYou are inside a building, a well house for a large spring.
X#4
XYou are in a valley in the forest beside a stream tumbling
Xalong a rocky bed.
X#5
XYou are in open forest, with a deep valley to one side.
X#6
XYou are in open forest near both a valley and a road.
X#7
XAt your feet all the water of the stream splashes into a
X2-inch slit in the rock.  Downstream the streambed is bare rock.
X#8
XYou are in a 20-foot depression floored with bare dirt.  Set
Xinto the dirt is a strong steel grate mounted in concrete.
XA dry streambed leads into the depression.
X#9
XYou are in a small chamber beneath a 3x3 steel grate to the
Xsurface.  A low crawl over cobbles leads inward to the West.
X#10
XYou are crawling over cobbles in a low passage.  There is a
Xdim light at the east end of the passage.
X#11
XYou are in a debris room filled with stuff washed in from the
Xsurface.  A low wide passage with cobbles becomes plugged
Xwith mud and debris here, but an awkward canyon leads
Xupward and west.  A note on the wall says:
X       Magic Word "XYZZY"
X#12
XYou are in an awkward sloping east/west canyon.
X#13
XYou are in a splendid chamber thirty feet high.  The walls
Xare frozen rivers of orange stone.  An awkward canyon and a
Xgood passage exit from east and west sides of the chamber.
X#14
XAt your feet is a small pit breathing traces of white mist.
XAn east passage ends here except for a small crack leading
Xon.
X#15
XYou are at one end of a vast hall stretching forward out of
Xsight to the west.  There are openings to either side.
XNearby, a wide stone staircase leads downward.  The hall
Xis filled with wisps of white mist swaying to and fro
Xalmost as if alive.  A cold wind blows up the staircase.
XThere is a passage at the top of a dome behind you.
X#16
XThe crack is far too small for you to follow.
X#17
XYou are on the east bank of a fissure slicing clear across
Xthe hall.  The mist is quite thick here, and the fissure
Xis too wide to jump.
X#18
XThis is a low room with a crude note on the wall.  The
Xnote says:
X       You won't get it up the steps.
X#19
XYou are in the hall of the mountain king, with passages
Xoff in all directions.
X#20
XYou are at the bottom of the pit with a broken neck.
X#21
XYou didn't make it.
X#22
XThe dome is unclimbable.
X#23
XYou are at the west end of the twopit room.  There is a
Xlarge hole in the wall above the pit at this end of the
Xroom.
X#24
XYou are that the bottom of the eastern pit in the twopit
Xroom.  There is a small pool of oil in one corner of the
Xpit.
X#25
XYou are at the bottom of the western pit in the towpit room.
XThere is a large hole in the wall about 25 feet above you.
X#26
XYou clamber up the plant and scurry through the hole at the
Xtop.
X#27
XYou are on the west side of the fissure in the hall of mists.
X#28
XYou are in a low N/S passage at a hole in the floor.  The
Xhole goes down to an E/W passage.
X#29
XYou are in the south side chamber.
X#30
XYou are in the west side chamber of the hall of the
Xmountain king.  A passage continues west and up here.
X#31
X>$<
X#32
XYou can't get by the snake.
X#33
XYou are in a large room, with a passage to the south,
Xa passage to the west, and a wall of broken rock to the
Xeast.  There is a large "Y2" on a rock in the room's 
Xcenter.
X#34
XYou are in a jumble of rock, with cracks everywhere.
X#35
XYou're at a low window overlooking a huge pit, which
Xextends up out of sight.  A floor is indistinctly visible
Xover 50 feet below.  Traces of white mist cover the floor
Xof the pit, becoming thicker to the right.  Marks in the
Xdust around the window would seem to indicate that
Xsomeone has been here recently.  Directly across the pit
Xfrom you and 25 feet away there is a similar window
Xlooking into a lighted room.  A shadowy figure can
Xbe seen there peering back at you.
X#36
XYou are in a dirty broken passage.  To the east is a
Xcrawl.  To the west is a large passage.  Above you is
Xanother passage.
X#37
XYou are on the brink of a small clean climbable pit.  A
Xcrawl leads west.
X#38
XYou are in the bottom of a small pit with a little stream,
Xwhich enters and exits through tiny slits.
X#39
XYou are in a large room full of dusty rocks.  There is a
Xbig hole in the floor.  There are cracks everywhere, and
Xa passage leading east.
X#40
XYou have crawled through a very low wide passage parallel
Xto and north of the hall of mists.
X#41
XYou are at the west end of hall of mists.  A low wide crawl
Xcontinues west and another goes north.  To the south is a
Xlittle passage 6 feet off the floor.
X#42
XYou are in a maze of twisty little passages, all alike.
X#43
XYou are in a maze of twisty little passages, all alike.
X#44
XYou are in a maze of twisty little passages, all alike.
X#45
XYou are in a maze of twisty little passages, all alike.
X#46
XDead end
X#47
XDead end
X#48
XDead end
X#49
XYou are in a maze of twisty little passages, all alike.
X#50
XYou are in a maze of twisty little passages, all alike.
X#51
XYou are in a maze of twisty little passages, all alike.
X#52
XYou are in a maze of twisty little passages, all alike.
X#53
XYou are in a maze of twisty little passages, all alike.
X#54
XDead end
X#55
XYou are in a maze of twisty little passages, all alike.
X#56
XDead end
X#57
XYou are on the brink of a thirty foot pit with a massive
Xorange column down one wall.  You could climb down here but
Xyou could not get back up.  The maze continues at this level.
X#58
XDead end
X#59
XYou have crawled through a very low wide passage paralled
Xto and north of the hall of mists.
X#60
XYou are at the east end of a very long hall apparently
Xwithout side chambers.  To the east a low wide crawl
Xslants up.  To the north a round two foot hole slants
Xdown.
X#61
XYou are at the west end of a very long featureless hall.
XThe hall joins up with a narrow north/south passage.
X#62
XYou are at a crossover of a high N/S passage and a low
XE/W one.
X#63
XDead end
X#64
XYou are at a complex junction.  A low hands and knees passage
Xfrom the north joins a higher crawl from the east to make
Xa walking passage going west.  There is also a large room
Xabove.  The air is damp here.
X#65
XYou are in bedquilt, a long east/west passage with holes
Xeverywhere.  To explore at random select north, south, up
Xor down.
X#66
XYou are in a room whose walls resemble swiss cheese.  
XObvious passages go west, east, ne, and nw.  Part of the
Xroom is occupied by a large bedrock block.
X#67
XYou are at the east end of the twopit room.  The floor
Xhere is littered with thin rock slabs, which make it easy
Xto descend the pits.  There is a path here bypassing
Xthe pits to connect passages from east and west.
XThere are holes all over, but the only bit one is on
Xthe wall directly over the west pit where you can't
Xget at it.
X#68
XYou are in a large low circular chamber whose floor is
Xan immense slab fallen from the ceiling (slab room).
XEast and west there once were large passages, but they
Xare now filled with boulders.  Low small passages go
Xnorth and south, and the south one quickly bends west
Xaround the boulders.
X#69
XYou are in a secret N/S canyon above a large room.
X#70
XYou are in a secret N/S canyon above a sizable passage.
X#71
XYou are in a secret canyon at a junction of three canyons,
Xbearing north, south and se.  The north one is as tall as
Xthe other two combined.
X#72
XYou are in a large low room.  Crawls lead north, se, and sw.
X#73
XDead end crawl.
X#74
XYou are in a secret canyon which here runs E/W.  It crosses
Xover a very tight canyon 15 feet below.  If you go down you
Xmay not be able to get back up.
X#75
XYou are at a wide place in a very tight N/S canyon.
X#76
XThe canyon here becomes too tight to go further south.
X#77
XYou are in a tall E/W canyon.  A low tight crawl goes 3
Xfeet north and seems to open up.
X#78
XThe canyon runs into a mass of boulders -- dead end.
X#79
XThe stream flows out through a pair of 1 foot diameter
Xsewer pipes.  It would be advisable to use the exit.
X#80
XYou are in a maze of twisty little passages, all alike.
X#81
XDead end.
X#82
XDead end.
X#83
XYou are in a maze of twisty little passages, all alike.
X#84
XYou are in a maze of twisty little passages, all alike.
X#85
XDead end.
X#86
XDead end.
X#87
XYou are in a maze of twisty little passages, all alike.
X#88
XYou are in a long, narrow corridor stretching out of sight
Xto the west.  At the eastern end is a hole through which
Xyou can see a profusion of leaves,
X#89
XThere is nothing here to climb.  Use "up" or "out" to leave
Xthe pit.
X#90
XYou have climbed up the plant and out of the pit.
X#91
XYou are at the top of a steep incline above a large room.
XYou could climb down here, but you would not be able to
Xclimb up.  There is a passage leading back to the north.
X#92
XYou are in the giant room.  The ceiling is too high up
Xfor your lamp to show it.  Cavernous passages lead east,
Xnorth, and south.  On the west wall is scrawled the
Xinscription:
X              "Fee Fie Foe Foo"       {sic}
X#93
XThe passage here is blocked by a recent cave-in.
X#94
XYou are at one end of an immense north/south passage.
X#95
XYou are in a magnificent cavern with a rushing stream,
Xwhich cascades over a sparkling waterfall into a
Xroaring whirlpool which disappears through a hole in
Xthe floor.  Passages exit to the south and west.
X#96
XYou are in the soft room.  The walls are covered with
Xheavy curtains, the floor with a thick pile carpet.
XMoss covers the ceiling.
X#97
XThis is the oriental room.  Ancient oriental cave drawings
Xcover the walls.  A gently sloping passage leads upward
Xto the north, another passage leads se, and a hands and
Xknees crawl leads west.
X#98
XYou are following a wide path around the outer edge of a
Xlarge cavern.  Far below, through a heavy white mist,
Xstrange splashing noises can be heard.  The mist rises up
Xthrough a fissure in the ceiling.  The path exits to the
Xsouth and west.
X#99
XYou are in an alcove.  A small nw path seems to widen
Xafter a short distance.  An extremely tight tunnel leads
Xeast.  It looks like a very tight squeeze.  An eerie
Xlight can be seen at the other end.
X#100
XYou're in a small chamber lit by an eerie green light.  An
Xextremely narrow tunnel exits to the west.  A dark corridor
Xleads ne.
X#101
XYou're in the dark-room.  A corridor leading south is the
Xonly exit.
X#102
XYou are in an arched hall.  A coral passage once continued
Xup and east from here, but is now blocked by debris.  The
Xair smells of sea water.
X#103
XYou're in a large room carved out of sedimentary rock.
XThe floor and walls are littered with bits of shells
Ximbedded in the stone.  A shallow passage proceeds
Xdownward, and a somewhat steeper one leads up.  A low
Xhands and knees passage enters from the south.
X#104
XYou are in a long sloping corridor with ragged sharp walls.
X#105
XYou are in a cul-de-sac about eight feet across.
X#106
XYou are in an anteroom leading to a large passage to the
Xeast.  Small passages go west and up.  The remnants of
Xrecent digging are evident.  A sign in midair here says:
X       "Cave under construction beyond this point."
X              "Proceed at your own risk."
X             "Witt construction company"
X#107
XYou are in a maze of twisty little passages, all different.
X#108
XYou are at Witt's end.  Passages lead off in ALL directions.
X#109
XYou are in a north/south canyon about 25 feet across.  The
Xfloor is covered by white mist seeping in from the north.
XThe walls extend upward for well over 100 feet.  Suspended
Xfrom some unseen point far above you, an enormous two-
Xsided mirror is hanging paralled to and midway between
Xthe canyon walls.  (The mirror is obviously provided
Xfor the use of the dwarves, who as you know, are
Xextremely vain.)  A small window can be seen in either
Xwall, some fifty feet up.
X#110
XYou're at a low window overlooking a huge pit, which
Xextends up out of sight.  A floor is indistinctly visible
Xover 50 feet below.  Traces of white mist cover the floor
Xof the pit, becoming thicker to the left.  Marks in the
Xdust around the window would seem to indicate that
Xsomeone has been here recently.  Directly across the pit
Xfrom you and 25 feet away there is a similar window
Xlooking into a lighted room.  A shadowy figure can be seen
Xthere peering back at you.
X#111
XA large stalactite extends from the roof and almost reaches
Xthe floor below.  You could climb down it, and jump from
Xit to the floor, but having done so you would be unable to
Xreach it to climb back up.
X#112
XYou are in a little maze of twisting passages, all different.
X#113
XYou are at the edge of a large underground reservoir.  An
Xopaque cloud of white mist fills the room and rises
Xrapidly upward.  The lake is fed by a stream which tumbles
Xout of a hole in the wall about 10 feet overhead and
Xsplashes noisily into the water somewhere within the mist.
XThe only passage goes back toward the south.
X#114
XDead end.
X#115
XYou are at the northeast end of an immense room, even
Xlarger than the giant room.  It appears to be a repository
Xfor the "adventure" program.  Massive torches far overhead
Xbathe the room with smoky yellow light.  Scattered about
Xyou can be seen a pile of bottles (all of them empty), a
Xnursery of young beanstalks murmuring quietly, a bed of
Xoysters, a bundle of black rods with rusty stars on their
Xends, and a collection of brass lanterns.  Off to one side
Xa great many Dwarves are sleeping on the floor, snoring
Xloudly.  A sign nearby reads:
X        "Do NOT disturb the Dwarves!"
XAn immense mirror is hanging against one wall, and
Xstretches to the other end of the room, where various
Xother sundry objects can be glimpsed dimly in the distance.
X#116
XYou are at the southwest end of the repository.  To one
Xside is a pit full of fierce green snakes.  On the other
Xside is a row of small wicker cages, each of which contains
Xa little sulking bird.  In one corner is a bundle of
Xblack rods with rusty marks on their ends.  A large
Xnumber of velvet pillows are scattered about on the floor.
XA vast mirror stretches off to the northeast.  At your
Xfeet is a large steel grate, next to which is a sign
Xwhich reads:
X     "Treasure vault.  Keys in main office."
X#117
XYou are on one side of a large deep chasm.  A heavy white
Xmist rising up from below obscures all view of the far
Xside.  A sw path leads away from the chasm into a winding
Xcorridor.
X#118
XYou are in a long winding corridor sloping out of sight
Xin both directions.
X#119
XYou are in a secret canyon which exits to the north and east.
X#120
XYou are in a secret canyon which exits to the north and east.
X#121
XYou are in a secret canyon which exits to the north and east.
X#122
XYou are on the far side of the chasm.  A ne path leads away
Xfrom the chasm on this side.
X#123
XYou're in a long east/west corridor.  A faint rumbling noise
Xcan be heard in the distance.
X#124
XThe path forks here.  The left fork leads northeast.  A dull
Xrumbling seems to get louder in that direction.  The right
Xfork leads southeast down a gentle slope.  The main
Xcorridor enters from the west.
X#125
XThe walls are quite warm here.  From the north can be heard
Xa steady roar, so loud that the entire cave seems to be
Xtrembling.  Another passage leads south, and a low crawl
Xgoes east.
X#126
XYou are on the edge of a breath-taking view.  Far below
Xyou is an active volcano, from which great gouts of molten
Xlava come surging out, cascading back down into the depths.
XThe glowing rock fills the farthest reaches of the cavern
Xwith a blood-red glare, giving everything an eerie,
Xmacabre appearance.  The air is filled with flickering
Xsparks of ash and a heavy smell of brimstone.  The walls
Xare hot to the touch, and the thundering of the volcano
Xdrowns out all other sounds.  Embedded in the jagged roof
Xfar overhead are myriad formations composed of pure
Xwhite alabaster, which scatter their murky light into
Xsinister apparitions upon the walls.  To one side is a
Xdeep gorge, filled with a bizarre chaos of tortured
Xrock which seems to have been crafted by the Devil
XHimself.  An immense river of fire crashes out from
Xthe depths of the volcano, burns its way through the
Xgorge, and plummets into a bottomless pit far off to your
Xleft.  To the right, an immense geyser of blistering
Xsteam erupts continuously from a barren island in the
Xcenter of a sulfurous lake, which bubbles ominously.
XThe far right wall is aflame with an incandescence of its
Xown, which lends an additional infernal splendor to the
Xalready hellish scene.  A dark, foreboding passage exits
Xto the south.
X#127
XYou are in a small chamber filled with large boulders.
XThe walls are very warm, causing the air in the room
Xto be almost stifling from the heat.  The only exit
Xis a crawl heading west, through which is coming
Xa low rumbling.
X#128
XYou are walking along a gently sloping north/south passage
Xlined with oddly shaped limestone formations.
X#129
XYou are standing at the entrance to a large, barren
Xroom.  A sign posted above the entrance reads:
X       "Caution!  Bear in room!"
X#130
XYou are inside a barren room.  The center of the room
Xis completely empty except for some dust.  Marks in
Xthe dust lead away toward the far end of the room.
XThe only exit is the way you came in.
X#131
XYou are in a maze of twisting little passages, all different.
X#132
XYou are in a little maze of twisty passages, all different.
X#133
XYou are in a twisting maze of little passages, all different.
X#134
XYou are in a twisting little maze of passages, all different.
X#135
XYou are in a twisty little maze of passages, all different.
X#136
XYou are in a twisty maze of little passages, all different.
X#137
XYou are in a little twisty maze of passages, all different.
X#138
XYou are in a maze of little twisting passages, all different.
X#139
XYou are in a maze of little twisty passages, all different.
X#140
XDead end.
/
echo x - advent2.txt
sed '/^X/s///' > advent2.txt << '/'
X#1
XYou're at end of road again.
X#2
XYou're at hill in road.
X#3
XYou're inside building.
X#4
XYou're in valley.
X#5
XYou're in forest.
X#6
XYou're in forest.
X#7
XYou're at slit in streambed.
X#8
XYou're outside grate.
X#9
XYou're below the grate.
X#10
XYou're in cobble crawl.
X#11
XYou're in debris room.
X#12
XYou are in an awkward sloping east/west canyon.
X#13
XYou're in bird chamber.
X#14
XYou're at top of small pit.
X#15
XYou're in hall of mists.
X#16
XThe crack is far too small for you to follow.
X#17
XYou're on east bank of fissure.
X#18
XYou're in nugget of gold room.
X#19
XYou're in hall of mt. king.
X#20
XYou are the the bottom of the pit with a broken neck.
X#21
XYou didn't make it.
X#22
XThe dome is unclimbable.
X#23
XYou're at west end of twopit room.
X#24
XYou're in east pit.
X#25
XYou're in west pit.
X#26
XYou clamber up the plant and scurry through the hole at the
Xtop.
X#27
XYou are on the west side of the fissure in the hall of mists.
X#28
XYou are in a low N/S passage at a hole in the floor.  The
Xhole goes down to an E/W passage.
X#29
XYou are in the south side chamber.
X#30
XYou are in the west side chamber of the hall of the
Xmountain king.  A passage continues west and up here.
X#31
X>$<
X#32
XYou can't get by the snake.
X#33
XYou're at "Y2".
X#34
XYou are in a jumble of rock, with cracks everywhere.
X#35
XYou're at window on pit.
X#36
XYou're in dirty passage.
X#37
XYou are on the brink of a small clean climbable pit.  A
Xcrawl leads west.
X#38
XYou are in the bottom of a small pit with a little stream,
Xwhich enters and exits through tiny slits.
X#39
XYou're in dusty rock room.
X#40
XYou have crawled through a very low wide passage parallel
Xto and north of the hall of mists.
X#41
XYou're at west end of hall of mists.
X#42
XYou are in a maze of twisty little passages, all alike.
X#43
XYou are in a maze of twisty little passages, all alike.
X#44
XYou are in a maze of twisty little passages, all alike.
X#45
XYou are in a maze of twisty little passages, all alike.
X#46
XDead end.
X#47
XDead end.
X#48
XDead end.
X#49
XYou are in a maze of twisty little passages, all alike.
X#50
XYou are in a maze of twisty little passages, all alike.
X#51
XYou are in a maze of twisty little passages, all alike.
X#52
XYou are in a maze of twisty little passages, all alike.
X#53
XYou are in a maze of twisty little passages, all alike.
X#54
XDead end.
X#55
XYou are in a maze of twisty little passages, all alike.
X#56
XDead end.
X#57
XYou're at brink of pit.
X#58
XDead end.
X#59
XYou have crawled through a very low wide passage paralled
Xto and north of the hall of mists.
X#60
XYou're at east end of long hall.
X#61
XYou're at west end of long hall.
X#62
XYou are at a crossover of a high N/S passage and a low
XE/W one.
X#63
XDead end.
X#64
XYou're at complex junction.
X#65
XYou are in bedquilt, a long east/west passage with holes
Xeverywhere.  To explore at random select north, south, up
Xor down.
X#66
XYou're in swiss cheese room.
X#67
XYou're at east end of twopit room.
X#68
XYou're in slab room.
X#69
XYou are in a secret N/S canyon above a large room.
X#70
XYou are in a secret N/S canyon above a sizable passage.
X#71
XYou're at junction of three secret canyons.
X#72
XYou are in a large low room.  Crawls lead north, se, and sw.
X#73
XDead end crawl.
X#74
XYou're at secret E/W canyon above tight canyon.
X#75
XYou are at a wide place in a very tight N/S canyon.
X#76
XThe canyon here becomes too tight to go further south.
X#77
XYou are in a tall E/W canyon.  A low tight crawl goes 3
Xfeet north and seems to open up.
X#78
XThe canyon runs into a mass of boulders -- dead end.
X#79
XThe stream flows out through a pair of 1 foot diameter
Xsewer pipes.  It would be advisable to use the exit.
X#80
XYou are in a maze of twisty little passages, all alike.
X#81
XDead end.
X#82
XDead end.
X#83
XYou are in a maze of twisty little passages, all alike.
X#84
XYou are in a maze of twisty little passages, all alike.
X#85
XDead end.
X#86
XDead end.
X#87
XYou are in a maze of twisty little passages, all alike.
X#88
XYou're in narrow corridor.
X#89
XThere is nothing here to climb.  Use "up" or "out" to leave
Xthe pit.
X#90
XYou have climbed up the plant and out of the pit.
X#91
XYou're at steep incline above large room.
X#92
XYou're in giant room.
X#93
XThe passage here is blocked by a recent cave-in.
X#94
XYou are at one end of an immense north/south passage.
X#95
XYou're in cavern with waterfall.
X#96
XYou're in soft room.
X#97
XYou're in oriental room.
X#98
XYou're in misty cavern.
X#99
XYou're in alcove.
X#100
XYou're in plover room.
X#101
XYou're in dark-room.
X#102
XYou're in arched hall.
X#103
XYou're in shell room.
X#104
XYou are in a long sloping corridor with ragged sharp walls.
X#105
XYou are in a cul-de-sac about eight feet across.
X#106
XYou're in anteroom.
X#107
XYou are in a maze of twisty little passages, all different.
X#108
XYou're at Witt's end.
X#109
XYou're in mirror canyon.
X#110
XYou're at window on pit.
X#111
XYou're at top of stalactite.
X#112
XYou are in a little maze of twisting passages, all different.
X#113
XYou're at reservoir.
X#114
XDead end.
X#115
XYou're at ne end of repository.
X#116
XYou're at sw end of repository.
X#117
XYou're on sw side of chasm.
X#118
XYou're in sloping corridor.
X#119
XYou are in a secret canyon which exits to the north and east.
X#120
XYou are in a secret canyon which exits to the north and east.
X#121
XYou are in a secret canyon which exits to the north and east.
X#122
XYou're on ne side of chasm.
X#123
XYou're in corridor.
X#124
XYou're at fork in path.
X#125
XYou're at junction with warm walls.
X#126
XYou're at breath-taking view.
X#127
XYou're in chamber of boulders.
X#128
XYou're in limestone passage.
X#129
XYou're in front of barren room.
X#130
XYou're in barren room.
X#131
XYou are in a maze of twisting little passages, all different.
X#132
XYou are in a little maze of twisty passages, all different.
X#133
XYou are in a twisting maze of little passages, all different.
X#134
XYou are in a twisting little maze of passages, all different.
X#135
XYou are in a twisty little maze of passages, all different.
X#136
XYou are in a twisty maze of little passages, all different.
X#137
XYou are in a little twisty maze of passages, all different.
X#138
XYou are in a maze of little twisting passages, all different.
X#139
XYou are in a maze of little twisty passages, all different.
X#140
XDead end.
/
echo x - advent3.txt
sed '/^X/s///' > advent3.txt << '/'
X#1
X/Set of keys.
X/There are some keys on the ground here.
X/
X#2
X/Brass lantern
X/There is a shiny brass lamp nearby.
X/There is a lamp shining nearby.
X/
X#3
X/*Grate
X/The grate is locked.
X/The grate is open.
X/
X#4
X/Wicker cage
X/There is a small wicker cage discarded nearby.
X/
X#5
X/Black rod
X/A three foot black rod with a rusty star on an end lies nearby.
X/
X#6
X/Black rod
X/A three foot black rod with a rusty mark on an end lies nearby.
X/
X#7
X/*Steps
X/Rough stone steps lead down the pit.
X/Rough stone steps lead up the dome.
X/
X#8
X/Little bird in cage
X/A cheerful little bird is sitting here singing.
X/There is a little bird in the cage.
X/
X#9
X/*Rusty door
X/The way north is barred by a massive, rusty, iron door.
X/The way north leads through a massive, rusty, iron door.
X/
X#10
X/Velvet pillow
X/A small velvet pillow lies on the floor.
X/
X#11
X/*Snake
X/A huge green fierce snake bars the way!
X//
X#12
X/*Fissure
X//A crystal bridge now spans the fissure.
X/The crystal bridge has vanished!
X/
X#13
X/*Stone tablet
X/A massive stone tablet imbedded in the wall reads:
X"Congratulations on bringing light into the dark-room!"
X/
X#14
X/Giant clam >Grunt!<
X/There is an enormous clam here with its shell tightly closed.
X/
X#15
X/Giant oyster >Groan!<
X/There is an enormous oyster here with its shell tightly closed.
X/Interesting.  There seems to be something written on the
Xunderside of the oyster.
X/
X#16
X/"Spelunker Today"
X/There are a few recent issues of "Spelunker Today" magazine
Xhere.
X/
X#17
X#18
X#19
X/Tasty food
X/There is tasty food here.
X/
X#20
X/Small bottle
X/There is a bottle of water here.
X/There is an empty bottle here.
X/There is a bottle of oil here.
X/
X#21
X/Water in the bottle.
X/
X#22
X/Oil in the bottle
X/
X#23
X/*Mirror
X//
X#24
X/*Plant
X/There is a tiny little plant in the pit, murmuring
X"Water, Water, ..."
X/The plant spurts into furious growth for a few seconds.
X/There is a 12-foot-tall beanstalk stretching up out of
Xthe pit, bellowing "Water!! Water!!"
X/The plant grows explosively, almost filling the bottom
Xof the pit. 
X/There is a gigantic beanstalk stretching all the way
Xup to the hole.
X/You've over-watered the plant!  It's shriveling up!
XIt's, It's...
X/
X#25
X/*Phony plant
X/
X/The top of a 12-foot-tall beanstalk is poking up out of
Xthe west pit.
X/There is a huge beanstalk growing out of the west pit up to
Xthe hole.
X/
X#26
X/*Stalactite
X//
X#27
X/*Shadowy figure
X/The shadowy figure seems to be trying to attract your attention.
X/
X#28
X/Dwarf's axe
X/There is a little axe here.
X/There is a little axe lying beside the bear.
X/
X#29
X/*Cave drawings
X//
X#30
X/*Pirate
X//
X#31
X/*Dragon
X/A huge green fierce dragon bars the way!
X/Congratulations!  You have just vanquished a dragon with
Xyour bare hands!  (Unbelievable, Isn't it?)
X/The body of a huge green dead dragon is lying off to one
Xside.
X/
X#32
X/*Chasm
X/A rickety wooden bridge extends across the chasm, vanishing
Xinto the mist.  A sign posted on the bridge reads:
X          "Stop!  Pay Troll!"
X/The wreckage of a bridge (and a dead bear) can be seen
Xat the bottom of the chasm.
X/
X#33
X/*Troll
X/A burly troll stands by the bridge and insists you throw
Xhim a treasure before you may cross.
X/The troll steps out from beneath the bridge and blocks
Xyour way.
X//
X#34
X/*Phony troll
X/The troll is nowhere to be seen.
X/
X#35
X//There is a ferocious cave bear eyeing you from the far
Xend of the room!
X/There is a gentle cave bear sitting placidly in one corner.
X/There is a contented-looking bear wandering about nearby.
X//
X#36
X/*Message in second maze
X/There is a message scrawled in the dust in a flowery script,
Xreading:
X           "This is not the maze where the"
X           "pirate leaves his treasure chest"
X/
X#37
X/*Volcano and,or Geyser
X//
X#38
X/*Vending machine
X/There is a massive vending machine here.  The instructions
Xon it read:
X     "Drop coins here to receive fresh batteries."
X/
X#39
X/Batteries
X/There are fresh batteries here.
X/Some worn-out batteries have been discarded nearby.
X/
X#40
X/*Carpet and,or moss
X//
X#41
X#42
X#43
X#44
X#45
X#46
X#47
X#48
X#49
X#50
X/Large gold nugget
X/There is a large sparkling nugget of gold here!
X/
X#51
X/Several diamonds
X/There are diamonds here!
X/
X#52
X/Bars of silver
X/There are bars of silver here!
X/
X#53
X/Precious jewelry
X/There is precious jewelry here!
X/
X#54
X/Rare coins
X/There are many coins here!
X/
X#55
X/Treasure chest
X/The pirate's treasure chest is here!
X/
X#56
X/Golden eggs
X/There is a large nest here, full of golden eggs!
X/The nest of golden eggs has vanished!
X/Done!
X/
X#57
X/Jeweled trident
X/There is a jewel-encrusted trident here!
X/
X#58
X/Ming vase
X/There is a delicate, precious, ming vase here!
X/The vase is now resting, delicately, on a velvet pillow.
X/The floor is littered with worthless shards of pottery.
X/The ming vase drops with a delicate crash.
X/
X#59
X/Egg-sized emerald
X/There is an emerald here the size of a plover's egg!
X/
X#60
X/Platinum pyramid
X/There is a platinum pyramid here, 8 inches on a side!
X/
X#61
X/Glistening pearl
X/Off to one side lies a glistening pearl!
X/
X#62
X/Persian rug
X/There is a persian rug spread out on the floor!
X/The dragon is sprawled out on a persian rug!!
X/
X#63
X/Rare spices
X/There are rare spices here!
X/
X#64
X/Golden chain
X/There is a golden chain lying in a heap on the floor!
X/The bear is locked to the wall with a golden chain!
X/There is a golden chain locked to the wall!
X/
/
echo x - advent4.txt
sed '/^X/s///' > advent4.txt << '/'
X#1
X
X
XSomewhere nearby is Colossal Cave, where others have
Xfound fortunes in treasure and gold, though it is rumored
Xthat some who enter are never seen again.  Magic is said
Xto work in the cave.  I will be your eyes and hands.  Direct
Xme with commands of 1 or 2 words.  I should warn you that I
Xlook at only the first five letters of each word, so you'll
Xhave to enter "Northeast" as "ne" to distinguish it from
X"North".  (Should you get stuck, type "help" for some
Xgeneral hints).
X
X#2
XA little dwarf with a big knife blocks your way.
X#3
XA little dwarf just walked around a corner, saw you,
Xthrew a little axe at you which missed, cursed, and ran away.
X#4
XThere is a threatening little dwarf in the room with you!
X#5
XOne sharp, nasty knife is thrown at you!
X#6
XNone of them hit you!
X#7
XOne of them gets you!
X#8
XA hollow voice says "Plugh".
X#9
XThere is no way to go that direction.
X#10
XI am unsure how you are facing.  Use compass points or
Xnearby objects.
X#11
XI don't know in from out here.  Use compass points or name
Xsomething in the general direction you want to go.
X#12
XI don't know how to apply that word here.
X#13
XI don't understand that!
X#14
XI'm game.  Would you care to explain how?
X#15
XSorry, but I am not allowed to give more detail.  I will
Xrepeat the long description of your location.
X#16
XIt is now pitch dark.  If you proceed you will likely fall
Xinto a pit.
X#17
XIf you prefer, simply type W rather than West.
X#18
XAre you trying to catch the bird?
X#19
XThe bird is frightened right now and you cannot catch
Xit no matter what you try.  Perhaps you might try later.
X#20
XAre you trying to somehow deal with the snake?
X#21
XYou can't kill the snake, or drive it away, or avoid it,
Xor anything like that.  There is a way to get by, but you
Xdon't have the necessary resources right now.
X#22
XDo you really want to quit now?
X#23
XYou fell into a pit and broke every bone in your body!
X#24
XYou are already carrying it!
X#25
XYou can't be serious!
X#26
XThe bird was unafraid when you entered, but as you approach
Xit becomes disturbed and you cannot catch it.
X#27
XYou can catch the bird, but you cannot carry it.
X#28
XThere is nothing here with a lock!
X#29
XYou aren't carrying it!
X#30
XThe little bird attacks the green snake, and in an
Xastounding flurry drives the snake away.
X#31
XYou have no keys!
X#32
XIt has no lock.
X#33
XI don't know how to lock or unlock such a thing.
X#34
XIt was already locked.
X#35
XThe grate is now locked.
X#36
XThe grate is now unlocked.
X#37
XIt was already unlocked.
X#38
XYou have no source of light.
X#39
XYour lamp is now on.
X#40
XYour lamp is now off.
X#41
XThere is no way to get past the bear to unlock the chain,_
Xwhich is probably just as well.
X#42
XNothing happens.
X#43
XWhere?
X#44
XThere is nothing here to attack.
X#45
XThe little bird is now dead.  Its body disappears.
X#46
XAttacking the snake both doesn't work and is very dangerous.
X#47
XYou killed a little dwarf.
X#48
XYou attack a little dwarf, but he dodges out of the way.
X#49
XWith what? Your bare hands?
X#50
XGood try, but that is an old worn-out magic word.
X#51
XI know of places, actions, and things.  Most of my vocabulary
Xdescribes places and is used to move you there.  To move, try
Xwords like forest, building, downstream, enter, east, west,
Xnorth, south, up or down.  I know about a few special
Xobjects, like a black rod hidden in the cave.  These objects
Xcan be manipulated using some of the action words I know.
XUsually you will need to give both the object and action
Xwords (In either order), but sometimes I can infer the
Xobject from the verb alone.  Some objects also imply verbs;
Xin particular, "inventory" implies "take inventory", which
Xcauses me to give you a list of what you're carrying.  The
Xobjects have side effects; for instance, the rod scares the
Xbird.  Usually people having trouble moving just need
Xto try a few more words.  Usually people trying unsuccessfully
Xto manipulate an object are attempting something beyond their
X(or my!) capabilities and should try a completely different
Xtack.  To speed the game you can sometimes move long distances
Xwith a single word.  For example, "building" usually gets you
Xto the building from anywhere above ground except when lost
Xin the forest.  Also, note that cave passages turn a lot, and
Xthat leaving a room to the north does not guarantee entering
Xthe next from the south.
XGood luck!
X#52
XIt misses!
X#53
XIt gets you!
X#54
XOK
X#55
XYou can't unlock the keys.
X#56
XYou have crawled around in some little holes and wound up
Xback in the main passage.
X#57
XI don't know where the cave is, but hereabouts no stream
Xcan run on the surface for very long.  I would try the stream.
X#58
XI need more detailed instructions to do that.
X#59
XI can only tell you what you see as you move about and
Xmanipulate things.  I cannot tell you where remote things are.
X#60
XI don't know that word.
X#61
XWhat?
X#62
XAre you trying to get into the cave?
X#63
XThe grate is very solid and has a hardened steel lock.  You
Xcannot enter without a key, and there are no keys nearby.
XI would recommend looking elsewhere for the keys.
X#64
XThe trees of the forest are large hardwood oak and maple,
Xwith an occasional grove of pine or spruce.  There is quite
Xa bit of undergrowth, largely birch and ash saplings plus
Xnondescript bushes of various sorts.  This time of year 
Xvisibility is quite restricted by all the leaves, but travel
Xis quite easy if you detour around the spruce and berry
Xbushes.
X#65
X
X
X		Welcome to ADVENTURE!
X
X
X	Original development by Willie Crowther.
X
X	Major features added by Don Woods.
X
X	Conversion to BDS  C by J. R. Jaeger
X
X	Unix standardization by Jerry D. Pohl.
X
X
X		Would you like instructions?
X
X#66
XDigging without a shovel is quite impractical.  Even with a
Xshovel progress is unlikely.
X#67
XBlasting requires dynamite.
X#68
XI'm as confused as you are.
X#69
XMist is a white vapor, usually water.  Seen from time to time
Xin caverns.  It can be found anywhere but is frequently a
Xsign of a deep pit leading down to water.
X#70
XYour feet are now wet.
X#71
XI think I just lost my appetite.
X#72
XThank you.  It was delicious!
X#73
XYou have taken a drink from the stream.  The water tastes
Xstrongly of minerals, but is not unpleasant.  It is extremely
Xcold.
X#74
XThe bottle of water is now empty.
X#75
XRubbing the electric lamp is not particularly rewarding.
XAnyway, nothing exciting happens.
X#76
XPeculiar.  Nothing unexpected happens.
X#77
XYour bottle is empty and the ground is wet.
X#78
XYou can't pour that.
X#79
XWatch it!
X#80
XWhich way?
X#81
XOh dear, you seem to have gotten yourself killed.  I might
Xbe able to help you out, but I've never really done this
Xbefore.  Do you want me to try to reincarnate you?
X#82
XAll right.  But don't blame me if something goes wr......
X                    --- POOF !! ---
XYou are engulfed in a cloud of orange smoke.  Coughing and
Xgasping, you emerge from the smoke and find...
X#83
XYou clumsy oaf, you've done it again!  I don't know how long
XI can keep this up.  Do you want me to try reincarnating
Xyou again?
X#84
XOkay, now where did i put my orange smoke? ... > POOF! <
XEverything disappears in a dense cloud of orange smoke.
X#85
XNow you've really done it!  I'm out of orange smoke!  You
Xdon't expect me to do a decent reincarnation without any
Xorange smoke, do you?
X#86
XOkay, If you're so smart, do it yourself!  I'm leaving!
X#87
XReserved
X#88
XReserved
X#89
XReserved
X#90
XReserved
X#91
XSorry, but I no longer seem to remember how it was you
Xgot here.
X#92
XYou can't carry anything more.  You'll have to drop something
Xfirst.
X#93
XYou can't go through a locked steel grate!
X#94
XI believe what you want is right here with you.
X#95
XYou don't fit through a two-inch slit!
X#96
XI respectfully suggest you go across the bridge instead
Xof jumping.
X#97
XThere is no way across the fissure.
X#98
XYou're not carrying anything.
X#99
XYou are currently holding the following:
X#100
XIt's not hungry (It's merely pinin' for the Fjords).  Besides
XYou have no bird seed.
X#101
XThe snake has now devoured your bird.
X#102
XThere's nothing here it wants to eat (Except perhaps you).
X#103
XYou fool, Dwarves eat only coal!  Now you've made
Xhim REALLY mad !!
X#104
XYou have nothing in which to carry it.
X#105
XYour bottle is already full.
X#106
XThere is nothing here with which to fill the bottle.
X#107
XYour bottle is now full of water.
X#108
XYour bottle is now full of oil.
X#109
XYou can't fill that.
X#110
XDon't be ridiculous!
X#111
XThe door is extremely rusty and refuses to open.
X#112
XThe plant indignantly shakes the oil off its leaves and asks:
X"Water?".
X#113
XThe hinges are quite thoroughly rusted now and won't budge.
X#114
XThe oil has freed up the hinges so that the door will now move,
Xalthough it requires some effort.
X#115
XThe plant has exceptionally deep roots and cannot be pulled free.
X#116
XThe Dwarves' knives vanish as they strike the walls of the cave.
X#117
XSomething you're carrying won't fit through the tunnel with
Xyou.  You'd best take inventory and drop something.
X#118
XYou can't fit this five-foot clam through that little passage!
X#119
XYou can't fit this five foot oyster through that little passage!
X#120
XI advise you to put down the clam before opening it. >STRAIN!<
X#121
XI advise you to put down the oyster before opening it.
X>WRENCH!<
X#122
XYou don't have anything strong enough to open the clam.
X#123
XYou don't have anything strong enough to open the oyster.
X#124
XA glistening pearl falls out of the clam and rolls away.
XGoodness, this must really be an oyster.  (I never was
Xvery good at identifying bivalves.)  Whatever it is,
Xit has now snapped shut again.
X#125
XThe oyster creaks open, revealing nothing but oyster inside.
XIt promptly snaps shut again.
X#126
XYou have crawled around in some little holes and found your
Xway blocked by a recent cave-in.  You are now back in the
Xmain passage.
X#127
XThere are faint rustling noises from the darkness behind
Xyou.
X#128
XOut from the shadows behind you pounces a bearded pirate!
X"Har, har" he chortles, "I'll just take all this booty and
Xhide it away with me chest deep in the maze!".  He snatches
Xyour treasure and vanishes into the gloom.
X#129
XA sepulchral voice reverberating through the cave says:
X"Cave closing soon.  All adventurers exit immediately
Xthrough main office."
X#130
XA mysterious recorded voice groans into life and announces:
X"This exit is closed.  Please leave via main office."
X#131
XIt looks as though you're dead.  Well, seeing as how it's so
Xclose to closing time anyway, I think we'll just call it a day.
X#132
XThe sepulchral voice entones, "The cave is now closed."  As
Xthe echoes fade, there is a blinding flash of light (and a
Xsmall puff of orange smoke). . . . 
XAs your eyes refocus you look around and find...
X#133
XThere is a loud explosion, and a twenty-foot hole appears in
Xthe far wall, burying the Dwarves in the rubble.  You march
Xthrough the hole and find yourself in the main office, where
Xa cheering band of friendly elves carry the conquering
Xadventurer off into the sunset.
X#134
XThere is a loud explosion, and a twenty-foot hole appears in
Xthe far wall, burying the snakes in the rubble.  A river of
Xmolten lava pours in through the hole, destroying
Xeverything in its path, including you!!
X#135
XThere is a loud explosion, and you are suddenly splashed across
Xthe walls of the room.
X#136
XThe resulting ruckus has awakened the Dwarves.  There are now
Xseveral threatening little Dwarves in the room with you!
XMost of them throw knives at you!  All of them get you!
X#137
XOh, leave the poor unhappy bird alone.
X#138
XI daresay whatever you want is around here somewhere.
X#139
XI don't know the word "stop".   Use "quit" if you want to
Xgive up.
X#140
XYou can't get there from here.
X#141
XYou are being followed by a very large, tame bear.
X#142
XIf you want to end your adventure early, say "quit".  To
Xsuspend you adventure such that you can continue later
Xsay "suspend" (or "pause" or "save").  To see how well
Xyou're doing, say "score".  To get full credit for a
Xtreasure, you must have left it safely in the building,
Xthough you get partial credit just for locating it.
XYou lose points for getting killed, or for quitting,
Xthough the former costs you more.  There are also points
Xbased on how much (If any) of the cave you've managed to
Xexplore;  in particular, there is a large bonus just for
Xgetting in (to distinguish the beginners from the rest of
Xthe pack), and there are other ways to determine whether
Xyou've been through some of the more harrowing sections.
XIf you think you've found all the treasures, just keep
Xexploring for a while.  If nothing interesting happens, you
Xhaven't found them all yet.  If something interesting DOES
Xhappen, it means you're getting a bonus and have an
Xopportunity to garner many more points in the master's
Xsection.  I may occasionally offer hints in you seem to
Xbe having trouble.  If I do, I'll warn you in
Xadvance how much it will affect your score to accept the
Xhints.  Finally, to save paper, you may specify "brief",
Xwhich tells me never to repeat the full description of a place
Xunless you explicitly ask me to.
X#143
XDo you indeed wish to quit now?
X#144
XThere is nothing here with which to fill the vase.
X#145
XThe sudden change in temperature has delicately shattered
Xthe vase.
X#146
XIt is beyond your power to do that.
X#147
XI don't know how.
X#148
XIt is too far up for you to reach.
X#149
XYou killed a little Dwarf.  The body vanished in a cloud
Xof greasy black smoke.
X#150
XThe shell is very strong and impervious to attack.
X#151
XWhat's the matter, can't you read?  Now you'd best start
Xover.
X#152
XThe axe bounces harmlessly off the dragon's thick scales.
X#153
XThe dragon looks rather nasty.  You'd best not try to get by.
X#154
XThe little bird attacks the green dragon, and in an
Xastounding flurry gets burnt to a cinder.  The ashes blow away.
X#155
XOn what?
X#156
XOkay, from now on I'll only describe a place in full the
Xfirst time you come to it.  To get the full description
Xsay "look".
X#157
XTrolls are close relatives with the rocks and have skin as
Xtough as that of a rhinoceros.  The troll fends off your
Xblows effortlessly.
X#158
XThe troll deftly catches the axe, examines it carefully,
Xand tosses it back, declaring, "Good workmanship,
Xbut it's not valuable enough.".
X#159
XThe troll catches your treasure and scurries away out of sight.
X#160
XThe troll refuses to let you cross.
X#161
XThere is no longer any way across the chasm.
X#162
XJust as you reach the other side, the bridge buckles beneath
Xthe weight of the bear, which was still following you around.
XYou scrabble desperately for support, but as the bridge 
Xcollapses you stumble back and fall into the chasm.
X#163
XThe bear lumbers toward the troll, who lets out a
Xstartled shriek and scurries away.  The bear soon gives
Xup pursuit and wanders back.
X#164
XThe axe misses and lands near the bear where you can't get
Xat it.
X#165
XWith what?  Your bare hands?  Agains HIS bear hands??
X#166
XThe bear is confused;  he only wants to be your friend.
X#167
XFor crying out loud, the poor thing is already dead!
X#168
XThe bear eagerly wolfs down your food, after which he seems
Xto calm down considerably, and even becomes rather friendly.
X#169
XThe bear is still chained to the wall.
X#170
XThe chain is still locked.
X#171
XThe chain is now unlocked.
X#172
XThe chain is now locked.
X#173
XThere is nothing here to which the chain can be locked.
X#174
XThere is nothing here to eat.
X#175
XDo you want the hint?
X#176
XDo you need help getting out of the maze?
X#177
XYou can make the passages look less alike by dropping things.
X#178
XAre you trying to explore beyond the plover room?
X#179
XThere is a way to explore that region without having to
Xworry about falling into a pit.  None of the objects
Xavailable is immediately useful in descovering the secret.
X#180
XDo you need help getting out of here?
X#181
XDon't go west.
X#182
XGluttony is not one of the Troll's vices.  Avarice, however, is.
X#183
XYour lamp is getting dim.. You'd best start wrapping this up,
Xunless you can find some fresh batteries.  I seem to recall
Xthere's a vending machine in the maze.  Bring some coins
Xwith you.
X#184
XYour lamp has run out of power.
X#185
XThere's not much point in wandering around out here, and you
Xcan't explore the cave without a lamp.  So let's just call
Xit a day.
X#186
XThere are faint rustling noises from the darkness behind you.
XAs you turn toward them, the beam of your lamp falls across a
Xbearded pirate.  He is carrying a large chest.  "Shiver me
Xtimbers!"  he cries, "I've been spotted!  I'd best hide
Xmeself off to the maze and hide me chest!".  With that,
Xhe vanished into the gloom.
X#187
XYour lamp is getting dim.  You'd best go back for
Xthose batteries.
X#188
XYour lamp is getting dim.. I'm taking the liberty of replacing
Xthe batteries.
X#189
XYour lamp is getting dim, and you're out of spare batteries.
XYou'd best start wrapping this up.
X#190
XI'm afraid the magazine is written in Dwarvish.
X#191
X"This is not the maze where the pirate leaves his treasure
Xchest."
X#192
XHmm, this looks like a clue, which means it'll cost you 10
Xpoints to read it.  Should I go ahead and read it anyway?
X#193
XIt says, "There is something strange about this place,
Xsuch that one of the words I've always known now has
Xa new effect."
X#194
XIt says the same thing it did before.
X#195
XI'm afraid I don't understand.
X#196
X"Congratulations on bringing light into the dark-room!"
X#197
XYou strike the mirror a resounding blow, whereupon it
Xshatters into a myriad tiny fragments.
X#198
XYou have taken the vase and hurled it delicately to the
Xground.
X#199
XYou prod the nearest Dwarf, who wakes up grumpily, takes
Xone look at you, curses, and grabs for his axe.
X#200
XIs this acceptable?
X#201
XThere's no point in suspending a demonstration game.
/
echo x - advtext.h
sed '/^X/s///' > advtext.h << '/'
X
X/*	header: ADVTEXT.H					*/
X
X
Xlong	idx1[MAXLOC] = {
X	3,160,304,367,448,
X	507,564,689,855,980,
X	1086,1333,1385,1567,1694,
X	2033,2083,2224,2332,2415,
X	2472,2496,2525,2647,2770,
X	2894,2963,3029,3125,3164,
X	3274,3282,3314,3490,3547,
X	4023,4151,4229,4335,4477,
X	4574,4733,4793,4853,4913,
X	4973,4986,4999,5012,5072,
X	5132,5192,5252,5312,5325,
X	5385,5398,5581,5594,5691,
X	5863,5977,6045,6058,6270,
X	6398,6557,6892,7187,7242,
X	7302,7447,7512,7532,7688,
X	7744,7803,7896,7953,8065,
X	8125,8139,8153,8213,8273,
X	8287,8301,8361,8516,8589,
X	8643,8818,9043,9096,9154,
X	9364,9499,9698,9944,10149,
X	10283,10357,10504,10769,10834,
X	10888,11197,11262,11328,11802,
X	12278,12486,12553,12884,12899,
X	13652,14160,14346,14427,14494,
X	14561,14628,14722,14818,15026,
X	15215,16503,16733,16843,16980,
X	17180,17247,17312,17379,17446,
X	17511,17576,17641,17708,17773
X	};
X
Xlong	idx2[MAXLOC] = {
X	3,35,62,89,110,
X	131,152,184,209,237,
X	265,292,344,372,404,
X	433,483,519,554,586,
X	644,668,697,736,760,
X	784,853,919,1015,1054,
X	1164,1172,1204,1224,1281,
X	1310,1339,1417,1523,1554,
X	1651,1692,1752,1812,1872,
X	1932,1946,1960,1974,2034,
X	2094,2154,2214,2274,2288,
X	2348,2362,2390,2404,2501,
X	2538,2575,2643,2657,2689,
X	2817,2850,2889,2914,2969,
X	3029,3077,3142,3162,3214,
X	3270,3329,3422,3479,3591,
X	3651,3665,3679,3739,3799,
X	3813,3827,3887,3918,3991,
X	4045,4091,4117,4170,4228,
X	4265,4290,4319,4347,4370,
X	4398,4424,4452,4479,4544,
X	4598,4623,4688,4715,4745,
X	4775,4809,4876,4902,4917,
X	4954,4991,5024,5057,5124,
X	5191,5258,5291,5316,5345,
X	5386,5421,5457,5491,5528,
X	5556,5623,5688,5755,5822,
X	5887,5952,6017,6084,6149
X	};
X
Xlong	idx3[MAXOBJ] = {
X	3,63,153,208,274,
X	355,436,524,636,770,
X	833,889,981,1110,1200,
X	1377,1469,1473,1477,1522,
X	1640,1668,1693,1709,2151,
X	2315,2335,2424,2518,2541,
X	2557,2780,3020,3196,3250,
X	3451,3643,3674,3821,3924,
X	3952,3956,3960,3964,3968,
X	3972,3976,3980,3984,3988,
X	4062,4112,4166,4223,4269,
X	4329,4444,4509,4733,4812,
X	4891,4957,5072,5120
X	};
X
Xlong	idx4[MAXMSG] = {
X	3,485,537,655,716,
X	760,785,810,842,884,
X	959,1073,1119,1148,1194,
X	1301,1376,1427,1465,1580,
X	1631,1796,1832,1891,1924,
X	1950,2060,2113,2152,2180,
X	2276,2298,2318,2371,2398,
X	2427,2458,2487,2520,2545,
X	2571,2666,2687,2698,2735,
X	2790,2855,2886,2947,2979,
X	3033,4327,4342,4359,4366,
X	4397,4485,4609,4659,4781,
X	4809,4819,4860,5032,5394,
X	5619,5712,5744,5776,5942,
X	5969,6006,6040,6170,6208,
X	6303,6346,6394,6419,6433,
X	6448,6619,6823,6956,7073,
X	7214,7274,7287,7300,7313,
X	7326,7395,7468,7515,7567,
X	7610,7682,7722,7756,7802,
X	7892,7935,7999,8072,8116,
X	8150,8208,8247,8284,8310,
X	8336,8390,8467,8532,8635,
X	8706,8776,8893,8961,9031,
X	9099,9169,9230,9293,9494,
X	9590,9727,9794,10019,10156,
X	10275,10405,10614,10888,11104,
X	11196,11376,11420,11479,11551,
X	11587,11643,12965,13002,13058,
X	13131,13172,13195,13235,13320,
X	13376,13444,13507,13574,13695,
X	13709,13839,13980,14124,14193,
X	14234,14284,14521,14661,14732,
X	14791,14852,14910,15036,15080,
X	15112,15144,15174,15235,15270,
X	15297,15344,15411,15466,15639,
X	15682,15702,15772,15966,16003,
X	16138,16466,16538,16621,16722,
X	16775,16847,16969,17097,17140,
X	17176,17237,17335,17404,17514,
X	17539
X	};
X
/
echo x - advword.h
sed '/^X/s///' > advword.h << '/'
X
X/*	header ADVWORD.H					*/
X
X
X/*
X  Adventure vocabulary & encryption
X*/
Xstruct wac wc[] =
X{
X "spelunker today", 1016,
X "?", 3051,
X "above", 29,
X "abra", 3050,
X "abracadabra", 3050,
X "across", 42,
X "ascend", 29,
X "attack", 2012,
X "awkward", 26,
X "axe", 1028,
X "back", 8,
X "barren", 40,
X "bars", 1052,
X "batteries", 1039,
X "battery", 1039,
X "beans", 1024,
X "bear", 1035,
X "bed", 16,
X "bedquilt", 70,
X "bird", 1008,
X "blast", 2023,
X "blowup", 2023,
X "bottle", 1020,
X "box", 1055,
X "break", 2028,
X "brief", 2026,
X "broken", 54,
X "building", 12,
X "cage", 1004,
X "calm", 2010,
X "canyon", 25,
X "capture", 2001,
X "carpet", 1040,
X "carry", 2001,
X "catch", 2001,
X "cave", 67,
X "cavern", 73,
X "chain", 1064,
X "chant", 2003,
X "chasm", 1032,
X "chest", 1055,
X "clam", 1014,
X "climb", 56,
X "close", 2006,
X "cobblestone", 18,
X "coins", 1054,
X "continue", 2011,
X "crack", 33,
X "crap", 3079,
X "crawl", 17,
X "cross", 69,
X "d", 30,
X "damn", 3079,
X "damnit", 3079,
X "dark", 22,
X "debris", 51,
X "depression", 63,
X "descend", 30,
X "describe", 57,
X "detonate", 2023,
X "devour", 2014,
X "diamonds", 1051,
X "dig", 3066,
X "discard", 2002,
X "disturb", 2029,
X "dome", 35,
X "door", 1009,
X "down", 30,
X "downstream", 4,
X "downward", 30,
X "dragon", 1031,
X "drawing", 1029,
X "drink", 2015,
X "drop", 2002,
X "dump", 2002,
X "dwarf", 1017,
X "dwarves", 1017,
X "e", 43,
X "east", 43,
X "eat", 2014,
X "egg", 1056,
X "eggs", 1056,
X "emerald", 1059,
X "enter", 3,
X "entrance", 64,
X "examine", 57,
X "excavate", 3066,
X "exit", 11,
X "explore", 2011,
X "extinguish", 2008,
X "fee", 2025,
X "fee", 3001,
X "feed", 2021,
X "fie", 2025,
X "fie", 3002,
X "fight", 2012,
X "figure", 1027,
X "fill", 2022,
X "find", 2019,
X "fissure", 1012,
X "floor", 58,
X "foe", 2025,
X "foe", 3003,
X "follow", 2011,
X "foo", 2025,
X "foo", 3004,
X "food", 1019,
X "forest", 6,
X "fork", 77,
X "forward", 7,
X "free", 2002,
X "fuck", 3079,
X "fum", 2025,
X "fum", 3005,
X "get", 2001,
X "geyser", 1037,
X "giant", 27,
X "go", 2011,
X "gold", 1050,
X "goto", 2011,
X "grate", 1003,
X "gully", 13,
X "h2o", 1021,
X "hall", 38,
X "headlamp", 1002,
X "help", 3051,
X "hill", 2,
X "hit", 2012,
X "hocus", 3050,
X "hole", 52,
X "hours", 2031,
X "house", 12,
X "ignite", 2023,
X "in", 19,
X "info", 3142,
X "information", 3142,
X "inside", 19,
X "inventory", 2020,
X "inward", 19,
X "issue", 1016,
X "jar", 1020,
X "jewel", 1053,
X "jewelry", 1053,
X "jewels", 1053,
X "jump", 39,
X "keep", 2001,
X "key", 1001,
X "keys", 1001,
X "kill", 2012,
X "knife", 1018,
X "knives", 1018,
X "lamp", 1002,
X "lantern", 1002,
X "leave", 11,
X "left", 36,
X "light", 2007,
X "lock", 2006,
X "log", 2032,
X "look", 57,
X "lost", 3068,
X "low", 24,
X "machine", 1038,
X "magazine", 1016,
X "main", 76,
X "message", 1036,
X "ming", 1058,
X "mirror", 1023,
X "mist", 3069,
X "moss", 1040,
X "mumble", 2003,
X "n", 45,
X "ne", 47,
X "nest", 1056,
X "north", 45,
X "nothing", 2005,
X "nowhere", 21,
X "nugget", 1050,
X "null", 21,
X "nw", 50,
X "off", 2008,
X "office", 76,
X "oil", 1022,
X "on", 2007,
X "onward", 7,
X "open", 2004,
X "opensesame", 3050,
X "oriental", 72,
X "out", 11,
X "outdoors", 32,
X "outside", 11,
X "over", 41,
X "oyster", 1015,
X "passage", 23,
X "pause", 2030,
X "pearl", 1061,
X "persian", 1062,
X "peruse", 2027,
X "pillow", 1010,
X "pirate", 1030,
X "pit", 31,
X "placate", 2010,
X "plant", 1024,
X "plant", 1025,
X "platinum", 1060,
X "plover", 71,
X "plugh", 65,
X "pocus", 3050,
X "pottery", 1058,
X "pour", 2013,
X "proceed", 2011,
X "pyramid", 1060,
X "quit", 2018,
X "rations", 1019,
X "read", 2027,
X "release", 2002,
X "reservoir", 75,
X "retreat", 8,
X "return", 8,
X "right", 37,
X "road", 2,
X "rock", 15,
X "rod", 1005,
X "rod", 1006,
X "room", 59,
X "rub", 2016,
X "rug", 1062,
X "run", 2011,
X "s", 46,
X "save", 2030,
X "say", 2003,
X "score", 2024,
X "se", 48,
X "secret", 66,
X "sesame", 3050,
X "shadow", 1027,
X "shake", 2009,
X "shard", 1058,
X "shatter", 2028,
X "shazam", 3050,
X "shell", 74,
X "shit", 3079,
X "silver", 1052,
X "sing", 2003,
X "slab", 61,
X "slit", 60,
X "smash", 2028,
X "snake", 1011,
X "south", 46,
X "spelunker", 1016,
X "spice", 1063,
X "spices", 1063,
X "stairs", 10,
X "stalactite", 1026,
X "steal", 2001,
X "steps", 1007,
X "steps", 34,
X "stop", 3139,
X "stream", 14,
X "strike", 2012,
X "surface", 20,
X "suspend", 2030,
X "sw", 49,
X "swim", 3147,
X "swing", 2009,
X "tablet", 1013,
X "take", 2001,
X "tame", 2010,
X "throw", 2017,
X "toss", 2017,
X "tote", 2001,
X "touch", 57,
X "travel", 2011,
X "treasure", 1055,
X "tree", 3064,
X "trees", 3064,
X "trident", 1057,
X "troll", 1033,
X "troll", 1034,
X "tunnel", 23,
X "turn", 2011,
X "u", 29,
X "unlock", 2004,
X "up", 29,
X "upstream", 4,
X "upward", 29,
X "utter", 2003,
X "valley", 9,
X "vase", 1058,
X "velvet", 1010,
X "vending", 1038,
X "view", 28,
X "volcano", 1037,
X "w", 44,
X "wake", 2029,
X "walk", 2011,
X "wall", 53,
X "water", 1021,
X "wave", 2009,
X "west", 44,
X "xyzzy", 62,
X "y2", 55
X};
/
echo x - database.c
sed '/^X/s///' > database.c << '/'
X
X/**	program DATABASE.C					*
X *	WARNING: "advent.c" allocates GLOBAL storage space by	*
X *		including "advdef.h".				*
X *		All other modules use "advdec.h".		*/
X
X
X#include        <string.h>
X#include	<ctype.h>
X#include	<stdio.h>
X#include	"advent.h"
X#include	"advdec.h"
X#include	"advcave.h"
X
X_PROTOTYPE (void exit, (int status));
X
X/*
X  Routine to fill travel array for a given location
X*/
Xvoid gettrav(loc)
Xint loc;
X{
X  int i;
X  long t, *lptr;
X
X  lptr = cave[loc - 1];
X  for (i = 0; i < MAXTRAV; i++) {
X	t = *lptr++;
X	if (!(t)) {
X		travel[i].tdest = -1;	/* end of array	 */
X		if (g.dbugflg) for (i = 0; i < MAXTRAV; ++i)
X				printf("cave[%d] = %d %d %d\n",
X				       loc, travel[i].tdest,
X				  travel[i].tverb, travel[i].tcond);
X		return;		/* terminate for loop	 */
X	}
X	travel[i].tcond = (t % 1000);
X	t /= 1000;
X	travel[i].tverb = (t % 1000);
X	t /= 1000;
X	travel[i].tdest = (t % 1000);
X  }
X  bug(33);
X  return;
X}
X
X/*
X  Function to scan a file up to a specified
X  point and either print or return a string.
X*/
Xint rdupto(fdi, uptoc, print, string)
XFILE *fdi;
Xchar uptoc, print, *string;
X{
X  int c;
X
X  while ((c = fgetc(fdi)) != uptoc) {
X	if (c == EOF) return(0);
X	if (c == '\r') continue;
X	if (print)
X		fputc(c, stdout);
X	else
X		*string++ = c;
X  }
X  if (!print) *string = '\0';
X  return(1);
X}
X
X/*
X  Function to read a file skipping
X  a given character a specified number
X  of times, with or without repositioning
X  the file.
X*/
Xvoid rdskip(fdi, skipc, n, rewind_)
XFILE *fdi;
Xchar skipc, rewind_;
Xint n;
X{
X  int c;
X
X  if (rewind_)
X	if (fseek(fdi, 0, 0) == -1) bug(31);
X  while (n--) while ((c = fgetc(fdi)) != skipc)
X		if (c == EOF) bug(32);
X}
X
X/*
X  Routine to request a yes or no answer to a question.
X*/
Xint yes(msg1, msg2, msg3)
Xint msg1, msg2, msg3;
X{
X  char answer[80];
X
X  if (msg1) rspeak(msg1);
X  fprintf(stdout, "\n> ");
X  fgets(answer, 80, stdin);
X  if (tolower(answer[0]) == 'n') {
X	if (msg3) rspeak(msg3);
X	return(0);
X  }
X  if (msg2) rspeak(msg2);
X  return(1);
X}
X
X/*
X  Print a location description from "advent4.txt"
X*/
Xvoid rspeak(msg)
Xint msg;
X{
X  if (msg == 54)
X	printf("ok.\n");
X  else {
X	if (g.dbugflg) printf("Seek loc msg #%d @ %ld\n", msg, idx4[msg]);
X	fseek(fd4, idx4[msg - 1], 0);
X	rdupto(fd4, '#', 1, 0);
X  }
X  return;
X}
X
X/*
X  Print an item message for a given state from "advent3.txt"
X*/
Xvoid pspeak(item, state)
Xint item, state;
X{
X  fseek(fd3, idx3[item - 1], 0);
X  rdskip(fd3, '/', state + 2, 0);
X  rdupto(fd3, '/', 1, 0);
X}
X
X/*
X  Print a long location description from "advent1.txt"
X*/
Xvoid desclg(loc)
Xint loc;
X{
X  fseek(fd1, idx1[loc - 1], 0);
X  rdupto(fd1, '#', 1, 0);
X}
X
X/*
X  Print a short location description from "advent2.txt"
X*/
Xvoid descsh(loc)
Xint loc;
X{
X  fseek(fd2, idx2[loc - 1], 0);
X  rdupto(fd2, '#', 1, 0);
X}
X
X/*
X  look-up vocabulary word in lex-ordered table.  words may have
X  two entries with different codes. if minimum acceptable value
X  = 0, then return minimum of different codes.  last word CANNOT
X  have two entries(due to binary sort).
X  word is the word to look up.
X  val  is the minimum acceptable value,
X	if != 0 return %1000
X*/
Xint vocab(word, val)
Xchar *word;
Xint val;
X{
X  int v1, v2;
X
X  if ((v1 = binary(word, wc, MAXWC)) >= 0) {
X	if (v1 > 0 && strcmp(word, wc[v1 - 1].aword) == 0)
X		v2 = v1 - 1;
X	else if (v1 < (MAXWC-1) && strcmp(word, wc[v1 + 1].aword) == 0)
X		v2 = v1 + 1;
X	else
X		v2 = v1;
X	if (!val) return(wc[v1].acode < wc[v2].acode
X			? wc[v1].acode : wc[v2].acode);
X	if (val <= wc[v1].acode)
X		return(wc[v1].acode % 1000);
X	else if (val <= wc[v2].acode)
X		return(wc[v2].acode % 1000);
X	else
X		return(-1);
X  } else
X	return(-1);
X}
X
Xint binary(w, wctable, maxwc)
Xchar *w;
Xint maxwc;
Xstruct wac wctable[];
X{
X  int lo, mid, hi, check;
X
X  lo = 0;
X  hi = maxwc - 1;
X  while (lo <= hi) {
X	mid = (lo + hi) / 2;
X	if ((check = strcmp(w, wctable[mid].aword)) < 0)
X		hi = mid - 1;
X	else if (check > 0)
X		lo = mid + 1;
X	else
X		return(mid);
X  }
X  return(-1);
X}
X
X
X/*
X  Utility Routines
X*/
X
X/*
X  Routine to test for darkness
X*/
Xint dark()
X{
X  return(!(g.cond[g.loc] & LIGHT) &&
X	(!g.prop[LAMP] ||
X	 !here(LAMP)));
X}
X
X/*
X  Routine to tell if an item is present.
X*/
Xint here(item)
Xint item;
X{
X  return(g.place[item] == g.loc || toting(item));
X}
X
X/*
X  Routine to tell if an item is being carried.
X*/
Xint toting(item)
Xint item;
X{
X  return(g.place[item] == -1);
X}
X
X/*
X  Routine to tell if a location causes
X  a forced move.
X*/
Xint forced(atloc)
Xint atloc;
X{
X  return(g.cond[atloc] == 2);
X}
X
X/*
X  Routine true x% of the time.
X*/
Xint pct(x)
Xint x;
X{
X  return(rand() % 100 < x);
X}
X
X/*
X  Routine to tell if player is on
X  either side of a two sided object.
X*/
Xint at(item)
Xint item;
X{
X  return(g.place[item] == g.loc || g.fixed[item] == g.loc);
X}
X
X/*
X  Routine to destroy an object
X*/
Xvoid dstroy(obj)
Xint obj;
X{
X  move(obj, 0);
X}
X
X/*
X  Routine to move an object
X*/
Xvoid move(obj, where)
Xint obj, where;
X{
X  int from;
X
X  from = (obj < MAXOBJ) ? g.place[obj] : g.fixed[obj];
X  if (from > 0 && from <= 300) carry(obj, from);
X  drop(obj, where);
X}
X
X/*
X  Juggle an object
X  currently a no-op
X*/
Xvoid juggle(loc)
Xint loc;
X{
X}
X
X/*
X  Routine to carry an object
X*/
Xvoid carry(obj, where)
Xint obj, where;
X{
X  if (obj < MAXOBJ) {
X	if (g.place[obj] == -1) return;
X	g.place[obj] = -1;
X	++g.holding;
X  }
X}
X
X/*
X  Routine to drop an object
X*/
Xvoid drop(obj, where)
Xint obj, where;
X{
X  if (obj < MAXOBJ) {
X	if (g.place[obj] == -1) --g.holding;
X	g.place[obj] = where;
X  } else
X	g.fixed[obj - MAXOBJ] = where;
X}
X
X/*
X  routine to move an object and return a
X  value used to set the negated prop values
X  for the repository.
X*/
Xint put(obj, where, pval)
Xint obj, where, pval;
X{
X  move(obj, where);
X  return((-1) - pval);
X}
X
X/*
X  Routine to check for presence
X  of dwarves..
X*/
Xint dcheck()
X{
X  int i;
X
X  for (i = 1; i < (DWARFMAX - 1); ++i)
X	if (g.dloc[i] == g.loc) return(i);
X  return(0);
X}
X
X/*
X  Determine liquid in the bottle
X*/
Xint liq()
X{
X  int i, j;
X  i = g.prop[BOTTLE];
X  j = -1 - i;
X  return(liq2(i > j ? i : j));
X}
X
X/*
X  Determine liquid at a location
X*/
Xint liqloc(loc)
Xint loc;
X{
X  if (g.cond[loc] & LIQUID)
X	return(liq2(g.cond[loc] & WATOIL));
X  else
X	return(liq2(1));
X}
X
X/*
X  Convert  0 to WATER
X	 1 to nothing
X	 2 to OIL
X*/
Xint liq2(pbottle)
Xint pbottle;
X{
X  return((1 - pbottle) * WATER + (pbottle >> 1) * (WATER + OIL));
X}
X
X/*
X  Fatal error routine
X*/
Xvoid bug(n)
Xint n;
X{
X  printf("Fatal error number %d\n", n);
X  exit(1);
X}
/
echo x - english.c
sed '/^X/s///' > english.c << '/'
X
X/**	program ENGLISH.C					*
X *	WARNING: "advent.c" allocates GLOBAL storage space by	*
X *		including "advdef.h".				*
X *		All other modules use "advdec.h".		*/
X
X
X#include	<stdio.h>	/* drv = 1.1st file 2.def 3.A	 */
X#include	<ctype.h>
X#include	"advent.h"
X#include	"advdec.h"
X
X
X/*
X  Analyze a two word sentence
X*/
Xint english()
X{
X
X  char *msg;
X  int type1, type2, val1, val2;
X
X  verb = object = motion = 0;
X  type2 = val2 = -1;
X  type1 = val1 = -1;
X  msg = "bad grammar...";
X
X  getwords();
X
X  if (!(*word1)) return(0);	/* ignore whitespace	 */
X  if (!analyze(word1, &type1, &val1))	/* check word1	 */
X	return(0);		/* didn't know it	 */
X
X  if (type1 == 2 && val1 == SAY) {
X	verb = SAY;		/* repeat word & act upon if..	 */
X	object = 1;
X	return(1);
X  }
X  if (*word2)
X	if (!analyze(word2, &type2, &val2))
X		return(0);	/* didn't know it	 */
X
X  /* Check his grammar */
X  if ((type1 == 3) && (type2 == 3) &&
X      (val1 == 51) && (val2 == 51)) {
X	outwords();
X	return(0);
X  } else if (type1 == 3) {
X	rspeak(val1);
X	return(0);
X  } else if (type2 == 3) {
X	rspeak(val2);
X	return(0);
X  } else if (type1 == 0) {
X	if (type2 == 0) {
X		printf("%s\n", msg);
X		return(0);
X	} else
X		motion = val1;
X  } else if (type2 == 0)
X	motion = val2;
X  else if (type1 == 1) {
X	object = val1;
X	if (type2 == 2) verb = val2;
X	if (type2 == 1) {
X		printf("%s\n", msg);
X		return(0);
X	}
X  } else if (type1 == 2) {
X	verb = val1;
X	if (type2 == 1) object = val2;
X	if (type2 == 2) {
X		printf("%s\n", msg);
X		return(0);
X	}
X  } else
X	bug(36);
X  return(1);
X}
X
X
X/*
X	Routine to analyze a word.
X*/
Xint analyze(word, type, value)
Xchar *word;
Xint *type, *value;
X{
X  int wordval, msg;
X
X  /* Make sure I understand */
X  if ((wordval = vocab(word, 0)) == -1) {
X	switch (rand() % 3) {
X	    case 0:	msg = 60;	break;
X	    case 1:	msg = 61;	break;
X	    default:	msg = 13;
X	}
X	rspeak(msg);
X	return(0);
X  }
X  *type = wordval / 1000;
X  *value = wordval % 1000;
X  return(1);
X}
X
X/*
X  retrieve input line (max 80 chars), convert to lower case
X   & rescan for first two words (max. WORDSIZE-1 chars).
X*/
Xvoid getwords()
X{
X  char words[80], *wptr;
X
X  fprintf(stdout, "\n> ");
X  word1[0] = word2[0] = '\0';
X  fgets(words, 80, stdin);
X  wptr = words;
X  while (*wptr = tolower(*wptr)) ++wptr;
X  sscanf(words, "%19s %19s", word1, word2);
X  if (g.dbugflg) printf("WORD1 = %s, WORD2 = %s\n", word1, word2);
X  return;
X}
X
X/*
X  output adventure word list (motion/0xxx & verb/2xxx) only
X  6 words/line pausing at 20th line until keyboard active
X*/
Xvoid outwords()
X{
X  int i, j, line;
X  char words[80];
X
X  j = line = 0;
X  for (i = 0; i < MAXWC; ++i) {
X	if ((wc[i].acode < 1000) || ((wc[i].acode < 3000) &&
X				     (wc[i].acode > 1999))) {
X		printf("%-12s", wc[i].aword);
X		if ((++j == 6) || (i == MAXWC - 1)) {
X			j = 0;
X			fputc('\n', stdout);
X			if (++line == 20) {
X				line = 0;
X				printf("\n\007Enter <RETURN>");
X				printf(" to continue\n\n");
X				fgets(words, 80, stdin);
X			}
X		}
X	}
X  }
X}
/
echo x - itverb.c
sed '/^X/s///' > itverb.c << '/'
X
X/*	program ITVERB.C					*
X *	WARNING: "advent.c" allocates GLOBAL storage space by	*
X *		including "advdef.h".				*
X *		All other modules use "advdec.h".		*/
X
X
X#include	"stdio.h"	/* drv = 1.1st file 2.def 3.A	 */
X#include	"advent.h"
X#include	"advdec.h"
X
X
X/*
X  Routines to process intransitive verbs
X*/
Xvoid itverb()
X{
X  switch (verb) {
X      case DROP:
X      case SAY:
X      case WAVE:
X      case CALM:
X      case RUB:
X      case THROW:
X      case FIND:
X      case FEED:
X      case BREAK:
X      case WAKE:	needobj();	break;
X      case TAKE:	ivtake();	break;
X      case OPEN:
X      case LOCK:	ivopen();	break;
X      case NOTHING:	rspeak(54);	break;
X      case ON:
X      case OFF:
X      case POUR:	trverb();	break;
X      case WALK:	actspk(verb);	break;
X      case KILL:	ivkill();	break;
X	/* Case EAT: iveat(); break; */
X      case DRINK:	ivdrink();	break;
X      case QUIT:	ivquit();	break;
X	/* Case FILL: ivfill(); break; */
X      case BLAST:	vblast();	break;
X      case SCORE:	score();	break;
X      case FOO:	ivfoo();	break;
X      case SUSPEND:	g.saveflg = 1;	break;
X      case INVENTORY:	inventory();	break;
X      default:
X	printf("This intransitive not implemented yet\n");
X  }
X}
X
X/*
X  CARRY, TAKE etc.
X*/
Xvoid ivtake()
X{
X  int anobj, item;
X
X  anobj = 0;
X  for (item = 1; item < MAXOBJ; ++item) {
X	if (g.place[item] == g.loc) {
X		if (anobj != 0) {
X			needobj();
X			return;
X		}
X		anobj = item;
X	}
X  }
X  if (anobj == 0 || (dcheck() && g.dflag >= 2)) {
X	needobj();
X	return;
X  }
X  object = anobj;
X  vtake();
X}
X
X/*
X  OPEN, LOCK, UNLOCK
X*/
Xvoid ivopen()
X{
X  if (here(CLAM)) object = CLAM;
X  if (here(OYSTER)) object = OYSTER;
X  if (at(DOOR)) object = DOOR;
X  if (at(GRATE)) object = GRATE;
X  if (here(CHAIN)) {
X	if (object != 0) {
X		needobj();
X		return;
X	}
X	object = CHAIN;
X  }
X  if (object == 0) {
X	rspeak(28);
X	return;
X  }
X  vopen();
X}
X
X/*
X  ATTACK, KILL etc
X*/
Xvoid ivkill()
X{
X  g.object1 = 0;
X  if (dcheck() && g.dflag >= 2) object = DWARF;
X  if (here(SNAKE)) addobj(SNAKE);
X  if (at(DRAGON) && g.prop[DRAGON] == 0) addobj(DRAGON);
X  if (at(TROLL)) addobj(TROLL);
X  if (here(BEAR) && g.prop[BEAR] == 0) addobj(BEAR);
X  if (g.object1 != 0) {
X	needobj();
X	return;
X  }
X  if (object != 0) {
X	vkill();
X	return;
X  }
X  if (here(BIRD) && verb != THROW) object = BIRD;
X  if (here(CLAM) || here(OYSTER)) addobj(CLAM);
X  if (g.object1 != 0) {
X	needobj();
X	return;
X  }
X  vkill();
X}
X
X/*
X  EAT
X*/
X/*  no more room...
Xvoid iveat()
X{
X  if(!here(FOOD))
X	needobj();
X  else {
X	object=FOOD;
X	veat();
X  }
X}
X*/
X
X/*
X  DRINK
X*/
Xvoid ivdrink()
X{
X  if (liqloc(g.loc) != WATER &&
X      (liq() != WATER || !here(BOTTLE)))
X	needobj();
X  else {
X	object = WATER;
X	vdrink();
X  }
X}
X
X/*
X  QUIT
X*/
Xvoid ivquit()
X{
X  if (g.gaveup = yes(22, 54, 54)) normend();
X}
X
X/*
X  FILL
X*/
X/*  no room...
Xvoid ivfill()
X{
X  if(!here(BOTTLE))
X	needobj();
X  else {
X	object=BOTTLE;
X	vfill();
X  }
X}
X*/
X
X/*
X  Handle fee fie foe foo...
X*/
Xvoid ivfoo()
X{
X  char k;
X  int msg;
X
X  k = vocab(word1, 3000);
X  msg = 42;
X  if (g.foobar != 1 - k) {
X	if (g.foobar != 0) msg = 151;
X	rspeak(msg);
X	return;
X  }
X  g.foobar = k;
X  if (k != 4) return;
X  g.foobar = 0;
X  if (g.place[EGGS] == 92 ||
X      (toting(EGGS) && g.loc == 92)) {
X	rspeak(msg);
X	return;
X  }
X  if (g.place[EGGS] == 0 && g.place[TROLL] == 0 &&
X      g.prop[TROLL] == 0)
X	g.prop[TROLL] = 1;
X  if (here(EGGS))
X	k = 1;
X  else if (g.loc == 92)
X	k = 0;
X  else
X	k = 2;
X  move(EGGS, 92);
X  pspeak(EGGS, k);
X  return;
X}
X
X/*
X  read etc...
X*/
X/*  no room for this...
Xvoid ivread()
X{
X  if (here(MAGAZINE)) object = MAGAZINE;
X  if (here(TABLET)) object = object*100 + TABLET;
X  if (here(MESSAGE)) object = object*100 + MESSAGE;
X  if (object > 100 || object == 0 || dark()) {
X	needobj();
X	return;
X  }
X  vread();
X}
X*/
X
X/*
X  INVENTORY
X*/
Xvoid inventory()
X{
X  int msg, i;
X
X  msg = 98;
X  for (i = 1; i <= MAXOBJ; ++i) {
X	if (i == BEAR || !toting(i)) continue;
X	if (msg) rspeak(99);
X	msg = 0;
X	pspeak(i, -1);
X  }
X  if (toting(BEAR)) msg = 141;
X  if (msg) rspeak(msg);
X}
X
X/*
X  ensure uniqueness as objects are searched
X  out for an intransitive verb
X*/
Xvoid addobj(obj)
Xint obj;
X{
X  if (g.object1 != 0) return;
X  if (object != 0) {
X	g.object1 = -1;
X	return;
X  }
X  object = obj;
X}
/
echo x - turn.c
sed '/^X/s///' > turn.c << '/'
X
X/*	program TURN.C						*
X *	WARNING: "advent.c" allocates GLOBAL storage space by	*
X *		including "advdef.h".				*
X *		All other modules use "advdec.h".		*/
X
X
X#include	"stdio.h"
X#include	"advent.h"
X#include	"advdec.h"
X
X_PROTOTYPE (void exit, (int status));
X
X/*
X  Routine to take 1 turn
X*/
Xvoid turn()
X{
X  int i;
X  /* If closing, then he can't leave except via the main office. */
X  if (g.newloc < 9 && g.newloc != 0 && g.closing) {
X	rspeak(130);
X	g.newloc = g.loc;
X	if (!g.panic) g.clock2 = 15;
X	g.panic = 1;
X  }
X
X  /* See if a dwarf has seen him and has come from where he wants to go. */
X  if (g.newloc != g.loc && !forced(g.loc) && g.cond[g.loc] & NOPIRAT == 0)
X	for (i = 1; i < (DWARFMAX - 1); ++i)
X		if (g.odloc[i] == g.newloc && g.dseen[i]) {
X			g.newloc = g.loc;
X			rspeak(2);
X			break;
X		}
X  dwarves();			/* & special dwarf(pirate who steals)	 */
X
X  /* Added by BDS C conversion */
X  if (g.loc != g.newloc) {
X	++g.turns;
X	g.loc = g.newloc;
X/*	causes occasional "move" with two describe & descitem	*/
X	/*		}	*//* if (loc != newloc)	 */
X
X	/* Check for death */
X	if (g.loc == 0) {
X		death();
X		return;
X	}
X
X	/* Check for forced move */
X	if (forced(g.loc)) {
X		describe();
X		domove();
X		return;
X	}
X
X	/* Check for wandering in dark */
X	if (g.wzdark && dark() && pct(35)) {
X		rspeak(23);
X		g.oldloc2 = g.loc;
X		death();
X		return;
X	}
X
X	/* Describe his situation */
X	describe();
X	if (!dark()) {
X		++g.visited[g.loc];
X		descitem();
X	}
X
X/*	causes occasional "move" with no describe & descitem	*/
X  }				/* if (loc != newloc)	 */
X  if (g.closed) {
X	if (g.prop[OYSTER] < 0 && toting(OYSTER)) pspeak(OYSTER, 1);
X	for (i = 1; i <= MAXOBJ; ++i)
X		if (toting(i) && g.prop[i] < 0) g.prop[i] = -1 - g.prop[i];
X  }
X  g.wzdark = dark();
X  if (g.knfloc > 0 && g.knfloc != g.loc) g.knfloc = 0;
X
X  if (stimer())			/* as the grains of sand slip by	 */
X	return;
X
X  while (!english())		/* retrieve player instructions	 */
X	;
X
X  if (g.dbugflg) printf("loc = %d, verb = %d, object = %d, \
X	motion = %d\n", g.loc, verb, object, motion);
X
X  if (motion)			/* execute player instructions	 */
X	domove();
X  else if (object)
X	doobj();
X  else
X	itverb();
X}
X
X/*
X  Routine to describe current location
X*/
Xvoid describe()
X{
X  if (toting(BEAR)) rspeak(141);
X  if (dark())
X	rspeak(16);
X  else if (g.visited[g.loc])
X	descsh(g.loc);
X  else
X	desclg(g.loc);
X  if (g.loc == 33 && pct(25) && !g.closing) rspeak(8);
X}
X
X/*
X  Routine to describe visible items
X*/
Xvoid descitem()
X{
X  int i, state;
X
X  for (i = 1; i < MAXOBJ; ++i) {
X	if (at(i)) {
X		if (i == STEPS && toting(NUGGET)) continue;
X		if (g.prop[i] < 0) {
X			if (g.closed)
X				continue;
X			else {
X				g.prop[i] = 0;
X				if (i == RUG || i == CHAIN) ++g.prop[i];
X				--g.tally;
X			}
X		}
X		if (i == STEPS && g.loc == g.fixed[STEPS])
X			state = 1;
X		else
X			state = g.prop[i];
X		pspeak(i, state);
X	}
X  }
X  if (g.tally == g.tally2 && g.tally != 0 && g.limit > 35) g.limit = 35;
X}
X
X/*
X  Routine to handle motion requests
X*/
Xvoid domove()
X{
X  gettrav(g.loc);
X  switch (motion) {
X      case NULLX:
X	break;
X      case BACK:	goback();	break;
X      case LOOK:
X	if (g.detail++ < 3) rspeak(15);
X	g.wzdark = 0;
X	g.visited[g.loc] = 0;
X	g.newloc = g.loc;
X	g.loc = 0;
X	break;
X      case CAVE:
X	if (g.loc < 8)
X		rspeak(57);
X	else
X		rspeak(58);
X	break;
X      default:
X	g.oldloc2 = g.oldloc;
X	g.oldloc = g.loc;
X	dotrav();
X  }
X}
X
X/*
X  Routine to handle request to return
X  from whence we came!
X*/
Xvoid goback()
X{
X  int kk, k2, want, temp;
X  struct trav strav[MAXTRAV];
X
X  if (forced(g.oldloc))
X	want = g.oldloc2;
X  else
X	want = g.oldloc;
X  g.oldloc2 = g.oldloc;
X  g.oldloc = g.loc;
X  k2 = 0;
X  if (want == g.loc) {
X	rspeak(91);
X	return;
X  }
X  copytrv(travel, strav);
X  for (kk = 0; travel[kk].tdest != -1; ++kk) {
X	if (!travel[kk].tcond && travel[kk].tdest == want) {
X		motion = travel[kk].tverb;
X		dotrav();
X		return;
X	}
X	if (!travel[kk].tcond) {
X		k2 = kk;
X		temp = travel[kk].tdest;
X		gettrav(temp);
X		if (forced(temp) && travel[0].tdest == want) k2 = temp;
X		copytrv(strav, travel);
X	}
X  }
X  if (k2) {
X	motion = travel[k2].tverb;
X	dotrav();
X  } else
X	rspeak(140);
X}
X
X/*
X  Routine to copy a travel array
X*/
Xvoid copytrv(trav1, trav2)
Xstruct trav *trav1, *trav2;
X{
X  int i;
X
X  for (i = 0; i < MAXTRAV; ++i) {
X	trav2->tdest = trav1->tdest;
X	trav2->tverb = trav1->tverb;
X	trav2->tcond = trav1->tcond;
X  }
X}
X
X/*
X  Routine to figure out a new location
X  given current location and a motion.
X*/
Xvoid dotrav()
X{
X  char mvflag, hitflag;
X  int kk;
X  int rdest, rverb, rcond, robject;
X  int pctt;
X
X  g.newloc = g.loc;
X  mvflag = hitflag = 0;
X  pctt = rand() % 100;
X
X  for (kk = 0; travel[kk].tdest >= 0 && !mvflag; ++kk) {
X	rdest = travel[kk].tdest;
X	rverb = travel[kk].tverb;
X	rcond = travel[kk].tcond;
X	robject = rcond % 100;
X
X	if (g.dbugflg) printf("rdest = %d, rverb = %d, rcond = %d, \
X		robject = %d in dotrav\n", rdest, rverb,
X		       rcond, robject);
X	if ((rverb != 1) && (rverb != motion) && !hitflag) continue;
X	++hitflag;
X	switch (rcond / 100) {
X	    case 0:
X		if ((rcond == 0) || (pctt < rcond)) ++mvflag;
X		if (rcond && g.dbugflg) printf("%% move %d %d\n",
X			       pctt, mvflag);
X		break;
X	    case 1:
X		if (robject == 0)
X			++mvflag;
X		else if (toting(robject))
X			++mvflag;
X		break;
X	    case 2:
X		if (toting(robject) || at(robject)) ++mvflag;
X		break;
X	    case 3:
X	    case 4:
X	    case 5:
X	    case 7:
X		if (g.prop[robject] != (rcond / 100) - 3) ++mvflag;
X		break;
X	    default:	bug(37);
X	}
X  }
X  if (!mvflag)
X	badmove();
X  else if (rdest > 500)
X	rspeak(rdest - 500);
X  else if (rdest > 300)
X	spcmove(rdest);
X  else {
X	g.newloc = rdest;
X	if (g.dbugflg) printf("newloc in dotrav = %d\n", g.newloc);
X  }
X}
X
X/*
X  The player tried a poor move option.
X*/
Xvoid badmove()
X{
X  int msg;
X
X  msg = 12;
X  if (motion >= 43 && motion <= 50) msg = 9;
X  if (motion == 29 || motion == 30) msg = 9;
X  if (motion == 7 || motion == 36 || motion == 37) msg = 10;
X  if (motion == 11 || motion == 19) msg = 11;
X  if (verb == FIND || verb == INVENTORY) msg = 59;
X  if (motion == 62 || motion == 65) msg = 42;
X  if (motion == 17) msg = 80;
X  rspeak(msg);
X}
X
X/*
X  Routine to handle very special movement.
X*/
Xvoid spcmove(rdest)
Xint rdest;
X{
X  switch (rdest - 300) {
X      case 1:			/* plover movement via alcove */
X	if (!g.holding || (g.holding == 1 && toting(EMERALD)))
X		g.newloc = (99 + 100) - g.loc;
X	else
X		rspeak(117);
X	break;
X      case 2:			/* trying to remove plover, bad route */
X	drop(EMERALD, g.loc);
X	break;
X      case 3:			/* troll bridge */
X	if (g.prop[TROLL] == 1) {
X		pspeak(TROLL, 1);
X		g.prop[TROLL] = 0;
X		move(TROLL2, 0);
X		move((TROLL2 + MAXOBJ), 0);
X		move(TROLL, 117);
X		move((TROLL + MAXOBJ), 122);
X		juggle(CHASM);
X		g.newloc = g.loc;
X	} else {
X		g.newloc = (g.loc == 117 ? 122 : 117);
X		if (g.prop[TROLL] == 0) ++g.prop[TROLL];
X		if (!toting(BEAR)) return;
X		rspeak(162);
X		g.prop[CHASM] = 1;
X		g.prop[TROLL] = 2;
X		drop(BEAR, g.newloc);
X		g.fixed[BEAR] = -1;
X		g.prop[BEAR] = 3;
X		if (g.prop[SPICES] < 0) ++g.tally2;
X		g.oldloc2 = g.newloc;
X		death();
X	}
X	break;
X      default:	bug(38);
X}
X}
X
X
X/*
X  Routine to handle player's demise via
X  waking up the dwarves...
X*/
Xvoid dwarfend()
X{
X  death();
X  normend();
X}
X
X/*
X  normal end of game
X*/
Xvoid normend()
X{
X  score();
X  exit(1);
X}
X
X/*
X  scoring
X*/
Xvoid score()
X{
X  int t, i, k, s;
X  s = 0;
X  for (i = 50; i <= MAXTRS; ++i) {
X	if (i == CHEST)
X		k = 14;
X	else if (i > CHEST)
X		k = 16;
X	else
X		k = 12;
X	if (g.prop[i] >= 0) s += 2;
X	if (g.place[i] == 3 && g.prop[i] == 0) s += k - 2;
X  }
X  printf("%-20s%d\n", "Treasures found:", 15 - g.tally);
X  s -= g.numdie * 10;
X  if (g.numdie) printf("%-20s%d\n", "Deaths:", g.numdie);
X  if (g.gaveup) s -= 4;
X  t = g.dflag ? 25 : 0;
X  s += t;
X  t = g.closing ? 25 : 0;
X  if (t) printf("%-20s%d\n", "Masters section:", t);
X  s += t;
X  if (g.closed) {
X	if (g.bonus == 0)
X		t = 10;
X	else if (g.bonus == 135)
X		t = 25;
X	else if (g.bonus == 134)
X		t = 30;
X	else if (g.bonus == 133)
X		t = 45;
X	printf("%-20s%d\n", "Bonus:", t);
X	s += t;
X  }
X  if (g.place[MAGAZINE] == 108) s += 1;
X  printf("%-20s%d\n", "Score:", s);
X}
X
X/*
X  Routine to handle the passing on of one
X  of the player's incarnations...
X*/
Xvoid death()
X{
X  char yea, i, j;
X
X  if (!g.closing) {
X	yea = yes(81 + g.numdie * 2, 82 + g.numdie * 2, 54);
X	if (++g.numdie >= MAXDIE || !yea) normend();
X	g.place[WATER] = 0;
X	g.place[OIL] = 0;
X	if (toting(LAMP)) g.prop[LAMP] = 0;
X	for (j = 1; j < 101; ++j) {
X		i = 101 - j;
X		if (toting(i)) drop(i, i == LAMP ? 1 : g.oldloc2);
X	}
X	g.newloc = 3;
X	g.oldloc = g.loc;
X	return;
X  }
X
X  /* Closing -- no resurrection... */
X  rspeak(131);
X  ++g.numdie;
X  normend();
X}
X
X/*
X  Routine to print word corresponding to object
X*/
Xchar *
Xprobj(object)
Xint object;
X{
X  int wtype, wval;
X  analyze(word1, &wtype, &wval);
X  return(wtype == 1 ? word1 : word2);
X}
X
X/*
X  Routine to process an object.
X*/
Xvoid doobj()
X{
X  /* Is object here?  if so, transitive */
X  if (g.fixed[object] == g.loc || here(object)) trobj();
X  /* Did he give grate as destination? */
X  else if (object == GRATE) {
X	if (g.loc == 1 || g.loc == 4 || g.loc == 7) {
X		motion = DEPRESSION;
X		domove();
X	} else if (g.loc > 9 && g.loc < 15) {
X		motion = ENTRANCE;
X		domove();
X	}
X  }
X
X  /* Is it a dwarf he is after? */
X  else if (dcheck() && g.dflag >= 2) {
X	object = DWARF;
X	trobj();
X  }
X
X  /* Is he trying to get/use a liquid? */
X  else if ((liq() == object && here(BOTTLE)) ||
X	 liqloc(g.loc) == object)
X	trobj();
X  else if (object == PLANT && at(PLANT2) &&
X	 g.prop[PLANT2] == 0) {
X	object = PLANT2;
X	trobj();
X  }
X
X  /* Is he trying to grab a knife? */
X  else if (object == KNIFE && g.knfloc == g.loc) {
X	rspeak(116);
X	g.knfloc = -1;
X  }
X
X  /* Is he trying to get at dynamite? */
X  else if (object == ROD && here(ROD2)) {
X	object = ROD2;
X	trobj();
X  } else
X	printf("I see no %s here.\n", probj(object));
X}
X
X/*
X  Routine to process an object being
X  referred to.
X*/
Xvoid trobj()
X{
X  if (verb)
X	trverb();
X  else
X	printf("What do you want to do with the %s?\n",
X	       probj(object));
X}
X
X/*
X  dwarf stuff.
X*/
Xvoid dwarves()
X{
X  int i, j, k, try, attack, stick, dtotal;
X  /* See if dwarves allowed here */
X  if (g.newloc == 0 || forced(g.newloc) || g.cond[g.newloc] & NOPIRAT)
X	return;
X  /* See if dwarves are active. */
X  if (!g.dflag) {
X	if (g.newloc > 15) ++g.dflag;
X	return;
X  }
X
X  /* If first close encounter (of 3rd kind) kill 0, 1 or 2 */
X  if (g.dflag == 1) {
X	if (g.newloc < 15 || pct(95)) return;
X	++g.dflag;
X	for (i = 1; i < 3; ++i)
X		if (pct(50)) g.dloc[rand() % 5 + 1] = 0;
X	for (i = 1; i < (DWARFMAX - 1); ++i) {
X		if (g.dloc[i] == g.newloc) g.dloc[i] = g.daltloc;
X		g.odloc[i] = g.dloc[i];
X	}
X	rspeak(3);
X	drop(AXE, g.newloc);
X	return;
X  }
X  dtotal = attack = stick = 0;
X  for (i = 1; i < DWARFMAX; ++i) {
X	if (g.dloc[i] == 0) continue;
X	/* Move a dwarf at random.  we don't have a matrix around to
X	 * do it as in the original version... */
X	for (try = 1; try < 20; ++try) {
X		j = rand() % 106 + 15;	/* allowed area */
X		if (j != g.odloc[i] && j != g.dloc[i] &&
X		 !(i == (DWARFMAX - 1) && g.cond[j] & NOPIRAT == 1))
X			break;
X	}
X	if (j == 0) j = g.odloc[i];
X	g.odloc[i] = g.dloc[i];
X	g.dloc[i] = j;
X	if ((g.dseen[i] && g.newloc >= 15) ||
X	    g.dloc[i] == g.newloc || g.odloc[i] == g.newloc)
X		g.dseen[i] = 1;
X	else
X		g.dseen[i] = 0;
X	if (!g.dseen[i]) continue;
X	g.dloc[i] = g.newloc;
X	if (i == 6)
X		dopirate();
X	else {
X		++dtotal;
X		if (g.odloc[i] == g.dloc[i]) {
X			++attack;
X			if (g.knfloc >= 0) g.knfloc = g.newloc;
X			if (rand() % 1000 < 45 * (g.dflag - 2)) ++stick;
X		}
X	}
X  }
X  if (dtotal == 0) return;
X  if (dtotal > 1)
X	printf("There are %d threatening little dwarves in the room with you!\n", dtotal);
X  else
X	rspeak(4);
X  if (attack == 0) return;
X  if (g.dflag == 2) ++g.dflag;
X  if (attack > 1) {
X	printf("%d of them throw knives at you!!\n", attack);
X	k = 6;
X  } else {
X	rspeak(5);
X	k = 52;
X  }
X  if (stick <= 1) {
X	rspeak(stick + k);
X	if (stick == 0) return;
X  } else
X	printf("%d of them get you !!!\n", stick);
X  g.oldloc2 = g.newloc;
X  death();
X}
X
X/*
X  pirate stuff
X*/
Xvoid dopirate()
X{
X  int j, k;
X  if (g.newloc == g.chloc || g.prop[CHEST] >= 0) return;
X  k = 0;
X  for (j = 50; j <= MAXTRS; ++j)
X	if (j != PYRAMID ||
X	    (g.newloc != g.place[PYRAMID] &&
X	     g.newloc != g.place[EMERALD])) {
X		if (toting(j)) goto stealit;
X		if (here(j)) ++k;
X	}
X  if (g.tally == g.tally2 + 1 && k == 0 && g.place[CHEST] == 0 &&
X      here(LAMP) && g.prop[LAMP] == 1) {
X	rspeak(186);
X	move(CHEST, g.chloc);
X	move(MESSAGE, g.chloc2);
X	g.dloc[6] = g.chloc;
X	g.odloc[6] = g.chloc;
X	g.dseen[6] = 0;
X	return;
X  }
X  if (g.odloc[6] != g.dloc[6] && pct(20)) {
X	rspeak(127);
X	return;
X  }
X  return;
X
Xstealit:
X
X  rspeak(128);
X  if (g.place[MESSAGE] == 0) move(CHEST, g.chloc);
X  move(MESSAGE, g.chloc2);
X  for (j = 50; j <= MAXTRS; ++j) {
X	if (j == PYRAMID &&
X	    (g.newloc == g.place[PYRAMID] ||
X	     g.newloc == g.place[EMERALD]))
X		continue;
X	if (at(j) && g.fixed[j] == 0) carry(j, g.newloc);
X	if (toting(j)) drop(j, g.chloc);
X  }
X  g.dloc[6] = g.chloc;
X  g.odloc[6] = g.chloc;
X  g.dseen[6] = 0;
X}
X
X/*
X  special time limit stuff...
X*/
Xint stimer()
X{
X  int i;
X  g.foobar = g.foobar > 0 ? -g.foobar : 0;
X  if (g.tally == 0 && g.loc >= 15 && g.loc != 33) --g.clock;
X  if (g.clock == 0) {
X	/* Start closing the cave */
X	g.prop[GRATE] = 0;
X	g.prop[FISSURE] = 0;
X	for (i = 1; i < DWARFMAX; ++i) g.dseen[i] = 0;
X	move(TROLL, 0);
X	move((TROLL + MAXOBJ), 0);
X	move(TROLL2, 117);
X	move((TROLL2 + MAXOBJ), 122);
X	juggle(CHASM);
X	if (g.prop[BEAR] != 3) dstroy(BEAR);
X	g.prop[CHAIN] = 0;
X	g.fixed[CHAIN] = 0;
X	g.prop[AXE] = 0;
X	g.fixed[AXE] = 0;
X	rspeak(129);
X	g.clock = -1;
X	g.closing = 1;
X	return(0);
X  }
X  if (g.clock < 0) --g.clock2;
X  if (g.clock2 == 0) {
X	/* Set up storage room... and close the cave... */
X	g.prop[BOTTLE] = put(BOTTLE, 115, 1);
X	g.prop[PLANT] = put(PLANT, 115, 0);
X	g.prop[OYSTER] = put(OYSTER, 115, 0);
X	g.prop[LAMP] = put(LAMP, 115, 0);
X	g.prop[ROD] = put(ROD, 115, 0);
X	g.prop[DWARF] = put(DWARF, 115, 0);
X	g.loc = 115;
X	g.oldloc = 115;
X	g.newloc = 115;
X	put(GRATE, 116, 0);
X	g.prop[SNAKE] = put(SNAKE, 116, 1);
X	g.prop[BIRD] = put(BIRD, 116, 1);
X	g.prop[CAGE] = put(CAGE, 116, 0);
X	g.prop[ROD2] = put(ROD2, 116, 0);
X	g.prop[PILLOW] = put(PILLOW, 116, 0);
X	g.prop[MIRROR] = put(MIRROR, 115, 0);
X	g.fixed[MIRROR] = 116;
X	for (i = 1; i <= MAXOBJ; ++i)
X		if (toting(i)) dstroy(i);
X	rspeak(132);
X	g.closed = 1;
X	return(1);
X  }
X  if (g.prop[LAMP] == 1) --g.limit;
X  if (g.limit <= 30 &&
X      here(BATTERIES) && g.prop[BATTERIES] == 0 &&
X      here(LAMP)) {
X	rspeak(188);
X	g.prop[BATTERIES] = 1;
X	if (toting(BATTERIES)) drop(BATTERIES, g.loc);
X	g.limit += 2500;
X	g.lmwarn = 0;
X	return(0);
X  }
X  if (g.limit == 0) {
X	--g.limit;
X	g.prop[LAMP] = 0;
X	if (here(LAMP)) rspeak(184);
X	return(0);
X  }
X  if (g.limit < 0 && g.loc <= 8) {
X	rspeak(185);
X	g.gaveup = 1;
X	normend();
X  }
X  if (g.limit <= 30) {
X	if (g.lmwarn || !here(LAMP)) return(0);
X	g.lmwarn = 1;
X	i = 187;
X	if (g.place[BATTERIES] == 0) i = 183;
X	if (g.prop[BATTERIES] == 1) i = 189;
X	rspeak(i);
X	return(0);
X  }
X  return(0);
X}
X
X/*
X  random number seed
X*/
Xstatic long rnum = 0;
X
Xvoid srand(n)
Xshort n;
X{
X  rnum = (long) n;
X}
X
X/*
X  random number
X*/
Xint rand()
X{
X  rnum = rnum * 0x41C64E6D + 0x3039;
X  return((short) (rnum >> 16) & 0x7FFF);
X}
/
echo x - verb.c
sed '/^X/s///' > verb.c << '/'
X
X/**	program VERB.C						*
X *	WARNING: "advent.c" allocates GLOBAL storage space by	*
X *		including "advdef.h".				*
X *		All other modules use "advdec.h".		*/
X
X
X#include	"stdio.h"
X#include	"advent.h"
X#include	"advdec.h"
X
X
X/*
X  Routine to process a transitive verb
X*/
Xvoid trverb()
X{
X  switch (verb) {
X      case CALM:
X      case WALK:
X      case QUIT:
X      case SCORE:
X      case FOO:
X      case BRIEF:
X      case SUSPEND:
X      case HOURS:
X      case LOG:	actspk(verb);	break;
X      case TAKE:	vtake();	break;
X      case DROP:	vdrop();	break;
X      case OPEN:
X      case LOCK:	vopen();	break;
X      case SAY:	vsay();	break;
X      case NOTHING:	rspeak(54);	break;
X      case ON:	von();	break;
X      case OFF:	voff();	break;
X      case WAVE:	vwave();	break;
X      case KILL:	vkill();	break;
X      case POUR:	vpour();	break;
X      case EAT:	veat();	break;
X      case DRINK:	vdrink();	break;
X      case RUB:
X	if (object != LAMP)
X		rspeak(76);
X	else
X		actspk(RUB);
X	break;
X      case THROW:	vthrow();	break;
X      case FEED:	vfeed();	break;
X      case FIND:
X      case INVENTORY:	vfind();	break;
X      case FILL:	vfill();	break;
X      case READ:	vread();	break;
X      case BLAST:	vblast();	break;
X      case BREAK:	vbreak();	break;
X      case WAKE:	vwake();	break;
X      default:
X	printf("This verb is not implemented yet.\n");
X  }
X}
X
X/*
X  CARRY TAKE etc.
X*/
Xvoid vtake()
X{
X  int msg, i;
X
X  if (toting(object)) {
X	actspk(verb);
X	return;
X  }
X
X  /* Special case objects and fixed objects */
X  msg = 25;
X  if (object == PLANT && g.prop[PLANT] <= 0) msg = 115;
X  if (object == BEAR && g.prop[BEAR] == 1) msg = 169;
X  if (object == CHAIN && g.prop[BEAR] != 0) msg = 170;
X  if (g.fixed[object]) {
X	rspeak(msg);
X	return;
X  }
X
X  /* Special case for liquids */
X  if (object == WATER || object == OIL) {
X	if (!here(BOTTLE) || liq() != object) {
X		object = BOTTLE;
X		if (toting(BOTTLE) && g.prop[BOTTLE] == 1) {
X			vfill();
X			return;
X		}
X		if (g.prop[BOTTLE] != 1) msg = 105;
X		if (!toting(BOTTLE)) msg = 104;
X		rspeak(msg);
X		return;
X	}
X	object = BOTTLE;
X  }
X  if (g.holding >= 7) {
X	rspeak(92);
X	return;
X  }
X
X  /* Special case for bird. */
X  if (object == BIRD && g.prop[BIRD] == 0) {
X	if (toting(ROD)) {
X		rspeak(26);
X		return;
X	}
X	if (!toting(CAGE)) {
X		rspeak(27);
X		return;
X	}
X	g.prop[BIRD] = 1;
X  }
X  if ((object == BIRD || object == CAGE) &&
X      g.prop[BIRD] != 0)
X	carry((BIRD + CAGE) - object, g.loc);
X  carry(object, g.loc);
X  /* Handle liquid in bottle */
X  i = liq();
X  if (object == BOTTLE && i != 0) g.place[i] = -1;
X  rspeak(54);
X}
X
X/*
X  DROP etc.
X*/
Xvoid vdrop()
X{
X  int i;
X
X  /* Check for dynamite */
X  if (toting(ROD2) && object == ROD && !toting(ROD)) object = ROD2;
X  if (!toting(object)) {
X	actspk(verb);
X	return;
X  }
X
X  /* Snake and bird */
X  if (object == BIRD && here(SNAKE)) {
X	rspeak(30);
X	if (g.closed) dwarfend();
X	dstroy(SNAKE);
X	g.prop[SNAKE] = -1;
X  }
X
X  /* Coins and vending machine */
X  else if (object == COINS && here(VEND)) {
X	dstroy(COINS);
X	drop(BATTERIES, g.loc);
X	pspeak(BATTERIES, 0);
X	return;
X  }
X
X  /* Bird and dragon (ouch!!) */
X  else if (object == BIRD && at(DRAGON) && g.prop[DRAGON] == 0) {
X	rspeak(154);
X	dstroy(BIRD);
X	g.prop[BIRD] = 0;
X	if (g.place[SNAKE] != 0) ++g.tally2;
X	return;
X  }
X
X  /* Bear and troll */
X  if (object == BEAR && at(TROLL)) {
X	rspeak(163);
X	move(TROLL, 0);
X	move((TROLL + MAXOBJ), 0);
X	move(TROLL2, 117);
X	move((TROLL2 + MAXOBJ), 122);
X	juggle(CHASM);
X	g.prop[TROLL] = 2;
X  }
X
X  /* Vase */
X  else if (object == VASE) {
X	if (g.loc == 96)
X		rspeak(54);
X	else {
X		g.prop[VASE] = at(PILLOW) ? 0 : 2;
X		pspeak(VASE, g.prop[VASE] + 1);
X		if (g.prop[VASE] != 0) g.fixed[VASE] = -1;
X	}
X  }
X
X  /* Handle liquid and bottle */
X  i = liq();
X  if (i == object) object = BOTTLE;
X  if (object == BOTTLE && i != 0) g.place[i] = 0;
X  /* Handle bird and cage */
X  if (object == CAGE && g.prop[BIRD] != 0) drop(BIRD, g.loc);
X  if (object == BIRD) g.prop[BIRD] = 0;
X  drop(object, g.loc);
X}
X
X/*
X  LOCK, UNLOCK, OPEN, CLOSE etc.
X*/
Xvoid vopen()
X{
X  int msg, oyclam;
X
X  switch (object) {
X      case CLAM:
X      case OYSTER:
X	oyclam = (object == OYSTER ? 1 : 0);
X	if (verb == LOCK)
X		msg = 61;
X	else if (!toting(TRIDENT))
X		msg = 122 + oyclam;
X	else if (toting(object))
X		msg = 120 + oyclam;
X	else {
X		msg = 124 + oyclam;
X		dstroy(CLAM);
X		drop(OYSTER, g.loc);
X		drop(PEARL, 105);
X	}
X	break;
X      case DOOR:
X	msg = (g.prop[DOOR] == 1 ? 54 : 111);
X	break;
X      case CAGE:	msg = 32;	break;
X      case KEYS:	msg = 55;	break;
X      case CHAIN:
X	if (!here(KEYS))
X		msg = 31;
X	else if (verb == LOCK) {
X		if (g.prop[CHAIN] != 0)
X			msg = 34;
X		else if (g.loc != 130)
X			msg = 173;
X		else {
X			g.prop[CHAIN] = 2;
X			if (toting(CHAIN)) drop(CHAIN, g.loc);
X			g.fixed[CHAIN] = -1;
X			msg = 172;
X		}
X	} else {
X		if (g.prop[BEAR] == 0)
X			msg = 41;
X		else if (g.prop[CHAIN] == 0)
X			msg = 37;
X		else {
X			g.prop[CHAIN] = 0;
X			g.fixed[CHAIN] = 0;
X			if (g.prop[BEAR] != 3) g.prop[BEAR] = 2;
X			g.fixed[BEAR] = 2 - g.prop[BEAR];
X			msg = 171;
X		}
X	}
X	break;
X      case GRATE:
X	if (!here(KEYS))
X		msg = 31;
X	else if (g.closing) {
X		if (!g.panic) {
X			g.clock2 = 15;
X			++g.panic;
X		}
X		msg = 130;
X	} else {
X		msg = 34 + g.prop[GRATE];
X		g.prop[GRATE] = (verb == LOCK ? 0 : 1);
X		msg += 2 * g.prop[GRATE];
X	}
X	break;
X      default:	msg = 33;
X}
X  rspeak(msg);
X}
X
X/*
X  SAY etc.
X*/
Xvoid vsay()
X{
X  int wtype, wval;
X
X  analyze(word1, &wtype, &wval);
X  printf("Okay.\n%s\n", wval == SAY ? word2 : word1);
X}
X
X/*
X  ON etc.
X*/
Xvoid von()
X{
X  if (!here(LAMP))
X	actspk(verb);
X  else if (g.limit < 0)
X	rspeak(184);
X  else {
X	g.prop[LAMP] = 1;
X	rspeak(39);
X	if (g.wzdark) {
X		g.wzdark = 0;
X		describe();
X	}
X  }
X}
X
X/*
X  OFF etc.
X*/
Xvoid voff()
X{
X  if (!here(LAMP))
X	actspk(verb);
X  else {
X	g.prop[LAMP] = 0;
X	rspeak(40);
X  }
X}
X
X/*
X  WAVE etc.
X*/
Xvoid vwave()
X{
X  if (!toting(object) &&
X      (object != ROD || !toting(ROD2)))
X	rspeak(29);
X  else if (object != ROD || !at(FISSURE) ||
X	 !toting(object) || g.closing)
X	actspk(verb);
X  else {
X	g.prop[FISSURE] = 1 - g.prop[FISSURE];
X	pspeak(FISSURE, 2 - g.prop[FISSURE]);
X  }
X}
X
X/*
X  ATTACK, KILL etc.
X*/
Xvoid vkill()
X{
X  int msg, i;
X
X  switch (object) {
X      case BIRD:
X	if (g.closed)
X		msg = 137;
X	else {
X		dstroy(BIRD);
X		g.prop[BIRD] = 0;
X		if (g.place[SNAKE] == 19) ++g.tally2;
X		msg = 45;
X	}
X	break;
X      case 0:	msg = 44;	break;
X      case CLAM:
X      case OYSTER:	msg = 150;	break;
X      case SNAKE:	msg = 46;	break;
X      case DWARF:
X	if (g.closed) dwarfend();
X	msg = 49;
X	break;
X      case TROLL:	msg = 157;	break;
X      case BEAR:
X	msg = 165 + (g.prop[BEAR] + 1) / 2;
X	break;
X      case DRAGON:
X	if (g.prop[DRAGON] != 0) {
X		msg = 167;
X		break;
X	}
X	if (!yes(49, 0, 0)) break;
X	pspeak(DRAGON, 1);
X	g.prop[DRAGON] = 2;
X	g.prop[RUG] = 0;
X	move((DRAGON + MAXOBJ), -1);
X	move((RUG + MAXOBJ), 0);
X	move(DRAGON, 120);
X	move(RUG, 120);
X	for (i = 1; i < MAXOBJ; ++i)
X		if (g.place[i] == 119 || g.place[i] == 121) move(i, 120);
X	g.newloc = 120;
X	return;
X      default:
X	actspk(verb);
X	return;
X  }
X  rspeak(msg);
X}
X
X/*
X  POUR
X*/
Xvoid vpour()
X{
X  if (object == BOTTLE || object == 0) object = liq();
X  if (object == 0) {
X	needobj();
X	return;
X  }
X  if (!toting(object)) {
X	actspk(verb);
X	return;
X  }
X  if (object != OIL && object != WATER) {
X	rspeak(78);
X	return;
X  }
X  g.prop[BOTTLE] = 1;
X  g.place[object] = 0;
X  if (at(PLANT)) {
X	if (object != WATER)
X		rspeak(112);
X	else {
X		pspeak(PLANT, g.prop[PLANT] + 1);
X		g.prop[PLANT] = (g.prop[PLANT] + 2) % 6;
X		g.prop[PLANT2] = g.prop[PLANT] / 2;
X		describe();
X	}
X  } else if (at(DOOR)) {
X	g.prop[DOOR] = (object == OIL ? 1 : 0);
X	rspeak(113 + g.prop[DOOR]);
X  } else
X	rspeak(77);
X}
X
X/*
X  EAT
X*/
Xvoid veat()
X{
X  int msg;
X
X  switch (object) {
X      case FOOD:
X	dstroy(FOOD);
X	msg = 72;
X	break;
X      case BIRD:
X      case SNAKE:
X      case CLAM:
X      case OYSTER:
X      case DWARF:
X      case DRAGON:
X      case TROLL:
X      case BEAR:	msg = 71;	break;
X      default:
X	actspk(verb);
X	return;
X  }
X  rspeak(msg);
X}
X
X/*
X  DRINK
X*/
Xvoid vdrink()
X{
X  if (object != WATER)
X	rspeak(110);
X  else if (liq() != WATER || !here(BOTTLE))
X	actspk(verb);
X  else {
X	g.prop[BOTTLE] = 1;
X	g.place[WATER] = 0;
X	rspeak(74);
X  }
X}
X
X/*
X  THROW etc.
X*/
Xvoid vthrow()
X{
X  int msg, i;
X
X  if (toting(ROD2) && object == ROD && !toting(ROD)) object = ROD2;
X  if (!toting(object)) {
X	actspk(verb);
X	return;
X  }
X
X  /* Treasure to troll */
X  if (at(TROLL) && object >= 50 && object < MAXOBJ) {
X	rspeak(159);
X	drop(object, 0);
X	move(TROLL, 0);
X	move((TROLL + MAXOBJ), 0);
X	drop(TROLL2, 117);
X	drop((TROLL2 + MAXOBJ), 122);
X	juggle(CHASM);
X	return;
X  }
X
X  /* Feed the bears... */
X  if (object == FOOD && here(BEAR)) {
X	object = BEAR;
X	vfeed();
X	return;
X  }
X
X  /* If not axe, same as drop... */
X  if (object != AXE) {
X	vdrop();
X	return;
X  }
X
X  /* AXE is THROWN */
X  /* At a dwarf... */
X  if (i = dcheck()) {
X	msg = 48;
X	if (pct(75)) {
X		g.dseen[i] = g.dloc[i] = 0;
X		msg = 47;
X		++g.dkill;
X		if (g.dkill == 1) msg = 149;
X	}
X  }
X
X  /* At a dragon... */
X  else if (at(DRAGON) && g.prop[DRAGON] == 0)
X	msg = 152;
X  /* At the troll... */
X  else if (at(TROLL))
X	msg = 158;
X  /* At the bear... */
X  else if (here(BEAR) && g.prop[BEAR] == 0) {
X	rspeak(164);
X	drop(AXE, g.loc);
X	g.fixed[AXE] = -1;
X	g.prop[AXE] = 1;
X	juggle(BEAR);
X	return;
X  }
X
X  /* Otherwise it is an attack */
X  else {
X	verb = KILL;
X	object = 0;
X	itverb();
X	return;
X  }
X
X  /* Handle the left over axe... */
X  rspeak(msg);
X  drop(AXE, g.loc);
X  describe();
X}
X
X/*
X  INVENTORY, FIND etc.
X*/
Xvoid vfind()
X{
X  int msg;
X  if (toting(object))
X	msg = 24;
X  else if (g.closed)
X	msg = 138;
X  else if (dcheck() && g.dflag >= 2 && object == DWARF)
X	msg = 94;
X  else if (at(object) ||
X	 (liq() == object && here(BOTTLE)) ||
X	 object == liqloc(g.loc))
X	msg = 94;
X  else {
X	actspk(verb);
X	return;
X  }
X  rspeak(msg);
X}
X
X/*
X  FILL
X*/
Xvoid vfill()
X{
X  int msg;
X  int i;
X
X  switch (object) {
X      case BOTTLE:
X	if (liq() != 0)
X		msg = 105;
X	else if (liqloc(g.loc) == 0)
X		msg = 106;
X	else {
X		g.prop[BOTTLE] = g.cond[g.loc] & WATOIL;
X		i = liq();
X		if (toting(BOTTLE)) g.place[i] = -1;
X		msg = (i == OIL ? 108 : 107);
X	}
X	break;
X      case VASE:
X	if (liqloc(g.loc) == 0) {
X		msg = 144;
X		break;
X	}
X	if (!toting(VASE)) {
X		msg = 29;
X		break;
X	}
X	rspeak(145);
X	vdrop();
X	return;
X      default:	msg = 29;
X}
X  rspeak(msg);
X}
X
X/*
X  FEED
X*/
Xvoid vfeed()
X{
X  int msg;
X
X  switch (object) {
X      case BIRD:	msg = 100;	break;
X      case DWARF:
X	if (!here(FOOD)) {
X		actspk(verb);
X		return;
X	}
X	++g.dflag;
X	msg = 103;
X	break;
X      case BEAR:
X	if (!here(FOOD)) {
X		if (g.prop[BEAR] == 0)
X			msg = 102;
X		else if (g.prop[BEAR] == 3)
X			msg = 110;
X		else {
X			actspk(verb);
X			return;
X		}
X		break;
X	}
X	dstroy(FOOD);
X	g.prop[BEAR] = 1;
X	g.fixed[AXE] = 0;
X	g.prop[AXE] = 0;
X	msg = 168;
X	break;
X      case DRAGON:
X	msg = (g.prop[DRAGON] != 0 ? 110 : 102);
X	break;
X      case TROLL:	msg = 182;	break;
X      case SNAKE:
X	if (g.closed || !here(BIRD)) {
X		msg = 102;
X		break;
X	}
X	msg = 101;
X	dstroy(BIRD);
X	g.prop[BIRD] = 0;
X	++g.tally2;
X	break;
X      default:	msg = 14;
X}
X  rspeak(msg);
X}
X
X/*
X  READ etc.
X*/
Xvoid vread()
X{
X  int msg;
X
X  msg = 0;
X  if (dark()) {
X	printf("I see no %s here.\n", probj(object));
X	return;
X  }
X  switch (object) {
X      case MAGAZINE:	msg = 190;	break;
X      case TABLET:	msg = 196;	break;
X      case MESSAGE:	msg = 191;	break;
X      case OYSTER:
X	if (!toting(OYSTER) || !g.closed) break;
X	yes(192, 193, 54);
X	return;
X      default:	;
X}
X  if (msg)
X	rspeak(msg);
X  else
X	actspk(verb);
X}
X
X/*
X  BLAST etc.
X*/
Xvoid vblast()
X{
X  if (g.prop[ROD2] < 0 || !g.closed)
X	actspk(verb);
X  else {
X	g.bonus = 133;
X	if (g.loc == 115) g.bonus = 134;
X	if (here(ROD2)) g.bonus = 135;
X	rspeak(g.bonus);
X	normend();
X  }
X}
X
X/*
X  BREAK etc.
X*/
Xvoid vbreak()
X{
X  int msg;
X  if (object == MIRROR) {
X	msg = 148;
X	if (g.closed) {
X		rspeak(197);
X		dwarfend();
X	}
X  } else if (object == VASE && g.prop[VASE] == 0) {
X	msg = 198;
X	if (toting(VASE)) drop(VASE, g.loc);
X	g.prop[VASE] = 2;
X	g.fixed[VASE] = -1;
X  } else {
X	actspk(verb);
X	return;
X  }
X  rspeak(msg);
X}
X
X/*
X  WAKE etc.
X*/
Xvoid vwake()
X{
X  if (object != DWARF || !g.closed)
X	actspk(verb);
X  else {
X	rspeak(199);
X	dwarfend();
X  }
X}
X
X/*
X  Routine to speak default verb message
X*/
Xvoid actspk(verb)
Xint verb;
X{
X  char i;
X
X  if (verb < 1 || verb > 31) bug(39);
X  i = actmsg[verb];
X  if (i) rspeak(i);
X}
X
X/*
X  Routine to indicate no reasonable
X  object for verb found.  Used mostly by
X  intransitive verbs.
X*/
Xvoid needobj()
X{
X  int wtype, wval;
X
X  analyze(word1, &wtype, &wval);
X  printf("%s what?\n", wtype == 2 ? word1 : word2);
X}
/
