echo x - signal.c
sed '/^X/s///' > signal.c << '/'
X/* SYSVR4 and ANSI compatible signal(2). */
X
X#include <lib.h>
X#define sigaction	_sigaction
X#define sigemptyset	_sigemptyset
X#include <signal.h>
X
XPUBLIC sighandler_t signal(sig, disp)
Xint sig;			/* signal number */
Xsighandler_t disp;		/* signal handler, or SIG_DFL, or SIG_IGN */
X{
X  struct sigaction sa, osa;
X
X  if (sig <= 0 || sig > _NSIG || sig == SIGKILL) {
X	errno = EINVAL;
X	return(SIG_ERR);
X  }
X  sigemptyset(&sa.sa_mask);
X
X#ifdef BASH
X  sa.sa_flags = 0;
X#else
X  /* Allow the signal being handled to interrupt the signal handler. */
X  sa.sa_flags = SA_NODEFER;
X
X  /* When signal is caught, reset signal handler to SIG_DFL for all but
X   * SIGILL and SIGTRAP.
X   */
X  if (sig != SIGILL && sig != SIGTRAP) sa.sa_flags |= SA_RESETHAND;
X#endif
X
X  sa.sa_handler = disp;
X  if (sigaction(sig, &sa, &osa) < 0) return(SIG_ERR);
X  return(osa.sa_handler);
X}
/
echo x - Makefile.ansi
sed '/^X/s///' > Makefile.ansi << '/'
XCC=exec cc
XCFLAGS= -c -O -D_MINIX -D_POSIX_SOURCE
X
Xall:	
X	@$(CC) $(CFLAGS) *.c
X
X
Xclean:	
X	@rm -rf *.o *.s *.bak
X
/
echo x - Makefile.kr
sed '/^X/s///' > Makefile.kr << '/'
XCC=exec cc
XCFLAGS= -c -O -D_MINIX -D_POSIX_SOURCE -LIB
X
X
Xall:	
X	@$(CC) $(CFLAGS) *.c
X
X
Xclean:	
X	@rm -rf *.o *.s *.bak
X
/
