echo x - Makefile.ansi
sed '/^X/s///' > Makefile.ansi << '/'
XCC=exec cc
XCFLAGS= -c -O -D_MINIX -D_POSIX_SOURCE -m
X
Xall:	
X	@$(CC) $(CFLAGS) *.c
X
X
Xclean:	
X	@rm -rf *.o *.s *.bak
X
/
echo x - Makefile.kr
sed '/^X/s///' > Makefile.kr << '/'
XCC=exec cc
XCFLAGS= -c -O -D_MINIX -D_POSIX_SOURCE -LIB
X
Xall:	
X	@$(CC) $(CFLAGS) *.c
X
X
Xclean:	
X	@rm -rf *.o *.s *.bak
X
/
echo x - beep.c
sed '/^X/s///' > beep.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X#include <termcap.h>
X
Xextern char *bl, *vb;
X
X/* Beep() sounds the terminal bell. */
Xvoid beep()
X{
X  if (bl)
X	tputs(bl, 1, outc);
X  else if (vb)
X	tputs(vb, 1, outc);
X}
/
echo x - charpick.c
sed '/^X/s///' > charpick.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Winch(win) returns the character at the current position in	*/
X/* Window 'win'.						*/
X/****************************************************************/
X
Xint winch(win)
XWINDOW *win;
X{
X  return((win->_line[win->_cury][win->_curx]) & 0xff);
X}				/* winch */
X
X/****************************************************************/
X/* Mvinch() moves the stdscr cursor to a new position, then	*/
X/* Returns the character at that position.			*/
X/****************************************************************/
X
Xint mvinch(y, x)
Xint y;
Xint x;
X{
X  if (wmove(stdscr, y, x) == ERR) return(ERR);
X  return((stdscr->_line[stdscr->_cury][stdscr->_curx]) & 0xff);
X}
X
X/****************************************************************/
X/* Mvwinch() moves the cursor of window 'win' to a new posi-	*/
X/* Tion, then returns the character at that position.		*/
X/****************************************************************/
X
Xint mvwinch(win, y, x)
XWINDOW *win;
Xint y;
Xint x;
X{
X  if (wmove(win, y, x) == ERR) return(ERR);
X  return((win->_line[win->_cury][win->_curx]) & 0xff);
X}
/
echo x - curs_set.c
sed '/^X/s///' > curs_set.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X#include <termcap.h>
X
Xextern char *vi, *ve, *vs;
X
X/* Sets cursor visibility to unvisible=0; normal visible=1 or very good
X * visible=2. 
X*/
Xvoid curs_set(visibility)
Xint visibility;
X{
X  switch (visibility) {
X      case 0:
X	if (vi) tputs(vi, 1, outc);
X	break;
X      case 1:
X	if (ve) tputs(ve, 1, outc);
X	break;
X      case 2:
X	if (vs)
X		tputs(vs, 1, outc);
X	else if (ve)
X		tputs(ve, 1, outc);
X  }
X}
/
echo x - curses.3
sed '/^X/s///' > curses.3 << '/'
X.TH CURSES 3
X.SH NAME
Xcurses \- screen/window management library
X.SH SYNOPSIS
Xcc demo.c -lcurses
X.SH DESCRIPTION
XCurses is a library of screen and window management routines.  It is modeled
Xafter the UNIX curses and ncurses libraries. Normally, programs written for
Xcurses should be easily ported to UNIX, and vice versa.
X.PP
XTo use the routines, the function initscr() must first be called.
XThis creates two 'windows' for the user: stdscr and curscr.  Stdscr is the
Xdefault
Xwindow for the user to make changes on, and curscr reflects the current
Xcontents of the physical display screen.  The user writes or edits the stdscr
Xwindow to his liking, then calls the refresh() function to make curscr
Xand the physical screen look like stdscr.  When the user program terminates,
Xit should call the endwin() function to restore things to normal.
X.PP
XThere are all sorts of window manipulation routines available to the
Xprogrammer: auxiliary windows may be created, edited, moved and deleted.  The
Xterminal may be set in many different modes, output text may be attributed
Xwith blink, blank, bold and reverse attributes.  Screen colors may also be 
Xset, foreground and background.  There are window-specific
Xprintf- and scanf-like routines, routines for scrolling, box-drawing,
Xwindow overlaying, clearing routines etc.
X.PP
XFor more and detailed information, see the library source codes.  All curses
Xfunctions are preceded by a complete description.
X.SH FUNCTIONS
XBelow is a list over the available functions, together with a brief
Xdescription of what they do.  In general, functions whose names start with 'w'
Xdiffer from the one without 'w' (like wmove vs. move) signify that
Xa specific window is used. Without a 'w', sdtscr is implied.  The functions
Xthat start with 'mv' before the 'genereic' function name signify that a
Xcursor motion should be made before the actual work.  'mv' and 'w' combine
Xas expected.
X.PP
XMost routines that return an int will return the manifest constant ERR if
Xthere is a failure during execution.  Routines that return a char actually
Xreturn an int, so that ERR does not conflict with the character code 0xff.
XAll characters from 0 to 0xff are allowed for usage with curses.
X.PP
XSome routines, like {mv}{w} printw() and {mv}{w}scanw() return a meaningful
Xpositive value if the operation is successful.
X.PP
XThe curses package uses some predefined types, variables and manifest
Xconstants that are also available to the programmer.  There are also a few
Xglobally accessible variables that should not be touched by the application
Xprogram.  Those untouchable variables have names starting with an
Xunderscore (_) to avoid conflicts.  The user-accessible types, variables
Xand constants are (there are a number of other constants defining character
Xattribute names and function key names - consult <curses.h> for details):
X.sp
X.nf
X.ta 3i
X(manifest constants)
X.RS
XTRUE\tboolean true
XFALSE\tboolean false
XERR\tunsuccessfull operation
XOK\tsuccessfull operation
X.RE
X.sp
X(types)
X.RS
XWINDOW\ta window structure type
Xbool\tboolean flag type
X.RE
X.sp
X(variables)
X.RS
XWINDOW curscr\tphysical display image
XWINDOW stdscr\tdefault user drawing board
Xint LINES\tterminal height
Xint COLS\tterminal width
Xint NONL\t\\n causes CR and LF when TRUE
X.RE
X.sp
X.fi
XThe following is an alphabetical list of the curses functions, together
Xwith their types, parameters and a short comment for each (win is a window,
Xch, vc, hc are characters, buf is a character buffer, attrs is an
Xattribute bit map, bf is a boolean flag.  Note that `characters' in this
Xcontext usually can have 16 bits):
X.nf
X.sp
Xint waddch(win,ch)\tput char in stdscr
Xint addch(ch)
Xint mvaddch(y,x,ch)
Xint mvwaddch(win,y,x,ch)
X
Xint waddstr(win,str)\tput string in stdscr
Xint addstr(str)
Xint mvaddstr(y,x,str)
Xint mvwaddstr(win,y,x,str)
X
Xvoid wattroff(win,attrs)\tclear attribute(s) in window
Xvoid attroff(attrs)
X
Xvoid wattron(win,attrs)\tadd attribute(s) in window
Xvoid attron(attrs)
X
Xvoid wattrset(win,attrs)\tset window char attributes
Xvoid attrset(attrs)
X
Xint baudrate()\tdummy for compatibility
X
Xvoid beep()\tring the bell or visible bell if no bell available
X
Xvoid flash()\tflash terminal screen or rings bell if no visible bell available
X
Xvoid wbox(win,miny,minx,maxy,maxx,vc,hc)\tbox in a window, with given characters
Xvoid box(win,vc,hc)
X
Xvoid cbreak()\tset terminal cbreak mode
X
Xvoid wclear(win)\tclear stdscr
Xvoid clear()
X
Xvoid clearok(win,bf)\tmarks window for screen clear
X
Xint wclrtobot(win)\tclear from cursor to end of line and all lines down this line
Xint clrtobot()
Xint mvclrtoeol(y,x)
Xint mvwclrtobot(win,y,x)
X
Xint wclrtoeol(win)\tclear from cursor to end of line
Xint clrtoeol()
Xint mvclrtoeol(y,x)
Xint mvwclrtoeol(win,y,x)
X
Xint wdelch(win)\tdelete a char in a window
Xint delch()
Xint mvdelch(y,x)
Xint mvwdelch(win,y,x)
X
Xint wdeleteln(win)\tdelete a line in a window
Xint deleteln()
Xint mvdeleteln(y,x)
Xint mvwdeleteln(win,y,x)
X
Xvoid delwin(win)\tdelete a window or a subwindow
Xvoid doupdate()\tupdate physical screen
Xvoid echo()\tset terminal echo mode
Xint endwin()\tcleanup and curses finitialization
X
Xvoid werase(win)\terase a window
Xvoid erase()
X
Xint erasechar()\treturn char delete character
Xint fixterm()\tdummy for compatibility
Xvoid flushinp()\tkill pending keyboard input
X
Xint wgetch(win)\tget char via a window
Xint getch()
Xint mvgetch(y,x)
Xint mvwgetch(win,y,x)
X
Xint wgetstr(win,str)\tget string via window to a buffer
Xint getstr(str)
Xint mvgetstr(y,x,str)
Xint mvwgetstr(win,y,x,str)
X
Xvoid getyx(win,y,x)\tget a window's cursor position
X
Xint gettmode()\tdummy for compatibility
Xvoid idlok(win,bf)\tdummy for compatibility
XWINDOW *initscr()\tcurses initialization (ret stdscr or NULL)
X
Xint winch(win)\tget char at window cursor
Xint inch()
Xint mvinch(y,x)
Xint mvwinch(win,y,x)
X
Xint winsch(win,ch)\tinsert character in a window
Xint insch(ch)
Xint mvinsch(y,x,ch)
Xint mvwinsch(win,y,x,ch)
X
Xint winsertln(win)\tinsert new line in a window
Xint insertln()
Xint mvinsertln(y,x)
Xint mvwinsertln(win,y,x)
X
Xvoid keypad(win,bf)\tmarks a window for keypad usage
Xint killchar()\treturn line delete character
Xchar *longname()\treturns terminal description string
Xvoid leaveok(win,bf)\tmarks window for cursor 'update leave'
Xvoid meta(win,bf)\tmarks window for meta
Xint move(y,x)\tmove cursor in stdscr
Xint mvcur(oldy,oldx,y,x)\tmove terminal cursor to <y,x>
X
Xint mvprintw(y,x,fmt,args)\tmove & print string in stdscr
X
Xint mvscanw(y,x,fmt,args)\tmove & get values via stdscr
Xint mvwin(win,y,x)\tmove window on physical screen
Xint mvwprintw(win,x,y,fmt,args)\tmove & print string in a window
Xint mvwscanw(win,y,x,fmt,args)\tmove & get values via a window
XWINDOW *newwin(lines,cols,begy,begx)\tcreate a new window
Xvoid nl()\tset terminal cr-crlf mapping mode
Xvoid nocbreak()\tunset terminal cbreak mod
Xvoid nodelay(win,bf)\tmarks window for no input wait
Xvoid noecho()\tunset terminal echo mode
Xvoid nonl()\tunset terminal cr-crlf mapping mode
Xvoid noraw()\tunset raw terminal mode
Xvoid overlay(win1,win2)\toverlay one window on another
Xvoid overwrite(win1,win2)\toverwrite one window on another
Xint printw(fmt,args)\tprint string in stdscr
Xvoid raw()\tset raw terminal mode
Xvoid refrbrk(bf)\tset screen update break mode
Xvoid refresh()\trefresh stdscr
Xint resetterm()\tdummy for compatibility
Xint resetty()\trestore terminal I/O modes
Xint saveoldterm()\tdummy for compatibility
Xint saveterm()\tdummy for compatibility
Xint savetty()\tsave terminal I/O modes
Xint scanw(fmt,args)\tget values via stdscr
Xvoid scroll(win)\tscroll scrolling region of a window
Xvoid scrollok(win,bf)\tmarks a window to allow scroll
Xvoid setcolors(A_COLOR(for,back))\tsets the forground and background
X\tcolors of stdscr
Xvoid set_curs(visibility)\t0 for invisible, 1 for visible, 2 for good
X\tvisible
Xint setsrcreg(miny,maxy)\tdefine stdscr's scroll region
Xint setterm()\tdummy for compatibility
Xint setupterm(term,fd,errret)\tset up terminal
Xvoid standend()\tstart normal chars in stdscr
Xvoid standout()\tstart standout chars in stdscr
XWINDOW *subwin(win,lines,cols,begy,begx)
X\tcreate a sub-window in window win
Xint tabsize(ts)\tset/get tabsize of stdscr
Xvoid touchwin(win)\tmark a window as totally modified
Xchar *unctrl(ch)\tchar-to-string converter
Xint wmove(win,y,x)\tmove cursor in a window
Xvoid wnoutrefresh(win)\tcreate internal screen image
Xint wprintw(win,fmt,args)\tprint string in a window
Xvoid wrefresh(win)\trefresh window
Xint wscanw(win,fmt,args)\tget values via a window
Xvoid wsetcolors(win,A_COLOR(for,back))\tsets the forground and
X\tbackground colors of the specified window
Xint wsetsrcreg(win,miny,maxy)\tdefine a window's scrolling region
Xvoid wstandend(win)\tstart normal chars in window
Xvoid wstandout(win)\tstart standout chars in window
Xint wtabsize(win,ts)\tset/get tabsize of a window
X.SH BUGS
XFunction keys are not available under the MINIX version.
X
/
echo x - cursesio.c
sed '/^X/s///' > cursesio.c << '/'
X#include <stdlib.h>
X#include <termcap.h>
X#include <curses.h>
X#include "curspriv.h"
X
Xstruct sgttyb _orig_tty, _tty;
Xcursv _cursvar;
X
XWINDOW *stdscr, *curscr;
Xint LINES, COLS;
Xbool NONL;
X
Xchar termcap[1024];		/* termcap buffer */
Xchar tc[200];			/* area to hold string capabilities */
Xchar *ttytype;			/* terminal type from env */
Xchar *arp;			/* pointer for use in tgetstr */
Xchar *cp;			/* character pointer */
X
Xchar *cl;			/* clear screen capability */
Xchar *cm;			/* cursor motion capability */
Xchar *so;			/* start standout capability */
Xchar *se;			/* end standout capability */
Xchar *mr;			/* start of reverse */
Xchar *me;			/* revert to normal */
Xchar *mb;			/* start of blink */
Xchar *md;			/* start of bold */
Xchar *us;			/* start of underscore */
Xchar *ue;			/* end of underscore */
Xchar *vi;			/* cursor invisible */
Xchar *ve;			/* cursor normal */
Xchar *vs;			/* cursor good visible */
Xchar *as;			/* alternative charset start */
Xchar *ae;			/* alternative charset end */
Xchar *bl;			/* ring the bell */
Xchar *vb;			/* visual bell */
X
X/* fatal - report error and die. Never returns */
Xvoid fatal(s)
Xchar *s;
X{
X  (void) fprintf(stderr, "curses: %s\n", s);
X  exit(1);
X}
X
X/* Outc - call putchar, necessary because putchar is a macro. */
Xvoid outc(c)
Xint c;
X{
X  putchar(c);
X}
X
X/* Move cursor to r,c */
Xvoid poscur(r, c)
Xint r, c;
X{
X  tputs(tgoto(cm, c, r), 1, outc);
X}
X
X/* Clear the screen */
Xvoid clrscr()
X{
X  tputs(cl, 1, outc);
X}
X
X/* This are terminal independent characters which can be used in curses */
X
Xunsigned int ACS_ULCORNER;
Xunsigned int ACS_LLCORNER;
Xunsigned int ACS_URCORNER;
Xunsigned int ACS_LRCORNER;
Xunsigned int ACS_RTEE;
Xunsigned int ACS_LTEE;
Xunsigned int ACS_BTEE;
Xunsigned int ACS_TTEE;
Xunsigned int ACS_HLINE;
Xunsigned int ACS_VLINE;
Xunsigned int ACS_PLUS;
Xunsigned int ACS_S1;
Xunsigned int ACS_S9;
Xunsigned int ACS_DIAMOND;
Xunsigned int ACS_CKBOARD;
Xunsigned int ACS_DEGREE;
Xunsigned int ACS_PLMINUS;
Xunsigned int ACS_BULLET;
Xunsigned int ACS_LARROW;
Xunsigned int ACS_RARROW;
Xunsigned int ACS_DARROW;
Xunsigned int ACS_UARROW;
Xunsigned int ACS_BOARD;
Xunsigned int ACS_LANTERN;
Xunsigned int ACS_BLOCK;
X
X/* These defines describe the full set of grafic block characters which
X * can be defined via termcap.
X */
X
X#define RIGHTARROW  0
X#define LEFTARROW   1
X#define DOWNARROW   2
X#define UPARROW     3
X#define FULLSQUARE  4
X#define GREYSQUARE  5
X#define EMPTYSQUARE 6
X#define LATERN      7
X#define DIAMOND     8
X#define DEGREE      9
X#define PLUSMINUS  10
X#define DOWNRIGHT  11
X#define UPRIGHT    12
X#define UPLEFT     13
X#define DOWNLEFT   14
X#define CROSS      15
X#define UPLINE     16
X#define UPMIDLINE  17
X#define MIDLINE    18
X#define DOMIDLINE  19
X#define DOWNLINE   20
X#define TEELEFT    21
X#define TEERIGHT   22
X#define TEEHEAD    23
X#define TEENORMAL  24
X#define VERTLINE   25
X#define PARAGRAPH  26
X
Xunsigned int _cursgraftable[27] =
X{
X '>', '<', 'v', '^', '#', ':', ' ', '#', '+', '\'', '#', '+', '+',
X '+', '+', '+', '-', ' ', '-', ' ', '_', '+', '+', '+', '+', '|'
X};
Xchar _cursident[28] = "+,.-0ahI`fgjklmnopqrstuvwx~";
X
Xint setterm(type)
Xchar *type;
X{
X  unsigned char *ac;
X  int i;
X
X  if (tgetent(termcap, type) != 1) return ERR;
X  LINES = tgetnum("li");
X  COLS = tgetnum("co");
X  arp = tc;
X  cl = tgetstr("cl", &arp);
X  so = tgetstr("so", &arp);
X  se = tgetstr("se", &arp);
X  cm = tgetstr("cm", &arp);
X  mr = tgetstr("mr", &arp);
X  me = tgetstr("me", &arp);
X  mb = tgetstr("mb", &arp);
X  md = tgetstr("md", &arp);
X  us = tgetstr("us", &arp);
X  ue = tgetstr("ue", &arp);
X  vi = tgetstr("vi", &arp);
X  ve = tgetstr("ve", &arp);
X  vs = tgetstr("vs", &arp);
X  as = tgetstr("as", &arp);
X  ae = tgetstr("ae", &arp);
X  ac = (unsigned char *) tgetstr("ac", &arp);
X  bl = tgetstr("bl", &arp);
X  vb = tgetstr("vb", &arp);
X
X  if (ac) {
X	while (*ac) {
X		i = 0;
X		while (*ac != _cursident[i]) i++;
X		_cursgraftable[i] = *++ac | A_ALTCHARSET;
X		ac++;
X	}
X  }
X
X  ACS_ULCORNER = _cursgraftable[UPLEFT];
X  ACS_LLCORNER = _cursgraftable[DOWNLEFT];
X  ACS_URCORNER = _cursgraftable[UPRIGHT];
X  ACS_LRCORNER = _cursgraftable[DOWNRIGHT];
X  ACS_RTEE = _cursgraftable[TEERIGHT];
X  ACS_LTEE = _cursgraftable[TEELEFT];
X  ACS_BTEE = _cursgraftable[TEEHEAD];
X  ACS_TTEE = _cursgraftable[TEENORMAL];
X  ACS_HLINE = _cursgraftable[MIDLINE];
X  ACS_VLINE = _cursgraftable[VERTLINE];
X  ACS_PLUS = _cursgraftable[CROSS];
X  ACS_S1 = _cursgraftable[UPLINE];
X  ACS_S9 = _cursgraftable[DOWNLINE];
X  ACS_DIAMOND = _cursgraftable[DIAMOND];
X  ACS_CKBOARD = _cursgraftable[GREYSQUARE];
X  ACS_DEGREE = _cursgraftable[DEGREE];
X  ACS_PLMINUS = _cursgraftable[PLUSMINUS];
X  ACS_BULLET = 'o';		/* where the hell is a bullet defined in
X			 * termcap ??? */
X  ACS_LARROW = _cursgraftable[LEFTARROW];
X  ACS_RARROW = _cursgraftable[RIGHTARROW];
X  ACS_DARROW = _cursgraftable[DOWNARROW];
X  ACS_UARROW = _cursgraftable[UPARROW];
X  ACS_BOARD = _cursgraftable[EMPTYSQUARE];
X  ACS_LANTERN = _cursgraftable[LATERN];
X  ACS_BLOCK = _cursgraftable[FULLSQUARE];
X  /* Wow, I got it! */
X  return OK;
X}
X
Xgettmode()
X{
X  gtty(0, &_orig_tty);
X  gtty(0, &_tty);
X  _cursvar.echoit = (_tty.sg_flags & ECHO) != 0;
X  _cursvar.rawmode = (_tty.sg_flags & RAW) != 0;
X  NONL = (_tty.sg_flags & CRMOD) != 0;
X}
/
echo x - curspriv.h
sed '/^X/s///' > curspriv.h << '/'
X/* Constants */
X#define	_SUBWIN		1		/* window is a subwindow */
X#define	_ENDLINE	2		/* last winline is last screen line */
X#define	_FULLWIN	4		/* window fills screen */
X#define	_SCROLLWIN	8		/* window lwr rgt is screen lwr rgt */
X
X#define	_NO_CHANGE	-1		/* flags line edge unchanged */
X#define	_BREAKCHAR	0x03		/* ^C character */
X#define _DCCHAR		0x08		/* Delete Char char (BS) */
X#define _DLCHAR		0x1b		/* Delete Line char (ESC) */
X#define	_GOCHAR		0x11		/* ^Q character */
X#define	_PRINTCHAR	0x10		/* ^P character */
X#define	_STOPCHAR	0x13		/* ^S character */
X#define	 NUNGETCH	10		/* max # chars to ungetch() */
X
X#define max(a,b) (((a) > (b)) ? (a) : (b))
X#define min(a,b) (((a) < (b)) ? (a) : (b))
X
X/* Character mask definitions. */
X#define CHR_MSK	((int) 0x00ff)		/* ASCIIZ character mask */
X#define	ATR_MSK	((int) 0xff00)		/* attribute mask */
X#define ATR_NRM	((int) 0x0000)		/* no special attributes */
X
X/* Type declarations. */
X
Xtypedef	struct {
X  WINDOW  *tmpwin;			/* window used for updates */
X  int	   cursrow;			/* position of physical cursor */
X  int	   curscol;
X  bool     rawmode;
X  bool     echoit;
X} cursv;
X
X/* External variables */
Xextern	cursv   _cursvar;		/* curses variables */
/
echo x - endwin.c
sed '/^X/s///' > endwin.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X#include <termcap.h>
X
Xint endwin()
X{
X  extern char *me;
X
X  curs_set(1);
X  poscur(LINES - 1, 0);
X  refresh();
X  tputs(me, 1, outc);
X  delwin(stdscr);
X  delwin(curscr);
X  delwin(_cursvar.tmpwin);
X  resetty();
X  return(OK);
X}
/
echo x - flash.c
sed '/^X/s///' > flash.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X#include <termcap.h>
X
Xextern char *bl, *vb;
X
X/* Flash() flashes the terminal screen. */
Xvoid flash()
X{
X  if (vb)
X	tputs(vb, 1, outc);
X  else if (bl)
X	tputs(bl, 1, outc);
X}
/
echo x - initscr.c
sed '/^X/s///' > initscr.c << '/'
X/* initscr.c - initialize the curses library */
X
X#include <stdlib.h>
X#include <curses.h>
X#include "curspriv.h"
X
XWINDOW *initscr()
X{
X  char *term;
X
X  if ((term = getenv("TERM")) == NULL) return NULL;
X  setterm(term);
X  gettmode();
X  if ((_cursvar.tmpwin = newwin(LINES, COLS, 0, 0)) == NULL) return NULL;
X  if ((curscr = newwin(LINES, COLS, 0, 0)) == NULL) return NULL;
X  if ((stdscr = newwin(LINES, COLS, 0, 0)) == NULL) return NULL;
X  clearok(curscr, TRUE);
X  return(stdscr);
X}
/
echo x - longname.c
sed '/^X/s///' > longname.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Longname() returns a pointer to a string describing the	*/
X/* User terminal.						*/
X/****************************************************************/
X
Xchar *longname()
X{
X  return("not implemented");
X}
/
echo x - move.c
sed '/^X/s///' > move.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Wmove() moves the cursor in window 'win' to position (x,y).	*/
X/****************************************************************/
X
Xint wmove(win, y, x)
XWINDOW *win;
Xint y;
Xint x;
X{
X  if ((x<0) || (x>win->_maxx) || (y<win->_regtop) || (y>win->_regbottom)) 
X	return(ERR);
X  win->_curx = x;
X  win->_cury = y;
X  return(OK);
X}
/
echo x - mvcursor.c
sed '/^X/s///' > mvcursor.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Mvcur(oldy,oldx,newy,newx) the display cursor to <newy,newx>	*/
X/****************************************************************/
X
Xint mvcur(oldy, oldx, newy, newx)
Xint oldy;
Xint oldx;
Xint newy;
Xint newx;
X{
X  if ((newy >= LINES) || (newx >= COLS) || (newy < 0) || (newx < 0))
X	return(ERR);
X  poscur(newy, newx);
X  _cursvar.cursrow = newy;
X  _cursvar.curscol = newx;
X  return(OK);
X}
/
echo x - newwin.c
sed '/^X/s///' > newwin.c << '/'
X#include <stdlib.h>
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Makenew() allocates all data for a new window except the	*/
X/* Actual lines themselves.					*/
X/****************************************************************/
X
X_PROTOTYPE(static WINDOW *makenew, (int nlines, int ncols, int begy,int begx));
X
Xstatic WINDOW *makenew(num_lines, num_columns, begy, begx)
Xint num_lines, num_columns, begy, begx;
X{
X  int i;
X  WINDOW *win;
X
X  /* Allocate the window structure itself */
X  if ((win = (WINDOW *) malloc(sizeof(WINDOW))) == NULL) 
X	return((WINDOW *) ERR);
X
X  /* Allocate the line pointer array */
X  if ((win->_line = (int **) calloc(num_lines, sizeof(int *))) == NULL) {
X	free(win);
X	return((WINDOW *) ERR);
X  }
X
X  /* Allocate the minchng and maxchng arrays */
X  if ((win->_minchng = (int *) calloc(num_lines, sizeof(int))) == NULL) {
X	free(win);
X	free(win->_line);
X	return((WINDOW *) ERR);
X  }
X  if ((win->_maxchng = (int *) calloc(num_lines, sizeof(int))) == NULL) {
X	free(win);
X	free(win->_line);
X	free(win->_minchng);
X	return((WINDOW *) ERR);
X  }
X
X  /* Initialize window variables */
X  win->_curx = 0;
X  win->_cury = 0;
X  win->_maxy = num_lines - 1;
X  win->_maxx = num_columns - 1;
X  win->_begy = begy;
X  win->_begx = begx;
X  win->_flags = 0;
X  win->_attrs = ATR_NRM;
X  win->_tabsize = 8;
X  win->_clear = FALSE;
X  win->_leave = FALSE;
X  win->_scroll = FALSE;
X  win->_nodelay = FALSE;
X  win->_keypad = FALSE;
X  win->_regtop = 0;
X  win->_regbottom = num_lines - 1;
X
X  /* Init to say window unchanged */
X  for (i = 0; i < num_lines; i++) {
X	win->_minchng[i] = 0;
X	win->_maxchng[i] = num_columns - 1;
X  }
X
X  /* Set flags for window properties */
X  if ((begy + num_lines) == LINES) {
X	win->_flags |= _ENDLINE;
X	if ((begx == 0) && (num_columns == COLS) && (begy == 0))
X		win->_flags |= _FULLWIN;
X  }				/* if */
X  if (((begy + num_lines) == LINES) && ((begx + num_columns) == COLS))
X	win->_flags |= _SCROLLWIN;
X  return(win);
X}
X
X
X/****************************************************************/
X/* Newwin() creates a new window with size num_lines * num_co-	*/
X/* Lumns, and origin begx,begy relative to the SCREEN. Special	*/
X/* Case: if num_lines and/or num_columns is 0, the remainder of	*/
X/* The screen is used.						*/
X/****************************************************************/
XWINDOW *newwin(num_lines, num_columns, begy, begx)
Xint num_lines, num_columns, begy, begx;
X{
X  WINDOW *win;
X  int *ptr;
X  int i, j;
X
X  if (num_lines == 0) num_lines = LINES - begy;
X  if (num_columns == 0) num_columns = COLS - begx;
X  if ((win = makenew(num_lines, num_columns, begy, begx)) == (WINDOW *) ERR)
X	return((WINDOW *) ERR);
X  for (i = 0; i < num_lines; i++) {	/* make and clear the lines */
X	if ((win->_line[i] = (int *)calloc(num_columns, sizeof(int))) == NULL){
X		for (j = 0; j < i; j++)	/* if error, free all the data */
X			free(win->_line[j]);
X		free(win->_minchng);
X		free(win->_maxchng);
X		free(win->_line);
X		free(win);
X		return((WINDOW *) ERR);
X	} else {
X		for (ptr = win->_line[i]; ptr < win->_line[i] + num_columns;)
X			*ptr++ = ' ' | ATR_NRM;
X	}
X  }
X  return(win);
X}
X
X
X/****************************************************************/
X/* Subwin() creates a sub-window in the 'orig' window, with	*/
X/* Size num_lines * num_columns, and with origin begx, begy	*/
X/* Relative to the SCREEN. Special case: if num_lines and/or	*/
X/* Num_columns is 0, the remainder of the original window is	*/
X/* Used. The subwindow uses the original window's line buffers	*/
X/* To store it's own lines.					*/
X/****************************************************************/
XWINDOW *subwin(orig, num_lines, num_columns, begy, begx)
XWINDOW *orig;
Xint num_lines, num_columns, begy, begx;
X{
X  WINDOW *win;
X  int i, j, k;
X
X  /* Make sure window fits inside the original one */
X  if (begy < orig->_begy || begx < orig->_begx ||
X		      (begy + num_lines) > (orig->_begy + orig->_maxy) ||
X		      (begx + num_columns) > (orig->_begx + orig->_maxx) )
X	return((WINDOW *) ERR);
X
X  if (num_lines == 0) num_lines = orig->_maxy - (begy - orig->_begy);
X  if (num_columns == 0) num_columns = orig->_maxx - (begx - orig->_begx);
X  if ((win = makenew(num_lines, num_columns, begy, begx)) == (WINDOW *) ERR)
X	return((WINDOW *) ERR);
X
X  /* Set line pointers the same as in the original window */
X  j = begy - orig->_begy;
X  k = begx - orig->_begx;
X  for (i = 0; i < num_lines; i++) win->_line[i] = (orig->_line[j++]) + k;
X  win->_flags |= _SUBWIN;
X  return(win);
X}
/
echo x - options.c
sed '/^X/s///' > options.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
Xstatic bool hasold = FALSE;	/* for remembering old cursor type */
Xstatic int oldmode;
X
X/****************************************************************/
X/* Idlok() is used to set  flag for using the terminal insert/	*/
X/* Delete line capabilities. This is not relevant for the PC	*/
X/* Version of curses, and thus nothing is done.			*/
X/****************************************************************/
Xvoid idlok(win, flag)
XWINDOW *win;
Xbool flag;
X{
X}
X
X/****************************************************************/
X/* Clearok() marks window 'win' to cause screen clearing and	*/
X/* Redraw the next time a refresh is done.			*/
X/****************************************************************/
Xvoid clearok(win, flag)
XWINDOW *win;
Xbool flag;
X{
X  if (win == curscr)
X	_cursvar.tmpwin->_clear = flag;
X  else
X	win->_clear = flag;
X}
X
X/****************************************************************/
X/* Leaveok() marks window 'win' to allow the update routines	*/
X/* To leave the hardware cursor where it happens to be at the	*/
X/* End of update. Usually used in combination with cursoff().	*/
X/****************************************************************/
X
Xvoid leaveok(win, flag)
XWINDOW *win;
Xbool flag;
X{
X  win->_leave = flag;
X}
X
X/****************************************************************/
X/* Scrollok() marks window 'win' to allow the scrolling region	*/
X/* Of it to actually scroll.					*/
X/****************************************************************/
Xvoid scrollok(win, flag)
XWINDOW *win;
Xbool flag;
X{
X  win->_scroll = flag;
X}
X
X/****************************************************************/
X/* Nodelay() marks the window to make character input non-	*/
X/* Waiting, i.e. if there is no character to get, -1 will be	*/
X/* Returned.							*/
X/****************************************************************/
Xvoid nodelay(win, flag)
XWINDOW *win;
Xbool flag;
X{
X  win->_nodelay = flag;
X}
X
X/****************************************************************/
X/* Keypad() marks window 'win' to use the special keypad mode.	*/
X/****************************************************************/
Xvoid keypad(win, flag)
XWINDOW *win;
Xbool flag;
X{
X  win->_keypad = flag;
X}
X
X/****************************************************************/
X/* Meta() allows use of any alternate character set allowed by	*/
X/* The terminal. We always allow this on the PC, so this one	*/
X/* Does nothing.						*/
X/****************************************************************/
Xvoid meta(win, flag)
XWINDOW *win;
Xbool flag;
X{
X}
/
echo x - overlay.c
sed '/^X/s///' > overlay.c << '/'
X/****************************************************************/
X/* Overlay() and overwrite() functions of the PCcurses package	*/
X/*								*/
X/****************************************************************/
X/* This version of curses is based on ncurses, a curses version	*/
X/* Originally written by Pavel Curtis at Cornell University.	*/
X/* I have made substantial changes to make it run on IBM PC's,	*/
X/* And therefore consider myself free to make it public domain.	*/
X/*		Bjorn Larsson (...mcvax!enea!infovax!bl)	*/
X/****************************************************************/
X/* 1.0:	Release:					870515	*/
X/****************************************************************/
X/* Modified to run under the MINIX operating system by Don Cope */
X/* These changes are also released into the public domain.      */
X/* 							900906  */
X/****************************************************************/
X
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Overlay() overwrites 'win1' upon 'win2', with origins alig-	*/
X/* Ned. Overlay is transparent; blanks from 'win1' are not	*/
X/* Copied to 'win2'.						*/
X/****************************************************************/
Xvoid overlay(win1, win2)
XWINDOW *win1, *win2;
X{
X  int *minchng;
X  int *maxchng;
X  int *w1ptr;
X  int *w2ptr;
X  int attrs;
X  int col;
X  int line;
X  int last_line;
X  int last_col;
X
X  last_col = min(win1->_maxx, win2->_maxx);
X  last_line = min(win1->_maxy, win2->_maxy);
X  attrs = win2->_attrs & ATR_MSK;
X  minchng = win2->_minchng;
X  maxchng = win2->_maxchng;
X
X  for (line = 0; line <= last_line; line++) {
X	register short fc, lc = 0;
X	w1ptr = win1->_line[line];
X	w2ptr = win2->_line[line];
X	fc = _NO_CHANGE;
X	for (col = 0; col <= last_col; col++) {
X		if ((*w1ptr & CHR_MSK) != ' ') {
X			*w2ptr = (*w1ptr & CHR_MSK) | attrs;
X			if (fc == _NO_CHANGE) fc = col;
X			lc = col;
X		}
X		w1ptr++;
X		w2ptr++;
X	}
X
X	if (*minchng == _NO_CHANGE) {
X		*minchng = fc;
X		*maxchng = lc;
X	} else if (fc != _NO_CHANGE) {
X		if (fc < *minchng) *minchng = fc;
X		if (lc > *maxchng) *maxchng = lc;
X	}
X	minchng++;
X	maxchng++;
X  }				/* for */
X}				/* overlay */
X
X/****************************************************************/
X/* Overwrite() overwrites 'win1' upon 'win2', with origins	*/
X/* Aligned. Overwrite is non-transparent; blanks from 'win1'	*/
X/* Are copied to 'win2'.					*/
X/****************************************************************/
Xvoid overwrite(win1, win2)
XWINDOW *win1, *win2;
X{
X  int *minchng;
X  int *maxchng;
X  int *w1ptr;
X  int *w2ptr;
X  int attrs;
X  int col;
X  int line;
X  int last_line;
X  int last_col;
X
X  last_col = min(win1->_maxx, win2->_maxx);
X  last_line = min(win1->_maxy, win2->_maxy);
X  attrs = win2->_attrs & ATR_MSK;
X  minchng = win2->_minchng;
X  maxchng = win2->_maxchng;
X
X  for (line = 0; line <= last_line; line++) {
X	register short fc, lc = 0;
X
X	w1ptr = win1->_line[line];
X	w2ptr = win2->_line[line];
X	fc = _NO_CHANGE;
X
X	for (col = 0; col <= last_col; col++) {
X		if ((*w1ptr & CHR_MSK) != (*w2ptr & CHR_MSK)) {
X			*w2ptr = (*w1ptr & CHR_MSK) | attrs;
X
X			if (fc == _NO_CHANGE) fc = col;
X			lc = col;
X		}
X		w1ptr++;
X		w2ptr++;
X	}			/* for */
X
X	if (*minchng == _NO_CHANGE) {
X		*minchng = fc;
X		*maxchng = lc;
X	} else if (fc != _NO_CHANGE) {
X		if (fc < *minchng) *minchng = fc;
X		if (lc > *maxchng) *maxchng = lc;
X	}
X	minchng++;
X	maxchng++;
X  }
X}
/
echo x - prntscan.c
sed '/^X/s///' > prntscan.c << '/'
X#include <string.h>
X#include <curses.h>
X#include "curspriv.h"
X
Xstatic char printscanbuf[513];	/* buffer used during I/O */
X
X#ifdef _ANSI
X/****************************************************************/
X/* Wprintw(win,fmt,args) does a printf() in window 'win'.	*/
X/****************************************************************/
Xint wprintw(WINDOW *win, char *fmt, va_list args, ...)
X{
X  va_start(args, fmt);
X  vsprintf(printscanbuf, fmt, args);
X  if (waddstr(win, printscanbuf) == ERR) return(ERR);
X  return(strlen(printscanbuf));
X}
X
X/****************************************************************/
X/* Printw(fmt,args) does a printf() in stdscr.			*/
X/****************************************************************/
Xint printw(char *fmt, ...)
X{
X  va_list args;
X
X  va_start(args, fmt);
X  vsprintf(printscanbuf, fmt, args);
X  if (waddstr(stdscr, printscanbuf) == ERR) return(ERR);
X  return(strlen(printscanbuf));
X}				/* printw */
X
X/****************************************************************/
X/* Mvprintw(fmt,args) moves the stdscr cursor to a new posi-	*/
X/* Tion, then does a printf() in stdscr.			*/
X/****************************************************************/
Xint mvprintw(int y, int x, char *fmt, ...)
X{
X  va_list args;
X
X  va_start(args, fmt);
X  if (wmove(stdscr, y, x) == ERR) return(ERR);
X  vsprintf(printscanbuf, fmt, args);
X  if (waddstr(stdscr, printscanbuf) == ERR) return(ERR);
X  return(strlen(printscanbuf));
X}
X
X/****************************************************************/
X/* Mvwprintw(win,fmt,args) moves the window 'win's cursor to	*/
X/* A new position, then does a printf() in window 'win'.	*/
X/****************************************************************/
Xint mvwprintw(WINDOW *win, int y, int x, char *fmt, ...)
X{
X  va_list args;
X
X  va_start(args, fmt);
X  if (wmove(win, y, x) == ERR) return(ERR);
X  vsprintf(printscanbuf, fmt, args);
X  if (waddstr(win, printscanbuf) == ERR) return(ERR);
X  return(strlen(printscanbuf));
X}				/* mvwprintw */
X#else
X/****************************************************************/
X/* Wprintw(win,fmt,args) does a printf() in window 'win'.	*/
X/****************************************************************/
Xint wprintw(win, fmt, args)
XWINDOW *win; 
Xchar *fmt;
Xva_list args;
X{
X  va_start(args, fmt);
X  vsprintf(printscanbuf, fmt, args);
X  if (waddstr(win, printscanbuf) == ERR) return(ERR);
X  return(strlen(printscanbuf));
X}
X
X/****************************************************************/
X/* Printw(fmt,args) does a printf() in stdscr.			*/
X/****************************************************************/
Xint printw(fmt)
Xchar *fmt;
X{
X  va_list args;
X
X  va_start(args, fmt);
X  vsprintf(printscanbuf, fmt, args);
X  if (waddstr(stdscr, printscanbuf) == ERR) return(ERR);
X  return(strlen(printscanbuf));
X}				/* printw */
X
X/****************************************************************/
X/* Mvprintw(fmt,args) moves the stdscr cursor to a new posi-	*/
X/* Tion, then does a printf() in stdscr.			*/
X/****************************************************************/
Xint mvprintw(y, x, fmt)
Xint y;
Xint x;
Xchar *fmt;
X{
X  va_list args;
X
X  va_start(args, fmt);
X  if (wmove(stdscr, y, x) == ERR) return(ERR);
X  vsprintf(printscanbuf, fmt, args);
X  if (waddstr(stdscr, printscanbuf) == ERR) return(ERR);
X  return(strlen(printscanbuf));
X}
X
X/****************************************************************/
X/* Mvwprintw(win,fmt,args) moves the window 'win's cursor to	*/
X/* A new position, then does a printf() in window 'win'.	*/
X/****************************************************************/
Xint mvwprintw(win, y, x, fmt)
XWINDOW *win;
Xint y;
Xint x;
Xchar *fmt;
X{
X  va_list args;
X
X  va_start(args, fmt);
X  if (wmove(win, y, x) == ERR) return(ERR);
X  vsprintf(printscanbuf, fmt, args);
X  if (waddstr(win, printscanbuf) == ERR) return(ERR);
X  return(strlen(printscanbuf));
X}				/* mvwprintw */
X#endif
X
X/****************************************************************/
X/* Wscanw(win,fmt,args) gets a string via window 'win', then	*/
X/* Scans the string using format 'fmt' to extract the values	*/
X/* And put them in the variables pointed to the arguments.	*/
X/****************************************************************/
Xint wscanw(win, fmt, A1, A2, A3, A4, A5)
XWINDOW *win;
Xchar *fmt;
Xchar *A1, A2, A3, A4, A5;	/* really pointers */
X{
X  wrefresh(win);		/* set cursor */
X  if (wgetstr(win, printscanbuf) == ERR)	/* get string */
X	return(ERR);
X  return(sscanf(printscanbuf, fmt, A1, A2, A3, A4, A5));
X}				/* wscanw */
X
X/****************************************************************/
X/* Scanw(fmt,args) gets a string via stdscr, then scans the	*/
X/* String using format 'fmt' to extract the values and put them	*/
X/* In the variables pointed to the arguments.			*/
X/****************************************************************/
Xint scanw(fmt, A1, A2, A3, A4, A5)
Xchar *fmt;
Xchar *A1, A2, A3, A4, A5;	/* really pointers */
X{
X  wrefresh(stdscr);		/* set cursor */
X  if (wgetstr(stdscr, printscanbuf) == ERR)	/* get string */
X	return(ERR);
X  return(sscanf(printscanbuf, fmt, A1, A2, A3, A4, A5));
X}				/* scanw */
X
X/****************************************************************/
X/* Mvscanw(y,x,fmt,args) moves stdscr's cursor to a new posi-	*/
X/* Tion, then gets a string via stdscr and scans the string	*/
X/* Using format 'fmt' to extract the values and put them in the	*/
X/* Variables pointed to the arguments.				*/
X/****************************************************************/
Xint mvscanw(y, x, fmt, A1, A2, A3, A4, A5)
Xint y;
Xint x;
Xchar *fmt;
Xchar *A1, A2, A3, A4, A5;	/* really pointers */
X{
X  if (wmove(stdscr, y, x) == ERR) return(ERR);
X  wrefresh(stdscr);		/* set cursor */
X  if (wgetstr(stdscr, printscanbuf) == ERR)	/* get string */
X	return(ERR);
X  return(sscanf(printscanbuf, fmt, A1, A2, A3, A4, A5));
X}				/* mvscanw */
X
X/****************************************************************/
X/* Mvwscanw(win,y,x,fmt,args) moves window 'win's cursor to a	*/
X/* New position, then gets a string via 'win' and scans the	*/
X/* String using format 'fmt' to extract the values and put them	*/
X/* In the variables pointed to the arguments.			*/
X/****************************************************************/
Xint mvwscanw(win, y, x, fmt, A1, A2, A3, A4, A5)
XWINDOW *win;
Xint y;
Xint x;
Xchar *fmt;
Xchar *A1, A2, A3, A4, A5;	/* really pointers */
X{
X  if (wmove(win, y, x) == ERR) return(ERR);
X  wrefresh(win);		/* set cursor */
X  if (wgetstr(win, printscanbuf) == ERR)	/* get string */
X	return(ERR);
X  return(sscanf(printscanbuf, fmt, A1, A2, A3, A4, A5));
X}				/* mvwscanw */
/
echo x - refresh.c
sed '/^X/s///' > refresh.c << '/'
X/* refresh.c */
X
X#include <curses.h>
X#include "curspriv.h"
X
X/* Wrefresh() updates window win's area of the physical screen.	*/
Xvoid wrefresh(win)
XWINDOW *win;
X{
X  if (win == curscr)
X	curscr->_clear = TRUE;
X  else
X	wnoutrefresh(win);
X  doupdate();
X}
X
X/****************************************************************/
X/* Wnoutrefresh() updates the image of the desired screen,	*/
X/* Without doing physical update (copies window win's image to	*/
X/* The _cursvar.tmpwin window, which is hidden from the user).	*/
X/****************************************************************/
X
Xvoid wnoutrefresh(win)
Xregister WINDOW *win;
X{
X  register int *dst;		/* start destination in temp window */
X  register int *end;		/* end destination in temp window */
X  register int *src;		/* source in user window */
X  register int first;		/* first changed char on line */
X  register int last;		/* last changed char on line */
X  WINDOW *nscr;
X  int begy;			/* window's place on screen */
X  int begx;
X  int i;
X  int j;
X
X  nscr = _cursvar.tmpwin;
X  begy = win->_begy;
X  begx = win->_begx;
X
X  for (i = 0, j = begy; i <= win->_maxy; i++, j++) {
X	if (win->_minchng[i] != _NO_CHANGE) {
X		first = win->_minchng[i];
X		last = win->_maxchng[i];
X		dst = &(nscr->_line[j][begx + first]);
X		end = &(nscr->_line[j][begx + last]);
X		src = &(win->_line[i][first]);
X
X		while (dst <= end)	/* copy user line to temp window */
X			*dst++ = *src++;
X
X		first += begx;	/* nscr's min/max change positions */
X		last += begx;
X
X		if ((nscr->_minchng[j] == _NO_CHANGE) || (nscr->_minchng[j] > first))
X			nscr->_minchng[j] = first;
X		if (last > nscr->_maxchng[j]) nscr->_maxchng[j] = last;
X
X		win->_minchng[i] = _NO_CHANGE;	/* updated now */
X	}			/* if */
X	win->_maxchng[i] = _NO_CHANGE;	/* updated now */
X  }				/* for */
X
X  if (win->_clear) {
X	win->_clear = FALSE;
X	nscr->_clear = TRUE;
X  }				/* if */
X  if (!win->_leave) {
X	nscr->_cury = win->_cury + begy;
X	nscr->_curx = win->_curx + begx;
X  }				/* if */
X}				/* wnoutrefresh */
/
echo x - scrreg.c
sed '/^X/s///' > scrreg.c << '/'
X/****************************************************************/
X/* Wsetscrreg() routine of the PCcurses package			*/
X/*								*/
X/****************************************************************/
X/* This version of curses is based on ncurses, a curses version	*/
X/* Originally written by Pavel Curtis at Cornell University.	*/
X/* I have made substantial changes to make it run on IBM PC's,	*/
X/* And therefore consider myself free to make it public domain.	*/
X/*		Bjorn Larsson (...mcvax!enea!infovax!bl)	*/
X/****************************************************************/
X/* 1.0:	Release:					870515	*/
X/****************************************************************/
X/* Modified to run under the MINIX operating system by Don Cope */
X/* These changes are also released into the public domain.      */
X/* 							900906  */
X/****************************************************************/
X
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Wsetscrreg() set the scrolling region of window 'win' to in-	*/
X/* Clude all lines between 'top' and 'bottom'.			*/
X/****************************************************************/
X
Xint wsetscrreg(win, top, bottom)
XWINDOW *win;
Xint top;
Xint bottom;
X{
X  if ((0 <= top) &&
X      (top <= win->_cury)
X      &&
X      (win->_cury <= bottom)
X      &&
X      (bottom <= win->_maxy)
X	) {
X	win->_regtop = top;
X	win->_regbottom = bottom;
X	return(OK);
X  }
X
X   /* If */ 
X  else
X	return(ERR);
X}				/* wsetscrreg */
X
X/****************************************************************/
X/* Setscrreg() set the scrolling region of stdscr to include	*/
X/* All lines between 'top' and 'bottom'.			*/
X/****************************************************************/
X
Xint setscrreg(top, bottom)
Xint top;
Xint bottom;
X{
X  return(wsetscrreg(stdscr, top, bottom));
X}				/* setscrreg */
/
echo x - setterm.c
sed '/^X/s///' > setterm.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
Xvoid raw()
X{
X  _cursvar.rawmode = TRUE;
X  _tty.sg_flags |= RAW;
X  stty(0, &_tty);
X}				/* raw */
X
Xvoid noraw()
X{
X  _cursvar.rawmode = FALSE;
X  _tty.sg_flags &= ~RAW;
X  stty(0, &_tty);
X}				/* noraw */
X
Xvoid echo()
X{
X  _cursvar.echoit = TRUE;
X  _tty.sg_flags |= ECHO;
X  stty(0, &_tty);
X}
X
Xvoid noecho()
X{
X  _cursvar.echoit = FALSE;
X  _tty.sg_flags &= ~ECHO;
X  stty(0, &_tty);
X}
X
Xvoid nl()
X{
X  _tty.sg_flags |= CRMOD;
X  NONL = FALSE;
X  stty(0, &_tty);
X}				/* nl */
X
Xvoid nonl()
X{
X  _tty.sg_flags &= ~CRMOD;
X  NONL = TRUE;
X  stty(0, &_tty);
X}				/* nonl */
X
Xvoid cbreak()
X{
X  _tty.sg_flags |= CBREAK;
X  _cursvar.rawmode = TRUE;
X  stty(0, &_tty);
X}				/* cbreak */
X
Xvoid nocbreak()
X{
X  _tty.sg_flags &= ~CBREAK;
X  _cursvar.rawmode = FALSE;
X  stty(0, &_tty);
X}				/* nocbreak */
/
echo x - tabsize.c
sed '/^X/s///' > tabsize.c << '/'
X/****************************************************************/
X/* Tabsize() routines of the PCcurses package			*/
X/*								*/
X/****************************************************************/
X/* This version of curses is based on ncurses, a curses version	*/
X/* Originally written by Pavel Curtis at Cornell University.	*/
X/* I have made substantial changes to make it run on IBM PC's,	*/
X/* And therefore consider myself free to make it public domain.	*/
X/*		Bjorn Larsson (...mcvax!enea!infovax!bl)	*/
X/****************************************************************/
X/* 1.0:	Release:					870515	*/
X/****************************************************************/
X/* Modified to run under the MINIX operating system by Don Cope */
X/* These changes are also released into the public domain.      */
X/* 							900906  */
X/****************************************************************/
X
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Wtabsize(win,ts) sets the tabsize of window 'win' to 'ts',	*/
X/* And returns the original value.				*/
X/****************************************************************/
X
Xint wtabsize(win, ts)
XWINDOW *win;
Xint ts;
X{
X  int origval;
X
X  origval = win->_tabsize;
X  win->_tabsize = ts;
X  return(origval);
X}				/* wtabsize */
X
X/****************************************************************/
X/* Tabsize(ts) sets the tabsize of stdscr to 'ts', and returns	*/
X/* The original value.						*/
X/****************************************************************/
X
Xint tabsize(ts)
Xint ts;
X{
X  int origval;
X
X  origval = stdscr->_tabsize;
X  stdscr->_tabsize = ts;
X  return(origval);
X}				/* tabsize */
/
echo x - termmisc.c
sed '/^X/s///' > termmisc.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/* Static variables or saving terminal modes */
X
Xint fixterm()
X{
X  return(OK);
X}				/* fixterm */
X
Xint resetterm()
X{
X  return(OK);
X}
X
Xint saveoldterm()
X{
X  return(OK);
X}				/* saveoldterm */
X
Xint saveterm()
X{
X  return(OK);
X}				/* saveterm */
X
Xint baudrate()
X{
X  return(19200);
X}				/* baudrate */
X
X/****************************************************************/
X/* Erasechar(), killchar() returns std MSDOS erase chars.	*/
X/****************************************************************/
X
Xint erasechar()
X{
X  return(_DCCHAR);		/* character delete char */
X}				/* erasechar */
X
Xint killchar()
X{
X  return(_DLCHAR);		/* line delete char */
X}				/* killchar */
X
X/****************************************************************/
X/* Savetty() and resetty() saves and restores the terminal I/O	*/
X/* Settings.							*/
X/****************************************************************/
X
Xint savetty()
X{
X  return(OK);
X}				/* savetty */
X
X/****************************************************************/
X/* Setupterm() sets up the terminal. On a PC, it is always suc-	*/
X/* Cessful, and returns 1.					*/
X/****************************************************************/
X
Xint setupterm()
X{
X  return(1);
X}				/* setupterm */
/
echo x - unctrl.c
sed '/^X/s///' > unctrl.c << '/'
X/****************************************************************/
X/* Unctrl() routines of the PCcurses package			*/
X/*								*/
X/****************************************************************/
X/* This version of curses is based on ncurses, a curses version	*/
X/* Originally written by Pavel Curtis at Cornell University.	*/
X/* I have made substantial changes to make it run on IBM PC's,	*/
X/* And therefore consider myself free to make it public domain.	*/
X/*		Bjorn Larsson (...mcvax!enea!infovax!bl)	*/
X/****************************************************************/
X/* 1.0:	Release:					870515	*/
X/****************************************************************/
X/* Modified to run under the MINIX operating system by Don Cope */
X/* These changes are also released into the public domain.      */
X/* 							900906  */
X/****************************************************************/
X
X#include <curses.h>
X#include "curspriv.h"
X
Xstatic char strbuf[3] = {0, 0, 0};
X
X/****************************************************************/
X/* Unctrl() returns a char pointer to a string corresponding to	*/
X/* Argument character 'c'.					*/
X/****************************************************************/
X
Xchar *unctrl(c)
Xchar c;
X{
X  int ic = c;
X  ic &= 0xff;
X
X  if ((ic >= ' ') && (ic != 0x7f)) {	/* normal characters */
X	strbuf[0] = ic;
X	strbuf[1] = '\0';
X	return(strbuf);
X  }				/* if */
X  strbuf[0] = '^';		/* '^' prefix */
X  if (c == 0x7f)		/* DEL */
X	strbuf[1] = '?';
X  else				/* other control */
X	strbuf[1] = ic + '@';
X  return(strbuf);
X}				/* unctrl */
/
echo x - update.c
sed '/^X/s///' > update.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X#include <termcap.h>
X
Xstatic WINDOW *twin;		/* used by many routines */
X
X/****************************************************************/
X/* Gotoxy() moves the physical cursor to the desired address on */
X/* The screen. We don't optimize here - on a PC, it takes more  */
X/* Time to optimize than to do things directly.                 */
X/****************************************************************/
X
X_PROTOTYPE(static void gotoxy, (int row, int col ));
X_PROTOTYPE(static void newattr, (int ch ));
X_PROTOTYPE(static void Putchar, (int ch ));
X_PROTOTYPE(static void clrupdate, (WINDOW *scr ));
X_PROTOTYPE(static void transformline, (int lineno ));
X
Xstatic void gotoxy(row, col)
Xint row, col;
X{
X  poscur(row, col);
X  _cursvar.cursrow = row;
X  _cursvar.curscol = col;
X}
X
X/* Update attributes */
Xstatic void newattr(ch)
Xint ch;
X{
X  extern char *me, *as, *ae, *mb, *md, *mr, *so, *us;
X  static int lastattr = 0;
X
X  if (lastattr != (ch &= ATR_MSK)) {
X	lastattr = ch;
X
X	tputs(me, 1, outc);
X	if (ae) tputs(ae, 1, outc);
X
X	if (ch & A_ALTCHARSET)
X		if (as) tputs(as, 1, outc);
X	if (ch & A_BLINK) tputs(mb, 1, outc);
X	if (ch & A_BOLD) tputs(md, 1, outc);
X	if (ch & A_REVERSE) tputs(mr, 1, outc);
X	if (ch & A_STANDOUT) tputs(so, 1, outc);
X	if (ch & A_UNDERLINE) tputs(us, 1, outc);
X  }
X}
X
X/* Putchar() writes a character, with attributes, to the physical
X   screen, but avoids writing to the lower right screen position.
X   Should it care about am?
X*/
X
X/* Output char with attribute */
Xstatic void Putchar(ch)
Xint ch;
X{
X  if ((_cursvar.cursrow < LINES) || (_cursvar.curscol < COLS)) {
X	newattr(ch);
X	putchar(ch);
X  }
X}
X
X/****************************************************************/
X/* Clrupdate(scr) updates the screen by clearing it and then    */
X/* Redraw it in it's entirety.					*/
X/****************************************************************/
X
Xstatic void clrupdate(scr)
XWINDOW *scr;
X{
X  register int *src;
X  register int *dst;
X  register int i;
X  register int j;
X  WINDOW *w;
X
X  w = curscr;
X
X  if (scr != w) {		/* copy scr to curscr */
X	for (i = 0; i < LINES; i++) {
X		src = scr->_line[i];
X		dst = w->_line[i];
X		for (j = 0; j < COLS; j++) *dst++ = *src++;
X	}			/* for */
X  }				/* if */
X  newattr(scr->_attrs);
X  clrscr();
X  scr->_clear = FALSE;
X  for (i = 0; i < LINES; i++) {	/* update physical screen */
X	src = w->_line[i];
X	j = 0;
X	while (j < COLS) {
X		if (*src != (' ' | ATR_NRM)) {
X			gotoxy(i, j);
X			while (j < COLS && (*src != (' ' | ATR_NRM))) {
X				Putchar(*src++);
X				j++;
X			}
X		} else {
X			src++;
X			j++;
X		}
X	}			/* for */
X  }				/* for */
X  fflush(stdout);
X}				/* clrupdate */
X
X/****************************************************************/
X/* Transformline() updates the given physical line to look      */
X/* Like the corresponding line in _cursvar.tmpwin.		*/
X/****************************************************************/
X
Xstatic void transformline(lineno)
Xregister int lineno;
X{
X  register int *dstp;
X  register int *srcp;
X  register int dstc;
X  register int srcc;
X  int x;
X  int endx;
X
X  x = twin->_minchng[lineno];
X  endx = twin->_maxchng[lineno];
X  dstp = curscr->_line[lineno] + x;
X  srcp = twin->_line[lineno] + x;
X
X  while (x <= endx) {
X	if ((*dstp != *srcp) || (dstc != srcc)) {
X		gotoxy(lineno, x);
X		while (x <= endx && ((*dstp != *srcp) || (dstc != srcc))) {
X			Putchar(*srcp);
X			*dstp++ = *srcp++;
X			x++;
X		}
X	} else {
X		*dstp++ = *srcp++;
X		x++;
X	}
X  }				/* for */
X  twin->_minchng[lineno] = _NO_CHANGE;
X  twin->_maxchng[lineno] = _NO_CHANGE;
X}				/* transformline */
X
X/****************************************************************/
X/* Doupdate() updates the physical screen to look like _curs-   */
X/* Var.tmpwin if curscr is not 'Clear-marked'. Otherwise it     */
X/* Updates the screen to look like curscr.                      */
X/****************************************************************/
X
Xvoid doupdate()
X{
X  int i;
X
X  twin = _cursvar.tmpwin;
X  if (curscr->_clear)
X	clrupdate(curscr);
X  else {
X	if (twin->_clear)
X		clrupdate(twin);
X	else {
X		for (i = 0; i < LINES; i++)
X			if (twin->_minchng[i] != _NO_CHANGE)
X				transformline(i);
X	}
X  }
X  curscr->_curx = twin->_curx;
X  curscr->_cury = twin->_cury;
X  gotoxy(curscr->_cury, curscr->_curx);
X  fflush(stdout);
X}				/* doupdate */
/
echo x - waddch.c
sed '/^X/s///' > waddch.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Newline() does line advance and returns the new cursor line.	*/
X/* If error, return -1.						*/
X/****************************************************************/
X
X_PROTOTYPE( static short newline, (WINDOW *win, int lin));
X
Xstatic short newline(win, lin)
XWINDOW *win;
Xint lin;
X{
X  if (++lin > win->_regbottom) {
X	lin--;
X	if (win->_scroll)
X		scroll(win);
X	else
X		return(-1);
X  }				/* if */
X  return(lin);
X}				/* newline */
X
X/****************************************************************/
X/* Waddch() inserts character 'c' at the current cursor posi-	*/
X/* Tion in window 'win', and takes any actions as dictated by	*/
X/* The character.						*/
X/****************************************************************/
X
Xint waddch(win, c)
XWINDOW *win;
Xint c;
X{
X  int x = win->_curx;
X  int y = win->_cury;
X  int newx;
X  int ch = c;
X  int ts = win->_tabsize;
X
X  ch &= (A_ALTCHARSET | 0xff);
X  if (y > win->_maxy || x > win->_maxx || y < 0 || x < 0) return(ERR);
X  switch (ch) {
X      case '\t':
X	for (newx = ((x / ts) + 1) * ts; x < newx; x++) {
X		if (waddch(win, ' ') == ERR) return(ERR);
X		if (win->_curx == 0)	/* if tab to next line */
X			return(OK);	/* exit the loop */
X	}
X	return(OK);
X
X      case '\n':
X	if (NONL) x = 0;
X	if ((y = newline(win, y)) < 0) return (ERR);
X	break;
X
X      case '\r':	x = 0;	break;
X
X      case '\b':
X	if (--x < 0)		/* no back over left margin */
X		x = 0;
X	break;
X
X      case 0x7f:
X	{
X		if (waddch(win, '^') == ERR) return(ERR);
X		return(waddch(win, '?'));
X	}
X
X      default:
X	if (ch < ' ') {		/* handle control chars */
X		if (waddch(win, '^') == ERR) return(ERR);
X		return(waddch(win, c + '@'));
X	}
X	ch |= (win->_attrs & ATR_MSK);
X	if (win->_line[y][x] != ch) {	/* only if data change */
X		if (win->_minchng[y] == _NO_CHANGE)
X			win->_minchng[y] = win->_maxchng[y] = x;
X		else if (x < win->_minchng[y])
X			win->_minchng[y] = x;
X		else if (x > win->_maxchng[y])
X			win->_maxchng[y] = x;
X	}			/* if */
X	win->_line[y][x++] = ch;
X	if (x > win->_maxx) {	/* wrap around test */
X		x = 0;
X		if ((y = newline(win, y)) < 0) return(ERR);
X	}
X	break;
X
X  }				/* switch */
X  win->_curx = x;
X  win->_cury = y;
X  return(OK);
X}
/
echo x - waddstr.c
sed '/^X/s///' > waddstr.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Waddstr() inserts string 'str' at the current cursor posi-	*/
X/* Tion in window 'win', and takes any actions as dictated by	*/
X/* The characters.						*/
X/****************************************************************/
X
Xint waddstr(win, str)
XWINDOW *win;
Xchar *str;
X{
X  while (*str) {
X	if (waddch(win, *str++) == ERR) return(ERR);
X  }
X  return(OK);
X}
/
echo x - wbox.c
sed '/^X/s///' > wbox.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Wbox(win,ymin,xmin,ymax,xmax,v,h) draws a box in window	*/
X/* 'win', enclosing the area xmin-xmax and ymin-xmax. If	*/
X/* Xmax and/or ymax is 0, the window max value is used. 'v' and	*/
X/* 'h' are the vertical and horizontal characters to use. If	*/
X/* 'v' and 'h' are 0, wbox will use the alternate character set */
X/* In a pretty way.						*/
X/****************************************************************/
X
Xint wbox(win, ymin, xmin, ymax, xmax, v, h)
XWINDOW *win;
Xint ymin, xmin, ymax, xmax;
Xunsigned int v;
Xunsigned int h;
X{
X  unsigned int vc, hc, ulc, urc, llc, lrc;	/* corner chars */
X  int i;
X
X  if (ymax == 0) ymax = win->_maxy;
X  if (xmax == 0) xmax = win->_maxx;
X
X  if (ymin >= win->_maxy || ymax > win->_maxy ||
X      xmin >= win->_maxx || xmax > win->_maxx ||
X      ymin >= ymax || xmin >= xmax)
X	return(ERR);
X
X  vc = v;
X  hc = h;
X  ulc = urc = llc = lrc = vc;	/* default same as vertical */
X
X  if (v == 0 && h == 0) {
X	ulc = ACS_ULCORNER;
X	urc = ACS_URCORNER;
X	llc = ACS_LLCORNER;
X	lrc = ACS_LRCORNER;
X	hc = ACS_HLINE;
X	vc = ACS_VLINE;
X  }
X  for (i = xmin + 1; i <= xmax - 1; i++) {
X	win->_line[ymin][i] = hc | win->_attrs;
X	win->_line[ymax][i] = hc | win->_attrs;
X  }
X  for (i = ymin + 1; i <= ymax - 1; i++) {
X	win->_line[i][xmin] = vc | win->_attrs;
X	win->_line[i][xmax] = vc | win->_attrs;
X  }
X  win->_line[ymin][xmin] = ulc | win->_attrs;
X  win->_line[ymin][xmax] = urc | win->_attrs;
X  win->_line[ymax][xmin] = llc | win->_attrs;
X  win->_line[ymax][xmax] = lrc | win->_attrs;
X
X  for (i = ymin; i <= ymax; i++) {
X	if (win->_minchng[i] == _NO_CHANGE) {
X		win->_minchng[i] = xmin;
X		win->_maxchng[i] = xmax;
X	} else {
X		win->_minchng[i] = min(win->_minchng[i], xmin);
X		win->_maxchng[i] = max(win->_maxchng[i], xmax);
X	}
X  }
X  return(OK);
X}
/
echo x - wclear.c
sed '/^X/s///' > wclear.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Wclear() fills all lines of window 'win' with blanks, and	*/
X/* Marks the window to be cleared at next refresh operation.	*/
X/****************************************************************/
X
Xvoid wclear(win)
XWINDOW *win;
X{
X  werase(win);
X  win->_clear = TRUE;
X}				/* wclear */
/
echo x - wclrtobot.c
sed '/^X/s///' > wclrtobot.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Wclrtobot() fills the right half of the cursor line of	*/
X/* Window 'win', and all lines below it with blanks.		*/
X/****************************************************************/
X
Xint wclrtobot(win)
XWINDOW *win;
X{
X  int y, minx, startx, *ptr, *end, *maxx, blank;
X
X  blank = ' ' | (win->_attrs & ATR_MSK);
X  startx = win->_curx;
X  for (y = win->_cury; y <= win->_regbottom; y++) {
X	minx = _NO_CHANGE;
X	end = &win->_line[y][win->_maxx];
X	for (ptr = &win->_line[y][startx]; ptr <= end; ptr++) {
X		if (*ptr != blank) {
X			maxx = ptr;
X			if (minx == _NO_CHANGE) minx = ptr - win->_line[y];
X			*ptr = blank;
X		}		/* if */
X	}			/* for */
X	if (minx != _NO_CHANGE) {
X		if ((win->_minchng[y] > minx) || (win->_minchng[y] == _NO_CHANGE))
X			win->_minchng[y] = minx;
X		if (win->_maxchng[y] < maxx - win->_line[y])
X			win->_maxchng[y] = maxx - win->_line[y];
X	}			/* if */
X	startx = 0;
X  }
X  return(OK);
X}
/
echo x - wclrtoeol.c
sed '/^X/s///' > wclrtoeol.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Wclrtoeol() fills the half of the cursor line to the right	*/
X/* Of the cursor in window 'win' with blanks.			*/
X/****************************************************************/
X
Xint wclrtoeol(win)
XWINDOW *win;
X{
X  int *maxx, *ptr, *end, y, x, minx, blank;
X
X  y = win->_cury;
X  x = win->_curx;
X  blank = ' ' | (win->_attrs & ATR_MSK);
X
X  end = &win->_line[y][win->_maxx];
X  minx = _NO_CHANGE;
X  maxx = &win->_line[y][x];
X  for (ptr = maxx; ptr <= end; ptr++) {
X	if (*ptr != blank) {
X		maxx = ptr;
X		if (minx == _NO_CHANGE) minx = ptr - win->_line[y];
X		*ptr = blank;
X	}			/* if */
X  }				/* for */
X
X  if (minx != _NO_CHANGE) {
X	if (win->_minchng[y] > minx || win->_minchng[y] == _NO_CHANGE)
X		win->_minchng[y] = minx;
X	if (win->_maxchng[y] < maxx - win->_line[y])
X		win->_maxchng[y] = maxx - win->_line[y];
X  }
X  return(OK);
X}
/
echo x - wdelch.c
sed '/^X/s///' > wdelch.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/* Wdelch() deletes the character at the window cursor, and the
X   characters to the right of it are shifted left, inserting a
X   space at the last position of the line.
X*/
X
Xint wdelch(win)
XWINDOW *win;
X{
X  int *temp1;
X  int *temp2;
X  int *end;
X  int y = win->_cury;
X  int x = win->_curx;
X  int maxx = win->_maxx;
X
X  end = &win->_line[y][maxx];
X  temp1 = &win->_line[y][x];
X  temp2 = temp1 + 1;
X  while (temp1 < end) *temp1++ = *temp2++;
X  *temp1 = ' ' | (win->_attrs & ATR_MSK);
X  win->_maxchng[y] = maxx;
X  if (win->_minchng[y] == _NO_CHANGE || win->_minchng[y] > x)
X	win->_minchng[y] = x;
X  return(OK);
X}
/
echo x - wdeleteln.c
sed '/^X/s///' > wdeleteln.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Wdeleteln() deletes the line at the window cursor, and the	*/
X/* Lines below it are shifted up, inserting a blank line at	*/
X/* The bottom of the window.					*/
X/****************************************************************/
X
Xint wdeleteln(win)
XWINDOW *win;
X{
X  int *end, *temp, y, blank;
X
X  blank = ' ' | (win->_attrs & ATR_MSK);
X
X  temp = win->_line[win->_cury];
X  for (y = win->_cury; y < win->_regbottom; y++) {
X	win->_line[y] = win->_line[y + 1];
X	win->_minchng[y] = 0;
X	win->_maxchng[y] = win->_maxx;
X  }
X  win->_minchng[y] = 0;
X  win->_maxchng[y] = win->_maxx;
X  win->_line[win->_regbottom] = temp;
X  for (end = &(temp[win->_maxx]); temp <= end;) *temp++ = blank;
X  return(OK);
X}
/
echo x - werase.c
sed '/^X/s///' > werase.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Werase() fills all lines of window 'win' with blanks and po-	*/
X/* Sitions the cursor at home in the scroll region.		*/
X/****************************************************************/
X
Xvoid werase(win)
XWINDOW *win;
X{
X  int *end, *start, y, blank;
X
X  blank = ' ' | (win->_attrs & ATR_MSK);
X
X  for (y = win->_regtop; y <= win->_regbottom; y++) {	/* clear all lines */
X	start = win->_line[y];
X	end = &start[win->_maxx];
X	while (start <= end)	/* clear all line */
X		*start++ = blank;
X	win->_minchng[y] = 0;
X	win->_maxchng[y] = win->_maxx;
X  }
X  win->_cury = win->_regtop;	/* cursor home */
X  win->_curx = 0;
X}
/
echo x - wgetch.c
sed '/^X/s///' > wgetch.c << '/'
X#include <curses.h>
X#include <stdio.h>
X#include "curspriv.h"
X
Xint wgetch(win)
XWINDOW *win;
X{
X  bool weset = FALSE;
X  char inp;
X
X  if (!win->_scroll && (win->_flags & _FULLWIN)
X      && win->_curx == win->_maxx - 1 && win->_cury == win->_maxy - 1)
X	return ERR;
X  if (_cursvar.echoit && !_cursvar.rawmode) {
X	cbreak();
X	weset++;
X  }
X  inp = getchar();
X  if (_cursvar.echoit) {
X	mvwaddch(curscr, win->_cury + win->_begy,
X		 win->_curx + win->_begx, inp);
X	waddch(win, inp);
X  }
X  if (weset) nocbreak();
X  return inp;
X}
/
echo x - wgetstr.c
sed '/^X/s///' > wgetstr.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Wgetstr(win,str) reads in a string (terminated by \n or \r)	*/
X/* To the buffer pointed to by 'str', and displays the input	*/
X/* In window 'win'. The user's erase and kill characters are	*/
X/* Active.							*/
X/****************************************************************/
X
Xint wgetstr(win, str)
XWINDOW *win;
Xchar *str;
X{
X  while ((*str = wgetch(win)) != ERR && *str != '\n') str++;
X  if (*str == ERR) {
X	*str = '\0';
X	return ERR;
X  }
X  *str = '\0';
X  return OK;
X}
/
echo x - windel.c
sed '/^X/s///' > windel.c << '/'
X/****************************************************************/
X/* Delwin() routine of the PCcurses package.			*/
X/*								*/
X/****************************************************************/
X/* This version of curses is based on ncurses, a curses version	*/
X/* Originally written by Pavel Curtis at Cornell University.	*/
X/* I have made substantial changes to make it run on IBM PC's,	*/
X/* And therefore consider myself free to make it public domain.	*/
X/*		Bjorn Larsson (...mcvax!enea!infovax!bl)	*/
X/****************************************************************/
X/* 1.0:	Release:					870515	*/
X/****************************************************************/
X/* Modified to run under the MINIX operating system by Don Cope */
X/* These changes are also released into the public domain.      */
X/* 							900906  */
X/****************************************************************/
X
X#include <stdlib.h>
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Delwin() deallocates all data allocated by 'win'. If 'win'	*/
X/* Is a subwindow, it uses the original window's lines for sto-	*/
X/* Rage, and thus the line arrays are not deallocated.		*/
X/****************************************************************/
X
Xvoid delwin(win)
XWINDOW *win;
X{
X  int i;
X
X  if (!(win->_flags & _SUBWIN)) {	/* subwindow uses 'parent's' lines */
X	for (i = 0; i <= win->_maxy && win->_line[i]; i++)
X		free(win->_line[i]);
X  }
X  free(win->_minchng);
X  free(win->_maxchng);
X  free(win->_line);
X  free(win);
X}				/* delwin */
/
echo x - winmove.c
sed '/^X/s///' > winmove.c << '/'
X/****************************************************************/
X/* Mvwin() routine of the PCcurses package			*/
X/*								*/
X/****************************************************************/
X/* This version of curses is based on ncurses, a curses version	*/
X/* Originally written by Pavel Curtis at Cornell University.	*/
X/* I have made substantial changes to make it run on IBM PC's,	*/
X/* And therefore consider myself free to make it public domain.	*/
X/*		Bjorn Larsson (...mcvax!enea!infovax!bl)	*/
X/****************************************************************/
X/* 1.0:	Release:					870515	*/
X/****************************************************************/
X/* Modified to run under the MINIX operating system by Don Cope */
X/* These changes are also released into the public domain.      */
X/* 							900906  */
X/****************************************************************/
X
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Mvwin() moves window 'win' to position (begx, begy) on the	*/
X/* Screen.							*/
X/****************************************************************/
X
Xint mvwin(win, begy, begx)
XWINDOW *win;
Xint begy, begx;
X{
X  if ((begy + win->_maxy) > (LINES - 1) || (begx + win->_maxx) > (COLS - 1))
X	return(ERR);
X  win->_begy = begy;
X  win->_begx = begx;
X  touchwin(win);
X  return(OK);
X}				/* mvwin */
/
echo x - winsch.c
sed '/^X/s///' > winsch.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/* Winsch() inserts character 'c' at the cursor position in
X   window 'win'. The cursor is advanced.
X*/
X
Xint winsch(win, c)
XWINDOW *win;
Xchar c;
X{
X  int *temp1;
X  int *temp2;
X  int *end;
X  int x = win->_curx;
X  int y = win->_cury;
X  int maxx = win->_maxx;
X
X  if ((c < ' ') && (c == '\n' || c == '\r' || c == '\t' || c == '\b'))
X	return(waddch(win, c));
X  end = &win->_line[y][x];
X  temp1 = &win->_line[y][maxx];
X  temp2 = temp1 - 1;
X  if (c < ' ')			/* if CTRL-char make space for 2 */
X	temp2--;
X  while (temp1 > end) *temp1-- = *temp2--;
X  win->_maxchng[y] = maxx;
X  if ((win->_minchng[y] == _NO_CHANGE) || (win->_minchng[y] > x))
X	win->_minchng[y] = x;
X  return(waddch(win, c));	/* fixes CTRL-chars too */
X}				/* winsch */
/
echo x - winscrol.c
sed '/^X/s///' > winscrol.c << '/'
X/****************************************************************/
X/* Scroll() routine of the PCcurses package			*/
X/*								*/
X/****************************************************************/
X/* This version of curses is based on ncurses, a curses version	*/
X/* Originally written by Pavel Curtis at Cornell University.	*/
X/* I have made substantial changes to make it run on IBM PC's,	*/
X/* And therefore consider myself free to make it public domain.	*/
X/*		Bjorn Larsson (...mcvax!enea!infovax!bl)	*/
X/****************************************************************/
X/* 1.0:	Release:					870515	*/
X/****************************************************************/
X/* Modified to run under the MINIX operating system by Don Cope */
X/* These changes are also released into the public domain.      */
X/* 							900906  */
X/****************************************************************/
X
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Scroll() scrolls the scrolling region of 'win', but only if	*/
X/* Scrolling is allowed and if the cursor is inside the scrol-	*/
X/* Ling region.							*/
X/****************************************************************/
X
Xvoid scroll(win)
XWINDOW *win;
X{
X  int i;
X  int *ptr;
X  int *temp;
X  static int blank;
X
X  blank = ' ' | (win->_attrs & ATR_MSK);
X  if ((!win->_scroll)		/* check if window scrolls */
X      ||(win->_cury < win->_regtop)	/* and cursor in region */
X      ||(win->_cury > win->_regbottom)
X	)
X	return;
X
X  temp = win->_line[win->_regtop];
X  for (i = win->_regtop; i < win->_regbottom; i++) {
X	win->_line[i] = win->_line[i + 1];	/* re-arrange line pointers */
X	win->_minchng[i] = 0;
X	win->_maxchng[i] = win->_maxx;
X  }
X  for (ptr = temp; ptr - temp <= win->_maxx; ptr++)
X	*ptr = blank;		/* make a blank line */
X  win->_line[win->_regbottom] = temp;
X  if (win->_cury > win->_regtop)/* if not on top line */
X	win->_cury--;		/* cursor scrolls too */
X  win->_minchng[win->_regbottom] = 0;
X  win->_maxchng[win->_regbottom] = win->_maxx;
X}				/* scroll */
/
echo x - winsertln.c
sed '/^X/s///' > winsertln.c << '/'
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Winsertln() inserts a blank line instead of the cursor line	*/
X/* In window 'win' and pushes other lines down.			*/
X/****************************************************************/
X
Xint winsertln(win)
XWINDOW *win;
X{
X  int *temp, *end, y, blank;
X
X  blank = ' ' | (win->_attrs & ATR_MSK);
X  temp = win->_line[win->_regbottom];
X  for (y = win->_regbottom; y > win->_cury; y--) {
X	win->_line[y] = win->_line[y - 1];
X	win->_minchng[y] = 0;
X	win->_maxchng[y] = win->_maxx;
X  }
X  win->_line[win->_cury] = temp;
X  for (end = &temp[win->_maxx]; temp <= end; temp++) *temp = blank;
X  win->_minchng[win->_cury] = 0;
X  win->_maxchng[win->_cury] = win->_maxx;
X  return(OK);
X}
/
echo x - wintouch.c
sed '/^X/s///' > wintouch.c << '/'
X/****************************************************************/
X/* Touchwin() routine of the PCcurses package			*/
X/*								*/
X/****************************************************************/
X/* This version of curses is based on ncurses, a curses version	*/
X/* Originally written by Pavel Curtis at Cornell University.	*/
X/* I have made substantial changes to make it run on IBM PC's,	*/
X/* And therefore consider myself free to make it public domain.	*/
X/*		Bjorn Larsson (...mcvax!enea!infovax!bl)	*/
X/****************************************************************/
X/* 1.0:	Release:					870515	*/
X/****************************************************************/
X/* Modified to run under the MINIX operating system by Don Cope */
X/* These changes are also released into the public domain.      */
X/* 							900906  */
X/****************************************************************/
X
X#include <curses.h>
X#include "curspriv.h"
X
X/****************************************************************/
X/* Touchwin() marks all lines of window 'win' as changed, from	*/
X/* The first to the last character on the line.			*/
X/****************************************************************/
X
Xvoid touchwin(win)
XWINDOW *win;
X{
X  int y;
X  int maxy;
X  int maxx;
X
X  maxy = win->_maxy;
X  maxx = win->_maxx;
X
X  for (y = 0; y <= maxy; y++) {
X	win->_minchng[y] = 0;
X	win->_maxchng[y] = maxx;
X  }				/* for */
X}				/* touchwin */
/
