echo x - ctype.h.ansi
sed '/^X/s///' > ctype.h.ansi << '/'
X/* The <ctype.h> header file defines some macros used to identify characters.
X * It works by using a table stored in chartab.c. When a character is presented
X * to one of these macros, the character is used as an index into the table
X * (__ctype) to retrieve a byte.  The relevant bit is then extracted.
X */
X
X#ifndef _CTYPE_H
X#define _CTYPE_H
X
Xextern char	__ctype[];	/* property array defined in chartab.c */
X
X#define _U		0x01	/* this bit is for upper-case letters [A-Z] */
X#define _L		0x02	/* this bit is for lower-case letters [a-z] */
X#define _N		0x04	/* this bit is for numbers [0-9] */
X#define _S		0x08	/* this bit is for white space \t \n \f etc */
X#define _P		0x10	/* this bit is for punctuation characters */
X#define _C		0x20	/* this bit is for control characters */
X#define _X		0x40	/* this bit is for hex digits [a-f] and [A-F]*/
X
X/* Function Prototypes (have to go before the macros). */
X#ifndef _ANSI_H
X#include <ansi.h>
X#endif
X
X_PROTOTYPE( int isalnum, (int  _c)  );	/* alphanumeric [a-z], [A-Z], [0-9] */
X_PROTOTYPE( int isalpha, (int  _c)  );	/* alphabetic */
X_PROTOTYPE( int iscntrl, (int  _c)  );	/* control characters */
X_PROTOTYPE( int isdigit, (int  _c)  );	/* digit [0-9] */
X_PROTOTYPE( int isgraph, (int  _c)  );	/* graphic character */
X_PROTOTYPE( int islower, (int  _c)  );	/* lower-case letter [a-z] */
X_PROTOTYPE( int isprint, (int  _c)  );	/* printable character */
X_PROTOTYPE( int ispunct, (int  _c)  );	/* punctuation mark */
X_PROTOTYPE( int isspace, (int  _c)  );	/* white space sp, \f, \n, \r, \t, \v*/
X_PROTOTYPE( int isupper, (int  _c)  );	/* upper-case letter [A-Z] */
X_PROTOTYPE( int isxdigit,(int  _c)  );	/* hex digit [0-9], [a-f], [A-F] */
X_PROTOTYPE( int tolower, (int  _c)  );	/* convert to lower-case */
X_PROTOTYPE( int toupper, (int  _c)  );	/* convert to upper-case */
X
X/* Macros for identifying character classes. */
X#define isalnum(c)	((__ctype+1)[c]&(_U|_L|_N))
X#define isalpha(c)	((__ctype+1)[c]&(_U|_L))
X#define iscntrl(c)	((__ctype+1)[c]&_C)
X#define isgraph(c)	((__ctype+1)[c]&(_P|_U|_L|_N))
X#define ispunct(c)	((__ctype+1)[c]&_P)
X#define isspace(c)	((__ctype+1)[c]&_S)
X#define isxdigit(c)	((__ctype+1)[c]&(_N|_X))
X
X#define isdigit(c)	((unsigned) ((c)-'0') < 10)
X#define islower(c)	((unsigned) ((c)-'a') < 26)
X#define isupper(c)	((unsigned) ((c)-'A') < 26)
X#define isprint(c)	((unsigned) ((c)-' ') < 95)
X#define isascii(c)	((unsigned) (c) < 128)
X
X#endif /* _CTYPE_H */
/
echo x - ctype.h.kr
sed '/^X/s///' > ctype.h.kr << '/'
X/* The <ctype.h> header file defines some macros used to identify characters.
X * It works by using a table stored in ctype.c.  When a character is presented
X * to one of these macros, the character is used as an index into the table
X * (__ctype) to retrieve a byte.  The relevant bit is then extracted.
X */
X
X#ifndef _CTYPE_H
X#define _CTYPE_H
X
Xextern unsigned char __ctype[];	/* property array declared in ctype.c */
Xextern unsigned char __tmp;	/* scratch variable declared in ctype.c */
X
X#define _U		0001	/* this bit is for upper-case letters [A-Z] */
X#define _L		0002	/* this bit is for lower-case letters [a-z] */
X#define _N		0004	/* this bit is for numbers [0-9] */
X#define _S		0010	/* this bit is for white space \t \n \f etc */
X#define _P		0020	/* this bit is for punctuation characters */
X#define _C		0040	/* this bit is for control characters */
X#define _X		0100	/* this bit is for hex digits [a-f] and [A-F]*/
X#define _SP		0200	/* this bit is for the space character only */
X
X/* Function Prototypes (have to go before the macros). */
X#ifndef _ANSI_H
X#include <ansi.h>
X#endif
X
X_PROTOTYPE( int isalnum, (int  __c)  );	/* alphanumeric [a-z], [A-Z], [0-9] */
X_PROTOTYPE( int isalpha, (int  __c)  );	/* alphabetic */
X_PROTOTYPE( int iscntrl, (int  __c)  );	/* control characters */
X_PROTOTYPE( int isdigit, (int  __c)  );	/* digit [0-9] */
X_PROTOTYPE( int isgraph, (int  __c)  );	/* graphic character */
X_PROTOTYPE( int islower, (int  __c)  );	/* lower-case letter [a-z] */
X_PROTOTYPE( int isprint, (int  __c)  );	/* printable character */
X_PROTOTYPE( int ispunct, (int  __c)  );	/* punctuation mark */
X_PROTOTYPE( int isspace, (int  __c)  );	/* white space sp, \f, \n, \r, \t, \v*/
X_PROTOTYPE( int isupper, (int  __c)  );	/* upper-case letter [A-Z] */
X_PROTOTYPE( int isxdigit,(int  __c)  );	/* hex digit [0-9], [a-f], [A-F] */
X
X/* Macros for identifying character classes. */
X#define isalnum(c)	((__ctype+1)[c]&(_U|_L|_N))
X#define isalpha(c)	((__ctype+1)[c]&(_U|_L))
X#define iscntrl(c)	((__ctype+1)[c]&_C)
X#define isdigit(c)	((__ctype+1)[c]&_N)
X#define isgraph(c)	((__ctype+1)[c]&(_P|_U|_L|_N))
X#define islower(c)	((__ctype+1)[c]&_L)
X#define isprint(c)	((__ctype+1)[c]&(_SP|_P|_U|_L|_N))
X#define ispunct(c)	((__ctype+1)[c]&_P)
X#define isspace(c)	((__ctype+1)[c]&_S)
X#define isupper(c)	((__ctype+1)[c]&_U)
X#define isxdigit(c)	((__ctype+1)[c]&(_N|_X))
X#define isascii(c)	((unsigned) ((c) + 1) < 129)
X
X/* The following two macros are weird to keep the Language Police at bay.
X * The macro 'tolower' only affects upper case letters, and 'toupper'
X * only affects lower case letters.  Neither one is permitted to evaluate
X * its argument more than once.  Thus a simple definition like:
X *
X *	#define tolower(c)	(isupper(c) ? c - 'A' + 'a' : c)
X *
X * is prohibited because the argument 'c' is evaluated twice.
X * It might be an expression that has side effects, such as a function
X * call that increments a counter and returns its value as a character.
X * The solution is to first copy the argument to a scratch variable, __tmp.
X */
X
X#define tolower(c) (__tmp = (c), isupper(__tmp) ? __tmp - 'A' + 'a' : __tmp)
X#define toupper(c) (__tmp = (c), islower(__tmp) ? __tmp - 'a' + 'A' : __tmp)
X
X#endif /* _CTYPE_H */
/
echo x - out.h
sed '/^X/s///' > out.h << '/'
X#ifndef _OUT_H
X#define _OUT_H
X/*
X * (c) copyright 1988 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the file "../Copyright".
X */
X/*
X * output format for ACK assemblers
X */
X#ifndef ushort
X#define ushort	unsigned short
X#endif /* ushort */
X
Xstruct outhead {
X	ushort 	oh_magic;	/* magic number */
X	ushort 	oh_stamp;	/* version stamp */
X	ushort	oh_flags;	/* several format flags */
X	ushort	oh_nsect;	/* number of outsect structures */
X	ushort	oh_nrelo;	/* number of outrelo structures */
X	ushort	oh_nname;	/* number of outname structures */
X	long	oh_nemit;	/* sum of all os_flen */
X	long	oh_nchar;	/* size of string area */
X};
X
X#define O_MAGIC	0x0201		/* magic number of output file */
X#define	O_STAMP	0		/* version stamp */
X#define MAXSECT	64		/* Maximum number of sections */
X
X#define	HF_LINK	0x0004		/* unresolved references left */
X#define	HF_8086	0x0008		/* os_base specially encoded */
X
Xstruct outsect {
X	long 	os_base;	/* startaddress in machine */
X	long	os_size;	/* section size in machine */
X	long	os_foff;	/* startaddress in file */
X	long	os_flen;	/* section size in file */
X	long	os_lign;	/* section alignment */
X};
X
Xstruct outrelo {
X	char	or_type;	/* type of reference */
X	char	or_sect;	/* referencing section */
X	ushort	or_nami;	/* referenced symbol index */
X	long	or_addr;	/* referencing address */
X};
X
Xstruct outname {
X	union {
X	  char	*on_ptr;	/* symbol name (in core) */
X	  long	on_off;		/* symbol name (in file) */
X	}	on_u;
X#define on_mptr	on_u.on_ptr
X#define on_foff	on_u.on_off
X	ushort	on_type;	/* symbol type */
X	ushort	on_desc;	/* debug info */
X	long	on_valu;	/* symbol value */
X};
X
X/*
X * relocation type bits
X */
X#define RELSZ	0x07		/* relocation length */
X#define RELO1	   1		/* 1 byte */
X#define RELO2	   2		/* 2 bytes */
X#define RELO4	   4		/* 4 bytes */
X#define RELPC	0x08		/* pc relative */
X#define RELBR	0x10		/* High order byte lowest address. */
X#define RELWR	0x20		/* High order word lowest address. */
X
X/*
X * section type bits and fields
X */
X#define S_TYP	0x007F		/* undefined, absolute or relative */
X#define S_EXT	0x0080		/* external flag */
X#define S_ETC	0x7F00		/* for symbolic debug, bypassing 'as' */
X
X/*
X * S_TYP field values
X */
X#define S_UND	0x0000		/* undefined item */
X#define S_ABS	0x0001		/* absolute item */
X#define S_MIN	0x0002		/* first user section */
X#define S_MAX	S_TYP		/* last user section */
X
X/*
X * S_ETC field values
X */
X#define S_SCT	0x0100		/* section names */
X#define S_LIN	0x0200		/* hll source line item */
X#define S_FIL	0x0300		/* hll source file item */
X#define S_MOD	0x0400		/* ass source file item */
X#define S_COM	0x1000		/* Common name. */
X
X/*
X * structure format strings
X */
X#define SF_HEAD		"22222244"
X#define SF_SECT		"44444"
X#define SF_RELO		"1124"
X#define SF_NAME		"4224"
X
X/*
X * structure sizes (bytes in file; add digits in SF_*)
X */
X#define SZ_HEAD		20
X#define SZ_SECT		20
X#define SZ_RELO		8
X#define SZ_NAME		12
X
X/*
X * file access macros
X */
X#define BADMAGIC(x)	((x).oh_magic!=O_MAGIC)
X#define OFF_SECT(x)	SZ_HEAD
X#define OFF_EMIT(x)	(OFF_SECT(x) + ((long)(x).oh_nsect * SZ_SECT))
X#define OFF_RELO(x)	(OFF_EMIT(x) + (x).oh_nemit)
X#define OFF_NAME(x)	(OFF_RELO(x) + ((long)(x).oh_nrelo * SZ_RELO))
X#define OFF_CHAR(x)	(OFF_NAME(x) + ((long)(x).oh_nname * SZ_NAME))
X#endif /* _OUT_H */
/
echo x - screen.h
sed '/^X/s///' > screen.h << '/'
Xstruct rgb_value {
X   unsigned char r;
X   unsigned char g;
X   unsigned char b;
X};
X
Xstruct scr_attr {
X  long addr;	/* location of the bitmap */
X  int width;	/* size is 0 .. width - 1 pixels */
X  int heigth;	/* size is 0 .. heigth - 1 pixels*/
X  int planes;	/* number of planes */
X  unsigned short clut_size;
X  unsigned short nr_color_bits;
X};
X
Xstruct clut_entry {
X  int index;
X  struct rgb_value rgb;
X};
X
X/* offset for the SCREEN minor numbers */
X#define SCREEN_DEV 64
X
/
echo x - setjmp.h.ansi
sed '/^X/s///' > setjmp.h.ansi << '/'
X/* The <setjmp.h> header relates to the C phenomenon known as setjmp/longjmp.
X * It is used to escape out of the current situation into a previous one.
X * A typical example is in an editor, where hitting DEL breaks off the current
X * command and puts the editor back in the main loop, though care has to be
X * taken when the DEL occurs while executing a library function, since
X * some of them are not reentrant.
X *
X * POSIX does not require the process signal mask to be saved and restored
X * during setjmp/longjmp.  However, the current implementation does this
X * in order to agree with OSF/1 and other BSD derived systems.
X *
X * The pair of functions _setjmp/_longjmp may be used when the signal
X * mask is not to be saved/restored.  These functions are traditional
X * in BSD systems.
X *
X * There are different ways of implementing setjmp/longjmp.  Probably
X * the best way is to unify it with signal handling.  This is true for the
X * following reasons:  Both setjmp/longjmp and signal delivery must save 
X * a context so that it may be restored later.  The jmp_buf necessarily 
X * contains signal information, namely the signal mask to restore.  Both
X * longjmp and the return of a signal handler must trap to the operating
X * system to restore the previous signal mask.  Finally, the jmp_buf
X * and the sigcontext structure contain the registers to restore.
X *
X * Some compilers, namely ACK, will not enregister any variables inside a
X * function containing a call to setjmp, even if those variables are
X * explicitly declared as register variables.  Thus for ACK, the
X * identification of the jmp_buf with a sigcontext structure would cause
X * unnecessary overhead: the jmp_buf has room for all the registers, but
X * the only registers that need to be saved are the stack pointer, 
X * frame pointer, and program counter.
X *
X * So, for ACK a jmp_buf is much smaller than a sigcontext structure, and
X * longjmp does not directly call sigreturn.  Instead, longjmp calls a
X * front-end function which initializes the appropriate fields of a
X * sigcontext structure, marks this structure as containing no valid
X * general purpose registers, and then calls sigreturn.
X *
X * The POSIX sigjmp_buf is identical to the jmp_buf in all cases.
X *
X * Different compilers have different symbols that they recognize as
X * setjmp symbols.  ACK recognizes __setjmp, the GNU C compiler
X * recognizes setjmp and _setjmp, and BCC recognizes all three.
X * When these symbols occur within a function, the compiler may keep 
X * all local variables on the stack, avoid certain optimizations, or
X * pass hidden arguments to the setjmp function.
X *  
X * Thus, setjmp implementations vary in two independent ways which may
X * be identified through the following preprocessor tokens:
X *
X * _SETJMP_SYMBOL -- If 0, this means the compiler treats setjmp and _setjmp
X * specially.  If 1, this means the compiler treats __setjmp specially.
X *
X * _SETJMP_SAVES_REGS -- If 1, this means setjmp/longjmp must explicitly
X * save and restore all registers.  This also implies that a jmp_buf is
X * different than a sigcontext structure.  If 0, this means that the compiler
X * will not use register variables within a function that calls one of 
X * its SETJMP_SYMBOLs. 
X * 
X * When _SETJMP_SYMBOL = 1, the implementation has a few dozen bytes of
X * unnecessary overhead.  This happens in the following manner:  a program uses
X * _setjmp/_longjmp because it is not interested in saving and restoring the
X * signal mask. Nevertheless, because _setjmp expands to the general purpose
X * function __setjmp, code for sigprocmask(2) is linked into the program.  
X */
X
X#ifndef _SETJMP_H
X#define _SETJMP_H
X
X#ifndef _ANSI_H
X#include <ansi.h>
X#endif
X
X#if !defined(__ACK__) && !defined(__BCC__) && !defined(__GNUC__)
X#define __ACK__
X#endif
X
X#ifdef __ACK__
X#define _SETJMP_SYMBOL 1
X#define _SETJMP_SAVES_REGS 0
X#endif
X#ifdef __BCC__
X#define _SETJMP_SYMBOL 0
X#define _SETJMP_SAVES_REGS 1
X#endif
X#ifdef __GNUC__
X#define _SETJMP_SYMBOL 0
X#define _SETJMP_SAVES_REGS 1
X#endif
X
X/* The jmp_buf data type.  Do not change the order of these fields -- some
X * C library code refers to these fields by name.  When _SETJMP_SAVES_REGS
X * is 1, the file <sys/jmp_buf.h> gives the usage of the sixteen registers.
X */
Xtypedef struct {
X  int __flags;			/* XXX - long might give better alignment */
X  long __mask;			/* must have size >= sizeof(sigset_t) */
X#if (_SETJMP_SAVES_REGS == 0)
X  _PROTOTYPE(void (*__pc),(void));	/* program counter */
X  void *__sp;			/* stack pointer */
X  void *__lb;			/* local base (ACKspeak for frame pointer) */
X#else
X  void *__regs[16];		/* size is machine dependent */
X#endif
X} jmp_buf[1];
X
X#if (_SETJMP_SYMBOL == 1)
X
X_PROTOTYPE( int __setjmp, (jmp_buf _env, int _savemask)			);
X_PROTOTYPE( void longjmp, (jmp_buf _env, int _val)			);
X_PROTOTYPE(int sigjmp, (jmp_buf _jb, int _retval)			);
X
X#define setjmp(env)	__setjmp((env), 1)
X
X#ifdef _MINIX
X#define _setjmp(env)	__setjmp((env), 0)
X_PROTOTYPE(void _longjmp, (jmp_buf _env, int _val)			);
X#endif
X
X#ifdef _POSIX_SOURCE
Xtypedef jmp_buf sigjmp_buf;
X_PROTOTYPE( void siglongjmp, (sigjmp_buf _env, int _val)		);
X
X#define sigsetjmp(env, savemask) __setjmp((env), (savemask))
X#endif /* _POSIX_SOURCE */
X
X#endif /* _SETJMP_SYMBOL == 1 */
X
X#if (_SETJMP_SYMBOL == 0)
X
X_PROTOTYPE( int setjmp, (jmp_buf _env)					);
X_PROTOTYPE( void longjmp, (jmp_buf _env, int _val)			);
X
X#ifdef _MINIX
X_PROTOTYPE( int _setjmp, (jmp_buf _env)					);
X_PROTOTYPE( void _longjmp, (jmp_buf _env, int _val)			);
X#endif
X
X#ifdef _POSIX_SOURCE
X#define sigjmp_buf jmp_buf
X_PROTOTYPE( void siglongjmp, (sigjmp_buf _env, int _val)		);
X/* XXX - the name _setjmp is no good - that's why ACK used __setjmp. */
X#define sigsetjmp(env, savemask) ((savemask) ? setjmp(env) : _setjmp(env))
X#endif /* _POSIX_SOURCE */
X
X#endif /* _SETJMP_SYMBOL == 0 */
X
X#endif /* _SETJMP_H */
/
echo x - setjmp.h.kr
sed '/^X/s///' > setjmp.h.kr << '/'
X/* The <setjmp.h> header relates to the C phenomenon known as setjmp/longjmp.
X * It is used to escape out of the current situation into a previous one.
X * A typical example is in an editor, where hitting DEL breaks off the current
X * command and puts the editor back in the main loop, though care has to be
X * taken when the DEL occurs while executing a library function, since
X * some of them are not reentrant.
X *
X * POSIX does not require the process signal mask to be saved and restored
X * during setjmp/longjmp.  However, the current implementation does this
X * in order to agree with OSF/1 and other BSD derived systems.
X *
X * The pair of functions _setjmp/_longjmp may be used when the signal
X * mask is not to be saved/restored.  These functions are traditional
X * in BSD systems.
X *
X * There are different ways of implementing setjmp/longjmp.  Probably
X * the best way is to unify it with signal handling.  This is true for the
X * following reasons:  Both setjmp/longjmp and signal delivery must save 
X * a context so that it may be restored later.  The jmp_buf necessarily 
X * contains signal information, namely the signal mask to restore.  Both
X * longjmp and the return of a signal handler must trap to the operating
X * system to restore the previous signal mask.  Finally, the jmp_buf
X * and the sigcontext structure contain the registers to restore.
X *
X * Some compilers, namely ACK, will not enregister any variables inside a
X * function containing a call to setjmp, even if those variables are
X * explicitly declared as register variables.  Thus for ACK, the
X * identification of the jmp_buf with a sigcontext structure would cause
X * unnecessary overhead: the jmp_buf has room for all the registers, but
X * the only registers that need to be saved are the stack pointer, 
X * frame pointer, and program counter.
X *
X * So, for ACK a jmp_buf is much smaller than a sigcontext structure, and
X * longjmp does not directly call sigreturn.  Instead, longjmp calls a
X * front-end function which initializes the appropriate fields of a
X * sigcontext structure, marks this structure as containing no valid
X * general purpose registers, and then calls sigreturn.
X *
X * The POSIX sigjmp_buf is identical to the jmp_buf in all cases.
X *
X * Different compilers have different symbols that they recognize as
X * setjmp symbols.  ACK K&R recognizes setjmp, the GNU C compiler
X * recognizes setjmp and _setjmp, and BCC recognizes all three.
X * When these symbols occur within a function, the compiler may keep 
X * all local variables on the stack, avoid certain optimizations, or
X * pass hidden arguments to the setjmp function.
X *  
X * Thus, setjmp implementations vary in two independent ways which may
X * be identified through the following preprocessor tokens:
X *
X * _SETJMP_SYMBOL -- If 0, this means the compiler treats setjmp and _setjmp
X * specially.  If 1, this means the compiler treats setjmp specially.
X *
X * _SETJMP_SAVES_REGS -- If 1, this means setjmp/longjmp must explicitly
X * save and restore all registers.  This also implies that a jmp_buf is
X * different than a sigcontext structure.  If 0, this means that the compiler
X * will not use register variables within a function that calls one of 
X * its SETJMP_SYMBOLs. 
X * 
X * When _SETJMP_SYMBOL = 1, the implementation has a few dozen bytes of
X * unnecessary overhead.  This happens in the following manner:  a program 
X * uses _setjmp/_longjmp because it is not interested in saving and restoring 
X * the signal mask. Nevertheless, because _setjmp expands to the general 
X * purpose function setjmp, code for sigprocmask(2) is linked into the program.  
X */
X
X#ifndef _SETJMP_H
X#define _SETJMP_H
X
X#ifndef _ANSI_H
X#include <ansi.h>
X#endif
X
X#if !defined(__ACK__) && !defined(__BCC__) && !defined(__GNUC__)
X#define __ACK__			/* default */
X#endif
X
X#ifdef __ACK__
X#define _SETJMP_SYMBOL 1
X#define _SETJMP_SAVES_REGS 0
X#endif
X#ifdef __BCC__
X#define _SETJMP_SYMBOL 0
X#define _SETJMP_SAVES_REGS 1
X#endif
X#ifdef __GNUC__
X#define _SETJMP_SYMBOL 0
X#define _SETJMP_SAVES_REGS 1
X#endif
X
X/* The jmp_buf data type.  Do not change the order of these fields -- some
X * C library code refers to these fields by name.  When _SETJMP_SAVES_REGS
X * is 1, the file <sys/jmp_buf.h> gives the usage of the sixteen registers.
X */
Xtypedef struct {
X  int __flags;			/* XXX - long might give better alignment */
X  long __mask;			/* must have size >= sizeof(sigset_t) */
X#if (_SETJMP_SAVES_REGS == 0)
X  _PROTOTYPE(void (*__pc),(void));	/* program counter */
X  void *__sp;			/* stack pointer */
X  void *__lb;			/* local base (ACKspeak for frame pointer) */
X#else
X  void *__regs[16];		/* size is machine dependent */
X#endif
X} jmp_buf[1];
X
X#if (_SETJMP_SYMBOL == 1)
X
X_PROTOTYPE( int setjmp, (jmp_buf _env)					);
X_PROTOTYPE( void longjmp, (jmp_buf _env, int _val)			);
X_PROTOTYPE(int sigjmp, (jmp_buf _jb, int _retval)			);
X
X#ifdef _MINIX
X#define _setjmp(env)	setjmp((env), 0)
X_PROTOTYPE(void _longjmp, (jmp_buf _env, int _val)			);
X#endif
X
X#ifdef _POSIX_SOURCE
Xtypedef jmp_buf sigjmp_buf;
X_PROTOTYPE( void siglongjmp, (sigjmp_buf _env, int _val)		);
X
X#define sigsetjmp(env, savemask) setjmp((env), (savemask))
X#endif /* _POSIX_SOURCE */
X
X#endif /* _SETJMP_SYMBOL == 1 */
X
X#if (_SETJMP_SYMBOL == 0)
X
X_PROTOTYPE( int setjmp, (jmp_buf _env)					);
X_PROTOTYPE( void longjmp, (jmp_buf _env, int _val)			);
X
X#ifdef _MINIX
X_PROTOTYPE( int _setjmp, (jmp_buf _env)					);
X_PROTOTYPE( void _longjmp, (jmp_buf _env, int _val)			);
X#endif
X
X#ifdef _POSIX_SOURCE
X#define sigjmp_buf jmp_buf
X_PROTOTYPE( void siglongjmp, (sigjmp_buf _env, int _val)		);
X/* XXX - the name _setjmp is no good - that's why ACK used __setjmp. */
X#define sigsetjmp(env, savemask) ((savemask) ? setjmp(env) : _setjmp(env))
X#endif /* _POSIX_SOURCE */
X
X#endif /* _SETJMP_SYMBOL == 0 */
X
X#endif /* _SETJMP_H */
/
echo x - st_screen.h
sed '/^X/s///' > st_screen.h << '/'
X#if (MACHINE != ATARI)
X#error this is the ATARI version
X#endif
X
X/* Kludge for MINIX 1.5.10 */
X#ifndef ATARI_TYPE
X#define ATARI_TYPE	  ST
X#define ST		   1	/* all ST's and Mega ST's */
X#define STE		   2	/* all STe and Mega STe's */
X#define TT		   3
X#endif
X
X#define SCR_ADDR	(long)0
X
Xstruct video_mode {
X  struct scr_attr attr;
X  short mode;	/* ST/TT: video mode */
X};
X
Xstruct video_mode video_mode[] =
X{
X/*
X *   +--------------------------------------- video memory address
X *   |           +--------------------------- pixels per line
X *   |           |    +---------------------- pixels per row
X *   |           |    |   +------------------ number of planes
X *   |           |    |   |    +------------- size of clut
X *   |           |    |   |    |   +--------- bits per color
X *   |           |    |   |    |   |     +--- video mode
X *   |           |    |   |    |   |     |
X *   V           V    V   V    V   V     V
X */
X #if (ATARI_TYPE == ST)
X { { SCR_ADDR,  320, 200, 4,  16,  3 }, 0x0  , },	/* ST lo res */
X { { SCR_ADDR,  640, 200, 2,   4,  3 }, 0x1  , },	/* ST med res */
X { { SCR_ADDR,  640, 400, 1,   1,  1 }, 0x2  , },	/* ST hi res */
X #endif
X #if (ATARI_TYPE == STe)
X { { SCR_ADDR,  320, 200, 4,  16,  4 }, 0x0  , },	/* STe lo res */
X { { SCR_ADDR,  640, 200, 2,   4,  4 }, 0x1  , },	/* STe med res */
X { { SCR_ADDR,  640, 400, 1,   1,  4 }, 0x2  , },	/* STe hi res */
X #endif
X #if (ATARI_TYPE == TT)
X { { SCR_ADDR,  320, 200, 4,  16,  4 }, 0x000, },	/* ST lo res */
X { { SCR_ADDR,  640, 200, 2,   4,  4 }, 0x100, },	/* ST med res */
X { { SCR_ADDR,  640, 400, 1,   1,  4 }, 0x200, },	/* ST hi res */
X { { SCR_ADDR,  320, 480, 8, 256,  4 }, 0x700, },	/* TT lo res */
X { { SCR_ADDR,  640, 480, 4,  16,  4 }, 0x400, },	/* TT med res */
X { { SCR_ADDR, 1280, 480, 1,   1,  1 }, 0x600, },	/* TT hi res */
X #endif
X};
/
echo x - stdio.h.ansi
sed '/^X/s///' > stdio.h.ansi << '/'
X/*
X * stdio.h - input/output definitions
X *
X * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
X * See the copyright notice in the ACK home directory, in the file "Copyright".
X */
X/* $Header: stdio.h,v 1.3 89/12/18 14:00:10 eck Exp $ */
X
X#ifndef _STDIO_H
X#define	_STDIO_H
X
X/*
X * Focus point of all stdio activity.
X */
Xtypedef struct __iobuf {
X	int		_count;
X	int		_fd;
X	int		_flags;
X	int		_bufsiz;
X	unsigned char	*_buf;
X	unsigned char	*_ptr;
X} FILE;
X
X#define	_IOFBF		0x000
X#define	_IOREAD		0x001
X#define	_IOWRITE	0x002
X#define	_IONBF		0x004
X#define	_IOMYBUF	0x008
X#define	_IOEOF		0x010
X#define	_IOERR		0x020
X#define	_IOLBF		0x040
X#define	_IOREADING	0x080
X#define	_IOWRITING	0x100
X#define	_IOAPPEND	0x200
X
X/* The following definitions are also in <unistd.h>. They should not
X * conflict.
X */
X#define	SEEK_SET	0
X#define	SEEK_CUR	1
X#define	SEEK_END	2
X
X#define	stdin		(&__stdin)
X#define	stdout		(&__stdout)
X#define	stderr		(&__stderr)
X
X#define	BUFSIZ		1024
X#define	NULL		((void *)0)
X#define	EOF		(-1)
X
X#define	FOPEN_MAX	20
X
X#define	FILENAME_MAX	14
X#define	TMP_MAX		999
X#define	L_tmpnam	(sizeof("/tmp/") + 15)
X#define __STDIO_VA_LIST__	void *
X
Xtypedef long int	fpos_t;
X
X#ifndef _SIZE_T
X#define	_SIZE_T
Xtypedef unsigned int	size_t;		/* type returned by sizeof */
X#endif /* _SIZE_T */
X
Xextern FILE	*__iotab[FOPEN_MAX];
Xextern FILE	__stdin, __stdout, __stderr;
X
X#ifndef _ANSI_H
X#include <ansi.h>
X#endif
X
X_PROTOTYPE( int remove, (const char *_filename)				);
X_PROTOTYPE( int rename, (const char *_old, const char *_new)		);
X_PROTOTYPE( FILE *tmpfile, (void)					);
X_PROTOTYPE( char *tmpnam, (char *_s)					);
X_PROTOTYPE( int fclose, (FILE *_stream)					);
X_PROTOTYPE( int fflush, (FILE *_stream)					);
X_PROTOTYPE( FILE *fopen, (const char *_filename, const char *_mode)	);
X_PROTOTYPE( FILE *freopen,
X	    (const char *_filename, const char *_mode, FILE *_stream)	);
X_PROTOTYPE( void setbuf, (FILE *_stream, char *_buf)			);
X_PROTOTYPE( int setvbuf,
X		(FILE *_stream, char *_buf, int _mode, size_t _size)	);
X_PROTOTYPE( int fprintf, (FILE *_stream, const char *_format, ...)	);
X_PROTOTYPE( int fscanf, (FILE *_stream, const char *_format, ...)	);
X_PROTOTYPE( int printf, (const char *_format, ...)			);
X_PROTOTYPE( int scanf, (const char *_format, ...)			);
X_PROTOTYPE( int sprintf, (char *_s, const char *_format, ...)		);
X_PROTOTYPE( int sscanf, (const char *_s, const char *_format, ...)	);
X_PROTOTYPE( int vfprintf,
X		(FILE *_stream, const char *_format, char *_arg)	);
X_PROTOTYPE( int vprintf, (const char *_format, char *_arg)		);
X_PROTOTYPE( int vsprintf, (char *_s, const char *_format, char *_arg)	);
X_PROTOTYPE( int fgetc, (FILE *_stream)					);
X_PROTOTYPE( char *fgets, (char *_s, int _n, FILE *_stream)		);
X_PROTOTYPE( int fputc, (int _c, FILE *_stream)				);
X_PROTOTYPE( int fputs, (const char *_s, FILE *_stream)			);
X_PROTOTYPE( int getc, (FILE *_stream)					);
X_PROTOTYPE( int getchar, (void)						);
X_PROTOTYPE( char *gets, (char *_s)					);
X_PROTOTYPE( int putc, (int _c, FILE *_stream)				);
X_PROTOTYPE( int putchar, (int _c)					);
X_PROTOTYPE( int puts, (const char *_s)					);
X_PROTOTYPE( int ungetc, (int _c, FILE *_stream)				);
X_PROTOTYPE( size_t fread,
X	    (void *_ptr, size_t _size, size_t _nmemb, FILE *_stream)	);
X_PROTOTYPE( size_t fwrite,
X	(const void *_ptr, size_t _size, size_t _nmemb, FILE *_stream)	);
X_PROTOTYPE( int fgetpos, (FILE *_stream, fpos_t *_pos)			);
X_PROTOTYPE( int fseek, (FILE *_stream, long _offset, int _whence)	);
X_PROTOTYPE( int fsetpos, (FILE *_stream, fpos_t *_pos)			);
X_PROTOTYPE( long ftell, (FILE *_stream)					);
X_PROTOTYPE( void rewind, (FILE *_stream)				);
X_PROTOTYPE( void clearerr, (FILE *_stream)				);
X_PROTOTYPE( int feof, (FILE *_stream)					);
X_PROTOTYPE( int ferror, (FILE *_stream)					);
X_PROTOTYPE( void perror, (const char *_s)				);
X_PROTOTYPE( int __fillbuf, (FILE *_stream)				);
X_PROTOTYPE( int __flushbuf, (int _c, FILE *_stream)			);
X
X#define	getchar()	getc(stdin)
X#define	putchar(c)	putc(c,stdout)
X#define	getc(p)		(--(p)->_count >= 0 ? (int) (*(p)->_ptr++) : \
X				__fillbuf(p))
X#define	putc(c, p)	(--(p)->_count >= 0 ? \
X			 (int) (*(p)->_ptr++ = (c)) : \
X			 __flushbuf((c),(p)))
X
X#define	feof(p)		(((p)->_flags & _IOEOF) != 0)
X#define	ferror(p)	(((p)->_flags & _IOERR) != 0)
X
X#ifdef _POSIX_SOURCE
X_PROTOTYPE( int fileno, (FILE *_stream)					);
X_PROTOTYPE (FILE *fdopen, (int _fildes, const char *_types) );
X#define	fileno(stream)		((stream)->_fd)
X#define L_ctermid 255	/* required by POSIX */
X#define L_cuserid 255	/* required by POSIX */
X#endif
X
X#ifdef _MINIX
X_PROTOTYPE(FILE *popen, (const char *_command, const char *_type));
X_PROTOTYPE(int pclose, (FILE *_stream));
X#endif
X
X#endif /* _STDIO_H */
/
echo x - stdio.h.kr
sed '/^X/s///' > stdio.h.kr << '/'
X/* The <stdio.h> header is used by the I/O routines. */
X
X#ifndef _STDIO_H
X#define _STDIO_H
X
X#ifdef NULL
X#undef NULL
X#endif
X
X#define BUFSIZ  1024
X#define NFILES  20
X#define NULL       0
X#define EOF     (-1)
X#define CMASK   0377
X
X#define READMODE     1
X#define WRITEMODE    2
X#define UNBUFF       4
X#define _EOF         8
X#define _ERR        16
X#define IOMYBUF     32
X#define PERPRINTF   64
X#define STRINGS    128
X
X#ifndef FILE
X
Xextern struct _io_buf {
X    int     _fd;
X    int     _count;
X    int     _flags;
X    char   *_buf;
X    char   *_ptr;
X}  *_io_table[NFILES];
X
X
X#endif	/* FILE */
X
X#define FILE struct _io_buf
X
X
X#define stdin  (_io_table[0])	
X#define stdout 	(_io_table[1])
X#define stderr 	(_io_table[2])
X
X/* -------------- Prototypes copied from Earl Chew's stdio -----------------*/
X
X#include <ansi.h>
X
X#if _ANSI
X#  define __STDIO_P__(__x) __x
X#  define __STDIO_VA__ ,...
X#else
X#  define __STDIO_P__(__x) ()
X#  define __STDIO_VA__
X#endif
X
X#ifndef _SIZE_T
X#define _SIZE_T
Xtypedef unsigned size_t;
X#endif
X
X#define __fpos_t long
X#define __STDIO_VA_LIST__	void *
X
X/* ANSI Stdio Requirements */
X
Xint	getc		__STDIO_P__((FILE *));
Xint	getchar		__STDIO_P__((void));
Xint	putc		__STDIO_P__((int, FILE *));
Xint	putchar		__STDIO_P__((int));
Xint	feof		__STDIO_P__((FILE *));
Xint	ferror		__STDIO_P__((FILE *));
Xvoid	clearerr	__STDIO_P__((FILE *));
X
XFILE 	*fopen		__STDIO_P__((const char *, const char *));
XFILE	*freopen	__STDIO_P__((const char *, const char *, FILE *));
Xint	fflush		__STDIO_P__((FILE *));
Xint	fclose		__STDIO_P__((FILE *));
X
Xint	fgetpos		__STDIO_P__((FILE *, __fpos_t *));
Xint	fsetpos		__STDIO_P__((FILE *, __fpos_t *));
Xlong	ftell		__STDIO_P__((FILE *));
Xint	fseek		__STDIO_P__((FILE *, long, int));
Xvoid	rewind		__STDIO_P__((FILE *));
X
Xint	fgetc		__STDIO_P__((FILE *));
Xint	fputc		__STDIO_P__((int, FILE *));
Xsize_t	fread		__STDIO_P__((void *, size_t, size_t, FILE *));
Xsize_t	fwrite		__STDIO_P__((const void *, size_t, size_t, FILE *));
X
Xint	getw		__STDIO_P__((FILE *));
Xint	putw		__STDIO_P__((int, FILE *));
Xchar	*gets		__STDIO_P__((char *));
Xchar	*fgets		__STDIO_P__((char *, int, FILE *));
Xint	puts		__STDIO_P__((const char *));
Xint	fputs		__STDIO_P__((const char *, FILE *));
X
Xint	ungetc		__STDIO_P__((int, FILE *));
X
X/* WRONG */
Xvoid	printf		__STDIO_P__((const char * __STDIO_VA__));
X/* WRONG */
Xvoid	fprintf		__STDIO_P__((FILE *, const char * __STDIO_VA__));
X/* WRONG */
Xchar	*sprintf	__STDIO_P__((char *, const char * __STDIO_VA__));
Xint	vprintf		__STDIO_P__((const char *, __STDIO_VA_LIST__));
Xint	vfprintf	__STDIO_P__((FILE *, const char *, __STDIO_VA_LIST__));
X/* WRONG */
Xchar 	*vsprintf	__STDIO_P__((char *, const char *, __STDIO_VA_LIST__));
Xint	scanf		__STDIO_P__((char *nonconstfmt __STDIO_VA__));
Xint	fscanf		__STDIO_P__((FILE *, char *nonconstfmt __STDIO_VA__));
Xint	sscanf		__STDIO_P__((char *nonconststr, char *nonconstfmt __STDIO_VA__));
X
Xvoid	setbuf		__STDIO_P__((FILE *, char *));
Xint	setvbuf		__STDIO_P__((FILE *, char *, int, size_t));
X
Xint	rename		__STDIO_P__((const char *, const char *));
Xint	remove		__STDIO_P__((const char *));
X
Xvoid	perror		__STDIO_P__((const char *));
X
Xchar *	tmpnam		__STDIO_P__((char *));
XFILE *	tmpfile		__STDIO_P__((void));
X
X/* Posix Definitions */
Xint	unlink		__STDIO_P__((const char *));
X
Xchar *	ctermid		__STDIO_P__((char *));
X
Xchar *	cuserid		__STDIO_P__((char *));
X
XFILE	*fdopen		__STDIO_P__((int, const char *));
X
Xint	fileno		__STDIO_P__((FILE *));
X
X/* Local Definitions */
Xextern _PROTOTYPE( void (*__cleanup), (void)				);
X_PROTOTYPE( void _doprintf, (FILE *iop, const char *fmt,
X			     __STDIO_VA_LIST__)				);
X_PROTOTYPE( int _doscanf, (int code, char *funcarg, char *nonconstfmt,
X			     __STDIO_VA_LIST__)				);
X
X/* ---------------------- End of Earl's prototypes --------------------------*/
X
X#define getchar() 		getc(stdin)
X#define putchar(c) 		putc(c,stdout)
X#define getc(f)			fgetc(f)
X#define putc(c,f)		fputc(c,f)
X#define feof(p) 		(((p)->_flags & _EOF) != 0)
X#define ferror(p) 		(((p)->_flags & _ERR) != 0)
X#define clearerr(p) 		((p)->_flags &= ~(_ERR))
X#define fileno(p) 		((p)->_fd)
X#define rewind(f)		fseek(f, 0L, 0)
X#define testflag(p,x)		((p)->_flags & (x))
X
X/* If you want a stream to be flushed after each printf use:
X * 
X *	perprintf(stream);
X *
X * If you want to stop with this kind of buffering use:
X *
X *	noperprintf(stream);
X */
X
X#define noperprintf(p)		((p)->_flags &= ~PERPRINTF)
X#define perprintf(p)		((p)->_flags |= PERPRINTF)
X
X#define L_ctermid 255	/* required by POSIX */
X#define L_cuserid 255	/* required by POSIX */
X
Xextern FILE	*fopen();
Xextern FILE	*freopen();
Xextern long	ftell();
Xextern char	*fgets();
Xextern char	*gets();
X
X#ifdef _MINIX
X_PROTOTYPE(FILE *popen, (const char *_command, const char *_type));
X_PROTOTYPE(int pclose, (FILE *_stream));
X#endif
X
X#endif /* _STDIO_H */
/
echo x - tiny-fcntl.h
sed '/^X/s///' > tiny-fcntl.h << '/'
X/* These prototypes from fcntl.h are needed by the system.  fcntl.h may be
X * too big to include, so have all users of these prototypes (including
X * fcntl.h) include this file.  The macros and types must be set up already.
X */
X_PROTOTYPE( int creat, (const char *_path, Mode_t _mode)		);
X_PROTOTYPE( int open,  (const char *_path, int _oflag, ...) 		);
/
echo x - tiny-unistd.h
sed '/^X/s///' > tiny-unistd.h << '/'
X/* The file <unistd.h> has so many prototypes that it causes the compiler
X * to overflow when compiling some programs.  This is a stripped down
X * version.
X */
X/* POSIX requires size_t and ssize_t in <unistd.h> and elsewhere. */
X#ifndef _SIZE_T
X#define _SIZE_T
Xtypedef unsigned int size_t;
X#endif
X
X#ifndef _SSIZE_T
X#define _SSIZE_T
Xtypedef int ssize_t;
X#endif
X
X_PROTOTYPE( int creat, (const char *_path, Mode_t _mode)		);
X_PROTOTYPE( int open,  (const char *_path, int _oflag, ...) 		);
X_PROTOTYPE( int access, (const char *_path, Mode_t _amode)		);
X_PROTOTYPE( int close, (int _fd)					);
X_PROTOTYPE( off_t lseek, (int _fd, off_t _offset, int _whence)		);
X_PROTOTYPE( ssize_t read, (int _fd, void *_buf, size_t _n)		);
X_PROTOTYPE( ssize_t write, (int _fd, const void *_buf, size_t _n)	);
X
X/* These definitions from unistd.h are needed by FS. */
X#define SEEK_SET           0	/* offset is absolute  */
X#define SEEK_CUR           1	/* offset is relative to current position */
X#define SEEK_END           2	/* offset is relative to end of file */
/
echo x - tools.h
sed '/^X/s///' > tools.h << '/'
X/* Constants describing the disk */
X#define SECTOR_SIZE	512
X#define SECTOR_SHIFT	9
X#define RATIO		(BLOCK_SIZE / SECTOR_SIZE)
X#define HRATIO		(SECTOR_SIZE / HCLICK_SIZE)
X#define PARAMSEC	1	/* sector containing boot parameters */
X#define DSKBASE		0x1E	/* floppy disk parameter vector */
X#define DSKPARSIZE	11	/* there are this many bytes of parameters */
X#define ESC		'\33'	/* escape key */
X#define HEADERSEG	0x0060	/* place for an array of struct exec's */
X#define MINIXSEG	0x0080	/* MINIX loaded here (rounded up to a click) */
X#define BOOTSEG		0x07C0	/* bootstraps are loaded here */
X#define SIGNATURE	0xAA55	/* proper bootstraps have this signature */
X#define SIGNATPOS	510	/* offset within bootblock */
X#define FREESEG		0x0800	/* Memory from FREESEG to cseg is free */
X#define MSEC_PER_TICK	55	/* 18.2 ticks per second */
X
X/* Scan codes for four different keyboards (from kernel/keyboard.c) */
X#define DUTCH_EXT_SCAN	  32	/* 'd' */
X#define OLIVETTI_SCAN	  12	/* '=' key on olivetti */
X#define STANDARD_SCAN	  13	/* '=' key on IBM */
X#define US_EXT_SCAN	  22	/* 'u' */
X
X/* Other */
X#define ROOT_INO ((ino_t) 1)	/* Inode nr of root dir. */
X#define IM_NAME_MAX       63
X
X/* Variables */
X#ifndef EXTERN
X#define EXTERN extern
X#endif
X
Xtypedef struct vector {
X  u16_t offset;
X  u16_t segment;
X} vector;
X
Xstruct image_header {
X  char name[IM_NAME_MAX + 1];	/* Null terminated. */
X  struct exec process;
X};
X
XEXTERN vector rem_part;		/* boot partition table entry */
XEXTERN u16_t cseg, dseg;	/* code and data segment of the boot program */
XEXTERN u32_t runsize;		/* size of this program */
XEXTERN u16_t device;		/* drive being booted from */
XEXTERN u16_t heads, sectors;	/* the drive's number of heads and sectors */
Xextern u16_t eqscancode;	/* Set by peek/getch() if they see a '=' */
X
X/* Sticky attributes */
X#define E_SPECIAL	0x01	/* These are known to the program */
X#define E_DEV		0x02	/* The value is a device name */
X#define E_RESERVED	0x04	/* May not be set by user, e.g. scancode */
X#define E_STICKY	0x07	/* Don't go once set */
X
X/* Volatile attributes */
X#define E_VAR		0x08	/* Variable */
X#define E_FUNCTION	0x10	/* Function definition */
X
Xtypedef struct environment {
X  struct environment *next;
X  char flags;
X  char *name;			/* name = value */
X  char *arg;			/* name(arg) {value} */
X  char *value;
X  char *defval;			/* Safehouse for default values */
X} environment;
X
X/* External variables */
XEXTERN environment *env;	/* Lists the environment */
XEXTERN int fsok;		/* True if the boot device contains an FS */
XEXTERN u32_t lowsec;		/* Offset to the file system on the boot dev */
X
X/* Prototypes */
X_PROTOTYPE( off_t r_super, (void));
X_PROTOTYPE( void r_stat, (Ino_t _inum, struct stat *_stp ));
X_PROTOTYPE( ino_t r_readdir, (char *_name ));
X_PROTOTYPE( off_t r_vir2abs, (off_t _virblk ));
X_PROTOTYPE( ino_t r_lookup, (Ino_t _cwd, char *_path ));
X
X#ifdef _MONHEAD
X_PROTOTYPE( void readerr, (off_t _sec, int _err ));
X_PROTOTYPE( int numprefix, (char *_s, char **_ps ));
X_PROTOTYPE( int numeric, (char *_s ));
X_PROTOTYPE( dev_t name2dev, (char *_name ));
X_PROTOTYPE( int delay, (char *_msec ));
X_PROTOTYPE( char *unix_err, (int _err ));
X_PROTOTYPE( void init_cache, (void));
X_PROTOTYPE( void invalidate_cache, (void));
X_PROTOTYPE( char *b_value, (char *_name ));
X_PROTOTYPE( void raw_copy, (int _doff, int _dseg, int _soff, int _sseg,
X						int _count));
X_PROTOTYPE( void raw_clear, (int _off, int _seg, int _count));
X_PROTOTYPE( void bootstrap, (int _device, int _partoff, int _partseg));
X
X_PROTOTYPE( long a2l, (char *_a ));
X_PROTOTYPE( char *ul2a, (u32_t _n ));
X_PROTOTYPE( char *u2a, (int _n1 ));
X
X/* Functions defined in monhead.s and usable by other files. */
X_PROTOTYPE( void reset_video, (int color));
X_PROTOTYPE( int dev_geometry, (void));
X_PROTOTYPE( u16_t get_ext_memsize, (void));
X_PROTOTYPE( u16_t get_low_memsize, (void));
X_PROTOTYPE( u16_t get_processor, (void));
X_PROTOTYPE( u32_t get_tick, (void));
X_PROTOTYPE( u16_t get_video, (void));
X_PROTOTYPE( u16_t get_word, (int _off, int _seg));
X_PROTOTYPE( int getchar, (void));
X_PROTOTYPE( void minix, (void));
X_PROTOTYPE( void minix86, (int _kcs, int _kds, char *_bpar, int _psize));
X_PROTOTYPE( void minix386, (int _kcs, int _kds, char *_bpar, int _psize));
X_PROTOTYPE( int peekchar, (void));
X_PROTOTYPE( void put_word, (int _off, int _seg, int _word));
X_PROTOTYPE( int putchar, (char _c));
X_PROTOTYPE( int readsectors, (int _off, int _seg, off_t _adr, int _ct));
X_PROTOTYPE( void reboot, (void));
X_PROTOTYPE( void relocate, (void));
X_PROTOTYPE( int writesectors, (int _off, int _seg, off_t _adr, int _ct));
X#endif
X
X
/
echo x - include.cd
sed '/^X/s///' > include.cd << '/'
Xecho x - a.out.h.d
Xsed '/^X/s///' > a.out.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/a.out.h  crc=03987   3733	Sat Apr 21 22:26:21 1990
XX--- /home/top/ast/minix/1.6.25/include/a.out.h  crc=52390   3962	Tue Nov  3 21:21:47 1992
XX***************
XX*** 4,52 ****
XX  #define _AOUT_H
XX  
XX  struct	exec {			/* a.out header */
XX! 	unsigned char	a_magic[2];	/* magic number */
XX! 	unsigned char	a_flags;	/* flags, see below */
XX! 	unsigned char	a_cpu;		/* cpu id */
XX! 	unsigned char	a_hdrlen;	/* length of header */
XX! 	unsigned char	a_unused;	/* reserved for future use */
XX! 	unsigned short	a_version;	/* version stamp */	
XX! 				/* not used */
XX! 	long		a_text;		/* size of text segement in bytes */
XX! 	long		a_data;		/* size of data segment in bytes */
XX! 	long		a_bss;		/* size of bss segment in bytes */
XX! 	long		a_no_entry;	/* in fact: entry point, a_entry */
XX! 	long		a_total;	/* total memory allocated */
XX! 	long		a_syms;		/* size of symbol table */
XX! 				/* SHORT FORM ENDS HERE */
XX! 	long		a_trsize;	/* text relocation size */
XX! 	long		a_drsize;	/* data relocation size */
XX! 	long		a_tbase;	/* text relocation base */
XX! 	long		a_dbase;	/* data relocation base */
XX  };
XX  
XX! #define A_MAGIC0	(unsigned char) 0x01
XX! #define A_MAGIC1	(unsigned char) 0x03
XX! #define BADMAG(X)	((X).a_magic[0] != A_MAGIC0 ||\
XX! 			 (X).a_magic[1] != A_MAGIC1)
XX  
XX! /* CPU Id of TARGET machine */
XX! 	/* byte order coded in low order two bits */
XX  #define A_NONE	0x00	/* unknown */
XX  #define A_I8086	0x04	/* intel i8086/8088 */
XX  #define A_M68K	0x0B	/* motorola m68000 */
XX  #define A_NS16K	0x0C	/* national semiconductor 16032 */
XX! #define A_I80386	0x10	/* intel i80386 */
XX  
XX  #define A_BLR(cputype)	((cputype&0x01)!=0) /* TRUE if bytes left-to-right */
XX  #define A_WLR(cputype)	((cputype&0x02)!=0) /* TRUE if words left-to-right */
XX  
XX! /* flags: */
XX  #define A_EXEC	0x10	/* executable */
XX  #define A_SEP	0x20	/* separate I/D */
XX  #define A_PURE	0x40	/* pure text */		/* not used */
XX  #define A_TOVLY	0x80	/* text overlay */	/* not used */
XX  
XX! /* offsets of various things: */
XX  #define A_MINHDR	32
XX  #define	A_TEXTPOS(X)	((long)(X).a_hdrlen)
XX  #define A_DATAPOS(X)	(A_TEXTPOS(X) + (X).a_text)
XX--- 4,52 ----
XX  #define _AOUT_H
XX  
XX  struct	exec {			/* a.out header */
XX!   unsigned char	a_magic[2];	/* magic number */
XX!   unsigned char	a_flags;	/* flags, see below */
XX!   unsigned char	a_cpu;		/* cpu id */
XX!   unsigned char	a_hdrlen;	/* length of header */
XX!   unsigned char	a_unused;	/* reserved for future use */
XX!   unsigned short a_version;	/* version stamp (not used at present) */
XX!   long		a_text;		/* size of text segement in bytes */
XX!   long		a_data;		/* size of data segment in bytes */
XX!   long		a_bss;		/* size of bss segment in bytes */
XX!   long		a_no_entry;	/* in fact: entry point, a_entry */
XX!   long		a_total;	/* total memory allocated */
XX!   long		a_syms;		/* size of symbol table */
XX! 
XX!   /* SHORT FORM ENDS HERE */
XX!   long		a_trsize;	/* text relocation size */
XX!   long		a_drsize;	/* data relocation size */
XX!   long		a_tbase;	/* text relocation base */
XX!   long		a_dbase;	/* data relocation base */
XX  };
XX  
XX! #define A_MAGIC0      (unsigned char) 0x01
XX! #define A_MAGIC1      (unsigned char) 0x03
XX! #define BADMAG(X)     ((X).a_magic[0] != A_MAGIC0 ||(X).a_magic[1] != A_MAGIC1)
XX  
XX! /* CPU Id of TARGET machine (byte order coded in low order two bits) */
XX  #define A_NONE	0x00	/* unknown */
XX  #define A_I8086	0x04	/* intel i8086/8088 */
XX  #define A_M68K	0x0B	/* motorola m68000 */
XX  #define A_NS16K	0x0C	/* national semiconductor 16032 */
XX! #define A_I80386 0x10	/* intel i80386 */
XX! #define A_SPARC	0x17	/* Sun SPARC */
XX  
XX  #define A_BLR(cputype)	((cputype&0x01)!=0) /* TRUE if bytes left-to-right */
XX  #define A_WLR(cputype)	((cputype&0x02)!=0) /* TRUE if words left-to-right */
XX  
XX! /* Flags. */
XX! #define A_UZP	0x01	/* unmapped zero page (pages) */
XX  #define A_EXEC	0x10	/* executable */
XX  #define A_SEP	0x20	/* separate I/D */
XX  #define A_PURE	0x40	/* pure text */		/* not used */
XX  #define A_TOVLY	0x80	/* text overlay */	/* not used */
XX  
XX! /* Offsets of various things. */
XX  #define A_MINHDR	32
XX  #define	A_TEXTPOS(X)	((long)(X).a_hdrlen)
XX  #define A_DATAPOS(X)	(A_TEXTPOS(X) + (X).a_text)
XX***************
XX*** 57,68 ****
XX  #define A_TRELPOS(X)	(A_DATAPOS(X) + (X).a_data)
XX  #define A_DRELPOS(X)	(A_TRELPOS(X) + (X).a_trsize)
XX  #define A_SYMPOS(X)	(A_TRELPOS(X) + (A_HASRELS(X) ? \
XX! 				((X).a_trsize + (X).a_drsize) : 0))
XX  
XX  struct reloc {
XX! 	long		r_vaddr;	/* virtual address of reference */
XX! 	unsigned short	r_symndx;	/* internal segnum or extern symbol num */
XX! 	unsigned short	r_type;		/* relocation type */
XX  };
XX  
XX  /* r_tyep values: */
XX--- 57,68 ----
XX  #define A_TRELPOS(X)	(A_DATAPOS(X) + (X).a_data)
XX  #define A_DRELPOS(X)	(A_TRELPOS(X) + (X).a_trsize)
XX  #define A_SYMPOS(X)	(A_TRELPOS(X) + (A_HASRELS(X) ? \
XX!   			((X).a_trsize + (X).a_drsize) : 0))
XX  
XX  struct reloc {
XX!   long r_vaddr;			/* virtual address of reference */
XX!   unsigned short r_symndx;	/* internal segnum or extern symbol num */
XX!   unsigned short r_type;	/* relocation type */
XX  };
XX  
XX  /* r_tyep values: */
XX***************
XX*** 83,98 ****
XX  #define S_BSS		((unsigned short)-4)
XX  
XX  struct nlist {			/* symbol table entry */
XX! 	char	 	n_name[8];	/* symbol name */
XX! 	long	 	n_value;	/* value */
XX! 	unsigned char	n_sclass;	/* storage class */
XX! 	unsigned char	n_numaux;	/* number of auxiliary entries */
XX! 						/* not used */
XX! 	unsigned short	n_type;		/* language base and derived type */
XX! 						/* not used */
XX  };
XX  
XX! /* low bits of storage class (section) */
XX  #define	N_SECT		  07	/* section mask */
XX  #define N_UNDF		  00	/* undefined */
XX  #define N_ABS		  01	/* absolute */
XX--- 83,96 ----
XX  #define S_BSS		((unsigned short)-4)
XX  
XX  struct nlist {			/* symbol table entry */
XX!   char n_name[8];		/* symbol name */
XX!   long n_value;			/* value */
XX!   unsigned char	n_sclass;	/* storage class */
XX!   unsigned char	n_numaux;	/* number of auxiliary entries (not used) */
XX!   unsigned short n_type;	/* language base and derived type (not used) */
XX  };
XX  
XX! /* Low bits of storage class (section). */
XX  #define	N_SECT		  07	/* section mask */
XX  #define N_UNDF		  00	/* undefined */
XX  #define N_ABS		  01	/* absolute */
XX***************
XX*** 101,110 ****
XX  #define	N_BSS		  04	/* bss */
XX  #define N_COMM		  05	/* (common) */
XX  
XX! /* high bits of storage class */
XX  #define N_CLASS		0370	/* storage class mask */
XX  #define C_NULL
XX  #define C_EXT		0020	/* external symbol */
XX  #define C_STAT		0030	/* static */
XX  
XX  #endif /* _AOUT_H */
XX--- 99,115 ----
XX  #define	N_BSS		  04	/* bss */
XX  #define N_COMM		  05	/* (common) */
XX  
XX! /* High bits of storage class. */
XX  #define N_CLASS		0370	/* storage class mask */
XX  #define C_NULL
XX  #define C_EXT		0020	/* external symbol */
XX  #define C_STAT		0030	/* static */
XX+ 
XX+ /* Function prototypes. */
XX+ #ifndef _ANSI_H
XX+ #include <ansi.h>
XX+ #endif
XX+ 
XX+ _PROTOTYPE( int nlist, (char *_file, struct nlist *_nl)			);
XX  
XX  #endif /* _AOUT_H */
X/
Xecho x - ansi.h.d
Xsed '/^X/s///' > ansi.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/ansi.h  crc=47792   1660	Sat Apr 21 22:26:21 1990
XX--- /home/top/ast/minix/1.6.25/include/ansi.h  crc=25403   1681	Tue Nov  3 21:21:48 1992
XX***************
XX*** 1,11 ****
XX! /* The <ansi.h> header checks whether the compiler claims conformance to ANSI
XX!  * Standard C. If so, the symbol _ANSI is defined as 1, otherwise it is 
XX!  * defined as 0.  Based on the result, a macro
XX   *
XX   *	_PROTOTYPE(function, params)
XX   *
XX   * is defined.  This macro expands in different ways, generating either
XX!  * ANSI Standard C prototypes or old-style K&R (Kernighan & Ritchie) 
XX   * prototypes, as needed.  Finally, some programs use _CONST, _VOIDSTAR etc
XX   * in such a way that they are portable over both ANSI and K&R compilers.
XX   * The appropriate macros are defined here.
XX--- 1,18 ----
XX! /* The <ansi.h> header attempts to decide whether the compiler has enough
XX!  * conformance to Standard C for Minix to take advantage of.  If so, the
XX!  * symbol _ANSI is defined (as 31415).  Otherwise _ANSI is not defined
XX!  * here, but it may be defined by applications that want to bend the rules.
XX!  * The magic number in the definition is to inhibit unnecessary bending
XX!  * of the rules.  (For consistency with the new '#ifdef _ANSI" tests in
XX!  * the headers, _ANSI should really be defined as nothing, but that would
XX!  * break many library routines that use "#if _ANSI".)
XX! 
XX!  * If _ANSI ends up being defined, a macro
XX   *
XX   *	_PROTOTYPE(function, params)
XX   *
XX   * is defined.  This macro expands in different ways, generating either
XX!  * ANSI Standard C prototypes or old-style K&R (Kernighan & Ritchie)
XX   * prototypes, as needed.  Finally, some programs use _CONST, _VOIDSTAR etc
XX   * in such a way that they are portable over both ANSI and K&R compilers.
XX   * The appropriate macros are defined here.
XX***************
XX*** 14,39 ****
XX  #ifndef _ANSI_H
XX  #define _ANSI_H
XX  
XX! /* ANSI C requires __STDC__ to be defined as 1 for an ANSI C compiler.
XX!  * Some half-ANSI compilers define it as 0.  Get around this here.
XX!  */
XX  
XX! #define _ANSI              0	/* 0 if compiler is not ANSI C, 1 if it is */
XX! 
XX! #ifdef __STDC__			/* __STDC__ defined for (near) ANSI compilers*/
XX! #if __STDC__ == 1		/* __STDC__ == 1 for conformant compilers */
XX! #undef _ANSI			/* get rid of above definition */
XX! #define _ANSI              1	/* _ANSI = 1 for ANSI C compilers */
XX  #endif
XX- #endif
XX  
XX! /* At this point, _ANSI has been set correctly to 0 or 1. Define the
XX!  * _PROTOTYPE macro to either expand both of its arguments (ANSI prototypes),
XX!  * only the function name (K&R prototypes).
XX!  */
XX  
XX! #if _ANSI
XX  #define	_PROTOTYPE(function, params)	function params
XX  #define	_VOIDSTAR	void *
XX  #define	_VOID		void
XX  #define	_CONST		const
XX--- 21,39 ----
XX  #ifndef _ANSI_H
XX  #define _ANSI_H
XX  
XX! #if __STDC__ == 1
XX! #define _ANSI		31459	/* compiler claims full ANSI conformance */
XX! #endif
XX  
XX! #ifdef __GNUC__
XX! #define _ANSI		31459	/* gcc conforms enough even in non-ANSI mode */
XX  #endif
XX  
XX! #ifdef _ANSI
XX  
XX! /* Keep everything for ANSI prototypes. */
XX  #define	_PROTOTYPE(function, params)	function params
XX+ 
XX  #define	_VOIDSTAR	void *
XX  #define	_VOID		void
XX  #define	_CONST		const
XX***************
XX*** 42,48 ****
XX--- 42,50 ----
XX  
XX  #else
XX  
XX+ /* Throw away the parameters for K&R prototypes. */
XX  #define	_PROTOTYPE(function, params)	function()
XX+ 
XX  #define	_VOIDSTAR	void *
XX  #define	_VOID		void
XX  #define	_CONST
X/
Xecho x - ar.h.d
Xsed '/^X/s///' > ar.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/ar.h  crc=51839    389	Sat Apr 21 22:26:21 1990
XX--- /home/top/ast/minix/1.6.25/include/ar.h  crc=16512    880	Tue Nov  3 21:21:48 1992
XX***************
XX*** 3,8 ****
XX--- 3,15 ----
XX  #ifndef _AR_H
XX  #define _AR_H
XX  
XX+ /* When CHIP is not defined, set it to something other than SPARC. */
XX+ #ifndef CHIP
XX+ #define CHIP -9999
XX+ #endif
XX+ 
XX+ #if CHIP != SPARC
XX+ /* Normal (default) case: not a SPARC.  Use V7 archive format. */
XX  #define	ARMAG	0177545
XX  #define _NAME_MAX    14
XX  
XX***************
XX*** 14,18 ****
XX--- 21,44 ----
XX    char  ar_mode[2];		/* short in byte order 0 1 */
XX    char  ar_size[4];		/* long in byte order 2 3 1 0 */
XX  };
XX+ 
XX+ #else	
XX+ /* SparcStation uses ASCII type of ar header. */
XX+ 
XX+ #define ARMAG	"!<arch>\n"
XX+ #define SARMAG	8
XX+ #define ARFMAG	"`\n"
XX+ 
XX+ struct ar_hdr {
XX+ 	char	ar_name[16];
XX+ 	char	ar_date[12];
XX+ 	char	ar_uid[6];
XX+ 	char	ar_gid[6];
XX+ 	char	ar_mode[8];
XX+ 	char	ar_size[10];
XX+ 	char	ar_fmag[2];
XX+ };
XX+ 
XX+ #endif /* CHIP != SPARC */
XX  
XX  #endif /* _AR_H */
X/
Xecho x - assert.h.d
Xsed '/^X/s///' > assert.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/assert.h  crc=37522    961	Sat Apr 21 22:26:21 1990
XX--- /home/top/ast/minix/1.6.25/include/assert.h  crc=15284   1035	Tue Nov  3 21:21:48 1992
XX***************
XX*** 1,6 ****
XX  /* The <assert.h> header contains a macro called "assert" that allows 
XX   * programmers to put assertions in the code.  These assertions can be verified
XX!  * at run time.  If an assertion fails, an error message is printed.  
XX   * Assertion checking can be disabled by adding the statement
XX   *
XX   *	#define NDEBUG
XX--- 1,7 ----
XX  /* The <assert.h> header contains a macro called "assert" that allows 
XX   * programmers to put assertions in the code.  These assertions can be verified
XX!  * at run time.  If an assertion fails, an error message is printed and the
XX!  * program aborts.
XX   * Assertion checking can be disabled by adding the statement
XX   *
XX   *	#define NDEBUG
XX***************
XX*** 12,22 ****
XX   * statement.
XX   */
XX  
XX! #ifdef assert
XX! #undef assert			/* make this file idempotent */
XX! #endif
XX  
XX! #ifndef	_ANSI_H
XX  #include <ansi.h>
XX  #endif
XX  
XX--- 13,21 ----
XX   * statement.
XX   */
XX  
XX! #undef assert
XX  
XX! #ifndef _ANSI_H
XX  #include <ansi.h>
XX  #endif
XX  
XX***************
XX*** 26,37 ****
XX  #define assert(expr)  ((void) 0)
XX  #else
XX  /* Debugging enabled -- verify assertions at run time. */
XX  
XX! #if _ANSI
XX! _PROTOTYPE( _VOID __bad_assertion, (const char *__expr, const char *__file, int __line) );
XX! #define assert(expr) ((void) ((expr) ? (void)0 : __bad_assertion( #expr, __FILE__,  __LINE__)))
XX  #else
XX  #define assert(expr) ((void) ((expr) ? 0 : __assert( __FILE__,  __LINE__)))
XX! #endif
XX! 
XX  #endif
XX--- 25,40 ----
XX  #define assert(expr)  ((void) 0)
XX  #else
XX  /* Debugging enabled -- verify assertions at run time. */
XX+ #ifdef _ANSI
XX+ #define	__str(x)	# x
XX+ #define	__xstr(x)	__str(x)
XX  
XX! _PROTOTYPE( void __bad_assertion, (const char *_mess) );
XX! #define	assert(expr)	((expr)? (void)0 : \
XX! 				__bad_assertion("Assertion \"" #expr \
XX! 				    "\" failed, file " __xstr(__FILE__) \
XX! 				    ", line " __xstr(__LINE__) "\n"))
XX  #else
XX  #define assert(expr) ((void) ((expr) ? 0 : __assert( __FILE__,  __LINE__)))
XX! #endif /* _ANSI */
XX  #endif
X/
Xecho x - curses.h.d
Xsed '/^X/s///' > curses.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/curses.h  crc=23132   1093	Sat Apr 21 22:26:21 1990
XX--- /home/top/ast/minix/1.6.25/include/curses.h  crc=24531   9192	Tue Nov 10 19:32:59 1992
XX***************
XX*** 1,39 ****
XX! #ifndef _CURSES_H
XX! #define _CURSES_H
XX  
XX! #include <ansi.h>
XX  
XX! /* Lots of junk here, not packaged right. */
XX! extern char termcap[];
XX! extern char tc[];
XX! extern char *ttytype;
XX! extern char *arp;
XX! extern char *cp;
XX  
XX! extern char *cl;
XX! extern char *cm;
XX! extern char *so;
XX! extern char *se;
XX  
XX! extern char /* nscrn[ROWS][COLS], cscrn[ROWS][COLS], */ row, col, mode;
XX! extern char str[];
XX  
XX! _PROTOTYPE( void addstr, (char *_s)					);
XX! _PROTOTYPE( void clear, (void)						);
XX! _PROTOTYPE( void clrtobot, (void)					);
XX! _PROTOTYPE( void clrtoeol, (void)					);
XX! _PROTOTYPE( void endwin, (void)						);
XX! _PROTOTYPE( void fatal, (char *_s)					);
XX! _PROTOTYPE( char inch, (void)						);
XX! _PROTOTYPE( void initscr, (void)					);
XX! _PROTOTYPE( void move, (int _y, int _x)					);
XX! /* WRONG, next is varargs. */
XX! _PROTOTYPE( void printw, (char *_fmt, char *_a1, char *_a2, char *_a3,
XX! 			  char *_a4, char *_a5)				);
XX! _PROTOTYPE( void outc, (int _c)						);
XX! _PROTOTYPE( void refresh, (void)					);
XX! _PROTOTYPE( void standend, (void)					);
XX! _PROTOTYPE( void standout, (void)					);
XX! _PROTOTYPE( void touchwin, (void)					);
XX  
XX! #endif /* _CURSES_H */
XX--- 1,221 ----
XX! /* curses.h - defines macros and prototypes for curses */
XX  
XX! #ifndef CURSES_H
XX  
XX! #include <sgtty.h>
XX! #include <stdarg.h>
XX! #include <stdio.h>
XX  
XX! typedef int bool;
XX  
XX! #define TRUE 1
XX! #define FALSE 0
XX! #define ERR 1		/* general error flag */
XX! #define OK 0		/* general OK flag */
XX  
XX! /* Macros. */
XX! #define box(win,vc,hc) wbox(win,0,0,0,0,vc,hc)
XX! #define addch(ch) waddch(stdscr,ch)
XX! #define mvaddch(y,x,ch) (wmove(stdscr,y,x)==ERR?ERR:waddch(stdscr,ch))
XX! #define mvwaddch(win,y,x,ch) (wmove(win,y,x)==ERR?ERR:waddch(win,ch))
XX! #define getch() wgetch(stdscr)
XX! #define mvgetch(y,x) (wmove(stdscr,y,x)==ERR?ERR:wgetch(stdscr))
XX! #define mvwgetch(win,y,x) (wmove(win,y,x)==ERR?ERR:wgetch(win))
XX! #define addstr(str) waddstr(stdscr,str)
XX! #define mvaddstr(y,x,str) (wmove(stdscr,y,x)==ERR?ERR:waddstr(stdscr,str))
XX! #define mvwaddstr(win,y,x,str) (wmove(win,y,x)==ERR?ERR:waddstr(win,str))
XX! #define getstr(str) wgetstr(stdscr,str)
XX! #define mvgetstr(y,x,str) (wmove(stdscr,y,x)==ERR?ERR:wgetstr(stdscr,str))
XX! #define mvwgetstr(win,y,x,str) (wmove(win,y,x)==ERR?ERR:wgetstr(win,str))
XX! #define move(y,x) wmove(stdscr,y,x)
XX! #define clear() wclear(stdscr)
XX! #define erase() werase(stdscr)
XX! #define clrtobot() wclrtobot(stdscr)
XX! #define mvclrtobot(y,x) (wmove(stdscr,y,x)==ERR?ERR:wclrtobot(stdscr))
XX! #define mvwclrtobot(win,y,x) (wmove(win,y,x)==ERR?ERR:wclrtobot(win))
XX! #define clrtoeol() wclrtoeol(stdscr)
XX! #define mvclrtoeol(y,x) (wmove(stdscr,y,x)==ERR?ERR:wclrtoeol(stdscr))
XX! #define mvwclrtoeol(win,y,x) (wmove(win,y,x)==ERR?ERR:wclrtoeol(win))
XX! #define insertln() winsertln(stdscr)
XX! #define mvinsertln(y,x) (wmove(stdscr,y,x)==ERR?ERR:winsertln(stdscr))
XX! #define mvwinsertln(win,y,x) (wmove(win,y,x)==ERR?ERR:winsertln(win))
XX! #define deleteln() wdeleteln(stdscr)
XX! #define mvdeleteln(y,x) (wmove(stdscr,y,x)==ERR?ERR:wdeleteln(stdscr))
XX! #define mvwdeleteln(win,y,x) (wmove(win,y,x)==ERR?ERR:wdeleteln(win))
XX! #define refresh() wrefresh(stdscr)
XX! #define inch() winch(stdscr)
XX! #define insch(ch) winsch(stdscr,ch)
XX! #define mvinsch(y,x,ch) (wmove(stdscr,y,x)==ERR?ERR:winsch(stdscr,ch))
XX! #define mvwinsch(win,y,x,ch) (wmove(win,y,x)==ERR?ERR:winsch(win,ch))
XX! #define delch() wdelch(stdscr)
XX! #define mvdelch(y,x) (wmove(stdscr,y,x)==ERR?ERR:wdelch(stdscr))
XX! #define mvwdelch(win,y,x) (wmove(win,y,x)==ERR?ERR:wdelch(win))
XX! #define standout() wstandout(stdscr)
XX! #define wstandout(win) (win)->_attrs |= A_STANDOUT
XX! #define standend() wstandend(stdscr)
XX! #define wstandend(win) (win)->_attrs &= ~A_STANDOUT
XX! #define attrset(attrs) wattrset(stdscr, attrs)
XX! #define wattrset(win, attrs) (win)->_attrs = (attrs)
XX! #define attron(attrs) wattron(stdscr, attrs)
XX! #define wattron(win, attrs) (win)->_attrs |= (attrs)
XX! #define attroff(attrs) wattroff(stdscr,attrs)
XX! #define wattroff(win, attrs) (win)->_attrs &= ~(attrs)
XX! #define resetty() stty(1, &_orig_tty)
XX! #define getyx(win,y,x) (y = (win)->_cury, x = (win)->_curx)
XX  
XX! /* Video attribute definitions. */
XX! #define	A_BLINK        0x0100
XX! #define	A_BLANK        0
XX! #define	A_BOLD         0x0200
XX! #define	A_DIM          0
XX! #define	A_PROTECT      0
XX! #define	A_REVERSE      0x0400
XX! #define	A_STANDOUT     0x0800
XX! #define	A_UNDERLINE    0x1000
XX! #define	A_ALTCHARSET   0x2000
XX! 
XX! /* Type declarations. */
XX! typedef struct {
XX!   int	   _cury;			/* current pseudo-cursor */
XX!   int	   _curx;
XX!   int      _maxy;			/* max coordinates */
XX!   int      _maxx;
XX!   int      _begy;			/* origin on screen */
XX!   int      _begx;
XX!   int	   _flags;			/* window properties */
XX!   int	   _attrs;			/* attributes of written characters */
XX!   int      _tabsize;			/* tab character size */
XX!   bool	   _clear;			/* causes clear at next refresh */
XX!   bool	   _leave;			/* leaves cursor as it happens */
XX!   bool	   _scroll;			/* allows window scrolling */
XX!   bool	   _nodelay;			/* input character wait flag */
XX!   bool	   _keypad;			/* flags keypad key mode active */
XX!   int    **_line;			/* pointer to line pointer array */
XX!   int	  *_minchng;			/* First changed character in line */
XX!   int	  *_maxchng;			/* Last changed character in line */
XX!   int	   _regtop;			/* Top/bottom of scrolling region */
XX!   int	   _regbottom;
XX! } WINDOW;
XX! 
XX! /* External variables */
XX! extern int LINES;			/* terminal height */
XX! extern int COLS;			/* terminal width */
XX! extern bool NONL;			/* \n causes CR too ? */
XX! extern WINDOW *curscr;			/* the current screen image */
XX! extern WINDOW *stdscr;			/* the default screen window */
XX! extern struct sgttyb _orig_tty, _tty;
XX! 
XX! extern unsigned int ACS_ULCORNER;	/* terminal dependent block grafic */
XX! extern unsigned int ACS_LLCORNER;	/* charcters.  Forget IBM, we are */
XX! extern unsigned int ACS_URCORNER;	/* independent of their charset. :-) */
XX! extern unsigned int ACS_LRCORNER;
XX! extern unsigned int ACS_RTEE;
XX! extern unsigned int ACS_LTEE;
XX! extern unsigned int ACS_BTEE;
XX! extern unsigned int ACS_TTEE;
XX! extern unsigned int ACS_HLINE;
XX! extern unsigned int ACS_VLINE;
XX! extern unsigned int ACS_PLUS;
XX! extern unsigned int ACS_S1;
XX! extern unsigned int ACS_S9;
XX! extern unsigned int ACS_DIAMOND;
XX! extern unsigned int ACS_CKBOARD;
XX! extern unsigned int ACS_DEGREE;
XX! extern unsigned int ACS_PLMINUS;
XX! extern unsigned int ACS_BULLET;
XX! extern unsigned int ACS_LARROW;
XX! extern unsigned int ACS_RARROW;
XX! extern unsigned int ACS_DARROW;
XX! extern unsigned int ACS_UARROW;
XX! extern unsigned int ACS_BOARD;
XX! extern unsigned int ACS_LANTERN;
XX! extern unsigned int ACS_BLOCK;
XX! 
XX! _PROTOTYPE( char *unctrl, (int _c) );
XX! _PROTOTYPE( int baudrate, (void));
XX! _PROTOTYPE( void beep, (void));
XX! _PROTOTYPE( void cbreak, (void));
XX! _PROTOTYPE( void clearok, (WINDOW *_win, bool _flag) );
XX! _PROTOTYPE( void clrscr, (void));
XX! _PROTOTYPE( void curs_set, (int _visibility) );
XX! _PROTOTYPE( void delwin, (WINDOW *_win) );
XX! _PROTOTYPE( void doupdate, (void));
XX! _PROTOTYPE( void echo, (void));
XX! _PROTOTYPE( int endwin, (void));
XX! _PROTOTYPE( int erasechar, (void));
XX! _PROTOTYPE( void fatal, (char *_s) );
XX! _PROTOTYPE( int fixterm, (void));
XX! _PROTOTYPE( void flash, (void));
XX! _PROTOTYPE( int gettmode, (void));
XX! _PROTOTYPE( void idlok, (WINDOW *_win, bool _flag) );
XX! _PROTOTYPE( WINDOW *initscr, (void));
XX! _PROTOTYPE( void keypad, (WINDOW *_win, bool _flag) );
XX! _PROTOTYPE( int killchar, (void));
XX! _PROTOTYPE( void leaveok, (WINDOW *_win, bool _flag) );
XX! _PROTOTYPE( char *longname, (void));
XX! _PROTOTYPE( void meta, (WINDOW *_win, bool _flag) );
XX! _PROTOTYPE( int mvcur, (int _oldy, int _oldx, int _newy, int _newx) );
XX! _PROTOTYPE( int mvinch, (int _y, int _x) );
XX! _PROTOTYPE( int mvprintw, (int _y, int _x, char *_fmt, ...) );
XX! _PROTOTYPE( int mvscanw, (int _y, int _x, char *_fmt, char *_A1, int _A2,
XX! 						int _A3, int _A4, int _A5) );
XX! _PROTOTYPE( int mvwin, (WINDOW *_win, int _begy, int _begx) );
XX! _PROTOTYPE( int mvwinch, (WINDOW *_win, int _y, int _x) );
XX! _PROTOTYPE( int mvwprintw, (WINDOW *_win, int _y, int _x, char *_fmt, ...) );
XX! _PROTOTYPE( int mvwscanw, (WINDOW *_win, int _y, int _x, char *_fmt, char *_A1,
XX! 					int _A2, int _A3, int _A4, int _A5) );
XX! _PROTOTYPE( WINDOW *newwin, (int _num_lines, int _num_cols, int _y, int _x));
XX! _PROTOTYPE( void nl, (void));
XX! _PROTOTYPE( void nocbreak, (void));
XX! _PROTOTYPE( void nodelay, (WINDOW *_win, bool _flag) );
XX! _PROTOTYPE( void noecho, (void));
XX! _PROTOTYPE( void nonl, (void));
XX! _PROTOTYPE( void noraw, (void));
XX! _PROTOTYPE( void outc, (int _c) );
XX! _PROTOTYPE( void overlay, (WINDOW *_win1, WINDOW *_win2) );
XX! _PROTOTYPE( void overwrite, (WINDOW *_win1, WINDOW *_win2) );
XX! _PROTOTYPE( void poscur, (int _r, int _c) );
XX! _PROTOTYPE( int printw, (char *_fmt, ...) );
XX! _PROTOTYPE( void raw, (void));
XX! _PROTOTYPE( int resetterm, (void));
XX! _PROTOTYPE( int saveoldterm, (void));
XX! _PROTOTYPE( int saveterm, (void));
XX! _PROTOTYPE( int savetty, (void));
XX! _PROTOTYPE( int scanw, (char *_fmt, char *_A1, int _A2, int _A3, int _A4,
XX! 					int _A5) );
XX! _PROTOTYPE( void scroll, (WINDOW *_win) );
XX! _PROTOTYPE( void scrollok, (WINDOW *_win, bool _flag) );
XX! _PROTOTYPE( int setscrreg, (int _top, int _bottom) );
XX! _PROTOTYPE( int setterm, (char *_type) );
XX! _PROTOTYPE( int setupterm, (void));
XX! _PROTOTYPE( WINDOW *subwin, (WINDOW *_orig, int _nlines, int _ncols, int _y,
XX! 					int _x));
XX! _PROTOTYPE( int tabsize, (int _ts) );
XX! _PROTOTYPE( void touchwin, (WINDOW *_win) );
XX! _PROTOTYPE( int waddch, (WINDOW *_win, int _c) );
XX! _PROTOTYPE( int waddstr, (WINDOW *_win, char *_str) );
XX! _PROTOTYPE( int wbox, (WINDOW *_win, int _ymin, int _xmin, int _ymax,
XX! 				int _xmax, unsigned int _v, unsigned int _h) );
XX! _PROTOTYPE( void wclear, (WINDOW *_win) );
XX! _PROTOTYPE( int wclrtobot, (WINDOW *_win) );
XX! _PROTOTYPE( int wclrtoeol, (WINDOW *_win) );
XX! _PROTOTYPE( int wdelch, (WINDOW *_win) );
XX! _PROTOTYPE( int wdeleteln, (WINDOW *_win) );
XX! _PROTOTYPE( void werase, (WINDOW *_win) );
XX! _PROTOTYPE( int wgetch, (WINDOW *_win) );
XX! _PROTOTYPE( int wgetstr, (WINDOW *_win, char *_str) );
XX! _PROTOTYPE( int winch, (WINDOW *_win) );
XX! _PROTOTYPE( int winsch, (WINDOW *_win, int _c) );
XX! _PROTOTYPE( int winsertln, (WINDOW *_win) );
XX! _PROTOTYPE( int wmove, (WINDOW *_win, int _y, int _x) );
XX! _PROTOTYPE( void wnoutrefresh, (WINDOW *_win) );
XX! _PROTOTYPE( int wprintw, (WINDOW *_win, char *_fmt, va_list _args, ...));
XX! _PROTOTYPE( void wrefresh, (WINDOW *_win) );
XX! _PROTOTYPE( int wscanw, (WINDOW *_win, char *_fmt, char *_A1, int _A2, int _A3, 
XX! 							int _A4, int _A5) );
XX! _PROTOTYPE( int wsetscrreg, (WINDOW *_win, int _top, int _bottom) );
XX! _PROTOTYPE( int wtabsize, (WINDOW *_win, int _ts) );
XX! 
XX! #define CURSES_H
XX! 
XX! #endif
X/
Xecho x - dirent.h.d
Xsed '/^X/s///' > dirent.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/dirent.h  crc=27217   1338	Sat Apr 21 22:48:42 1990
XX--- /home/top/ast/minix/1.6.25/include/dirent.h  crc=11144   1468	Tue Nov 10 19:33:00 1992
XX***************
XX*** 32,40 ****
XX  #endif
XX  
XX  _PROTOTYPE( int closedir, (DIR *_dirp)					);
XX! _PROTOTYPE( int getdents, (int _fildes, char *_buf, unsigned _nbyte)	);
XX! _PROTOTYPE( DIR *opendir, (char *_dirname)				);
XX  _PROTOTYPE( struct dirent *readdir, (DIR *_dirp)			);
XX  _PROTOTYPE( void rewinddir, (DIR *_dirp)				);
XX  
XX  #endif /* _DIRENT_H */
XX--- 32,45 ----
XX  #endif
XX  
XX  _PROTOTYPE( int closedir, (DIR *_dirp)					);
XX! _PROTOTYPE( DIR *opendir, (const char *_dirname)			);
XX  _PROTOTYPE( struct dirent *readdir, (DIR *_dirp)			);
XX  _PROTOTYPE( void rewinddir, (DIR *_dirp)				);
XX+ 
XX+ #ifdef _MINIX
XX+ _PROTOTYPE( int getdents, (int _fildes, char *_buf, unsigned _nbyte)	);
XX+ _PROTOTYPE( void seekdir, (DIR *_dirp, off_t _loc)			);
XX+ _PROTOTYPE( off_t telldir, (DIR *_dirp)					);
XX+ #endif
XX  
XX  #endif /* _DIRENT_H */
X/
Xecho x - errno.h.d
Xsed '/^X/s///' > errno.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/errno.h  crc=11257   4931	Sat Apr 21 22:49:21 1990
XX--- /home/top/ast/minix/1.6.25/include/errno.h  crc=61309   6035	Tue Nov  3 21:21:49 1992
XX***************
XX*** 31,37 ****
XX  extern int errno;		  /* place where the error numbers go */
XX  
XX  /* Here are the numerical values of the error numbers. */
XX! #define _NERROR               39  /* number of errors */  
XX  
XX  #define ERROR         (_SIGN 99)  /* generic error */
XX  #define EPERM         (_SIGN  1)  /* operation not permitted */
XX--- 31,37 ----
XX  extern int errno;		  /* place where the error numbers go */
XX  
XX  /* Here are the numerical values of the error numbers. */
XX! #define _NERROR               70  /* number of errors */  
XX  
XX  #define ERROR         (_SIGN 99)  /* generic error */
XX  #define EPERM         (_SIGN  1)  /* operation not permitted */
XX***************
XX*** 74,96 ****
XX  #define ENOSYS        (_SIGN 38)  /* function not implemented */
XX  #define ENOTEMPTY     (_SIGN 39)  /* directory not empty */
XX  
XX  /* The following are not POSIX errors, but they can still happen. */
XX  #define ELOCKED      (_SIGN 101)  /* can't send message */
XX  #define EBADCALL     (_SIGN 102)  /* error on send/receive */
XX  
XX  /* The following error codes are generated by the kernel itself. */
XX  #ifdef _SYSTEM
XX! #define E_BAD_DEST        -1	/* destination address illegal */
XX! #define E_BAD_SRC         -2	/* source address illegal */
XX! #define E_TRY_AGAIN       -3	/* can't send-- tables full */
XX! #define E_OVERRUN         -4	/* interrupt for task that is not waiting */
XX! #define E_BAD_BUF         -5	/* message buf outside caller's addr space */
XX! #define E_TASK            -6	/* can't send to task */
XX! #define E_NO_MESSAGE      -7	/* RECEIVE failed: no message present */
XX! #define E_NO_PERM         -8	/* ordinary users can't send to tasks */
XX! #define E_BAD_FCN         -9	/* only valid fcns are SEND, RECEIVE, BOTH */
XX! #define E_BAD_ADDR       -10	/* bad address given to utility routine */
XX! #define E_BAD_PROC       -11	/* bad proc number given to utility */
XX  #endif /* _SYSTEM */
XX  
XX  #endif /* _ERRNO_H */
XX--- 74,115 ----
XX  #define ENOSYS        (_SIGN 38)  /* function not implemented */
XX  #define ENOTEMPTY     (_SIGN 39)  /* directory not empty */
XX  
XX+ /* The following errors relate to networking. */
XX+ #define EPACKSIZE     (_SIGN 50)  /* invalid packet size for some protocol */
XX+ #define EOUTOFBUFS    (_SIGN 51)  /* not enough buffers left */
XX+ #define EBADIOCTL     (_SIGN 52)  /* illegal ioctl for device */
XX+ #define EBADMODE      (_SIGN 53)  /* badmode in ioctl */
XX+ #define EWOULDBLOCK   (_SIGN 54)
XX+ #define EBADDEST      (_SIGN 55)  /* not a valid destination address */
XX+ #define EDSTNOTRCH    (_SIGN 56)  /* destination not reachable */
XX+ #define EISCONN	      (_SIGN 57)  /* all ready connected */
XX+ #define EADDRINUSE    (_SIGN 58)  /* address in use */
XX+ #define ECONNREFUSED  (_SIGN 59)  /* connection refused */
XX+ #define ECONNRESET    (_SIGN 60)  /* connection reset */
XX+ #define ETIMEDOUT     (_SIGN 61)  /* connection timed out */
XX+ #define EURG	      (_SIGN 62)  /* urgent data present */
XX+ #define ENOURG	      (_SIGN 63)  /* no urgent data present */
XX+ #define ENOTCONN      (_SIGN 64)  /* no connection (yet or anymore) */
XX+ #define ESHUTDOWN     (_SIGN 65)  /* a write call to a shutdown connection */
XX+ #define ENOCONN       (_SIGN 66)  /* no such connection */
XX+ 
XX  /* The following are not POSIX errors, but they can still happen. */
XX  #define ELOCKED      (_SIGN 101)  /* can't send message */
XX  #define EBADCALL     (_SIGN 102)  /* error on send/receive */
XX  
XX  /* The following error codes are generated by the kernel itself. */
XX  #ifdef _SYSTEM
XX! #define E_BAD_DEST     -1001	/* destination address illegal */
XX! #define E_BAD_SRC      -1002	/* source address illegal */
XX! #define E_TRY_AGAIN    -1003	/* can't send-- tables full */
XX! #define E_OVERRUN      -1004	/* interrupt for task that is not waiting */
XX! #define E_BAD_BUF      -1005	/* message buf outside caller's addr space */
XX! #define E_TASK         -1006	/* can't send to task */
XX! #define E_NO_MESSAGE   -1007	/* RECEIVE failed: no message present */
XX! #define E_NO_PERM      -1008	/* ordinary users can't send to tasks */
XX! #define E_BAD_FCN      -1009	/* only valid fcns are SEND, RECEIVE, BOTH */
XX! #define E_BAD_ADDR     -1010	/* bad address given to utility routine */
XX! #define E_BAD_PROC     -1011	/* bad proc number given to utility */
XX  #endif /* _SYSTEM */
XX  
XX  #endif /* _ERRNO_H */
X/
Xecho x - fcntl.h.d
Xsed '/^X/s///' > fcntl.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/fcntl.h  crc=21473   2769	Sat Apr 21 22:26:21 1990
XX--- /home/top/ast/minix/1.6.25/include/fcntl.h  crc=46278   2755	Tue Nov  3 21:21:49 1992
XX***************
XX*** 24,32 ****
XX  #define FD_CLOEXEC         1	/* close on exec flag for third arg of fcntl */
XX  
XX  /* L_type values for record locking with fcntl().  POSIX Table 6-3. */
XX! #define F_RDLCK            0	/* shared or read lock */
XX! #define F_WRLCK            1	/* exclusive or write lock */
XX! #define F_UNLCK            2	/* unlock */
XX  
XX  /* Oflag values for open().  POSIX Table 6-4. */
XX  #define O_CREAT        00100	/* creat file if it doesn't exist */
XX--- 24,32 ----
XX  #define FD_CLOEXEC         1	/* close on exec flag for third arg of fcntl */
XX  
XX  /* L_type values for record locking with fcntl().  POSIX Table 6-3. */
XX! #define F_RDLCK            1	/* shared or read lock */
XX! #define F_WRLCK            2	/* exclusive or write lock */
XX! #define F_UNLCK            3	/* unlock */
XX  
XX  /* Oflag values for open().  POSIX Table 6-4. */
XX  #define O_CREAT        00100	/* creat file if it doesn't exist */
XX***************
XX*** 61,67 ****
XX  #include <ansi.h>
XX  #endif
XX  
XX! _PROTOTYPE( int creat, (const char *_path, /* mode_t */ unsigned _mode)	);
XX  _PROTOTYPE( int fcntl, (int _filedes, int _cmd, ...)	  		);
XX  _PROTOTYPE( int open,  (const char *_path, int _oflag, ...) 		);
XX  
XX--- 61,67 ----
XX  #include <ansi.h>
XX  #endif
XX  
XX! _PROTOTYPE( int creat, (const char *_path, Mode_t _mode)		);
XX  _PROTOTYPE( int fcntl, (int _filedes, int _cmd, ...)	  		);
XX  _PROTOTYPE( int open,  (const char *_path, int _oflag, ...) 		);
XX  
X/
Xecho x - float.h.d
Xsed '/^X/s///' > float.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/float.h  crc=61616   1166	Sat Apr 21 22:26:21 1990
XX--- /home/top/ast/minix/1.6.25/include/float.h  crc=36951   1168	Tue Nov  3 21:21:49 1992
XX***************
XX*** 7,13 ****
XX  #define _FLOAT_H
XX  
XX  #define FLT_DIG			6
XX! #define FLT_EPSILON		1.19209290e-07
XX  #define FLT_MANT_DIG		24
XX  #define FLT_MAX			3.40282347e+38F
XX  #define FLT_MAX_10_EXP		38
XX--- 7,13 ----
XX  #define _FLOAT_H
XX  
XX  #define FLT_DIG			6
XX! #define FLT_EPSILON		1.19209290e-07F
XX  #define FLT_MANT_DIG		24
XX  #define FLT_MAX			3.40282347e+38F
XX  #define FLT_MAX_10_EXP		38
XX***************
XX*** 27,33 ****
XX  #define DBL_MIN_EXP		-1021
XX  
XX  #define LDBL_DIG		15
XX! #define LDBL_EPSILON		2.2204460492503131e-16
XX  #define LDBL_MANT_DIG		53
XX  #define LDBL_MAX		1.7976931348623157e+308L
XX  #define LDBL_MAX_10_EXP		308
XX--- 27,33 ----
XX  #define DBL_MIN_EXP		-1021
XX  
XX  #define LDBL_DIG		15
XX! #define LDBL_EPSILON		2.2204460492503131e-16L
XX  #define LDBL_MANT_DIG		53
XX  #define LDBL_MAX		1.7976931348623157e+308L
XX  #define LDBL_MAX_10_EXP		308
X/
Xecho x - grp.h.d
Xsed '/^X/s///' > grp.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/grp.h  crc=38223    674	Sat Apr 21 22:26:21 1990
XX--- /home/top/ast/minix/1.6.25/include/grp.h  crc=43120    680	Tue Nov  3 21:21:49 1992
XX***************
XX*** 15,22 ****
XX  #include <ansi.h>
XX  #endif
XX  
XX! _PROTOTYPE( struct group *getgrgid,  (int _gid)  			);
XX! _PROTOTYPE( struct group *getgrnam, (char *_name) 			);
XX  
XX  #ifdef _MINIX
XX  _PROTOTYPE( void endgrent, (void)					);
XX--- 15,22 ----
XX  #include <ansi.h>
XX  #endif
XX  
XX! _PROTOTYPE( struct group *getgrgid, (Gid_t _gid)  			);
XX! _PROTOTYPE( struct group *getgrnam, (const char *_name)			);
XX  
XX  #ifdef _MINIX
XX  _PROTOTYPE( void endgrent, (void)					);
X/
Xecho x - lib.h.d
Xsed '/^X/s///' > lib.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/lib.h  crc=62253   1213	Sat Apr 21 22:26:21 1990
XX--- /home/top/ast/minix/1.6.25/include/lib.h  crc=45729   1171	Sat Jan 30 20:05:14 1993
XX***************
XX*** 20,39 ****
XX  #include <minix/type.h>
XX  #include <minix/callnr.h>
XX  
XX- extern message _M;
XX- 
XX  #define MM                 0
XX  #define FS                 1
XX  
XX! _PROTOTYPE( int _callm1, (int _proc, int _syscallnr,
XX! 			 int _int1, int _int2, int _int3,
XX! 			 char *_ptr1, char *_ptr2, char *_ptr3)		);
XX! _PROTOTYPE( int _callm3, (int _proc, int _syscallnr, int _int1,
XX! 			 const char *_name)				);
XX! _PROTOTYPE( int _callx, (int _proc, int _syscallnr)			);
XX  _PROTOTYPE( int _len, (const char *_s)					);
XX  _PROTOTYPE( void panic, (const char *_message, int _errnum)		);
XX  _PROTOTYPE( int _sendrec, (int _src_dest, message *_m_ptr)		);
XX! _PROTOTYPE( void begsig, (int dummy)					);
XX  
XX  #endif /* _LIB_H */
XX--- 20,35 ----
XX  #include <minix/type.h>
XX  #include <minix/callnr.h>
XX  
XX  #define MM                 0
XX  #define FS                 1
XX  
XX! _PROTOTYPE( int __execve, (const char *_path, char *const _argv[], 
XX! 			char *const _envp[], int _nargs, int _nenvps)	);
XX! _PROTOTYPE( int _syscall, (int _who, int _syscallnr, message *_msgptr)	);
XX! _PROTOTYPE( void _loadname, (const char *_name, message *_msgptr)	);
XX  _PROTOTYPE( int _len, (const char *_s)					);
XX  _PROTOTYPE( void panic, (const char *_message, int _errnum)		);
XX  _PROTOTYPE( int _sendrec, (int _src_dest, message *_m_ptr)		);
XX! _PROTOTYPE( void _begsig, (int _dummy)					);
XX  
XX  #endif /* _LIB_H */
X/
Xecho x - limits.h.d
Xsed '/^X/s///' > limits.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/limits.h  crc=01828   3219	Sat Apr 21 22:26:21 1990
XX--- /home/top/ast/minix/1.6.25/include/limits.h  crc=09714   3972	Mon Mar  1 20:59:45 1993
XX***************
XX*** 20,49 ****
XX  #define SHRT_MAX       32767	/* maximum value of a short */
XX  #define USHRT_MAX     0xFFFF	/* maximum value of unsigned short */
XX  
XX! /* Definitions about ints (16 bits in MINIX for 8088, 80286, Atari etc) */
XX! #define INT_MIN   (-32767-1)	/* minimum value of an int */
XX! #define INT_MAX        32767	/* maximum value of an int */
XX! #define UINT_MAX      0xFFFF	/* maximum value of an unsigned int */
XX  
XX  /*Definitions about longs (32 bits in MINIX). */
XX! #define LONG_MIN (-2147483647-1)/* minimum value of a long */
XX  #define LONG_MAX  2147483647L	/* maximum value of a long */
XX  #define ULONG_MAX 4294967295L	/* maximum value of an unsigned long */
XX  
XX! /* Minimum sizes required by the POSIX P1003.1 standard (Table 2-2). */
XX  #ifdef _POSIX_SOURCE		/* these are only visible for POSIX */
XX! #define _POSIX_ARG_MAX  4096	/* exec() may have 4K worth of args */
XX! #define _POSIX_CHILD_MAX   6	/* a process may have 6 children */
XX! #define _POSIX_LINK_MAX    8	/* a file may have 8 links */
XX! #define _POSIX_MAX_CANON 255	/* size of the canonical input queue */
XX! #define _POSIX_MAX_INPUT 255	/* you can type 255 chars ahead */
XX! #define _POSIX_NAME_MAX   14	/* a file name may have 14 chars */
XX! #define _POSIX_NGROUPS_MAX 0	/* supplementary group IDs are optional */
XX! #define _POSIX_OPEN_MAX   16	/* a process may have 16 files open */
XX! #define _POSIX_PATH_MAX  255	/* a pathname may contain 255 chars */
XX! #define _POSIX_PIPE_BUF  512	/* pipes writes of 512 bytes must be atomic */
XX  
XX! /* Values actually implemented by MINIX (Tables 2-3, 2-4, and 2-5). */
XX  /* Some of these old names had better be defined when not POSIX. */
XX  #define _NO_LIMIT        100	/* arbitrary number; limit not enforced */
XX  
XX--- 20,60 ----
XX  #define SHRT_MAX       32767	/* maximum value of a short */
XX  #define USHRT_MAX     0xFFFF	/* maximum value of unsigned short */
XX  
XX! /* _EM_WSIZE is a compiler-generated symbol giving the word size in bytes. */
XX! #if _EM_WSIZE == 2
XX! #define INT_MIN   (-32767-1)	/* minimum value of a 16-bit int */
XX! #define INT_MAX        32767	/* maximum value of a 16-bit int */
XX! #define UINT_MAX      0xFFFF	/* maximum value of an unsigned 16-bit int */
XX! #endif
XX  
XX+ #if _EM_WSIZE == 4
XX+ #define INT_MIN (-2147483647-1)	/* minimum value of a 32-bit int */
XX+ #define INT_MAX   2147483647	/* maximum value of a 32-bit int */
XX+ #define UINT_MAX  4294967295	/* maximum value of an unsigned 32-bit int */
XX+ #endif
XX+ 
XX  /*Definitions about longs (32 bits in MINIX). */
XX! #define LONG_MIN (-2147483647L-1)/* minimum value of a long */
XX  #define LONG_MAX  2147483647L	/* maximum value of a long */
XX  #define ULONG_MAX 4294967295L	/* maximum value of an unsigned long */
XX  
XX! /* Minimum sizes required by the POSIX P1003.1 standard (Table 2-3). */
XX  #ifdef _POSIX_SOURCE		/* these are only visible for POSIX */
XX! #define _POSIX_ARG_MAX    4096	/* exec() may have 4K worth of args */
XX! #define _POSIX_CHILD_MAX     6	/* a process may have 6 children */
XX! #define _POSIX_LINK_MAX      8	/* a file may have 8 links */
XX! #define _POSIX_MAX_CANON   255	/* size of the canonical input queue */
XX! #define _POSIX_MAX_INPUT   255	/* you can type 255 chars ahead */
XX! #define _POSIX_NAME_MAX     14	/* a file name may have 14 chars */
XX! #define _POSIX_NGROUPS_MAX   0	/* supplementary group IDs are optional */
XX! #define _POSIX_OPEN_MAX     16	/* a process may have 16 files open */
XX! #define _POSIX_PATH_MAX    255	/* a pathname may contain 255 chars */
XX! #define _POSIX_PIPE_BUF    512	/* pipes writes of 512 bytes must be atomic */
XX! #define _POSIX_STREAM_MAX    8	/* at least 8 FILEs can be open at once */
XX! #define _POSIX_TZNAME_MAX    3	/* time zone names can be at least 3 chars */
XX! #define _POSIX_SSIZE_MAX 32767	/* read() must support 32767 byte reads */
XX  
XX! /* Values actually implemented by MINIX (Tables 2-4, 2-5, 2-6, and 2-7). */
XX  /* Some of these old names had better be defined when not POSIX. */
XX  #define _NO_LIMIT        100	/* arbitrary number; limit not enforced */
XX  
XX***************
XX*** 57,62 ****
XX--- 68,76 ----
XX  #define NAME_MAX          14	/* # chars in a file name */
XX  #define PATH_MAX         255	/* # chars in a path name */
XX  #define PIPE_BUF        7168	/* # bytes in atomic write to a pipe */
XX+ #define STREAM_MAX        20	/* must be the same as FOPEN_MAX in stdio.h */
XX+ #define TZNAME_MAX         3	/* maximum bytes in a time zone name is 3 */
XX+ #define SSIZE_MAX      32767	/* max defined byte count for read() */
XX  
XX  #endif /* _POSIX_SOURCE */
XX  
X/
Xecho x - math.h.d
Xsed '/^X/s///' > math.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/math.h  crc=53819   1315	Sat Apr 21 22:26:21 1990
XX--- /home/top/ast/minix/1.6.25/include/math.h  crc=22013   1392	Tue Nov  3 21:21:50 1992
XX***************
XX*** 3,15 ****
XX  #ifndef _MATH_H
XX  #define _MATH_H
XX  
XX! #define HUGE_VAL	9.9e+999	/* though it will generate a warning */
XX  
XX  /* Function Prototypes. */
XX  #ifndef _ANSI_H
XX  #include <ansi.h>
XX  #endif
XX! 	
XX  _PROTOTYPE( double acos,  (double _x)					);
XX  _PROTOTYPE( double asin,  (double _x)					);
XX  _PROTOTYPE( double atan,  (double _x)					);
XX--- 3,18 ----
XX  #ifndef _MATH_H
XX  #define _MATH_H
XX  
XX! #define HUGE_VAL	(__huge_val())		/* may be infinity */
XX  
XX  /* Function Prototypes. */
XX  #ifndef _ANSI_H
XX  #include <ansi.h>
XX  #endif
XX! 
XX! _PROTOTYPE( double __huge_val,	(void)					);
XX! _PROTOTYPE( int __IsNan,	(double _x)				);
XX! 
XX  _PROTOTYPE( double acos,  (double _x)					);
XX  _PROTOTYPE( double asin,  (double _x)					);
XX  _PROTOTYPE( double atan,  (double _x)					);
X/
Xecho x - mathconst.h.d
Xsed '/^X/s///' > mathconst.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/mathconst.h  crc=32412   1193	Sat Apr 21 22:26:21 1990
XX--- /home/top/ast/minix/1.6.25/include/mathconst.h  crc=13358   1187	Tue Nov  3 21:21:50 1992
XX***************
XX*** 3,12 ****
XX   */
XX  /* $Header: mathconst.h,v 1.3 89/12/18 13:59:33 eck Exp $ */
XX  
XX! #if	!defined(_MATHCONST_H)
XX  #define	_MATHCONST_H
XX  
XX! /* some constants (Hart & Cheney) */
XX  #define	M_PI		3.14159265358979323846264338327950288
XX  #define	M_2PI		6.28318530717958647692528676655900576
XX  #define	M_3PI_4		2.35619449019234492884698253745962716
XX--- 3,12 ----
XX   */
XX  /* $Header: mathconst.h,v 1.3 89/12/18 13:59:33 eck Exp $ */
XX  
XX! #ifndef _MATHCONST_H
XX  #define	_MATHCONST_H
XX  
XX! /* Some constants (Hart & Cheney) */
XX  #define	M_PI		3.14159265358979323846264338327950288
XX  #define	M_2PI		6.28318530717958647692528676655900576
XX  #define	M_3PI_4		2.35619449019234492884698253745962716
XX***************
XX*** 26,29 ****
XX  #define	M_1_SQRT2	0.70710678118654752440084436210484904
XX  #define	M_EULER		0.57721566490153286060651209008240243
XX  
XX! #endif	/* _MATHCONST_H */
XX--- 26,29 ----
XX  #define	M_1_SQRT2	0.70710678118654752440084436210484904
XX  #define	M_EULER		0.57721566490153286060651209008240243
XX  
XX! #endif /* _MATHCONST_H */
X/
Xecho x - pwd.h.d
Xsed '/^X/s///' > pwd.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/pwd.h  crc=44431    855	Sat Apr 21 22:26:22 1990
XX--- /home/top/ast/minix/1.6.25/include/pwd.h  crc=30641    883	Tue Nov 10 19:33:00 1992
XX***************
XX*** 21,30 ****
XX  #include <ansi.h>
XX  #endif
XX  
XX  _PROTOTYPE( void endpwent, (void)					);
XX- _PROTOTYPE( struct passwd *getpwnam, (char *_name)			);
XX- _PROTOTYPE( struct passwd *getpwuid, (int _uid)				);
XX  _PROTOTYPE( struct passwd *getpwent, (void)				);
XX  _PROTOTYPE( int setpwent, (void)					);
XX  
XX  #endif /* _PWD_H */
XX--- 21,33 ----
XX  #include <ansi.h>
XX  #endif
XX  
XX+ _PROTOTYPE( struct passwd *getpwnam, (const char *_name)		);
XX+ _PROTOTYPE( struct passwd *getpwuid, (Uid_t _uid)			);
XX+ 
XX+ #ifdef _MINIX
XX  _PROTOTYPE( void endpwent, (void)					);
XX  _PROTOTYPE( struct passwd *getpwent, (void)				);
XX  _PROTOTYPE( int setpwent, (void)					);
XX+ #endif
XX  
XX  #endif /* _PWD_H */
X/
Xecho x - sgtty.h.d
Xsed '/^X/s///' > sgtty.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/sgtty.h  crc=01109   2793	Sat Apr 21 22:26:22 1990
XX--- /home/top/ast/minix/1.6.25/include/sgtty.h  crc=27089   4353	Thu Apr  8 19:20:36 1993
XX***************
XX*** 44,49 ****
XX--- 44,50 ----
XX  #define B2400		  24
XX  #define B4800		  48
XX  #define B9600 		  96
XX+ #define B19200		 192
XX  
XX  #define TIOCGETP (('t'<<8) | 8)
XX  #define TIOCSETP (('t'<<8) | 9)
XX***************
XX*** 74,82 ****
XX  #define BSDELAY      0100000
XX  #define ALLDELAY     0177400
XX  
XX  #if MACHINE == ATARI
XX- /* ST specific clock stuff */
XX  
XX  #define	 DCLOCK	('D'<<8)
XX  
XX  #define	DC_RBMS100	(DCLOCK|1)
XX--- 75,103 ----
XX  #define BSDELAY      0100000
XX  #define ALLDELAY     0177400
XX  
XX+ /* screen stuff */
XX+ 
XX+ #define	SCR	('S'<<8)
XX+ #define SCR_ATTR	(SCR | 1)
XX+ #define SCR_SETCOL	(SCR | 2)
XX+ #define SCR_GETCOL	(SCR | 3)
XX+ #define SCR_SETCOLMAP	(SCR | 4)
XX+ #define SCR_GETCOLMAP	(SCR | 5)
XX+ 
XX+ #ifdef MACHINE
XX+ 
XX  #if MACHINE == ATARI
XX  
XX+ /* declaration for font header */
XX+ struct fnthdr {
XX+ 	char width;
XX+ 	char heigth;
XX+ 	void *addr;
XX+ };
XX+ 
XX+ #define VDU_LOADFONT ('F' << 8)
XX+ 
XX+ /* ST specific clock stuff */
XX  #define	 DCLOCK	('D'<<8)
XX  
XX  #define	DC_RBMS100	(DCLOCK|1)
XX***************
XX*** 85,96 ****
XX  #define	DC_RICD  	(DCLOCK|4)
XX  #define	DC_WBMS100	(DCLOCK|8)
XX  #define	DC_WBMS200	(DCLOCK|9)
XX! #endif
XX  
XX  #include <ansi.h>
XX  
XX  _PROTOTYPE( int gtty, (int _fd, struct sgttyb *_argp)			);
XX! _PROTOTYPE( int ioctl, (int _fd, int _request, struct sgttyb *_argp)	);
XX  _PROTOTYPE( int stty, (int _fd, struct sgttyb *_argp)			);
XX  
XX  #endif /* _SGTTY_H */
XX--- 106,148 ----
XX  #define	DC_RICD  	(DCLOCK|4)
XX  #define	DC_WBMS100	(DCLOCK|8)
XX  #define	DC_WBMS200	(DCLOCK|9)
XX! #endif /* MACHINE == ATARI */
XX  
XX+ #if MACHINE == SUN_4_60
XX+ /* Window size support, not really SparcStation specific */
XX+ struct winsize {
XX+   unsigned short ws_row;	/* number of character rows */
XX+   unsigned short ws_col;	/* number of characters per line */
XX+   unsigned short ws_xpixel;	/* horizontal character size in pixels */
XX+   unsigned short ws_ypixel;	/* vertical character size in pixels */
XX+ };
XX+ 
XX+ #define TIOCGWINSZ (('t'<<8) | 104)	/* get window size */
XX+ #define TIOCSWINSZ (('t'<<8) | 103)	/* set window size */
XX+ 
XX+ /* SparcStation specific floppy support: */
XX+ struct diskio {
XX+   int  f_cyl;			/* disk cylinder number */
XX+   unsigned char f_head;		/* disk head (aka 'side' or 'track') number */
XX+   unsigned char f_sec;		/* sector number (not used at the moment */
XX+   unsigned char f_density;	/* bit density (data rate): HIGH_D or LOW_D */
XX+   char *f_buf;			/* address of data */
XX+   int  f_cnt;			/* length of buffer in bytes */
XX+ };
XX+ 
XX+ #define TIOCEJECT (('f'<<8) | 0)	/* Floppy disk eject */
XX+ #define TIOCFORMAT (('f'<<8) | 1)	/* Format one track */
XX+ 
XX+ #define LOW_D		1	/* Actually: `normal' density MFM (250Kb/s) */
XX+ #define HIGH_D		0	/* `high' density MFM (500Kb/s) */
XX+ #endif /* MACHINE == SUN_4_60 */
XX+ 
XX+ #endif /* MACHINE defined */
XX+ 
XX  #include <ansi.h>
XX  
XX  _PROTOTYPE( int gtty, (int _fd, struct sgttyb *_argp)			);
XX! _PROTOTYPE( int ioctl, (int _fd, int _request, struct sgttyb * _argp)	);
XX  _PROTOTYPE( int stty, (int _fd, struct sgttyb *_argp)			);
XX  
XX  #endif /* _SGTTY_H */
X/
Xecho x - signal.h.d
Xsed '/^X/s///' > signal.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/signal.h  crc=07877   4183	Sat Apr 21 22:26:22 1990
XX--- /home/top/ast/minix/1.6.25/include/signal.h  crc=15449   4642	Thu Nov  5 20:58:39 1992
XX***************
XX*** 6,22 ****
XX  #ifndef _SIGNAL_H
XX  #define _SIGNAL_H
XX  
XX  /* Here are types that are closely associated with signal handling. */
XX  typedef int sig_atomic_t;
XX  
XX! #ifdef	_POSIX_SOURCE
XX! typedef unsigned short sigset_t;
XX  #endif
XX  
XX- 
XX  #define _NSIG             16	/* number of signals used */
XX  
XX! #define SIGHUP	           1	/* hangup */
XX  #define SIGINT             2	/* interrupt (DEL) */
XX  #define SIGQUIT            3	/* quit (ASCII FS) */
XX  #define SIGILL             4	/* illegal instruction */
XX--- 6,28 ----
XX  #ifndef _SIGNAL_H
XX  #define _SIGNAL_H
XX  
XX+ #ifndef _ANSI_H
XX+ #include <ansi.h>
XX+ #endif
XX+ 
XX  /* Here are types that are closely associated with signal handling. */
XX  typedef int sig_atomic_t;
XX  
XX! #ifdef _POSIX_SOURCE
XX! #ifndef _SIGSET_T
XX! #define _SIGSET_T
XX! typedef unsigned long sigset_t;
XX  #endif
XX+ #endif
XX  
XX  #define _NSIG             16	/* number of signals used */
XX  
XX! #define SIGHUP             1	/* hangup */
XX  #define SIGINT             2	/* interrupt (DEL) */
XX  #define SIGQUIT            3	/* quit (ASCII FS) */
XX  #define SIGILL             4	/* illegal instruction */
XX***************
XX*** 47,114 ****
XX  #define SIGTTIN           21	/* background process wants to read */
XX  #define SIGTTOU           22	/* background process wants to write */
XX  
XX  #ifdef _POSIX_SOURCE
XX! #define SA_NOCLDSTOP       1	/* signal parent if child stops */
XX! 
XX! #endif /* _POSIX_SOURCE */
XX! 
XX! /* POSIX requires these values for use on system calls involving signals. */
XX! #define SIG_BLOCK          0	/* for blocking signals */
XX! #define SIG_UNBLOCK        1	/* for unblocking signals */
XX! #define SIG_SETMASK        2	/* for setting the signal mask */
XX! 
XX! #ifndef _ANSI_H
XX! #include <ansi.h>
XX  #endif
XX  
XX! /* Macros used as function pointers and one awful prototype. */
XX! #if _ANSI
XX! #define SIG_DFL		((void (*)(int))0)	/* default signal handling */
XX! #define SIG_IGN		((void (*)(int))1)	/* ignore signal */
XX! #define SIG_ERR		((void (*)(int))-1)
XX  
XX- void (*signal(int _sig, void (*_func)(int)))(int);
XX- 
XX  #ifdef _POSIX_SOURCE
XX  struct sigaction {
XX!   void (*sa_handler)(int);	/* SIG_DFL, SIG_IGN, or pointer to function */
XX    sigset_t sa_mask;		/* signals to be blocked during handler */
XX    int sa_flags;			/* special flags */
XX  };
XX- #endif
XX  
XX! #else	/* !_ANSI */
XX! #define SIG_DFL		((void (*)())0)		/* default signal handling */
XX! #define SIG_IGN		((void (*)())1)		/* ignore signal */
XX! #define SIG_ERR		((void (*)())-1)
XX  
XX! void (*signal()) ();
XX  
XX! #ifdef _POSIX_SOURCE		/* otherwise sigset_t is not defined */
XX! struct sigaction {
XX!   void (*sa_handler)();		/* SIG_DFL, SIG_IGN, or pointer to function */
XX!   sigset_t sa_mask;		/* signals to be blocked during handler */
XX!   int sa_flags;			/* special flags */
XX! };
XX! #endif
XX! 
XX! #endif	/* _ANSI */
XX! 
XX! /* Function Prototypes. */
XX  _PROTOTYPE( int raise, (int _sig)					);
XX  
XX  #ifdef _POSIX_SOURCE
XX  _PROTOTYPE( int kill, (pid_t _pid, int _sig)				);
XX! _PROTOTYPE( int sigaddset, (sigset_t *_set)				);
XX! _PROTOTYPE( int sigdelset, (sigset_t *_set)				);
XX  _PROTOTYPE( int sigemptyset, (sigset_t *_set)				);
XX  _PROTOTYPE( int sigfillset, (sigset_t *_set)				);
XX! _PROTOTYPE( int sigismember, (sigset_t *_set, int _signo)		);
XX! _PROTOTYPE( int sigpending, (sigset_t *set)				);
XX! _PROTOTYPE( int sigprocmask, (int _how, sigset_t *_set, sigset_t *_oset));
XX! _PROTOTYPE( int sigsuspend, (sigset_t *_sigmask)			);
XX! _PROTOTYPE( int sigaction,
XX! 	    (int _sig, struct sigaction *_a, struct sigaction *_oact)	);
XX  #endif
XX  
XX  #endif /* _SIGNAL_H */
XX--- 53,113 ----
XX  #define SIGTTIN           21	/* background process wants to read */
XX  #define SIGTTOU           22	/* background process wants to write */
XX  
XX+ /* The sighandler_t type is not allowed unless _POSIX_SOURCE is defined. */
XX  #ifdef _POSIX_SOURCE
XX! #define __sighandler_t sighandler_t
XX! #else
XX! typedef void (*__sighandler_t) (int);
XX  #endif
XX  
XX! /* Macros used as function pointers. */
XX! #define SIG_ERR    ((__sighandler_t) -1)	/* error return */
XX! #define SIG_DFL	   ((__sighandler_t)  0)	/* default signal handling */
XX! #define SIG_IGN	   ((__sighandler_t)  1)	/* ignore signal */
XX! #define SIG_HOLD   ((__sighandler_t)  2)	/* block signal */
XX! #define SIG_CATCH  ((__sighandler_t)  3)	/* catch signal */
XX  
XX  #ifdef _POSIX_SOURCE
XX  struct sigaction {
XX!   __sighandler_t sa_handler;	/* SIG_DFL, SIG_IGN, or pointer to function */
XX    sigset_t sa_mask;		/* signals to be blocked during handler */
XX    int sa_flags;			/* special flags */
XX  };
XX  
XX! /* Fields for sa_flags. */
XX! #define SA_ONSTACK   0x0001	/* deliver signal on alternate stack */
XX! #define SA_RESETHAND 0x0002	/* reset signal handler when signal caught */
XX! #define SA_NODEFER   0x0004	/* don't block signal while catching it */
XX! #define SA_RESTART   0x0008	/* automatic system call restart */
XX! #define SA_SIGINFO   0x0010	/* extended signal handling */
XX! #define SA_NOCLDWAIT 0x0020	/* don't create zombies */
XX! #define SA_NOCLDSTOP 0x0040	/* don't receive SIGCHLD when child stops */
XX! #define SA_COMPAT    0x0080	/* internal flag for old signal catchers */
XX  
XX! /* POSIX requires these values for use with sigprocmask(2). */
XX! #define SIG_BLOCK          0	/* for blocking signals */
XX! #define SIG_UNBLOCK        1	/* for unblocking signals */
XX! #define SIG_SETMASK        2	/* for setting the signal mask */
XX! #define SIG_INQUIRE        4	/* for internal use only */
XX! #endif	/* _POSIX_SOURCE */
XX  
XX! /* POSIX and ANSI function prototypes. */
XX  _PROTOTYPE( int raise, (int _sig)					);
XX+ _PROTOTYPE( __sighandler_t signal, (int _sig, __sighandler_t _func)	);
XX  
XX  #ifdef _POSIX_SOURCE
XX  _PROTOTYPE( int kill, (pid_t _pid, int _sig)				);
XX! _PROTOTYPE( int sigaction,
XX!     (int _sig, const struct sigaction *_act, struct sigaction *_oact)	);
XX! _PROTOTYPE( int sigaddset, (sigset_t *_set, int _sig)			);
XX! _PROTOTYPE( int sigdelset, (sigset_t *_set, int _sig)			);
XX  _PROTOTYPE( int sigemptyset, (sigset_t *_set)				);
XX  _PROTOTYPE( int sigfillset, (sigset_t *_set)				);
XX! _PROTOTYPE( int sigismember, (sigset_t *_set, int _sig)			);
XX! _PROTOTYPE( int sigpending, (sigset_t *_set)				);
XX! _PROTOTYPE( int sigprocmask,
XX! 	    (int _how, const sigset_t *_set, sigset_t *_oset)		);
XX! _PROTOTYPE( int sigsuspend, (const sigset_t *_sigmask)			);
XX  #endif
XX  
XX  #endif /* _SIGNAL_H */
X/
Xecho x - stdarg.h.d
Xsed '/^X/s///' > stdarg.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/stdarg.h  crc=05705   1167	Sat Apr 21 22:26:22 1990
XX--- /home/top/ast/minix/1.6.25/include/stdarg.h  crc=12749   2859	Tue Nov  3 21:21:51 1992
XX***************
XX*** 11,23 ****
XX   *	va_start(ap, parmN)	prepare to access parameters
XX   *	va_arg(ap, type)	get next parameter value and type
XX   *	va_end(ap)		access is finished
XX   */
XX  
XX  #ifndef _STDARG_H
XX  #define _STDARG_H
XX  
XX- typedef	char *va_list;
XX  
XX  #define __vasz(x)		((sizeof(x)+sizeof(int)-1) & ~(sizeof(int) -1))
XX  
XX  #define va_start(ap, parmN)	((ap) = (va_list)&parmN + __vasz(parmN))
XX--- 11,81 ----
XX   *	va_start(ap, parmN)	prepare to access parameters
XX   *	va_arg(ap, type)	get next parameter value and type
XX   *	va_end(ap)		access is finished
XX+  *
XX+  * Ken Thompson's famous line from V6 UNIX is equally applicable to this file:
XX+  *
XX+  *	"You are not expected to understand this"
XX+  *
XX   */
XX  
XX  #ifndef _STDARG_H
XX  #define _STDARG_H
XX  
XX  
XX+ #ifdef __GNUC__
XX+ /* The GNU C-compiler uses its own, but similar varargs mechanism. */
XX+ 
XX+ typedef char *va_list;
XX+ 
XX+ /* Amount of space required in an argument list for an arg of type TYPE.
XX+  * TYPE may alternatively be an expression whose type is used.
XX+  */
XX+ 
XX+ #define __va_rounded_size(TYPE)  \
XX+   (((sizeof (TYPE) + sizeof (int) - 1) / sizeof (int)) * sizeof (int))
XX+ 
XX+ #if __GNUC__ < 2
XX+ 
XX+ #ifndef __sparc__
XX+ #define va_start(AP, LASTARG)                                           \
XX+  (AP = ((char *) &(LASTARG) + __va_rounded_size (LASTARG)))
XX+ #else
XX+ #define va_start(AP, LASTARG)                                           \
XX+  (__builtin_saveregs (),                                                \
XX+   AP = ((char *) &(LASTARG) + __va_rounded_size (LASTARG)))
XX+ #endif
XX+ 
XX+ void va_end (va_list);          /* Defined in gnulib */
XX+ #define va_end(AP)
XX+ 
XX+ #define va_arg(AP, TYPE)                                                \
XX+  (AP += __va_rounded_size (TYPE),                                       \
XX+   *((TYPE *) (AP - __va_rounded_size (TYPE))))
XX+ 
XX+ #else	/* __GNUC__ >= 2 */
XX+ 
XX+ #ifndef __sparc__
XX+ #define va_start(AP, LASTARG) 						\
XX+  (AP = ((char *) __builtin_next_arg ()))
XX+ #else
XX+ #define va_start(AP, LASTARG)					\
XX+   (__builtin_saveregs (), AP = ((char *) __builtin_next_arg ()))
XX+ #endif
XX+ 
XX+ void va_end (va_list);		/* Defined in libgcc.a */
XX+ #define va_end(AP)
XX+ 
XX+ #define va_arg(AP, TYPE)						\
XX+  (AP = ((char *) (AP)) += __va_rounded_size (TYPE),			\
XX+   *((TYPE *) ((char *) (AP) - __va_rounded_size (TYPE))))
XX+ 
XX+ #endif	/* __GNUC__ >= 2 */
XX+ 
XX+ #else	/* not __GNUC__ */
XX+ 
XX+ 
XX+ typedef char *va_list;
XX+ 
XX  #define __vasz(x)		((sizeof(x)+sizeof(int)-1) & ~(sizeof(int) -1))
XX  
XX  #define va_start(ap, parmN)	((ap) = (va_list)&parmN + __vasz(parmN))
XX***************
XX*** 25,29 ****
XX--- 83,90 ----
XX    (*((type *)((va_list)((ap) = (void *)((va_list)(ap) + __vasz(type))) \
XX  						    - __vasz(type))))
XX  #define va_end(ap)
XX+ 
XX+ 
XX+ #endif /* __GNUC__ */
XX  
XX  #endif /* _STDARG_H */
X/
Xecho x - stddef.h.d
Xsed '/^X/s///' > stddef.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/stddef.h  crc=63716    550	Sat Apr 21 22:26:22 1990
XX--- /home/top/ast/minix/1.6.25/include/stddef.h  crc=22676    656	Tue Nov  3 21:21:51 1992
XX***************
XX*** 6,14 ****
XX  #define NULL   ((void *)0)
XX  
XX  /* The following is not portable, but the compiler accepts it. */
XX! #define offsetof(type, ident)		((size_t) &(((type *)0)->ident))
XX  
XX  typedef int ptrdiff_t;		/* result of subtracting two pointers */
XX  
XX  #ifndef _SIZE_T
XX  #define _SIZE_T
XX--- 6,18 ----
XX  #define NULL   ((void *)0)
XX  
XX  /* The following is not portable, but the compiler accepts it. */
XX! #define offsetof(type, ident)	((size_t) (unsigned long) &((type *)0)->ident)
XX  
XX+ #if _EM_PSIZE == _EM_WSIZE
XX  typedef int ptrdiff_t;		/* result of subtracting two pointers */
XX+ #else	/* _EM_PSIZE == _EM_LSIZE */
XX+ typedef long ptrdiff_t;
XX+ #endif
XX  
XX  #ifndef _SIZE_T
XX  #define _SIZE_T
X/
Xecho x - stdlib.h.d
Xsed '/^X/s///' > stdlib.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/stdlib.h  crc=49463   2639	Sat Apr 21 22:26:22 1990
XX--- /home/top/ast/minix/1.6.25/include/stdlib.h  crc=20841   2744	Tue Nov 10 21:23:32 1992
XX***************
XX*** 32,38 ****
XX  
XX  _PROTOTYPE( void abort, (void)						);
XX  _PROTOTYPE( int abs, (int _j)						);
XX! _PROTOTYPE( int atexit, (void (*func)(void))				);
XX  _PROTOTYPE( double atof, (const char *_nptr)				);
XX  _PROTOTYPE( int atoi, (const char *_nptr)				);
XX  _PROTOTYPE( long atol, (const char *_nptr)				);
XX--- 32,38 ----
XX  
XX  _PROTOTYPE( void abort, (void)						);
XX  _PROTOTYPE( int abs, (int _j)						);
XX! _PROTOTYPE( int atexit, (void (*_func)(void))				);
XX  _PROTOTYPE( double atof, (const char *_nptr)				);
XX  _PROTOTYPE( int atoi, (const char *_nptr)				);
XX  _PROTOTYPE( long atol, (const char *_nptr)				);
XX***************
XX*** 54,66 ****
XX  _PROTOTYPE( long strtol, (const char *_nptr, char **_endptr, int _base)	);
XX  _PROTOTYPE( int system, (const char *_string)				);
XX  _PROTOTYPE( size_t wcstombs, (char *_s, const wchar_t *_pwcs, size_t _n));
XX! _PROTOTYPE( int wctomb, (char *_s, int _wchar)				);
XX! _PROTOTYPE( void *bsearch,
XX! 	(const void *_key, const void *_base, size_t _nmemb,
XX! 	size_t _size, int (*_compar) (const void *, const void *))	);
XX  _PROTOTYPE( void qsort, (void *_base, size_t _nmemb, size_t _size,
XX! 	int (*_compar) (const void *, const void *))			);
XX  _PROTOTYPE( unsigned long int strtoul,
XX  			(const char *_nptr, char **_endptr, int _base)	);
XX  
XX  #endif /* STDLIB_H */
XX--- 54,70 ----
XX  _PROTOTYPE( long strtol, (const char *_nptr, char **_endptr, int _base)	);
XX  _PROTOTYPE( int system, (const char *_string)				);
XX  _PROTOTYPE( size_t wcstombs, (char *_s, const wchar_t *_pwcs, size_t _n));
XX! _PROTOTYPE( int wctomb, (char *_s, wchar_t _wchar)			);
XX! _PROTOTYPE( void *bsearch, (const void *_key, const void *_base, 
XX! 	size_t _nmemb, size_t _size, 
XX! 	int (*compar) (const void *, const void *))			);
XX  _PROTOTYPE( void qsort, (void *_base, size_t _nmemb, size_t _size,
XX! 	int (*compar) (const void *, const void *))			);
XX  _PROTOTYPE( unsigned long int strtoul,
XX  			(const char *_nptr, char **_endptr, int _base)	);
XX+ 
XX+ #ifdef _MINIX
XX+ _PROTOTYPE(int getopt, (int _argc, char **_argv, char *_opts));
XX+ #endif /* _MINIX */
XX  
XX  #endif /* STDLIB_H */
X/
Xecho x - string.h.d
Xsed '/^X/s///' > string.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/string.h  crc=28161   2238	Sat Apr 21 22:26:22 1990
XX--- /home/top/ast/minix/1.6.25/include/string.h  crc=39513   2250	Tue Nov 10 19:33:00 1992
XX***************
XX*** 10,44 ****
XX  #ifndef _SIZE_T
XX  #define _SIZE_T
XX  typedef unsigned int size_t;	/* type returned by sizeof */
XX! #endif
XX  
XX  /* Function Prototypes. */
XX  #ifndef _ANSI_H
XX  #include <ansi.h>
XX  #endif
XX  
XX  _PROTOTYPE( void *memcpy, (void *_s1, const void *_s2, size_t _n)	);
XX  _PROTOTYPE( void *memmove, (void *_s1, const void *_s2, size_t _n)	);
XX! _PROTOTYPE( char *strcpy, (char *_s1, const char *_s2)			);
XX! _PROTOTYPE( char *strncpy, (char *_s1, const char *_s2, size_t _n)	);
XX  _PROTOTYPE( char *strcat, (char *_s1, const char *_s2)			);
XX! _PROTOTYPE( char *strncat, (char *_s1, const char *_s2, size_t _n)	);
XX! _PROTOTYPE( int memcmp, (const void *_s1, const void *_s2, size_t _n)	);
XX  _PROTOTYPE( int strcmp, (const char *_s1, const char *_s2)		);
XX  _PROTOTYPE( int strcoll, (const char *_s1, const char *_s2)		);
XX! _PROTOTYPE( int strncmp, (const char *_s1, const char *_s2, size_t _n)	);
XX! _PROTOTYPE( size_t strxfrm, (char *_s1, const char *_s2, size_t _n)	);
XX! _PROTOTYPE( void *memchr, (const void *_s, int _c, size_t _n)		);
XX! _PROTOTYPE( char *strchr, (const char *_s, int _c)			);
XX  _PROTOTYPE( size_t strcspn, (const char *_s1, const char *_s2)		);
XX  _PROTOTYPE( char *strpbrk, (const char *_s1, const char *_s2)		);
XX  _PROTOTYPE( char *strrchr, (const char *_s, int _c)			);
XX  _PROTOTYPE( size_t strspn, (const char *_s1, const char *_s2)		);
XX  _PROTOTYPE( char *strstr, (const char *_s1, const char *_s2)		);
XX  _PROTOTYPE( char *strtok, (char *_s1, const char *_s2)			);
XX! _PROTOTYPE( void *memset, (void *_s, int _c, size_t _n)			);
XX! _PROTOTYPE( char *strerror, ( int _errnum)				);
XX! _PROTOTYPE( size_t strlen, (const char *_s)				);
XX  
XX  #ifdef _MINIX
XX  /* For backward compatibility. */
XX--- 10,44 ----
XX  #ifndef _SIZE_T
XX  #define _SIZE_T
XX  typedef unsigned int size_t;	/* type returned by sizeof */
XX! #endif /*_SIZE_T */
XX  
XX  /* Function Prototypes. */
XX  #ifndef _ANSI_H
XX  #include <ansi.h>
XX  #endif
XX  
XX+ _PROTOTYPE( void *memchr, (const void *_s, int _c, size_t _n)		);
XX+ _PROTOTYPE( int memcmp, (const void *_s1, const void *_s2, size_t _n)	);
XX  _PROTOTYPE( void *memcpy, (void *_s1, const void *_s2, size_t _n)	);
XX  _PROTOTYPE( void *memmove, (void *_s1, const void *_s2, size_t _n)	);
XX! _PROTOTYPE( void *memset, (void *_s, int _c, size_t _n)			);
XX  _PROTOTYPE( char *strcat, (char *_s1, const char *_s2)			);
XX! _PROTOTYPE( char *strchr, (const char *_s, int _c)			);
XX! _PROTOTYPE( int strncmp, (const char *_s1, const char *_s2, size_t _n)	);
XX  _PROTOTYPE( int strcmp, (const char *_s1, const char *_s2)		);
XX  _PROTOTYPE( int strcoll, (const char *_s1, const char *_s2)		);
XX! _PROTOTYPE( char *strcpy, (char *_s1, const char *_s2)			);
XX  _PROTOTYPE( size_t strcspn, (const char *_s1, const char *_s2)		);
XX+ _PROTOTYPE( char *strerror, (int _errnum)				);
XX+ _PROTOTYPE( size_t strlen, (const char *_s)				);
XX+ _PROTOTYPE( char *strncat, (char *_s1, const char *_s2, size_t _n)	);
XX+ _PROTOTYPE( char *strncpy, (char *_s1, const char *_s2, size_t _n)	);
XX  _PROTOTYPE( char *strpbrk, (const char *_s1, const char *_s2)		);
XX  _PROTOTYPE( char *strrchr, (const char *_s, int _c)			);
XX  _PROTOTYPE( size_t strspn, (const char *_s1, const char *_s2)		);
XX  _PROTOTYPE( char *strstr, (const char *_s1, const char *_s2)		);
XX  _PROTOTYPE( char *strtok, (char *_s1, const char *_s2)			);
XX! _PROTOTYPE( size_t strxfrm, (char *_s1, const char *_s2, size_t _n)	);
XX  
XX  #ifdef _MINIX
XX  /* For backward compatibility. */
X/
Xecho x - termios.h.d
Xsed '/^X/s///' > termios.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/termios.h  crc=04437   6195	Sat Apr 21 22:26:22 1990
XX--- /home/top/ast/minix/1.6.25/include/termios.h  crc=49363   7113	Wed Feb  3 01:05:24 1993
XX***************
XX*** 3,23 ****
XX  #ifndef _TERMIOS_H
XX  #define _TERMIOS_H
XX  
XX  typedef unsigned short tcflag_t;
XX  typedef unsigned char cc_t;
XX! typedef unsigned int speed_t;
XX  
XX! #define NCCS		11	/* size of cc_c array */
XX  
XX! /* Primary terminal control structure. POSIX Table 7-1. */
XX  struct termios {
XX    tcflag_t c_iflag;		/* input modes */
XX    tcflag_t c_oflag;		/* output modes */
XX    tcflag_t c_cflag;		/* control modes */
XX    tcflag_t c_lflag;		/* local modes */
XX-   speed_t  c_ispeed;		/* input speed */
XX-   speed_t  c_ospeed;		/* output speed */
XX    cc_t c_cc[NCCS];		/* control characters */
XX  };
XX  
XX  /* Values for termios c_iflag bit map.  POSIX Table 7-2. */
XX--- 3,27 ----
XX  #ifndef _TERMIOS_H
XX  #define _TERMIOS_H
XX  
XX+ #define _TERMIOS_EMULATION 1	/* this is an emulation, not a real termios */
XX+ 
XX  typedef unsigned short tcflag_t;
XX  typedef unsigned char cc_t;
XX! typedef unsigned long speed_t;
XX  
XX! #define NCCS		11	/* size of c_cc array */
XX  
XX! /* Primary terminal control structure.  POSIX Table 7-1. */
XX  struct termios {
XX    tcflag_t c_iflag;		/* input modes */
XX    tcflag_t c_oflag;		/* output modes */
XX    tcflag_t c_cflag;		/* control modes */
XX    tcflag_t c_lflag;		/* local modes */
XX    cc_t c_cc[NCCS];		/* control characters */
XX+ 
XX+   /* The rest of the structure is implementation-defined. */
XX+   speed_t _c_ispeed;		/* input speed */
XX+   speed_t _c_ospeed;		/* output speed */
XX  };
XX  
XX  /* Values for termios c_iflag bit map.  POSIX Table 7-2. */
XX***************
XX*** 36,41 ****
XX--- 40,51 ----
XX  /* Values for termios c_oflag bit map.  POSIX Sec. 7.1.2.3. */
XX  #define OPOST         000001	/* perform output processing */
XX  
XX+ /* The following is stolen from <sgtty.h> and must match. */
XX+ #if defined(_MINIX) || !defined(_POSIX_SOURCE)
XX+ #define XTABS	     0006000	/* do tab expansion */
XX+ #define CRMOD	     0000020	/* map lf to cr + lf */
XX+ #endif
XX+ 
XX  /* Values for termios c_cflag bit map.  POSIX Table 7-3. */
XX  #define CLOCAL        000001	/* ignore modem status lines */
XX  #define CREAD         000002	/* enable receiver */
XX***************
XX*** 59,96 ****
XX  #define IEXTEN        000040	/* enable extended functions */
XX  #define ISIG          000100	/* enable signals */
XX  #define NOFLSH        000200	/* disable flush after interrupt or quit */
XX! #define TOSTOP        000400	/* send SIGTTOU (job control, not implemented*/
XX  
XX  /* Indices into c_cc array.  Default values in parentheses. POSIX Table 7-5. */
XX! #define VEOF               0	/* cc_c[VEOF] = EOF char (CTRL-D) */
XX! #define VEOL               1	/* cc_c[VEOL] = EOL char (??) */
XX! #define VERASE             2	/* cc_c[VERASE] = ERASE char (CTRL-H) */
XX! #define VINTR              3	/* cc_c[VINTR] = INTR char (DEL) */
XX! #define VKILL              4	/* cc_c[VKILL] = KILL char (@) */
XX! #define VMIN               5	/* cc_c[VMIN] = MIN value for timer */
XX! #define VQUIT              6	/* cc_c[VQUIT] = QUIT char (CTRL-\) */
XX! #define VTIME              7	/* cc_c[VTIME] = TIME value for timer */
XX! #define VSUSP              8	/* cc_c[VSUSP] = SUSP (job control, not impl */
XX! #define VSTART             9	/* cc_c[VSTART] = START char (always CTRL-S) */
XX! #define VSTOP             10	/* cc_c[VSTOP] = STOP char (always CTRL-Q) */
XX  
XX  /* Values for the baud rate settings.  POSIX Table 7-6. */
XX! #define B0           0000000	/* hang up the line */
XX! #define B50          0010000	/* 50 baud */
XX! #define B75          0020000	/* 75 baud */
XX! #define B110         0030000	/* 110 baud */
XX! #define B134         0040000	/* 134.5 baud */
XX! #define B150         0050000	/* 150 baud */
XX! #define B200         0060000	/* 200 baud */
XX! #define B300         0070000	/* 300 baud */
XX! #define B600         0100000	/* 600 baud */
XX! #define B1200        0110000	/* 1200 baud */
XX! #define B1800        0120000	/* 1800 baud */
XX! #define B2400        0130000	/* 2400 baud */
XX! #define B4800        0140000	/* 4800 baud */
XX! #define B9600        0150000	/* 9600 baud */
XX! #define B19200       0160000	/* 19200 baud */
XX! #define B38400       0170000	/* 38400 baud */
XX  
XX  /* Optional actions for tcsetattr().  POSIX Sec. 7.2.1.2. */
XX  #define TCSANOW            1	/* changes take effect immediately */
XX--- 69,114 ----
XX  #define IEXTEN        000040	/* enable extended functions */
XX  #define ISIG          000100	/* enable signals */
XX  #define NOFLSH        000200	/* disable flush after interrupt or quit */
XX! #define TOSTOP        000400	/* send SIGTTOU (job cntrl, not implemented) */
XX  
XX  /* Indices into c_cc array.  Default values in parentheses. POSIX Table 7-5. */
XX! #define VEOF               0	/* c_cc[VEOF] = EOF char (CTRL-D) */
XX! #define VEOL               1	/* c_cc[VEOL] = EOL char (NUL, not impl) */
XX! #define VERASE             2	/* c_cc[VERASE] = ERASE char (CTRL-H) */
XX! #define VINTR              3	/* c_cc[VINTR] = INTR char (DEL) */
XX! #define VKILL              4	/* c_cc[VKILL] = KILL char (@) */
XX! #define VMIN               5	/* c_cc[VMIN] = MIN value for timer */
XX! #define VQUIT              6	/* c_cc[VQUIT] = QUIT char (CTRL-\) */
XX! #define VTIME              7	/* c_cc[VTIME] = TIME value for timer */
XX! #define VSUSP              8	/* c_cc[VSUSP] = SUSP (job cntrl, not impl) */
XX! #define VSTART             9	/* c_cc[VSTART] = START char (CTRL-S) */
XX! #define VSTOP             10	/* c_cc[VSTOP] = STOP char (CTRL-Q) */
XX  
XX  /* Values for the baud rate settings.  POSIX Table 7-6. */
XX! /* Since we are reimplementing this, use a simple encoding.  Perhaps the
XX!  * constants should be cast to speed_t since that is not an int.
XX!  */
XX! #define B0                 0	/* hang up the line */
XX! #define B50               50
XX! #define B75               75
XX! #define B110             110
XX! #define B134             134
XX! #define B150             150
XX! #define B200             200
XX! #define B300             300
XX! #define B600             600
XX! #define B1200           1200
XX! #define B1800           1800
XX! #define B2400           2400
XX! #define B4800           4800
XX! #define B9600           9600
XX! #define B19200         19200
XX! #define B38400         38400
XX! #if defined(_MINIX) || !defined(_POSIX_SOURCE)
XX! #define B28800         28800	/* nonstandard */
XX! #define B57600         57600	/* nonstandard */
XX! #define B115200       115200	/* nonstandard */
XX! #endif
XX  
XX  /* Optional actions for tcsetattr().  POSIX Sec. 7.2.1.2. */
XX  #define TCSANOW            1	/* changes take effect immediately */
XX***************
XX*** 108,131 ****
XX  #define TCIOFF             3	/* transmit a STOP character on the line */
XX  #define TCION              4	/* transmit a START character on the line */
XX  
XX  
XX  /* Function Prototypes. */
XX  #ifndef _ANSI_H
XX  #include <ansi.h>
XX  #endif
XX  
XX! _PROTOTYPE( int tcsendbreak, (int _fildes, int _duration)		     );
XX! _PROTOTYPE( int tcdrain, (int _filedes)				     );
XX! _PROTOTYPE( int tcflush, (int _filedes, int _queue_selector)		     );
XX! _PROTOTYPE( int tcflow, (int _filedes, int _action)			     );
XX! _PROTOTYPE( speed_t cfgetospeed, (struct termios *_termios_p) 		     );
XX! _PROTOTYPE( speed_t cfsetospeed, \
XX! 		        (struct termios *_termios_p, speed_t _speed)       );
XX! _PROTOTYPE( speed_t cfgetispeed, (struct termios *_termios_p) 		     );
XX! _PROTOTYPE( speed_t cfsetispeed, \
XX! 			(struct termios *_termios_p, speed_t _speed)       );
XX! _PROTOTYPE( int tcgetattr, (int _filedes, struct termios *_termios_p)      );
XX! _PROTOTYPE( int tcsetattr, \
XX! 	(int _filedes, int _opt_actions, struct termios *_termios_p)      );
XX  
XX  #endif /* _TERMIOS_H */
XX--- 126,165 ----
XX  #define TCIOFF             3	/* transmit a STOP character on the line */
XX  #define TCION              4	/* transmit a START character on the line */
XX  
XX+ #if defined(_MINIX) || !defined(_POSIX_SOURCE)
XX+ /* Kludge */
XX+ #define _TC_COPY_CRMOD     0
XX+ #define _TC_ALWAYS_CRMOD   1
XX+ #define _TC_NEVER_CRMOD    2
XX+ extern int __tios_crmod;
XX+ #endif
XX  
XX  /* Function Prototypes. */
XX  #ifndef _ANSI_H
XX  #include <ansi.h>
XX  #endif
XX  
XX! #ifdef __cplusplus
XX! extern "C" {
XX! #endif
XX! _PROTOTYPE( int tcsendbreak, (int _fildes, int _duration)		);
XX! _PROTOTYPE( int tcdrain, (int _filedes)					);
XX! _PROTOTYPE( int tcflush, (int _filedes, int _queue_selector)		);
XX! _PROTOTYPE( int tcflow, (int _filedes, int _action)			);
XX! _PROTOTYPE( speed_t cfgetospeed, (const struct termios *_termios_p)	);
XX! _PROTOTYPE( int cfsetospeed, (struct termios *_termios_p, speed_t _speed) );
XX! _PROTOTYPE( speed_t cfgetispeed, (const struct termios *_termios_p)	);
XX! _PROTOTYPE( int cfsetispeed, (struct termios *_termios_p, speed_t _speed) );
XX! _PROTOTYPE( int tcgetattr, (int _filedes, struct termios *_termios_p)	);
XX! _PROTOTYPE( int tcsetattr, (int _filedes, int _optional_actions,
XX! 			    const struct termios *_termios_p)		);
XX! #ifdef __cplusplus
XX! }
XX! #endif
XX! 
XX! #define cfgetispeed(termios_p)		((termios_p)->_c_ispeed)
XX! #define cfgetospeed(termios_p)		((termios_p)->_c_ospeed)
XX! #define cfsetispeed(termios_p, speed)	((termios_p)->_c_ispeed = (speed), 0)
XX! #define cfsetospeed(termios_p, speed)	((termios_p)->_c_ospeed = (speed), 0)
XX  
XX  #endif /* _TERMIOS_H */
X/
Xecho x - time.h.d
Xsed '/^X/s///' > time.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/time.h  crc=42940   2116	Sat May  5 13:14:44 1990
XX--- /home/top/ast/minix/1.6.25/include/time.h  crc=59905   2210	Tue Nov 10 19:33:01 1992
XX***************
XX*** 12,18 ****
XX  #define CLOCKS_PER_SEC    60	/* MINIX always uses 60 Hz, even in Europe */
XX  
XX  #ifdef _POSIX_SOURCE
XX! #define CLK_TCK CLOCKS_PER_SEC	/* obsolete name for CLOCKS_PER_SEC */
XX  #endif
XX  
XX  #define NULL    ((void *)0)
XX--- 12,18 ----
XX  #define CLOCKS_PER_SEC    60	/* MINIX always uses 60 Hz, even in Europe */
XX  
XX  #ifdef _POSIX_SOURCE
XX! #define CLK_TCK CLOCKS_PER_SEC	/* obsolescent mame for CLOCKS_PER_SEC */
XX  #endif
XX  
XX  #define NULL    ((void *)0)
XX***************
XX*** 44,49 ****
XX--- 44,51 ----
XX    int tm_isdst;			/* Daylight Saving Time flag */
XX  };
XX  
XX+ extern char *tzname[];
XX+ 
XX  /* Function Prototypes. */
XX  #ifndef _ANSI_H
XX  #include <ansi.h>
XX***************
XX*** 62,67 ****
XX--- 64,73 ----
XX  
XX  #ifdef _POSIX_SOURCE
XX  _PROTOTYPE( void tzset, (void)						);
XX+ #endif
XX+ 
XX+ #ifdef _MINIX
XX+ _PROTOTYPE( int stime, (time_t *_top)					);
XX  #endif
XX  
XX  #endif /* _TIME_H */
X/
Xecho x - unistd.h.d
Xsed '/^X/s///' > unistd.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/unistd.h  crc=49222   5119	Sat Apr 21 22:26:22 1990
XX--- /home/top/ast/minix/1.6.25/include/unistd.h  crc=53209   6014	Fri Feb 12 19:32:19 1993
XX***************
XX*** 3,39 ****
XX  #ifndef _UNISTD_H
XX  #define _UNISTD_H
XX  
XX! /* Values used by access().  POSIX Table 2-6. */
XX  #define F_OK               0	/* test if file exists */
XX  #define X_OK               1	/* test if file is executable */
XX  #define W_OK               2	/* test if file is writable */
XX  #define R_OK               4	/* test if file is readable */
XX  
XX! /* Values used for whence in lseek(fd, offset, whence).  POSIX Table 2-7. */
XX  #define SEEK_SET           0	/* offset is absolute  */
XX  #define SEEK_CUR           1	/* offset is relative to current position */
XX  #define SEEK_END           2	/* offset is relative to end of file */
XX  
XX! /* This value is required by POSIX Table 2-8. */
XX! #define _POSIX_VERSION 198808L	/* which standard is being conformed to */
XX  
XX  /* These three definitions are required by POSIX Sec. 8.2.1.2. */
XX  #define STDIN_FILENO       0	/* file descriptor for stdin */
XX  #define STDOUT_FILENO      1	/* file descriptor for stdout */
XX  #define STDERR_FILENO      2	/* file descriptor for stderr */
XX  
XX! /* NULL must be defined in <unistd.h> according to POSIX Sec. 2.8.1. */
XX  #define NULL    ((void *)0)
XX  
XX  /* The following relate to configurable system variables. POSIX Table 4-2. */
XX  #define _SC_ARG_MAX		1
XX  #define _SC_CHILD_MAX		2
XX  #define _SC_CLOCKS_PER_SEC	3
XX  #define _SC_NGROUPS_MAX		4
XX  #define _SC_OPEN_MAX		5
XX  #define _SC_JOB_CONTROL		6
XX  #define _SC_SAVED_IDS		7
XX  #define _SC_VERSION		8
XX  
XX  /* The following relate to configurable pathname variables. POSIX Table 5-2. */
XX  #define _PC_LINK_MAX		1	/* link count */
XX--- 3,53 ----
XX  #ifndef _UNISTD_H
XX  #define _UNISTD_H
XX  
XX! /* POSIX requires size_t and ssize_t in <unistd.h> and elsewhere. */
XX! #ifndef _SIZE_T
XX! #define _SIZE_T
XX! typedef unsigned int size_t;
XX! #endif
XX! 
XX! #ifndef _SSIZE_T
XX! #define _SSIZE_T
XX! typedef int ssize_t;
XX! #endif
XX! 
XX! /* Values used by access().  POSIX Table 2-8. */
XX  #define F_OK               0	/* test if file exists */
XX  #define X_OK               1	/* test if file is executable */
XX  #define W_OK               2	/* test if file is writable */
XX  #define R_OK               4	/* test if file is readable */
XX  
XX! /* Values used for whence in lseek(fd, offset, whence).  POSIX Table 2-9. */
XX  #define SEEK_SET           0	/* offset is absolute  */
XX  #define SEEK_CUR           1	/* offset is relative to current position */
XX  #define SEEK_END           2	/* offset is relative to end of file */
XX  
XX! /* This value is required by POSIX Table 2-10. */
XX! #define _POSIX_VERSION 199009L	/* which standard is being conformed to */
XX  
XX  /* These three definitions are required by POSIX Sec. 8.2.1.2. */
XX  #define STDIN_FILENO       0	/* file descriptor for stdin */
XX  #define STDOUT_FILENO      1	/* file descriptor for stdout */
XX  #define STDERR_FILENO      2	/* file descriptor for stderr */
XX  
XX! /* NULL must be defined in <unistd.h> according to POSIX Sec. 2.7.1. */
XX  #define NULL    ((void *)0)
XX  
XX  /* The following relate to configurable system variables. POSIX Table 4-2. */
XX  #define _SC_ARG_MAX		1
XX  #define _SC_CHILD_MAX		2
XX  #define _SC_CLOCKS_PER_SEC	3
XX+ #define _SC_CLK_TCK             3
XX  #define _SC_NGROUPS_MAX		4
XX  #define _SC_OPEN_MAX		5
XX  #define _SC_JOB_CONTROL		6
XX  #define _SC_SAVED_IDS		7
XX  #define _SC_VERSION		8
XX+ #define _SC_STREAM_MAX		9
XX+ #define _SC_TZNAME_MAX         10
XX  
XX  /* The following relate to configurable pathname variables. POSIX Table 5-2. */
XX  #define _PC_LINK_MAX		1	/* link count */
XX***************
XX*** 51,87 ****
XX   *
XX   * _POSIX_JOB_CONTROL	    not defined:	no job control
XX   * _POSIX_SAVED_IDS 	    not defined:	no saved uid/gid
XX!  * _POSIX_NO_TRUNC	    not defined:	long path names are truncated
XX   * _POSIX_CHOWN_RESTRICTED  defined:		you can't give away files
XX   * _POSIX_VDISABLE	    defined:		tty functions can be disabled
XX   */
XX! #define _POSIX_CHOWN_RESTRICTED
XX! #define _POSIX_VDISABLE '\t'	/* can't set any control char to tab */
XX  
XX- 
XX  /* Function Prototypes. */
XX  #ifndef _ANSI_H
XX  #include <ansi.h>
XX  #endif
XX  
XX  _PROTOTYPE( void _exit, (int _status)					);
XX! _PROTOTYPE( int access, (char *_path, int _amode)			);
XX! _PROTOTYPE( int chdir, (char *_path)					);
XX! _PROTOTYPE( int chown, (char *_path, int _owner, int _group)		);
XX  _PROTOTYPE( int close, (int _fd)					);
XX  _PROTOTYPE( char *ctermid, (char *_s)					);
XX  _PROTOTYPE( char *cuserid, (char *_s)					);
XX  _PROTOTYPE( int dup, (int _fd)						);
XX  _PROTOTYPE( int dup2, (int _fd, int _fd2)				);
XX! _PROTOTYPE( int execl, (char *_path, ...)				);
XX! _PROTOTYPE( int execle, (char *_path, ...)				);
XX! _PROTOTYPE( int execlp, (char *_file, ...)				);
XX! _PROTOTYPE( int execv, (char *_path, char *_argv[])			);
XX! _PROTOTYPE( int execve, (char *_path, char *_argv[], char *_envp[])	);
XX! _PROTOTYPE( int execvp, (char *_file, char *_argv[])			);
XX  _PROTOTYPE( pid_t fork, (void)						);
XX  _PROTOTYPE( long fpathconf, (int _fd, int _name)			);
XX! _PROTOTYPE( char *getcwd, (char *_buf, int _size)			);
XX  _PROTOTYPE( gid_t getegid, (void)					);
XX  _PROTOTYPE( uid_t geteuid, (void)					);
XX  _PROTOTYPE( gid_t getgid, (void)					);
XX--- 65,103 ----
XX   *
XX   * _POSIX_JOB_CONTROL	    not defined:	no job control
XX   * _POSIX_SAVED_IDS 	    not defined:	no saved uid/gid
XX!  * _POSIX_NO_TRUNC	    defined as -1:	long path names are truncated
XX   * _POSIX_CHOWN_RESTRICTED  defined:		you can't give away files
XX   * _POSIX_VDISABLE	    defined:		tty functions can be disabled
XX   */
XX! #define _POSIX_NO_TRUNC       (-1)
XX! #define _POSIX_CHOWN_RESTRICTED  1
XX! #define _POSIX_VDISABLE       0xDF
XX  
XX  /* Function Prototypes. */
XX  #ifndef _ANSI_H
XX  #include <ansi.h>
XX  #endif
XX  
XX  _PROTOTYPE( void _exit, (int _status)					);
XX! _PROTOTYPE( int access, (const char *_path, Mode_t _amode)		);
XX! _PROTOTYPE( unsigned int alarm, (unsigned int _seconds)			);
XX! _PROTOTYPE( int chdir, (const char *_path)				);
XX! _PROTOTYPE( int chown, (const char *_path, Uid_t _owner, Gid_t _group)	);
XX  _PROTOTYPE( int close, (int _fd)					);
XX  _PROTOTYPE( char *ctermid, (char *_s)					);
XX  _PROTOTYPE( char *cuserid, (char *_s)					);
XX  _PROTOTYPE( int dup, (int _fd)						);
XX  _PROTOTYPE( int dup2, (int _fd, int _fd2)				);
XX! _PROTOTYPE( int execl, (const char *_path, const char *_arg, ...)	);
XX! _PROTOTYPE( int execle, (const char *_path, const char *_arg, ...)	);
XX! _PROTOTYPE( int execlp, (const char *_file, const char *arg, ...)	);
XX! _PROTOTYPE( int execv, (const char *_path, char *const _argv[])		);
XX! _PROTOTYPE( int execve, (const char *_path, char *const _argv[], 
XX! 						char *const _envp[])	);
XX! _PROTOTYPE( int execvp, (const char *_file, char *const _argv[])	);
XX  _PROTOTYPE( pid_t fork, (void)						);
XX  _PROTOTYPE( long fpathconf, (int _fd, int _name)			);
XX! _PROTOTYPE( char *getcwd, (char *_buf, size_t _size)			);
XX  _PROTOTYPE( gid_t getegid, (void)					);
XX  _PROTOTYPE( uid_t geteuid, (void)					);
XX  _PROTOTYPE( gid_t getgid, (void)					);
XX***************
XX*** 91,121 ****
XX  _PROTOTYPE( pid_t getpid, (void)					);
XX  _PROTOTYPE( pid_t getppid, (void)					);
XX  _PROTOTYPE( uid_t getuid, (void)					);
XX- _PROTOTYPE( unsigned int alarm, (unsigned int _seconds)			);
XX- _PROTOTYPE( unsigned int sleep, (unsigned int _seconds)			);
XX  _PROTOTYPE( int isatty, (int _fd)					);
XX! _PROTOTYPE( int link, (const char *_path1, const char *_path2)		);
XX  _PROTOTYPE( off_t lseek, (int _fd, off_t _offset, int _whence)		);
XX! _PROTOTYPE( long pathconf, (char *_path, int _name)			);
XX  _PROTOTYPE( int pause, (void)						);
XX  _PROTOTYPE( int pipe, (int _fildes[2])					);
XX! _PROTOTYPE( int read, (int _fd, char *_buf, unsigned int _n)		);
XX! _PROTOTYPE( int rmdir, (char *_path)					);
XX! _PROTOTYPE( int setgid, (int _gid)					);
XX  _PROTOTYPE( int setpgid, (pid_t _pid, pid_t _pgid)			);
XX  _PROTOTYPE( pid_t setsid, (void)					);
XX! _PROTOTYPE( int setuid, (int _uid)					);
XX  _PROTOTYPE( long sysconf, (int _name)					);
XX  _PROTOTYPE( pid_t tcgetpgrp, (int _fd)					);
XX  _PROTOTYPE( int tcsetpgrp, (int _fd, pid_t _pgrp_id)			);
XX  _PROTOTYPE( char *ttyname, (int _fd)					);
XX  _PROTOTYPE( int unlink, (const char *_path)				);
XX! _PROTOTYPE( int write, (int _fd, char *_buf, unsigned int _n)		);
XX  
XX  #ifdef _MINIX
XX! _PROTOTYPE( char *brk, (char *_addr)					);
XX  _PROTOTYPE( char *mktemp, (char *_template)				);
XX  _PROTOTYPE( char *sbrk, (int _incr)					);
XX  #endif
XX  
XX  #endif /* _UNISTD_H */
XX--- 107,144 ----
XX  _PROTOTYPE( pid_t getpid, (void)					);
XX  _PROTOTYPE( pid_t getppid, (void)					);
XX  _PROTOTYPE( uid_t getuid, (void)					);
XX  _PROTOTYPE( int isatty, (int _fd)					);
XX! _PROTOTYPE( int link, (const char *_existing, const char *_new)		);
XX  _PROTOTYPE( off_t lseek, (int _fd, off_t _offset, int _whence)		);
XX! _PROTOTYPE( long pathconf, (const char *_path, int _name)		);
XX  _PROTOTYPE( int pause, (void)						);
XX  _PROTOTYPE( int pipe, (int _fildes[2])					);
XX! _PROTOTYPE( ssize_t read, (int _fd, void *_buf, size_t _n)		);
XX! _PROTOTYPE( int rmdir, (const char *_path)				);
XX! _PROTOTYPE( int setgid, (Gid_t _gid)					);
XX  _PROTOTYPE( int setpgid, (pid_t _pid, pid_t _pgid)			);
XX  _PROTOTYPE( pid_t setsid, (void)					);
XX! _PROTOTYPE( int setuid, (Uid_t _uid)					);
XX! _PROTOTYPE( unsigned int sleep, (unsigned int _seconds)			);
XX  _PROTOTYPE( long sysconf, (int _name)					);
XX  _PROTOTYPE( pid_t tcgetpgrp, (int _fd)					);
XX  _PROTOTYPE( int tcsetpgrp, (int _fd, pid_t _pgrp_id)			);
XX  _PROTOTYPE( char *ttyname, (int _fd)					);
XX  _PROTOTYPE( int unlink, (const char *_path)				);
XX! _PROTOTYPE( ssize_t write, (int _fd, const void *_buf, size_t _n)	);
XX  
XX  #ifdef _MINIX
XX! _PROTOTYPE( int brk, (char *_addr)					);
XX! _PROTOTYPE( int chroot, (const char *_name)				);
XX! _PROTOTYPE( int mknod, (const char *_name, Mode_t _mode, Dev_t _addr)	);
XX! _PROTOTYPE( int mknod4, (const char *_name, Mode_t _mode, Dev_t _addr,
XX! 	    long _size)							);
XX  _PROTOTYPE( char *mktemp, (char *_template)				);
XX+ _PROTOTYPE( int mount, (char *_spec, char *_name, int _flag)		);
XX+ _PROTOTYPE( long ptrace, (int _req, pid_t _pid, long _addr, long _data)	);
XX  _PROTOTYPE( char *sbrk, (int _incr)					);
XX+ _PROTOTYPE( int sync, (void)						);
XX+ _PROTOTYPE( int umount, (const char *_name)				);
XX  #endif
XX  
XX  #endif /* _UNISTD_H */
X/
Xecho x - utime.h.d
Xsed '/^X/s///' > utime.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/utime.h  crc=08965    358	Sat Apr 21 22:26:22 1990
XX--- /home/top/ast/minix/1.6.25/include/utime.h  crc=43202    373	Tue Nov 10 19:33:01 1992
XX***************
XX*** 14,19 ****
XX  #include <ansi.h>
XX  #endif
XX  
XX! _PROTOTYPE( int utime, (char *_path, struct utimbuf *_times)		);
XX  
XX  #endif /* _UTIME_H */
XX--- 14,19 ----
XX  #include <ansi.h>
XX  #endif
XX  
XX! _PROTOTYPE( int utime, (const char *_path, const struct utimbuf *_times)     );
XX  
XX  #endif /* _UTIME_H */
X/
Xecho x - utmp.h.d
Xsed '/^X/s///' > utmp.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/utmp.h  crc=08619   1036	Sat Apr 21 22:26:22 1990
XX--- /home/top/ast/minix/1.6.25/include/utmp.h  crc=62469   1086	Tue Nov  3 21:21:53 1992
XX***************
XX*** 12,17 ****
XX--- 12,18 ----
XX    char ut_user[8];		/* user name */
XX    char ut_id[4];		/* /etc/inittab ID */
XX    char ut_line[12];		/* terminal name */
XX+   char ut_host[16];		/* host name, when remote */
XX    pid_t ut_pid;			/* process id */
XX    short int ut_type;		/* type of entry */
XX    long ut_time;			/* login/logout time */
X/
/
