echo x - dl_eth.h
sed '/^X/s///' > dl_eth.h << '/'
X/* The eth_stat struct is used in a DL_GETSTAT request the the ehw_task. */
X
X#ifndef _ETH_HW_H
X#define _ETH_HW_H
X
Xtypedef struct eth_stat
X{
X  unsigned long ets_recvErr,	/* # receive errors */
X	ets_sendErr,		/* # send error */
X	ets_OVW,		/* # buffer overwrite warnings */
X	ets_CRCerr,		/* # crc errors of read */
X	ets_frameAll,		/* # frames not alligned (# bits % 8 != 0) */
X	ets_missedP,		/* # packets missed due to slow processing */
X	ets_packetR,		/* # packets received */
X	ets_packetT,		/* # packets transmitted */
X	ets_transDef,		/* # transmission defered (Tx was busy) */
X	ets_collision,		/* # collissions */
X	ets_transAb,		/* # Tx aborted due to excess collisions */
X	ets_carrSense,		/* # carrier sense lost */
X	ets_fifoUnder,		/* # FIFO underruns (processor too busy) */
X	ets_fifoOver,		/* # FIFO overruns (processor too busy) */
X	ets_CDheartbeat,	/* # times unable to transmit collision sig*/
X	ets_OWC;		/* # times out of window collision */
X} eth_stat_t;
X
X#endif /* _ETH_HW_H */
/
echo x - fslib.h
sed '/^X/s///' > fslib.h << '/'
X_PROTOTYPE( int bitmapsize, (bit_t _nr_bits)				);
X_PROTOTYPE( unsigned conv2, (int _norm, int _w)				);
X_PROTOTYPE( long conv4, (int _norm, long _x)				);
X_PROTOTYPE( void conv_inode, (struct inode *_rip, d1_inode *_dip,
X			     d2_inode *_dip2, int _rw_flag, int _magic)	);
X_PROTOTYPE( void old_icopy, (struct inode *_rip, d1_inode *_dip,
X					      int _direction, int _norm));
X_PROTOTYPE( void new_icopy, (struct inode *_rip, d2_inode *_dip,
X					      int _direction, int _norm));
/
echo x - jmp_buf.h
sed '/^X/s///' > jmp_buf.h << '/'
X/* This file is intended for use by assembly language programs that
X * need to manipulate a jmp_buf.  It may only be used by those systems
X * for which a jmp_buf is identical to a struct sigcontext.
X */
X
X#ifndef _JMP_BUF_H
X#define _JMP_BUF_H
X
X#if !defined(CHIP) || !defined(INTEL)
X#include "error, configuration is not known"	/* XXX */
X#endif
X
X#if (CHIP == INTEL)
X#if INTEL_32BITS
X#define JB_FLAGS	 0
X#define JB_MASK		 4
X#define JB_GS		 8
X#define JB_FS		10
X#define JB_ES		12
X#define JB_DS		14
X#define JB_DI		16
X#define JB_SI		20
X#define JB_BP		24
X#define JB_ST		28
X#define JB_BX		32
X#define JB_DX		36
X#define JB_CX		40
X#define JB_AX		44
X#define JB_RETADR	48
X#define JB_IP		52
X#define JB_CS		56
X#define JB_PSW		60
X#define JB_SP		64
X#define JB_SS		68
X#else /* !INTEL_32BITS */
X#define JB_FLAGS	 0
X#define JB_MASK		 2
X#define JB_ES		 6
X#define JB_DS		 8 
X#define JB_DI		10
X#define JB_SI		12
X#define JB_BP		14
X#define JB_ST		16
X#define JB_BX		18
X#define JB_DX		20
X#define JB_CX		22
X#define JB_AX		24
X#define JB_RETADR	26
X#define JB_IP		28
X#define JB_CS		30
X#define JB_PSW		32
X#define JB_SP		34
X#define JB_SS		36
X#endif /* INTEL_32BITS */
X#else /* !(CHIP == INTEL) */
X#if (CHIP == M68000)
X#define JB_FLAGS	 0
X#define JB_MASK		 2
X#define JB_RETREG	 6
X#define JB_D1		10
X#define JB_D2		14
X#define JB_D3		18
X#define JB_D4		22
X#define JB_D5		26
X#define JB_D6		20
X#define JB_D7		34
X#define JB_A0		38
X#define JB_A1		42
X#define JB_A2		46
X#define JB_A3		50
X#define JB_A4		54
X#define JB_A5		58
X#define JB_A6		62
X#define JB_SP		66
X#define JB_PC		70
X#define JB_PSW		74
X#else /* !(CHIP == INTEL) && !(CHIP == M68000) */
X#include "error, CHIP is not supported"	/* XXX */
X#endif /* (CHIP == INTEL) */
X
X/* Defines from C headers needed in assembly code.  The headers have too
X * much C stuff to used directly.
X */
X#define SIG_BLOCK	0	/* must agree with <signal.h> */
X#define SC_SIGCONTEXT	2	/* must agree with <sys/sigcontext.h> */
X#define SC_NOREGLOCALS	4	/* must agree with <sys/sigcontext.h> */
X#endif /* _JMP_BUF_H */
/
echo x - minlib.h
sed '/^X/s///' > minlib.h << '/'
X#ifndef _MINLIB
X#define _MINLIB
X
X#ifndef _ANSI_H
X#include <ansi.h>
X#endif
X
X/* Miscellaneous BSD. */
X_PROTOTYPE(void swab, (char *_from, char *_to, int _count));
X_PROTOTYPE(char *crypt, (char *_pw, char *_salt));
X_PROTOTYPE(char *itoa, (int _n));
X_PROTOTYPE(char *getpass, (const char *_prompt));
X
X/* Miscellaneous MINIX. */
X_PROTOTYPE(void std_err, (char *_s));
X_PROTOTYPE(void prints, (const char *_s, ...));
X_PROTOTYPE(int fsversion, (char *_dev, char *_prog));
X_PROTOTYPE(int load_mtab, (char *_prog_name));
X_PROTOTYPE(int rewrite_mtab, (char *_prog_name));
X_PROTOTYPE(int get_mtab_entry, (char *_s1, char *_s2, char *_s3, char *_s4));
X_PROTOTYPE(int put_mtab_entry, (char *_s1, char *_s2, char *_s3, char *_s4));
X
X#endif
/
echo x - syslib.h
sed '/^X/s///' > syslib.h << '/'
X/* Prototypes for system library functions. */
X
X/* Minix user+system library. */
X#ifndef _SYSLIB_H
X#define _SYSLIB_H
X_PROTOTYPE( void printk, (char *_fmt, ...)				);
X_PROTOTYPE( int sendrec, (int _src_dest, message *_m_ptr)		);
X_PROTOTYPE( int _taskcall, (int _who, int _syscallnr, message *_msgptr)	);
X
X/* Minix system library. */
X_PROTOTYPE( int receive, (int _src, message *_m_ptr)			);
X_PROTOTYPE( int send, (int _dest, message *_m_ptr)			);
X
X_PROTOTYPE( void sys_abort, (void)					);
X_PROTOTYPE( void sys_copy, (message *_mptr)				);
X
X#endif /* _SYSLIB_H */
/
echo x - minix.cd
sed '/^X/s///' > minix.cd << '/'
Xecho x - boot.h.d
Xsed '/^X/s///' > boot.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/minix/boot.h  crc=03203   1158	Sat Apr 21 22:19:57 1990
XX--- /home/top/ast/minix/1.6.25/include/minix/boot.h  crc=20307   1256	Tue Nov  3 21:22:26 1992
XX***************
XX*** 1,5 ****
XX--- 1,8 ----
XX  /* boot.h */
XX  
XX+ #ifndef _BOOT_H
XX+ #define _BOOT_H
XX+ 
XX  /* Redefine root and root image devices as variables.
XX   * This keeps the diffs small but may cause future confusion.
XX   */
XX***************
XX*** 12,17 ****
XX--- 15,21 ----
XX  #define DEV_FD0   0x200
XX  #define DEV_HD0   0x300
XX  #define DEV_RAM   0x100
XX+ #define DEV_SCSI  0x700	/* Atari TT only */
XX  
XX  /* Default device numbers for root and root image.
XX   * Root image is only used when root is /dev/ram.
XX***************
XX*** 41,43 ****
XX--- 45,48 ----
XX  };
XX  
XX  extern struct bparam_s boot_parameters;
XX+ #endif /* _BOOT_H */
X/
Xecho x - callnr.h.d
Xsed '/^X/s///' > callnr.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/minix/callnr.h  crc=25018   1453	Sat Apr 21 22:19:57 1990
XX--- /home/top/ast/minix/1.6.25/include/minix/callnr.h  crc=61570   1675	Tue Nov  3 21:22:26 1992
XX***************
XX*** 1,4 ****
XX! #define NCALLS		  70	/* number of system calls allowed */
XX  
XX  #define EXIT		   1 
XX  #define FORK		   2 
XX--- 1,4 ----
XX! #define NCALLS		  76	/* number of system calls allowed */
XX  
XX  #define EXIT		   1 
XX  #define FORK		   2 
XX***************
XX*** 10,15 ****
XX--- 10,16 ----
XX  #define CREAT		   8 
XX  #define LINK		   9 
XX  #define UNLINK		  10 
XX+ #define WAITPID		  11
XX  #define CHDIR		  12 
XX  #define TIME		  13
XX  #define MKNOD		  14 
XX***************
XX*** 56,58 ****
XX--- 57,69 ----
XX  
XX  /* The following IS a system call for amoeba transactions */
XX  #define	AM_SYSCALL	  69
XX+ 
XX+ /* Memory allocation function for tasks */
XX+ #define BRK3		70
XX+ 
XX+ /* Posix signal handling. */
XX+ #define SIGACTION	71
XX+ #define SIGSUSPEND	72
XX+ #define SIGPENDING	73
XX+ #define SIGPROCMASK	74
XX+ #define SIGRETURN	75
X/
Xecho x - com.h.d
Xsed '/^X/s///' > com.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/minix/com.h  crc=63206   7886	Sat Apr 21 22:19:57 1990
XX--- /home/top/ast/minix/1.6.25/include/minix/com.h  crc=05934   8418	Tue Nov  3 21:22:27 1992
XX***************
XX*** 7,67 ****
XX  /* Task numbers, function codes and reply codes. */
XX  
XX  #define TTY         -NR_TASKS	/* terminal I/O class */
XX! #	define TTY_READ	    3	/* fcn code for reading from tty */
XX! #	define TTY_WRITE    4	/* fcn code for writing to tty */
XX! #	define TTY_IOCTL    5	/* fcn code for ioctl */
XX! #	define TTY_SETPGRP  6	/* fcn code for setpgrp */
XX! #	define TTY_OPEN     7	/* fcn code for opening tty */
XX! #	define TTY_CLOSE    8	/* fcn code for closing tty */
XX  #	define SUSPEND	 -998	/* used in interrupts when tty has no data */
XX  
XX! #ifdef AM_KERNEL
XX! #define	AMOEBA
XX! #endif
XX  
XX! #ifdef AMOEBA
XX  
XX! /* There are AM_NTASK copies of the amoeba kernel task.
XX!  * If you change AM_NTASKS be sure to adjust kernel/table.c and fs/table.c
XX!  */
XX! #define AM_NTASKS	   4	/* number of kernel tasks of this class */
XX  
XX! #define	AMINT_CLASS	    (TTY+1)	/* Amoeba event handler */
XX! #define AMOEBA_CLASS 	    (AMINT_CLASS+AM_NTASKS) /* transaction handlers */
XX! #	define ETHER_ARRIV   1	/* fcn code for packet arrival */
XX! #	define AM_TRANS      2	/* amoeba transaction */		
XX! #	define AM_GETREQ     3	/* amoeba getrequest */
XX! #	define AM_PUTREP     4	/* amoeba putrep */
XX! #	define AM_REVIVE     6	/* used by kernel task to revive luser task */
XX! #	define AM_TIMEOUT    8	/* used to talk to clock task */
XX! #	define AM_PUTSIG     9	/* when the luser hits the DEL ! */
XX! #	define AM_TASK_DIED 10  /* sent if task died during a transaction */
XX  
XX! #else	/* if AMOEBA not defined */
XX  
XX! #define	AMOEBA_CLASS	TTY
XX  
XX! #endif /* AMOEBA */
XX  
XX! /*
XX!  * New class definitions should go here and should be defined relative
XX!  * to AMOEBA_CLASS  (ie. as AMOEBA_CLASS+n, for the nth task added).
XX!  */
XX  
XX! #define IDLE (AMOEBA_CLASS+1)	/* task to run when there's nothing to run */
XX  
XX! #define PRINTER           -7		/* printer  I/O class */
XX! /* The printer uses the same commands as TTY. */
XX  
XX  #define WINCHESTER        -6	/* winchester (hard) disk class */
XX  #define FLOPPY            -5	/* floppy disk class */
XX- #	define DISK_READ   3	/* fcn code to DISK (must equal TTY_READ) */
XX- #	define DISK_WRITE  4	/* fcn code to DISK (must equal TTY_WRITE) */
XX- #	define DISK_IOCTL  5	/* fcn code for setting up RAM disk */
XX- #	define SCATTERED_IO 6	/* fcn code for multiple reads/writes */
XX- #	define OPTIONAL_IO 16	/* modifier to DISK_* codes within vector */
XX  
XX  #define MEM               -4	/* /dev/ram, /dev/(k)mem and /dev/null class */
XX  #	define RAM_DEV     0	/* minor device for /dev/ram */
XX  #	define MEM_DEV     1	/* minor device for /dev/mem */
XX  #	define KMEM_DEV    2	/* minor device for /dev/kmem */
XX--- 7,84 ----
XX  /* Task numbers, function codes and reply codes. */
XX  
XX  #define TTY         -NR_TASKS	/* terminal I/O class */
XX! #	define CANCEL       0	/* general req to force a task to cancel */
XX! #	define HARD_INT     2	/* fcn code for all hardware interrupts */
XX! #	define DEV_READ	    3	/* fcn code for reading from tty */
XX! #	define DEV_WRITE    4	/* fcn code for writing to tty */
XX! #	define DEV_IOCTL    5	/* fcn code for ioctl */
XX! #	define DEV_OPEN     6	/* fcn code for opening tty */
XX! #	define DEV_CLOSE    7	/* fcn code for closing tty */
XX! #	define SCATTERED_IO 8	/* fcn code for multiple reads/writes */
XX! #	define TTY_SETPGRP  9	/* fcn code for setpgroup */
XX! #	define TTY_EXIT	   10	/* a process group leader has exited */	
XX! #	define OPTIONAL_IO 16	/* modifier to DEV_* codes within vector */
XX! #	define NO_CTL_TTY  -1	/* returned by DEV_OPEN if no ctl tty exists */
XX  #	define SUSPEND	 -998	/* used in interrupts when tty has no data */
XX  
XX! #define SCSI		-NR_TASKS+1
XX  
XX! #if INET_KERNEL
XX! #define DL_ETH		-10
XX! #endif /* INET_TASK */
XX  
XX! /* Message type for data link layer reqests. */
XX! #	define DL_WRITE		3
XX! #	define DL_WRITEV	4
XX! #	define DL_READ		5
XX! #	define DL_READV		6
XX! #	define DL_INIT		7
XX! #	define DL_STOP		8
XX! #	define DL_GETSTAT	9
XX  
XX! /* Message type for data link layer replies. */
XX! #	define DL_INIT_REPLY	20
XX! #	define DL_TASK_REPLY	21
XX! #	define DL_INT_TASK	22
XX  
XX! #	define DL_PORT		m2_i1
XX! #	define DL_PROC		m2_i2
XX! #	define DL_COUNT		m2_i3
XX! #	define DL_MODE		m2_l1
XX! #	define DL_CLCK		m2_l2
XX! #	define DL_ADDR		m2_p1
XX! #	define DL_STAT		m2_l1
XX  
XX! /* Bits in `DL_STAT' field of DL replies. */
XX! #	define DL_PACK_SEND	0x01
XX! #	define DL_PACK_RECV	0x02
XX! #	define DL_DISABLED	0x10
XX  
XX! /* Bits in `DL_MODE' field of DL requests. */
XX! #	define DL_NOMODE	0x0
XX! #	define DL_WRITEINT_REQ	0x1
XX! #	define DL_PROMISC_REQ	0x2
XX! #	define DL_MULTI_REQ	0x4
XX! #	define DL_BROAD_REQ	0x8
XX  
XX! #	define NW_OPEN		DEV_OPEN
XX! #	define NW_CLOSE		DEV_CLOSE
XX! #	define NW_READ		DEV_READ
XX! #	define NW_WRITE		DEV_WRITE
XX! #	define NW_IOCTL		DEV_IOCTL
XX! #	define NW_CANCEL	CANCEL
XX  
XX! #define SYN_ALRM_TASK     -9	/* task to send CLOCK_INT messages */
XX  
XX! #define IDLE              -8	/* task to run when there's nothing to run */
XX  
XX+ /* The printer and disks use the same commands as TTY. */
XX+ #define PRINTER           -7	/* printer  I/O class */
XX  #define WINCHESTER        -6	/* winchester (hard) disk class */
XX  #define FLOPPY            -5	/* floppy disk class */
XX  
XX  #define MEM               -4	/* /dev/ram, /dev/(k)mem and /dev/null class */
XX+ #       define NULL_MAJOR  1	/* major device for /dev/null */
XX  #	define RAM_DEV     0	/* minor device for /dev/ram */
XX  #	define MEM_DEV     1	/* minor device for /dev/mem */
XX  #	define KMEM_DEV    2	/* minor device for /dev/kmem */
XX***************
XX*** 74,85 ****
XX  #	define SET_ALARM   1	/* fcn code to CLOCK, set up alarm */
XX  #	define GET_TIME	   3	/* fcn code to CLOCK, get real time */
XX  #	define SET_TIME	   4	/* fcn code to CLOCK, set real time */
XX  #	define REAL_TIME   1	/* reply from CLOCK: here is real time */
XX  
XX  #define SYSTASK           -2	/* internal functions */
XX  #	define SYS_XIT     1	/* fcn code for sys_xit(parent, proc) */
XX  #	define SYS_GETSP   2	/* fcn code for sys_sp(proc, &new_sp) */
XX! #	define SYS_SIG     3	/* fcn code for sys_sig(proc, sig) */
XX  #	define SYS_FORK    4	/* fcn code for sys_fork(parent, child) */
XX  #	define SYS_NEWMAP  5	/* fcn code for sys_newmap(procno, map_ptr) */
XX  #	define SYS_COPY    6	/* fcn code for sys_copy(ptr) */
XX--- 91,109 ----
XX  #	define SET_ALARM   1	/* fcn code to CLOCK, set up alarm */
XX  #	define GET_TIME	   3	/* fcn code to CLOCK, get real time */
XX  #	define SET_TIME	   4	/* fcn code to CLOCK, set real time */
XX+ #	define GET_UPTIME  5	/* fcn code to CLOCK, get uptime */
XX+ #	define SET_SYNC_AL 6	/* fcn code to CLOCK, set up alarm which */
XX+ 				/* times out with a send */
XX  #	define REAL_TIME   1	/* reply from CLOCK: here is real time */
XX+ #	define CLOCK_INT   HARD_INT
XX+ 				/* this code will only be sent by */
XX+ 				/* SYN_ALRM_TASK to a task that requested a */
XX+ 				/* synchronous alarm */
XX  
XX  #define SYSTASK           -2	/* internal functions */
XX  #	define SYS_XIT     1	/* fcn code for sys_xit(parent, proc) */
XX  #	define SYS_GETSP   2	/* fcn code for sys_sp(proc, &new_sp) */
XX! #	define SYS_OLDSIG  3	/* fcn code for sys_oldsig(proc, sig) */
XX  #	define SYS_FORK    4	/* fcn code for sys_fork(parent, child) */
XX  #	define SYS_NEWMAP  5	/* fcn code for sys_newmap(procno, map_ptr) */
XX  #	define SYS_COPY    6	/* fcn code for sys_copy(ptr) */
XX***************
XX*** 92,97 ****
XX--- 116,126 ----
XX  #	define SYS_UMAP   13	/* fcn code for sys_umap(procno, etc) */
XX  #	define SYS_MEM    14	/* fcn code for sys_mem() */
XX  #	define SYS_TRACE  15	/* fcn code for sys_trace(req,pid,addr,data) */
XX+ #	define SYS_VCOPY  16	/* fnc code for sys_vcopy(src_proc, dest_proc,
XX+ 				   vcopy_s, vcopy_ptr) */
XX+ #	define SYS_SENDSIG   17	/* fcn code for sys_sendsig(&sigmsg) */
XX+ #	define SYS_SIGRETURN 18	/* fcn code for sys_sigreturn(&sigmsg) */
XX+ #	define SYS_ENDSIG    19	/* fcn code for sys_endsig(procno) */
XX  
XX  #define HARDWARE          -1	/* used as source on interrupt generated msgs*/
XX  
XX***************
XX*** 110,121 ****
XX  #define ADDRESS        m2_p1	/* core buffer address */
XX  
XX  /* Names of message fields for messages to TTY task. */
XX! #define TTY_LINE       m2_i1	/* message parameter: terminal line */
XX! #define TTY_REQUEST    m2_i3	/* message parameter: ioctl request code */
XX! #define TTY_SPEK       m2_l1	/* message parameter: ioctl speed, erasing */
XX  #define TTY_FLAGS      m2_l2	/* message parameter: ioctl tty mode */
XX! #define TTY_PGRP       m2_i3    /* message parameter: process group */
XX  
XX  /* Names of messages fields used in reply messages from tasks. */
XX  #define REP_PROC_NR    m2_i1	/* # of proc on whose behalf I/O was done */
XX  #define REP_STATUS     m2_i2	/* bytes transferred or error number */
XX--- 139,154 ----
XX  #define ADDRESS        m2_p1	/* core buffer address */
XX  
XX  /* Names of message fields for messages to TTY task. */
XX! #define TTY_LINE       DEVICE	/* message parameter: terminal line */
XX! #define TTY_REQUEST    COUNT	/* message parameter: ioctl request code */
XX! #define TTY_SPEK       POSITION	/* message parameter: ioctl speed, erasing */
XX  #define TTY_FLAGS      m2_l2	/* message parameter: ioctl tty mode */
XX! #define TTY_PGRP       m2_i3	/* message parameter: process group */	
XX  
XX+ /* Names of the message fields for QIC 02 status reply from tape driver */
XX+ #define TAPE_STAT0	m2_l1
XX+ #define TAPE_STAT1	m2_l2
XX+ 
XX  /* Names of messages fields used in reply messages from tasks. */
XX  #define REP_PROC_NR    m2_i1	/* # of proc on whose behalf I/O was done */
XX  #define REP_STATUS     m2_i2	/* bytes transferred or error number */
XX***************
XX*** 134,139 ****
XX--- 167,173 ----
XX  #define SYSTEM_TIME    m4_l2	/* system time consumed by process */
XX  #define CHILD_UTIME    m4_l3	/* user time consumed by process' children */
XX  #define CHILD_STIME    m4_l4	/* sys time consumed by process' children */
XX+ #define BOOT_TICKS     m4_l5	/* number of clock ticks since boot time */
XX  
XX  #define PROC1          m1_i1	/* indicates a process */
XX  #define PROC2          m1_i2	/* indicates a process */
XX***************
XX*** 143,166 ****
XX  #define SIGNUM         m6_i2	/* signal number for sys_sig */
XX  #define FUNC           m6_f1	/* function pointer for sys_sig */
XX  #define MEM_PTR        m1_p1	/* tells where memory map is for sys_newmap */
XX! #define CANCEL             0    /* general request to force a task to cancel */
XX! #define SIG_MAP        m1_i2	/* used by kernel for passing signal bit map */
XX! 
XX! #ifdef AMOEBA
XX! 
XX! /* Names of message fields for amoeba tasks */
XX! #define	AM_OP		m2_i1	/* one of the above operators */
XX! #define	AM_PROC_NR	m2_i2	/* process # of proc doing operation */
XX! #define	AM_COUNT	m2_i3	/* size of buffer for operation */
XX! #define	AM_ADDRESS	m2_p1	/* address of buffer for operation */
XX! 
XX! /* For communication between MM and AMOEBA_CLASS kernel tasks */
XX! #define	AM_STATUS	m2_i3	/* same use as REP_STATUS but for amoeba */
XX! #define	AM_FREE_IT	m2_l1	/* 1=not a getreq, 0=is a getreq */
XX! 
XX! /* Special for passing a physical address from the ethernet driver */
XX! #define	AM_PADDR	m2_l1	/* to the transaction layer */
XX! 
XX! #endif /* AMOEBA */
XX! 
XX! #define HARD_INT           2	/* fcn code for all hardware interrupts */
XX--- 177,185 ----
XX  #define SIGNUM         m6_i2	/* signal number for sys_sig */
XX  #define FUNC           m6_f1	/* function pointer for sys_sig */
XX  #define MEM_PTR        m1_p1	/* tells where memory map is for sys_newmap */
XX! #define NAME_PTR       m1_p2	/* tells where program name is for dmp */
XX! #define IP_PTR	       m1_p3	/* initial value for ip after exec */
XX! #define SIG_PROC       m2_i1	/* process number for inform */
XX! #define SIG_MAP        m2_l1	/* used by kernel for passing signal bit map */
XX! #define SIG_MSG_PTR    m1_i1	/* pointer to info to build sig catch stack */
XX! #define SIG_CTXT_PTR   m1_p1	/* pointer to info to restore signal context */
X/
Xecho x - config.h.d
Xsed '/^X/s///' > config.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/minix/config.h  crc=19667   4317	Sat Apr 21 22:19:57 1990
XX--- /home/top/ast/minix/1.6.25/include/minix/config.h  crc=44651   7857	Sun Dec 20 15:37:04 1992
XX***************
XX*** 1,3 ****
XX--- 1,6 ----
XX+ #ifndef _CONFIG_H
XX+ #define _CONFIG_H
XX+ 
XX  /* This file sets configuration parameters for the MINIX kernel, FS, and MM.
XX   * It is divided up into two main sections.  The first section contains
XX   * user-settable parameters.  In the second section, various internal system
XX***************
XX*** 7,18 ****
XX  /*===========================================================================*
XX   *		This section contains user-settable parameters		     *
XX   *===========================================================================*/
XX- 
XX- /* MACHINE must be set to one of the machine types list below. */
XX  #define MACHINE       IBM_PC	/* Must be one of the names listed below */
XX  #define IBM_PC             1	/* any  8088 or 80x86-based system */
XX! #define SUN_4             40	/* any SUN SPARC-based system */
XX! #define ATARI             60	/* ATARI ST (68000) */
XX  #define AMIGA             61	/* Commodore Amiga (68000) */
XX  #define MACINTOSH         62	/* Apple Macintosh (68000) */
XX  
XX--- 10,22 ----
XX  /*===========================================================================*
XX   *		This section contains user-settable parameters		     *
XX   *===========================================================================*/
XX  #define MACHINE       IBM_PC	/* Must be one of the names listed below */
XX+ 
XX  #define IBM_PC             1	/* any  8088 or 80x86-based system */
XX! #define IBM_386_VM         2	/* any 386 (486) with virtual memory enabled */
XX! #define SUN_4             40	/* any Sun SPARC-based system */
XX! #define SUN_4_60	  40	/* Sun-4/60 (aka SparcStation 1 or Campus) */
XX! #define ATARI             60	/* ATARI ST/STe/TT (68000/68030) */
XX  #define AMIGA             61	/* Commodore Amiga (68000) */
XX  #define MACINTOSH         62	/* Apple Macintosh (68000) */
XX  
XX***************
XX*** 24,51 ****
XX   */
XX  #define ROBUST             0	/* 0 for speed, 1 for robustness */
XX  
XX! /* If HAVE_SCATTERED_IO is set to 1, scattered I/O is enabled. */
XX! /* DEBUG - 1.4b will always use this. */
XX! #define HAVE_SCATTERED_IO  1
XX  
XX- 
XX  /* The buffer cache should be made as large as you can afford. */
XX  #if INTEL_32BITS
XX  #define NR_BUFS          320	/* # blocks in the buffer cache */
XX  #define NR_BUF_HASH      512	/* size of buf hash table; MUST BE POWER OF 2*/
XX- #else
XX- #define NR_BUFS           30	/* # blocks in the buffer cache */
XX- #define NR_BUF_HASH       32	/* size of buf hash table; MUST BE POWER OF 2*/
XX  #endif
XX  
XX  
XX  /* Defines for kernel configuration. */
XX  #define AUTO_BIOS          0	/* xt_wini.c - use Western's autoconfig BIOS */
XX  #define C_RS232_INT_HANDLERS 0	/* rs232.c - use slower C int handlers */
XX  #define DEFAULT_CLASS      0	/* floppy.c - 3 or 5 to get only that size */
XX  #define LINEWRAP           0	/* console.c - wrap lines at column 80 */
XX  #define NO_HANDSHAKE       1	/* rs232.c - don't use CTS/RTS handshaking */
XX  
XX  /* These configuration defines control debugging and unfinished code. */
XX  #define FLOPPY_TIMING      0	/* floppy.c - for fine tuning floppy driver */
XX  #define MONITOR		   0	/* xt_wini.c - monitor loop in w_wait_int */
XX--- 28,77 ----
XX   */
XX  #define ROBUST             0	/* 0 for speed, 1 for robustness */
XX  
XX! /* if SCREEN is set to 1 graphical screen operations are possible */
XX! #define SCREEN             1	
XX  
XX  /* The buffer cache should be made as large as you can afford. */
XX  #if INTEL_32BITS
XX  #define NR_BUFS          320	/* # blocks in the buffer cache */
XX  #define NR_BUF_HASH      512	/* size of buf hash table; MUST BE POWER OF 2*/
XX  #endif
XX  
XX+ #if (MACHINE == SUN_4_60)
XX+ #define NR_BUFS		 512	/* # blocks in the buffer cache (<=1536) */
XX+ #define NR_BUF_HASH	 512	/* size of buf hash table; MUST BE POWER OF 2*/
XX+ #endif
XX  
XX+ #if (MACHINE == ATARI)
XX+ #define NR_BUFS		1536	/* # blocks in the buffer cache (<=1536) */
XX+ #define NR_BUF_HASH	2048	/* size of buf hash table; MUST BE POWER OF 2*/
XX+ #endif
XX+ 
XX+ #ifndef NR_BUFS
XX+ #define NR_BUFS           40	/* # blocks in the buffer cache */
XX+ #define NR_BUF_HASH       64	/* size of buf hash table; MUST BE POWER OF 2*/
XX+ #endif
XX+ 
XX+ /* The number of map slots determines how big a disk partition can be.
XX+  * Each I_MAP_SLOT allows 8K files; each Z_MAP_SLOT allows 8M of data.
XX+  */
XX+ #define I_MAP_SLOTS        8	/* max # of blocks in the inode bit map */
XX+ #define Z_MAP_SLOTS       16	/* max # of blocks in the zone bit map */
XX+ 
XX  /* Defines for kernel configuration. */
XX  #define AUTO_BIOS          0	/* xt_wini.c - use Western's autoconfig BIOS */
XX  #define C_RS232_INT_HANDLERS 0	/* rs232.c - use slower C int handlers */
XX  #define DEFAULT_CLASS      0	/* floppy.c - 3 or 5 to get only that size */
XX  #define LINEWRAP           0	/* console.c - wrap lines at column 80 */
XX  #define NO_HANDSHAKE       1	/* rs232.c - don't use CTS/RTS handshaking */
XX+ #define KEYBOARD_84        1	/* set to 1 to swap CTRL & CAPSLOCK keys */
XX+ #define ENABLE_NETWORKING  0	/* enable TCP/IP code */
XX+ #define ALLOW_GAP_MESSAGES 1	/* proc.c - allow messages in the gap between
XX+ 				 * the end of bss and lowest stack address */
XX  
XX+ /* Determine which device to use for pipes. */
XX+ #define PIPE_DEV    ROOT_DEV	/* put pipes on root device */
XX+ 
XX  /* These configuration defines control debugging and unfinished code. */
XX  #define FLOPPY_TIMING      0	/* floppy.c - for fine tuning floppy driver */
XX  #define MONITOR		   0	/* xt_wini.c - monitor loop in w_wait_int */
XX***************
XX*** 55,61 ****
XX--- 81,136 ----
XX  #define SPARE_VIDEO_MEMORY 0	/* misc.c - use memory from any 2nd vid card */
XX  #define SPLIMITS           0	/* mpx*.x - set stack limits (never checked) */
XX  
XX+ /* NR_CONS and NR_RS_LINES determine number of consoles and RS232 lines. */
XX+ #define NR_CONS            1	/* how many consoles can system handle */
XX+ #define	NR_RS_LINES	   2	/* how many rs232 terminals can system handle*/
XX  
XX+ #if (MACHINE == ATARI)
XX+ /* The next define says if you have an ATARI ST or TT */
XX+ #define ATARI_TYPE	  TT
XX+ #define ST		   1	/* all ST's and Mega ST's */
XX+ #define STE		   2	/* all STe and Mega STe's */
XX+ #define TT		   3
XX+ 
XX+ /* This define says whether the keyboard generates VT100 or IBM_PC escapes. */
XX+ #define KEYBOARD       VT100	/* either VT100 or IBM_PC */
XX+ #define VT100		 100
XX+ 
XX+ /* The next define determines the kind of partitioning. */
XX+ #define PARTITIONING   SUPRA	/* one of the following or ATARI */
XX+ #define SUPRA		   1	/*ICD, SUPRA and BMS are all the same */
XX+ #define BMS		   1
XX+ #define ICD		   1
XX+ #define CBHD		   2
XX+ #define EICKMANN	   3
XX+ 
XX+ /* Define the number of hard disk drives on your system. */
XX+ #define NR_ACSI_DRIVES	   3	/* typically 0 or 1 */
XX+ #define NR_SCSI_DRIVES	   1	/* typically 0 (ST, STe) or 1 (TT) */
XX+ 
XX+ /* Some systems need to have a little delay after each winchester
XX+  * commands. These systems need FAST_DISK set to 0. Other disks do not
XX+  * need this delay, and thus can have FAST_DISK set to 1 to avoid this delay.
XX+  */
XX+ #define FAST_DISK	   1	/* 0 or 1 */
XX+ 
XX+ /* Note: if you want to make your kernel smaller, you can set NR_FD_DRIVES
XX+  * to 0. You will still be able to boot minix.img from floppy. However, you
XX+  * MUST fetch both the root and usr filesystem from a hard disk
XX+  */
XX+ 
XX+ /* Define the number of floppy disk drives on your system. */
XX+ #define NR_FD_DRIVES	   1	/* 0, 1, 2 */
XX+ 
XX+ /* This configuration define controls parallel printer code. */
XX+ #define PAR_PRINTER	   1	/* disable (0) / enable (1) parallel printer */
XX+ 
XX+ /* This configuration define controls disk controller clock code. */
XX+ #define HD_CLOCK	   1	/* disable (0) / enable (1) hard disk clock */
XX+ 
XX+ #endif
XX+ 
XX+ 
XX  /*===========================================================================*
XX   *	There are no user-settable parameters after this line		     *
XX   *===========================================================================*/
XX***************
XX*** 67,104 ****
XX  #define M68000            2	/* CHIP type for Atari, Amiga, Macintosh    */
XX  #define SPARC             3	/* CHIP type for SUN-4 (e.g. SPARCstation)  */
XX  
XX! #if MACHINE == IBM_PC
XX! #define CHIP           INTEL
XX  #endif
XX  
XX! #if (MACHINE == ATARI) | (MACHINE == AMIGA) | (MACHINE == MACINTOSH)
XX! #define CHIP          M68000
XX  #endif
XX  
XX! #if (MACHINE == SUN_4)
XX! #define CHIP           SPARC
XX  #endif
XX  
XX! #if MACHINE == ATARI
XX! #define ASKDEV             1	/* ask for boot device */
XX! #define FASTLOAD           1	/* use multiple block transfers to init ram */
XX  #endif
XX  
XX  /* The file buf.h uses MAYBE_WRITE_IMMED. */
XX  #if ROBUST
XX  #define MAYBE_WRITE_IMMED  WRITE_IMMED	/* slower but perhaps safer */
XX  #else
XX! #define MAYBE_WRITE_IMMED  0		/* faster */
XX  #endif
XX  
XX  #ifndef MACHINE
XX! #error "In <minix/config.h> please define MACHINE"
XX  #endif
XX  
XX  #ifndef CHIP
XX! #error "In <minix/config.h> please define MACHINE to have a legal value"
XX  #endif
XX  
XX  #if (MACHINE == 0)
XX! #error "MACHINE has incorrect value (0)"
XX  #endif
XX--- 142,199 ----
XX  #define M68000            2	/* CHIP type for Atari, Amiga, Macintosh    */
XX  #define SPARC             3	/* CHIP type for SUN-4 (e.g. SPARCstation)  */
XX  
XX! /* Set the FP_FORMAT type based on the machine selected, either hw or sw    */
XX! #define FP_NONE		  0	/* no floating point support                */
XX! #define FP_IEEE		  1	/* conform IEEE floating point standard     */
XX! 
XX! #if (MACHINE == IBM_PC)
XX! #define CHIP          INTEL
XX! #define SHADOWING	  0
XX  #endif
XX  
XX! #if (MACHINE == ATARI) || (MACHINE == AMIGA) || (MACHINE == MACINTOSH)
XX! #define CHIP         M68000
XX! #define SHADOWING	  1
XX  #endif
XX  
XX! #if (MACHINE == SUN_4) || (MACHINE == SUN_4_60)
XX! #define CHIP          SPARC
XX! #define FP_FORMAT   FP_IEEE
XX! #define SHADOWING	  0
XX  #endif
XX  
XX! #if (MACHINE == ATARI) || (MACHINE == SUN_4)
XX! #define ASKDEV            1	/* ask for boot device */
XX! #define FASTLOAD          1	/* use multiple block transfers to init ram */
XX  #endif
XX  
XX+ #if (ATARI_TYPE == TT) /* and all other 68030's */
XX+ #define FPP
XX+ #undef SHADOWING
XX+ #define SHADOWING 0
XX+ #endif
XX+ 
XX+ #ifndef FP_FORMAT
XX+ #define FP_FORMAT   FP_NONE
XX+ #endif
XX+ 
XX  /* The file buf.h uses MAYBE_WRITE_IMMED. */
XX  #if ROBUST
XX  #define MAYBE_WRITE_IMMED  WRITE_IMMED	/* slower but perhaps safer */
XX  #else
XX! #define MAYBE_WRITE_IMMED 0		/* faster */
XX  #endif
XX  
XX  #ifndef MACHINE
XX! error "In <minix/config.h> please define MACHINE"
XX  #endif
XX  
XX  #ifndef CHIP
XX! error "In <minix/config.h> please define MACHINE to have a legal value"
XX  #endif
XX  
XX  #if (MACHINE == 0)
XX! error "MACHINE has incorrect value (0)"
XX  #endif
XX+ 
XX+ #endif /* _CONFIG_H */
X/
Xecho x - const.h.d
Xsed '/^X/s///' > const.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/minix/const.h  crc=55802   3932	Sat Apr 21 22:19:57 1990
XX--- /home/top/ast/minix/1.6.25/include/minix/const.h  crc=16068   5644	Tue Nov  3 21:22:27 1992
XX***************
XX*** 1,4 ****
XX! /* Copyright (C) 1990 by Prentice-Hall, Inc.  Permission is hereby granted
XX   * to redistribute the binary and source programs of this system for
XX   * educational or research purposes.  For other use, written permission from
XX   * Prentice-Hall is required.  
XX--- 1,4 ----
XX! /* Copyright (C) 1992 by Prentice-Hall, Inc.  Permission is hereby granted
XX   * to redistribute the binary and source programs of this system for
XX   * educational or research purposes.  For other use, written permission from
XX   * Prentice-Hall is required.  
XX***************
XX*** 19,28 ****
XX  #define MAJOR	           8	/* major device = (dev>>MAJOR) & 0377 */
XX  #define MINOR	           0	/* minor device = (dev>>MINOR) & 0377 */
XX  
XX! #ifdef AM_KERNEL
XX! #define NR_TASKS	  14	/* must be 5 more than without amoeba */
XX! #else
XX! #define NR_TASKS           9	/* number of tasks in the transfer vector */
XX  #endif
XX  
XX  #define NR_PROCS          32	/* number of slots in proc table */
XX--- 19,36 ----
XX  #define MAJOR	           8	/* major device = (dev>>MAJOR) & 0377 */
XX  #define MINOR	           0	/* minor device = (dev>>MINOR) & 0377 */
XX  
XX! #define NULL     ((void *)0)	/* null pointer */
XX! #define CPVEC_NR          16	/* max # of entries in a SYS_VCOPY request */
XX! #if (MACHINE == SUN_4)
XX! #define LOAD_ADDR     0x4000	/* addr at which the file is loaded (SPARC) */
XX! 				/* DEBUG.  What file?  Is this the same as
XX! 				 * KERNEL_LOAD_ADDRESS for the 8088/386?
XX! 				 * It is 0x600 for the 8088 and for old 386
XX! 				 * versions, 0x700 for the current 386 version,
XX! 				 * and may have to be page-aligned for later
XX! 				 * 386 versions.  It surely belongs in the
XX! 				 * machine-dependent section.
XX! 				 */
XX  #endif
XX  
XX  #define NR_PROCS          32	/* number of slots in proc table */
XX***************
XX*** 31,44 ****
XX  #define D                  1	/* proc[i].mem_map[D] is for data */
XX  #define S                  2	/* proc[i].mem_map[S] is for stack */
XX  
XX! #define MAX_P_LONG  2147483647	/* maximum positive long, i.e. 2**31 - 1 */
XX  
XX  /* Memory is allocated in clicks. */
XX! #if (CHIP == INTEL) || (CHIP == M68000)
XX  #define CLICK_SIZE       256	/* unit in which memory is allocated */
XX  #define CLICK_SHIFT        8	/* log2 of CLICK_SIZE */
XX  #endif
XX  
XX  #define click_to_round_k(n) \
XX  	((unsigned) ((((unsigned long) (n) << CLICK_SHIFT) + 512) / 1024))
XX  #if CLICK_SIZE < 1024
XX--- 39,89 ----
XX  #define D                  1	/* proc[i].mem_map[D] is for data */
XX  #define S                  2	/* proc[i].mem_map[S] is for stack */
XX  
XX! /* Process numbers of some important processes. */
XX! #define MM_PROC_NR         0	/* process number of memory manager */
XX! #define FS_PROC_NR         1	/* process number of file system */
XX  
XX+ /* Miscellaneous */
XX+ #define BYTE            0377	/* mask for 8 bits */
XX+ #define TO_USER            0	/* flag telling to copy from fs to user */
XX+ #define FROM_USER          1	/* flag telling to copy from user to fs */
XX+ #define READING            0	/* copy data to user */
XX+ #define WRITING            1	/* copy data from user */
XX+ #define NO_NUM        0x8000	/* used as numerical argument to panic() */
XX+ #define NIL_PTR   (char *) 0	/* generally useful expression */
XX+ #define HAVE_SCATTERED_IO  1	/* scattered I/O is now standard */
XX+ 
XX+ /* How many bytes are pushed by a signal. */
XX+ #define SIG_PUSH_BYTES (sizeof(int)+sizeof(u16_t)+sizeof(u32_t)) 
XX+ 
XX+ /* Macros. */
XX+ #define MAX(a, b)   ((a) > (b) ? (a) : (b))
XX+ #define MIN(a, b)   ((a) < (b) ? (a) : (b))
XX+ 
XX+ /* Machine dependent stuff. */
XX+ #if INET_KERNEL
XX+ #define INET_TASKS         1	/* Ethernet task */
XX+ #else
XX+ #define INET_TASKS         0
XX+ #endif
XX+ 
XX+ #if (MACHINE == ATARI)
XX+ #define NR_TASKS (11 + INET_TASKS)	/* number of tasks */
XX+ #else
XX+ #define NR_TASKS (10 + INET_TASKS)	/* number of tasks */
XX+ #endif
XX+ 
XX  /* Memory is allocated in clicks. */
XX! #if (CHIP == INTEL)
XX  #define CLICK_SIZE       256	/* unit in which memory is allocated */
XX  #define CLICK_SHIFT        8	/* log2 of CLICK_SIZE */
XX  #endif
XX  
XX+ #if (CHIP == SPARC) || (CHIP == M68000)
XX+ #define CLICK_SIZE	4096	/* unit in which memory is alocated */
XX+ #define CLICK_SHIFT	  12	/* 2log of CLICK_SIZE */
XX+ #endif
XX+ 
XX  #define click_to_round_k(n) \
XX  	((unsigned) ((((unsigned long) (n) << CLICK_SHIFT) + 512) / 1024))
XX  #if CLICK_SIZE < 1024
XX***************
XX*** 47,76 ****
XX  #define k_to_click(n) ((n) / (CLICK_SIZE / 1024))
XX  #endif
XX  
XX! /* Process numbers of some important processes */
XX! #define MM_PROC_NR         0	/* process number of memory manager */
XX! #define FS_PROC_NR         1	/* process number of file system */
XX  #define INIT_PROC_NR       2	/* init -- the process that goes multiuser */
XX  #define LOW_USER           2	/* first user not part of operating system */
XX  
XX- /* Miscellaneous */
XX- #define BYTE            0377	/* mask for 8 bits */
XX- #define TO_USER            0	/* flag telling to copy from fs to user */
XX- #define FROM_USER          1	/* flag telling to copy from user to fs */
XX- #define READING            0	/* copy data to user */
XX- #define WRITING            1	/* copy data from user */
XX- 
XX- #if (MACHINE != ATARI)
XX  #define ABS             -999	/* this process means absolute memory */
XX- #endif
XX  
XX- #define WORD_SIZE          2	/* number of bytes per word */
XX- 
XX- #define NIL_PTR   (char *) 0	/* generally useful expression */
XX- 
XX- #define NO_NUM        0x8000	/* used as numerical argument to panic() */
XX- #define SIG_PUSH_BYTES (4*sizeof(int))	/* how many bytes pushed by signal */
XX- 
XX  /* Flag bits for i_mode in the inode. */
XX  #define I_TYPE          0170000	/* this field gives inode type */
XX  #define I_REGULAR       0100000	/* regular file, not dir or special */
XX--- 92,108 ----
XX  #define k_to_click(n) ((n) / (CLICK_SIZE / 1024))
XX  #endif
XX  
XX! #if INET_KERNEL
XX! #define INET_PROC_NR       2	/* process number of network task */
XX! #define INIT_PROC_NR       3	/* init -- the process that goes multiuser */
XX! #define LOW_USER           3	/* first user not part of operating system */
XX! #else
XX  #define INIT_PROC_NR       2	/* init -- the process that goes multiuser */
XX  #define LOW_USER           2	/* first user not part of operating system */
XX+ #endif
XX  
XX  #define ABS             -999	/* this process means absolute memory */
XX  
XX  /* Flag bits for i_mode in the inode. */
XX  #define I_TYPE          0170000	/* this field gives inode type */
XX  #define I_REGULAR       0100000	/* regular file, not dir or special */
XX***************
XX*** 86,88 ****
XX--- 118,131 ----
XX  #define W_BIT           0000002	/* rWx protection bit */
XX  #define X_BIT           0000001	/* rwX protection bit */
XX  #define I_NOT_ALLOC     0000000	/* this inode is free */
XX+ 
XX+ /* Some limits. */
XX+ #define MAX_BLOCK_NR  ((block_t) 077777777)	/* largest block number */
XX+ #define HIGHEST_ZONE   ((zone_t) 077777777)	/* largest zone number */
XX+ #define MAX_INODE_NR      ((ino_t) 0177777)	/* largest inode number */
XX+ #define MAX_FILE_POS ((off_t) 037777777777)	/* largest legal file offset */
XX+ 
XX+ #define NO_BLOCK              ((block_t) 0)	/* absence of a block number */
XX+ #define NO_ENTRY                ((ino_t) 0)	/* absence of a dir entry */
XX+ #define NO_ZONE                ((zone_t) 0)	/* absence of a zone number */
XX+ #define NO_DEV                  ((dev_t) 0)	/* absence of a device numb */
X/
Xecho x - diskparm.h.d
Xsed '/^X/s///' > diskparm.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/minix/diskparm.h  crc=16388    393	Sat Apr 21 22:19:57 1990
XX--- /home/top/ast/minix/1.6.25/include/minix/diskparm.h  crc=28321    458	Tue Nov  3 21:22:27 1992
XX***************
XX*** 2,7 ****
XX--- 2,9 ----
XX   * used mainly for formatting.
XX   */
XX  
XX+ #ifndef _DISKPARM_H
XX+ #define _DISKPARM_H
XX  struct disk_parameter_s {
XX    char spec1;
XX    char spec2;
XX***************
XX*** 15,17 ****
XX--- 17,20 ----
XX    char head_settle_msec;
XX    char motor_start_eigth_sec;
XX  };
XX+ #endif /* _DISKPARM_H */
X/
Xecho x - partition.h.d
Xsed '/^X/s///' > partition.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/minix/partition.h  crc=64597   1059	Sat Apr 21 22:19:57 1990
XX--- /home/top/ast/minix/1.6.25/include/minix/partition.h  crc=49125   1127	Tue Nov  3 21:22:28 1992
XX***************
XX*** 1,4 ****
XX--- 1,6 ----
XX  /* Description of entry in partition table.  */
XX+ #ifndef _PARTITION_H
XX+ #define _PARTITION_H
XX  struct part_entry {
XX    unsigned char bootind;	/* boot indicator 0/ACTIVE_FLAG	 */
XX    unsigned char start_head;	/* head value for first sector	 */
XX***************
XX*** 20,22 ****
XX--- 22,25 ----
XX  #define MINIX_PART	0x81
XX  #define NO_PART		0x00
XX  #define OLD_MINIX_PART	0x80	/* created before 1.4b, driver must round */
XX+ #endif /* _PARTITION_H */
X/
Xecho x - type.h.d
Xsed '/^X/s///' > type.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/minix/type.h  crc=38283   3826	Sat Apr 21 22:19:57 1990
XX--- /home/top/ast/minix/1.6.25/include/minix/type.h  crc=25035   3896	Tue Nov  3 21:22:28 1992
XX***************
XX*** 1,40 ****
XX! /* Macros */
XX! #define MAX(a,b)	(a > b ? a : b)
XX! #define MIN(a,b)	(a < b ? a : b)
XX  
XX! /* Type definitions */
XX! typedef unsigned short unshort;	/* must be 16-bit unsigned */
XX! typedef unshort block_nr;	/* block number */
XX! #define NO_BLOCK (block_nr) 0	/* indicates the absence of a block number */
XX! #define MAX_BLOCK_NR (block_nr) 0177777
XX  
XX- #define NO_ENTRY (ino_t) 0	/* indicates the absence of a dir entry */
XX- #define MAX_INODE_NR (ino_t) 0177777
XX- 
XX- typedef unshort zone_nr;	/* zone number */
XX- #define NO_ZONE   (zone_nr) 0	/* indicates the absence of a zone number */
XX- #define HIGHEST_ZONE (zone_nr)  0177777
XX- 
XX- typedef unshort bit_nr;		/* if ino_t & zone_nr both unshort,
XX- 				   then also unshort, else long */
XX- 
XX- typedef long zone_type;		/* zone size */
XX- #define NO_DEV    (dev_t) ~0	/* indicates absence of a device number */
XX- 
XX- #define MAX_FILE_POS 017777777777L
XX- 
XX  #if (CHIP == INTEL)
XX! typedef unsigned vir_bytes;	/* virtual addresses and lengths in bytes */
XX  #endif
XX  
XX  #if (CHIP == M68000)
XX! typedef long vir_bytes;		/* virtual addresses and lengths in bytes */
XX  #endif
XX  
XX! typedef unsigned vir_clicks;	/* virtual addresses and lengths in clicks */
XX! typedef long phys_bytes;	/* physical addresses and lengths in bytes */
XX! typedef unsigned phys_clicks;	/* physical addresses and lengths in clicks */
XX! typedef int signed_clicks;	/* same length as phys_clicks, but signed */
XX  
XX  /* Types relating to messages. */
XX  #define M1                 1
XX--- 1,24 ----
XX! #ifndef _TYPE_H
XX! #define _TYPE_H
XX! #ifndef _MINIX_TYPE_H
XX! #define _MINIX_TYPE_H
XX  
XX! /* Type definitions. */
XX! typedef unsigned int vir_clicks; /* virtual  addresses and lengths in clicks */
XX! typedef unsigned long phys_bytes;/* physical addresses and lengths in bytes */
XX! typedef unsigned int phys_clicks;/* physical addresses and lengths in clicks */
XX  
XX  #if (CHIP == INTEL)
XX! typedef unsigned int vir_bytes;	/* virtual addresses and lengths in bytes */
XX  #endif
XX  
XX  #if (CHIP == M68000)
XX! typedef unsigned long vir_bytes;/* virtual addresses and lengths in bytes */
XX  #endif
XX  
XX! #if (CHIP == SPARC)
XX! typedef unsigned long vir_bytes;/* virtual addresses and lengths in bytes */
XX! #endif
XX  
XX  /* Types relating to messages. */
XX  #define M1                 1
XX***************
XX*** 45,53 ****
XX  typedef struct {int m1i1, m1i2, m1i3; char *m1p1, *m1p2, *m1p3;} mess_1;
XX  typedef struct {int m2i1, m2i2, m2i3; long m2l1, m2l2; char *m2p1;} mess_2;
XX  typedef struct {int m3i1, m3i2; char *m3p1; char m3ca1[M3_STRING];} mess_3;
XX! typedef struct {long m4l1, m4l2, m4l3, m4l4;} mess_4;
XX! typedef struct {char m5c1, m5c2; int m5i1, m5i2; long m5l1, m5l2, m5l3;} mess_5;
XX! typedef struct {int m6i1, m6i2, m6i3; long m6l1; void (*m6f1)();} mess_6;
XX  
XX  typedef struct {
XX    int m_source;			/* who sent the message */
XX--- 29,37 ----
XX  typedef struct {int m1i1, m1i2, m1i3; char *m1p1, *m1p2, *m1p3;} mess_1;
XX  typedef struct {int m2i1, m2i2, m2i3; long m2l1, m2l2; char *m2p1;} mess_2;
XX  typedef struct {int m3i1, m3i2; char *m3p1; char m3ca1[M3_STRING];} mess_3;
XX! typedef struct {long m4l1, m4l2, m4l3, m4l4, m4l5;} mess_4;
XX! typedef struct {char m5c1, m5c2; int m5i1, m5i2; long m5l1, m5l2, m5l3;}mess_5;
XX! typedef struct {int m6i1, m6i2, m6i3; long m6l1; sighandler_t m6f1;} mess_6;
XX  
XX  typedef struct {
XX    int m_source;			/* who sent the message */
XX***************
XX*** 62,70 ****
XX    } m_u;
XX  } message;
XX  
XX- #define MESS_SIZE (sizeof(message))
XX- #define NIL_MESS (message *) 0
XX- 
XX  /* The following defines provide names for useful members. */
XX  #define m1_i1  m_u.m_m1.m1i1
XX  #define m1_i2  m_u.m_m1.m1i2
XX--- 46,51 ----
XX***************
XX*** 85,95 ****
XX  #define m3_p1  m_u.m_m3.m3p1
XX  #define m3_ca1 m_u.m_m3.m3ca1
XX  
XX- 
XX  #define m4_l1  m_u.m_m4.m4l1
XX  #define m4_l2  m_u.m_m4.m4l2
XX  #define m4_l3  m_u.m_m4.m4l3
XX  #define m4_l4  m_u.m_m4.m4l4
XX  
XX  #define m5_c1  m_u.m_m5.m5c1
XX  #define m5_c2  m_u.m_m5.m5c2
XX--- 66,76 ----
XX  #define m3_p1  m_u.m_m3.m3p1
XX  #define m3_ca1 m_u.m_m3.m3ca1
XX  
XX  #define m4_l1  m_u.m_m4.m4l1
XX  #define m4_l2  m_u.m_m4.m4l2
XX  #define m4_l3  m_u.m_m4.m4l3
XX  #define m4_l4  m_u.m_m4.m4l4
XX+ #define m4_l5  m_u.m_m4.m4l5
XX  
XX  #define m5_c1  m_u.m_m5.m5c1
XX  #define m5_c2  m_u.m_m5.m5c2
XX***************
XX*** 111,129 ****
XX    vir_clicks mem_len;		/* length */
XX  };
XX  
XX- struct copy_info {		/* used by sys_copy(src, dst, bytes) */
XX-   int cp_src_proc;
XX-   int cp_src_space;
XX-   vir_bytes cp_src_vir;
XX-   int cp_dst_proc;
XX-   int cp_dst_space;
XX-   vir_bytes cp_dst_vir;
XX-   vir_bytes cp_bytes;
XX- };
XX- 
XX  struct iorequest_s {
XX    long io_position;		/* position in device file (really off_t) */
XX    char *io_buf;			/* buffer in user space */
XX    unsigned short io_nbytes;	/* size of request */
XX    unsigned short io_request;	/* read, write (optionally) */
XX  };
XX--- 92,130 ----
XX    vir_clicks mem_len;		/* length */
XX  };
XX  
XX  struct iorequest_s {
XX    long io_position;		/* position in device file (really off_t) */
XX    char *io_buf;			/* buffer in user space */
XX    unsigned short io_nbytes;	/* size of request */
XX    unsigned short io_request;	/* read, write (optionally) */
XX  };
XX+ #endif /* _TYPE_H */
XX+ 
XX+ typedef struct {
XX+   vir_bytes iov_addr;		/* address of an I/O buffer */
XX+   vir_bytes iov_size;		/* sizeof an I/O buffer */
XX+ } iovec_t;
XX+ 
XX+ typedef struct {
XX+   vir_bytes cpv_src;		/* src address of data */
XX+   vir_bytes cpv_dst;		/* dst address of data */
XX+   vir_bytes cpv_size;		/* size of data */
XX+ } cpvec_t;
XX+ 
XX+ /* MM passes the address of a structure of this type to KERNEL when
XX+  * do_sendsig() is invoked as part of the signal catching mechanism.
XX+  * The structure contain all the information that KERNEL needs to build
XX+  * the signal stack.
XX+  */
XX+ struct sigmsg {
XX+   int sm_signo;			/* signal number being caught */
XX+   unsigned long sm_mask;	/* mask to restore when handler returns */
XX+   vir_bytes sm_sighandler;	/* address of handler */
XX+   vir_bytes sm_sigreturn;	/* address of _sigreturn in C library */
XX+   vir_bytes sm_stkptr;		/* user stack pointer */
XX+ };
XX+ 
XX+ #define MESS_SIZE (sizeof(message))	/* might need usizeof from fs here */
XX+ #define NIL_MESS ((message *) 0)
XX+ 
XX+ #endif /* _MINIX_TYPE_H */
X/
/
