echo x - Doc
sed '/^X/s///' > Doc << '/'
XNroff is a primitive version of the UNIX nroff program.
XIt supports some nroff commands, but not all.  The following things need to be
Xdone to it:
X
X  - Add more commands (see below for supported/unsupported commands)
X  - Add the 4-character nroff escape sequences (see below).  Device dependent.
X  - Add more of the \ characters, especially the useful ones like:
X    \\, \|, \0, \^, \&, \", \$n, \%, \*, \c, \f, \n, \o, \{, \}
X  - Add the more useful number registers
X  - Write a proper -ms package
X  - Change command line options to be nroff-like
X  - Write drivers for -Tdj (deskjet), -Tepson, -Tlp.  The default way to
X    handle bold should be overprinting, and italics overstriking with _ .
X  - Remove lots of nonstandard stuff where standard mechanisms work better
X  - Support the following command flags.  Delete the current nonstandard ones:
X    -o, -n, -m, -r, -T, 
X
XNote: just adding more commands may cause command() to get so big the compiler
Xcan no longer handle it.  Probably it should be split up into a separate
Xroutine for each command.  Other routines also need to be cleaned up.
X
X
XThe following commands are supported
X------------------------------------
X.ad [mode]	Adjust
X.af R {1,a,A,i,I,0...1}		Assign format to number reg
X.bo [N]		Bold face
X.bp [+/-N]	Begin page
X.br		Break (page)
X.bs [N]		Backspace in output
X.c2 [c=']	Nobreak char
X.cc [c=.]	Command character
X.ce [N]		Center
X.cu [N]		Continuous underline
X.de name [end]	Define macro
X.ds name string	Define string
X.ec [c=\]	Escape char
X.ef "a" "b" "c"	Even footer
X.eh "a" "b" "c"	Even header
X.en or ..	End macro def (should not get one here...)
X.eo		Escape off
X.fi		Fill
X.fl		Flush NOW
X.fo "a" "b" "c"	Footer
X.ft {R,I,B,S,P}	Font change
X.ig name	Ignore input lines
X.in [+/-N]	Indenting
X.ju		Justify
X.ll [+/-N] .rm [+/-N]		Line length
X.ls [+/-N=+1]	Line spacing
X.lt N		Title length
X.m1 N		Topmost margin
X.m2 N		Second top margin
X.m3 N		1st bottom margin
X.m4 N		Bottom-most margin
X.na		No adjust
X.ne N		Need n lines
X.nf		No fill
X.nj		No justify
X.nr R +/-N M	Set number reg
X.of "a" "b" "c"	Odd footer
X.oh "a" "b" "c"	Odd header
X.pc [c=NULL]	Page number char
X.pl N		Page length
X.pm [t]		Print macro names and sizes
X.pn N		Page number
X.po N		Page offset
X.rr R		Unset number reg
X.so name	Source file
X.sp [N=1]	Space
X.ti [+/-N]	Temporary indent
X.tr ab...	Translate
X.ul [N]		Underline
X
X
XThe following commands are not supported, but should be, if possible:
X--------------------------------------------------------
X.bd	embolden
X.ch	change trap
X.el	else
X.em	end macro
X.fp	font position
X.hy	hyphenation control
X.ie	if-else
X.if	if
X.hc	hyphenation char
X.ns	no space mode
X.ps	point size
X.rm	remove definition
X.rn	rename
X.rs	restore spacing
X.ss	set space size
X.ta	tab
X.tl	titles
X.tm	comment
X.vs	vertical spacing
X.wh	trap where
X
X
XThe  following lines show how the 4-character nroff escape sequences can be 
Xbuilt up using overstriking.  Each line has 3 entries: escape name, length of 
Xsequence, codes to output, where \b is backspace.  These are device dependent,
Xand should come from the files invoked by the -T option.  The choices below are
Xfor a printer with backspace and overstrike.
X-------------------------------------------------------------------------------
X\(!= 1 /\b=
X\(& 0
X\(** 1 *
X\(*C 1 _\b-\b~
X\(*D 2 _\b/_\b\\
X\(*F 1 |\bO
X\(*G 2 ~\b|~
X\(*H 1 -\bO
X\(*L 2 /\\
X\(*P 2 ~\b|~\b|
X\(*Q 1 |\bU
X\(*S 1 ~\b_\b>
X\(*U 1 Y
X\(*W 2 _\b(_\b)
X\(*a 1 <\ba
X\(*b 1 ,\bB
X\(*c 1 ,\b3
X\(*d 1 S\bo
X\(*e 1 -\bc
X\(*f 1 /\bo
X\(*g 1 ,\by
X\(*h 1 -\b0
X\(*i 1 ,\bi
X\(*k 1 <\bK
X\(*l 1 \\\b>
X\(*m 1 ,\bu
X\(*n 1 ,\bv
X\(*o 1 o
X\(*p 1 -\bn
X\(*q 1 |\bu
X\(*r 1 p
X\(*s 1 -\bo
X\(*t 1 ~\bt
X\(*u 1 u
X\(*w 1 u\bw
X\(*x 1 /\b\\
X\(*y 1 ,\bn
X\(*z 1 ,\bL
X\(+- 1 _\b+
X\(-> 2 ->
X\(0 1 " 
X\(12 3 1/2
X\(14 3 1/4
X\(34 3 3/4
X\(<- 2 <-
X\(<= 1 _\b<
X\(== 1 _\b=
X\(>= 1 _\b>
X\(^ 0
X\(aa 1 '
X\(ap 1 ~
X\(br 1 |
X\(bs 4 (:-)
X\(bu 1 +\bo
X\(bv 1 |
X\(ca 3 (^)
X\(ci 1 O
X\(co 3 (c)
X\(ct 1 /\bc
X\(cu 1 U
X\(da 1 |\bv
X\(dd 1 I\b|
X\(de 1 '\b`
X\(dg 1 -\b!
X\(di 1 -\b:
X\(em 2 --
X\(eq 1 =
X\(es 1 /\bO
X\(fm 1 '
X\(ga 1 `
X\(gr 1 ~\bV
X\(hy 1 -
X\(ib 2 (~\b_\b=
X\(if 2 oo
X\(ip 2 ~\b_\b=)
X\(is 1 '\b,\bI
X\(lb 1 _\b(
X\(lc 1 ~\b[
X\(lf 1 _\b[
X\(lh 1 =\b<
X\(lk 1 -\b(
X\(lt 1 ~\b(
X\(mi 1 -
X\(mo 1 -\bC
X\(mu 1 x
X\(no 1 -
X\(or 1 |
X\(pd 1 3\bo
X\(pl 1 +
X\(pt 2 oc
X\(rb 1 _\b)
X\(rc 1 ~\b]
X\(rf 1 _\b]
X\(rg 3 (R)
X\(rh 1 =\b>
X\(rk 1 -\b)
X\(rn 1 ~
X\(rt 1 ~\b)
X\(ru 1 _
X\(sb 2 (_\b~
X\(sc 1 j\bf
X\(sl 1 /
X\(sp 2 _\b~)
X\(sq 2 []
X\(sr 2 \\/
X\(ts 1 s
X\(ua 1 |\b^
X\(ul 1 _
X\(| 0
X\(~= 1 ~\b=
/
echo x - tmac.ms
sed '/^X/s///' > tmac.ms << '/'
X.\" Macro package taken from cawf.  Just for ideas */
X.de R
X.ie \\n(.$=0 .ft R
X.el \\fR\\$1\\fP\\$2
X..
X.\"-----------------
X.de I
X.ie \\n(.$=0 .ft I
X.el \\fI\\$1\\fP\\$2
X..
X.\"-----------------
X.de B
X.ie \\n(.$=0 .ft B
X.el \\fB\\$1\\fP\\$2
X..
X.\"-----------------
X.de UX
X.\" old-fashioned capitalization -- I've never gotten used to the new one
X\\$2Unix\\$1
X..
X.\"-----------------
X.de DA
X.ds DY "\\$1 \\$2 \\$3
X.\" keep trailing spaces out of CF
X.if \\n(.$=1 .ds CF "\\$1
X.if \\n(.$=2 .ds CF "\\$1 \\$2
X.if \\n(.$>2 .ds CF "\\$1 \\$2 \\$3
X..
X.\"-----------------
X.de ND
X.\" it's our default, ignore it
X..
X.\"-----------------
X.de TL
X.rs
X.sp 5
X.ft B
X.ce 9999
X..
X.\"-----------------
X.de AU
X.sp 2
X.ft R
X..
X.\"-----------------
X.de AI
X.sp
X.ft R
X..
X.\"-----------------
X.de AB
X.sp 2
X.ce 0
X.ll -7n
X.in +7n
X..
X.\"-----------------
X.de AE
X.sp
X.ll
X.in
X..
X.\"-----------------
X.\" common initialization for headers and paragraphs:  .In need extraspace
X.de In
X.ne \\$1
X.sp \\n(Tsu
X.nr Ts 0
X.ie \\n(.$>1 .nr iN \\$2v
X.el .nr iN 0
X.sp \\n(PDu+\\n(iNu
X.ce 0
X.ft R
X.in 0
X.ti 0
X.in \\n(inu
X.ll \\n(LLu
X.ns
X.fi
X..
X.\"-----------------
X.de SH
X.nr in 0
X.In 6 1
X.ft B
X..
X.\"-----------------
X.de NH
X.nr in 0
X.In 6 1
X.ft B
X.\" punt to awk code to get the header numbering right
X.nH \\$1
X.\" and pick up the result
X\&\\*(Nh
X..
X.\"-----------------
X.de LP
X.In 4
X..
X.\"-----------------
X.de PP
X.In 4
X.ti \\n(PIu
X..
X.\"-----------------
X.de TP
X.In 4
X.if \\n(.$>0 .nr tp \\$1n
X.in \\n(inu+\\n(tpu
X.ti 0-\\n(tpu
X.it 1 tP
X..
X.\"-----------------
X.de IP
X.ie \\n(.$>1 .TP "\\$2"
X.el .TP 4n
X\&\\$1
X..
X.\"-----------------
X.de QP
X.In 4
X.in +5n
X.ll -5n
X..
X.\"-----------------
X.de QS
X.nr in +5n
X.nr LL -5n
X.In 4
X..
X.\"-----------------
X.de QE
X.nr in -5n
X.nr LL +5n
X.In 4
X..
X.\"-----------------
X.de DS
X.In 5
X.if '\\$1'C' .ce 9999
X.if '\\$1'' .in +5n
X.nf
X..
X.\"-----------------
X.de CD
X.In 5
X.ce 9999
X.nf
X..
X.\"-----------------
X.de LD
X.In 5
X.nf
X..
X.\"-----------------
X.de ID
X.In 5
X.in +5n
X.nf
X..
X.\"-----------------
X.de DE
X.In 3
X.rs
X..
X.\"-----------------
X.de RS
X.nr in +5n
X.in \\n(inu
X..
X.\"-----------------
X.de RE
X.nr in -5n
X.in \\n(inu
X..
X.\"-----------------
X.de UL
X\&\\fI$1\\fP
X..
X.\"-----------------
X.de RP
X..
X.\"-----------------
X.de LG
X..
X.\"-----------------
X.de SM
X..
X.\"-----------------
X.de NL
X..
X.\"-----------------
X.\" the -ms accent strings
X.ds ' "'\b
X.ds ` "`\b
X.ds : ":\b
X.ds ^ "^\b
X.ds ~ "~\b
X.ds C "v\b
X.ds , ",\b
X.\" post-title spacing
X.nr Ts 4v
X.\" and parameter setup
X.nr LL 6i
X.ll \n(LLu
X.nr PD 0.3v
X.nr PI 5n
XHello
/
echo x - nroff.cd
sed '/^X/s///' > nroff.cd << '/'
Xecho x - Makefile.d
Xsed '/^X/s///' > Makefile.d << '/'
XX*** /home/top/ast/minix/1.5/commands/nroff/Makefile  crc=53641    210	Sat Apr 21 22:27:21 1990
XX--- /home/top/ast/minix/1.6.25/commands/nroff/Makefile  crc=55763    304	Sat Jan 30 20:12:17 1993
XX***************
XX*** 1,9 ****
XX  # Makefile for nroff
XX  CFLAGS=-D_MINIX -D_POSIX_SOURCE -F
XX! OBJS    = main.s command.s text.s io.s macros.s strings.s escape.s low.s
XX  
XX  nroff:	$(OBJS) nroff.h
XX! 	cc -i -o nroff $(OBJS)
XX  
XX  clean:	
XX! 	@rm -f *.bak *.s nroff
XX--- 1,14 ----
XX  # Makefile for nroff
XX+ 
XX  CFLAGS=-D_MINIX -D_POSIX_SOURCE -F
XX! O=o
XX! OBJS = main.$O command.$O text.$O io.$O macros.$O strings.$O escape.$O low.$O
XX  
XX  nroff:	$(OBJS) nroff.h
XX! 	@rm -rf mroff
XX! 	@echo Start linking nroff
XX! 	@cc -i -o nroff $(OBJS) >/dev/null
XX! 	@chmem =65000 nroff
XX  
XX  clean:	
XX! 	@rm -f *.bak *.o *.s core nroff
X/
Xecho x - command.c.d
Xsed '/^X/s///' > command.c.d << '/'
XX*** /home/top/ast/minix/1.5/commands/nroff/command.c  crc=34131  17355	Sat Apr 21 22:27:21 1990
XX--- /home/top/ast/minix/1.6.25/commands/nroff/command.c  crc=07687  15421	Mon Nov 23 12:19:51 1992
XX***************
XX*** 1,934 ****
XX! /*
XX!  *	command.c - command input parser/processor for nroff text processor
XX!  *
XX!  *	adapted for atariST/TOS by Bill Rosenkranz 11/89
XX!  *	net:	rosenkra@hall.cray.com
XX!  *	CIS:	71460,17
XX!  *	GENIE:	W.ROSENKRANZ
XX!  *
XX!  *	original author:
XX!  *
XX!  *	Stephen L. Browning
XX!  *	5723 North Parker Avenue
XX!  *	Indianapolis, Indiana 46220
XX!  *
XX!  *	history:
XX!  *
XX!  *	- Originally written in BDS C;
XX!  *	- Adapted for standard C by W. N. Paul
XX!  *	- Heavily hacked up to conform to "real" nroff by Bill Rosenkranz
XX!  */
XX  
XX- #undef NRO_MAIN					/* extern globals */
XX- 
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX! 
XX! 
XX! /*------------------------------*/       
XX  /*	comand			*/
XX! /*------------------------------*/       
XX! comand (p)
XX! register char  *p;
XX  {
XX  
XX! /*
XX!  *	main command processor
XX!  */
XX  
XX! 	register int	i;
XX! 	register int	ct;
XX! 	register int	val;
XX! 	register int   	indx;
XX! 	int		newval;
XX! 	int     	spval;
XX! 	char    	argtyp;
XX! 	char    	name[MAXLINE];
XX! 	char    	macexp[MXMLEN];
XX! 	int		tmp;
XX! 	char	       *pfs;
XX! 	char		fs[20];
XX  
XX  
XX! 	/*
XX! 	 *   get command code
XX! 	 */
XX! 	ct = comtyp (p, macexp);
XX  
XX! 	/*
XX! 	 *   error?
XX! 	 */
XX! 	if (ct == UNKNOWN)
XX! 	{
XX! 		fprintf (err_stream,
XX! 			"***%s: unrecognized command %s\n", myname, p);
XX! 		return;
XX  	}
XX  
XX! 	/*
XX! 	 *   ignore comments
XX! 	 */
XX! 	if (ct == COMMENT)
XX! 		return;
XX  
XX  
XX! 	/*
XX! 	 *   do escape expansion on command line args
XX! 	 */
XX! 	expesc (p, name);
XX  
XX  
XX! 	/*
XX! 	 *   get value of command
XX! 	 */
XX! 	val = getval (p, &argtyp);
XX  
XX  
XX! 	/*
XX! 	 *   do the command
XX! 	 */
XX! 	switch (ct)
XX! 	{
XX! 	/* set (&param, val, type, defval, minval, maxval) */
XX! 	case FC:
XX! 		/*
XX! 		 *   field delim/pad chars
XX! 		 *
XX! 		 *   .fc [delim] [pad]
XX! 		 */
XX! 		fprintf (err_stream, "***%s: .fc not available\n", myname);
XX! 		break;
XX! 	case TR:
XX! 		/*
XX! 		 *   translate
XX! 		 *
XX! 		 *   .tr ab...
XX! 		 */
XX! 		fprintf (err_stream, "***%s: .tr not available\n", myname);
XX! 		break;
XX  
XX  
XX  
XX  
XX! 	case AD:
XX! 		/*
XX! 		 *   adjust
XX! 		 *
XX! 		 *   .ad [mode]
XX! 		 */
XX! 		p = skipwd (p);
XX! 		p = skipbl (p);
XX  
XX! 		switch (*p)
XX! 		{
XX! 		case 'l':
XX! 			dc.adjval = ADJ_LEFT;
XX! 			dc.juval  = YES;
XX! 			break;
XX! 		case 'r':
XX! 			dc.adjval = ADJ_RIGHT;
XX! 			dc.juval  = YES;
XX! 			break;
XX! 		case 'c':
XX! 			dc.adjval = ADJ_CENTER;
XX! 			dc.juval  = YES;
XX! 			break;
XX! 		case 'b':
XX! 		case 'n':
XX! 			dc.adjval = ADJ_BOTH;
XX! 			dc.juval  = YES;
XX! 			break;
XX! 		default:
XX! 			break;
XX! 		}
XX! 		break;
XX! 	case AF:
XX! 		/*
XX! 		 *   assign format to number reg
XX! 		 *
XX! 		 *   .af R {1,a,A,i,I,0...1}
XX! 		 */
XX! 		p = skipwd (p);
XX! 		p = skipbl (p);
XX! 		if (!isalpha (*p))
XX! 		{
XX! 			fprintf (err_stream,
XX! 				"***%s: invalid or missing number register name\n",
XX! 				myname);
XX! 		}
XX! 		else
XX! 		{
XX! 			/*
XX! 			 *   number register format is 1,a,A,i,I,0...1
XX! 			 *   default is 1. for 0001 format, store num dig
XX! 			 *   or'ed with 0x80, up to 8 digits.
XX! 			 */
XX! 			indx = tolower (*p) - 'a';
XX! 			p = skipwd (p);
XX! 			p = skipbl (p);
XX! 			if (*p == '1')
XX! 				dc.nrfmt[indx] = '1';
XX! 			else if (*p == 'a')
XX! 				dc.nrfmt[indx] = 'a';
XX! 			else if (*p == 'A')
XX! 				dc.nrfmt[indx] = 'A';
XX! 			else if (*p == 'i')
XX! 				dc.nrfmt[indx] = 'i';
XX! 			else if (*p == 'I')
XX! 				dc.nrfmt[indx] = 'I';
XX! 			else if (*p == '0')
XX! 			{
XX! 				for (i = 0; isdigit (p[i]); i++)
XX! 					;
XX! 				dc.nrfmt[indx] = (char) (i);
XX! 				if (dc.nrfmt[indx] <= 0)
XX! 					dc.nrfmt[indx] = '1';
XX! 				else if (dc.nrfmt[indx] > 8)
XX! 				{
XX! 					dc.nrfmt[indx]  = 8;
XX! 					dc.nrfmt[indx] |= 0x80;
XX! 				}
XX! 				else
XX! 					dc.nrfmt[indx] |= 0x80;
XX  
XX! 			}
XX! 			else
XX! 				dc.nrfmt[indx] = '1';
XX! 		}
XX! 		break;
XX! 	case BD:
XX! 		/*
XX! 		 *   embolden font (IGNORED)
XX! 		 *
XX! 		 *   .bd [S] F N
XX! 		 */
XX! 		break;
XX! 	case BO:
XX! 		/*
XX! 		 *   bold face
XX! 		 *
XX! 		 *   .bo [N]
XX! 		 */
XX! 		set (&dc.boval, val, argtyp, 1, 0, HUGE);
XX! 		dc.cuval = dc.ulval = 0;
XX! 		break;
XX! 	case BP:
XX! 		/*
XX! 		 *   begin page
XX! 		 *
XX! 		 *   .bp [+/-N]
XX! 		 */
XX! 		if (pg.lineno > 0)
XX! 			space (HUGE);
XX! 		set (&pg.curpag, val, argtyp, pg.curpag + 1, -HUGE, HUGE);
XX! 		pg.newpag = pg.curpag;
XX! 		set_ireg ("%", pg.newpag, 0);
XX! 		break;
XX! 	case BR:
XX! 		/*
XX! 		 *   break (page)
XX! 		 *
XX! 		 *   .br
XX! 		 */
XX! 		robrk ();
XX! 		break;
XX! 	case BS:
XX! 		/*
XX! 		 *   backspc in output
XX! 		 *
XX! 		 *   .bs [N]
XX! 		 */
XX! 		set (&dc.bsflg, val, argtyp, 1, 0, 1);
XX! 		break;
XX! 	case C2:
XX! 		/*
XX! 		 *   nobreak char
XX! 		 *
XX! 		 *   .c2 [c=']
XX! 		 */
XX! 		if (argtyp == '\r' || argtyp == '\n')
XX! 			dc.nobrchr = '\'';
XX! 		else
XX! 			dc.nobrchr = argtyp;
XX! 		break;
XX! 	case CC:
XX! 		/*
XX! 		 *   command character
XX! 		 *
XX! 		 *   .cc [c=.]
XX! 		 */
XX! 		if (argtyp == '\r' || argtyp == '\n')
XX! 			dc.cmdchr = '.';
XX! 		else
XX! 			dc.cmdchr = argtyp;
XX! 		break;
XX! 	case CE:
XX! 		/*
XX! 		 *   center
XX! 		 *
XX! 		 *   .ce [N]
XX! 		 */
XX! 		robrk ();
XX! 		set (&dc.ceval, val, argtyp, 1, 0, HUGE);
XX! 		break;
XX! 	case CS:
XX! 		/*
XX! 		 *   constant space char (IGNORED)
XX! 		 *
XX! 		 *   .cs F N M
XX! 		 */
XX! 		break;
XX! 	case CU:
XX! 		/*
XX! 		 *   continuous underline
XX! 		 *
XX! 		 *   .cu [N]
XX! 		 */
XX! 		set (&dc.cuval, val, argtyp, 1, 0, HUGE);
XX! 		dc.ulval = dc.boval = 0;
XX! 		break;
XX! 	case DE:
XX! 		/*
XX! 		 *   define macro
XX! 		 *
XX! 		 *   .de name [end]
XX! 		 */
XX! 		ignoring = FALSE;
XX! 		defmac (p, sofile[dc.flevel]);
XX! 		break;
XX! 	case DS:
XX! 		/*
XX! 		 *   define string
XX! 		 *
XX! 		 *   .ds name string
XX! 		 */
XX! 		defstr (p);
XX! 		break;
XX! 	case EC:
XX! 		/*
XX! 		 *   escape char
XX! 		 *
XX! 		 *   .ec [c=\]
XX! 		 */
XX! 		if (argtyp == '\r' || argtyp == '\n')
XX! 			dc.escchr = '\\';
XX! 		else
XX! 			dc.escchr = argtyp;
XX! 		dc.escon = YES;
XX! 		break;
XX! 	case EF:
XX! 		/*
XX! 		 *   even footer
XX! 		 *
XX! 		 *   .ef "a" "b" "c"
XX! 		 */
XX! 		gettl (p, pg.efoot, &pg.eflim[0]);
XX! 		break;
XX! 	case EH:
XX! 		/*
XX! 		 *   even header
XX! 		 *
XX! 		 *   .eh "a" "b" "c"
XX! 		 */
XX! 		gettl (p, pg.ehead, &pg.ehlim[0]);
XX! 		break;
XX! 	case EN:
XX! 		/*
XX! 		 *   end macro def (should not get one here...)
XX! 		 *
XX! 		 *   .en or ..
XX! 		 */
XX! 		fprintf (err_stream, "***%s: missing .de command\n", myname);
XX! 		break;
XX! 	case EO:
XX! 		/*
XX! 		 *   escape off
XX! 		 *
XX! 		 *   .eo
XX! 		 */
XX! 		dc.escon = NO;
XX! 		break;
XX! 	case FI:
XX! 		/*
XX! 		 *   fill
XX! 		 *
XX! 		 *   .fi
XX! 		 */
XX! 		robrk ();
XX! 		dc.fill = YES;
XX! 		break;
XX! 	case FL:
XX! 		/*
XX! 		 *   flush NOW
XX! 		 *
XX! 		 *   .fl
XX! 		 */
XX! 		fflush (out_stream);
XX! 		break;
XX! 	case FO:
XX! 		/*
XX! 		 *   footer
XX! 		 *
XX! 		 *   .fo "a" "b" "c"
XX! 		 */
XX! 		gettl (p, pg.efoot, &pg.eflim[0]);
XX! 		gettl (p, pg.ofoot, &pg.oflim[0]);
XX! 		break;
XX! 	case FT:
XX! 		/*
XX! 		 *   font change
XX! 		 *
XX! 		 *   .ft {R,I,B,S,P}
XX! 		 *
XX! 		 *   the way it's implemented here, it causes a break
XX! 		 *   rather than be environmental...
XX! 		 */
XX! 		p = skipwd (p);
XX! 		p = skipbl (p);
XX! 		if (!isalpha (*p))
XX! 		{
XX! 			fprintf (err_stream,
XX! 				"***%s: invalid or missing font name\n",
XX! 				myname);
XX! 		}
XX! 		else
XX! 		{
XX! 			pfs = &fs[0];
XX  
XX! 			fontchange (*p, pfs);
XX  
XX! 			robrk ();
XX! 			fflush (out_stream);
XX! 			fprintf (out_stream, "%s", pfs);
XX! 			fflush (out_stream);
XX! 		}
XX! 		break;
XX! 	case TL:
XX! 	case HE:
XX! 		/*
XX! 		 *   header (both are currently identical. .he is -me)
XX! 		 *
XX! 		 *   .tl "a" "b" "c"
XX! 		 *   .he "a" "b" "c"
XX! 		 */
XX! 		gettl (p, pg.ehead, &pg.ehlim[0]);
XX! 		gettl (p, pg.ohead, &pg.ohlim[0]);
XX! 		break;
XX! 	case IG:
XX! 		/*
XX! 		 *   ignore input lines
XX! 		 *
XX! 		 *   .ig name
XX! 		 */
XX! 		ignoring = TRUE;
XX! 		defmac (p, sofile[dc.flevel]);
XX! 		break;
XX! 	case IN:
XX! 		/*
XX! 		 *   indenting
XX! 		 *
XX! 		 *   .in [+/-N]
XX! 		 */
XX! 		set (&dc.inval, val, argtyp, 0, 0, dc.rmval - 1);
XX! 		set_ireg (".i", dc.inval, 0);
XX! 		dc.tival = dc.inval;
XX! 		break;
XX! 	case JU:
XX! 		/*
XX! 		 *   justify
XX! 		 *
XX! 		 *   .ju
XX! 		 */
XX! 		dc.juval = YES;
XX! 		break;
XX! 	case LL:
XX! 		/*
XX! 		 *   line length
XX! 		 *
XX! 		 *   .ll [+/-N]
XX! 		 *   .rm [+/-N]
XX! 		 */
XX! 		set (&dc.rmval, val, argtyp, PAGEWIDTH, dc.tival + 1, HUGE);
XX! 		set (&dc.llval, val, argtyp, PAGEWIDTH, dc.tival + 1, HUGE);
XX! 		set_ireg (".l", dc.llval, 0);
XX! 		break;
XX! 	case LS:
XX! 		/*
XX! 		 *   line spacing
XX! 		 *
XX! 		 *   .ls [+/-N=+1]
XX! 		 */
XX! 		set (&dc.lsval, val, argtyp, 1, 1, HUGE);
XX! 		set_ireg (".v", dc.lsval, 0);
XX! 		break;
XX! 	case LT:
XX! 		/*
XX! 		 *   title length
XX! 		 *
XX! 		 *   .lt N
XX! 		 */
XX! 		set (&dc.ltval, val, argtyp, PAGEWIDTH, 0, HUGE);
XX! 		pg.ehlim[RIGHT] = dc.ltval;
XX! 		pg.ohlim[RIGHT] = dc.ltval;
XX! 		break;
XX! 	case M1:
XX! 		/*
XX! 		 *   topmost margin
XX! 		 *
XX! 		 *   .m1 N
XX! 		 */
XX! 		set (&pg.m1val, val, argtyp, 2, 0, HUGE);
XX! 		break;
XX! 	case M2:
XX! 		/*
XX! 		 *   second top margin
XX! 		 *
XX! 		 *   .m2 N
XX! 		 */
XX! 		set (&pg.m2val, val, argtyp, 2, 0, HUGE);
XX! 		break;
XX! 	case M3:
XX! 		/*
XX! 		 *   1st bottom margin
XX! 		 *
XX! 		 *   .m3 N
XX! 		 */
XX! 		set (&pg.m3val, val, argtyp, 2, 0, HUGE);
XX! 		pg.bottom = pg.plval - pg.m4val - pg.m3val;
XX! 		break;
XX! 	case M4:
XX! 		/*
XX! 		 *   bottom-most marg
XX! 		 *
XX! 		 *   .m4 N
XX! 		 */
XX! 		set (&pg.m4val, val, argtyp, 2, 0, HUGE);
XX! 		pg.bottom = pg.plval - pg.m4val - pg.m3val;
XX! 		break;
XX! 	case MACRO:
XX! 		/*
XX! 		 *   macro expansion
XX! 		 *
XX! 		 *   (internal)
XX! 		 */
XX! 		maceval (p, macexp);
XX! 		break;
XX! 	case NA:
XX! 		/*
XX! 		 *   no adjust
XX! 		 *
XX! 		 *   .na
XX! 		 */
XX! 		dc.adjval = ADJ_OFF;
XX! 		dc.juval  = NO;
XX! 		break;
XX! 	case NE:
XX! 		/*
XX! 		 *   need n lines
XX! 		 *
XX! 		 *   .ne N
XX! 		 */
XX! 		robrk ();
XX! 		if ((pg.bottom - pg.lineno + 1) < (val * dc.lsval))
XX! 		{
XX! 			space (HUGE);
XX! 		}
XX! 		break;
XX! 	case NF:
XX! 		/*
XX! 		 *   no fill
XX! 		 *
XX! 		 *   .nf
XX! 		 */
XX! 		robrk ();
XX! 		dc.fill = NO;
XX! 		break;
XX! 	case NJ:
XX! 		/*
XX! 		 *   no justify
XX! 		 *
XX! 		 *   .nj
XX! 		 */
XX! 		dc.juval = NO;
XX! 		break;
XX! 	case NR:
XX! 		/*
XX! 		 *   set number reg
XX! 		 *
XX! 		 *   .nr R +/-N M
XX! 		 */
XX! 		p = skipwd (p);
XX! 		p = skipbl (p);
XX! 		if (!isalpha (*p))
XX! 		{
XX! 			fprintf (err_stream,
XX! 				"***%s: invalid or missing number register name\n",
XX! 				myname);
XX! 		}
XX! 		else
XX! 		{
XX! 			/*
XX! 			 *   indx is the register, R, and val is the final
XX! 			 *   value (default = 0). getval does skipwd,skipbl
XX! 			 */
XX! 			indx = tolower (*p) - 'a';
XX! 			val = getval (p, &argtyp);
XX! 			set (&dc.nr[indx], val, argtyp, 0, -INFINITE, INFINITE);
XX  
XX! 			/*
XX! 			 *   now get autoincrement M, if any (default = 1).
XX! 			 *   getval does skipwd,skipbl
XX! 			 */
XX! 			p = skipwd (p);
XX! 			p = skipbl (p);
XX! 			val = getval (p, &argtyp);
XX! 			set (&dc.nrauto[indx], val, '1', 1, -INFINITE, INFINITE);
XX! 		}
XX! 		break;
XX! 	case OF:
XX! 		/*
XX! 		 *   odd footer
XX! 		 *
XX! 		 *   .of "a" "b" "c"
XX! 		 */
XX! 		gettl (p, pg.ofoot, &pg.oflim[0]);
XX! 		break;
XX! 	case OH:
XX! 		/*
XX! 		 *   odd header
XX! 		 *
XX! 		 *   .oh "a" "b" "c"
XX! 		 */
XX! 		gettl (p, pg.ohead, &pg.ohlim[0]);
XX! 		break;
XX! 	case PC:
XX! 		/*
XX! 		 *   page number char
XX! 		 *
XX! 		 *   .pc [c=NULL]
XX! 		 */
XX! 		if (argtyp == '\r' || argtyp == '\n')
XX! 			dc.pgchr = EOS;
XX! 		else
XX! 			dc.pgchr = argtyp;
XX! 		break;
XX! 	case PL:
XX! 		/*
XX! 		 *   page length
XX! 		 *
XX! 		 *   .pl N
XX! 		 */
XX! 		set (&pg.plval,
XX! 		     val,
XX! 		     argtyp,
XX! 		     PAGELEN,
XX! 		     pg.m1val + pg.m2val + pg.m3val + pg.m4val + 1,
XX! 		     HUGE);
XX! 		set_ireg (".p", pg.plval, 0);
XX! 		pg.bottom = pg.plval - pg.m3val - pg.m4val;
XX! 		break;
XX! 	case PM:
XX! 		/*
XX! 		 *   print macro names and sizes
XX! 		 *
XX! 		 *   .pm [t]
XX! 		 */
XX! 		if (argtyp == '\r' || argtyp == '\n')
XX! 			printmac (0);
XX! 		else if (argtyp == 't')
XX! 			printmac (1);
XX! 		else if (argtyp == 'T')
XX! 			printmac (2);
XX! 		else
XX! 			printmac (0);
XX! 		break;
XX! 	case PN:
XX! 		/*
XX! 		 *   page number
XX! 		 *
XX! 		 *   .pn N
XX! 		 */
XX! 		tmp = pg.curpag;
XX! 		set (&pg.curpag, val - 1, argtyp, tmp, -HUGE, HUGE);
XX! 		pg.newpag = pg.curpag + 1;
XX! 		set_ireg ("%", pg.newpag, 0);
XX! 		break;
XX! 	case PO:
XX! 		/*
XX! 		 *   page offset
XX! 		 *
XX! 		 *   .po N
XX! 		 */
XX! 		set (&pg.offset, val, argtyp, 0, 0, HUGE);
XX! 		set_ireg (".o", pg.offset, 0);
XX! 		break;
XX! 	case PS:
XX! 		/*
XX! 		 *   point size (IGNORED)
XX! 		 *
XX! 		 *   .ps +/-N
XX! 		 */
XX! 		break;
XX! 	case RR:
XX! 		/*
XX! 		 *   unset number reg
XX! 		 *
XX! 		 *   .rr R
XX! 		 */
XX! 		p = skipwd (p);
XX! 		p = skipbl (p);
XX! 		if (!isalpha (*p))
XX! 		{
XX! 			fprintf (err_stream,
XX! 				"***%s: invalid or missing number register name\n",
XX! 				myname);
XX! 		}
XX! 		else
XX! 		{
XX! 			indx = tolower (*p) - 'a';
XX! 			val = 0;
XX! 			set (&dc.nr[indx], val, argtyp, 0, -HUGE, HUGE);
XX! 		}
XX! 		break;
XX! 	case SO:
XX! 		/*
XX! 		 *   source file
XX! 		 *
XX! 		 *   .so name
XX! 		 */
XX! 		p = skipwd (p);
XX! 		p = skipbl (p);
XX! 		if (getwrd (p, name) == 0)
XX! 			break;
XX! 		if (dc.flevel + 1 >= Nfiles)
XX! 		{
XX! 			fprintf (err_stream,
XX! 				"***%s: .so commands nested too deeply\n",
XX! 				myname);
XX! 			err_exit (-1);
XX! 		}
XX! 		if ((sofile[dc.flevel + 1] = fopen (name, "r")) == NULL_FPTR)
XX! 		{
XX! 			fprintf (err_stream,
XX! 				"***%s: unable to open %s\n", myname, name);
XX! 			err_exit (-1);
XX! 		}
XX! 		dc.flevel += 1;
XX! 		break;
XX! 	case SP:
XX! 		/*
XX! 		 *   space
XX! 		 *
XX! 		 *   .sp [N=1]
XX! 		 */
XX! 		set (&spval, val, argtyp, 1, 0, HUGE);
XX! 		space (spval);
XX! 		break;
XX! 	case SS:
XX! 		/*
XX! 		 *   space char size (IGNORED)
XX! 		 *
XX! 		 *   .ss N
XX! 		 */
XX! 		break;
XX! 	case TI:
XX! 		/*
XX! 		 *   temporary indent
XX! 		 *
XX! 		 *   .ti [+/-N]
XX! 		 */
XX! 		robrk ();
XX! 		set (&dc.tival, val, argtyp, 0, 0, dc.rmval);
XX! 		break;
XX! 	case UL:
XX! 		/*
XX! 		 *   underline
XX! 		 *
XX! 		 *   .ul [N]
XX! 		 */
XX! 		set (&dc.ulval, val, argtyp, 0, 1, HUGE);
XX! 		dc.cuval = dc.boval = 0;
XX! 		break;
XX! 	}
XX! }
XX  
XX  
XX  
XX  
XX  
XX! /*------------------------------*/
XX! /*	comtyp			*/
XX! /*------------------------------*/
XX! comtyp (p, m)
XX! register char  *p;
XX! char	       *m;
XX! {
XX  
XX! /*
XX!  *	decodes nro command and returns its associated value.
XX!  *	ptr "p" is incremented (and returned)
XX!  */
XX  
XX! 	register char	c1;
XX! 	register char	c2;
XX! 	char	       *s;
XX! 	char    	macnam[MNLEN];
XX  
XX! 	/*
XX! 	 *   skip past dot and any whitespace
XX! 	 */
XX! 	p++;
XX! 	while (*p && (*p == ' ' || *p == '\t'))
XX! 		p++;
XX! 	if (*p == '\0')
XX! 		return (COMMENT);
XX  
XX! 	/* 
XX! 	 *	First check to see if the command is a macro.
XX! 	 *	If it is, truncate to two characters and return
XX! 	 *	expansion in m.  Note that upper and lower case
XX! 	 *	characters are handled differently.
XX  	 */
XX! 	getwrd (p, macnam);
XX! 	macnam[2] = EOS;
XX! 	if ((s = getmac (macnam)) != NULL_CPTR)
XX! 	{
XX! 		strcpy (m, s);
XX! 		return (MACRO);
XX  	}
XX! 	c1 = *p++;
XX! 	c2 = *p;
XX! 	if (c1 == '\\' && c2 == '\"')		return (COMMENT);
XX! 	if (c1 == 'a' && c2 == 'f')		return (AF);
XX! 	if (c1 == 'a' && c2 == 'd')		return (AD);
XX! 	if (c1 == 'b' && c2 == 'o')		return (BO);
XX! 	if (c1 == 'b' && c2 == 'p')		return (BP);
XX! 	if (c1 == 'b' && c2 == 'r')		return (BR);
XX! 	if (c1 == 'b' && c2 == 's')		return (BS);
XX! 	if (c1 == 'c' && c2 == 'c')		return (CC);
XX! 	if (c1 == 'c' && c2 == 'e')		return (CE);
XX! 	if (c1 == 'c' && c2 == 'u')		return (CU);
XX! 	if (c1 == 'd' && c2 == 'e')		return (DE);
XX! 	if (c1 == 'd' && c2 == 's')		return (DS);
XX! 	if (c1 == 'e' && c2 == 'f')		return (EF);
XX! 	if (c1 == 'e' && c2 == 'c')		return (EC);
XX! 	if (c1 == 'e' && c2 == 'h')		return (EH);
XX! 	if (c1 == 'e' && c2 == 'n')		return (EN);
XX! 	if (c1 == '.')				return (EN);
XX! 	if (c1 == 'e' && c2 == 'o')		return (EO);
XX! 	if (c1 == 'f' && c2 == 'i')		return (FI);
XX! 	if (c1 == 'f' && c2 == 'l')		return (FL);
XX! 	if (c1 == 'f' && c2 == 'o')		return (FO);
XX! 	if (c1 == 'f' && c2 == 't')		return (FT);
XX! 	if (c1 == 'h' && c2 == 'e')		return (HE);
XX! 	if (c1 == 'i' && c2 == 'n')		return (IN);
XX! 	if (c1 == 'j' && c2 == 'u')		return (JU);
XX! 	if (c1 == 'l' && c2 == 'l')		return (LL);
XX! 	if (c1 == 'l' && c2 == 's')		return (LS);
XX! 	if (c1 == 'm' && c2 == '1')		return (M1);
XX! 	if (c1 == 'm' && c2 == '2')		return (M2);
XX! 	if (c1 == 'm' && c2 == '3')		return (M3);
XX! 	if (c1 == 'm' && c2 == '4')		return (M4);
XX! 	if (c1 == 'n' && c2 == 'a')		return (NA);
XX! 	if (c1 == 'n' && c2 == 'e')		return (NE);
XX! 	if (c1 == 'n' && c2 == 'f')		return (NF);
XX! 	if (c1 == 'n' && c2 == 'j')		return (NJ);
XX! 	if (c1 == 'n' && c2 == 'r')		return (NR);
XX! 	if (c1 == 'o' && c2 == 'f')		return (OF);
XX! 	if (c1 == 'o' && c2 == 'h')		return (OH);
XX! 	if (c1 == 'p' && c2 == 'c')		return (PC);
XX! 	if (c1 == 'p' && c2 == 'l')		return (PL);
XX! 	if (c1 == 'p' && c2 == 'm')		return (PM);
XX! 	if (c1 == 'p' && c2 == 'o')		return (PO);
XX! 	if (c1 == 'r' && c2 == 'm')		return (RM);
XX! 	if (c1 == 'r' && c2 == 'r')		return (RR);
XX! 	if (c1 == 's' && c2 == 'o')		return (SO);
XX! 	if (c1 == 's' && c2 == 'p')		return (SP);
XX! 	if (c1 == 't' && c2 == 'i')		return (TI);
XX! 	if (c1 == 't' && c2 == 'l')		return (TL);
XX! 	if (c1 == 'u' && c2 == 'l')		return (UL);
XX  
XX! 	if (c1 == 'p' && c2 == 'n')		return (PN);
XX! 	if (c1 == 'r' && c2 == 'r')		return (RR);
XX! 	if (c1 == 'c' && c2 == '2')		return (C2);
XX! 	if (c1 == 't' && c2 == 'r')		return (TR);
XX! 	if (c1 == 'l' && c2 == 't')		return (LT);
XX! 	if (c1 == 'f' && c2 == 'c')		return (FC);
XX  
XX! 	return (UNKNOWN);
XX! }
XX  
XX  
XX  
XX  
XX  
XX  /*------------------------------*/
XX! /*	gettl			*/
XX  /*------------------------------*/
XX! gettl (p, q, limit)
XX! register char  *p;
XX! register char  *q;
XX! int	       *limit;
XX  {
XX  
XX! /*
XX!  *	get header or footer title
XX   */
XX  
XX! 	/*
XX! 	 *   skip forward a word...
XX! 	 */
XX! 	p = skipwd (p);
XX! 	p = skipbl (p);
XX  
XX! 	/*
XX! 	 *   copy and set limits
XX! 	 */
XX! 	strcpy (q, p);
XX! 	limit[LEFT]  = dc.inval;
XX! 	limit[RIGHT] = dc.rmval;
XX  }
XX  
XX  
XX  
XX  
XX  
XX  /*------------------------------*/
XX  /*	getval			*/
XX  /*------------------------------*/
XX! getval (p, p_argt)
XX! register char  *p;
XX! register char  *p_argt;
XX  {
XX  
XX! /*
XX!  *	retrieves optional argument following command.
XX!  *	returns positive integer value with sign (if any)
XX!  *	saved in character addressed by p_argt.
XX   */
XX  
XX! 	p = skipwd (p);
XX! 	p = skipbl (p);
XX! 	*p_argt = *p;
XX! 	if ((*p == '+') || (*p == '-'))
XX! 		++p;
XX! 	return (ctod (p));
XX  }
XX  
XX  
XX- 
XX- 
XX  /*------------------------------*/
XX  /*	set			*/
XX  /*------------------------------*/
XX! set (param, val, type, defval, minval, maxval)
XX! register int   *param;
XX! register int	val;
XX! register char	type;
XX! register int	defval;
XX! register int	minval;
XX! register int	maxval;
XX  {
XX  
XX  /*
XX--- 1,658 ----
XX! /* command.c - command input parser/processor for nroff text processor */
XX  
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX! /*------------------------------*/
XX  /*	comand			*/
XX! /*------------------------------*/
XX! void comand(p)
XX! register char *p;
XX  {
XX+ /* Main command processor */
XX+   register int i;
XX+   register int ct;
XX+   register int val;
XX+   register int indx;
XX+   int spval;
XX+   char argtyp;
XX+   char name[MAXLINE];
XX+   char macexp[MXMLEN];
XX+   int tmp;
XX+   char *pfs;
XX+   char fs[20];
XX  
XX!   /* Get command code */
XX!   ct = comtyp(p, macexp);
XX  
XX!   /* Error? */
XX!   if (ct == UNKNOWN) {
XX! 	fprintf(err_stream, "***%s: unrecognized command %s\n", myname, p);
XX! 	return;
XX!   }
XX  
XX+   /* Ignore comments */
XX+   if (ct == COMMENT) return;
XX  
XX!   /* Do escape expansion on command line args */
XX!   expesc(p, name);
XX  
XX!   /* Get value of command */
XX!   val = getval(p, &argtyp);
XX! 
XX!   /* Do the command */
XX!   switch (ct) {
XX! 	/* Set (&param, val, type, defval, minval, maxval) */
XX!       case FC:
XX! 	/* Field delim/pad chars 
XX! 	 * .fc [delim] [pad] */
XX! 	fprintf(err_stream, "***%s: .fc not available\n", myname);
XX! 	break;
XX! 
XX!       case TR:
XX! 	/* Translate: .tr ab... */
XX! 	fprintf(err_stream, "***%s: .tr not available\n", myname);
XX! 	break;
XX! 
XX!       case AD:
XX! 	/* Adjust:  .ad [mode] */
XX! 	p = skipwd(p);
XX! 	p = skipbl(p);
XX! 
XX! 	switch (*p) {
XX! 	    case 'l':
XX! 		dc.adjval = ADJ_LEFT;
XX! 		dc.juval = YES;
XX! 		break;
XX! 	    case 'r':
XX! 		dc.adjval = ADJ_RIGHT;
XX! 		dc.juval = YES;
XX! 		break;
XX! 	    case 'c':
XX! 		dc.adjval = ADJ_CENTER;
XX! 		dc.juval = YES;
XX! 		break;
XX! 	    case 'b':
XX! 	    case 'n':
XX! 		dc.adjval = ADJ_BOTH;
XX! 		dc.juval = YES;
XX! 		break;
XX! 	    default:	break;
XX  	}
XX+ 	break;
XX  
XX!       case AF:
XX! 	/* Assign format to number reg:  .af R {1,a,A,i,I,0...1} */
XX! 	p = skipwd(p);
XX! 	p = skipbl(p);
XX! 	if (!isalpha(*p)) {
XX! 		fprintf(err_stream,
XX! 		 "***%s: invalid or missing number register name\n", myname);
XX! 	} else {
XX! 		/* Number register format is 1,a,A,i,I,0...1 default
XX! 		 * is 1. for 0001 format, store num dig or'ed with
XX! 		 * 0x80, up to 8 digits. 
XX! 		 */
XX! 		indx = tolower(*p) - 'a';
XX! 		p = skipwd(p);
XX! 		p = skipbl(p);
XX! 		if (*p == '1')
XX! 			dc.nrfmt[indx] = '1';
XX! 		else if (*p == 'a')
XX! 			dc.nrfmt[indx] = 'a';
XX! 		else if (*p == 'A')
XX! 			dc.nrfmt[indx] = 'A';
XX! 		else if (*p == 'i')
XX! 			dc.nrfmt[indx] = 'i';
XX! 		else if (*p == 'I')
XX! 			dc.nrfmt[indx] = 'I';
XX! 		else if (*p == '0') {
XX! 			for (i = 0; isdigit(p[i]); i++);
XX! 			dc.nrfmt[indx] = (char) (i);
XX! 			if (dc.nrfmt[indx] <= 0)
XX! 				dc.nrfmt[indx] = '1';
XX! 			else if (dc.nrfmt[indx] > 8) {
XX! 				dc.nrfmt[indx] = 8;
XX! 				dc.nrfmt[indx] |= 0x80;
XX! 			} else
XX! 				dc.nrfmt[indx] |= 0x80;
XX  
XX+ 		} else
XX+ 			dc.nrfmt[indx] = '1';
XX+ 	}
XX+ 	break;
XX  
XX!       case BD:
XX! 	/* Embolden font (IGNORED):  .bd [S] F N */
XX! 	break;
XX  
XX+       case BO:
XX+ 	/* Bold face: .bo [N] */
XX+ 	set(&dc.boval, val, argtyp, 1, 0, HUGE);
XX+ 	dc.cuval = dc.ulval = 0;
XX+ 	break;
XX  
XX!       case BP:
XX! 	/* Begin page: .bp [+/-N] */
XX! 	if (pg.lineno > 0) space(HUGE);
XX! 	set(&pg.curpag, val, argtyp, pg.curpag + 1, -HUGE, HUGE);
XX! 	pg.newpag = pg.curpag;
XX! 	set_ireg("%", pg.newpag, 0);
XX! 	break;
XX  
XX+       case BR:
XX+ 	/* Break (page):  .br */
XX+ 	robrk();
XX+ 	break;
XX  
XX!       case BS:
XX! 	/* Backspace in output:  .bs [N] */
XX! 	set(&dc.bsflg, val, argtyp, 1, 0, 1);
XX! 	break;
XX  
XX+       case C2:
XX+ 	/* Nobreak char:  .c2 [c='] */
XX+ 	if (argtyp == '\r' || argtyp == '\n')
XX+ 		dc.nobrchr = '\'';
XX+ 	else
XX+ 		dc.nobrchr = argtyp;
XX+ 	break;
XX  
XX+       case CC:
XX+ 	/* Command character:  .cc [c=.] */
XX+ 	if (argtyp == '\r' || argtyp == '\n')
XX+ 		dc.cmdchr = '.';
XX+ 	else
XX+ 		dc.cmdchr = argtyp;
XX+ 	break;
XX  
XX+       case CE:
XX+ 	/* Center:  .ce [N] */
XX+ 	robrk();
XX+ 	set(&dc.ceval, val, argtyp, 1, 0, HUGE);
XX+ 	break;
XX  
XX!       case CS:
XX! 	/* Constant space char (IGNORED):  .cs F N M */
XX! 	break;
XX  
XX!       case CU:
XX! 	/* Continuous underline:  .cu [N] */
XX! 	set(&dc.cuval, val, argtyp, 1, 0, HUGE);
XX! 	dc.ulval = dc.boval = 0;
XX! 	break;
XX  
XX!       case DE: 
XX! 	/* Define macro:  .de name [end] */
XX! 	ignoring = FALSE;
XX! 	defmac(p, sofile[dc.flevel]);
XX! 	break;
XX  
XX!       case DS:
XX! 	/* Define string:  .ds name string */
XX! 	defstr(p);
XX! 	break;
XX  
XX!       case EC:
XX! 	/* Escape char:  .ec [c=\] */
XX! 	if (argtyp == '\r' || argtyp == '\n')
XX! 		dc.escchr = '\\';
XX! 	else
XX! 		dc.escchr = argtyp;
XX! 	dc.escon = YES;
XX! 	break;
XX  
XX!       case EF:
XX! 	/* Even footer: .ef "a" "b" "c" */
XX! 	gettl(p, pg.efoot, &pg.eflim[0]);
XX! 	break;
XX  
XX+       case EH:
XX+ 	/* Even header:  .eh "a" "b" "c" */
XX+ 	gettl(p, pg.ehead, &pg.ehlim[0]);
XX+ 	break;
XX  
XX+       case EN:
XX+ 	/* End macro def (should not get one here...):  .en or .. */
XX+ 	fprintf(err_stream, "***%s: missing .de command\n", myname);
XX+ 	break;
XX  
XX+       case EO:
XX+ 	/* Escape off:  .eo */
XX+ 	dc.escon = NO;
XX+ 	break;
XX  
XX+       case FI:
XX+ 	/* Fill:  .fi */
XX+ 	robrk();
XX+ 	dc.fill = YES;
XX+ 	break;
XX  
XX!       case FL:
XX! 	/* Flush NOW:  .fl */
XX! 	fflush(out_stream);
XX! 	break;
XX  
XX!       case FO:
XX! 	/* Footer: .fo "a" "b" "c" */
XX! 	gettl(p, pg.efoot, &pg.eflim[0]);
XX! 	gettl(p, pg.ofoot, &pg.oflim[0]);
XX! 	break;
XX  
XX!       case FT:
XX! 	/* Font change:  .ft {R,I,B,S,P}
XX! 	 * 
XX! 	 * The way it's implemented here, it causes a break rather than
XX! 	 * be environmental... */
XX! 	p = skipwd(p);
XX! 	p = skipbl(p);
XX! 	if (!isalpha(*p)) {
XX! 		fprintf(err_stream,
XX! 			"***%s: invalid or missing font name\n",
XX! 			myname);
XX! 	} else {
XX! 		pfs = &fs[0];
XX  
XX! 		fontchange(*p, pfs);
XX  
XX! 		robrk();
XX! 		fflush(out_stream);
XX! 		fprintf(out_stream, "%s", pfs);
XX! 		fflush(out_stream);
XX! 	}
XX! 	break;
XX! 
XX!       case TL:
XX!       case HE:
XX! 	/* Header (both are currently identical. .he is -me) 
XX! 	 * .tl "a" "b" "c" .he "a" "b" "c" 
XX  	 */
XX! 	gettl(p, pg.ehead, &pg.ehlim[0]);
XX! 	gettl(p, pg.ohead, &pg.ohlim[0]);
XX! 	break;
XX! 
XX!       case IG:
XX! 	/* Ignore input lines:  .ig name */
XX! 	ignoring = TRUE;
XX! 	defmac(p, sofile[dc.flevel]);
XX! 	break;
XX! 
XX!       case IN:
XX! 	/* Indenting:  .in [+/-N] */
XX! 	set(&dc.inval, val, argtyp, 0, 0, dc.rmval - 1);
XX! 	set_ireg(".i", dc.inval, 0);
XX! 	dc.tival = dc.inval;
XX! 	break;
XX! 
XX!       case JU:
XX! 	/* Justify:  .ju */
XX! 	dc.juval = YES;
XX! 	break;
XX! 
XX!       case LL:
XX! 	/* Line length:  .ll [+/-N] .rm [+/-N] */
XX! 	set(&dc.rmval, val, argtyp, PAGEWIDTH, dc.tival + 1, HUGE);
XX! 	set(&dc.llval, val, argtyp, PAGEWIDTH, dc.tival + 1, HUGE);
XX! 	set_ireg(".l", dc.llval, 0);
XX! 	break;
XX! 
XX!       case LS:
XX! 	/* Line spacing:  .ls [+/-N=+1] */
XX! 	set(&dc.lsval, val, argtyp, 1, 1, HUGE);
XX! 	set_ireg(".v", dc.lsval, 0);
XX! 	break;
XX! 
XX!       case LT:
XX! 	/* Title length:  .lt N */
XX! 	set(&dc.ltval, val, argtyp, PAGEWIDTH, 0, HUGE);
XX! 	pg.ehlim[RIGHT] = dc.ltval;
XX! 	pg.ohlim[RIGHT] = dc.ltval;
XX! 	break;
XX! 
XX!       case M1:
XX! 	/* Topmost margin:  .m1 N */
XX! 	set(&pg.m1val, val, argtyp, 2, 0, HUGE);
XX! 	break;
XX! 
XX!       case M2:
XX! 	/* Second top margin:  .m2 N */
XX! 	set(&pg.m2val, val, argtyp, 2, 0, HUGE);
XX! 	break;
XX! 
XX!       case M3:
XX! 	/* 1st bottom margin:  .m3 N */
XX! 	set(&pg.m3val, val, argtyp, 2, 0, HUGE);
XX! 	pg.bottom = pg.plval - pg.m4val - pg.m3val;
XX! 	break;
XX! 
XX!       case M4:
XX! 	/* Bottom-most margin: .m4 N */
XX! 	set(&pg.m4val, val, argtyp, 2, 0, HUGE);
XX! 	pg.bottom = pg.plval - pg.m4val - pg.m3val;
XX! 	break;
XX! 
XX!       case MACRO:
XX! 	/* Macro expansion:  (internal) */
XX! 	maceval(p, macexp);
XX! 	break;
XX! 
XX!       case NA:
XX! 	/* No adjust:  .na */
XX! 	dc.adjval = ADJ_OFF;
XX! 	dc.juval = NO;
XX! 	break;
XX! 
XX!       case NE:
XX! 	/* Need n lines:  .ne N */
XX! 	robrk();
XX! 	if ((pg.bottom - pg.lineno + 1) < (val * dc.lsval)) {
XX! 		space(HUGE);
XX  	}
XX! 	break;
XX! 
XX!       case NF:
XX! 	/* No fill:  .nf */
XX! 	robrk();
XX! 	dc.fill = NO;
XX! 	break;
XX! 
XX!       case NJ:
XX! 	/* No justify: .nj */
XX! 	dc.juval = NO;
XX! 	break;
XX! 
XX!       case NR:
XX! 	/* Set number reg:  .nr R +/-N M */
XX! 	p = skipwd(p);
XX! 	p = skipbl(p);
XX! 	if (!isalpha(*p)) {
XX! 		fprintf(err_stream,
XX! 		 "***%s: invalid or missing number register name\n",
XX! 			myname);
XX! 	} else {
XX! 		/* Indx is the register, R, and val is the final
XX! 		 * value (default = 0). getval does skipwd,skipbl */
XX! 		indx = tolower(*p) - 'a';
XX! 		val = getval(p, &argtyp);
XX! 		set(&dc.nr[indx], val, argtyp, 0, -INFINITE, INFINITE);
XX  
XX! 		/* Now get autoincrement M, if any (default = 1).
XX! 		 * getval does skipwd,skipbl */
XX! 		p = skipwd(p);
XX! 		p = skipbl(p);
XX! 		val = getval(p, &argtyp);
XX! 		set(&dc.nrauto[indx], val, '1', 1, -INFINITE, INFINITE);
XX! 	}
XX! 	break;
XX  
XX!       case OF:
XX! 	/* Odd footer:  .of "a" "b" "c" */
XX! 	gettl(p, pg.ofoot, &pg.oflim[0]);
XX! 	break;
XX  
XX+       case OH:
XX+ 	/* Odd header:  .oh "a" "b" "c" */
XX+ 	gettl(p, pg.ohead, &pg.ohlim[0]);
XX+ 	break;
XX  
XX+       case PC:
XX+ 	/* Page number char:  .pc [c=NULL] */
XX+ 	if (argtyp == '\r' || argtyp == '\n')
XX+ 		dc.pgchr = EOS;
XX+ 	else
XX+ 		dc.pgchr = argtyp;
XX+ 	break;
XX  
XX+       case PL:
XX+ 	/* Page length: .pl N */
XX+ 	set(&pg.plval,
XX+ 	    val,
XX+ 	    argtyp,
XX+ 	    PAGELEN,
XX+ 	    pg.m1val + pg.m2val + pg.m3val + pg.m4val + 1,
XX+ 	    HUGE);
XX+ 	set_ireg(".p", pg.plval, 0);
XX+ 	pg.bottom = pg.plval - pg.m3val - pg.m4val;
XX+ 	break;
XX  
XX+       case PM:
XX+ 	/* Print macro names and sizes:  .pm [t] */
XX+ 	if (argtyp == '\r' || argtyp == '\n')
XX+ 		printmac(0);
XX+ 	else if (argtyp == 't')
XX+ 		printmac(1);
XX+ 	else if (argtyp == 'T')
XX+ 		printmac(2);
XX+ 	else
XX+ 		printmac(0);
XX+ 	break;
XX  
XX+       case PN:
XX+ 	/* Page number:  .pn N */
XX+ 	tmp = pg.curpag;
XX+ 	set(&pg.curpag, val - 1, argtyp, tmp, -HUGE, HUGE);
XX+ 	pg.newpag = pg.curpag + 1;
XX+ 	set_ireg("%", pg.newpag, 0);
XX+ 	break;
XX+ 
XX+       case PO:
XX+ 	/* Page offset:  .po N */
XX+ 	set(&pg.offset, val, argtyp, 0, 0, HUGE);
XX+ 	set_ireg(".o", pg.offset, 0);
XX+ 	break;
XX+ 
XX+       case PS:
XX+ 	/* Point size (IGNORED):  .ps +/-N */
XX+ 	break;
XX+ 
XX+       case RR:
XX+ 	/* Unset number reg:  .rr R */
XX+ 	p = skipwd(p);
XX+ 	p = skipbl(p);
XX+ 	if (!isalpha(*p)) {
XX+ 		fprintf(err_stream,
XX+ 		 "***%s: invalid or missing number register name\n", myname);
XX+ 	} else {
XX+ 		indx = tolower(*p) - 'a';
XX+ 		val = 0;
XX+ 		set(&dc.nr[indx], val, argtyp, 0, -HUGE, HUGE);
XX+ 	}
XX+ 	break;
XX+ 
XX+       case SO:
XX+ 	/* Source file:  .so name */
XX+ 	p = skipwd(p);
XX+ 	p = skipbl(p);
XX+ 	if (getwrd(p, name) == 0) break;
XX+ 
XX+ 	if (dc.flevel + 1 >= Nfiles) {
XX+ 		fprintf(err_stream,
XX+ 			"***%s: .so commands nested too deeply\n",
XX+ 			myname);
XX+ 		err_exit(-1);
XX+ 	}
XX+ 	if ((sofile[dc.flevel + 1] = fopen(name, "r")) == NULL_FPTR) {
XX+ 		fprintf(err_stream,
XX+ 			"***%s: unable to open %s\n", myname, name);
XX+ 		err_exit(-1);
XX+ 	}
XX+ 	dc.flevel += 1;
XX+ 	break;
XX+ 
XX+       case SP:
XX+ 	/* Space:  .sp [N=1] */
XX+ 	set(&spval, val, argtyp, 1, 0, HUGE);
XX+ 	space(spval);
XX+ 	break;
XX+ 
XX+       case SS:
XX+ 	/* Space char size (IGNORED):  .ss N */
XX+ 	break;
XX+ 
XX+       case TI:
XX+ 	/* Temporary indent:  .ti [+/-N] */
XX+ 	robrk();
XX+ 	set(&dc.tival, val, argtyp, 0, 0, dc.rmval);
XX+ 	break;
XX+ 
XX+       case UL:
XX+ 	/* Underline:  .ul [N] */
XX+ 	set(&dc.ulval, val, argtyp, 0, 1, HUGE);
XX+ 	dc.cuval = dc.boval = 0;
XX+ 	break;
XX+ 
XX+   }
XX+ }
XX+ 
XX+ 
XX  /*------------------------------*/
XX! /*	comtyp			*/
XX  /*------------------------------*/
XX! int comtyp(p, m)
XX! register char *p;
XX! char *m;
XX  {
XX  
XX! /* Decodes nro command and returns its associated value.
XX!  * ptr "p" is incremented (and returned)
XX   */
XX  
XX!   register char c1;
XX!   register char c2;
XX!   char *s;
XX!   char macnam[MNLEN];
XX  
XX!   /* Skip past dot and any whitespace */
XX!   p++;
XX!   while (*p && (*p == ' ' || *p == '\t')) p++;
XX!   if (*p == '\0') return (COMMENT);
XX! 
XX!   /* First check to see if the command is a macro. If it is, truncate
XX!    * to two characters and return expansion in m.  Note that upper and
XX!    * lower case characters are handled differently. 
XX!    */
XX!   getwrd(p, macnam);
XX!   macnam[2] = EOS;
XX!   if ((s = getmac(macnam)) != NULL_CPTR) {
XX! 	strcpy(m, s);
XX! 	return(MACRO);
XX!   }
XX!   c1 = *p++;
XX!   c2 = *p;
XX!   if (c1 == '\\' && c2 == '\"') return(COMMENT);
XX!   if (c1 == 'a' && c2 == 'f') return (AF);
XX!   if (c1 == 'a' && c2 == 'd') return (AD);
XX!   if (c1 == 'b' && c2 == 'o') return (BO);
XX!   if (c1 == 'b' && c2 == 'p') return (BP);
XX!   if (c1 == 'b' && c2 == 'r') return (BR);
XX!   if (c1 == 'b' && c2 == 's') return (BS);
XX!   if (c1 == 'c' && c2 == 'c') return (CC);
XX!   if (c1 == 'c' && c2 == 'e') return (CE);
XX!   if (c1 == 'c' && c2 == 'u') return (CU);
XX!   if (c1 == 'd' && c2 == 'e') return (DE);
XX!   if (c1 == 'd' && c2 == 's') return (DS);
XX!   if (c1 == 'e' && c2 == 'f') return (EF);
XX!   if (c1 == 'e' && c2 == 'c') return (EC);
XX!   if (c1 == 'e' && c2 == 'h') return (EH);
XX!   if (c1 == 'e' && c2 == 'n') return (EN);
XX!   if (c1 == '.') return (EN);
XX!   if (c1 == 'e' && c2 == 'o') return (EO);
XX!   if (c1 == 'f' && c2 == 'i') return (FI);
XX!   if (c1 == 'f' && c2 == 'l') return (FL);
XX!   if (c1 == 'f' && c2 == 'o') return (FO);
XX!   if (c1 == 'f' && c2 == 't') return (FT);
XX!   if (c1 == 'h' && c2 == 'e') return (HE);
XX!   if (c1 == 'i' && c2 == 'n') return (IN);
XX!   if (c1 == 'j' && c2 == 'u') return (JU);
XX!   if (c1 == 'l' && c2 == 'l') return (LL);
XX!   if (c1 == 'l' && c2 == 's') return (LS);
XX!   if (c1 == 'm' && c2 == '1') return (M1);
XX!   if (c1 == 'm' && c2 == '2') return (M2);
XX!   if (c1 == 'm' && c2 == '3') return (M3);
XX!   if (c1 == 'm' && c2 == '4') return (M4);
XX!   if (c1 == 'n' && c2 == 'a') return (NA);
XX!   if (c1 == 'n' && c2 == 'e') return (NE);
XX!   if (c1 == 'n' && c2 == 'f') return (NF);
XX!   if (c1 == 'n' && c2 == 'j') return (NJ);
XX!   if (c1 == 'n' && c2 == 'r') return (NR);
XX!   if (c1 == 'o' && c2 == 'f') return (OF);
XX!   if (c1 == 'o' && c2 == 'h') return (OH);
XX!   if (c1 == 'p' && c2 == 'c') return (PC);
XX!   if (c1 == 'p' && c2 == 'l') return (PL);
XX!   if (c1 == 'p' && c2 == 'm') return (PM);
XX!   if (c1 == 'p' && c2 == 'o') return (PO);
XX!   if (c1 == 'r' && c2 == 'm') return (RM);
XX!   if (c1 == 'r' && c2 == 'r') return (RR);
XX!   if (c1 == 's' && c2 == 'o') return (SO);
XX!   if (c1 == 's' && c2 == 'p') return (SP);
XX!   if (c1 == 't' && c2 == 'i') return (TI);
XX!   if (c1 == 't' && c2 == 'l') return (TL);
XX!   if (c1 == 'u' && c2 == 'l') return (UL);
XX! 
XX!   if (c1 == 'p' && c2 == 'n') return(PN);
XX!   if (c1 == 'r' && c2 == 'r') return (RR);
XX!   if (c1 == 'c' && c2 == '2') return (C2);
XX!   if (c1 == 't' && c2 == 'r') return (TR);
XX!   if (c1 == 'l' && c2 == 't') return (LT);
XX!   if (c1 == 'f' && c2 == 'c') return (FC);
XX! 
XX!   return(UNKNOWN);
XX  }
XX  
XX  
XX+ /*------------------------------*/
XX+ /*	gettl			*/
XX+ /*------------------------------*/
XX+ void gettl(p, q, limit)
XX+ register char *p;
XX+ register char *q;
XX+ int *limit;
XX+ {
XX  
XX+ /* Get header or footer title  */
XX  
XX+   /* Skip forward a word... */
XX+   p = skipwd(p);
XX+   p = skipbl(p);
XX  
XX+   /* Copy and set limits */
XX+   strcpy(q, p);
XX+   limit[LEFT] = dc.inval;
XX+   limit[RIGHT] = dc.rmval;
XX+ }
XX+ 
XX+ 
XX  /*------------------------------*/
XX  /*	getval			*/
XX  /*------------------------------*/
XX! int getval(p, p_argt)
XX! register char *p;
XX! register char *p_argt;
XX  {
XX  
XX! /* Retrieves optional argument following command.
XX!  * Returns positive integer value with sign (if any)
XX!  * saved in character addressed by p_argt.
XX   */
XX  
XX!   p = skipwd(p);
XX!   p = skipbl(p);
XX!   *p_argt = *p;
XX!   if ((*p == '+') || (*p == '-')) ++p;
XX!   return(ctod(p));
XX  }
XX  
XX  
XX  /*------------------------------*/
XX  /*	set			*/
XX  /*------------------------------*/
XX! void set(param, val, type, defval, minval, maxval)
XX! register int *param;
XX! register int val;
XX! register char type;
XX! register int defval;
XX! register int minval;
XX! register int maxval;
XX  {
XX  
XX  /*
XX***************
XX*** 947,1003 ****
XX   *	.nr a		reset register 'a' to default value (0)
XX   */
XX  
XX! 	switch (type)
XX! 	{
XX! 	case '\r': 
XX! 	case '\n': 
XX! 		*param = defval;
XX! 		break;
XX! 	case '+': 
XX! 		*param += val;
XX! 		break;
XX! 	case '-': 
XX! 		*param -= val;
XX! 		break;
XX! 	default: 
XX! 		*param = val;
XX! 		break;
XX! 	}
XX! 	*param = min (*param, maxval);
XX! 	*param = max (*param, minval);
XX  }
XX  
XX- 
XX- 
XX- 
XX- 
XX  /*------------------------------*/
XX  /*	set_ireg		*/
XX  /*------------------------------*/
XX! set_ireg (name, val, opt)
XX! register char  *name;
XX! register int	val;
XX! register int	opt;				/* 0=internal, 1=user set */
XX  {
XX  
XX! /*
XX!  *	set internal register "name" to val. ret 0 if ok, else -1 if reg not
XX!  *	found or 1 if read only
XX   */
XX  
XX! 	register int	nreg;
XX  
XX! 	nreg = findreg (name);
XX! 	if (nreg < 0)
XX! 		return (-1);
XX  
XX! 	if ((rg[nreg].rflag & RF_WRITE) || (opt == 0))
XX! 	{
XX! 		rg[nreg].rval = val;
XX  
XX! 		return (0);
XX! 	}
XX! 
XX! 	return (1);
XX  }
XX- 
XX--- 671,710 ----
XX   *	.nr a		reset register 'a' to default value (0)
XX   */
XX  
XX!   switch (type) {
XX!       case '\r':
XX!       case '\n':	*param = defval;	break;
XX!       case '+':	*param += val;			break;
XX!       case '-':	*param -= val;			break;
XX!       default:	*param = val;			break;
XX! 
XX!   }
XX!   *param = min(*param, maxval);
XX!   *param = max(*param, minval);
XX  }
XX  
XX  /*------------------------------*/
XX  /*	set_ireg		*/
XX  /*------------------------------*/
XX! int set_ireg(name, val, opt)
XX! register char *name;
XX! register int val;
XX! register int opt;		/* 0=internal, 1=user set */
XX  {
XX  
XX! /* Set internal register "name" to val. ret 0 if ok, else -1 if reg not
XX!  * found or 1 if read only
XX   */
XX  
XX!   register int nreg;
XX  
XX!   nreg = findreg(name);
XX!   if (nreg < 0) return(-1);
XX  
XX!   if ((rg[nreg].rflag & RF_WRITE) || (opt == 0)) {
XX! 	rg[nreg].rval = val;
XX  
XX! 	return(0);
XX!   }
XX!   return(1);
XX  }
X/
Xecho x - config.h.d
Xsed '/^X/s///' > config.h.d << '/'
XX*** /home/top/ast/minix/1.5/commands/nroff/config.h  crc=07019   1517	Sat Apr 21 22:27:21 1990
XX--- /home/top/ast/minix/1.6.25/commands/nroff/config.h  crc=49301   1517	Mon Nov 23 12:19:52 1992
XX***************
XX*** 1,5 ****
XX! /* nroff/config.h
XX!  * Adapted for compatibility with Minix 1.5.5 nroff/Makefile
XX   * by Wim 'Blue Baron' van Dorst (wsincc@tuerc3.urc.tue.nl)
XX   */
XX  #ifndef CONFIG_H
XX--- 1,4 ----
XX! /* nroff/config.h Adapted for compatibility with Minix 1.5.5 nroff/Makefile
XX   * by Wim 'Blue Baron' van Dorst (wsincc@tuerc3.urc.tue.nl)
XX   */
XX  #ifndef CONFIG_H
XX***************
XX*** 43,49 ****
XX  
XX  #ifdef alcyon
XX  # ifndef ALCYON
XX! #  define ALCYON			/* for gemdos version, alcyon C */
XX  # endif
XX  # ifndef GEMDOS
XX  #  define GEMDOS
XX--- 42,48 ----
XX  
XX  #ifdef alcyon
XX  # ifndef ALCYON
XX! #  define ALCYON		/* for gemdos version, alcyon C */
XX  # endif
XX  # ifndef GEMDOS
XX  #  define GEMDOS
XX***************
XX*** 71,75 ****
XX  # endif
XX  #endif
XX  
XX! #endif /*CONFIG_H*/
XX! 
XX--- 70,73 ----
XX  # endif
XX  #endif
XX  
XX! #endif				/* CONFIG_H */
X/
Xecho x - escape.c.d
Xsed '/^X/s///' > escape.c.d << '/'
XX*** /home/top/ast/minix/1.5/commands/nroff/escape.c  crc=61976  17208	Sat Apr 21 22:27:21 1990
XX--- /home/top/ast/minix/1.6.25/commands/nroff/escape.c  crc=16721  14969	Mon Nov 23 12:19:52 1992
XX***************
XX*** 1,957 ****
XX! /*
XX!  *	escape.c - Escape and special character input processing portion of
XX!  *	           nroff word processor
XX!  *
XX!  *	adapted for atariST/TOS by Bill Rosenkranz 11/89
XX!  *	net:	rosenkra@hall.cray.com
XX!  *	CIS:	71460,17
XX!  *	GENIE:	W.ROSENKRANZ
XX!  *
XX!  *	original author:
XX!  *
XX!  *	Stephen L. Browning
XX!  *	5723 North Parker Avenue
XX!  *	Indianapolis, Indiana 46220
XX!  *
XX!  *	history:
XX!  *
XX!  *	- Originally written in BDS C;
XX!  *	- Adapted for standard C by W. N. Paul
XX!  *	- Heavily hacked up to conform to "real" nroff by Bill Rosenkranz
XX!  */
XX  
XX- #undef NRO_MAIN					/* extern globals */
XX- 
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX- 
XX  /*------------------------------*/
XX  /*	expesc			*/
XX  /*------------------------------*/
XX! expesc (p, q)
XX! char   *p;
XX! char   *q;
XX  {
XX  
XX! /*
XX!  *	Expand escape sequences
XX!  */
XX  
XX! 	register char  *s;
XX! 	register char  *t;
XX! 	register char  *pstr;
XX! 	register int	i;
XX! 	register int	val;
XX! 	register int	autoinc;
XX! 	char		c;
XX! 	char		fs[5];				/* for font change */
XX! 	char		nrstr[20];
XX! 	char		fmt[20];
XX! 	char		name[10];
XX! 	int		nreg;
XX! 	char	       *pfs;
XX! 	int		inc;
XX! 	int		tmp;
XX! 	char		delim;
XX  
XX  
XX! 	s = p;
XX! 	t = q;
XX! 
XX! 
XX! 	/*
XX! 	 *   if escape parsing is not on, just copy string
XX! 	 */
XX! 	if (dc.escon == NO)
XX! 	{
XX! 		while (*s != EOS)
XX! 		{
XX! 			*t++ = *s++;
XX  		}
XX! 		*t = EOS;
XX! 		strcpy (p, q);
XX! 
XX! 		return;
XX! 	}
XX! 
XX! 
XX! 	/*
XX! 	 *   do it...
XX! 	 */
XX! 	while (*s != EOS)
XX! 	{
XX! 		if (*s != dc.escchr)
XX! 		{
XX! 			/*
XX! 			 *   not esc, continue...
XX! 			 */
XX! 			*t++ = *s++;
XX  		}
XX  
XX  
XX! 		else if (*(s + 1) == dc.escchr)
XX! 		{
XX! 			/*
XX! 			 *   \\			escape escape
XX! 			 */
XX! 			*t++ = *s++;
XX! 			++s;
XX! 		}
XX  
XX  
XX! 		else if (*(s + 1) == 'n')
XX! 		{
XX! 			/*
XX! 			 *   \nx, \n(xx		register
XX! 			 *
XX! 			 *   first check for \n+... or \n-... (either form)
XX! 			 */
XX! 			s += 2;
XX! 			autoinc = 0;
XX! 			if (*s == '+')
XX! 			{
XX! 				autoinc = 1;
XX! 				s += 1;
XX  			}
XX! 			if (*s == '-')
XX! 			{
XX! 				autoinc = -1;
XX! 				s += 1;
XX  			}
XX  
XX  
XX  
XX! 			/*
XX! 			 *   was this \nx or \n(xx form?
XX! 			 */
XX! 			if (isalpha (*s))
XX! 			{
XX! 				/*
XX! 				 *   \nx form. find reg (a-z)
XX! 				 */
XX! 				nreg = tolower (*s) - 'a';
XX! 
XX! 
XX! 				/*
XX! 				 *   was this \n+x or \n-x? if so, do the
XX! 				 *   auto incr
XX! 				 */
XX! 				if (autoinc > 0)
XX! 					dc.nr[nreg] += dc.nrauto[nreg];
XX! 				else if (autoinc < 0)
XX! 					dc.nr[nreg] -= dc.nrauto[nreg];
XX! 
XX! 				/*
XX! 				 *   display format
XX! 				 */
XX! 				if (dc.nrfmt[nreg] == '1')
XX! 				{
XX! 					/*
XX! 					 *   normal decimal digits
XX! 					 */
XX! 					t += itoda (dc.nr[nreg], t, 6) - 1;
XX! 				}
XX! 				else if (dc.nrfmt[nreg] == 'i')
XX! 				{
XX! 					/*
XX! 					 *   lower roman
XX! 					 */
XX! 					t += itoroman (dc.nr[nreg], t, 24) - 1;
XX! 				}
XX! 				else if (dc.nrfmt[nreg] == 'I')
XX! 				{
XX! 					/*
XX! 					 *   upper roman
XX! 					 */
XX! 					t += itoROMAN (dc.nr[nreg], t, 24) - 1;
XX! 				}
XX! 				else if (dc.nrfmt[nreg] == 'a')
XX! 				{
XX! 					/*
XX! 					 *   lower letters
XX! 					 */
XX! 					t += itoletter (dc.nr[nreg], t, 12) - 1;
XX! 				}
XX! 				else if (dc.nrfmt[nreg] == 'A')
XX! 				{
XX! 					/*
XX! 					 *   upper letters
XX! 					 */
XX! 					t += itoLETTER (dc.nr[nreg], t, 12) - 1;
XX! 				}
XX! 				else if (dc.nrfmt[nreg] & 0x80)
XX! 				{
XX! 					/*
XX! 					 *   zero-filled decimal
XX! 					 */
XX! 					sprintf (fmt, "%%0%dld",
XX! 						(int)(dc.nrfmt[nreg] & 0x7F));
XX! 					fmt[5] = '\0';
XX! 					sprintf (nrstr, fmt, (long) dc.nr[nreg]);
XX! 					tmp = dc.nrfmt[nreg] & 0x7F;
XX! 					nrstr[tmp] = '\0';
XX! 
XX! 					strcpy (t, nrstr);
XX! 					t += strlen (nrstr);
XX! 				}
XX! 				else
XX! 				{
XX! 					/*
XX! 					 *   normal (default)
XX! 					 */
XX! 					t += itoda (dc.nr[nreg], t, 6) - 1;
XX! 				}
XX! 				++s;
XX  			}
XX! 			else if (*s == '%')
XX! 			{
XX! 				/*
XX! 				 *   \n% form. find index into reg struct
XX! 				 */
XX! 				nreg = findreg ("%");
XX! 				if (nreg < 0)
XX! 				{
XX! 					fprintf (err_stream,
XX! 						"***%s: no register match\n",
XX! 						myname);
XX! 					err_exit (-1);
XX! 				}
XX  
XX! 
XX! 				/*
XX! 				 *   was this \n+% or \n-%? if so, do the
XX! 				 *   auto incr
XX! 				 */
XX  				if (autoinc > 0)
XX  					rg[nreg].rval += rg[nreg].rauto;
XX  				else if (autoinc < 0)
XX  					rg[nreg].rval -= rg[nreg].rauto;
XX- 
XX- 
XX- 				/*
XX- 				 *   display format
XX- 				 */
XX- 				if (rg[nreg].rfmt == '1')
XX- 				{
XX- 					/*
XX- 					 *   normal decimal digits
XX- 					 */
XX- 					t += itoda (rg[nreg].rval, t, 6) - 1;
XX- 				}
XX- 				else if (rg[nreg].rfmt == 'i')
XX- 				{
XX- 					/*
XX- 					 *   lower roman
XX- 					 */
XX- 					t += itoroman (rg[nreg].rval, t, 24) - 1;
XX- 				}
XX- 				else if (rg[nreg].rfmt == 'I')
XX- 				{
XX- 					/*
XX- 					 *   upper roman
XX- 					 */
XX- 					t += itoROMAN (rg[nreg].rval, t, 24) - 1;
XX- 				}
XX- 				else if (rg[nreg].rfmt == 'a')
XX- 				{
XX- 					/*
XX- 					 *   lower letters
XX- 					 */
XX- 					t += itoletter (rg[nreg].rval, t, 12) - 1;
XX- 				}
XX- 				else if (rg[nreg].rfmt == 'A')
XX- 				{
XX- 					/*
XX- 					 *   upper letters
XX- 					 */
XX- 					t += itoLETTER (rg[nreg].rval, t, 12) - 1;
XX- 				}
XX- 				else if (rg[nreg].rfmt & 0x80)
XX- 				{
XX- 					/*
XX- 					 *   zero-filled decimal
XX- 					 */
XX- 					sprintf (fmt, "%%0%dld",
XX- 						(int)(rg[nreg].rfmt & 0x7F));
XX- 					fmt[5] = '\0';
XX- 					sprintf (nrstr, fmt, (long) rg[nreg].rval);
XX- 					tmp = rg[nreg].rfmt & 0x7F;
XX- 					nrstr[tmp] = '\0';
XX- 
XX- 					strcpy (t, nrstr);
XX- 					t += strlen (nrstr);
XX- 				}
XX- 				else
XX- 				{
XX- 					/*
XX- 					 *   normal (default)
XX- 					 */
XX- 					t += itoda (rg[nreg].rval, t, 6) - 1;
XX- 				}
XX- 				s += 1;
XX  			}
XX- 			else if (*s == '(')
XX- 			{
XX- 				/*
XX- 				 *   \n(xx form. find index into reg struct
XX- 				 */
XX- 				s += 1;
XX- 				name[0] = *s;
XX- 				name[1] = *(s + 1);
XX- 				if (name[1] == ' '  || name[1] == '\t'
XX- 				||  name[1] == '\n' || name[1] == '\r')
XX- 					name[1] = '\0';
XX- 				name[2] = '\0';
XX- 				nreg = findreg (name);
XX- 				if (nreg < 0)
XX- 				{
XX- 					fprintf (err_stream,
XX- 						"***%s: no register match\n",
XX- 						myname);
XX- 					err_exit (-1);
XX- 				}
XX- 				
XX  
XX! 				/*
XX! 				 *   was this \n+(xx or \n-(xx? if so, do the
XX! 				 *   auto incr
XX! 				 */
XX! 				if (rg[nreg].rflag & RF_WRITE)
XX! 				{
XX! 					if (autoinc > 0)
XX! 						rg[nreg].rval += rg[nreg].rauto;
XX! 					else if (autoinc < 0)
XX! 						rg[nreg].rval -= rg[nreg].rauto;
XX! 				}
XX  
XX! 
XX! 				/*
XX! 				 *   display format
XX! 				 */
XX! 				if (rg[nreg].rfmt == '1')
XX! 				{
XX! 					/*
XX! 					 *   normal decimal digits
XX! 					 */
XX! 					t += itoda (rg[nreg].rval, t, 6) - 1;
XX! 				}
XX! 				else if (rg[nreg].rfmt == 'i')
XX! 				{
XX! 					/*
XX! 					 *   lower roman
XX! 					 */
XX! 					t += itoroman (rg[nreg].rval, t, 24) - 1;
XX! 				}
XX! 				else if (rg[nreg].rfmt == 'I')
XX! 				{
XX! 					/*
XX! 					 *   upper roman
XX! 					 */
XX! 					t += itoROMAN (rg[nreg].rval, t, 24) - 1;
XX! 				}
XX! 				else if (rg[nreg].rfmt == 'a')
XX! 				{
XX! 					/*
XX! 					 *   lower letters
XX! 					 */
XX! 					t += itoletter (rg[nreg].rval, t, 12) - 1;
XX! 				}
XX! 				else if (rg[nreg].rfmt == 'A')
XX! 				{
XX! 					/*
XX! 					 *   upper letters
XX! 					 */
XX! 					t += itoLETTER (rg[nreg].rval, t, 12) - 1;
XX! 				}
XX! 				else if (rg[nreg].rfmt & 0x80)
XX! 				{
XX! 					/*
XX! 					 *   zero-filled decimal
XX! 					 */
XX! 					sprintf (fmt, "%%0%dld",
XX! 						(int)(rg[nreg].rfmt & 0x7F));
XX! 					fmt[5] = '\0';
XX! 					sprintf (nrstr, fmt, (long) rg[nreg].rval);
XX! 					tmp = rg[nreg].rfmt & 0x7F;
XX! 					nrstr[tmp] = '\0';
XX! 
XX! 					strcpy (t, nrstr);
XX! 					t += strlen (nrstr);
XX! 				}
XX! 				else
XX! 				{
XX! 					/*
XX! 					 *   normal (default)
XX! 					 */
XX! 					t += itoda (rg[nreg].rval, t, 6) - 1;
XX! 				}
XX! 				s += 2;
XX  			}
XX- 		}
XX- 
XX- 
XX- 		else if (*(s + 1) == '\"')
XX- 		{
XX- 			/*
XX- 			 *   \"			comment
XX- 			 */
XX- 			*s = EOS;
XX- 			*t = *s;
XX- 
XX- 			return;
XX- 		}
XX- 
XX- 
XX- 		else if (*(s + 1) == '*')
XX- 		{
XX- 			/*
XX- 			 *   \*x, \*(xx		string
XX- 			 */
XX  			s += 2;
XX- 			if (*s == '(')
XX- 			{
XX- 				/*
XX- 				 *   \*(xx form
XX- 				 */
XX- 				s += 1;
XX- 				name[0] = *s;
XX- 				name[1] = *(s + 1);
XX- 				name[2] = '\0';
XX- 				pstr = getstr (name);
XX- 				if (!pstr)
XX- 				{
XX- 					fprintf (err_stream,
XX- 						"***%s: string not found\n",
XX- 						myname);
XX- 					err_exit (-1);
XX- 				}
XX- 				while (*pstr)
XX- 					*t++ = *pstr++;
XX- 				s += 2;
XX- 			}
XX- 			else
XX- 			{
XX- 				/*
XX- 				 *   \*x form
XX- 				 */
XX- 				name[0] = *s;
XX- 				name[1] = '\0';
XX- 				pstr = getstr (name);
XX- 				if (!pstr)
XX- 				{
XX- 					fprintf (err_stream,
XX- 						"***%s: string not found\n",
XX- 						myname);
XX- 					err_exit (-1);
XX- 				}
XX- 				while (*pstr)
XX- 					*t++ = *pstr++;
XX- 				s += 1;
XX- 			}
XX  		}
XX  
XX! 
XX! 		else if (*(s + 1) == 'f')
XX! 		{
XX! 			/*
XX! 			 *   \fx		font
XX! 			 */
XX  			s += 2;
XX! 			pfs = fs;		/* set up ret string */
XX! 			fs[0] = '\0';
XX! 
XX! 			/*
XX! 			 *  it parses 1-2 char of s and returns esc seq for
XX! 			 *  \fB and \fR (\fI is same as \fB)
XX! 			 */
XX! 			fontchange (*s, pfs);
XX! 
XX! 			/*
XX! 			 *   imbed the atari (vt52) escape seq
XX! 			 */
XX! 			while (*pfs)
XX! 				*t++ = *pfs++;
XX! 			++s;			/* skip B,I,R,S,P */
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '(')
XX! 		{
XX! 			/*
XX! 			 *   \(xx		special char
XX! 			 */
XX! 			s  += 2;
XX! 
XX! 			/*
XX! 			 *   it returns num char to skip and sets c to
XX! 			 *   the ascii value of the char
XX! 			 */
XX! 			inc = specialchar (s, &c);
XX! 
XX! 			/*
XX! 			 *   skip proper num char in s and add c to target
XX! 			 */
XX! 			if (inc)
XX! 			{
XX! 				s   += inc;
XX! 				*t++ = c;
XX  			}
XX  		}
XX  
XX  
XX! 		else if (*(s + 1) == 'e')
XX! 		{
XX! 			/*
XX! 			 *   \e		printable version of escape
XX! 			 */
XX! 			*t++ = dc.escchr;
XX! 			s   += 2;
XX! 		}
XX  
XX  
XX! 		else if (*(s + 1) == '`')
XX! 		{
XX! 			/*
XX! 			 *   \`		grave, like \(ga
XX! 			 */
XX! 			*t++ = 0x60;
XX! 			s  += 2;
XX  		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '\'')
XX! 		{
XX! 			/*
XX! 			 *   \'		accute, like \(aa
XX! 			 */
XX! 			s  += 2;
XX! 			*t++ = 0xBA;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '-')
XX! 		{
XX! 			/*
XX! 			 *   \-		minus
XX! 			 */
XX! 			s  += 2;
XX! 			*t++ = 0x2D;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '.')
XX! 		{
XX! 			/*
XX! 			 *   \.		period
XX! 			 */
XX! 			s  += 2;
XX! 			*t++ = 0x2E;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == ' ')
XX! 		{
XX! 			/*
XX! 			 *   \(space)	space
XX! 			 */
XX! 			s  += 2;
XX! 			*t++ = 0x20;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '0')
XX! 		{
XX! 			/*
XX! 			 *   \0		digital width space
XX! 			 */
XX! 			s  += 2;
XX! 			*t++ = 0x20;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '|')
XX! 		{
XX! 			/*
XX! 			 *   \|		narrow width char (0 in nroff)
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '^')
XX! 		{
XX! 			/*
XX! 			 *   \^		narrow width char (0 in nroff)
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '&')
XX! 		{
XX! 			/*
XX! 			 *   \&		non-printing zero width
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '!')
XX! 		{
XX! 			/*
XX! 			 *   \!		transparent copy line
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '$')
XX! 		{
XX! 			/*
XX! 			 *   \$N	interpolate arg 1<=N<=9
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '%')
XX! 		{
XX! 			/*
XX! 			 *   \%		hyphen
XX! 			 */
XX! 			s  += 2;
XX! 			*t++ = 0x2D;
XX! 			*t++ = 0x2D;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'a')
XX! 		{
XX! 			/*
XX! 			 *   \a
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'b')
XX! 		{
XX! 			/*
XX! 			 *   \b'abc...'
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'c')
XX! 		{
XX! 			/*
XX! 			 *   \c
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'd')
XX! 		{
XX! 			/*
XX! 			 *   \d
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'h')
XX! 		{
XX! 			/*
XX! 			 *   \h'N'	horiz motion
XX! 			 */
XX! 			s    += 2;
XX! 			delim = *s++;
XX! 			val   = atoi (s);
XX! 			for (i = 0; i < val; i++)
XX! 				*t++ = ' ';
XX! 			while (*s != delim)
XX! 			{
XX! 				if (*s == 0)
XX! 					break;
XX! 				s++;
XX! 			}
XX! 			if (*s)
XX! 				s++;
XX! 			
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'k')
XX! 		{
XX! 			/*
XX! 			 *   \kx
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'l')
XX! 		{
XX! 			/*
XX! 			 *   \l'Nc'
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'L')
XX! 		{
XX! 			/*
XX! 			 *   \L'Nc'
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'o')
XX! 		{
XX! 			/*
XX! 			 *   \o'abc...'		overstrike
XX! 			 */
XX! 			s  += 2;
XX! 			delim = *s++;
XX! 			while (*s != EOS && *s != delim)
XX! 			{
XX! 				*t++ = *s++;
XX! 				*t++ = 0x08;
XX! 			}
XX  			s++;
XX  		}
XX  
XX! 
XX! 		else if (*(s + 1) == 'p')
XX! 		{
XX! 			/*
XX! 			 *   \p
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'r')
XX! 		{
XX! 			/*
XX! 			 *   \r
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 's')
XX! 		{
XX! 			/*
XX! 			 *   \sN,\s+-N
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 't')
XX! 		{
XX! 			/*
XX! 			 *   \t		horizontal tab
XX! 			 */
XX! 			s  += 2;
XX! 			*t++ = 0x09;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'u')
XX! 		{
XX! 			/*
XX! 			 *   \u
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'v')
XX! 		{
XX! 			/*
XX! 			 *   \v'N'	vert tab
XX! 			 */
XX! 			s    += 2;
XX! 			delim = *s++;
XX! 			val   = atoi (s);
XX! 			for (i = 0; i < val; i++)
XX! 				*t++ = 0x0A;
XX! 			while (*s != delim)
XX! 			{
XX! 				if (*s == 0)
XX! 					break;
XX! 				s++;
XX! 			}
XX! 			if (*s)
XX! 				s++;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'w')
XX! 		{
XX! 			/*
XX! 			 *   \w'str'
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'x')
XX! 		{
XX! 			/*
XX! 			 *   \x'N'
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == 'z')
XX! 		{
XX! 			/*
XX! 			 *   \zc	print c w/o spacing
XX! 			 */
XX! 			s  += 2;
XX  			*t++ = *s++;
XX  			*t++ = 0x08;
XX  		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '{')
XX! 		{
XX! 			/*
XX! 			 *   \{
XX! 			 */
XX! 			s  += 2;
XX  		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '}')
XX! 		{
XX! 			/*
XX! 			 *   \}
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else if (*(s + 1) == '\n' || *(s + 1) == '\r')
XX! 		{
XX! 			/*
XX! 			 *   \(newline)	ignore newline
XX! 			 */
XX! 			s  += 2;
XX! 		}
XX! 
XX! 
XX! 		else
XX! 		{
XX! 			/*
XX! 			 *   \X		any other character not above
XX! 			 */
XX! 			s   += 1;
XX! 			*t++ = *s++;
XX! 		}
XX! 
XX  	}
XX  
XX! 	/*
XX! 	 *   end the string and return it in original buf
XX! 	 */
XX! 	*t = EOS;
XX! 	strcpy (p, q);
XX  }
XX  
XX- 
XX- 
XX- 
XX  /*------------------------------*/
XX  /*	specialchar		*/
XX  /*------------------------------*/
XX! specialchar (s, c)
XX! register char  *s;
XX! register char  *c;
XX  {
XX  
XX  /*
XX   *	handles \(xx escape sequences for special characters (atari-specific)
XX   */
XX  
XX! 	register char	c1;
XX! 	register char	c2;
XX  
XX! 	c1 = *s;
XX! 	c2 = *(s+1);
XX  
XX! 	/*
XX! 	 *   symbols
XX! 	 */
XX! 	if (c1 == 'c' && c2 == 'o') {*c = 0xBD; return (2);}	/* copyrite */
XX! 	if (c1 == 'r' && c2 == 'g') {*c = 0xBE; return (2);}	/* registered */
XX! 	if (c1 == 't' && c2 == 'm') {*c = 0xBF; return (2);}	/* trademark */
XX! 	if (c1 == '1' && c2 == '2') {*c = 0xAB; return (2);}	/* 1/2 */
XX! 	if (c1 == '1' && c2 == '4') {*c = 0xAC; return (2);}	/* 1/4 */
XX! 	if (c1 == 'p' && c2 == '2') {*c = 0xFD; return (2);}	/* ^2 */
XX! 	if (c1 == 'p' && c2 == '3') {*c = 0xFE; return (2);}	/* ^3 */
XX! 	if (c1 == 'p' && c2 == 'n') {*c = 0xFC; return (2);}	/* ^n */
XX! 	if (c1 == 'a' && c2 == 'a') {*c = 0xBA; return (2);}	/* acute */
XX! 	if (c1 == 'g' && c2 == 'a') {*c = 0x60; return (2);}	/* grave */
XX! 	if (c1 == 'd' && c2 == 'e') {*c = 0xF8; return (2);}	/* degree */
XX! 	if (c1 == 'd' && c2 == 'g') {*c = 0xBB; return (2);}	/* dagger */
XX! 	if (c1 == 'c' && c2 == 't') {*c = 0x9B; return (2);}	/* cent */
XX! 	if (c1 == 'b' && c2 == 'u') {*c = 0xF9; return (2);}	/* bullet */
XX! 	if (c1 == 'd' && c2 == 't') {*c = 0xFA; return (2);}	/* dot */
XX! 	if (c1 == 'p' && c2 == 'p') {*c = 0xBC; return (2);}	/* paragraph */
XX! 	if (c1 == '^' && c2 == 'g') {*c = 0x07; return (2);}	/* ring bell */
XX! 	if (c1 == 'u' && c2 == 'a') {*c = 0x01; return (2);}	/* up arrow */
XX! 	if (c1 == 'd' && c2 == 'a') {*c = 0x02; return (2);}	/* dn arrow */
XX! 	if (c1 == '-' && c2 == '>') {*c = 0x03; return (2);}	/* rt arrow */
XX! 	if (c1 == '<' && c2 == '-') {*c = 0x04; return (2);}	/* lf arrow */
XX! 	if (c1 == 'd' && c2 == 'i') {*c = 0xF6; return (2);}	/* divide */
XX! 	if (c1 == 's' && c2 == 'r') {*c = 0xFB; return (2);}	/* sq root */
XX! 	if (c1 == '=' && c2 == '=') {*c = 0xF0; return (2);}	/* == */
XX! 	if (c1 == '>' && c2 == '=') {*c = 0xF2; return (2);}	/* >= */
XX! 	if (c1 == '<' && c2 == '=') {*c = 0xF3; return (2);}	/* <= */
XX! 	if (c1 == '+' && c2 == '-') {*c = 0xF1; return (2);}	/* +- */
XX! 	if (c1 == '~' && c2 == '=') {*c = 0xF7; return (2);}	/* ~= */
XX! 	if (c1 == 'a' && c2 == 'p') {*c = 0x7E; return (2);}	/* approx */
XX! 	if (c1 == 'n' && c2 == 'o') {*c = 0xAA; return (2);}	/* not */
XX! 	if (c1 == 'm' && c2 == 'o') {*c = 0xEE; return (2);}	/* member */
XX! 	if (c1 == 'c' && c2 == 'a') {*c = 0xEF; return (2);}	/* intersect */
XX! 	if (c1 == 'c' && c2 == 'u') {*c = 0x55; return (2);}	/* union */
XX! 	if (c1 == 'i' && c2 == '1') {*c = 0xF4; return (2);}	/* integral1 */
XX! 	if (c1 == 'i' && c2 == '2') {*c = 0xF5; return (2);}	/* integral2 */
XX! 
XX! 	/*
XX! 	 *   greek
XX! 	 */
XX! 	if (c1 == '*' && c2 == 'a') {*c = 0xE0; return (2);}	/* alpha */
XX! 	if (c1 == '*' && c2 == 'b') {*c = 0xE1; return (2);}	/* beta */
XX! 	if (c1 == '*' && c2 == 'g') {*c = 0xE2; return (2);}	/* gamma */
XX! 	if (c1 == '*' && c2 == 'd') {*c = 0x7F; return (2);}	/* delta */
XX! 	if (c1 == '*' && c2 == 's') {*c = 0xE4; return (2);}	/* sigma */
XX! 	if (c1 == '*' && c2 == 'p') {*c = 0xE3; return (2);}	/* pi */
XX! 	if (c1 == '*' && c2 == 'm') {*c = 0xE6; return (2);}	/* mu */
XX! 
XX! 	*c = ' ';
XX! 	return (0);	
XX  }
XX  
XX- 
XX- 
XX- 
XX  /*------------------------------*/
XX  /*	fontchange		*/
XX  /*------------------------------*/
XX! fontchange (fnt, s)
XX! char	fnt;
XX! char   *s;
XX  {
XX  
XX  /*
XX--- 1,629 ----
XX! /* escape.c - Escape and special character input processing portion of nroff */
XX  
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX  /*------------------------------*/
XX  /*	expesc			*/
XX  /*------------------------------*/
XX! void expesc(p, q)
XX! char *p;
XX! char *q;
XX  {
XX+ /* Expand escape sequences */
XX  
XX!   register char *s;
XX!   register char *t;
XX!   register char *pstr;
XX!   register int i;
XX!   register int val;
XX!   register int autoinc;
XX!   char c;
XX!   char fs[5];			/* for font change */
XX!   char nrstr[20];
XX!   char fmt[20];
XX!   char name[10];
XX!   int nreg;
XX!   char *pfs;
XX!   int inc;
XX!   int tmp;
XX!   char delim;
XX  
XX!   s = p;
XX!   t = q;
XX  
XX+   /* If escape parsing is not on, just copy string */
XX+   if (dc.escon == NO) {
XX+ 	while (*s != EOS) *t++ = *s++;
XX+ 	*t = EOS;
XX+ 	strcpy(p, q);
XX+ 	return;
XX+   }
XX  
XX!   /* Do it... */
XX!   while (*s != EOS) {
XX! 	if (*s != dc.escchr) {
XX! 		/* Not esc, continue... */
XX! 		*t++ = *s++;
XX! 	} else if (*(s + 1) == dc.escchr) {
XX! 		/* \\				escape escape */
XX! 		*t++ = *s++;
XX! 		++s;
XX! 	} else if (*(s + 1) == 'n') {
XX! 		/* \nx, \n(xx			register 
XX! 		 * first check for \n+... or \n-... (either form) */
XX! 		s += 2;
XX! 		autoinc = 0;
XX! 		if (*s == '+') {
XX! 			autoinc = 1;
XX! 			s += 1;
XX  		}
XX! 		if (*s == '-') {
XX! 			autoinc = -1;
XX! 			s += 1;
XX  		}
XX  
XX+ 		/* Was this \nx or \n(xx form? */
XX+ 		if (isalpha(*s)) {
XX+ 			/* \nx form. find reg (a-z) */
XX+ 			nreg = tolower(*s) - 'a';
XX  
XX! 			/* Was this \n+x or \n-x? if so, do the auto incr */
XX! 			if (autoinc > 0)
XX! 				dc.nr[nreg] += dc.nrauto[nreg];
XX! 			else if (autoinc < 0)
XX! 				dc.nr[nreg] -= dc.nrauto[nreg];
XX  
XX+ 			/* Display format */
XX+ 			if (dc.nrfmt[nreg] == '1') {
XX+ 				/* Normal decimal digits */
XX+ 				t += itoda(dc.nr[nreg], t, 6) - 1;
XX+ 			} else if (dc.nrfmt[nreg] == 'i') {
XX+ 				/* Lower roman */
XX+ 				t += itoroman(dc.nr[nreg], t, 24) - 1;
XX+ 			} else if (dc.nrfmt[nreg] == 'I') {
XX+ 				/* Upper roman */
XX+ 				t += itoROMAN(dc.nr[nreg], t, 24) - 1;
XX+ 			} else if (dc.nrfmt[nreg] == 'a') {
XX+ 				/* Lower letters */
XX+ 				t += itoletter(dc.nr[nreg], t, 12) - 1;
XX+ 			} else if (dc.nrfmt[nreg] == 'A') {
XX+ 				/* Upper letters */
XX+ 				t += itoLETTER(dc.nr[nreg], t, 12) - 1;
XX+ 			} else if (dc.nrfmt[nreg] & 0x80) {
XX+ 				/* Zero-filled decimal */
XX+ 				sprintf(fmt, "%%0%dld",
XX+ 				     (int) (dc.nrfmt[nreg] & 0x7F));
XX+ 				fmt[5] = '\0';
XX+ 				sprintf(nrstr, fmt, (long) dc.nr[nreg]);
XX+ 				tmp = dc.nrfmt[nreg] & 0x7F;
XX+ 				nrstr[tmp] = '\0';
XX  
XX! 				strcpy(t, nrstr);
XX! 				t += strlen(nrstr);
XX! 			} else {
XX! 				/* Normal (default) */
XX! 				t += itoda(dc.nr[nreg], t, 6) - 1;
XX  			}
XX! 			++s;
XX! 		} else if (*s == '%') {
XX! 			/* \n% form. find index into reg struct */
XX! 			nreg = findreg("%");
XX! 			if (nreg < 0) {
XX! 				fprintf(err_stream,
XX! 					"***%s: no register match\n",
XX! 					myname);
XX! 				err_exit(-1);
XX  			}
XX  
XX+ 			/* Was this \n+% or \n-%? if so, do the auto incr */
XX+ 			if (autoinc > 0)
XX+ 				rg[nreg].rval += rg[nreg].rauto;
XX+ 			else if (autoinc < 0)
XX+ 				rg[nreg].rval -= rg[nreg].rauto;
XX  
XX+ 			/* Display format */
XX+ 			if (rg[nreg].rfmt == '1') {
XX+ 				/* Normal decimal digits */
XX+ 				t += itoda(rg[nreg].rval, t, 6) - 1;
XX+ 			} else if (rg[nreg].rfmt == 'i') {
XX+ 				/* Lower roman */
XX+ 				t += itoroman(rg[nreg].rval, t, 24) - 1;
XX+ 			} else if (rg[nreg].rfmt == 'I') {
XX+ 				/* Upper roman */
XX+ 				t += itoROMAN(rg[nreg].rval, t, 24) - 1;
XX+ 			} else if (rg[nreg].rfmt == 'a') {
XX+ 				/* Lower letters */
XX+ 				t += itoletter(rg[nreg].rval, t, 12) - 1;
XX+ 			} else if (rg[nreg].rfmt == 'A') {
XX+ 				/* Upper letters */
XX+ 				t += itoLETTER(rg[nreg].rval, t, 12) - 1;
XX+ 			} else if (rg[nreg].rfmt & 0x80) {
XX+ 				/* Zero-filled decimal */
XX+ 				sprintf(fmt, "%%0%dld",
XX+ 				      (int) (rg[nreg].rfmt & 0x7F));
XX+ 				fmt[5] = '\0';
XX+ 				sprintf(nrstr, fmt, (long) rg[nreg].rval);
XX+ 				tmp = rg[nreg].rfmt & 0x7F;
XX+ 				nrstr[tmp] = '\0';
XX  
XX! 				strcpy(t, nrstr);
XX! 				t += strlen(nrstr);
XX! 			} else {
XX! 				/* Normal (default) */
XX! 				t += itoda(rg[nreg].rval, t, 6) - 1;
XX  			}
XX! 			s += 1;
XX! 		} else if (*s == '(') {
XX! 			/* \n(xx form. find index into reg struct */
XX! 			s += 1;
XX! 			name[0] = *s;
XX! 			name[1] = *(s + 1);
XX! 			if (name[1] == ' ' || name[1] == '\t'
XX! 			    || name[1] == '\n' || name[1] == '\r')
XX! 				name[1] = '\0';
XX! 			name[2] = '\0';
XX! 			nreg = findreg(name);
XX! 			if (nreg < 0) {
XX! 				fprintf(err_stream,
XX! 					"***%s: no register match\n",
XX! 					myname);
XX! 				err_exit(-1);
XX! 			}
XX  
XX! 			/* Was this \n+(xx or \n-(xx? if so, do the auto incr*/
XX! 			if (rg[nreg].rflag & RF_WRITE) {
XX  				if (autoinc > 0)
XX  					rg[nreg].rval += rg[nreg].rauto;
XX  				else if (autoinc < 0)
XX  					rg[nreg].rval -= rg[nreg].rauto;
XX  			}
XX  
XX! 			/* Display format */
XX! 			if (rg[nreg].rfmt == '1') {
XX! 				/* Normal decimal digits */
XX! 				t += itoda(rg[nreg].rval, t, 6) - 1;
XX! 			} else if (rg[nreg].rfmt == 'i') {
XX! 				/* Lower roman */
XX! 				t += itoroman(rg[nreg].rval, t, 24) - 1;
XX! 			} else if (rg[nreg].rfmt == 'I') {
XX! 				/* Upper roman */
XX! 				t += itoROMAN(rg[nreg].rval, t, 24) - 1;
XX! 			} else if (rg[nreg].rfmt == 'a') {
XX! 				/* Lower letters */
XX! 				t += itoletter(rg[nreg].rval, t, 12) - 1;
XX! 			} else if (rg[nreg].rfmt == 'A') {
XX! 				/* Upper letters */
XX! 				t += itoLETTER(rg[nreg].rval, t, 12) - 1;
XX! 			} else if (rg[nreg].rfmt & 0x80) {
XX! 				/* Zero-filled decimal */
XX! 				sprintf(fmt, "%%0%dld",
XX! 				      (int) (rg[nreg].rfmt & 0x7F));
XX! 				fmt[5] = '\0';
XX! 				sprintf(nrstr, fmt, (long) rg[nreg].rval);
XX! 				tmp = rg[nreg].rfmt & 0x7F;
XX! 				nrstr[tmp] = '\0';
XX  
XX! 				strcpy(t, nrstr);
XX! 				t += strlen(nrstr);
XX! 			} else {
XX! 				/* Normal (default) */
XX! 				t += itoda(rg[nreg].rval, t, 6) - 1;
XX  			}
XX  			s += 2;
XX  		}
XX+ 	} else if (*(s + 1) == '\"') {
XX+ 		/* \"				comment */
XX+ 		*s = EOS;
XX+ 		*t = *s;
XX  
XX! 		return;
XX! 	} else if (*(s + 1) == '*') {
XX! 		/* \*x, \*(xx			string */
XX! 		s += 2;
XX! 		if (*s == '(') {
XX! 			/* \*(xx form */
XX! 			s += 1;
XX! 			name[0] = *s;
XX! 			name[1] = *(s + 1);
XX! 			name[2] = '\0';
XX! 			pstr = getstr(name);
XX! 			if (!pstr) {
XX! 				fprintf(err_stream,
XX! 					"***%s: string not found\n",
XX! 					myname);
XX! 				err_exit(-1);
XX! 			}
XX! 			while (*pstr) *t++ = *pstr++;
XX  			s += 2;
XX! 		} else {
XX! 			/* \*x form */
XX! 			name[0] = *s;
XX! 			name[1] = '\0';
XX! 			pstr = getstr(name);
XX! 			if (!pstr) {
XX! 				fprintf(err_stream,
XX! 					"***%s: string not found\n",
XX! 					myname);
XX! 				err_exit(-1);
XX  			}
XX+ 			while (*pstr) *t++ = *pstr++;
XX+ 			s += 1;
XX  		}
XX+ 	} else if (*(s + 1) == 'f') {
XX+ 		/* \fx			font */
XX+ 		s += 2;
XX+ 		pfs = fs;	/* set up ret string */
XX+ 		fs[0] = '\0';
XX  
XX+ 		/* It parses 1-2 char of s and returns esc seq for
XX+ 		 * \fB and \fR (\fI is same as \fB) */
XX+ 		fontchange(*s, pfs);
XX  
XX! 		/* Imbed the atari (vt52) escape seq */
XX! 		while (*pfs) *t++ = *pfs++;
XX! 		++s;		/* skip B,I,R,S,P */
XX! 	} else if (*(s + 1) == '(') {
XX! 		/* \(xx			special char */
XX! 		s += 2;
XX  
XX+ 		/* It returns num char to skip and sets c to the
XX+ 		 * ascii value of the char */
XX+ 		inc = specialchar(s, &c);
XX  
XX! 		/* Skip proper num char in s and add c to target */
XX! 		if (inc) {
XX! 			s += inc;
XX! 			*t++ = c;
XX  		}
XX! 	} else if (*(s + 1) == 'e') {
XX! 		/* \e			printable version of escape */
XX! 		*t++ = dc.escchr;
XX! 		s += 2;
XX! 	} else if (*(s + 1) == '`') {
XX! 		/* \`			grave, like \(ga */
XX! 		*t++ = 0x60;
XX! 		s += 2;
XX! 	} else if (*(s + 1) == '\'') {
XX! 		/* \'			accute, like \(aa */
XX! 		s += 2;
XX! 		*t++ = 0xBA;
XX! 	} else if (*(s + 1) == '-') {
XX! 		/* \-			minus */
XX! 		s += 2;
XX! 		*t++ = 0x2D;
XX! 	} else if (*(s + 1) == '.') {
XX! 		/* \.			period */
XX! 		s += 2;
XX! 		*t++ = 0x2E;
XX! 	} else if (*(s + 1) == ' ') {
XX! 		/* \(space)		space */
XX! 		s += 2;
XX! 		*t++ = 0x20;
XX! 	} else if (*(s + 1) == '0') {
XX! 		/* \0			digital width space */
XX! 		s += 2;
XX! 		*t++ = 0x20;
XX! 	} else if (*(s + 1) == '|') {
XX! 		/* \|			narrow width char (0 in nroff) */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == '^') {
XX! 		/* \^			narrow width char (0 in nroff) */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == '&') {
XX! 		/* \&			non-printing zero width */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == '!') {
XX! 		/* \!			transparent copy line */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == '$') {
XX! 		/* \$N		interpolate arg 1<=N<=9 */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == '%') {
XX! 		/* \%			hyphen */
XX! 		s += 2;
XX! 		*t++ = 0x2D;
XX! 		*t++ = 0x2D;
XX! 	} else if (*(s + 1) == 'a') {
XX! 		/* \a */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == 'b') {
XX! 		/* \b'abc...' */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == 'c') {
XX! 		/* \c */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == 'd') {
XX! 		/* \d */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == 'h') {
XX! 		/* \h'N'		horiz motion */
XX! 		s += 2;
XX! 		delim = *s++;
XX! 		val = atoi(s);
XX! 		for (i = 0; i < val; i++) *t++ = ' ';
XX! 		while (*s != delim) {
XX! 			if (*s == 0) break;
XX  			s++;
XX  		}
XX+ 		if (*s) s++;
XX  
XX! 	} else if (*(s + 1) == 'k') {
XX! 		/* \kx */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == 'l') {
XX! 		/* \l'Nc' */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == 'L') {
XX! 		/* \L'Nc' */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == 'o') {
XX! 		/* \o'abc...'			overstrike */
XX! 		s += 2;
XX! 		delim = *s++;
XX! 		while (*s != EOS && *s != delim) {
XX  			*t++ = *s++;
XX  			*t++ = 0x08;
XX  		}
XX! 		s++;
XX! 	} else if (*(s + 1) == 'p') {
XX! 		/* \p */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == 'r') {
XX! 		/* \r */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == 's') {
XX! 		/* \sN,\s+-N */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == 't') {
XX! 		/* \t			horizontal tab */
XX! 		s += 2;
XX! 		*t++ = 0x09;
XX! 	} else if (*(s + 1) == 'u') {
XX! 		/* \u */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == 'v') {
XX! 		/* \v'N'		vert tab */
XX! 		s += 2;
XX! 		delim = *s++;
XX! 		val = atoi(s);
XX! 		for (i = 0; i < val; i++) *t++ = 0x0A;
XX! 		while (*s != delim) {
XX! 			if (*s == 0) break;
XX! 			s++;
XX  		}
XX! 		if (*s) s++;
XX! 	} else if (*(s + 1) == 'w') {
XX! 		/* \w'str' */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == 'x') {
XX! 		/* \x'N' */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == 'z') {
XX! 		/* \zc		print c w/o spacing */
XX! 		s += 2;
XX! 		*t++ = *s++;
XX! 		*t++ = 0x08;
XX! 	} else if (*(s + 1) == '{') {
XX! 		/* \{ */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == '}') {
XX! 		/* \} */
XX! 		s += 2;
XX! 	} else if (*(s + 1) == '\n' || *(s + 1) == '\r') {
XX! 		/* \(newline)		ignore newline */
XX! 		s += 2;
XX! 	} else {
XX! 		/* \X			any other character not above */
XX! 		s += 1;
XX! 		*t++ = *s++;
XX  	}
XX  
XX!   }
XX! 
XX!   /* End the string and return it in original buf */
XX!   *t = EOS;
XX!   strcpy(p, q);
XX  }
XX  
XX  /*------------------------------*/
XX  /*	specialchar		*/
XX  /*------------------------------*/
XX! int specialchar(s, c)
XX! register char *s;
XX! register char *c;
XX  {
XX  
XX  /*
XX   *	handles \(xx escape sequences for special characters (atari-specific)
XX   */
XX  
XX!   register char c1;
XX!   register char c2;
XX  
XX!   c1 = *s;
XX!   c2 = *(s + 1);
XX  
XX!   /* Symbols */
XX!   if (c1 == 'c' && c2 == 'o') {
XX! 	*c = 0xBD;
XX! 	return(2);
XX!   }				/* copyright */
XX!   if (c1 == 'r' && c2 == 'g') {
XX! 	*c = 0xBE;
XX! 	return(2);
XX!   }				/* registered */
XX!   if (c1 == 't' && c2 == 'm') {
XX! 	*c = 0xBF;
XX! 	return(2);
XX!   }				/* trademark */
XX!   if (c1 == '1' && c2 == '2') {
XX! 	*c = 0xAB;
XX! 	return(2);
XX!   }				/* 1/2 */
XX!   if (c1 == '1' && c2 == '4') {
XX! 	*c = 0xAC;
XX! 	return(2);
XX!   }				/* 1/4 */
XX!   if (c1 == 'p' && c2 == '2') {
XX! 	*c = 0xFD;
XX! 	return(2);
XX!   }				/* ^2 */
XX!   if (c1 == 'p' && c2 == '3') {
XX! 	*c = 0xFE;
XX! 	return(2);
XX!   }				/* ^3 */
XX!   if (c1 == 'p' && c2 == 'n') {
XX! 	*c = 0xFC;
XX! 	return(2);
XX!   }				/* ^n */
XX!   if (c1 == 'a' && c2 == 'a') {
XX! 	*c = 0xBA;
XX! 	return(2);
XX!   }				/* acute */
XX!   if (c1 == 'g' && c2 == 'a') {
XX! 	*c = 0x60;
XX! 	return(2);
XX!   }				/* grave */
XX!   if (c1 == 'd' && c2 == 'e') {
XX! 	*c = 0xF8;
XX! 	return(2);
XX!   }				/* degree */
XX!   if (c1 == 'd' && c2 == 'g') {
XX! 	*c = 0xBB;
XX! 	return(2);
XX!   }				/* dagger */
XX!   if (c1 == 'c' && c2 == 't') {
XX! 	*c = 0x9B;
XX! 	return(2);
XX!   }				/* cent */
XX!   if (c1 == 'b' && c2 == 'u') {
XX! 	*c = 0xF9;
XX! 	return(2);
XX!   }				/* bullet */
XX!   if (c1 == 'd' && c2 == 't') {
XX! 	*c = 0xFA;
XX! 	return(2);
XX!   }				/* dot */
XX!   if (c1 == 'p' && c2 == 'p') {
XX! 	*c = 0xBC;
XX! 	return(2);
XX!   }				/* paragraph */
XX!   if (c1 == '^' && c2 == 'g') {
XX! 	*c = 0x07;
XX! 	return(2);
XX!   }				/* ring bell */
XX!   if (c1 == 'u' && c2 == 'a') {
XX! 	*c = 0x01;
XX! 	return(2);
XX!   }				/* up arrow */
XX!   if (c1 == 'd' && c2 == 'a') {
XX! 	*c = 0x02;
XX! 	return(2);
XX!   }				/* dn arrow */
XX!   if (c1 == '-' && c2 == '>') {
XX! 	*c = 0x03;
XX! 	return(2);
XX!   }				/* rt arrow */
XX!   if (c1 == '<' && c2 == '-') {
XX! 	*c = 0x04;
XX! 	return(2);
XX!   }				/* lf arrow */
XX!   if (c1 == 'd' && c2 == 'i') {
XX! 	*c = 0xF6;
XX! 	return(2);
XX!   }				/* divide */
XX!   if (c1 == 's' && c2 == 'r') {
XX! 	*c = 0xFB;
XX! 	return(2);
XX!   }				/* sq root */
XX!   if (c1 == '=' && c2 == '=') {
XX! 	*c = 0xF0;
XX! 	return(2);
XX!   }				/* == */
XX!   if (c1 == '>' && c2 == '=') {
XX! 	*c = 0xF2;
XX! 	return(2);
XX!   }				/* >= */
XX!   if (c1 == '<' && c2 == '=') {
XX! 	*c = 0xF3;
XX! 	return(2);
XX!   }				/* <= */
XX!   if (c1 == '+' && c2 == '-') {
XX! 	*c = 0xF1;
XX! 	return(2);
XX!   }				/* +- */
XX!   if (c1 == '~' && c2 == '=') {
XX! 	*c = 0xF7;
XX! 	return(2);
XX!   }				/* ~= */
XX!   if (c1 == 'a' && c2 == 'p') {
XX! 	*c = 0x7E;
XX! 	return(2);
XX!   }				/* approx */
XX!   if (c1 == 'n' && c2 == 'o') {
XX! 	*c = 0xAA;
XX! 	return(2);
XX!   }				/* not */
XX!   if (c1 == 'm' && c2 == 'o') {
XX! 	*c = 0xEE;
XX! 	return(2);
XX!   }				/* member */
XX!   if (c1 == 'c' && c2 == 'a') {
XX! 	*c = 0xEF;
XX! 	return(2);
XX!   }				/* intersect */
XX!   if (c1 == 'c' && c2 == 'u') {
XX! 	*c = 0x55;
XX! 	return(2);
XX!   }				/* union */
XX!   if (c1 == 'i' && c2 == '1') {
XX! 	*c = 0xF4;
XX! 	return(2);
XX!   }				/* integral1 */
XX!   if (c1 == 'i' && c2 == '2') {
XX! 	*c = 0xF5;
XX! 	return(2);
XX!   }				/* integral2 */
XX!   /* Greek */
XX!   if (c1 == '*' && c2 == 'a') {
XX! 	*c = 0xE0;
XX! 	return(2);
XX!   }				/* alpha */
XX!   if (c1 == '*' && c2 == 'b') {
XX! 	*c = 0xE1;
XX! 	return(2);
XX!   }				/* beta */
XX!   if (c1 == '*' && c2 == 'g') {
XX! 	*c = 0xE2;
XX! 	return(2);
XX!   }				/* gamma */
XX!   if (c1 == '*' && c2 == 'd') {
XX! 	*c = 0x7F;
XX! 	return(2);
XX!   }				/* delta */
XX!   if (c1 == '*' && c2 == 's') {
XX! 	*c = 0xE4;
XX! 	return(2);
XX!   }				/* sigma */
XX!   if (c1 == '*' && c2 == 'p') {
XX! 	*c = 0xE3;
XX! 	return(2);
XX!   }				/* pi */
XX!   if (c1 == '*' && c2 == 'm') {
XX! 	*c = 0xE6;
XX! 	return(2);
XX!   }				/* mu */
XX!   *c = ' ';
XX!   return(0);
XX  }
XX  
XX  /*------------------------------*/
XX  /*	fontchange		*/
XX  /*------------------------------*/
XX! void fontchange(fnt, s)
XX! char fnt;
XX! char *s;
XX  {
XX  
XX  /*
XX***************
XX*** 960,1041 ****
XX   *	with no args)
XX   */
XX  
XX! 	int	tmp;
XX  
XX  	*s = '\0';
XX! 	switch (fnt)
XX! 	{
XX! 	case 'R':				/* Times Roman */
XX! 		if (dc.dofnt == YES)
XX! 		{
XX  			if (dc.thisfnt == 2)
XX! 				strcpy (s, e_italic);
XX  			else if (dc.thisfnt == 3)
XX! 				strcpy (s, e_bold);
XX! 		}
XX! 		dc.lastfnt = dc.thisfnt;
XX! 		dc.thisfnt = 1;
XX! 		break;
XX! 	case 'I':				/* Times italic */
XX! 		if (dc.dofnt == YES)
XX! 			strcpy (s, s_italic);
XX! 		dc.lastfnt = dc.thisfnt;
XX! 		dc.thisfnt = 2;
XX! 		break;
XX! 	case 'B':				/* Times bold */
XX! 		if (dc.dofnt == YES)
XX! 			strcpy (s, s_bold);
XX! 		dc.lastfnt = dc.thisfnt;
XX! 		dc.thisfnt = 3;
XX! 		break;
XX! 	case 'S':				/* math/special */
XX! 		*s = '\0';
XX! 		dc.lastfnt = dc.thisfnt;
XX! 		dc.thisfnt = 4;
XX! 		break;
XX! 	case 'P':				/* previous (exchange) */
XX! 		if (dc.dofnt == YES)
XX! 		{
XX! 			if (dc.lastfnt == 1)
XX! 			{
XX! 				if (dc.thisfnt == 2)
XX! 					strcpy (s, e_italic);
XX! 				else if (dc.thisfnt == 3)
XX! 					strcpy (s, e_bold);
XX! 			}
XX! 			else if (dc.lastfnt == 2)
XX! 			{
XX! 				strcpy (s, s_italic);	/* to I */
XX! 			}
XX! 			else if (dc.lastfnt == 3)
XX! 			{
XX! 				strcpy (s, s_bold);	/* to B */
XX! 			}
XX! 			else
XX! 				*s = '\0';		/* nothing */
XX! 		}
XX! 
XX! 		tmp        = dc.thisfnt;		/* swap this/last */
XX! 		dc.thisfnt = dc.lastfnt;
XX! 		dc.lastfnt = tmp;
XX! 		break;
XX! 	default:
XX! 		*s = '\0';
XX! 		break;
XX  	}
XX  
XX! 	set_ireg (".f", dc.thisfnt, 0);
XX! }
XX  
XX  
XX  
XX- 
XX- 
XX  /*------------------------------*/
XX  /*	findreg			*/
XX  /*------------------------------*/
XX! findreg (name)
XX! register char  *name;
XX  {
XX  
XX  /*
XX--- 632,701 ----
XX   *	with no args)
XX   */
XX  
XX!   int tmp;
XX  
XX+   *s = '\0';
XX+   switch (fnt) {
XX+       case 'R':			/* Times Roman */
XX+ 	if (dc.dofnt == YES) {
XX+ 		if (dc.thisfnt == 2)
XX+ 			strcpy(s, e_italic);
XX+ 		else if (dc.thisfnt == 3)
XX+ 			strcpy(s, e_bold);
XX+ 	}
XX+ 	dc.lastfnt = dc.thisfnt;
XX+ 	dc.thisfnt = 1;
XX+ 	break;
XX+ 
XX+       case 'I':			/* Times italic */
XX+ 	if (dc.dofnt == YES) strcpy(s, s_italic);
XX+ 	dc.lastfnt = dc.thisfnt;
XX+ 	dc.thisfnt = 2;
XX+ 	break;
XX+ 
XX+       case 'B':			/* Times bold */
XX+ 	if (dc.dofnt == YES) strcpy(s, s_bold);
XX+ 	dc.lastfnt = dc.thisfnt;
XX+ 	dc.thisfnt = 3;
XX+ 	break;
XX+ 
XX+       case 'S':			/* math/special */
XX  	*s = '\0';
XX! 	dc.lastfnt = dc.thisfnt;
XX! 	dc.thisfnt = 4;
XX! 	break;
XX! 
XX!       case 'P':			/* previous (exchange) */
XX! 	if (dc.dofnt == YES) {
XX! 		if (dc.lastfnt == 1) {
XX  			if (dc.thisfnt == 2)
XX! 				strcpy(s, e_italic);
XX  			else if (dc.thisfnt == 3)
XX! 				strcpy(s, e_bold);
XX! 		} else if (dc.lastfnt == 2) {
XX! 			strcpy(s, s_italic);	/* to I */
XX! 		} else if (dc.lastfnt == 3) {
XX! 			strcpy(s, s_bold);	/* to B */
XX! 		} else
XX! 			*s = '\0';	/* nothing */
XX  	}
XX+ 	tmp = dc.thisfnt;	/* swap this/last */
XX+ 	dc.thisfnt = dc.lastfnt;
XX+ 	dc.lastfnt = tmp;
XX+ 	break;
XX  
XX!       default:	*s = '\0';	break;
XX  
XX+   }
XX  
XX+   set_ireg(".f", dc.thisfnt, 0);
XX+ }
XX  
XX  /*------------------------------*/
XX  /*	findreg			*/
XX  /*------------------------------*/
XX! int findreg(name)
XX! register char *name;
XX  {
XX  
XX  /*
XX***************
XX*** 1043,1061 ****
XX   *	if not found.
XX   */
XX  
XX! 	register int	i;
XX! 	register char  *prname;
XX  
XX! 	for (i = 0; i < MAXREGS; i++)
XX! 	{
XX! 		prname = rg[i].rname;
XX! 		if (*prname == *name && *(prname + 1) == *(name + 1))
XX! 			break;
XX! 	}
XX  
XX! 	return ((i < MAXREGS) ? i : -1);
XX  }
XX- 
XX- 
XX- 
XX- 
XX--- 703,715 ----
XX   *	if not found.
XX   */
XX  
XX!   register int i;
XX!   register char *prname;
XX  
XX!   for (i = 0; i < MAXREGS; i++) {
XX! 	prname = rg[i].rname;
XX! 	if (*prname == *name && *(prname + 1) == *(name + 1)) break;
XX!   }
XX  
XX!   return((i < MAXREGS) ? i : -1);
XX  }
X/
Xecho x - io.c.d
Xsed '/^X/s///' > io.c.d << '/'
XX*** /home/top/ast/minix/1.5/commands/nroff/io.c  crc=03651   3900	Sat Apr 21 22:27:21 1990
XX--- /home/top/ast/minix/1.6.25/commands/nroff/io.c  crc=45807   3287	Mon Nov 23 12:19:52 1992
XX***************
XX*** 1,67 ****
XX! /*
XX!  *	io.c - low level I/O processing portion of nroff word processor
XX!  *
XX!  *	adapted for atariST/TOS by Bill Rosenkranz 11/89
XX!  *	net:	rosenkra@hall.cray.com
XX!  *	CIS:	71460,17
XX!  *	GENIE:	W.ROSENKRANZ
XX!  *
XX!  *	original author:
XX!  *
XX!  *	Stephen L. Browning
XX!  *	5723 North Parker Avenue
XX!  *	Indianapolis, Indiana 46220
XX!  *
XX!  *	history:
XX!  *
XX!  *	- Originally written in BDS C;
XX!  *	- Adapted for standard C by W. N. Paul
XX!  *	- Heavily hacked up to conform to "real" nroff by Bill Rosenkranz
XX!  */
XX  
XX- #undef NRO_MAIN					/* extern globals */
XX- 
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX  /*------------------------------*/
XX  /*	getlin			*/
XX  /*------------------------------*/
XX! getlin (p, in_buf)
XX! char   *p;
XX! FILE   *in_buf;
XX  {
XX  
XX  /*
XX   *	retrieve one line of input text
XX   */
XX  
XX! 	register char  *q;
XX! 	register int	i;
XX! 	int		c;
XX! 	int		nreg;
XX  
XX! 	q = p;
XX! 	for (i = 0; i < MAXLINE - 1; ++i)
XX! 	{
XX! 		c = ngetc (in_buf);
XX! 		if (c == EOF)
XX! 		{
XX! 			*q = EOS;
XX! 			c  = strlen (p);
XX! 			return (c == 0 ? EOF : c);
XX! 		}
XX! 		*q++ = c;
XX! 		if (c == '\n')
XX! 			break;
XX  	}
XX! 	*q = EOS;
XX  
XX! 	nreg = findreg (".c");
XX! 	if (nreg > 0)
XX! 		set_ireg (".c", rg[nreg].rval + 1, 0);
XX  
XX! 	return (strlen (p));
XX  }
XX  
XX  
XX--- 1,42 ----
XX! /* io.c - low level I/O processing portion of nroff word processor */
XX  
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX  /*------------------------------*/
XX  /*	getlin			*/
XX  /*------------------------------*/
XX! int getlin(p, in_buf)
XX! char *p;
XX! FILE *in_buf;
XX  {
XX  
XX  /*
XX   *	retrieve one line of input text
XX   */
XX  
XX!   register char *q;
XX!   register int i;
XX!   int c;
XX!   int nreg;
XX  
XX!   q = p;
XX!   for (i = 0; i < MAXLINE - 1; ++i) {
XX! 	c = ngetc(in_buf);
XX! 	if (c == EOF) {
XX! 		*q = EOS;
XX! 		c = strlen(p);
XX! 		return(c == 0 ? EOF : c);
XX  	}
XX! 	*q++ = c;
XX! 	if (c == '\n') break;
XX!   }
XX!   *q = EOS;
XX  
XX!   nreg = findreg(".c");
XX!   if (nreg > 0) set_ireg(".c", rg[nreg].rval + 1, 0);
XX  
XX!   return(strlen(p));
XX  }
XX  
XX  
XX***************
XX*** 72,93 ****
XX  /*------------------------------*/
XX  /*	ngetc			*/
XX  /*------------------------------*/
XX! ngetc (infp)
XX! FILE   *infp;
XX  {
XX  
XX  /*
XX   *	get character from input file or push back buffer
XX   */
XX  
XX! 	register int	c;
XX  
XX! 	if (mac.ppb >= &mac.pbb[0])
XX! 		c = *mac.ppb--;
XX! 	else
XX! 		c = getc (infp);
XX  
XX! 	return (c);
XX  }
XX  
XX  
XX--- 47,68 ----
XX  /*------------------------------*/
XX  /*	ngetc			*/
XX  /*------------------------------*/
XX! int ngetc(infp)
XX! FILE *infp;
XX  {
XX  
XX  /*
XX   *	get character from input file or push back buffer
XX   */
XX  
XX!   register int c;
XX  
XX!   if (mac.ppb >= &mac.pbb[0])
XX! 	c = *mac.ppb--;
XX!   else
XX! 	c = getc(infp);
XX  
XX!   return(c);
XX  }
XX  
XX  
XX***************
XX*** 95,121 ****
XX  /*------------------------------*/
XX  /*	pbstr			*/
XX  /*------------------------------*/
XX! pbstr (p)
XX! char   *p;
XX  {
XX  
XX  /*
XX   *	Push back string into input stream
XX   */
XX  
XX! 	register int	i;
XX  
XX! 	/*
XX! 	 *   if string is null, we do nothing
XX! 	 */
XX! 	if (p == NULL_CPTR)
XX! 		return;
XX! 	if (p[0] == EOS)
XX! 		return;
XX! 	for (i = strlen (p) - 1; i >= 0; --i)
XX! 	{
XX! 		putbak (p[i]);
XX! 	}
XX  }
XX  
XX  
XX--- 70,91 ----
XX  /*------------------------------*/
XX  /*	pbstr			*/
XX  /*------------------------------*/
XX! void pbstr(p)
XX! char *p;
XX  {
XX  
XX  /*
XX   *	Push back string into input stream
XX   */
XX  
XX!   register int i;
XX  
XX!   /* If string is null, we do nothing */
XX!   if (p == NULL_CPTR) return;
XX!   if (p[0] == EOS) return;
XX!   for (i = strlen(p) - 1; i >= 0; --i) {
XX! 	putbak(p[i]);
XX!   }
XX  }
XX  
XX  
XX***************
XX*** 125,132 ****
XX  /*------------------------------*/
XX  /*	putbak			*/
XX  /*------------------------------*/
XX! putbak (c)
XX! char    c;
XX  {
XX  
XX  /*
XX--- 95,102 ----
XX  /*------------------------------*/
XX  /*	putbak			*/
XX  /*------------------------------*/
XX! void putbak(c)
XX! char c;
XX  {
XX  
XX  /*
XX***************
XX*** 134,154 ****
XX   *	stored with macros.
XX   */
XX  
XX! 	if (mac.ppb < &(mac.pbb[0]))
XX! 	{
XX! 		mac.ppb = &(mac.pbb[0]);
XX! 		*mac.ppb = c;
XX  	}
XX! 	else
XX! 	{
XX! 		if (mac.ppb >= &mac.pbb[MAXLINE - 1])
XX! 		{
XX! 			fprintf (err_stream,
XX! 				"***%s: push back buffer overflow\n", myname);
XX! 			err_exit (-1);
XX! 		}
XX! 		*++(mac.ppb) = c;
XX! 	}
XX  }
XX  
XX  
XX--- 104,120 ----
XX   *	stored with macros.
XX   */
XX  
XX!   if (mac.ppb < &(mac.pbb[0])) {
XX! 	mac.ppb = &(mac.pbb[0]);
XX! 	*mac.ppb = c;
XX!   } else {
XX! 	if (mac.ppb >= &mac.pbb[MAXLINE - 1]) {
XX! 		fprintf(err_stream,
XX! 		      "***%s: push back buffer overflow\n", myname);
XX! 		err_exit(-1);
XX  	}
XX! 	*++(mac.ppb) = c;
XX!   }
XX  }
XX  
XX  
XX***************
XX*** 156,174 ****
XX  /*------------------------------*/
XX  /*	prchar			*/
XX  /*------------------------------*/
XX! prchar (c, fp)
XX! char    c;
XX! FILE   *fp;
XX  {
XX  
XX  /*
XX   *	print character with test for printer
XX   */
XX  
XX! 	if (fp == stdout)
XX! 		putc (c, fp);
XX! 	else
XX! 		putc_lpr (c, fp);
XX  }
XX  
XX  
XX--- 122,140 ----
XX  /*------------------------------*/
XX  /*	prchar			*/
XX  /*------------------------------*/
XX! void prchar(c, fp)
XX! char c;
XX! FILE *fp;
XX  {
XX  
XX  /*
XX   *	print character with test for printer
XX   */
XX  
XX!   if (fp == stdout)
XX! 	putc(c, fp);
XX!   else
XX! 	putc_lpr(c, fp);
XX  }
XX  
XX  
XX***************
XX*** 179,228 ****
XX  /*------------------------------*/
XX  /*	put			*/
XX  /*------------------------------*/
XX! put (p)
XX! char   *p;
XX  {
XX  
XX  /*
XX   *	put out line with proper spacing and indenting
XX   */
XX  
XX! 	register int	j;
XX! 	char		os[MAXLINE];
XX  
XX! 	if (pg.lineno == 0 || pg.lineno > pg.bottom)
XX! 	{
XX! 		phead ();
XX! 	}
XX! 	if (dc.prflg == TRUE)
XX! 	{
XX! 		if (!dc.bsflg)
XX! 		{
XX! 			if (strkovr (p, os) == TRUE)
XX! 			{
XX! 				for (j = 0; j < pg.offset; ++j)
XX! 					prchar (' ', out_stream);
XX! 				for (j = 0; j < dc.tival; ++j)
XX! 					prchar (' ', out_stream);
XX! 				putlin (os, out_stream);
XX! 			}
XX  		}
XX- 		for (j = 0; j < pg.offset; ++j)
XX- 			prchar (' ', out_stream);
XX- 		for (j = 0; j < dc.tival; ++j)
XX- 			prchar (' ', out_stream);
XX- 		putlin (p, out_stream);
XX  	}
XX! 	dc.tival = dc.inval;
XX! 	skip (min (dc.lsval - 1, pg.bottom - pg.lineno));
XX! 	pg.lineno = pg.lineno + dc.lsval;
XX! 	set_ireg ("ln", pg.lineno, 0);
XX! 	if (pg.lineno > pg.bottom)
XX! 	{
XX! 		pfoot ();
XX! 		if (stepping)
XX! 			wait_for_char ();
XX! 	}
XX  }
XX  
XX  
XX--- 145,186 ----
XX  /*------------------------------*/
XX  /*	put			*/
XX  /*------------------------------*/
XX! void put(p)
XX! char *p;
XX  {
XX  
XX  /*
XX   *	put out line with proper spacing and indenting
XX   */
XX  
XX!   register int j;
XX!   char os[MAXLINE];
XX  
XX!   if (pg.lineno == 0 || pg.lineno > pg.bottom) {
XX! 	phead();
XX!   }
XX!   if (dc.prflg == TRUE) {
XX! 	if (!dc.bsflg) {
XX! 		if (strkovr(p, os) == TRUE) {
XX! 			for (j = 0; j < pg.offset; ++j)
XX! 				prchar(' ', out_stream);
XX! 			for (j = 0; j < dc.tival; ++j)
XX! 				prchar(' ', out_stream);
XX! 			putlin(os, out_stream);
XX  		}
XX  	}
XX! 	for (j = 0; j < pg.offset; ++j) prchar(' ', out_stream);
XX! 	for (j = 0; j < dc.tival; ++j) prchar(' ', out_stream);
XX! 	putlin(p, out_stream);
XX!   }
XX!   dc.tival = dc.inval;
XX!   skip(min(dc.lsval - 1, pg.bottom - pg.lineno));
XX!   pg.lineno = pg.lineno + dc.lsval;
XX!   set_ireg("ln", pg.lineno, 0);
XX!   if (pg.lineno > pg.bottom) {
XX! 	pfoot();
XX! 	if (stepping) wait_for_char();
XX!   }
XX  }
XX  
XX  
XX***************
XX*** 231,239 ****
XX  /*------------------------------*/
XX  /*	putlin			*/
XX  /*------------------------------*/
XX! putlin (p, pbuf)
XX! register char  *p;
XX! FILE	       *pbuf;
XX  {
XX  
XX  /*
XX--- 189,197 ----
XX  /*------------------------------*/
XX  /*	putlin			*/
XX  /*------------------------------*/
XX! void putlin(p, pbuf)
XX! register char *p;
XX! FILE *pbuf;
XX  {
XX  
XX  /*
XX***************
XX*** 241,248 ****
XX   *	specified by pbuf.
XX   */
XX  
XX! 	while (*p != EOS)
XX! 		prchar (*p++, pbuf);
XX  }
XX  
XX  
XX--- 199,205 ----
XX   *	specified by pbuf.
XX   */
XX  
XX!   while (*p != EOS) prchar(*p++, pbuf);
XX  }
XX  
XX  
XX***************
XX*** 251,272 ****
XX  /*------------------------------*/
XX  /*	putc_lpr		*/
XX  /*------------------------------*/
XX! #ifdef GEMDOS
XX! #include <osbind.h>
XX! #endif
XX! 
XX! putc_lpr (c, fp)
XX! char	c;
XX! FILE   *fp;
XX  {
XX  
XX  /*
XX   *	write char to printer
XX   */
XX  
XX! #ifdef GEMDOS
XX! 	Bconout (0, (int) c & 0x00FF);
XX! #else
XX! 	putc (c, fp);
XX! #endif
XX  }
XX--- 208,221 ----
XX  /*------------------------------*/
XX  /*	putc_lpr		*/
XX  /*------------------------------*/
XX! void putc_lpr(c, fp)
XX! char c;
XX! FILE *fp;
XX  {
XX  
XX  /*
XX   *	write char to printer
XX   */
XX  
XX!   putc(c, fp);
XX  }
X/
Xecho x - low.c.d
Xsed '/^X/s///' > low.c.d << '/'
XX*** /home/top/ast/minix/1.5/commands/nroff/low.c  crc=24933  11845	Sat Apr 21 22:27:21 1990
XX--- /home/top/ast/minix/1.6.25/commands/nroff/low.c  crc=26672  10512	Mon Nov 23 12:19:53 1992
XX***************
XX*** 1,28 ****
XX! /*
XX!  *	low.c - misc low-level functions for nroff word processor
XX!  *
XX!  *	adapted for atariST/TOS by Bill Rosenkranz 11/89
XX!  *	net:	rosenkra@hall.cray.com
XX!  *	CIS:	71460,17
XX!  *	GENIE:	W.ROSENKRANZ
XX!  *
XX!  *	original author:
XX!  *
XX!  *	Stephen L. Browning
XX!  *	5723 North Parker Avenue
XX!  *	Indianapolis, Indiana 46220
XX!  *
XX!  *	history:
XX!  *
XX!  *	- Originally written in BDS C;
XX!  *	- Adapted for standard C by W. N. Paul
XX!  *	- Heavily hacked up to conform to "real" nroff by Bill Rosenkranz
XX!  *	- Adapted to have it recognize also VT100 escape codes (e.g. ESC[7m)
XX!  *	  by Wim 'Blue Baron' van Dorst (wsincc@tuerc3.urc.tue.nl)
XX!  */
XX  
XX- #undef NRO_MAIN					/* extern globals */
XX- 
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX--- 1,5 ----
XX! /* low.c - misc low-level functions for nroff word processor */
XX  
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX***************
XX*** 31,45 ****
XX  /*------------------------------*/
XX  /*	atod			*/
XX  /*------------------------------*/
XX! atod (c)
XX! char    c;
XX  {
XX  
XX  /*
XX   *	convert ascii character to decimal.
XX   */
XX  
XX! 	return (((c < '0') || (c > '9')) ? -1 : c - '0');
XX  }
XX  
XX  
XX--- 8,22 ----
XX  /*------------------------------*/
XX  /*	atod			*/
XX  /*------------------------------*/
XX! int atod(c)
XX! char c;
XX  {
XX  
XX  /*
XX   *	convert ascii character to decimal.
XX   */
XX  
XX!   return(((c < '0') || (c > '9')) ? -1 : c - '0');
XX  }
XX  
XX  
XX***************
XX*** 49,78 ****
XX  /*------------------------------*/
XX  /*	robrk			*/
XX  /*------------------------------*/
XX! robrk ()
XX  {
XX  
XX  /*
XX   *	end current filled line
XX   */
XX  
XX! 	if (co.outp > 0)
XX! 	{
XX! #ifdef GEMDOS
XX! 		co.outbuf[co.outp]   = '\r';
XX! 		co.outbuf[co.outp+1] = '\n';
XX! 		co.outbuf[co.outp+2] = EOS;
XX! #else
XX! 		co.outbuf[co.outp]   = '\n';
XX! 		co.outbuf[co.outp+1] = EOS;
XX! 		co.outbuf[co.outp+2] = EOS;
XX! #endif
XX! 		put (co.outbuf);
XX! 	}
XX! 	co.outp   = 0;
XX! 	co.outw   = 0;
XX! 	co.outwds = 0;
XX! 	co.outesc = 0;
XX  }
XX  
XX  
XX--- 26,48 ----
XX  /*------------------------------*/
XX  /*	robrk			*/
XX  /*------------------------------*/
XX! void robrk()
XX  {
XX  
XX  /*
XX   *	end current filled line
XX   */
XX  
XX!   if (co.outp > 0) {
XX! 	co.outbuf[co.outp] = '\n';
XX! 	co.outbuf[co.outp + 1] = EOS;
XX! 	co.outbuf[co.outp + 2] = EOS;
XX! 	put(co.outbuf);
XX!   }
XX!   co.outp = 0;
XX!   co.outw = 0;
XX!   co.outwds = 0;
XX!   co.outesc = 0;
XX  }
XX  
XX  
XX***************
XX*** 81,88 ****
XX  /*------------------------------*/
XX  /*	ctod			*/
XX  /*------------------------------*/
XX! ctod (p)
XX! register char  *p;
XX  {
XX  
XX  /*
XX--- 51,58 ----
XX  /*------------------------------*/
XX  /*	ctod			*/
XX  /*------------------------------*/
XX! int ctod(p)
XX! register char *p;
XX  {
XX  
XX  /*
XX***************
XX*** 90,108 ****
XX   *	processes only positive values.
XX   */
XX  
XX! 	register int	val;
XX! 	register int	d;
XX  
XX! 	val = 0;
XX! 	while (*p != EOS)
XX! 	{
XX! 		d = atod (*p);
XX! 		p++;
XX! 		if (d == -1)
XX! 			return (val);
XX! 		val = 10 * val + d;
XX! 	}
XX! 	return (val);
XX  }
XX  
XX  
XX--- 60,76 ----
XX   *	processes only positive values.
XX   */
XX  
XX!   register int val;
XX!   register int d;
XX  
XX!   val = 0;
XX!   while (*p != EOS) {
XX! 	d = atod(*p);
XX! 	p++;
XX! 	if (d == -1) return(val);
XX! 	val = 10 * val + d;
XX!   }
XX!   return(val);
XX  }
XX  
XX  
XX***************
XX*** 111,125 ****
XX  /*------------------------------*/
XX  /*	inptobu			*/
XX  /*------------------------------*/
XX! inptobu (ps)
XX! char   *ps;
XX  {
XX  
XX  /*
XX   *	convert input units to b.u.
XX   */
XX  
XX! 	return;
XX  }
XX  
XX  
XX--- 79,93 ----
XX  /*------------------------------*/
XX  /*	inptobu			*/
XX  /*------------------------------*/
XX! void inptobu(ps)
XX! char *ps;
XX  {
XX  
XX  /*
XX   *	convert input units to b.u.
XX   */
XX  
XX!   return;
XX  }
XX  
XX  
XX***************
XX*** 128,142 ****
XX  /*------------------------------*/
XX  /*	butochar		*/
XX  /*------------------------------*/
XX! butochar (ps)
XX! char   *ps;
XX  {
XX  
XX  /*
XX   *	convert b.u. to char spaces
XX   */
XX  
XX! 	return;
XX  }
XX  
XX  
XX--- 96,110 ----
XX  /*------------------------------*/
XX  /*	butochar		*/
XX  /*------------------------------*/
XX! void butochar(ps)
XX! char *ps;
XX  {
XX  
XX  /*
XX   *	convert b.u. to char spaces
XX   */
XX  
XX!   return;
XX  }
XX  
XX  
XX***************
XX*** 145,152 ****
XX  /*------------------------------*/
XX  /*	skipbl			*/
XX  /*------------------------------*/
XX! char   *skipbl (p)
XX! register char  *p;
XX  {
XX  
XX  /*
XX--- 113,120 ----
XX  /*------------------------------*/
XX  /*	skipbl			*/
XX  /*------------------------------*/
XX! char *skipbl(p)
XX! register char *p;
XX  {
XX  
XX  /*
XX***************
XX*** 155,163 ****
XX   *	also increments the arg ptr (side effect).
XX   */
XX  
XX! 	while ((*p != EOS) && (*p == ' ' || *p == '\t'))
XX! 		++p;
XX! 	return (p);
XX  }
XX  
XX  
XX--- 123,130 ----
XX   *	also increments the arg ptr (side effect).
XX   */
XX  
XX!   while ((*p != EOS) && (*p == ' ' || *p == '\t')) ++p;
XX!   return(p);
XX  }
XX  
XX  
XX***************
XX*** 166,173 ****
XX  /*------------------------------*/
XX  /*	skipwd			*/
XX  /*------------------------------*/
XX! char   *skipwd (p)
XX! register char  *p;
XX  {
XX  
XX  /*
XX--- 133,140 ----
XX  /*------------------------------*/
XX  /*	skipwd			*/
XX  /*------------------------------*/
XX! char *skipwd(p)
XX! register char *p;
XX  {
XX  
XX  /*
XX***************
XX*** 176,184 ****
XX   *	the arg ptr (side effect).
XX   */
XX  
XX! 	while (*p != ' ' && *p != '\t' && *p != '\r' && *p != '\n' && *p != EOS)
XX! 		++p;
XX! 	return (p);
XX  }
XX  
XX  
XX--- 143,151 ----
XX   *	the arg ptr (side effect).
XX   */
XX  
XX!   while (*p != ' ' && *p != '\t' && *p != '\r' && *p != '\n' && *p != EOS)
XX! 	++p;
XX!   return(p);
XX  }
XX  
XX  
XX***************
XX*** 188,211 ****
XX  /*------------------------------*/
XX  /*	space			*/
XX  /*------------------------------*/
XX! space (n)
XX! int     n;
XX  {
XX  
XX  /*
XX   *	space vertically n lines. this does header and footer also.
XX   */
XX  
XX! 	robrk ();
XX! 	if (pg.lineno > pg.bottom)
XX! 		return;
XX! 	if (pg.lineno == 0)
XX! 		phead ();
XX! 	skip (min (n, pg.bottom + 1 - pg.lineno));
XX! 	pg.lineno += n;
XX! 	set_ireg ("ln", pg.lineno, 0);
XX! 	if (pg.lineno > pg.bottom)
XX! 		pfoot ();
XX  }
XX  
XX  
XX--- 155,175 ----
XX  /*------------------------------*/
XX  /*	space			*/
XX  /*------------------------------*/
XX! void space(n)
XX! int n;
XX  {
XX  
XX  /*
XX   *	space vertically n lines. this does header and footer also.
XX   */
XX  
XX!   robrk();
XX!   if (pg.lineno > pg.bottom) return;
XX!   if (pg.lineno == 0) phead();
XX!   skip(min(n, pg.bottom + 1 - pg.lineno));
XX!   pg.lineno += n;
XX!   set_ireg("ln", pg.lineno, 0);
XX!   if (pg.lineno > pg.bottom) pfoot();
XX  }
XX  
XX  
XX***************
XX*** 214,237 ****
XX  /*------------------------------*/
XX  /*	getfield		*/
XX  /*------------------------------*/
XX! char   *getfield (p, q, delim)
XX! register char  *p;
XX! register char  *q;
XX! char		delim;
XX  {
XX  
XX  /*
XX   *	get field from title
XX   */
XX  
XX! 	while (*p != delim && *p != '\r' && *p != '\n' && *p != EOS)
XX! 	{
XX! 		*q++ = *p++;
XX! 	}
XX! 	*q = EOS;
XX! 	if (*p == delim)
XX! 		++p;
XX! 	return (p);
XX  }
XX  
XX  
XX--- 178,199 ----
XX  /*------------------------------*/
XX  /*	getfield		*/
XX  /*------------------------------*/
XX! char *getfield(p, q, delim)
XX! register char *p;
XX! register char *q;
XX! char delim;
XX  {
XX  
XX  /*
XX   *	get field from title
XX   */
XX  
XX!   while (*p != delim && *p != '\r' && *p != '\n' && *p != EOS) {
XX! 	*q++ = *p++;
XX!   }
XX!   *q = EOS;
XX!   if (*p == delim) ++p;
XX!   return(p);
XX  }
XX  
XX  
XX***************
XX*** 241,249 ****
XX  /*------------------------------*/
XX  /*	getwrd			*/
XX  /*------------------------------*/
XX! getwrd (p0, p1)
XX! register char  *p0;
XX! register char  *p1;
XX  {
XX  
XX  /*
XX--- 203,211 ----
XX  /*------------------------------*/
XX  /*	getwrd			*/
XX  /*------------------------------*/
XX! int getwrd(p0, p1)
XX! register char *p0;
XX! register char *p1;
XX  {
XX  
XX  /*
XX***************
XX*** 251,305 ****
XX   *	return number of characters processed.
XX   */
XX  
XX! 	register int	i;
XX! 	register char  *p;
XX! 	char		c;
XX  
XX! 	/*
XX! 	 *   init counter...
XX! 	 */
XX! 	i = 0;
XX  
XX  
XX! 	/*
XX! 	 *   skip leading whitespace
XX! 	 */
XX! 	while (*p0 && (*p0 == ' ' || *p0 == '\t'))
XX! 	{
XX! 		++i;
XX! 		++p0;
XX! 	}
XX  
XX  
XX! 	/*
XX! 	 *   set ptr and start to look for end of word
XX! 	 */
XX! 	p = p0;
XX! 	while (*p0 != ' ' && *p0 != EOS && *p0 != '\t')
XX! 	{
XX! 		if (*p0 == '\n' || *p0 == '\r')
XX! 			break;
XX! 		*p1 = *p0++;
XX! 		++p1;
XX! 		++i;
XX! 	}
XX  
XX! 	c = *(p1 - 1);
XX! 	if (c == '"')
XX! 		c = *(p1 - 2);
XX! 	if (c == '?' || c == '!')
XX! 	{
XX! 		*p1++ = ' ';
XX! 		++i;
XX! 	}
XX! 	if (c == '.' && (*p0 == '\n' || *p0 == '\r' || islower (*p)))
XX! 	{
XX! 		*p1++ = ' ';
XX! 		++i;
XX! 	}
XX! 	*p1 = EOS;
XX  
XX! 	return (i);
XX  }
XX  
XX  
XX--- 213,255 ----
XX   *	return number of characters processed.
XX   */
XX  
XX!   register int i;
XX!   register char *p;
XX!   char c;
XX  
XX!   /* Init counter... */
XX!   i = 0;
XX  
XX  
XX!   /* Skip leading whitespace */
XX!   while (*p0 && (*p0 == ' ' || *p0 == '\t')) {
XX! 	++i;
XX! 	++p0;
XX!   }
XX  
XX  
XX!   /* Set ptr and start to look for end of word */
XX!   p = p0;
XX!   while (*p0 != ' ' && *p0 != EOS && *p0 != '\t') {
XX! 	if (*p0 == '\n' || *p0 == '\r') break;
XX! 	*p1 = *p0++;
XX! 	++p1;
XX! 	++i;
XX!   }
XX  
XX!   c = *(p1 - 1);
XX!   if (c == '"') c = *(p1 - 2);
XX!   if (c == '?' || c == '!') {
XX! 	*p1++ = ' ';
XX! 	++i;
XX!   }
XX!   if (c == '.' && (*p0 == '\n' || *p0 == '\r' || islower(*p))) {
XX! 	*p1++ = ' ';
XX! 	++i;
XX!   }
XX!   *p1 = EOS;
XX  
XX!   return(i);
XX  }
XX  
XX  
XX***************
XX*** 311,318 ****
XX  
XX  #define ESC			27
XX  
XX! countesc (p)
XX! register char  *p;
XX  {
XX  
XX  /*
XX--- 261,268 ----
XX  
XX  #define ESC			27
XX  
XX! int countesc(p)
XX! register char *p;
XX  {
XX  
XX  /*
XX***************
XX*** 320,381 ****
XX   *	string
XX   */
XX  
XX! 	register char  *pp;
XX! 	register int	num;
XX  
XX! 	pp  = p;
XX! 	num = 0;
XX  
XX! 	while (*pp != EOS)
XX! 	{
XX! 		if (*pp == ESC)
XX! 		{
XX! 			/*
XX! 			 *   count escape char (vt52 and vt100)
XX! 			 */
XX! 			switch (*(pp+1))
XX! 			{
XX! 			case 'A':			/* ESC-a */
XX! 			case 'B':
XX! 			case 'C':
XX! 			case 'D':
XX! 			case 'E':
XX! 			case 'H':
XX! 			case 'I':
XX! 			case 'J':
XX! 			case 'K':
XX! 			case 'L':
XX! 			case 'M':
XX! 			case 'd':
XX! 			case 'e':
XX! 			case 'f':
XX! 			case 'j':
XX! 			case 'k':
XX! 			case 'l':
XX! 			case 'o':
XX! 			case 'p':
XX! 			case 'q':
XX! 			case 'v':
XX! 			case 'w':
XX! 				num += 2;
XX! 				break;
XX! 			case 'b':			/* ESC-a-b */
XX! 			case 'c':
XX! 				num += 3;
XX! 				break;
XX! 			case 'Y':			/* ESC-a-b-c */
XX! 			case '[':			/* Esc [ 7 m */
XX! 				num += 4;
XX! 				break;
XX! 			default:
XX! 				num += 1;
XX! 				break;
XX! 			}
XX  		}
XX- 		pp++;
XX  	}
XX  
XX! 	return (num);
XX  }
XX  
XX  
XX--- 270,320 ----
XX   *	string
XX   */
XX  
XX!   register char *pp;
XX!   register int num;
XX  
XX!   pp = p;
XX!   num = 0;
XX  
XX!   while (*pp != EOS) {
XX! 	if (*pp == ESC) {
XX! 		/* Count escape char (vt52 and vt100) */
XX! 		switch (*(pp + 1)) {
XX! 		    case 'A':	/* ESC-a */
XX! 		    case 'B':
XX! 		    case 'C':
XX! 		    case 'D':
XX! 		    case 'E':
XX! 		    case 'H':
XX! 		    case 'I':
XX! 		    case 'J':
XX! 		    case 'K':
XX! 		    case 'L':
XX! 		    case 'M':
XX! 		    case 'd':
XX! 		    case 'e':
XX! 		    case 'f':
XX! 		    case 'j':
XX! 		    case 'k':
XX! 		    case 'l':
XX! 		    case 'o':
XX! 		    case 'p':
XX! 		    case 'q':
XX! 		    case 'v':
XX! 		    case 'w':	num += 2;	break;
XX! 		    case 'b':	/* ESC-a-b */
XX! 		    case 'c':	num += 3;	break;
XX! 		    case 'Y':	/* ESC-a-b-c */
XX! 		    case '[':	/* Esc [ 7 m */
XX! 			num += 4;
XX! 			break;
XX! 		    default:	num += 1;	break;
XX  		}
XX  	}
XX+ 	pp++;
XX+   }
XX  
XX!   return(num);
XX  }
XX  
XX  
XX***************
XX*** 384,421 ****
XX  /*------------------------------*/
XX  /*	itoda			*/
XX  /*------------------------------*/
XX! itoda (value, p, size)
XX! int		value;
XX! register char  *p;
XX! register int	size;
XX  {
XX  
XX  /*
XX   *	convert integer to decimal ascii string
XX   */
XX  
XX! 	register int	i;
XX! 	register int    j;
XX! 	register int	k;
XX! 	register int	aval;
XX! 	char		c[20];
XX  
XX! 	aval = abs (value);
XX! 	c[0] = EOS;
XX! 	i = 1;
XX! 	do
XX! 	{
XX! 		c[i++] = (aval % 10) + '0';
XX! 		aval /= 10;
XX  
XX! 	} while (aval > 0 && i <= size);
XX  
XX! 	if (value < 0 && i <= size)
XX! 		c[i++] = '-';
XX! 	for (j = 0; j < i; ++j)
XX! 		*p++ = c[i - j - 1];
XX  
XX! 	return (i);
XX  }
XX  
XX  
XX--- 323,356 ----
XX  /*------------------------------*/
XX  /*	itoda			*/
XX  /*------------------------------*/
XX! int itoda(value, p, size)
XX! int value;
XX! register char *p;
XX! register int size;
XX  {
XX  
XX  /*
XX   *	convert integer to decimal ascii string
XX   */
XX  
XX!   register int i;
XX!   register int j;
XX!   register int aval;
XX!   char c[20];
XX  
XX!   aval = abs(value);
XX!   c[0] = EOS;
XX!   i = 1;
XX!   do {
XX! 	c[i++] = (aval % 10) + '0';
XX! 	aval /= 10;
XX  
XX!   } while (aval > 0 && i <= size);
XX  
XX!   if (value < 0 && i <= size) c[i++] = '-';
XX!   for (j = 0; j < i; ++j) *p++ = c[i - j - 1];
XX  
XX!   return(i);
XX  }
XX  
XX  
XX***************
XX*** 424,608 ****
XX  /*------------------------------*/
XX  /*	itoROMAN		*/
XX  /*------------------------------*/
XX! itoROMAN (value, p, size)
XX! int		value;
XX! register char  *p;
XX! register int	size;
XX  {
XX  
XX  /*
XX   *	convert integer to upper roman. must be positive
XX   */
XX  
XX! 	register int	i;
XX! 	register int	j;
XX! 	register int	k;
XX! 	register int	aval;
XX! 	char		c[100];
XX! 	int		rem;
XX  
XX! 	aval = abs (value);
XX! 	c[0] = EOS;
XX! 	i = 1;
XX  
XX! 	/*
XX! 	 *   trivial case:
XX! 	 */
XX! 	if (aval == 0)
XX! 	{
XX! 		c[i++] = '0';
XX! 		goto done_100;
XX! 	}
XX  
XX! 	/*
XX! 	 *   temporarily mod 100...
XX! 	 */
XX! 	aval = aval % 100;
XX  
XX! 	if (aval > 0)
XX! 	{
XX! 		/*
XX! 		 *   build backward
XX! 		 *
XX! 		 *   | I|		1
XX! 		 *   | II|		2
XX! 		 *   | III|		3
XX! 		 *   | VI|		4
XX! 		 *   | V|		5
XX! 		 *   | IV|		6
XX! 		 *   | IIV|		7
XX! 		 *   | IIIV|		8
XX! 		 *   | XI|		9
XX! 		 *   | X|		0
XX! 		 *   | IX|		11
XX! 		 *   | IIX|		12
XX! 		 */
XX! 		if ((aval % 5 == 0) && (aval % 10 != 0))/* 5 */
XX! 			c[i++] = 'V';
XX! 		else
XX! 		{
XX! 			rem = aval % 10;
XX! 			if (rem == 9)			/* 9 */
XX! 			{
XX! 				c[i++] = 'X';
XX! 				c[i++] = 'I';
XX! 			}
XX! 			else if (rem == 8)		/* 8 */
XX! 			{
XX! 				c[i++] = 'I';
XX! 				c[i++] = 'I';
XX! 				c[i++] = 'I';
XX! 				c[i++] = 'V';
XX! 			}
XX! 			else if (rem == 7)		/* 7 */
XX! 			{
XX! 				c[i++] = 'I';
XX! 				c[i++] = 'I';
XX! 				c[i++] = 'V';
XX! 			}
XX! 			else if (rem == 6)		/* 6 */
XX! 			{
XX! 				c[i++] = 'I';
XX! 				c[i++] = 'V';
XX! 			}
XX! 			else if (rem == 4)		/* 4 */
XX! 			{
XX! 				c[i++] = 'V';
XX! 				c[i++] = 'I';
XX! 			}
XX! 			else				/* 3,2,1 */
XX! 			{
XX! 				for (j = 0; j < rem; j++)
XX! 					c[i++] = 'I';
XX! 			}
XX! 		}
XX! 
XX! 		aval /= 10;
XX! 		if (aval == 0)
XX! 			goto done_100;
XX! 
XX  		rem = aval % 10;
XX! 		if (rem == 4)
XX! 		{
XX! 			c[i++] = 'L';
XX  			c[i++] = 'X';
XX  		}
XX- 		else if (rem == 5)
XX- 		{
XX- 			c[i++] = 'L';
XX- 		}
XX- 		else if (rem < 4)
XX- 		{
XX- 			for (j = 0; j < rem; j++)
XX- 				c[i++] = 'X';
XX- 		}
XX- 		else
XX- 		{
XX- 			for (j = 0; j < rem - 5; j++)
XX- 				c[i++] = 'X';
XX- 			c[i++] = 'L';
XX- 		}
XX  	}
XX  
XX  
XX  done_100:
XX! 	/*
XX! 	 *   divide by 100 (they are done) and temp mod by another 10
XX! 	 */
XX! 	aval  = abs (value);
XX! 	aval /= 100;
XX  
XX! 	if (aval > 0)
XX! 	{
XX! 		rem  = aval % 10;
XX! 		if (rem == 4)
XX! 		{
XX! 			c[i++] = 'D';
XX! 			c[i++] = 'C';
XX! 		}
XX! 		if (rem == 5)
XX! 		{
XX! 			c[i++] = 'D';
XX! 		}
XX! 		else if (rem < 4)
XX! 		{
XX! 			for (j = 0; j < rem; j++)
XX! 				c[i++] = 'C';
XX! 		}
XX! 		else if (rem == 9)
XX! 		{
XX! 			c[i++] = 'M';
XX! 			c[i++] = 'C';
XX! 		}
XX! 		else if (rem < 9)
XX! 		{
XX! 			for (j = 0; j < rem - 5; j++)
XX! 				c[i++] = 'C';
XX! 			c[i++] = 'D';
XX! 		}
XX  	}
XX  
XX! 
XX! 	aval /= 10;
XX! 
XX! 	if (aval > 0)
XX! 	{
XX! 		rem  = aval % 10;
XX! 		if (rem < 4)
XX! 		{
XX! 			for (j = 0; j < rem; j++)
XX! 				c[i++] = 'M';
XX! 		}
XX  	}
XX  
XX  
XX! 	if (value < 0)
XX! 		c[i++] = '-';
XX! 
XX! 	for (j = 0; j < i; ++j)
XX! 		*p++ = c[i - j - 1];
XX! 
XX! 	return (i);
XX  }
XX  
XX  
XX--- 359,478 ----
XX  /*------------------------------*/
XX  /*	itoROMAN		*/
XX  /*------------------------------*/
XX! int itoROMAN(value, p, size)
XX! int value;
XX! register char *p;
XX! register int size;
XX  {
XX  
XX  /*
XX   *	convert integer to upper roman. must be positive
XX   */
XX  
XX!   register int i;
XX!   register int j;
XX!   register int aval;
XX!   char c[100];
XX!   int rem;
XX  
XX!   aval = abs(value);
XX!   c[0] = EOS;
XX!   i = 1;
XX  
XX!   /* Trivial case: */
XX!   if (aval == 0) {
XX! 	c[i++] = '0';
XX! 	goto done_100;
XX!   }
XX  
XX!   /* Temporarily mod 100... */
XX!   aval = aval % 100;
XX  
XX!   if (aval > 0) {
XX! 	/* Build backward 
XX! 	 * | I|			1 | II|		2 | III|		3 |
XX! 	 * VI|			4 | V|		5 | IV|		6 | IIV|
XX! 	 * | IIIV|			8 | XI|		9 | X|		0 |
XX! 	 * IX|			11 | IIX|		12 */
XX! 	if ((aval % 5 == 0) && (aval % 10 != 0))	/* 5 */
XX! 		c[i++] = 'V';
XX! 	else {
XX  		rem = aval % 10;
XX! 		if (rem == 9) {	/* 9 */
XX  			c[i++] = 'X';
XX+ 			c[i++] = 'I';
XX+ 		} else if (rem == 8) {	/* 8 */
XX+ 			c[i++] = 'I';
XX+ 			c[i++] = 'I';
XX+ 			c[i++] = 'I';
XX+ 			c[i++] = 'V';
XX+ 		} else if (rem == 7) {	/* 7 */
XX+ 			c[i++] = 'I';
XX+ 			c[i++] = 'I';
XX+ 			c[i++] = 'V';
XX+ 		} else if (rem == 6) {	/* 6 */
XX+ 			c[i++] = 'I';
XX+ 			c[i++] = 'V';
XX+ 		} else if (rem == 4) {	/* 4 */
XX+ 			c[i++] = 'V';
XX+ 			c[i++] = 'I';
XX+ 		} else {	/* 3,2,1 */
XX+ 			for (j = 0; j < rem; j++) c[i++] = 'I';
XX  		}
XX  	}
XX  
XX+ 	aval /= 10;
XX+ 	if (aval == 0) goto done_100;
XX  
XX+ 	rem = aval % 10;
XX+ 	if (rem == 4) {
XX+ 		c[i++] = 'L';
XX+ 		c[i++] = 'X';
XX+ 	} else if (rem == 5) {
XX+ 		c[i++] = 'L';
XX+ 	} else if (rem < 4) {
XX+ 		for (j = 0; j < rem; j++) c[i++] = 'X';
XX+ 	} else {
XX+ 		for (j = 0; j < rem - 5; j++) c[i++] = 'X';
XX+ 		c[i++] = 'L';
XX+ 	}
XX+   }
XX  done_100:
XX!   /* Divide by 100 (they are done) and temp mod by another 10 */
XX!   aval = abs(value);
XX!   aval /= 100;
XX  
XX!   if (aval > 0) {
XX! 	rem = aval % 10;
XX! 	if (rem == 4) {
XX! 		c[i++] = 'D';
XX! 		c[i++] = 'C';
XX  	}
XX+ 	if (rem == 5) {
XX+ 		c[i++] = 'D';
XX+ 	} else if (rem < 4) {
XX+ 		for (j = 0; j < rem; j++) c[i++] = 'C';
XX+ 	} else if (rem == 9) {
XX+ 		c[i++] = 'M';
XX+ 		c[i++] = 'C';
XX+ 	} else if (rem < 9) {
XX+ 		for (j = 0; j < rem - 5; j++) c[i++] = 'C';
XX+ 		c[i++] = 'D';
XX+ 	}
XX+   }
XX+   aval /= 10;
XX  
XX!   if (aval > 0) {
XX! 	rem = aval % 10;
XX! 	if (rem < 4) {
XX! 		for (j = 0; j < rem; j++) c[i++] = 'M';
XX  	}
XX+   }
XX+   if (value < 0) c[i++] = '-';
XX  
XX+   for (j = 0; j < i; ++j) *p++ = c[i - j - 1];
XX  
XX!   return(i);
XX  }
XX  
XX  
XX***************
XX*** 611,642 ****
XX  /*------------------------------*/
XX  /*	itoroman		*/
XX  /*------------------------------*/
XX! itoroman (value, p, size)
XX! int     value;
XX! char   *p;
XX! int     size;
XX  {
XX  
XX  /*
XX   *	convert integer to lower roman
XX   */
XX  
XX! 	register int	i;
XX! 	register int	len;
XX! 	register int	aval;
XX! 	char		c[100];
XX  
XX! 	c[0] = EOS;
XX! 	len = itoROMAN (value, c, size);
XX  
XX! 	for (i = 0; i < len; i++)
XX! 	{
XX! 		p[i] = c[i];
XX! 		if (isalpha (p[i]))
XX! 			p[i] = tolower (c[i]);
XX! 	}
XX  
XX! 	return (len);
XX  }
XX  
XX  
XX--- 481,509 ----
XX  /*------------------------------*/
XX  /*	itoroman		*/
XX  /*------------------------------*/
XX! int itoroman(value, p, size)
XX! int value;
XX! char *p;
XX! int size;
XX  {
XX  
XX  /*
XX   *	convert integer to lower roman
XX   */
XX  
XX!   register int i;
XX!   register int len;
XX!   char c[100];
XX  
XX!   c[0] = EOS;
XX!   len = itoROMAN(value, c, size);
XX  
XX!   for (i = 0; i < len; i++) {
XX! 	p[i] = c[i];
XX! 	if (isalpha(p[i])) p[i] = tolower(c[i]);
XX!   }
XX  
XX!   return(len);
XX  }
XX  
XX  
XX***************
XX*** 645,705 ****
XX  /*------------------------------*/
XX  /*	itoLETTER		*/
XX  /*------------------------------*/
XX! itoLETTER (value, p, size)
XX! int		value;
XX! register char  *p;
XX! register int	size;
XX  {
XX  
XX  /*
XX   *	convert integer to upper letter value: 0,A,B,C,...,AA,AB,AC,...
XX   */
XX  
XX! 	register int	i;
XX! 	register int	j;
XX! 	register int	k;
XX! 	register int	aval;
XX! 	int		rem;
XX! 	char		c[20];
XX  
XX! 	aval = abs (value);
XX! 	c[0] = EOS;
XX! 	i = 1;
XX  
XX! 	/*
XX! 	 *   1 based:
XX! 	 *
XX! 	 *   0	0
XX! 	 *   1	A
XX! 	 *   25	Z
XX! 	 *   26	AA
XX! 	 *   51 AZ
XX! 	 *   52 AAA
XX! 	 *   ...
XX! 	 */
XX! 	if (aval == 0)
XX! 		c[i++] = '0';
XX! 	else if (aval < 27)
XX! 	{
XX! 		c[i++] = aval - 1 + 'A';
XX! 	}
XX! 	else
XX! 	{
XX! 		do
XX! 		{
XX! 			c[i++] = ((aval - 1) % 26) + 'A';
XX! 			aval = (aval - 1)  / 26;
XX! 	
XX! 		} while (aval > 0 && i <= size);
XX! 	}
XX  
XX! 	if (value < 0 && i <= size)
XX! 		c[i++] = '-';
XX  
XX! 	for (j = 0; j < i; ++j)
XX! 		*p++ = c[i - j - 1];
XX  
XX! 	return (i);
XX  }
XX  
XX  
XX--- 512,555 ----
XX  /*------------------------------*/
XX  /*	itoLETTER		*/
XX  /*------------------------------*/
XX! int itoLETTER(value, p, size)
XX! int value;
XX! register char *p;
XX! register int size;
XX  {
XX  
XX  /*
XX   *	convert integer to upper letter value: 0,A,B,C,...,AA,AB,AC,...
XX   */
XX  
XX!   register int i;
XX!   register int j;
XX!   register int aval;
XX!   char c[20];
XX  
XX!   aval = abs(value);
XX!   c[0] = EOS;
XX!   i = 1;
XX  
XX!   /* 1 based: 
XX!    * 0	0 1	A 25	Z 26	AA 51 AZ 52 AAA ... */
XX!   if (aval == 0)
XX! 	c[i++] = '0';
XX!   else if (aval < 27) {
XX! 	c[i++] = aval - 1 + 'A';
XX!   } else {
XX! 	do {
XX! 		c[i++] = ((aval - 1) % 26) + 'A';
XX! 		aval = (aval - 1) / 26;
XX  
XX! 	} while (aval > 0 && i <= size);
XX!   }
XX  
XX!   if (value < 0 && i <= size) c[i++] = '-';
XX  
XX!   for (j = 0; j < i; ++j) *p++ = c[i - j - 1];
XX! 
XX!   return(i);
XX  }
XX  
XX  
XX***************
XX*** 707,767 ****
XX  /*------------------------------*/
XX  /*	itoletter		*/
XX  /*------------------------------*/
XX! itoletter (value, p, size)
XX! int		value;
XX! register char  *p;
XX! register int	size;
XX  {
XX  
XX  /*
XX   *	convert integer to upper letter value: 0,a,b,c,...,aa,ab,ac,...
XX   */
XX  
XX! 	register int	i;
XX! 	register int	j;
XX! 	register int	k;
XX! 	register int	aval;
XX! 	char		c[20];
XX! 	int		rem;
XX  
XX! 	aval = abs (value);
XX! 	c[0] = EOS;
XX! 	i = 1;
XX  
XX! 	/*
XX! 	 *   1 based:
XX! 	 *
XX! 	 *   0	0
XX! 	 *   1	A
XX! 	 *   25	Z
XX! 	 *   26	AA
XX! 	 *   51 AZ
XX! 	 *   52 AAA
XX! 	 *   ...
XX! 	 */
XX! 	if (aval == 0)
XX! 		c[i++] = '0';
XX! 	else if (aval < 27)
XX! 	{
XX! 		c[i++] = aval - 1 + 'a';
XX! 	}
XX! 	else
XX! 	{
XX! 		do
XX! 		{
XX! 			c[i++] = ((aval - 1) % 26) + 'a';
XX! 			aval = (aval - 1)  / 26;
XX! 	
XX! 		} while (aval > 0 && i <= size);
XX! 	}
XX  
XX! 	if (value < 0 && i <= size)
XX! 		c[i++] = '-';
XX  
XX! 	for (j = 0; j < i; ++j)
XX! 		*p++ = c[i - j - 1];
XX  
XX! 	return (i);
XX  }
XX  
XX  
XX--- 557,600 ----
XX  /*------------------------------*/
XX  /*	itoletter		*/
XX  /*------------------------------*/
XX! int itoletter(value, p, size)
XX! int value;
XX! register char *p;
XX! register int size;
XX  {
XX  
XX  /*
XX   *	convert integer to upper letter value: 0,a,b,c,...,aa,ab,ac,...
XX   */
XX  
XX!   register int i;
XX!   register int j;
XX!   register int aval;
XX!   char c[20];
XX  
XX!   aval = abs(value);
XX!   c[0] = EOS;
XX!   i = 1;
XX  
XX!   /* 1 based: 
XX!    * 0	0 1	A 25	Z 26	AA 51 AZ 52 AAA ... */
XX!   if (aval == 0)
XX! 	c[i++] = '0';
XX!   else if (aval < 27) {
XX! 	c[i++] = aval - 1 + 'a';
XX!   } else {
XX! 	do {
XX! 		c[i++] = ((aval - 1) % 26) + 'a';
XX! 		aval = (aval - 1) / 26;
XX  
XX! 	} while (aval > 0 && i <= size);
XX!   }
XX  
XX!   if (value < 0 && i <= size) c[i++] = '-';
XX  
XX!   for (j = 0; j < i; ++j) *p++ = c[i - j - 1];
XX! 
XX!   return(i);
XX  }
XX  
XX  
XX***************
XX*** 774,789 ****
XX  #undef min
XX  #endif
XX  
XX! min (v1, v2)
XX! register int	v1;
XX! register int	v2;
XX  {
XX  
XX  /*
XX   *	find minimum of two integer ONLY
XX   */
XX  
XX! 	return ((v1 < v2) ? v1 : v2);
XX  }
XX  
XX  
XX--- 607,622 ----
XX  #undef min
XX  #endif
XX  
XX! int min(v1, v2)
XX! register int v1;
XX! register int v2;
XX  {
XX  
XX  /*
XX   *	find minimum of two integer ONLY
XX   */
XX  
XX!   return((v1 < v2) ? v1 : v2);
XX  }
XX  
XX  
XX***************
XX*** 798,813 ****
XX  #undef max
XX  #endif
XX  
XX! max (v1, v2)
XX! register int	v1;
XX! register int	v2;
XX  {
XX  
XX  /*
XX   *	find maximum of two integers ONLY
XX   */
XX  
XX! 	return ((v1 > v2) ? v1 : v2);
XX  }
XX  
XX  
XX--- 631,646 ----
XX  #undef max
XX  #endif
XX  
XX! int max(v1, v2)
XX! register int v1;
XX! register int v2;
XX  {
XX  
XX  /*
XX   *	find maximum of two integers ONLY
XX   */
XX  
XX!   return((v1 > v2) ? v1 : v2);
XX  }
XX  
XX  
XX***************
XX*** 817,823 ****
XX  /*------------------------------*/
XX  /*	err_exit		*/
XX  /*------------------------------*/
XX! err_exit (code)
XX  {
XX  
XX  /*
XX--- 650,657 ----
XX  /*------------------------------*/
XX  /*	err_exit		*/
XX  /*------------------------------*/
XX! void err_exit(code)
XX! int code;
XX  {
XX  
XX  /*
XX***************
XX*** 825,858 ****
XX   *	exit.
XX   */
XX  
XX! 	if (err_stream != stderr && err_stream != (FILE *) 0)
XX! 	{
XX! 		/*
XX! 		 *   not going to stderr (-o file)
XX! 		 */
XX! 		fflush (err_stream);
XX! 		fclose (err_stream);
XX! 	}
XX! 	if (debugging && dbg_stream != stderr && dbg_stream != (FILE *) 0)
XX! 	{
XX! 		fflush (dbg_stream);
XX! 		fclose (dbg_stream);
XX! 	}
XX! 	if (out_stream != stdout && out_stream != (FILE *) 0)
XX! 	{
XX! 		/*
XX! 		 *   not going to stdout (-l)
XX! 		 */
XX! 		fflush (out_stream);
XX! 		fclose (out_stream);
XX! 	}
XX! 
XX! 	if (hold_screen)
XX! 	{
XX! 		wait_for_char ();
XX! 	}
XX! 
XX! 	exit (code);
XX  }
XX  
XX  
XX--- 659,682 ----
XX   *	exit.
XX   */
XX  
XX!   if (err_stream != stderr && err_stream != (FILE *) 0) {
XX! 	/* Not going to stderr (-o file) */
XX! 	fflush(err_stream);
XX! 	fclose(err_stream);
XX!   }
XX!   if (debugging && dbg_stream != stderr && dbg_stream != (FILE *) 0) {
XX! 	fflush(dbg_stream);
XX! 	fclose(dbg_stream);
XX!   }
XX!   if (out_stream != stdout && out_stream != (FILE *) 0) {
XX! 	/* Not going to stdout (-l) */
XX! 	fflush(out_stream);
XX! 	fclose(out_stream);
XX!   }
XX!   if (hold_screen) {
XX! 	wait_for_char();
XX!   }
XX!   exit(code);
XX  }
XX  
XX  
XX***************
XX*** 860,876 ****
XX  /*------------------------------*/
XX  /*	wait_for_char		*/
XX  /*------------------------------*/
XX! #ifdef GEMDOS
XX! #include <osbind.h>
XX! #endif
XX! 
XX! wait_for_char ()
XX  {
XX- #ifdef GEMDOS
XX- 		printf ("enter any key..."); fflush (stdout);
XX- 		Cconin ();
XX- #endif
XX  }
XX- 
XX- 
XX- 
XX--- 684,689 ----
XX  /*------------------------------*/
XX  /*	wait_for_char		*/
XX  /*------------------------------*/
XX! void wait_for_char()
XX  {
XX  }
X/
Xecho x - macros.c.d
Xsed '/^X/s///' > macros.c.d << '/'
XX*** /home/top/ast/minix/1.5/commands/nroff/macros.c  crc=31508   9430	Sat Apr 21 22:27:21 1990
XX--- /home/top/ast/minix/1.6.25/commands/nroff/macros.c  crc=20780   8249	Mon Nov 23 12:19:53 1992
XX***************
XX*** 1,29 ****
XX! /*
XX!  *	macros.c - macro input/output processing for nroff word processor
XX!  *
XX!  *	adapted for atariST/TOS by Bill Rosenkranz 11/89
XX!  *	net:	rosenkra@hall.cray.com
XX!  *	CIS:	71460,17
XX!  *	GENIE:	W.ROSENKRANZ
XX!  *
XX!  *	original author:
XX!  *
XX!  *	Stephen L. Browning
XX!  *	5723 North Parker Avenue
XX!  *	Indianapolis, Indiana 46220
XX!  *
XX!  *	history:
XX!  *
XX!  *	- Originally written in BDS C;
XX!  *	- Adapted for standard C by W. N. Paul
XX!  *	- Heavily hacked up to conform to "real" nroff by Bill Rosenkranz
XX!  *	- Changed array index i from type long to type int (32000 is the
XX!  *	  largest value anyhow) to prevent compiler warnings
XX!  *	  by Wim 'Blue Baron' van Dorst (wsincc@tuerc3.urc.tue.nl)
XX!  */
XX  
XX- #undef NRO_MAIN					/* extern globals */
XX- 
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX--- 1,5 ----
XX! /* macros.c - macro input/output processing for nroff word processor */
XX  
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX***************
XX*** 32,40 ****
XX  /*------------------------------*/
XX  /*	defmac			*/
XX  /*------------------------------*/
XX! defmac (p, infp)
XX! register char  *p;
XX! FILE	       *infp;
XX  {
XX  
XX  /*
XX--- 8,16 ----
XX  /*------------------------------*/
XX  /*	defmac			*/
XX  /*------------------------------*/
XX! void defmac(p, infp)
XX! register char *p;
XX! FILE *infp;
XX  {
XX  
XX  /*
XX***************
XX*** 54,165 ****
XX   *	putmac, after colmac...
XX   */
XX  
XX! 	register char  *q;
XX! 	register int	i;
XX! 	char    	name[MNLEN];
XX! 	char    	defn[MXMLEN];
XX! 	char		newend[10];
XX  
XX  
XX! 	/*
XX! 	 *   skip the .de and get to the name...
XX! 	 */
XX! 	q = skipwd (p);
XX! 	q = skipbl (q);
XX  
XX! 	/*
XX! 	 *   ok, name now holds the name. make sure it is valid (i.e. first
XX! 	 *   char is alpha...). getwrd returns the length of the word.
XX! 	 */
XX! 	i = getwrd (q, name);
XX! 	if (!isprint (*name))
XX! 	{
XX! 		fprintf (err_stream,
XX! 			"***%s: missing or illegal macro definition name\n",
XX! 			myname);
XX! 		err_exit (-1);
XX! 	}
XX  
XX! 	/*
XX! 	 *   truncate to 2 char max name.
XX! 	 */
XX! 	if (i > 2)
XX! 		name[2] = EOS;
XX  
XX  
XX! 	/*
XX! 	 *   skip the name and see if we have a new end defined...
XX! 	 */
XX! 	q = skipwd (p);
XX! 	q = skipbl (q);
XX! 	for (i = 0; i < 10; i++)
XX! 		newend[i] = EOS;
XX  
XX! 	for (i = 0; (i < 10) && ( isalpha (q[i]) || isdigit (q[i]) ); i++)
XX! 	{
XX! 		newend[i] = q[i];
XX! 	}
XX  
XX  
XX  
XX! 	/*
XX! 	 *   read a line from input stream until we get the end of macro
XX! 	 *   command (.en or ..). actually. we should have read the next
XX! 	 *   field just above here to get the .de NA . or .de NA en string
XX! 	 *   to be new end of macro.
XX! 	 */
XX! 	i = 0;
XX! 	while (getlin (p, infp) != EOF)
XX! 	{
XX! 		if (p[0] == dc.cmdchr && newend[0] != EOS
XX! 		&&  p[1] == newend[0] && p[2] == newend[1])
XX! 		{
XX! 			/*
XX! 			 *   replacement end found
XX! 			 */
XX! 			break;
XX! 		}
XX! 		if (p[0] == dc.cmdchr && p[1] == 'e' && p[2] == 'n')
XX! 		{
XX! 			/*
XX! 			 *   .en found
XX! 			 */
XX! 			break;
XX! 		}
XX! 		if (p[0] == dc.cmdchr && p[1] == dc.cmdchr)
XX! 		{
XX! 			/*
XX! 			 *   .. found
XX! 			 */
XX! 			break;
XX! 		}
XX  
XX! 
XX! 		/*
XX! 		 *   collect macro from the line we just read. all this does
XX! 		 *   is put it in the string defn.
XX! 		 */
XX! 		if ((i = colmac (p, defn, i)) == ERR)
XX! 		{
XX! 			fprintf (err_stream,
XX! 				"***%s: macro definition too long\n", myname);
XX! 			err_exit (-1);
XX! 		}
XX  	}
XX  
XX  
XX! 	/*
XX! 	 *   store the macro
XX! 	 */
XX! 	if (!ignoring)
XX! 	{
XX! 		if (putmac (name, defn) == ERR)
XX! 		{
XX! 			fprintf (err_stream,
XX! 				"***%s: macro definition table full\n", myname);
XX! 			err_exit (-1);
XX! 		}
XX  	}
XX  }
XX  
XX  
XX--- 30,109 ----
XX   *	putmac, after colmac...
XX   */
XX  
XX!   register char *q;
XX!   register int i;
XX!   char name[MNLEN];
XX!   char defn[MXMLEN];
XX!   char newend[10];
XX  
XX  
XX!   /* Skip the .de and get to the name... */
XX!   q = skipwd(p);
XX!   q = skipbl(q);
XX  
XX!   /* Ok, name now holds the name. make sure it is valid (i.e. first
XX!    * char is alpha...). getwrd returns the length of the word. */
XX!   i = getwrd(q, name);
XX!   if (!isprint(*name)) {
XX! 	fprintf(err_stream,
XX! 		"***%s: missing or illegal macro definition name\n",
XX! 		myname);
XX! 	err_exit(-1);
XX!   }
XX  
XX!   /* Truncate to 2 char max name. */
XX!   if (i > 2) name[2] = EOS;
XX  
XX  
XX!   /* Skip the name and see if we have a new end defined... */
XX!   q = skipwd(p);
XX!   q = skipbl(q);
XX!   for (i = 0; i < 10; i++) newend[i] = EOS;
XX  
XX!   for (i = 0; (i < 10) && (isalpha(q[i]) || isdigit(q[i])); i++) {
XX! 	newend[i] = q[i];
XX!   }
XX  
XX  
XX  
XX!   /* Read a line from input stream until we get the end of macro
XX!    * command (.en or ..). actually. we should have read the next field
XX!    * just above here to get the .de NA . or .de NA en string to be new
XX!    * end of macro. */
XX!   i = 0;
XX!   while (getlin(p, infp) != EOF) {
XX! 	if (p[0] == dc.cmdchr && newend[0] != EOS
XX! 	    && p[1] == newend[0] && p[2] == newend[1]) {
XX! 		/* Replacement end found */
XX! 		break;
XX! 	}
XX! 	if (p[0] == dc.cmdchr && p[1] == 'e' && p[2] == 'n') {
XX! 		/* .en found */
XX! 		break;
XX! 	}
XX! 	if (p[0] == dc.cmdchr && p[1] == dc.cmdchr) {
XX! 		/* .. found */
XX! 		break;
XX! 	}
XX  
XX! 	/* Collect macro from the line we just read. all this does is
XX! 	 * put it in the string defn. */
XX! 	if ((i = colmac(p, defn, i)) == ERR) {
XX! 		fprintf(err_stream,
XX! 		      "***%s: macro definition too long\n", myname);
XX! 		err_exit(-1);
XX  	}
XX+   }
XX  
XX  
XX!   /* Store the macro */
XX!   if (!ignoring) {
XX! 	if (putmac(name, defn) == ERR) {
XX! 		fprintf(err_stream,
XX! 		    "***%s: macro definition table full\n", myname);
XX! 		err_exit(-1);
XX  	}
XX+   }
XX  }
XX  
XX  
XX***************
XX*** 169,195 ****
XX  /*------------------------------*/
XX  /*	colmac			*/
XX  /*------------------------------*/
XX! colmac (p, d, i)
XX! register char  *p;
XX! char	       *d;
XX! register int	i;
XX  {
XX  
XX  /*
XX   *	Collect macro definition from input stream
XX   */
XX  
XX! 	while (*p != EOS)
XX! 	{
XX! 		if (i >= MXMLEN - 1)
XX! 		{
XX! 			d[i - 1] = EOS;
XX! 			return (ERR);
XX! 		}
XX! 		d[i++] = *p++;
XX  	}
XX! 	d[i] = EOS;
XX! 	return (i);
XX  }
XX  
XX  
XX--- 113,137 ----
XX  /*------------------------------*/
XX  /*	colmac			*/
XX  /*------------------------------*/
XX! int colmac(p, d, i)
XX! register char *p;
XX! char *d;
XX! register int i;
XX  {
XX  
XX  /*
XX   *	Collect macro definition from input stream
XX   */
XX  
XX!   while (*p != EOS) {
XX! 	if (i >= MXMLEN - 1) {
XX! 		d[i - 1] = EOS;
XX! 		return(ERR);
XX  	}
XX! 	d[i++] = *p++;
XX!   }
XX!   d[i] = EOS;
XX!   return(i);
XX  }
XX  
XX  
XX***************
XX*** 199,207 ****
XX  /*------------------------------*/
XX  /*	putmac			*/
XX  /*------------------------------*/
XX! putmac (name, p)
XX! char   *name;
XX! char   *p;
XX  {
XX  
XX  /*
XX--- 141,149 ----
XX  /*------------------------------*/
XX  /*	putmac			*/
XX  /*------------------------------*/
XX! int putmac(name, p)
XX! char *name;
XX! char *p;
XX  {
XX  
XX  /*
XX***************
XX*** 212,260 ****
XX   */
XX  
XX  
XX! 	/*
XX! 	 *   any room left? (did we exceed max number of possible macros)
XX! 	 */
XX! 	if (mac.lastp >= MXMDEF)
XX! 		return (ERR);
XX  
XX! 	/*
XX! 	 *   will new one fit in big buffer?
XX! 	 */
XX! 	if (mac.emb + strlen (name) + strlen (p) + 1 > &mac.mb[MACBUF])
XX! 	{
XX! 		return (ERR);
XX! 	}
XX  
XX  
XX! 	/*
XX! 	 *   add it...
XX! 	 *
XX! 	 *   bump counter, set ptr to name, copy name, copy def.
XX! 	 *   finally increment end of macro buffer ptr (emb).
XX! 	 *
XX! 	 *   macro looks like this in mb:
XX! 	 *
XX! 	 *	mac.mb[MACBUF]		size of total buf
XX! 	 *	lastp < MXMDEF		number of macros possible
XX! 	 *	*mnames[MXMDEF]		-> names, each max length
XX! 	 *	..._____________________________...____________________...
XX! 	 *	    / / /|X|X|0|macro definition      |0| / / / / / / /
XX! 	 *	.../_/_/_|_|_|_|________________...___|_|/_/_/_/_/_/_/_...
XX! 	 *		  ^
XX! 	 *		  |
XX! 	 *		  \----- mac.mnames[mac.lastp] points here
XX! 	 *
XX! 	 *   both the 2 char name (XX) and the descripton are null term and
XX! 	 *   follow one after the other.
XX! 	 */
XX! 	++mac.lastp;
XX! 	mac.mnames[mac.lastp] = mac.emb;
XX! 	strcpy (mac.emb, name);
XX! 	strcpy (mac.emb + strlen (name) + 1, p);
XX! 	mac.emb += strlen (name) + strlen (p) + 2;
XX! 
XX! 	return (OK);
XX  }
XX  
XX  
XX--- 154,190 ----
XX   */
XX  
XX  
XX!   /* Any room left? (did we exceed max number of possible macros) */
XX!   if (mac.lastp >= MXMDEF) return(ERR);
XX  
XX!   /* Will new one fit in big buffer? */
XX!   if (mac.emb + strlen(name) + strlen(p) + 1 > &mac.mb[MACBUF]) {
XX! 	return(ERR);
XX!   }
XX  
XX+   /* Add it... 
XX+    * bump counter, set ptr to name, copy name, copy def. finally increment
XX+    * end of macro buffer ptr (emb).
XX+    * 
XX+    * macro looks like this in mb:
XX+    * 
XX+    * mac.mb[MACBUF]		size of total buf lastp < MXMDEF
XX+    * umber of macros possible *mnames[MXMDEF]		-> names,
XX+    * each max length
XX+    * ..._____________________________...____________________... / /
XX+    * /|X|X|0|macro definition      |0| / / / / / / /
XX+    * .../_/_/_|_|_|_|________________...___|_|/_/_/_/_/_/_/_... ^ |
XX+    * \----- mac.mnames[mac.lastp] points here
XX+    * 
XX+    * both the 2 char name (XX) and the descripton are null term and follow
XX+    * one after the other. */
XX+   ++mac.lastp;
XX+   mac.mnames[mac.lastp] = mac.emb;
XX+   strcpy(mac.emb, name);
XX+   strcpy(mac.emb + strlen(name) + 1, p);
XX+   mac.emb += strlen(name) + strlen(p) + 2;
XX  
XX!   return(OK);
XX  }
XX  
XX  
XX***************
XX*** 265,309 ****
XX  /*------------------------------*/
XX  /*	getmac			*/
XX  /*------------------------------*/
XX! char   *getmac (name)
XX! register char  *name;
XX  {
XX  
XX  /*
XX   *	Get (lookup) macro definition from namespace
XX   */
XX  
XX! 	register int	i;
XX  
XX! 	/*
XX! 	 *   loop for all macros, starting with last one
XX! 	 */
XX! 	for (i = mac.lastp; i >= 0; --i)
XX! 	{
XX! 		/*
XX! 		 *   is this REALLY a macro?
XX! 		 */
XX! 		if (mac.mnames[i])
XX! 		{
XX! 			/*
XX! 			 *   if it compares, return a ptr to it
XX! 			 */
XX! 			if (!strcmp (name, mac.mnames[i]))
XX! 			{
XX  /*!!!debug			puts (mac.mnames[i]);*/
XX  
XX! 				if (mac.mnames[i][1] == EOS)
XX! 					return (mac.mnames[i] + 2);
XX! 				else
XX! 					return (mac.mnames[i] + 3);
XX! 			}
XX  		}
XX  	}
XX  
XX! 	/*
XX! 	 *   none found, return null
XX! 	 */
XX! 	return (NULL_CPTR);
XX  }
XX  
XX  
XX--- 195,228 ----
XX  /*------------------------------*/
XX  /*	getmac			*/
XX  /*------------------------------*/
XX! char *getmac(name)
XX! register char *name;
XX  {
XX  
XX  /*
XX   *	Get (lookup) macro definition from namespace
XX   */
XX  
XX!   register int i;
XX  
XX!   /* Loop for all macros, starting with last one */
XX!   for (i = mac.lastp; i >= 0; --i) {
XX! 	/* Is this REALLY a macro? */
XX! 	if (mac.mnames[i]) {
XX! 		/* If it compares, return a ptr to it */
XX! 		if (!strcmp(name, mac.mnames[i])) {
XX  /*!!!debug			puts (mac.mnames[i]);*/
XX  
XX! 			if (mac.mnames[i][1] == EOS)
XX! 				return(mac.mnames[i] + 2);
XX! 			else
XX! 				return(mac.mnames[i] + 3);
XX  		}
XX  	}
XX+   }
XX  
XX!   /* None found, return null */
XX!   return(NULL_CPTR);
XX  }
XX  
XX  
XX***************
XX*** 314,455 ****
XX  /*------------------------------*/
XX  /*	maceval			*/
XX  /*------------------------------*/
XX! maceval (p, m)
XX! register char  *p;
XX! char	       *m;
XX  {
XX  
XX  /*
XX   *	Evaluate macro expansion
XX   */
XX  
XX! 	register int	i;
XX! 	register int	j;
XX! 	char	       *argp[15];
XX! 	char		c;
XX! 	int		xc;
XX  
XX  
XX  
XX! 	/*
XX! 	 *   replace command char with EOS
XX! 	 */
XX! 	*p++ = EOS;
XX  
XX  
XX! 	/* 
XX! 	 *   initialize argp array to substitute command
XX! 	 *   string for any undefined argument
XX! 	 *
XX! 	 *	NO!!! this is fixed...
XX! 	 */
XX  /*	for (i = 0; i < 10; ++i)
XX! 		argp[i] = p;
XX  */
XX! 	/*
XX! 	 *   skip the command name
XX! 	 */
XX! 	p = skipwd (p);
XX! 	*p++ = EOS;
XX  
XX  
XX! 	/*
XX! 	 *   loop for all $n variables...
XX! 	 */
XX! 	for (i = 0; i < 10; ++i)
XX! 	{
XX! 		/*
XX! 		 *   get to substituted param and if no more, reset remaining
XX! 		 *   args to NULL and stop. using "i" here IS ok...
XX! 		 */
XX! 		p = skipbl (p);
XX! 		if (*p == '\r' || *p == '\n' || *p == EOS)
XX! 		{
XX! 			set_ireg (".$", i, 0);
XX! 			for ( ; i < 10; i++)
XX! 			{
XX! 				argp[i] = NULL_CPTR;
XX! 			}
XX! 			break;
XX  		}
XX  
XX! 
XX! 		/*
XX! 		 *   ...otherwise, see if this param is quoted. if it is,
XX! 		 *   it is all one parameter, even with blanks (but not
XX! 		 *   newlines...). look for another "c" (which is the quote).
XX! 		 *
XX! 		 *   if no quote, just read the arg as a single word and null
XX! 		 *   terminate it.
XX! 		 */
XX! 		if (*p == '\'' || *p == '"')
XX! 		{
XX! 			c = *p++;
XX! 			argp[i] = p;
XX! 			while (*p != c && *p != '\r' && *p != '\n' && *p != EOS)
XX! 				++p;
XX! 			*p++ = EOS;
XX! 		}
XX! 		else
XX! 		{
XX! 			argp[i] = p;
XX! 			p = skipwd (p);
XX! 			*p++ = EOS;
XX! 		}
XX  	}
XX  
XX  
XX! 	/*
XX! 	 *   m contains text of the macro. p contained the input line.
XX! 	 *   here we start at the end of the macro def and see if there
XX! 	 *   are any $n thingies. go backwards.
XX! 	 */
XX! 	for (i = strlen (m) - 1; i >= 0; --i)
XX! 	{
XX! 		/*
XX! 		 *   found a $.
XX! 		 */
XX! 		if (i > 0 && m[i - 1] == '$')
XX! 		{
XX! 			if (!isdigit (m[i]))
XX! 			{
XX! 				/*
XX! 				 *   it wasn't a numeric replacement arg so
XX! 				 *   push this char back onto input stream
XX! 				 */
XX! 				putbak (m[i]);
XX! 			}
XX! 			else
XX! 			{
XX! 				/*
XX! 				 *   it WAS a numeric replacement arg. so we
XX! 				 *   want to push back the appropriate macro
XX! 				 *   invocation arg. m[i]-'0' is the numerical
XX! 				 *   value of the $1 thru $9. if the arg is
XX! 				 *   not there, argp[n] will be (char *) 0
XX! 				 *   and pbstr will do nothing.
XX! 				 */
XX! 				xc = m[i] - '1';
XX! 				if (argp[xc])
XX! 					pbstr (argp[xc]);
XX! 				--i;
XX! 			}
XX  		}
XX! 		else
XX! 		{
XX! 			/*
XX! 			 *   no $ so push back the char...
XX! 			 */
XX! 			putbak (m[i]);
XX! 		}
XX  	}
XX  
XX! 	/*
XX! 	 *   at this point, the iobuf will hold the new macro command, full
XX! 	 *   expanded for $n things. the return gets us right back to the
XX! 	 *   main loop in main() and we parse the (new) command just as if
XX! 	 *   it were read from a file.
XX! 	 */
XX  
XX  }
XX  
XX--- 233,333 ----
XX  /*------------------------------*/
XX  /*	maceval			*/
XX  /*------------------------------*/
XX! void maceval(p, m)
XX! register char *p;
XX! char *m;
XX  {
XX  
XX  /*
XX   *	Evaluate macro expansion
XX   */
XX  
XX!   register int i;
XX!   char *argp[15];
XX!   char c;
XX!   int xc;
XX  
XX  
XX  
XX!   /* Replace command char with EOS */
XX!   *p++ = EOS;
XX  
XX  
XX!   /* Initialize argp array to substitute command string for any
XX!    * undefined argument
XX!    * 
XX!    * NO!!! this is fixed... */
XX  /*	for (i = 0; i < 10; ++i)
XX! 	argp[i] = p;
XX  */
XX!   /* Skip the command name */
XX!   p = skipwd(p);
XX!   *p++ = EOS;
XX  
XX  
XX!   /* Loop for all $n variables... */
XX!   for (i = 0; i < 10; ++i) {
XX! 	/* Get to substituted param and if no more, reset remaining
XX! 	 * args to NULL and stop. using "i" here IS ok... */
XX! 	p = skipbl(p);
XX! 	if (*p == '\r' || *p == '\n' || *p == EOS) {
XX! 		set_ireg(".$", i, 0);
XX! 		for (; i < 10; i++) {
XX! 			argp[i] = NULL_CPTR;
XX  		}
XX+ 		break;
XX+ 	}
XX  
XX! 	/* ...otherwise, see if this param is quoted. if it is, it is
XX! 	 * all one parameter, even with blanks (but not newlines...).
XX! 	 * look for another "c" (which is the quote).
XX! 	 * 
XX! 	 * if no quote, just read the arg as a single word and null
XX! 	 * terminate it. */
XX! 	if (*p == '\'' || *p == '"') {
XX! 		c = *p++;
XX! 		argp[i] = p;
XX! 		while (*p != c && *p != '\r' && *p != '\n' && *p != EOS) ++p;
XX! 		*p++ = EOS;
XX! 	} else {
XX! 		argp[i] = p;
XX! 		p = skipwd(p);
XX! 		*p++ = EOS;
XX  	}
XX+   }
XX  
XX  
XX!   /* M contains text of the macro. p contained the input line. here we
XX!    * start at the end of the macro def and see if there are any $n
XX!    * thingies. go backwards. */
XX!   for (i = strlen(m) - 1; i >= 0; --i) {
XX! 	/* Found a $. */
XX! 	if (i > 0 && m[i - 1] == '$') {
XX! 		if (!isdigit(m[i])) {
XX! 			/* It wasn't a numeric replacement arg so
XX! 			 * push this char back onto input stream */
XX! 			putbak(m[i]);
XX! 		} else {
XX! 			/* It WAS a numeric replacement arg. so we
XX! 			 * want to push back the appropriate macro
XX! 			 * invocation arg. m[i]-'0' is the numerical
XX! 			 * value of the $1 thru $9. if the arg is not
XX! 			 * there, argp[n] will be (char *) 0 and
XX! 			 * pbstr will do nothing. */
XX! 			xc = m[i] - '1';
XX! 			if (argp[xc]) pbstr(argp[xc]);
XX! 			--i;
XX  		}
XX! 	} else {
XX! 		/* No $ so push back the char... */
XX! 		putbak(m[i]);
XX  	}
XX+   }
XX  
XX!   /* At this point, the iobuf will hold the new macro command, full
XX!    * expanded for $n things. the return gets us right back to the main
XX!    * loop in main() and we parse the (new) command just as if it were
XX!    * read from a file. */
XX  
XX  }
XX  
XX***************
XX*** 460,517 ****
XX  /*------------------------------*/
XX  /*	printmac		*/
XX  /*------------------------------*/
XX! printmac (opt)
XX! int	opt;				/* 0=name&size,1=total size,2=full */
XX  {
XX  
XX  /*
XX   *	print all macros and strings and tabulate sizes
XX   */
XX  
XX! 	register int	i;
XX! 	register long	space;
XX!  	register long	totalspace;
XX! 	register char  *pname;
XX! 	register char  *pdef;
XX  
XX  
XX! 	space      = 0L;
XX! 	totalspace = 0L;
XX  
XX! 	fflush (out_stream);
XX! 	fflush (err_stream);
XX  
XX! 	for (i = mac.lastp; i >= 0; --i)
XX! 	{
XX!  		/*
XX! 		 *   is this REALLY a macro?
XX! 		 */
XX! 		if (mac.mnames[i])
XX! 		{
XX! 			pname = (char *) (mac.mnames[i]);
XX! 			pdef  = pname + 3;
XX! 			if (*(pname + 1) == '\0')
XX! 				pdef = pname + 2;
XX  
XX! 			space       = (long) strlen (pdef);
XX! 			totalspace += space;
XX  
XX! 			switch (opt)
XX! 			{
XX! 			case 0:
XX! 				fprintf (err_stream, "%s %ld\n", pname, space);
XX! 				break;
XX! 			case 2:
XX! 				fprintf (err_stream, "%s %ld\n", pname, space);
XX! 				fprintf (err_stream, "%s\n", pdef);
XX! 				break;
XX! 			case 1:
XX! 			default:
XX! 				break;
XX! 			}
XX  		}
XX  	}
XX! 	fprintf (err_stream, "Total space: %ld\n", totalspace);
XX! 	
XX! }
XX  
XX--- 338,386 ----
XX  /*------------------------------*/
XX  /*	printmac		*/
XX  /*------------------------------*/
XX! void printmac(opt)
XX! int opt;			/* 0=name&size,1=total size,2=full */
XX  {
XX  
XX  /*
XX   *	print all macros and strings and tabulate sizes
XX   */
XX  
XX!   register int i;
XX!   register long space;
XX!   register long totalspace;
XX!   register char *pname;
XX!   register char *pdef;
XX  
XX  
XX!   space = 0L;
XX!   totalspace = 0L;
XX  
XX!   fflush(out_stream);
XX!   fflush(err_stream);
XX  
XX!   for (i = mac.lastp; i >= 0; --i) {
XX! 	/* Is this REALLY a macro? */
XX! 	if (mac.mnames[i]) {
XX! 		pname = (char *) (mac.mnames[i]);
XX! 		pdef = pname + 3;
XX! 		if (*(pname + 1) == '\0') pdef = pname + 2;
XX  
XX! 		space = (long) strlen(pdef);
XX! 		totalspace += space;
XX  
XX! 		switch (opt) {
XX! 		    case 0:
XX! 			fprintf(err_stream, "%s %ld\n", pname, space);
XX! 			break;
XX! 		    case 2:
XX! 			fprintf(err_stream, "%s %ld\n", pname, space);
XX! 			fprintf(err_stream, "%s\n", pdef);
XX! 			break;
XX! 		    case 1:	default:	break;
XX  		}
XX  	}
XX!   }
XX!   fprintf(err_stream, "Total space: %ld\n", totalspace);
XX  
XX+ }
X/
Xecho x - main.c.d
Xsed '/^X/s///' > main.c.d << '/'
XX*** /home/top/ast/minix/1.5/commands/nroff/main.c  crc=30150  19894	Sat Apr 21 22:27:21 1990
XX--- /home/top/ast/minix/1.6.25/commands/nroff/main.c  crc=02300  17839	Mon Nov 23 12:19:54 1992
XX***************
XX*** 1,115 ****
XX! #include "config.h"
XX  
XX! /*
XX!  *	main.c - main for nroff word processor
XX!  *
XX!  *	similar to Unix(tm) nroff or RSX-11M RNO. adaptation of text processor
XX!  *	given in "Software Tools", Kernighan and Plauger.
XX!  *
XX!  *	adapted for atariST/TOS by Bill Rosenkranz 11/89
XX!  *	net:	rosenkra@hall.cray.com
XX!  *	CIS:	71460,17
XX!  *	GENIE:	W.ROSENKRANZ
XX!  *
XX!  *	original author:
XX!  *
XX!  *	Stephen L. Browning
XX!  *	5723 North Parker Avenue
XX!  *	Indianapolis, Indiana 46220
XX!  *
XX!  *	history:
XX!  *
XX!  *	- Originally written in BDS C;
XX!  *	- Adapted for standard C by W. N. Paul
XX!  *	- Heavily hacked up to conform to "real" nroff by Bill Rosenkranz
XX!  *	- Changed array index i from type long to type int (32000 is the
XX!  *	  largest value anyhow) to prevent compiler warnings
XX!  *	  by Wim 'Blue Baron' van Dorst (wsincc@tuerc3.urc.tue.nl)
XX!  *	- Changed termcap capabilities md/me, changed handling and
XX!  * 	  removed the unused standout references
XX!  *	  by Wim 'Blue Baron' van Dorst (wsincc@tuerc3.urc.tue.nl)
XX!  */
XX  
XX- #define NRO_MAIN			/* to define globals in nro.h */
XX- 
XX- #ifdef GEMDOS
XX- #include <sys\types.h>
XX- #include <sys\time.h>
XX- #else
XX- #include <sys/types.h>
XX- #include <time.h>
XX- #endif
XX- 
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX! 
XX! main (argc, argv)
XX! int     argc;
XX! char   *argv[];
XX  {
XX! 	register int	i;
XX! 	int		swflg;
XX! 	int		ifp = 0;
XX! 	char	       *ptmp;
XX! #ifndef GEMDOS
XX! 	char	       *pterm;
XX! 	char		capability[100];
XX! 	char	       *pcap;
XX! 	char	       *ps;
XX! #endif
XX  
XX  
XX  
XX! 	/*
XX! 	 *   set up initial flags and file descriptors
XX! 	 */
XX! 	swflg       = FALSE;
XX! 	ignoring    = FALSE;
XX! 	hold_screen = FALSE;
XX! 	debugging   = FALSE;
XX! 	stepping    = FALSE;
XX! 	out_stream  = stdout;
XX! 	err_stream  = stderr;
XX! 	dbg_stream  = stderr;
XX  
XX- 
XX- 	/*
XX- 	 *   this is for tmp files, if ever needed. it SHOULD start
XX- 	 *   out without the trailing slash. if not in env, use default
XX- 	 */
XX- 	if (ptmp = getenv ("TMPDIR"))
XX- 		strcpy (tmpdir, ptmp);
XX- 	else
XX- 		strcpy (tmpdir, ".");
XX- 
XX- 
XX- 	/*
XX- 	 *   handle terminal for \fB, \fI
XX- 	 */
XX- #ifdef GEMDOS
XX- 	/*
XX- 	 *   atari/TOS is easy...
XX- 	 */
XX- 	strcpy (s_bold, "\33p");
XX- 	strcpy (e_bold, "\33q");
XX- 	strcpy (s_italic, "\33p");
XX- 	strcpy (e_italic, "\33q");
XX- #else
XX- 	s_italic[0]   = '\0';
XX- 	e_italic[0]   = '\0';
XX- 	s_bold[0]     = '\0';
XX- 	e_bold[0]     = '\0';
XX- 	if ((pterm = getenv ("TERM"))
XX- 	&& (tgetent (termcap, pterm) == 1))
XX- 	{
XX- 		/*
XX- 		 *  termcap capabilities md/me for bold, us/ue for italic,
XX- 		 *  so/se if all else fails
XX- 		 */
XX- 		pcap = capability;
XX- 		if (ps = tgetstr ("so", &pcap))
XX- 		{
XX  /* NOTE: the termcap on my sun has padding or something in it so i just
XX     arbitarily remove it here. this is not right, but the worst that happens
XX     is you have no standout. since minix uses standard ansi escape for so,
XX--- 1,53 ----
XX! /* main.c - main for nroff word processor */
XX  
XX! #define NRO_MAIN
XX  
XX  #include <stdio.h>
XX+ #include "config.h"
XX  #include "nroff.h"
XX  
XX! int main(argc, argv)
XX! int argc;
XX! char *argv[];
XX  {
XX!   register int i;
XX!   int swflg;
XX!   int ifp = 0;
XX!   char *ptmp;
XX!   char *pterm;
XX!   char capability[100];
XX!   char *pcap;
XX!   char *ps;
XX  
XX+   /* Set up initial flags and file descriptors */
XX+   swflg = FALSE;
XX+   ignoring = FALSE;
XX+   hold_screen = FALSE;
XX+   debugging = FALSE;
XX+   stepping = FALSE;
XX+   out_stream = stdout;
XX+   err_stream = stderr;
XX+   dbg_stream = stderr;
XX  
XX+   /* This is for tmp files, if ever needed. it SHOULD start out without
XX+    * the trailing slash. if not in env, use default 
XX+    */
XX+   if (ptmp = getenv("TMPDIR"))
XX+ 	strcpy(tmpdir, ptmp);
XX+   else
XX+ 	strcpy(tmpdir, ".");
XX  
XX!   /* Handle terminal for \fB, \fI */
XX!   s_italic[0] = '\0';
XX!   e_italic[0] = '\0';
XX!   s_bold[0] = '\0';
XX!   e_bold[0] = '\0';
XX!   if ((pterm = getenv("TERM")) && (tgetent(termcap, pterm) == 1)) {
XX! 	/* Termcap capabilities md/me for bold, us/ue for italic,
XX! 	 * so/se if all else fails */
XX! 	pcap = capability;
XX! 	if (ps = tgetstr("so", &pcap)) {
XX  
XX  /* NOTE: the termcap on my sun has padding or something in it so i just
XX     arbitarily remove it here. this is not right, but the worst that happens
XX     is you have no standout. since minix uses standard ansi escape for so,
XX***************
XX*** 117,273 ****
XX     terminals so this is also not a problem for me. the right thing to do
XX     would be to use tputs() to remove the padding and write a new string
XX     but i am lazy... */
XX! 			while (*ps && *ps != 0x1B)	ps++;
XX! 			strcpy (s_italic, ps);
XX! 			strcpy (s_bold, ps);
XX! 		}
XX! 		if (ps = tgetstr ("se", &pcap))
XX! 		{
XX! 			while (*ps && *ps != 0x1B)	ps++;
XX! 			strcpy (e_italic, ps);
XX! 			strcpy (e_bold, ps);
XX! 		}
XX! 		/*
XX! 		 * Because the type faces are actually exclusive and
XX! 		 * the terminal capabilities are not the one has turn
XX! 		 * the other off before starting itself
XX! 		 */
XX! 		/* End Italic */
XX! 		if (ps = tgetstr ("ue", &pcap))
XX! 		{
XX! 			while (*ps && *ps != 0x1B)	ps++;
XX! 			strcpy (e_italic, ps);
XX! 		}
XX! 		/* End Bold */
XX! 		if (ps = tgetstr ("me", &pcap))
XX! 		{
XX! 			while (*ps && *ps != 0x1B)	ps++;
XX! 			strcpy (e_bold, ps);
XX! 		}
XX! 		/* Start Italic */
XX! 		if (ps = tgetstr ("us", &pcap))
XX! 		{
XX! 			while (*ps && *ps != 0x1B)	ps++;
XX! 			strcpy (s_italic, e_bold);
XX! 			strcat (s_italic, ps);
XX! 		}
XX! 		/* Start Bold */
XX! 		if (ps = tgetstr ("md", &pcap))
XX! 		{
XX! 			while (*ps && *ps != 0x1B)	ps++;
XX! 			strcpy (s_bold, e_italic);
XX! 			strcat (s_bold, ps);
XX! 		}
XX  	}
XX! #endif
XX  
XX  
XX  
XX! 	/*
XX! 	 *   initialize structures (defaults)
XX! 	 */
XX! 	init ();
XX  
XX! 
XX! 	/*
XX! 	 *   parse cmdline flags
XX! 	 */
XX! 	for (i = 1; i < argc; ++i)
XX! 	{
XX! 		if (*argv[i] == '-' || *argv[i] == '+')
XX! 		{
XX! 			if (pswitch (argv[i], argv[i+1], &swflg) == ERR)
XX! 				err_exit (-1);
XX! 		}
XX  	}
XX  
XX  
XX! 	/*
XX! 	 *   loop on files
XX! 	 */
XX! 	for (i = 1; i < argc; ++i)
XX! 	{
XX! 		if (*argv[i] != '-' && *argv[i] != '+')
XX! 		{
XX! 			/*
XX! 			 *   open this file...
XX! 			 */
XX! 			if ((sofile[0] = fopen (argv[i], "r")) == NULL_FPTR)
XX! 			{
XX! 				fprintf (err_stream,
XX! 					"***%s: unable to open file %s\n",
XX! 					myname, argv[i]);
XX! 				err_exit (-1);
XX! 			}
XX! 			else
XX! 			{
XX! 				/*
XX! 				 *   do it for this file...
XX! 				 */
XX! 				ifp = 1;
XX! 				profile ();
XX! 				fclose (sofile[0]);
XX! 			}
XX! 		}
XX! 		else if (*argv[i] == '-' && *(argv[i]+1) == 0)
XX! 		{
XX! 			/*
XX! 			 *   - means read stdin (anywhere in file list)
XX! 			 */
XX! 			sofile[0] = stdin;
XX  			ifp = 1;
XX! 			profile ();
XX  		}
XX! 
XX  	}
XX  
XX  
XX! 	/*
XX! 	 *   if no files, usage (should really use stdin...)
XX! 	 */
XX! 	if ((ifp == 0 && swflg == FALSE) || argc <= 1)
XX! 	{
XX! 		usage ();
XX  
XX! 		err_exit (-1);
XX! 	}
XX! 
XX! 
XX! 	/*
XX! 	 *   normal exit. this will fflush/fclose streams...
XX! 	 */
XX! 	err_exit (0);
XX  }
XX  
XX- 
XX- 
XX- 
XX  /*------------------------------*/
XX  /*	usage			*/
XX  /*------------------------------*/
XX! usage ()
XX  {
XX! 	/*
XX! 	 *   note: -l may not work correctly
XX! 	 */
XX! 	fprintf (stderr, "Usage:   %s [options] file [...]\n", myname);
XX! 	fprintf (stderr, "Options: -a        no font changes\n");
XX! 	fprintf (stderr, "         -b        backspace\n");
XX! 	fprintf (stderr, "         -d        debug mode (file: nroff.dbg)\n");
XX! #ifdef GEMDOS
XX! 	fprintf (stderr, "         -h        hold screen before desktop\n");
XX! #endif
XX! 	fprintf (stderr, "         -l        output to printer\n");
XX! 	fprintf (stderr, "         -m<name>  macro file (e.g. -man)\n");
XX! 	fprintf (stderr, "         -o file   error log file (stderr is default)\n");
XX! 	fprintf (stderr, "         -pl<n>    page length\n");
XX! 	fprintf (stderr, "         -po<n>    page offset\n");
XX! 	fprintf (stderr, "         -pn<n>    initial page number\n");
XX! 	fprintf (stderr, "         -s        step through pages\n");
XX! 	fprintf (stderr, "         -v        print version only\n");
XX! 	fprintf (stderr, "         +<n>      first page to do\n");
XX! 	fprintf (stderr, "         -<n>      last page to do\n");
XX! 	fprintf (stderr, "         -         use stdin (in file list)\n");
XX  }
XX  
XX  
XX--- 55,167 ----
XX     terminals so this is also not a problem for me. the right thing to do
XX     would be to use tputs() to remove the padding and write a new string
XX     but i am lazy... */
XX! 		while (*ps && *ps != 0x1B) ps++;
XX! 		strcpy(s_italic, ps);
XX! 		strcpy(s_bold, ps);
XX  	}
XX! 	if (ps = tgetstr("se", &pcap)) {
XX! 		while (*ps && *ps != 0x1B) ps++;
XX! 		strcpy(e_italic, ps);
XX! 		strcpy(e_bold, ps);
XX! 	}
XX  
XX+ 	/* Because the type faces are actually exclusive and the
XX+ 	 * terminal capabilities are not the one has turn the other
XX+ 	 * off before starting itself */
XX+ 	/* End Italic */
XX+ 	if (ps = tgetstr("ue", &pcap)) {
XX+ 		while (*ps && *ps != 0x1B) ps++;
XX+ 		strcpy(e_italic, ps);
XX+ 	}
XX  
XX+ 	/* End Bold */
XX+ 	if (ps = tgetstr("me", &pcap)) {
XX+ 		while (*ps && *ps != 0x1B) ps++;
XX+ 		strcpy(e_bold, ps);
XX+ 	}
XX  
XX! 	/* Start Italic */
XX! 	if (ps = tgetstr("us", &pcap)) {
XX! 		while (*ps && *ps != 0x1B) ps++;
XX! 		strcpy(s_italic, e_bold);
XX! 		strcat(s_italic, ps);
XX! 	}
XX  
XX! 	/* Start Bold */
XX! 	if (ps = tgetstr("md", &pcap)) {
XX! 		while (*ps && *ps != 0x1B) ps++;
XX! 		strcpy(s_bold, e_italic);
XX! 		strcat(s_bold, ps);
XX  	}
XX+   }
XX  
XX+   /* Initialize structures (defaults) */
XX+   init();
XX  
XX!   /* Parse cmdline flags */
XX!   for (i = 1; i < argc; ++i) {
XX! 	if (*argv[i] == '-' || *argv[i] == '+') {
XX! 		if (pswitch(argv[i], argv[i + 1], &swflg) == ERR)
XX! 			err_exit(-1);
XX! 	}
XX!   }
XX! 
XX!   /* Loop on files */
XX!   for (i = 1; i < argc; ++i) {
XX! 	if (*argv[i] != '-' && *argv[i] != '+') {
XX! 		/* Open this file... */
XX! 		if ((sofile[0] = fopen(argv[i], "r")) == NULL_FPTR) {
XX! 			fprintf(err_stream,
XX! 				"***%s: unable to open file %s\n",
XX! 				myname, argv[i]);
XX! 			err_exit(-1);
XX! 		} else {
XX! 			/* Do it for this file... */
XX  			ifp = 1;
XX! 			profile();
XX! 			fclose(sofile[0]);
XX  		}
XX! 	} else if (*argv[i] == '-' && *(argv[i] + 1) == 0) {
XX! 		/* - means read stdin (anywhere in file list) */
XX! 		sofile[0] = stdin;
XX! 		ifp = 1;
XX! 		profile();
XX  	}
XX+   }
XX  
XX+   /* If no files, usage (should really use stdin...) */
XX+   if ((ifp == 0 && swflg == FALSE) || argc <= 1) {
XX+ 	usage();
XX  
XX! 	err_exit(-1);
XX!   }
XX  
XX!   /* Normal exit. this will fflush/fclose streams... */
XX!   err_exit(0);
XX!   exit(-1);
XX  }
XX  
XX  /*------------------------------*/
XX  /*	usage			*/
XX  /*------------------------------*/
XX! void usage()
XX  {
XX!   /* Note: -l may not work correctly */
XX!   fprintf(stderr, "Usage:   %s [options] file [...]\n", myname);
XX!   fprintf(stderr, "Options: -a        no font changes\n");
XX!   fprintf(stderr, "         -b        backspace\n");
XX!   fprintf(stderr, "         -d        debug mode (file: nroff.dbg)\n");
XX!   fprintf(stderr, "         -l        output to printer\n");
XX!   fprintf(stderr, "         -m<name>  macro file (e.g. -man)\n");
XX!   fprintf(stderr, "         -o file   error log file (stderr is default)\n");
XX!   fprintf(stderr, "         -pl<n>    page length\n");
XX!   fprintf(stderr, "         -po<n>    page offset\n");
XX!   fprintf(stderr, "         -pn<n>    initial page number\n");
XX!   fprintf(stderr, "         -s        step through pages\n");
XX!   fprintf(stderr, "         -v        print version only\n");
XX!   fprintf(stderr, "         +<n>      first page to do\n");
XX!   fprintf(stderr, "         -<n>      last page to do\n");
XX!   fprintf(stderr, "         -         use stdin (in file list)\n");
XX  }
XX  
XX  
XX***************
XX*** 276,282 ****
XX  /*------------------------------*/
XX  /*	init			*/
XX  /*------------------------------*/
XX! init ()
XX  {
XX  
XX  /*
XX--- 170,176 ----
XX  /*------------------------------*/
XX  /*	init			*/
XX  /*------------------------------*/
XX! void init()
XX  {
XX  
XX  /*
XX***************
XX*** 284,706 ****
XX   */
XX  
XX  
XX! 	register int	i;
XX! 	time_t		tval;
XX! 	char	       *ctim;
XX  
XX! 	tval       = time (0L);
XX! 	dc.fill    = YES;
XX! 	dc.dofnt   = YES;
XX! 	dc.lsval   = 1;
XX! 	dc.inval   = 0;
XX! 	dc.rmval   = PAGEWIDTH - 1;
XX! 	dc.llval   = PAGEWIDTH - 1;
XX! 	dc.ltval   = PAGEWIDTH - 1;
XX! 	dc.tival   = 0;
XX! 	dc.ceval   = 0;
XX! 	dc.ulval   = 0;
XX! 	dc.cuval   = 0;
XX! 	dc.juval   = YES;
XX! 	dc.adjval  = ADJ_BOTH;
XX! 	dc.boval   = 0;
XX! 	dc.bsflg   = FALSE;
XX! 	dc.prflg   = TRUE;
XX! 	dc.sprdir  = 0;
XX! 	dc.flevel  = 0;
XX! 	dc.lastfnt = 1;
XX! 	dc.thisfnt = 1;
XX! 	dc.escon   = YES;
XX! 	dc.pgchr   = '%';
XX! 	dc.cmdchr  = '.';
XX! 	dc.escchr  = '\\';
XX! 	dc.nobrchr  = '\'';
XX! 	for (i = 0; i < 26; ++i)
XX! 		dc.nr[i] = 0;
XX! 	for (i = 0; i < 26; ++i)
XX! 		dc.nrauto[i] = 1;
XX! 	for (i = 0; i < 26; ++i)
XX! 		dc.nrfmt[i] = '1';
XX  
XX  
XX! 	/*
XX! 	 *   initialize internal regs. first zero out...
XX! 	 */
XX! 	for (i = 0; i < MAXREGS; i++)
XX! 	{
XX! 		rg[i].rname[0] = rg[i].rname[1] = rg[i].rname[2] = rg[i].rname[3] = '\0';
XX! 		rg[i].rauto = 1;
XX! 		rg[i].rval  = 0;
XX! 		rg[i].rflag = RF_READ;
XX! 		rg[i].rfmt  = '1';
XX! 	}
XX  
XX  
XX  
XX! 	/*
XX! 	 *   this should be checked...
XX! 	 */
XX! 	ctim = ctime (&tval);
XX  
XX  
XX! 	/*
XX! 	 *   predefined regs. these are read/write:
XX! 	 */
XX! 	i = 0;
XX  
XX! 	strcpy (rg[i].rname, "%");		/* current page */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "ct");		/* character type */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "dl");		/* width of last complete di */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "dn");		/* height of last complete di */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "dw");		/* day of week (1-7) */
XX! 	rg[i].rval  = 0;
XX! 	if      (!strncmp (&ctim[0], "Sun", 3))
XX! 		rg[i].rval  = 1;
XX! 	else if (!strncmp (&ctim[0], "Mon", 3))
XX! 		rg[i].rval  = 2;
XX! 	else if (!strncmp (&ctim[0], "Tue", 3))
XX! 		rg[i].rval  = 3;
XX! 	else if (!strncmp (&ctim[0], "Wed", 3))
XX! 		rg[i].rval  = 4;
XX! 	else if (!strncmp (&ctim[0], "Thu", 3))
XX! 		rg[i].rval  = 5;
XX! 	else if (!strncmp (&ctim[0], "Fri", 3))
XX! 		rg[i].rval  = 6;
XX! 	else if (!strncmp (&ctim[0], "Sat", 3))
XX! 		rg[i].rval  = 7;
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "dy");		/* day of month (1-31) */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = atoi (&ctim[8]);
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "hp");		/* current h pos on input */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "ln");		/* output line num */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "mo");		/* current month (1-12) */
XX! 	rg[i].rval  = 0;
XX! 	if      (!strncmp (&ctim[4], "Jan", 3))
XX! 		rg[i].rval  = 1;
XX! 	else if (!strncmp (&ctim[4], "Feb", 3))
XX! 		rg[i].rval  = 2;
XX! 	else if (!strncmp (&ctim[4], "Mar", 3))
XX! 		rg[i].rval  = 3;
XX! 	else if (!strncmp (&ctim[4], "Apr", 3))
XX! 		rg[i].rval  = 4;
XX! 	else if (!strncmp (&ctim[4], "May", 3))
XX! 		rg[i].rval  = 5;
XX! 	else if (!strncmp (&ctim[4], "Jun", 3))
XX! 		rg[i].rval  = 6;
XX! 	else if (!strncmp (&ctim[4], "Jul", 3))
XX! 		rg[i].rval  = 7;
XX! 	else if (!strncmp (&ctim[4], "Aug", 3))
XX! 		rg[i].rval  = 8;
XX! 	else if (!strncmp (&ctim[4], "Sep", 3))
XX! 		rg[i].rval  = 9;
XX! 	else if (!strncmp (&ctim[4], "Oct", 3))
XX! 		rg[i].rval  = 10;
XX! 	else if (!strncmp (&ctim[4], "Nov", 3))
XX! 		rg[i].rval  = 11;
XX! 	else if (!strncmp (&ctim[4], "Dec", 3))
XX! 		rg[i].rval  = 12;
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "nl");		/* v pos of last base-line */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "sb");		/* depth of str below base */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "st");		/* height of str above base */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "yr");		/* last 2 dig of current year*/
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = atoi (&ctim[22]);
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "hh");		/* current hour (0-23) */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = atoi (&ctim[11]);
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = 2 | 0x80;
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "mm");		/* current minute (0-59) */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = atoi (&ctim[14]);
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = 2 | 0x80;
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, "ss");		/* current second (0-59) */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = atoi (&ctim[17]);
XX! 	rg[i].rflag = RF_READ | RF_WRITE;
XX! 	rg[i].rfmt  = 2 | 0x80;
XX! 	i++;
XX! 	
XX  
XX! 	/*
XX! 	 *   these are read only:
XX! 	 */
XX! 	strcpy (rg[i].rname, ".$");		/* num of args at current macro*/
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".A");		/* 1 for nroff */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 1;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".H");		/* hor resolution */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 1;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".T");		/* 1 for troff */
XX! 	rg[i].rauto = 0;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".V");		/* vert resolution */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 1;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".a");
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".c");
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".d");
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".f");		/* current font (1-4) */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 1;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".h");
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".i");		/* current indent */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".l");		/* current line length */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = PAGEWIDTH - 1;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".n");
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".o");		/* current offset */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".p");		/* current page len */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = PAGELEN;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".s");		/* current point size */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 1;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".t");
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".u");
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".v");		/* current v line spacing */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 1;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".w");		/* width of prev char */
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 1;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".x");
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".y");
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX! 	i++;
XX! 	
XX! 	strcpy (rg[i].rname, ".z");
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval  = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt  = '1';
XX  
XX! 	pg.curpag   = 0;
XX! 	pg.newpag   = 1;
XX! 	pg.lineno   = 0;
XX! 	pg.plval    = PAGELEN;
XX! 	pg.m1val    = 2;
XX! 	pg.m2val    = 2;
XX! 	pg.m3val    = 2;
XX! 	pg.m4val    = 2;
XX! 	pg.bottom   = pg.plval - pg.m4val - pg.m3val;
XX! 	pg.offset   = 0;
XX! 	pg.frstpg   = 0;
XX! 	pg.lastpg   = 30000;
XX! 	pg.ehead[0] = pg.ohead[0] = '\n';
XX! 	pg.efoot[0] = pg.ofoot[0] = '\n';
XX! 	for (i = 1; i < MAXLINE; ++i)
XX! 	{
XX! 		pg.ehead[i] = pg.ohead[i] = EOS;
XX! 		pg.efoot[i] = pg.ofoot[i] = EOS;
XX! 	}
XX! 	pg.ehlim[LEFT]  = pg.ohlim[LEFT]  = dc.inval;
XX! 	pg.eflim[LEFT]  = pg.oflim[LEFT]  = dc.inval;
XX! 	pg.ehlim[RIGHT] = pg.ohlim[RIGHT] = dc.rmval;
XX! 	pg.eflim[RIGHT] = pg.oflim[RIGHT] = dc.rmval;
XX  
XX! 	co.outp   = 0;
XX! 	co.outw   = 0;
XX! 	co.outwds = 0;
XX! 	co.lpr    = FALSE;
XX! 	for (i = 0; i < MAXLINE; ++i)
XX! 		co.outbuf[i] = EOS;
XX  
XX! 	for (i = 0; i < MXMDEF; ++i)
XX! 		mac.mnames[i] = NULL_CPTR;
XX! 	for (i = 0; i < MACBUF; ++i)
XX! 		mac.mb[i] = '\0';
XX! 	for (i = 0; i < MAXLINE; ++i)
XX! 		mac.pbb[i] = '\0';
XX! 	mac.lastp = 0;
XX! 	mac.emb   = &mac.mb[0];
XX! 	mac.ppb   = NULL_CPTR;
XX  }
XX  
XX  
XX--- 178,583 ----
XX   */
XX  
XX  
XX!   register int i;
XX!   time_t tval;
XX!   char *ctim;
XX  
XX!   tval = time((time_t *) 0);
XX!   dc.fill = YES;
XX!   dc.dofnt = YES;
XX!   dc.lsval = 1;
XX!   dc.inval = 0;
XX!   dc.rmval = PAGEWIDTH - 1;
XX!   dc.llval = PAGEWIDTH - 1;
XX!   dc.ltval = PAGEWIDTH - 1;
XX!   dc.tival = 0;
XX!   dc.ceval = 0;
XX!   dc.ulval = 0;
XX!   dc.cuval = 0;
XX!   dc.juval = YES;
XX!   dc.adjval = ADJ_BOTH;
XX!   dc.boval = 0;
XX!   dc.bsflg = FALSE;
XX!   dc.prflg = TRUE;
XX!   dc.sprdir = 0;
XX!   dc.flevel = 0;
XX!   dc.lastfnt = 1;
XX!   dc.thisfnt = 1;
XX!   dc.escon = YES;
XX!   dc.pgchr = '%';
XX!   dc.cmdchr = '.';
XX!   dc.escchr = '\\';
XX!   dc.nobrchr = '\'';
XX!   for (i = 0; i < 26; ++i) dc.nr[i] = 0;
XX!   for (i = 0; i < 26; ++i) dc.nrauto[i] = 1;
XX!   for (i = 0; i < 26; ++i) dc.nrfmt[i] = '1';
XX  
XX  
XX!   /* Initialize internal regs. first zero out... */
XX!   for (i = 0; i < MAXREGS; i++) {
XX! 	rg[i].rname[0] = rg[i].rname[1] = rg[i].rname[2] = rg[i].rname[3] = '\0';
XX! 	rg[i].rauto = 1;
XX! 	rg[i].rval = 0;
XX! 	rg[i].rflag = RF_READ;
XX! 	rg[i].rfmt = '1';
XX!   }
XX  
XX  
XX  
XX!   /* This should be checked... */
XX!   ctim = ctime(&tval);
XX  
XX  
XX!   /* Predefined regs. these are read/write: */
XX!   i = 0;
XX  
XX!   strcpy(rg[i].rname, "%");	/* current page */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, "ct");	/* character type */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, "dl");	/* width of last complete di */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, "dn");	/* height of last complete di */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, "dw");	/* day of week (1-7) */
XX!   rg[i].rval = 0;
XX!   if (!strncmp(&ctim[0], "Sun", 3))
XX! 	rg[i].rval = 1;
XX!   else if (!strncmp(&ctim[0], "Mon", 3))
XX! 	rg[i].rval = 2;
XX!   else if (!strncmp(&ctim[0], "Tue", 3))
XX! 	rg[i].rval = 3;
XX!   else if (!strncmp(&ctim[0], "Wed", 3))
XX! 	rg[i].rval = 4;
XX!   else if (!strncmp(&ctim[0], "Thu", 3))
XX! 	rg[i].rval = 5;
XX!   else if (!strncmp(&ctim[0], "Fri", 3))
XX! 	rg[i].rval = 6;
XX!   else if (!strncmp(&ctim[0], "Sat", 3))
XX! 	rg[i].rval = 7;
XX!   rg[i].rauto = 1;
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, "dy");	/* day of month (1-31) */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = atoi(&ctim[8]);
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, "hp");	/* current h pos on input */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, "ln");	/* output line num */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, "mo");	/* current month (1-12) */
XX!   rg[i].rval = 0;
XX!   if (!strncmp(&ctim[4], "Jan", 3))
XX! 	rg[i].rval = 1;
XX!   else if (!strncmp(&ctim[4], "Feb", 3))
XX! 	rg[i].rval = 2;
XX!   else if (!strncmp(&ctim[4], "Mar", 3))
XX! 	rg[i].rval = 3;
XX!   else if (!strncmp(&ctim[4], "Apr", 3))
XX! 	rg[i].rval = 4;
XX!   else if (!strncmp(&ctim[4], "May", 3))
XX! 	rg[i].rval = 5;
XX!   else if (!strncmp(&ctim[4], "Jun", 3))
XX! 	rg[i].rval = 6;
XX!   else if (!strncmp(&ctim[4], "Jul", 3))
XX! 	rg[i].rval = 7;
XX!   else if (!strncmp(&ctim[4], "Aug", 3))
XX! 	rg[i].rval = 8;
XX!   else if (!strncmp(&ctim[4], "Sep", 3))
XX! 	rg[i].rval = 9;
XX!   else if (!strncmp(&ctim[4], "Oct", 3))
XX! 	rg[i].rval = 10;
XX!   else if (!strncmp(&ctim[4], "Nov", 3))
XX! 	rg[i].rval = 11;
XX!   else if (!strncmp(&ctim[4], "Dec", 3))
XX! 	rg[i].rval = 12;
XX!   rg[i].rauto = 1;
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX  
XX!   strcpy(rg[i].rname, "nl");	/* v pos of last base-line */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX  
XX!   strcpy(rg[i].rname, "sb");	/* depth of str below base */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX  
XX!   strcpy(rg[i].rname, "st");	/* height of str above base */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX  
XX!   strcpy(rg[i].rname, "yr");	/* last 2 dig of current year */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = atoi(&ctim[22]);
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, "hh");	/* current hour (0-23) */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = atoi(&ctim[11]);
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = 2 | 0x80;
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, "mm");	/* current minute (0-59) */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = atoi(&ctim[14]);
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = 2 | 0x80;
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, "ss");	/* current second (0-59) */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = atoi(&ctim[17]);
XX!   rg[i].rflag = RF_READ | RF_WRITE;
XX!   rg[i].rfmt = 2 | 0x80;
XX!   i++;
XX! 
XX! 
XX!   /* These are read only: */
XX!   strcpy(rg[i].rname, ".$");	/* num of args at current macro */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".A");	/* 1 for nroff */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 1;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".H");	/* hor resolution */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 1;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".T");	/* 1 for troff */
XX!   rg[i].rauto = 0;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".V");	/* vert resolution */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 1;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".a");
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".c");
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".d");
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".f");	/* current font (1-4) */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 1;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".h");
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".i");	/* current indent */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".l");	/* current line length */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = PAGEWIDTH - 1;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".n");
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".o");	/* current offset */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".p");	/* current page len */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = PAGELEN;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".s");	/* current point size */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 1;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".t");
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".u");
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".v");	/* current v line spacing */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 1;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".w");	/* width of prev char */
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 1;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".x");
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".y");
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX!   i++;
XX! 
XX!   strcpy(rg[i].rname, ".z");
XX!   rg[i].rauto = 1;
XX!   rg[i].rval = 0;
XX!   rg[i].rflag = RF_READ;
XX!   rg[i].rfmt = '1';
XX! 
XX!   pg.curpag = 0;
XX!   pg.newpag = 1;
XX!   pg.lineno = 0;
XX!   pg.plval = PAGELEN;
XX!   pg.m1val = 2;
XX!   pg.m2val = 2;
XX!   pg.m3val = 2;
XX!   pg.m4val = 2;
XX!   pg.bottom = pg.plval - pg.m4val - pg.m3val;
XX!   pg.offset = 0;
XX!   pg.frstpg = 0;
XX!   pg.lastpg = 30000;
XX!   pg.ehead[0] = pg.ohead[0] = '\n';
XX!   pg.efoot[0] = pg.ofoot[0] = '\n';
XX!   for (i = 1; i < MAXLINE; ++i) {
XX! 	pg.ehead[i] = pg.ohead[i] = EOS;
XX! 	pg.efoot[i] = pg.ofoot[i] = EOS;
XX!   }
XX!   pg.ehlim[LEFT] = pg.ohlim[LEFT] = dc.inval;
XX!   pg.eflim[LEFT] = pg.oflim[LEFT] = dc.inval;
XX!   pg.ehlim[RIGHT] = pg.ohlim[RIGHT] = dc.rmval;
XX!   pg.eflim[RIGHT] = pg.oflim[RIGHT] = dc.rmval;
XX! 
XX!   co.outp = 0;
XX!   co.outw = 0;
XX!   co.outwds = 0;
XX!   co.lpr = FALSE;
XX!   for (i = 0; i < MAXLINE; ++i) co.outbuf[i] = EOS;
XX! 
XX!   for (i = 0; i < MXMDEF; ++i) mac.mnames[i] = NULL_CPTR;
XX!   for (i = 0; i < MACBUF; ++i) mac.mb[i] = '\0';
XX!   for (i = 0; i < MAXLINE; ++i) mac.pbb[i] = '\0';
XX!   mac.lastp = 0;
XX!   mac.emb = &mac.mb[0];
XX!   mac.ppb = NULL_CPTR;
XX  }
XX  
XX  
XX***************
XX*** 709,918 ****
XX  /*------------------------------*/
XX  /*	pswitch			*/
XX  /*------------------------------*/
XX! pswitch (p, p2, q)
XX! register char  *p;
XX! register char  *p2;
XX! register int   *q;
XX  {
XX  
XX  /*
XX   *	process switch values from command line
XX   */
XX  
XX! 	int     swgood;
XX! 	char    mfile[128];
XX! 	char   *ptmac;
XX  
XX! 	swgood = TRUE;
XX! 	if (*p == '-')
XX! 	{
XX! 		/*
XX! 		 *   since is STILL use the goofy atari/dri xmain code, i
XX! 		 *   look for both upper and lower case. if you use dLibs
XX! 		 *   (and if its startup code does not ucase the cmd line),
XX! 		 *   you can probably look for just lower case. gulam and
XX! 		 *   other shells typically don't change case of cmd line.
XX! 		 */
XX! 		switch (*++p)
XX! 		{
XX! 		case 0:					/* stdin */
XX! 			break;
XX  
XX! 		case 'a': 				/* font changes */
XX! 		case 'A': 
XX! 			dc.dofnt = NO;
XX! 			break;
XX  
XX! 		case 'b': 				/* backspace */
XX! 		case 'B': 
XX! 			dc.bsflg = TRUE;
XX! 			break;
XX  
XX! 		case 'd': 				/* debug mode */
XX! 		case 'D': 
XX! 			dbg_stream = fopen (dbgfile, "w");
XX! 			debugging = TRUE;
XX! 			break;
XX  
XX! 		case 'h': 				/* hold screen */
XX! 		case 'H': 
XX! 			hold_screen = TRUE;
XX! 			break;
XX  
XX! 		case 'l': 				/* to lpr (was P) */
XX! 		case 'L': 
XX! #ifdef GEMDOS
XX! 			out_stream = (FILE *) 0;
XX! #else
XX! 			out_stream = fopen (printer, "w");
XX! #endif
XX! 			co.lpr = TRUE;
XX! 			break;
XX  
XX! 		case 'm': 				/* macro file */
XX! 		case 'M': 
XX! 			/*
XX! 			 *   build macro file name. start with lib
XX! 			 *
XX! 			 *   put c:\lib\tmac in environment so we can
XX! 			 *   read it here. else use default. if you want
XX! 			 *   file from cwd, "setenv TMACDIR ." from shell.
XX! 			 *
XX! 			 *   we want file names like "tmac.an" (for -man)
XX! 			 */
XX! 			if (ptmac = getenv ("TMACDIR"))
XX! 			{
XX! 				/*
XX! 				 *   this is the lib path (e.g. "c:\lib\tmac")
XX! 				 */
XX! 				strcpy (mfile, ptmac);
XX  
XX! 				/*
XX! 				 *   this is the prefix (i.e. "\tmac.")
XX! 				 */
XX! 				strcat (mfile, TMACPRE);
XX! 			}
XX! 			else
XX! 				/*
XX! 				 *   use default lib/prefix (i.e.
XX! 				 *   "c:\lib\tmac\tmac.")
XX! 				 */
XX! 				strcpy (mfile, TMACFULL);
XX  
XX! 			/*
XX! 			 *   finally, add extension (e.g. "an")
XX! 			 */
XX! 			strcat (mfile, ++p);
XX  
XX! 			/*
XX! 			 *   open file and read it
XX! 			 */
XX! 			if ((sofile[0] = fopen (mfile, "r")) == NULL_FPTR)
XX! 			{
XX! 				fprintf (stderr,
XX! 					"***%s: unable to open macro file %s\n",
XX! 					myname, mfile);
XX! 				err_exit (-1);
XX! 			}
XX! 			profile ();
XX! 			fclose (sofile[0]);
XX! 			break;
XX  
XX! 		case 'o': 				/* output error log */
XX! 		case 'O': 
XX! 			if (!p2)
XX! 			{
XX! 				fprintf (stderr,
XX! 					"***%s: no error file specified\n",
XX! 					myname);
XX! 				err_exit (-1);
XX! 			}
XX! 			if ((err_stream = fopen (p2, "w")) == NULL_FPTR)
XX! 			{
XX! 				fprintf (stderr,
XX! 					"***%s: unable to open error file %s\n",
XX! 					myname, p2);
XX! 				err_exit (-1);
XX! 			}
XX! 			break;
XX  
XX! 		case 'p': 				/* .po, .pn */
XX! 		case 'P':
XX! 			if (*(p+1) == 'o' || *(p+1) == 'O')	/* -po___ */
XX! 			{
XX! 				p += 2;
XX! 				set (&pg.offset, ctod (p), '1', 0, 0, HUGE);
XX! 				set_ireg (".o", pg.offset, 0);
XX! 			}
XX! 			else if (*(p+1) == 'n' || *(p+1) == 'N')/* -pn___ */
XX! 			{
XX! 				p += 2;
XX! 				set (&pg.curpag, ctod (p) - 1, '1', 0, -HUGE, HUGE);
XX! 				pg.newpag = pg.curpag + 1;
XX! 				set_ireg ("%", pg.newpag, 0);
XX! 			}
XX! 			else if (*(p+1) == 'l' || *(p+1) == 'L')/* -pl___ */
XX! 			{
XX! 				p += 2;
XX! 				set (&pg.plval, ctod (p) - 1, '1', 0,
XX! 					pg.m1val + pg.m2val + pg.m3val + pg.m4val + 1,
XX! 					HUGE);
XX! 				set_ireg (".p", pg.plval, 0);
XX! 				pg.bottom = pg.plval - pg.m3val - pg.m4val;
XX! 			}
XX! 			else					/* -p___ */
XX! 			{
XX! 				set (&pg.offset, ctod (++p), '1', 0, 0, HUGE);
XX! 				set_ireg (".o", pg.offset, 0);
XX! 			}
XX! 			break;
XX  
XX! 		case 's': 				/* page step mode */
XX! 		case 'S': 
XX! 			stepping = TRUE;
XX! 			break;
XX  
XX! 		case 'v': 				/* version */
XX! 		case 'V': 
XX! 			printf ("%s\n", "Version 1.5");
XX! 			*q = TRUE;
XX! 			break;
XX  
XX! 		case '0': 				/* last page */
XX! 		case '1': 
XX! 		case '2': 
XX! 		case '3': 
XX! 		case '4': 
XX! 		case '5': 
XX! 		case '6': 
XX! 		case '7': 
XX! 		case '8': 
XX! 		case '9': 
XX! 			pg.lastpg = ctod (p);
XX! 			break;
XX  
XX! 		default: 				/* illegal */
XX! 			swgood = FALSE;
XX! 			break;
XX! 		}
XX! 	}
XX! 	else if (*p == '+')				/* first page */
XX! 	{
XX! 		pg.frstpg = ctod (++p);
XX! 	}
XX! 	else						/* illegal */
XX! 	{
XX  		swgood = FALSE;
XX  	}
XX  
XX  
XX! 	if (swgood == FALSE)
XX! 	{
XX! 		fprintf (stderr, "***%s: illegal switch %s\n", myname, p);
XX! 		return (ERR);
XX! 	}
XX! 
XX! 	return (OK);
XX  }
XX  
XX  
XX--- 586,748 ----
XX  /*------------------------------*/
XX  /*	pswitch			*/
XX  /*------------------------------*/
XX! int pswitch(p, p2, q)
XX! register char *p;
XX! register char *p2;
XX! register int *q;
XX  {
XX  
XX  /*
XX   *	process switch values from command line
XX   */
XX  
XX!   int swgood;
XX!   char mfile[128];
XX!   char *ptmac;
XX  
XX!   swgood = TRUE;
XX!   if (*p == '-') {
XX! 	/* Since is STILL use the goofy atari/dri xmain code, i look
XX! 	 * for both upper and lower case. if you use dLibs (and if
XX! 	 * its startup code does not ucase the cmd line), you can
XX! 	 * probably look for just lower case. gulam and other shells
XX! 	 * typically don't change case of cmd line. 
XX! 	 */
XX! 	switch (*++p) {
XX! 	    case 0:		/* stdin */
XX! 		break;
XX  
XX! 	    case 'a':		/* font changes */
XX! 	    case 'A':	dc.dofnt = NO;	break;
XX  
XX! 	    case 'b':		/* backspace */
XX! 	    case 'B':	dc.bsflg = TRUE;	break;
XX  
XX! 	    case 'd':		/* debug mode */
XX! 	    case 'D':
XX! 		dbg_stream = fopen(dbgfile, "w");
XX! 		debugging = TRUE;
XX! 		break;
XX  
XX! 	    case 'h':		/* hold screen */
XX! 	    case 'H':	hold_screen = TRUE;	break;
XX  
XX! 	    case 'l':		/* to lpr (was P) */
XX! 	    case 'L':
XX! 		out_stream = fopen(printer, "w");
XX! 		co.lpr = TRUE;
XX! 		break;
XX  
XX! 	    case 'm':		/* macro file */
XX! 	    case 'M':
XX! 		/* Build macro file name. start with lib 
XX! 		 * put c:\lib\tmac in environment so we can read it
XX! 		 * here. else use default. if you want file from cwd,
XX! 		 * "setenv TMACDIR ." from shell.
XX! 		 * 
XX! 		 * we want file names like "tmac.an" (for -man) 
XX! 		 */
XX! 		if (ptmac = getenv("TMACDIR")) {
XX! 			/* This is the lib path (e.g. "c:\lib\tmac") */
XX! 			strcpy(mfile, ptmac);
XX  
XX! 			/* This is the prefix (i.e. "\tmac.") */
XX! 			strcat(mfile, TMACPRE);
XX! 		} else
XX! 			/* Use default lib/prefix (i.e.
XX! 			 * "c:\lib\tmac\tmac.") */
XX! 			strcpy(mfile, TMACFULL);
XX  
XX! 		/* Finally, add extension (e.g. "an") */
XX! 		strcat(mfile, ++p);
XX  
XX! 		/* Open file and read it */
XX! 		if ((sofile[0] = fopen(mfile, "r")) == NULL_FPTR) {
XX! 			fprintf(stderr,
XX! 			    "***%s: unable to open macro file %s\n",
XX! 				myname, mfile);
XX! 			err_exit(-1);
XX! 		}
XX! 		profile();
XX! 		fclose(sofile[0]);
XX! 		break;
XX  
XX! 	    case 'o':		/* output error log */
XX! 	    case 'O':
XX! 		if (!p2) {
XX! 			fprintf(stderr,
XX! 				"***%s: no error file specified\n",
XX! 				myname);
XX! 			err_exit(-1);
XX! 		}
XX! 		if ((err_stream = fopen(p2, "w")) == NULL_FPTR) {
XX! 			fprintf(stderr,
XX! 			    "***%s: unable to open error file %s\n",
XX! 				myname, p2);
XX! 			err_exit(-1);
XX! 		}
XX! 		break;
XX  
XX! 	    case 'p':		/* .po, .pn */
XX! 	    case 'P':
XX! 		if (*(p + 1) == 'o' || *(p + 1) == 'O') {	/* -po___ */
XX! 			p += 2;
XX! 			set(&pg.offset, ctod(p), '1', 0, 0, HUGE);
XX! 			set_ireg(".o", pg.offset, 0);
XX! 		} else if (*(p + 1) == 'n' || *(p + 1) == 'N') {	/* -pn___ */
XX! 			p += 2;
XX! 			set(&pg.curpag, ctod(p) - 1, '1', 0, -HUGE, HUGE);
XX! 			pg.newpag = pg.curpag + 1;
XX! 			set_ireg("%", pg.newpag, 0);
XX! 		} else if (*(p + 1) == 'l' || *(p + 1) == 'L') {	/* -pl___ */
XX! 			p += 2;
XX! 			set(&pg.plval, ctod(p) - 1, '1', 0,
XX! 			    pg.m1val + pg.m2val + pg.m3val + pg.m4val + 1,
XX! 			    HUGE);
XX! 			set_ireg(".p", pg.plval, 0);
XX! 			pg.bottom = pg.plval - pg.m3val - pg.m4val;
XX! 		} else {	/* -p___ */
XX! 			set(&pg.offset, ctod(++p), '1', 0, 0, HUGE);
XX! 			set_ireg(".o", pg.offset, 0);
XX! 		}
XX! 		break;
XX  
XX! 	    case 's':		/* page step mode */
XX! 	    case 'S':	stepping = TRUE;	break;
XX  
XX! 	    case 'v':		/* version */
XX! 	    case 'V':
XX! 		printf("%s\n", "Version 1.5");
XX! 		*q = TRUE;
XX! 		break;
XX  
XX! 	    case '0':		/* last page */
XX! 	    case '1':
XX! 	    case '2':
XX! 	    case '3':
XX! 	    case '4':
XX! 	    case '5':
XX! 	    case '6':
XX! 	    case '7':
XX! 	    case '8':
XX! 	    case '9':	pg.lastpg = ctod(p);	break;
XX  
XX! 	    default:		/* illegal */
XX  		swgood = FALSE;
XX+ 		break;
XX  	}
XX+   } else if (*p == '+') {	/* first page */
XX+ 	pg.frstpg = ctod(++p);
XX+   } else {			/* illegal */
XX+ 	swgood = FALSE;
XX+   }
XX  
XX  
XX!   if (swgood == FALSE) {
XX! 	fprintf(stderr, "***%s: illegal switch %s\n", myname, p);
XX! 	return(ERR);
XX!   }
XX!   return(OK);
XX  }
XX  
XX  
XX***************
XX*** 921,973 ****
XX  /*------------------------------*/
XX  /*	profile			*/
XX  /*------------------------------*/
XX! profile ()
XX  {
XX  
XX  /*
XX   *	process input files from command line
XX   */
XX  
XX! 	char    ibuf[MAXLINE];
XX  
XX! 	/*
XX! 	 *   handle nesting of includes (.so)
XX! 	 */
XX! 	for (dc.flevel = 0; dc.flevel >= 0; dc.flevel -= 1)
XX! 	{
XX! 		while (getlin (ibuf, sofile[dc.flevel]) != EOF)
XX! 		{
XX! 			/*
XX! 			 *   if line is a command or text
XX! 			 */
XX! 			if (ibuf[0] == dc.cmdchr)
XX! 			{
XX! 				comand (ibuf);
XX! 			}
XX! 			else
XX! 			{
XX! 				/*
XX! 				 *   this is a text line. first see if
XX! 				 *   first char is space. if it is, break
XX! 				 *   line.
XX! 				 */
XX! 				if (ibuf[0] == ' ')
XX! 					robrk ();
XX! 				text (ibuf);
XX! 			}
XX  		}
XX- 
XX- 		/*
XX- 		 *   close included file
XX- 		 */
XX- 		if (dc.flevel > 0)
XX- 			fclose (sofile[dc.flevel]);
XX  	}
XX- 	if (pg.lineno > 0)
XX- 		space (HUGE);
XX- }
XX  
XX! 
XX! 
XX! 
XX! 
XX--- 751,781 ----
XX  /*------------------------------*/
XX  /*	profile			*/
XX  /*------------------------------*/
XX! void profile()
XX  {
XX  
XX  /*
XX   *	process input files from command line
XX   */
XX  
XX!   char ibuf[MAXLINE];
XX  
XX!   /* Handle nesting of includes (.so) */
XX!   for (dc.flevel = 0; dc.flevel >= 0; dc.flevel -= 1) {
XX! 	while (getlin(ibuf, sofile[dc.flevel]) != EOF) {
XX! 		/* If line is a command or text */
XX! 		if (ibuf[0] == dc.cmdchr) {
XX! 			comand(ibuf);
XX! 		} else {
XX! 			/* This is a text line. first see if first
XX! 			 * char is space. if it is, break line. */
XX! 			if (ibuf[0] == ' ') robrk();
XX! 			text(ibuf);
XX  		}
XX  	}
XX  
XX! 	/* Close included file */
XX! 	if (dc.flevel > 0) fclose(sofile[dc.flevel]);
XX!   }
XX!   if (pg.lineno > 0) space(HUGE);
XX! }
X/
Xecho x - nroff.h.d
Xsed '/^X/s///' > nroff.h.d << '/'
XX*** /home/top/ast/minix/1.5/commands/nroff/nroff.h  crc=05189  15993	Sat Apr 21 22:27:21 1990
XX--- /home/top/ast/minix/1.6.25/commands/nroff/nroff.h  crc=44789  16772	Mon Dec 21 18:56:36 1992
XX***************
XX*** 1,8 ****
XX- #ifndef NRO_H
XX- #define NRO_H
XX- 
XX- #include "config.h"			/* os/compiler options */
XX- 
XX  /*
XX   *	nroff.h - stuff for nroff
XX   *
XX--- 1,3 ----
XX***************
XX*** 36,109 ****
XX   *	- Heavily hacked up to conform to "real" nroff by Bill Rosenkranz
XX   */
XX  
XX  #include <ctype.h>
XX  
XX- #ifdef _MINIX
XX- # ifdef tolower
XX- #  undef tolower
XX- # endif
XX- # define tolower(x) (isupper(x)?((x)-'A'+'a'):(x))
XX- #endif
XX- #ifdef UNIX
XX- # ifdef tolower
XX- #  undef tolower
XX- # endif
XX- # define tolower(x) (isupper(x)?((x)-'A'+'a'):(x))
XX- #endif
XX- 
XX  /*
XX   *	default prefix of macro files. files will be of the form "tmac.an"
XX   *	(for -man), "tmac.s" (for -ms), "tmac.e" (for -me), etc. first
XX   *	checks environment for TMACDIR which would be path (e.g. "c:\lib\tmac"
XX   *	or ".", no trailing slash char!).
XX   */
XX- #ifdef tmacfull
XX- # define TMACFULL	tmacfull
XX- #endif
XX- #ifdef tmacpre
XX- # define TMACPRE	tmacpre
XX- #endif
XX  
XX! #ifdef GEMDOS
XX! # ifndef TMACFULL
XX! #  define TMACFULL	"c:\\lib\\tmac\\tmac."
XX! # endif
XX! # ifndef TMACPRE
XX! #  define TMACPRE	"\\tmac."
XX! # endif
XX! #endif
XX  
XX! #ifdef _MINIX
XX! # ifndef TMACFULL
XX! #  define TMACFULL	"/usr/lib/tmac/tmac."
XX! # endif
XX! # ifndef TMACPRE
XX! #  define TMACPRE	"/tmac."
XX! # endif
XX! #endif
XX! 
XX! #ifdef UNIX
XX! # ifndef TMACFULL
XX! #  define TMACFULL	"/usr/lib/tmac/tmac."
XX! # endif
XX! # ifndef TMACPRE
XX! #  define TMACPRE	"/tmac."
XX! # endif
XX! #endif
XX! 
XX! /*
XX!  *	command codes. indented defines are commands not yet implemented
XX!  */
XX  #undef PI
XX  #define MACRO		0	/* macro definition */
XX  #define BP	 	1	/* begin page */
XX  #define BR	 	2	/* break */
XX  #define CE	 	3	/* center */
XX! #define FI	 	4	/* fill	*/
XX  #define FO	 	5	/* footer */
XX  #define HE	 	6	/* header */
XX  #define IN	 	7	/* indent */
XX! #define LS	 	8	/* line spacing	*/
XX  #define NF	 	9	/* no fill */
XX  #define PL		10	/* page length */
XX  #define RM		11	/* remove macro */
XX--- 31,68 ----
XX   *	- Heavily hacked up to conform to "real" nroff by Bill Rosenkranz
XX   */
XX  
XX+ #ifndef NRO_H
XX+ #define NRO_H
XX+ 
XX+ #undef NULL
XX+ #include "config.h"		/* os/compiler options */
XX  #include <ctype.h>
XX+ #include <termcap.h>
XX+ #include <stdlib.h>
XX+ #include <string.h>
XX+ #include <time.h>
XX  
XX  /*
XX   *	default prefix of macro files. files will be of the form "tmac.an"
XX   *	(for -man), "tmac.s" (for -ms), "tmac.e" (for -me), etc. first
XX   *	checks environment for TMACDIR which would be path (e.g. "c:\lib\tmac"
XX   *	or ".", no trailing slash char!).
XX   */
XX  
XX! #define TMACFULL	"/usr/lib/tmac/tmac."
XX! #define TMACPRE		"/tmac."
XX  
XX! /* Command codes. Indented defines are commands not yet implemented.  */
XX  #undef PI
XX  #define MACRO		0	/* macro definition */
XX  #define BP	 	1	/* begin page */
XX  #define BR	 	2	/* break */
XX  #define CE	 	3	/* center */
XX! #define FI	 	4	/* fill	 */
XX  #define FO	 	5	/* footer */
XX  #define HE	 	6	/* header */
XX  #define IN	 	7	/* indent */
XX! #define LS	 	8	/* line spacing	 */
XX  #define NF	 	9	/* no fill */
XX  #define PL		10	/* page length */
XX  #define RM		11	/* remove macro */
XX***************
XX*** 127,135 ****
XX  #define EF		29	/* footer for even numbered pages */
XX  #define OF		30	/* footer for odd numbered pages */
XX  #define SO		31	/* source file */
XX! #define CU		32	/* continuous underline	*/
XX! #define DE		33	/* define macro	*/
XX! #define EN		34	/* end macro definition	*/
XX  #define NR		35	/* set number register */
XX  #define EC		36	/* escape character (\) */
XX  #define FT		37	/* font change (R,B,I,S,P) */
XX--- 86,94 ----
XX  #define EF		29	/* footer for even numbered pages */
XX  #define OF		30	/* footer for odd numbered pages */
XX  #define SO		31	/* source file */
XX! #define CU		32	/* continuous underline	 */
XX! #define DE		33	/* define macro	 */
XX! #define EN		34	/* end macro definition	 */
XX  #define NR		35	/* set number register */
XX  #define EC		36	/* escape character (\) */
XX  #define FT		37	/* font change (R,B,I,S,P) */
XX***************
XX*** 235,243 ****
XX  #undef OK
XX  #define OK 		!ERR
XX  
XX! /*
XX!  *	a rational way of dealing with the NULL thing...
XX!  */
XX  #define NULL_CPTR	(char *) 0
XX  #define NULL_FPTR	(FILE *) 0
XX  #define NULL_IPTR	(int *) 0
XX--- 194,200 ----
XX  #undef OK
XX  #define OK 		!ERR
XX  
XX! /* A rational way of dealing with the NULL thing... */
XX  #define NULL_CPTR	(char *) 0
XX  #define NULL_FPTR	(FILE *) 0
XX  #define NULL_IPTR	(int *) 0
XX***************
XX*** 247,255 ****
XX  #define NULLP(type)	(type *) 0
XX  
XX  
XX! /*
XX!  *	for justification during line fill
XX!  */
XX  #define ADJ_OFF		0
XX  #define ADJ_LEFT	1
XX  #define ADJ_RIGHT	2
XX--- 204,210 ----
XX  #define NULLP(type)	(type *) 0
XX  
XX  
XX! /* For justification during line fill */
XX  #define ADJ_OFF		0
XX  #define ADJ_LEFT	1
XX  #define ADJ_RIGHT	2
XX***************
XX*** 268,280 ****
XX   *
XX   *		char_spaces = (int)(inches * (float) BU_INCH) / BU_EM;
XX   */
XX! #define BU_INCH		240		/* 1.0i = 240 b.u. */
XX! #define BU_CM		945/10		/* 1.0c = 240*50/127 b.u. */
XX! #define BU_PICA		40		/* 1P   = 240/6 b.u. */
XX! #define BU_EM		24		/* 1m   = 240/10 b.u. (10 char/inch) */
XX! #define BU_EN		24		/* 1n   = 240/10 b.u. */
XX! #define BU_POINT	240/72		/* 1p   = 240/72 b.u. */
XX! #define BU_BU		1		/* 1    = 1 b.u. */
XX  
XX  
XX  /*
XX--- 223,235 ----
XX   *
XX   *		char_spaces = (int)(inches * (float) BU_INCH) / BU_EM;
XX   */
XX! #define BU_INCH		240	/* 1.0i = 240 b.u. */
XX! #define BU_CM		945/10	/* 1.0c = 240*50/127 b.u. */
XX! #define BU_PICA		40	/* 1P   = 240/6 b.u. */
XX! #define BU_EM		24	/* 1m   = 240/10 b.u. (10 char/inch) */
XX! #define BU_EN		24	/* 1n   = 240/10 b.u. */
XX! #define BU_POINT	240/72	/* 1p   = 240/72 b.u. */
XX! #define BU_BU		1	/* 1    = 1 b.u. */
XX  
XX  
XX  /*
XX***************
XX*** 294,580 ****
XX  #define MNLEN		10	/* max length of macro name */
XX  #define MAXREGS		100	/* max number of registers (2-char) */
XX  
XX! struct macros
XX! {
XX! 	char   *mnames[MXMDEF];	/* table of ptrs to macro names */
XX! 	int	lastp;		/* index to last mname	*/
XX! 	char   *emb;		/* next char avail in macro defn buf */
XX! 	char 	mb[MACBUF];	/* table of macro definitions */
XX! 	char   *ppb;		/* pointer into push back buffer */
XX! 	char 	pbb[MAXLINE];	/* push back buffer */
XX  };
XX  
XX  
XX! /*
XX!  *	number registers
XX!  */
XX  #define RF_READ		0x0001	/* register flags */
XX  #define RF_WRITE	0x0002
XX  
XX! struct regs
XX! {
XX! 	char	rname[4];	/* 2-char register name */
XX! 	int	rauto;		/* autoincrement value */
XX! 	int	rval;		/* current value of the register */
XX! 	int	rflag;		/* register flags */
XX! 	char	rfmt;		/* register format (1,a,A,i,I,...) */
XX  };
XX  
XX! 
XX! 
XX! /*
XX!  *	control parameters for nroff
XX!  */
XX! struct docctl
XX! {
XX! 	int	fill;		/* fill if YES, init = YES */
XX! 	int	dofnt;		/* handle font change, init = YES */
XX! 	int	lsval;		/* current line spacing, init = 1 */
XX! 	int	inval;		/* current indent, >= 0, init = 0 */
XX! 	int	rmval;		/* current right margin, init = 60 */
XX! 	int	llval;		/* current line length, init = 60 */
XX! 	int	ltval;		/* current title length, init = 60 */
XX! 	int	tival;		/* current temp indent, init = 0 */
XX! 	int	ceval;		/* number of lines to center, init = 0 */
XX! 	int	ulval;		/* number of lines to underline, init = 0 */
XX! 	int	cuval;		/* no lines to continuously uline, init = 0 */
XX! 	int	juval;		/* justify if YES, init = YES */
XX! 	int	adjval;		/* adjust type, init = ADJ_BOTH */
XX! 	int	boval;		/* number of lines to bold face, init = 0 */
XX! 	int	bsflg;		/* can output contain '\b', init = FALSE */
XX! 	int	prflg;		/* print on or off, init = TRUE */
XX! 	int	sprdir;		/* direction for spread(), init = 0 */
XX! 	int	flevel;		/* nesting depth for source cmd, init = 0 */
XX! 	int	lastfnt;	/* previous used font */
XX! 	int	thisfnt;	/* current font, init = 1 (1=R,2=I,3=B,4=S) */
XX! 	int	escon;		/* whether esc parsing is on, init = YES */
XX! 	int	nr[26];		/* number registers */
XX! 	int	nrauto[26];	/* number registers auto increment */
XX! 	char	nrfmt[26];	/* number registers formats, init = '1' */
XX! 				/* input code how printed */
XX! 				/* 1     '1'  1,2,3,... */
XX! 				/* a     'a'  a,b,c,...,aa,bb,cc,... */
XX! 				/* A     'A'  A,B,C,...,AA,BB,CC,... */
XX! 				/* i     'i'  i,ii,iii,iv,v... */
XX! 				/* I     'I'  I,II,III,IV,V... */
XX! 				/* 01     2   01,02,03,... */
XX! 				/* 001    3   001,002,003,... */
XX! 				/* 0..1   8   00000001,00000002,... */
XX! 	char	pgchr;		/* page number character, init = '%' */
XX! 	char	cmdchr;		/* command character, init = '.' */
XX! 	char	escchr;		/* escape char, init = '\' */
XX! 	char	nobrchr;	/* nobreak char, init = '\'' */
XX  };
XX  
XX! 
XX! /*
XX!  *	output buffer control parameters
XX!  */
XX! struct cout
XX! {
XX! 	int	outp;		/* next avail char pos in outbuf, init = 0 */
XX! 	int	outw;		/* width of text currently in buffer */
XX! 	int	outwds;		/* number of words in buffer, init = 0 */
XX! 	int	lpr;		/* output to printer, init = FALSE */
XX! 	int	outesc;		/* number of escape char on this line */
XX! 	char	outbuf[MAXLINE];/* output of filled text */
XX  };
XX  
XX! 
XX! /*
XX!  *	page control parameters
XX!  */
XX! struct page
XX! {
XX! 	int	curpag;		/* current output page number, init =0 */
XX! 	int	newpag;		/* next output page number, init = 1 */
XX! 	int	lineno;		/* next line to be printed, init = 0 */
XX! 	int	plval;		/* page length in lines, init = 66 */
XX! 	int	m1val;		/* margin before and including header */
XX! 	int	m2val;		/* margin after header */
XX! 	int	m3val;		/* margin after last text line */
XX! 	int	m4val;		/* bottom margin, including footer */
XX! 	int	bottom;		/* last live line on page
XX! 					= plval - m3val - m4val	*/
XX! 	int	offset;		/* page offset from left, init = 0 */
XX! 	int	frstpg;		/* first page to print, init = 0 */
XX! 	int	lastpg;		/* last page to print, init = 30000 */
XX! 	int	ehlim[2];	/* left/right margins for headers/footers */
XX! 	int	ohlim[2];	/* init = 0 and PAGEWIDTH */
XX! 	int	eflim[2];
XX! 	int	oflim[2];
XX! 	char	ehead[MAXLINE];	/* top of page title, init = '\n' */
XX! 	char	ohead[MAXLINE];
XX! 	char	efoot[MAXLINE];	/* bottom of page title, init = '\n' */
XX! 	char	ofoot[MAXLINE];
XX  };
XX  
XX  
XX  
XX! /*
XX!  *	forward refs from libc
XX!  */
XX! char   *getenv ();
XX! char   *ctime ();
XX! long	time ();
XX! #ifdef UNIX
XX! char   *tgetstr ();			/* from termcap/terminfo */
XX! #endif
XX! #ifdef MINIX_ST
XX! char   *tgetstr ();
XX! #endif
XX! #ifdef MINIX_PC
XX! char   *tgetstr ();
XX! #endif
XX  
XX  
XX! /*
XX!  *	forward refs from nroff
XX!  */
XX! char   *getmac ();
XX! char   *getstr ();
XX! char   *skipwd ();
XX! char   *skipbl ();
XX! char   *getfield ();
XX  
XX! int	comand ();
XX! int	comtyp ();
XX! int	gettl ();
XX! int	getval ();
XX! int	set ();
XX! int	expesc ();
XX! int	specialchar ();
XX! int	fontchange ();
XX! int	getlin ();
XX! int	ngetc ();
XX! int	pbstr ();
XX! int	putbak ();
XX! int	prchar ();
XX! int	put ();
XX! int	putlin ();
XX! int	atod ();
XX! int	robrk ();
XX! int	ctod ();
XX! int	space ();
XX! int	getwrd ();
XX! int	countesc ();
XX! int	itoda ();
XX! int	itoROMAN ();
XX! int	itoroman ();
XX! int	itoLETTER ();
XX! int	itoletter ();
XX! int	min ();
XX! int	max ();
XX! int	defmac ();
XX! int	colmac ();
XX! int	putmac ();
XX! int	maceval ();
XX! int	main ();
XX! int	usage ();
XX! int	init ();
XX! int	pswitch ();
XX! int	profile ();
XX! int	text ();
XX! int	bold ();
XX! int	center ();
XX! int	expand ();
XX! int	justcntr ();
XX! int	justleft ();
XX! int	justrite ();
XX! int	leadbl ();
XX! int	pfoot ();
XX! int	phead ();
XX! int	puttl ();
XX! int	putwrd ();
XX! int	skip ();
XX! int	spread ();
XX! int	strkovr ();
XX! int	underl ();
XX! int	width ();
XX! int	inptobu ();		/* convert input units to b.u. */
XX! int	butochar ();		/* convert b.u. to char spaces */
XX  
XX! int	findreg ();
XX! int	set_ireg ();
XX  
XX  
XX  
XX! /*
XX!  *	globals. define NRO_MAIN in main.c to define globals there. else
XX!  *	you get extern.
XX!  */
XX! #ifdef NRO_MAIN
XX  
XX! struct docctl		dc;
XX! struct page		pg;
XX! struct cout		co;
XX! struct macros		mac;
XX! struct regs		rg[MAXREGS];
XX! FILE		       *out_stream;
XX! FILE		       *err_stream;
XX! FILE		       *dbg_stream;
XX! FILE		       *sofile[Nfiles+1];
XX! int			ignoring;		/* .ig vs .de */
XX! int			hold_screen;
XX! int			debugging;
XX! int			stepping;		/* paging */
XX! char			tmpdir[256];
XX! char			termcap[1030];
XX! char			s_standout[20];
XX! char			e_standout[20];
XX! char			s_italic[20];
XX! char			e_italic[20];
XX! char			s_bold[20];
XX! char			e_bold[20];
XX! char		       *dbgfile = "nroff.dbg";
XX! #ifdef GEMDOS
XX! char		       *printer = "prn:";	/* this WON'T work!!! */
XX! #else
XX! char		       *printer = "/dev/lp";	/* this probably won't */
XX  #endif
XX  
XX  
XX! #include "version.h"				/* for myname and version */
XX! 
XX! 
XX! #ifdef ALCYON
XX! /*
XX!  *	this SHOULD be big enough for most needs. only used by startup
XX!  *	code (gemstart.o or crt0.o)
XX!  */
XX! long			_STKSIZ = 16384L;
XX  #endif
XX  
XX! 
XX! #else /*NRO_MAIN*/
XX! 
XX! extern struct docctl	dc;
XX! extern struct page	pg;
XX! extern struct cout	co;
XX! extern struct macros	mac;
XX! extern struct regs	rg[MAXREGS];
XX! extern FILE	       *out_stream;
XX! extern FILE	       *err_stream;
XX! extern FILE	       *dbg_stream;
XX! extern FILE	       *sofile[Nfiles+1];
XX! extern int		ignoring;
XX! extern int		hold_screen;
XX! extern int		debugging;
XX! extern int		stepping;
XX! extern char		tmpdir[];
XX! extern char		termcap[];
XX! extern char		s_standout[];
XX! extern char		e_standout[];
XX! extern char		s_italic[];
XX! extern char		e_italic[];
XX! extern char		s_bold[];
XX! extern char		e_bold[];
XX! extern char	       *dbgfile;
XX! extern char	       *printer;
XX! extern char	       *myname;
XX! extern char	       *version;
XX! 
XX! #endif /*NRO_MAIN*/
XX!  
XX! #endif /*NRO_H*/
XX! 
XX--- 249,477 ----
XX  #define MNLEN		10	/* max length of macro name */
XX  #define MAXREGS		100	/* max number of registers (2-char) */
XX  
XX! struct macros {
XX!   char *mnames[MXMDEF];		/* table of ptrs to macro names */
XX!   int lastp;			/* index to last mname	 */
XX!   char *emb;			/* next char avail in macro defn buf */
XX!   char mb[MACBUF];		/* table of macro definitions */
XX!   char *ppb;			/* pointer into push back buffer */
XX!   char pbb[MAXLINE];		/* push back buffer */
XX  };
XX  
XX  
XX! /* Number registers */
XX  #define RF_READ		0x0001	/* register flags */
XX  #define RF_WRITE	0x0002
XX  
XX! struct regs {
XX!   char rname[4];		/* 2-char register name */
XX!   int rauto;			/* autoincrement value */
XX!   int rval;			/* current value of the register */
XX!   int rflag;			/* register flags */
XX!   char rfmt;			/* register format (1,a,A,i,I,...) */
XX  };
XX  
XX! /* Control parameters for nroff */
XX! struct docctl {
XX!   int fill;			/* fill if YES, init = YES */
XX!   int dofnt;			/* handle font change, init = YES */
XX!   int lsval;			/* current line spacing, init = 1 */
XX!   int inval;			/* current indent, >= 0, init = 0 */
XX!   int rmval;			/* current right margin, init = 60 */
XX!   int llval;			/* current line length, init = 60 */
XX!   int ltval;			/* current title length, init = 60 */
XX!   int tival;			/* current temp indent, init = 0 */
XX!   int ceval;			/* number of lines to center, init = 0 */
XX!   int ulval;			/* number of lines to underline, init = 0 */
XX!   int cuval;			/* no lines to continuously uline, init = 0 */
XX!   int juval;			/* justify if YES, init = YES */
XX!   int adjval;			/* adjust type, init = ADJ_BOTH */
XX!   int boval;			/* number of lines to bold face, init = 0 */
XX!   int bsflg;			/* can output contain '\b', init = FALSE */
XX!   int prflg;			/* print on or off, init = TRUE */
XX!   int sprdir;			/* direction for spread(), init = 0 */
XX!   int flevel;			/* nesting depth for source cmd, init = 0 */
XX!   int lastfnt;			/* previous used font */
XX!   int thisfnt;			/* current font, init = 1 (1=R,2=I,3=B,4=S) */
XX!   int escon;			/* whether esc parsing is on, init = YES */
XX!   int nr[26];			/* number registers */
XX!   int nrauto[26];		/* number registers auto increment */
XX!   char nrfmt[26];		/* number registers formats, init = '1' */
XX!   /* Input code how printed */
XX!   /* 1     '1'  1,2,3,... */
XX!   /* A     'a'  a,b,c,...,aa,bb,cc,... */
XX!   /* A     'A'  A,B,C,...,AA,BB,CC,... */
XX!   /* I     'i'  i,ii,iii,iv,v... */
XX!   /* I     'I'  I,II,III,IV,V... */
XX!   /* 01     2   01,02,03,... */
XX!   /* 001    3   001,002,003,... */
XX!   /* 0..1   8   00000001,00000002,... */
XX!   char pgchr;			/* page number character, init = '%' */
XX!   char cmdchr;			/* command character, init = '.' */
XX!   char escchr;			/* escape char, init = '\' */
XX!   char nobrchr;			/* nobreak char, init = '\'' */
XX  };
XX  
XX! /* Output buffer control parameters */
XX! struct cout {
XX!   int outp;			/* next avail char pos in outbuf, init = 0 */
XX!   int outw;			/* width of text currently in buffer */
XX!   int outwds;			/* number of words in buffer, init = 0 */
XX!   int lpr;			/* output to printer, init = FALSE */
XX!   int outesc;			/* number of escape char on this line */
XX!   char outbuf[MAXLINE];		/* output of filled text */
XX  };
XX  
XX! /* Page control parameters */
XX! struct page {
XX!   int curpag;			/* current output page number, init =0 */
XX!   int newpag;			/* next output page number, init = 1 */
XX!   int lineno;			/* next line to be printed, init = 0 */
XX!   int plval;			/* page length in lines, init = 66 */
XX!   int m1val;			/* margin before and including header */
XX!   int m2val;			/* margin after header */
XX!   int m3val;			/* margin after last text line */
XX!   int m4val;			/* bottom margin, including footer */
XX!   int bottom;			/* last live line on page: plval-m3val-m4val */
XX!   int offset;			/* page offset from left, init = 0 */
XX!   int frstpg;			/* first page to print, init = 0 */
XX!   int lastpg;			/* last page to print, init = 30000 */
XX!   int ehlim[2];			/* left/right margins for headers/footers */
XX!   int ohlim[2];			/* init = 0 and PAGEWIDTH */
XX!   int eflim[2];
XX!   int oflim[2];
XX!   char ehead[MAXLINE];		/* top of page title, init = '\n' */
XX!   char ohead[MAXLINE];
XX!   char efoot[MAXLINE];		/* bottom of page title, init = '\n' */
XX!   char ofoot[MAXLINE];
XX  };
XX  
XX+ /* Forward refs from nroff */
XX  
XX+ /* Command.c */
XX+ _PROTOTYPE(void comand, (char *p));
XX+ _PROTOTYPE(int comtyp, (char *p, char *m));
XX+ _PROTOTYPE(void gettl, (char *p, char *q, int *limit));
XX+ _PROTOTYPE(int getval, (char *p, char *p_argt));
XX+ _PROTOTYPE(int set_ireg, (char *name, int val, int opt));
XX+ _PROTOTYPE(void set, (int *param, int val, int type, int defval, int minval, 
XX+ 								 int maxval));
XX  
XX! /* Escape.c */
XX! _PROTOTYPE(void expesc, (char *p, char *q));
XX! _PROTOTYPE(int specialchar, (char *s, char *c));
XX! _PROTOTYPE(void fontchange, (int fnt, char *s));
XX! _PROTOTYPE(int findreg, (char *name));
XX  
XX+ /* Io.c */
XX+ _PROTOTYPE(int getlin, (char *p, FILE * in_buf));
XX+ _PROTOTYPE(int ngetc, (FILE * infp));
XX+ _PROTOTYPE(void pbstr, (char *p));
XX+ _PROTOTYPE(void putbak, (int c));
XX+ _PROTOTYPE(void prchar, (int c, FILE * fp));
XX+ _PROTOTYPE(void put, (char *p));
XX+ _PROTOTYPE(void putlin, (char *p, FILE * pbuf));
XX+ _PROTOTYPE(void putc_lpr, (int c, FILE * fp));
XX  
XX! /* Low.c */
XX! _PROTOTYPE(int atod, (int c));
XX! _PROTOTYPE(void robrk, (void));
XX! _PROTOTYPE(int ctod, (char *p));
XX! _PROTOTYPE(void inptobu, (char *ps));
XX! _PROTOTYPE(void butochar, (char *ps));
XX! _PROTOTYPE(char *skipbl, (char *p));
XX! _PROTOTYPE(char *skipwd, (char *p));
XX! _PROTOTYPE(void space, (int n));
XX! _PROTOTYPE(char *getfield, (char *p, char *q, int delim));
XX! _PROTOTYPE(int getwrd, (char *p0, char *p1));
XX! _PROTOTYPE(int countesc, (char *p));
XX! _PROTOTYPE(int itoda, (int value, char *p, int size));
XX! _PROTOTYPE(int itoROMAN, (int value, char *p, int size));
XX! _PROTOTYPE(int itoroman, (int value, char *p, int size));
XX! _PROTOTYPE(int itoLETTER, (int value, char *p, int size));
XX! _PROTOTYPE(int itoletter, (int value, char *p, int size));
XX! _PROTOTYPE(int min, (int v1, int v2));
XX! _PROTOTYPE(int max, (int v1, int v2));
XX! _PROTOTYPE(void err_exit, (int code));
XX! _PROTOTYPE(void wait_for_char, (void));
XX  
XX! /* Macros.c */
XX! _PROTOTYPE(void defmac, (char *p, FILE * infp));
XX! _PROTOTYPE(int colmac, (char *p, char *d, int i));
XX! _PROTOTYPE(int putmac, (char *name, char *p));
XX! _PROTOTYPE(char *getmac, (char *name));
XX! _PROTOTYPE(void maceval, (char *p, char *m));
XX! _PROTOTYPE(void printmac, (int opt));
XX  
XX! /* Main.c */
XX! _PROTOTYPE(int main, (int argc, char *argv[]));
XX! _PROTOTYPE(void usage, (void));
XX! _PROTOTYPE(void init, (void));
XX! _PROTOTYPE(int pswitch, (char *p, char *p2, int *q));
XX! _PROTOTYPE(void profile, (void));
XX  
XX+ /* Strings.c */
XX+ _PROTOTYPE(void defstr, (char *p));
XX+ _PROTOTYPE(int colstr, (char *p, char *d));
XX+ _PROTOTYPE(int putstr, (char *name, char *p));
XX+ _PROTOTYPE(char *getstr, (char *name));
XX  
XX+ /* Text.c */
XX+ _PROTOTYPE(void text, (char *p));
XX+ _PROTOTYPE(void bold, (char *p0, char *p1, int size));
XX+ _PROTOTYPE(void center, (char *p));
XX+ _PROTOTYPE(void expand, (char *p0, int c, char *s));
XX+ _PROTOTYPE(void justcntr, (char *p, char *q, int *limit));
XX+ _PROTOTYPE(void justleft, (char *p, char *q, int limit));
XX+ _PROTOTYPE(void justrite, (char *p, char *q, int limit));
XX+ _PROTOTYPE(void leadbl, (char *p));
XX+ _PROTOTYPE(void pfoot, (void));
XX+ _PROTOTYPE(void phead, (void));
XX+ _PROTOTYPE(void puttl, (char *p, int *lim, int pgno));
XX+ _PROTOTYPE(void putwrd, (char *wrdbuf));
XX+ _PROTOTYPE(void skip, (int n));
XX+ _PROTOTYPE(void spread,(char *p, int outp, int nextra,int outwds,int escapes));
XX+ _PROTOTYPE(int strkovr, (char *p, char *q));
XX+ _PROTOTYPE(void underl, (char *p0, char *p1, int size));
XX+ _PROTOTYPE(int width, (char *s));
XX  
XX! /* Globals. Define NRO_MAIN in main.c to define globals, else you get extern */
XX! #define EXTERN extern		/* true in all files except main.c */
XX  
XX! #ifdef NRO_MAIN
XX! #undef EXTERN
XX! #define EXTERN
XX  #endif
XX  
XX+ EXTERN struct docctl dc;
XX+ EXTERN struct page pg;
XX+ EXTERN struct cout co;
XX+ EXTERN struct macros mac;
XX+ EXTERN struct regs rg[MAXREGS];
XX+ EXTERN FILE *out_stream;
XX+ EXTERN FILE *err_stream;
XX+ EXTERN FILE *dbg_stream;
XX+ EXTERN FILE *sofile[Nfiles + 1];
XX+ EXTERN int ignoring;			/* .ig vs .de */
XX+ EXTERN int hold_screen;
XX+ EXTERN int debugging;
XX+ EXTERN int stepping;			/* paging */
XX+ EXTERN char tmpdir[256];
XX+ EXTERN char termcap[1030];
XX+ EXTERN char s_standout[20];
XX+ EXTERN char e_standout[20];
XX+ EXTERN char s_italic[20];
XX+ EXTERN char e_italic[20];
XX+ EXTERN char s_bold[20];
XX+ EXTERN char e_bold[20];
XX  
XX! #ifdef NRO_MAIN
XX! char *myname = "nroff";
XX! char *dbgfile = "nroff.dbg";
XX! char *printer = "/dev/lp";	/* this probably won't */
XX! char *version = "nroff v0.99 BETA 02/25/90 wjr";
XX! #else
XX! extern char *myname, *dbgfile, *printer, *version;
XX  #endif
XX  
XX! #endif				/* NRO_H */
X/
Xecho x - strings.c.d
Xsed '/^X/s///' > strings.c.d << '/'
XX*** /home/top/ast/minix/1.5/commands/nroff/strings.c  crc=65031   4930	Sat Apr 21 22:27:21 1990
XX--- /home/top/ast/minix/1.6.25/commands/nroff/strings.c  crc=28691   4308	Mon Nov 23 12:19:56 1992
XX***************
XX*** 1,26 ****
XX! /*
XX!  *	strings.c - String input/output processing for nroff word processor
XX!  *
XX!  *	adapted for atariST/TOS by Bill Rosenkranz 11/89
XX!  *	net:	rosenkra@hall.cray.com
XX!  *	CIS:	71460,17
XX!  *	GENIE:	W.ROSENKRANZ
XX!  *
XX!  *	original author:
XX!  *
XX!  *	Stephen L. Browning
XX!  *	5723 North Parker Avenue
XX!  *	Indianapolis, Indiana 46220
XX!  *
XX!  *	history:
XX!  *
XX!  *	- Originally written in BDS C;
XX!  *	- Adapted for standard C by W. N. Paul
XX!  *	- Heavily hacked up to conform to "real" nroff by Bill Rosenkranz
XX!  */
XX  
XX- #undef NRO_MAIN					/* extern globals */
XX- 
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX--- 1,5 ----
XX! /* strings.c - String input/output processing for nroff word processor */
XX  
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX***************
XX*** 29,36 ****
XX  /*------------------------------*/
XX  /*	defstr			*/
XX  /*------------------------------*/
XX! defstr (p)
XX! register char  *p;
XX  {
XX  
XX  /*
XX--- 8,15 ----
XX  /*------------------------------*/
XX  /*	defstr			*/
XX  /*------------------------------*/
XX! void defstr(p)
XX! register char *p;
XX  {
XX  
XX  /*
XX***************
XX*** 50,122 ****
XX   *	putstr, after colstr...
XX   */
XX  
XX! 	register char  *q;
XX! 	register int	i;
XX! 	char		name[MNLEN];
XX! 	char		defn[MXMLEN];
XX  
XX  
XX  
XX! 	name[0] = '\0';
XX! 	defn[0] = '\0';
XX  
XX  
XX! 	/*
XX! 	 *   skip the .ds and get to the name...
XX! 	 */
XX! 	q = skipwd (p);
XX! 	q = skipbl (q);
XX  
XX! 	/*
XX! 	 *   ok, name now holds the name. make sure it is valid (i.e. first
XX! 	 *   char is alpha...). getwrd returns the length of the word.
XX! 	 */
XX! 	i = getwrd (q, name);
XX! 	if (!name[0])
XX! 	{
XX! 		fprintf (err_stream,
XX! 			"***%s: missing or illegal string definition name\n",
XX! 			myname);
XX! 		err_exit (-1);
XX! 	}
XX  
XX! 	/*
XX! 	 *   truncate to 2 char max name.
XX! 	 */
XX! 	if (i > 2)
XX! 		name[2] = EOS;
XX  
XX  
XX! 	/*
XX! 	 *   skip the name to get to the string. it CAN start with a " to
XX! 	 *   have leading blanks...
XX! 	 */
XX! 	q = skipwd (q);
XX! 	q = skipbl (q);
XX  
XX  
XX  
XX! 	/*
XX! 	 *   read rest of line from input stream and collect string into
XX! 	 *   temp buffer defn
XX! 	 */
XX! 	if ((i = colstr (q, defn)) == ERR)
XX! 	{
XX! 		fprintf (err_stream,
XX! 			"***%s: string definition too long\n", myname);
XX! 		err_exit (-1);
XX! 	}
XX  
XX! 
XX! 	/*
XX! 	 *   store the string
XX! 	 */
XX! 	if (putstr (name, defn) == ERR)
XX! 	{
XX! 		fprintf (err_stream,
XX! 			"***%s: string definition table full\n", myname);
XX! 		err_exit (-1);
XX! 	}
XX  }
XX  
XX  
XX--- 29,84 ----
XX   *	putstr, after colstr...
XX   */
XX  
XX!   register char *q;
XX!   register int i;
XX!   char name[MNLEN];
XX!   char defn[MXMLEN];
XX  
XX  
XX  
XX!   name[0] = '\0';
XX!   defn[0] = '\0';
XX  
XX  
XX!   /* Skip the .ds and get to the name... */
XX!   q = skipwd(p);
XX!   q = skipbl(q);
XX  
XX!   /* Ok, name now holds the name. make sure it is valid (i.e. first
XX!    * char is alpha...). getwrd returns the length of the word. */
XX!   i = getwrd(q, name);
XX!   if (!name[0]) {
XX! 	fprintf(err_stream,
XX! 		"***%s: missing or illegal string definition name\n",
XX! 		myname);
XX! 	err_exit(-1);
XX!   }
XX  
XX!   /* Truncate to 2 char max name. */
XX!   if (i > 2) name[2] = EOS;
XX  
XX  
XX!   /* Skip the name to get to the string. it CAN start with a " to have
XX!    * leading blanks... */
XX!   q = skipwd(q);
XX!   q = skipbl(q);
XX  
XX  
XX  
XX!   /* Read rest of line from input stream and collect string into temp
XX!    * buffer defn */
XX!   if ((i = colstr(q, defn)) == ERR) {
XX! 	fprintf(err_stream,
XX! 		"***%s: string definition too long\n", myname);
XX! 	err_exit(-1);
XX!   }
XX  
XX!   /* Store the string */
XX!   if (putstr(name, defn) == ERR) {
XX! 	fprintf(err_stream,
XX! 		"***%s: string definition table full\n", myname);
XX! 	err_exit(-1);
XX!   }
XX  }
XX  
XX  
XX***************
XX*** 126,156 ****
XX  /*------------------------------*/
XX  /*	colstr			*/
XX  /*------------------------------*/
XX! colstr (p, d)
XX! register char  *p;
XX! char	       *d;
XX  {
XX  
XX  /*
XX   *	Collect string definition from input stream
XX   */
XX  
XX! 	register int	i = 0;
XX  
XX! 	if (*p == '\"')
XX! 		p++;
XX  
XX! 	while (*p != EOS)
XX! 	{
XX! 		if (i >= MXMLEN - 1)
XX! 		{
XX! 			d[i - 1] = EOS;
XX! 			return (ERR);
XX! 		}
XX! 		d[i++] = *p++;
XX  	}
XX! 	d[i] = EOS;
XX! 	return (i);
XX  }
XX  
XX  
XX--- 88,115 ----
XX  /*------------------------------*/
XX  /*	colstr			*/
XX  /*------------------------------*/
XX! int colstr(p, d)
XX! register char *p;
XX! char *d;
XX  {
XX  
XX  /*
XX   *	Collect string definition from input stream
XX   */
XX  
XX!   register int i = 0;
XX  
XX!   if (*p == '\"') p++;
XX  
XX!   while (*p != EOS) {
XX! 	if (i >= MXMLEN - 1) {
XX! 		d[i - 1] = EOS;
XX! 		return(ERR);
XX  	}
XX! 	d[i++] = *p++;
XX!   }
XX!   d[i] = EOS;
XX!   return(i);
XX  }
XX  
XX  
XX***************
XX*** 160,168 ****
XX  /*------------------------------*/
XX  /*	putstr			*/
XX  /*------------------------------*/
XX! putstr (name, p)
XX! register char  *name;
XX! register char  *p;
XX  {
XX  
XX  /*
XX--- 119,127 ----
XX  /*------------------------------*/
XX  /*	putstr			*/
XX  /*------------------------------*/
XX! int putstr(name, p)
XX! register char *name;
XX! register char *p;
XX  {
XX  
XX  /*
XX***************
XX*** 173,220 ****
XX   */
XX  
XX  
XX! 	/*
XX! 	 *   any room left? (did we exceed max number of possible macros)
XX! 	 */
XX! 	if (mac.lastp >= MXMDEF)
XX! 		return (ERR);
XX  
XX! 	/*
XX! 	 *   will new one fit in big buffer?
XX! 	 */
XX! 	if (mac.emb + strlen (name) + strlen (p) + 1 > &mac.mb[MACBUF])
XX! 	{
XX! 		return (ERR);
XX! 	}
XX  
XX! 
XX! 	/*
XX! 	 *   add it...
XX! 	 *
XX! 	 *   bump counter, set ptr to name, copy name, copy def.
XX! 	 *   finally increment end of macro buffer ptr (emb).
XX! 	 *
XX! 	 *   string looks like this in mb:
XX! 	 *
XX! 	 *	mac.mb[MACBUF]		size of total buf
XX! 	 *	lastp < MXMDEF		number of macros/strings possible
XX! 	 *	*mnames[MXMDEF]		-> names, each max length
XX! 	 *	...______________________________...____________________...
XX! 	 *	    / / /|X|X|0|string definition      |0| / / / / / / /
XX! 	 *	.../_/_/_|_|_|_|_________________...___|_|/_/_/_/_/_/_/_...
XX! 	 *		    ^
XX! 	 *		    |
XX! 	 *		    \----- mac.mnames[mac.lastp] points here
XX! 	 *
XX! 	 *   both the 2 char name (XX) and the descripton are null term and
XX! 	 *   follow one after the other.
XX! 	 */
XX! 	++mac.lastp;
XX! 	mac.mnames[mac.lastp] = mac.emb;
XX! 	strcpy (mac.emb, name);
XX! 	strcpy (mac.emb + strlen (name) + 1, p);
XX! 	mac.emb += strlen (name) + strlen (p) + 2;
XX! 	return (OK);
XX  }
XX  
XX  
XX--- 132,167 ----
XX   */
XX  
XX  
XX!   /* Any room left? (did we exceed max number of possible macros) */
XX!   if (mac.lastp >= MXMDEF) return(ERR);
XX  
XX!   /* Will new one fit in big buffer? */
XX!   if (mac.emb + strlen(name) + strlen(p) + 1 > &mac.mb[MACBUF]) {
XX! 	return(ERR);
XX!   }
XX  
XX!   /* Add it... 
XX!    * bump counter, set ptr to name, copy name, copy def. finally increment
XX!    * end of macro buffer ptr (emb).
XX!    * 
XX!    * string looks like this in mb:
XX!    * 
XX!    * mac.mb[MACBUF]		size of total buf lastp < MXMDEF
XX!    * umber of macros/strings possible *mnames[MXMDEF]		->
XX!    * names, each max length
XX!    * ...______________________________...____________________... / /
XX!    * /|X|X|0|string definition      |0| / / / / / / /
XX!    * .../_/_/_|_|_|_|_________________...___|_|/_/_/_/_/_/_/_... ^ |
XX!    * \----- mac.mnames[mac.lastp] points here
XX!    * 
XX!    * both the 2 char name (XX) and the descripton are null term and follow
XX!    * one after the other. */
XX!   ++mac.lastp;
XX!   mac.mnames[mac.lastp] = mac.emb;
XX!   strcpy(mac.emb, name);
XX!   strcpy(mac.emb + strlen(name) + 1, p);
XX!   mac.emb += strlen(name) + strlen(p) + 2;
XX!   return(OK);
XX  }
XX  
XX  
XX***************
XX*** 225,273 ****
XX  /*------------------------------*/
XX  /*	getstr			*/
XX  /*------------------------------*/
XX! char   *getstr (name)
XX! register char  *name;
XX  {
XX  
XX  /*
XX   *	Get (lookup) string definition from namespace
XX   */
XX  
XX! 	register int	i;
XX  
XX! 	/*
XX! 	 *   loop for all macros, starting with last one
XX! 	 */
XX! 	for (i = mac.lastp; i >= 0; --i)
XX! 	{
XX! 		/*
XX! 		 *   is this REALLY a macro?
XX! 		 */
XX! 		if (mac.mnames[i])
XX! 		{
XX! 			/*
XX! 			 *   if it compares, return a ptr to it
XX! 			 */
XX! 			if (!strcmp (name, mac.mnames[i]))
XX! 			{
XX  /*!!!debug			puts (mac.mnames[i]);*/
XX  
XX! 				if (mac.mnames[i][1] == EOS)
XX! 					return (mac.mnames[i] + 2);
XX! 				else
XX! 					return (mac.mnames[i] + 3);
XX! 			}
XX  		}
XX  	}
XX  
XX! 	/*
XX! 	 *   none found, return null
XX! 	 */
XX! 	return (NULL_CPTR);
XX  }
XX- 
XX- 
XX- 
XX- 
XX- 
XX- 
XX--- 172,203 ----
XX  /*------------------------------*/
XX  /*	getstr			*/
XX  /*------------------------------*/
XX! char *getstr(name)
XX! register char *name;
XX  {
XX  
XX  /*
XX   *	Get (lookup) string definition from namespace
XX   */
XX  
XX!   register int i;
XX  
XX!   /* Loop for all macros, starting with last one */
XX!   for (i = mac.lastp; i >= 0; --i) {
XX! 	/* Is this REALLY a macro? */
XX! 	if (mac.mnames[i]) {
XX! 		/* If it compares, return a ptr to it */
XX! 		if (!strcmp(name, mac.mnames[i])) {
XX  /*!!!debug			puts (mac.mnames[i]);*/
XX  
XX! 			if (mac.mnames[i][1] == EOS)
XX! 				return(mac.mnames[i] + 2);
XX! 			else
XX! 				return(mac.mnames[i] + 3);
XX  		}
XX  	}
XX+   }
XX  
XX!   /* None found, return null */
XX!   return(NULL_CPTR);
XX  }
X/
Xecho x - text.c.d
Xsed '/^X/s///' > text.c.d << '/'
XX*** /home/top/ast/minix/1.5/commands/nroff/text.c  crc=11881  11611	Sat Apr 21 22:27:21 1990
XX--- /home/top/ast/minix/1.6.25/commands/nroff/text.c  crc=25258  10339	Mon Nov 23 12:19:56 1992
XX***************
XX*** 1,28 ****
XX! /*
XX!  *	text.c - text output processing portion of nroff word processor
XX!  *
XX!  *	adapted for atariST/TOS by Bill Rosenkranz 11/89
XX!  *	net:	rosenkra@hall.cray.com
XX!  *	CIS:	71460,17
XX!  *	GENIE:	W.ROSENKRANZ
XX!  *
XX!  *	original author:
XX!  *
XX!  *	Stephen L. Browning
XX!  *	5723 North Parker Avenue
XX!  *	Indianapolis, Indiana 46220
XX!  *
XX!  *	history:
XX!  *
XX!  *	- Originally written in BDS C;
XX!  *	- Adapted for standard C by W. N. Paul
XX!  *	- Heavily hacked up to conform to "real" nroff by Bill Rosenkranz
XX!  *	- Adapted the justification of lines with escape codes 
XX!  *	  by Wim 'Blue Baron' van Dorst (wsincc@tuerc3.urc.tue.nl)
XX!  */
XX  
XX- #undef NRO_MAIN					/* extern globals */
XX- 
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX--- 1,5 ----
XX! /* text.c - text output processing portion of nroff word processor */
XX  
XX  #include <stdio.h>
XX  #include "nroff.h"
XX  
XX***************
XX*** 30,143 ****
XX  /*------------------------------*/
XX  /*	text			*/
XX  /*------------------------------*/
XX! text (p)
XX! register char  *p;
XX  {
XX  
XX  /*
XX   *	main text processing
XX   */
XX  
XX! 	register int	i;
XX! 	char		wrdbuf[MAXLINE];
XX  
XX  
XX! 	/*
XX! 	 *   skip over leading blanks if in fill mode. we indent later.
XX! 	 *   since leadbl does a robrk, do it if in .nf mode
XX! 	 */
XX! 	if (dc.fill == YES)
XX! 	{
XX! 		if (*p == ' ' || *p == '\n' || *p == '\r')
XX! 			leadbl (p);
XX! 	}
XX! 	else
XX! 		robrk ();
XX  
XX  
XX! 	/*
XX! 	 *   expand escape sequences
XX! 	 */
XX! 	expesc (p, wrdbuf);
XX  
XX  
XX! 	/*
XX! 	 *   test for how to output
XX! 	 */
XX! 	if (dc.ulval > 0)
XX! 	{
XX! 		/*
XX! 		 *   underline (.ul)
XX! 		 *
XX! 		 *   Because of the way underlining is handled,
XX! 		 *   MAXLINE should be declared to be three times
XX! 		 *   larger than the longest expected input line
XX! 		 *   for underlining.  Since many of the character
XX! 		 *   buffers use this parameter, a lot of memory
XX! 		 *   can be allocated when it may not really be
XX! 		 *   needed.  A MAXLINE of 180 would allow about
XX! 		 *   60 characters in the output line to be
XX! 		 *   underlined (remember that only alphanumerics
XX! 		 *   get underlined - no spaces or punctuation).
XX! 		 */
XX! 		underl (p, wrdbuf, MAXLINE);
XX! 		--dc.ulval;
XX! 	}
XX! 	if (dc.cuval > 0)
XX! 	{
XX! 		/*
XX! 		 *   continuous underline (.cu)
XX! 		 */
XX! 		underl (p, wrdbuf, MAXLINE);
XX! 		--dc.cuval;
XX! 	}
XX! 	if (dc.boval > 0)
XX! 	{
XX! 		/*
XX! 		 *   bold (.bo)
XX! 		 */
XX! 		bold (p, wrdbuf, MAXLINE);
XX! 		--dc.boval;
XX! 	}
XX! 	if (dc.ceval > 0)
XX! 	{
XX! 		/*
XX! 		 *   centered (.ce)
XX! 		 */
XX! 		center (p);
XX! 		put (p);
XX! 		--dc.ceval;
XX! 	}
XX! 	else if ((*p == '\r' || *p == '\n') && dc.fill == NO)
XX! 	{
XX! 		/*
XX! 		 *   all blank line
XX! 		 */
XX! 		put (p);
XX! 	}
XX! 	else if (dc.fill == NO)
XX! 	{
XX! 		/*
XX! 		 *   unfilled (.nf)
XX! 		 */
XX! 		put (p);
XX! 	}
XX! 	else
XX! 	{
XX! 		/*
XX! 		 *   anything else...
XX! 		 */
XX  
XX! 		/*
XX! 		 *   get a word and put it out. increment ptr to the next
XX! 		 *   word.
XX! 		 */
XX! 		while ((i = getwrd (p, wrdbuf)) > 0)
XX! 		{
XX! 			putwrd (wrdbuf);
XX! 			p += i;
XX! 		}
XX  	}
XX  }
XX  
XX  
XX--- 7,80 ----
XX  /*------------------------------*/
XX  /*	text			*/
XX  /*------------------------------*/
XX! void text(p)
XX! register char *p;
XX  {
XX  
XX  /*
XX   *	main text processing
XX   */
XX  
XX!   register int i;
XX!   char wrdbuf[MAXLINE];
XX  
XX  
XX!   /* Skip over leading blanks if in fill mode. we indent later. since
XX!    * leadbl does a robrk, do it if in .nf mode */
XX!   if (dc.fill == YES) {
XX! 	if (*p == ' ' || *p == '\n' || *p == '\r') leadbl(p);
XX!   } else
XX! 	robrk();
XX  
XX  
XX!   /* Expand escape sequences */
XX!   expesc(p, wrdbuf);
XX  
XX  
XX!   /* Test for how to output */
XX!   if (dc.ulval > 0) {
XX! 	/* Underline (.ul) 
XX! 	 * Because of the way underlining is handled, MAXLINE should be
XX! 	 * declared to be three times larger than the longest
XX! 	 * expected input line for underlining.  Since many of the
XX! 	 * character buffers use this parameter, a lot of memory can
XX! 	 * be allocated when it may not really be needed.  A MAXLINE
XX! 	 * of 180 would allow about 60 characters in the output line
XX! 	 * to be underlined (remember that only alphanumerics get
XX! 	 * underlined - no spaces or punctuation). */
XX! 	underl(p, wrdbuf, MAXLINE);
XX! 	--dc.ulval;
XX!   }
XX!   if (dc.cuval > 0) {
XX! 	/* Continuous underline (.cu) */
XX! 	underl(p, wrdbuf, MAXLINE);
XX! 	--dc.cuval;
XX!   }
XX!   if (dc.boval > 0) {
XX! 	/* Bold (.bo) */
XX! 	bold(p, wrdbuf, MAXLINE);
XX! 	--dc.boval;
XX!   }
XX!   if (dc.ceval > 0) {
XX! 	/* Centered (.ce) */
XX! 	center(p);
XX! 	put(p);
XX! 	--dc.ceval;
XX!   } else if ((*p == '\r' || *p == '\n') && dc.fill == NO) {
XX! 	/* All blank line */
XX! 	put(p);
XX!   } else if (dc.fill == NO) {
XX! 	/* Unfilled (.nf) */
XX! 	put(p);
XX!   } else {
XX! 	/* Anything else... */
XX  
XX! 	/* Get a word and put it out. increment ptr to the next word. */
XX! 	while ((i = getwrd(p, wrdbuf)) > 0) {
XX! 		putwrd(wrdbuf);
XX! 		p += i;
XX  	}
XX+   }
XX  }
XX  
XX  
XX***************
XX*** 146,179 ****
XX  /*------------------------------*/
XX  /*	bold			*/
XX  /*------------------------------*/
XX! bold (p0, p1, size)
XX! register char  *p0;
XX! register char  *p1;
XX! int		size;
XX  {
XX  
XX  /*
XX   *	insert bold face text (by overstriking)
XX   */
XX  
XX! 	register int	i;
XX! 	register int	j;
XX  
XX! 	j = 0;
XX! 	for (i = 0; (p0[i] != '\n') && (j < size - 1); ++i)
XX! 	{
XX! 		if (isalpha (p0[i]) || isdigit (p0[i]))
XX! 		{
XX! 			p1[j++] = p0[i];
XX! 			p1[j++] = '\b';
XX! 		}
XX  		p1[j++] = p0[i];
XX  	}
XX! 	p1[j++] = '\n';
XX! 	p1[j] = EOS;
XX! 	while (*p1 != EOS)
XX! 		*p0++ = *p1++;
XX! 	*p0 = EOS;
XX  }
XX  
XX  
XX--- 83,113 ----
XX  /*------------------------------*/
XX  /*	bold			*/
XX  /*------------------------------*/
XX! void bold(p0, p1, size)
XX! register char *p0;
XX! register char *p1;
XX! int size;
XX  {
XX  
XX  /*
XX   *	insert bold face text (by overstriking)
XX   */
XX  
XX!   register int i;
XX!   register int j;
XX  
XX!   j = 0;
XX!   for (i = 0; (p0[i] != '\n') && (j < size - 1); ++i) {
XX! 	if (isalpha(p0[i]) || isdigit(p0[i])) {
XX  		p1[j++] = p0[i];
XX+ 		p1[j++] = '\b';
XX  	}
XX! 	p1[j++] = p0[i];
XX!   }
XX!   p1[j++] = '\n';
XX!   p1[j] = EOS;
XX!   while (*p1 != EOS) *p0++ = *p1++;
XX!   *p0 = EOS;
XX  }
XX  
XX  
XX***************
XX*** 184,198 ****
XX  /*------------------------------*/
XX  /*	center			*/
XX  /*------------------------------*/
XX! center (p)
XX! register char  *p;
XX  {
XX  
XX  /*
XX   *	center a line by setting tival
XX   */
XX  
XX! 	dc.tival = max ((dc.rmval + dc.tival - width (p)) >> 1, 0);
XX  }
XX  
XX  
XX--- 118,132 ----
XX  /*------------------------------*/
XX  /*	center			*/
XX  /*------------------------------*/
XX! void center(p)
XX! register char *p;
XX  {
XX  
XX  /*
XX   *	center a line by setting tival
XX   */
XX  
XX!   dc.tival = max((dc.rmval + dc.tival - width(p)) >> 1, 0);
XX  }
XX  
XX  
XX***************
XX*** 201,237 ****
XX  /*------------------------------*/
XX  /*	expand			*/
XX  /*------------------------------*/
XX! expand (p0, c, s)
XX! register char  *p0;
XX! char		c;
XX! register char  *s;
XX  {
XX  
XX  /*
XX   *	expand title buffer to include character string
XX   */
XX  
XX! 	register char  *p;
XX! 	register char  *q;
XX! 	register char  *r;
XX! 	char    	tmp[MAXLINE];
XX  
XX! 	p = p0;
XX! 	q = tmp;
XX! 	while (*p != EOS)
XX! 	{
XX! 		if (*p == c)
XX! 		{
XX! 			r = s;
XX! 			while (*r != EOS)
XX! 				*q++ = *r++;
XX! 		}
XX! 		else
XX! 			*q++ = *p;
XX! 		++p;
XX! 	}
XX! 	*q = EOS;
XX! 	strcpy (p0, tmp);		/* copy it back */
XX  }
XX  
XX  
XX--- 135,167 ----
XX  /*------------------------------*/
XX  /*	expand			*/
XX  /*------------------------------*/
XX! void expand(p0, c, s)
XX! register char *p0;
XX! char c;
XX! register char *s;
XX  {
XX  
XX  /*
XX   *	expand title buffer to include character string
XX   */
XX  
XX!   register char *p;
XX!   register char *q;
XX!   register char *r;
XX!   char tmp[MAXLINE];
XX  
XX!   p = p0;
XX!   q = tmp;
XX!   while (*p != EOS) {
XX! 	if (*p == c) {
XX! 		r = s;
XX! 		while (*r != EOS) *q++ = *r++;
XX! 	} else
XX! 		*q++ = *p;
XX! 	++p;
XX!   }
XX!   *q = EOS;
XX!   strcpy(p0, tmp);		/* copy it back */
XX  }
XX  
XX  
XX***************
XX*** 240,261 ****
XX  /*------------------------------*/
XX  /*	justcntr		*/
XX  /*------------------------------*/
XX! justcntr (p, q, limit)
XX! register char  *p;
XX! char	       *q;
XX! int	       *limit;
XX  {
XX  
XX  /*
XX   *	center title text into print buffer
XX   */
XX  
XX! 	register int	len;
XX  
XX! 	len = width (p);
XX! 	q   = &q[(limit[RIGHT] + limit[LEFT] - len) >> 1];
XX! 	while (*p != EOS)
XX! 		*q++ = *p++;
XX  }
XX  
XX  
XX--- 170,190 ----
XX  /*------------------------------*/
XX  /*	justcntr		*/
XX  /*------------------------------*/
XX! void justcntr(p, q, limit)
XX! register char *p;
XX! char *q;
XX! int *limit;
XX  {
XX  
XX  /*
XX   *	center title text into print buffer
XX   */
XX  
XX!   register int len;
XX  
XX!   len = width(p);
XX!   q = &q[(limit[RIGHT] + limit[LEFT] - len) >> 1];
XX!   while (*p != EOS) *q++ = *p++;
XX  }
XX  
XX  
XX***************
XX*** 265,283 ****
XX  /*------------------------------*/
XX  /*	justleft		*/
XX  /*------------------------------*/
XX! justleft (p, q, limit)
XX! register char  *p;
XX! char	       *q;
XX! int		limit;
XX  {
XX  
XX  /*
XX   *	left justify title text into print buffer
XX   */
XX  
XX! 	q = &q[limit];
XX! 	while (*p != EOS)
XX! 		*q++ = *p++;
XX  }
XX  
XX  
XX--- 194,211 ----
XX  /*------------------------------*/
XX  /*	justleft		*/
XX  /*------------------------------*/
XX! void justleft(p, q, limit)
XX! register char *p;
XX! char *q;
XX! int limit;
XX  {
XX  
XX  /*
XX   *	left justify title text into print buffer
XX   */
XX  
XX!   q = &q[limit];
XX!   while (*p != EOS) *q++ = *p++;
XX  }
XX  
XX  
XX***************
XX*** 286,307 ****
XX  /*------------------------------*/
XX  /*	justrite		*/
XX  /*------------------------------*/
XX! justrite (p, q, limit)
XX! register char  *p;
XX! char	       *q;
XX! int     	limit;
XX  {
XX  
XX  /*
XX   *	right justify title text into print buffer
XX   */
XX  
XX! 	register int	len;
XX  
XX! 	len = width (p);
XX! 	q = &q[limit - len];
XX! 	while (*p != EOS)
XX! 		*q++ = *p++;
XX  }
XX  
XX  
XX--- 214,234 ----
XX  /*------------------------------*/
XX  /*	justrite		*/
XX  /*------------------------------*/
XX! void justrite(p, q, limit)
XX! register char *p;
XX! char *q;
XX! int limit;
XX  {
XX  
XX  /*
XX   *	right justify title text into print buffer
XX   */
XX  
XX!   register int len;
XX  
XX!   len = width(p);
XX!   q = &q[limit - len];
XX!   while (*p != EOS) *q++ = *p++;
XX  }
XX  
XX  
XX***************
XX*** 312,356 ****
XX  /*------------------------------*/
XX  /*	leadbl			*/
XX  /*------------------------------*/
XX! leadbl (p)
XX! register char  *p;
XX  {
XX  
XX  /*
XX   *	delete leading blanks, set tival
XX   */
XX  
XX! 	register int	i;
XX! 	register int	j;
XX  
XX! 	/*
XX! 	 *   end current line and reset co struct
XX! 	 */
XX! 	robrk ();
XX  
XX! 	/*
XX! 	 *   skip spaces
XX! 	 */
XX! 	for (i = 0; p[i] == ' ' || p[i] == '\t'; ++i)
XX! 		;
XX  
XX! 	/*
XX! 	 *   if not end of line, reset current temp indent
XX! 	 */
XX! #ifdef GEMDOS
XX! 	if (p[i] != '\n' && p[i] != '\r')
XX! 		dc.tival = i;
XX! #else
XX! 	if (p[i] != '\n' && p[i] != '\r')
XX! 		dc.tival = i;
XX! #endif
XX  
XX! 	/*
XX! 	 *   shift string
XX! 	 */
XX! 	for (j = 0; p[i] != EOS; ++j)
XX! 		p[j] = p[i++];
XX! 	p[j] = EOS;
XX  }
XX  
XX  
XX--- 239,267 ----
XX  /*------------------------------*/
XX  /*	leadbl			*/
XX  /*------------------------------*/
XX! void leadbl(p)
XX! register char *p;
XX  {
XX  
XX  /*
XX   *	delete leading blanks, set tival
XX   */
XX  
XX!   register int i;
XX!   register int j;
XX  
XX!   /* End current line and reset co struct */
XX!   robrk();
XX  
XX!   /* Skip spaces */
XX!   for (i = 0; p[i] == ' ' || p[i] == '\t'; ++i);
XX  
XX!   /* If not end of line, reset current temp indent */
XX!   if (p[i] != '\n' && p[i] != '\r') dc.tival = i;
XX  
XX!   /* Shift string */
XX!   for (j = 0; p[i] != EOS; ++j) p[j] = p[i++];
XX!   p[j] = EOS;
XX  }
XX  
XX  
XX***************
XX*** 360,388 ****
XX  /*------------------------------*/
XX  /*	pfoot			*/
XX  /*------------------------------*/
XX! pfoot ()
XX  {
XX  
XX  /*
XX   *	put out page footer
XX   */
XX  
XX! 	if (dc.prflg == TRUE)
XX! 	{
XX! 		skip (pg.m3val);
XX! 		if (pg.m4val > 0)
XX! 		{
XX! 			if ((pg.curpag % 2) == 0)
XX! 			{
XX! 				puttl (pg.efoot, pg.eflim, pg.curpag);
XX! 			}
XX! 			else
XX! 			{
XX! 				puttl (pg.ofoot, pg.oflim, pg.curpag);
XX! 			}
XX! 			skip (pg.m4val - 1);
XX  		}
XX  	}
XX  }
XX  
XX  
XX--- 271,294 ----
XX  /*------------------------------*/
XX  /*	pfoot			*/
XX  /*------------------------------*/
XX! void pfoot()
XX  {
XX  
XX  /*
XX   *	put out page footer
XX   */
XX  
XX!   if (dc.prflg == TRUE) {
XX! 	skip(pg.m3val);
XX! 	if (pg.m4val > 0) {
XX! 		if ((pg.curpag % 2) == 0) {
XX! 			puttl(pg.efoot, pg.eflim, pg.curpag);
XX! 		} else {
XX! 			puttl(pg.ofoot, pg.oflim, pg.curpag);
XX  		}
XX+ 		skip(pg.m4val - 1);
XX  	}
XX+   }
XX  }
XX  
XX  
XX***************
XX*** 392,436 ****
XX  /*------------------------------*/
XX  /*	phead			*/
XX  /*------------------------------*/
XX! phead ()
XX  {
XX  
XX  /*
XX   *	put out page header
XX   */
XX  
XX! 	pg.curpag = pg.newpag;
XX! 	if (pg.curpag >= pg.frstpg && pg.curpag <= pg.lastpg)
XX! 	{
XX! 		dc.prflg = TRUE;
XX! 	}
XX! 	else
XX! 	{
XX! 		dc.prflg = FALSE;
XX! 	}
XX! 	++pg.newpag;
XX! 	set_ireg ("%", pg.newpag, 0);
XX! 	if (dc.prflg == TRUE)
XX! 	{
XX! 		if (pg.m1val > 0)
XX! 		{
XX! 			skip (pg.m1val - 1);
XX! 			if ((pg.curpag % 2) == 0)
XX! 			{
XX! 				puttl (pg.ehead, pg.ehlim, pg.curpag);
XX! 			}
XX! 			else
XX! 			{
XX! 				puttl (pg.ohead, pg.ohlim, pg.curpag);
XX! 			}
XX  		}
XX- 		skip (pg.m2val);
XX  	}
XX! 	/* 
XX! 	 *	initialize lineno for the next page
XX! 	 */
XX! 	pg.lineno = pg.m1val + pg.m2val + 1;
XX! 	set_ireg ("ln", pg.lineno, 0);
XX  }
XX  
XX  
XX--- 298,333 ----
XX  /*------------------------------*/
XX  /*	phead			*/
XX  /*------------------------------*/
XX! void phead()
XX  {
XX  
XX  /*
XX   *	put out page header
XX   */
XX  
XX!   pg.curpag = pg.newpag;
XX!   if (pg.curpag >= pg.frstpg && pg.curpag <= pg.lastpg) {
XX! 	dc.prflg = TRUE;
XX!   } else {
XX! 	dc.prflg = FALSE;
XX!   }
XX!   ++pg.newpag;
XX!   set_ireg("%", pg.newpag, 0);
XX!   if (dc.prflg == TRUE) {
XX! 	if (pg.m1val > 0) {
XX! 		skip(pg.m1val - 1);
XX! 		if ((pg.curpag % 2) == 0) {
XX! 			puttl(pg.ehead, pg.ehlim, pg.curpag);
XX! 		} else {
XX! 			puttl(pg.ohead, pg.ohlim, pg.curpag);
XX  		}
XX  	}
XX! 	skip(pg.m2val);
XX!   }
XX! 
XX!   /* Initialize lineno for the next page */
XX!   pg.lineno = pg.m1val + pg.m2val + 1;
XX!   set_ireg("ln", pg.lineno, 0);
XX  }
XX  
XX  
XX***************
XX*** 439,486 ****
XX  /*------------------------------*/
XX  /*	puttl			*/
XX  /*------------------------------*/
XX! puttl (p, lim, pgno)
XX! register char  *p;
XX! int	       *lim;
XX! int		pgno;
XX  {
XX  
XX  /*
XX   *	put out title or footer
XX   */
XX  
XX! 	register int	i;
XX! 	char		pn[8];
XX! 	char		t[MAXLINE];
XX! 	char		h[MAXLINE];
XX! 	char		delim;
XX  
XX! 	itoda (pgno, pn, 6);
XX! 	for (i = 0; i < MAXLINE; ++i)
XX! 		h[i] = ' ';
XX! 	delim = *p++;
XX! 	p = getfield (p, t, delim);
XX! 	expand (t, dc.pgchr, pn);
XX! 	justleft (t, h, lim[LEFT]);
XX! 	p = getfield (p, t, delim);
XX! 	expand (t, dc.pgchr, pn);
XX! 	justcntr (t, h, lim);
XX! 	p = getfield (p, t, delim);
XX! 	expand (t, dc.pgchr, pn);
XX! 	justrite (t, h, lim[RIGHT]);
XX! 	for (i = MAXLINE - 4; h[i] == ' '; --i)
XX! 		h[i] = EOS;
XX! 	h[++i] = '\n';
XX! #ifdef GEMDOS
XX! 	h[++i] = '\r';
XX! #endif
XX! 	h[++i] = EOS;
XX! 	if (strlen (h) > 2)
XX! 	{
XX! 		for (i = 0; i < pg.offset; ++i)
XX! 			prchar (' ', out_stream);
XX! 	}
XX! 	putlin (h, out_stream);
XX  }
XX  
XX  
XX--- 336,376 ----
XX  /*------------------------------*/
XX  /*	puttl			*/
XX  /*------------------------------*/
XX! void puttl(p, lim, pgno)
XX! register char *p;
XX! int *lim;
XX! int pgno;
XX  {
XX  
XX  /*
XX   *	put out title or footer
XX   */
XX  
XX!   register int i;
XX!   char pn[8];
XX!   char t[MAXLINE];
XX!   char h[MAXLINE];
XX!   char delim;
XX  
XX!   itoda(pgno, pn, 6);
XX!   for (i = 0; i < MAXLINE; ++i) h[i] = ' ';
XX!   delim = *p++;
XX!   p = getfield(p, t, delim);
XX!   expand(t, dc.pgchr, pn);
XX!   justleft(t, h, lim[LEFT]);
XX!   p = getfield(p, t, delim);
XX!   expand(t, dc.pgchr, pn);
XX!   justcntr(t, h, lim);
XX!   p = getfield(p, t, delim);
XX!   expand(t, dc.pgchr, pn);
XX!   justrite(t, h, lim[RIGHT]);
XX!   for (i = MAXLINE - 4; h[i] == ' '; --i) h[i] = EOS;
XX!   h[++i] = '\n';
XX!   h[++i] = EOS;
XX!   if (strlen(h) > 2) {
XX! 	for (i = 0; i < pg.offset; ++i) prchar(' ', out_stream);
XX!   }
XX!   putlin(h, out_stream);
XX  }
XX  
XX  
XX***************
XX*** 490,578 ****
XX  /*------------------------------*/
XX  /*	putwrd			*/
XX  /*------------------------------*/
XX! putwrd (wrdbuf)
XX! register char  *wrdbuf;
XX  {
XX  
XX  /*
XX   *	put word in output buffer
XX   */
XX  
XX! 	register char  *p0;
XX! 	register char  *p1;
XX! 	int     	w;
XX! 	int     	last;
XX! 	int     	llval;
XX! 	int     	nextra;
XX  
XX  
XX  
XX! 	/*
XX! 	 *   check if this word puts us over the limit
XX! 	 */
XX! 	w     = width (wrdbuf);
XX! 	last  = strlen (wrdbuf) + co.outp;
XX! 	llval = dc.rmval - dc.tival;
XX! 	co.outesc += countesc (wrdbuf);
XX! 	if (((co.outp > 0) && ((co.outw + w - co.outesc) > llval))
XX! 	||   (last > MAXLINE))
XX! 	{
XX! 		/*
XX! 		 *   last word exceeds limit so prepare to break line, print
XX! 		 *   it, and reset outbuf.
XX! 		 */
XX! 		last -= co.outp;
XX! 		if (dc.juval == YES)
XX! 		{
XX! 			nextra = llval - co.outw + 1;
XX  
XX! 			/*
XX! 			 *	Do not take in the escape char of the
XX! 			 * 	word that didn't fit on this line anymore
XX! 			 */
XX! 			 co.outesc -= countesc (wrdbuf);
XX! 			
XX! 			/* 
XX! 			 *	Check whether last word was end of
XX! 			 *	sentence and modify counts so that
XX! 			 *	it is right justified.
XX! 			 */
XX! 			if (co.outbuf[co.outp - 2] == ' ')
XX! 			{
XX! 				--co.outp;
XX! 				++nextra;
XX! 			}
XX! 			spread (co.outbuf, co.outp - 1, nextra, 
XX! 							co.outwds, co.outesc);
XX! 			if ((nextra + co.outesc > 0) && (co.outwds > 1))
XX! 			{
XX! 				co.outp += (nextra + co.outesc - 1);
XX! 			}
XX! 		}
XX  
XX! 		/*
XX! 		 *   break line, output it, and reset all co members. reset
XX! 		 *   esc count.
XX! 		 */
XX! 		robrk ();
XX! 
XX! 		co.outesc = countesc (wrdbuf);
XX  	}
XX  
XX  
XX! 	/*
XX! 	 *   copy the current word to the out buffer which may have been
XX! 	 *   reset
XX! 	 */
XX! 	p0 = wrdbuf;
XX! 	p1 = co.outbuf + co.outp;
XX! 	while (*p0 != EOS)
XX! 		*p1++ = *p0++;
XX  
XX! 	co.outp              = last;
XX! 	co.outbuf[co.outp++] = ' ';
XX! 	co.outw             += w + 1;
XX! 	co.outwds           += 1;
XX  }
XX  
XX  
XX--- 380,448 ----
XX  /*------------------------------*/
XX  /*	putwrd			*/
XX  /*------------------------------*/
XX! void putwrd(wrdbuf)
XX! register char *wrdbuf;
XX  {
XX  
XX  /*
XX   *	put word in output buffer
XX   */
XX  
XX!   register char *p0;
XX!   register char *p1;
XX!   int w;
XX!   int last;
XX!   int llval;
XX!   int nextra;
XX  
XX  
XX  
XX!   /* Check if this word puts us over the limit */
XX!   w = width(wrdbuf);
XX!   last = strlen(wrdbuf) + co.outp;
XX!   llval = dc.rmval - dc.tival;
XX!   co.outesc += countesc(wrdbuf);
XX!   if (((co.outp > 0) && ((co.outw + w - co.outesc) > llval))
XX!       || (last > MAXLINE)) {
XX! 	/* Last word exceeds limit so prepare to break line, print
XX! 	 * it, and reset outbuf. */
XX! 	last -= co.outp;
XX! 	if (dc.juval == YES) {
XX! 		nextra = llval - co.outw + 1;
XX  
XX! 		/* Do not take in the escape char of the word that
XX! 		 * didn't fit on this line anymore */
XX! 		co.outesc -= countesc(wrdbuf);
XX  
XX! 		/* Check whether last word was end of sentence and
XX! 		 * modify counts so that it is right justified. */
XX! 		if (co.outbuf[co.outp - 2] == ' ') {
XX! 			--co.outp;
XX! 			++nextra;
XX! 		}
XX! 		spread(co.outbuf, co.outp - 1, nextra,
XX! 		       co.outwds, co.outesc);
XX! 		if ((nextra + co.outesc > 0) && (co.outwds > 1)) {
XX! 			co.outp += (nextra + co.outesc - 1);
XX! 		}
XX  	}
XX  
XX+ 	/* Break line, output it, and reset all co members. reset esc
XX+ 	 * count. */
XX+ 	robrk();
XX  
XX! 	co.outesc = countesc(wrdbuf);
XX!   }
XX  
XX!   /* Copy the current word to the out buffer which may have been reset */
XX!   p0 = wrdbuf;
XX!   p1 = co.outbuf + co.outp;
XX!   while (*p0 != EOS) *p1++ = *p0++;
XX! 
XX!   co.outp = last;
XX!   co.outbuf[co.outp++] = ' ';
XX!   co.outw += w + 1;
XX!   co.outwds += 1;
XX  }
XX  
XX  
XX***************
XX*** 581,606 ****
XX  /*------------------------------*/
XX  /*	skip			*/
XX  /*------------------------------*/
XX! skip (n)
XX! register int	n;
XX  {
XX  
XX  /*
XX   *	skips the number of lines specified by n.
XX   */
XX  
XX! 	register int	i;
XX  
XX! 	if (dc.prflg == TRUE && n > 0)
XX! 	{
XX! 		for (i = 0; i < n; ++i)
XX! 		{
XX! 			prchar ('\n', out_stream);
XX! 		}
XX! #ifdef GEMDOS
XX! 		prchar ('\r', out_stream);
XX! #endif
XX  	}
XX  }
XX  
XX  
XX--- 451,471 ----
XX  /*------------------------------*/
XX  /*	skip			*/
XX  /*------------------------------*/
XX! void skip(n)
XX! register int n;
XX  {
XX  
XX  /*
XX   *	skips the number of lines specified by n.
XX   */
XX  
XX!   register int i;
XX  
XX!   if (dc.prflg == TRUE && n > 0) {
XX! 	for (i = 0; i < n; ++i) {
XX! 		prchar('\n', out_stream);
XX  	}
XX+   }
XX  }
XX  
XX  
XX***************
XX*** 610,670 ****
XX  /*------------------------------*/
XX  /*	spread			*/
XX  /*------------------------------*/
XX! spread (p, outp, nextra, outwds, escapes)
XX! register char  *p;
XX! int     	outp;
XX! int		nextra;
XX! int		outwds;
XX! int		escapes;
XX  {
XX  
XX  /*
XX   *	spread words to justify right margin
XX   */
XX  
XX! 	register int	i;
XX! 	register int	j;
XX! 	register int	nb;
XX! 	register int	ne;
XX! 	register int	nholes;
XX! 	int		jmin;
XX  
XX  
XX! 	/*
XX! 	 *   quick sanity check...
XX! 	 */
XX! 	if ((nextra + escapes < 1) || (outwds < 2))
XX! 		return;
XX  
XX! 	/*
XX! 	 *   set up for the spread and do it...
XX! 	 */
XX! 	dc.sprdir = ~dc.sprdir;
XX! 	ne        = nextra + escapes;
XX! 	nholes    = outwds - 1;			/* holes between words */
XX! 	i         = outp - 1;			/* last non-blank character */
XX! 	j         = min (MAXLINE - 3, i + ne);	/* leave room for CR,LF,EOS */
XX  
XX! 	while (i < j)
XX! 	{
XX! 		p[j] = p[i];
XX! 		if (p[i] == ' ')
XX! 		{
XX! 			if (dc.sprdir == 0)
XX! 				nb = (ne - 1) / nholes + 1;
XX! 			else
XX! 				nb = ne / nholes;
XX! 			ne -= nb;
XX! 			--nholes;
XX! 			for (; nb > 0; --nb)
XX! 			{
XX! 				--j;
XX! 				p[j] = ' ';
XX! 			}
XX  		}
XX- 		--i;
XX- 		--j;
XX  	}
XX  }
XX  
XX  
XX--- 475,526 ----
XX  /*------------------------------*/
XX  /*	spread			*/
XX  /*------------------------------*/
XX! void spread(p, outp, nextra, outwds, escapes)
XX! register char *p;
XX! int outp;
XX! int nextra;
XX! int outwds;
XX! int escapes;
XX  {
XX  
XX  /*
XX   *	spread words to justify right margin
XX   */
XX  
XX!   register int i;
XX!   register int j;
XX!   register int nb;
XX!   register int ne;
XX!   register int nholes;
XX  
XX  
XX!   /* Quick sanity check... */
XX!   if ((nextra + escapes < 1) || (outwds < 2)) return;
XX  
XX!   /* Set up for the spread and do it... */
XX!   dc.sprdir = ~dc.sprdir;
XX!   ne = nextra + escapes;
XX!   nholes = outwds - 1;		/* holes between words */
XX!   i = outp - 1;			/* last non-blank character */
XX!   j = min(MAXLINE - 3, i + ne);	/* leave room for CR,LF,EOS */
XX  
XX!   while (i < j) {
XX! 	p[j] = p[i];
XX! 	if (p[i] == ' ') {
XX! 		if (dc.sprdir == 0)
XX! 			nb = (ne - 1) / nholes + 1;
XX! 		else
XX! 			nb = ne / nholes;
XX! 		ne -= nb;
XX! 		--nholes;
XX! 		for (; nb > 0; --nb) {
XX! 			--j;
XX! 			p[j] = ' ';
XX  		}
XX  	}
XX+ 	--i;
XX+ 	--j;
XX+   }
XX  }
XX  
XX  
XX***************
XX*** 674,716 ****
XX  /*------------------------------*/
XX  /*	strkovr			*/
XX  /*------------------------------*/
XX! strkovr (p, q)
XX! register char  *p;
XX! register char  *q;
XX  {
XX  
XX  /*
XX   *	split overstrikes (backspaces) into seperate buffer
XX   */
XX  
XX! 	register char  *pp;
XX! 	int		bsflg;
XX  
XX! 	bsflg = FALSE;
XX! 	pp = p;
XX! 	while (*p != EOS)
XX! 	{
XX! 		*q = ' ';
XX! 		*pp = *p;
XX! 		++p;
XX! 		if (*p == '\b')
XX! 		{
XX! 			if (*pp >= ' ' && *pp <= '~')
XX! 			{
XX! 				bsflg = TRUE;
XX! 				*q = *pp;
XX! 				++p;
XX! 				*pp = *p;
XX! 				++p;
XX! 			}
XX  		}
XX- 		++q;
XX- 		++pp;
XX  	}
XX! 	*q++ = '\r';
XX! 	*q = *pp = EOS;
XX  
XX! 	return (bsflg);
XX  }
XX  
XX  
XX--- 530,569 ----
XX  /*------------------------------*/
XX  /*	strkovr			*/
XX  /*------------------------------*/
XX! int strkovr(p, q)
XX! register char *p;
XX! register char *q;
XX  {
XX  
XX  /*
XX   *	split overstrikes (backspaces) into seperate buffer
XX   */
XX  
XX!   register char *pp;
XX!   int bsflg;
XX  
XX!   bsflg = FALSE;
XX!   pp = p;
XX!   while (*p != EOS) {
XX! 	*q = ' ';
XX! 	*pp = *p;
XX! 	++p;
XX! 	if (*p == '\b') {
XX! 		if (*pp >= ' ' && *pp <= '~') {
XX! 			bsflg = TRUE;
XX! 			*q = *pp;
XX! 			++p;
XX! 			*pp = *p;
XX! 			++p;
XX  		}
XX  	}
XX! 	++q;
XX! 	++pp;
XX!   }
XX!   *q++ = '\r';
XX!   *q = *pp = EOS;
XX  
XX!   return(bsflg);
XX  }
XX  
XX  
XX***************
XX*** 720,756 ****
XX  /*------------------------------*/
XX  /*	underl			*/
XX  /*------------------------------*/
XX! underl (p0, p1, size)
XX! register char  *p0;
XX! register char  *p1;
XX! int		size;
XX  {
XX  
XX  /*
XX   *	underline a line
XX   */
XX  
XX! 	register int	i;
XX! 	register int	j;
XX  
XX! 	j = 0;
XX! 	for (i = 0; (p0[i] != '\n') && (j < size - 1); ++i)
XX! 	{
XX! 		if (p0[i] >= ' ' && p0[i] <= '~')
XX! 		{
XX! 			if (isalpha (p0[i]) || isdigit (p0[i]) || dc.cuval > 0)
XX! 			{
XX! 				p1[j++] = '_';
XX! 				p1[j++] = '\b';
XX! 			}
XX  		}
XX- 		p1[j++] = p0[i];
XX  	}
XX! 	p1[j++] = '\n';
XX! 	p1[j] = EOS;
XX! 	while (*p1 != EOS)
XX! 		*p0++ = *p1++;
XX! 	*p0 = EOS;
XX  }
XX  
XX  
XX--- 573,605 ----
XX  /*------------------------------*/
XX  /*	underl			*/
XX  /*------------------------------*/
XX! void underl(p0, p1, size)
XX! register char *p0;
XX! register char *p1;
XX! int size;
XX  {
XX  
XX  /*
XX   *	underline a line
XX   */
XX  
XX!   register int i;
XX!   register int j;
XX  
XX!   j = 0;
XX!   for (i = 0; (p0[i] != '\n') && (j < size - 1); ++i) {
XX! 	if (p0[i] >= ' ' && p0[i] <= '~') {
XX! 		if (isalpha(p0[i]) || isdigit(p0[i]) || dc.cuval > 0) {
XX! 			p1[j++] = '_';
XX! 			p1[j++] = '\b';
XX  		}
XX  	}
XX! 	p1[j++] = p0[i];
XX!   }
XX!   p1[j++] = '\n';
XX!   p1[j] = EOS;
XX!   while (*p1 != EOS) *p0++ = *p1++;
XX!   *p0 = EOS;
XX  }
XX  
XX  
XX***************
XX*** 759,783 ****
XX  /*------------------------------*/
XX  /*	width			*/
XX  /*------------------------------*/
XX! width (s)
XX! register char  *s;
XX  {
XX  
XX  /*
XX   *	compute width of character string
XX   */
XX  
XX! 	register int	w;
XX  
XX! 	w = 0;
XX! 	while (*s != EOS)
XX! 	{
XX! 		if (*s == '\b')
XX! 			--w;
XX! 		else if (*s != '\n' && *s != '\r')
XX! 			++w;
XX! 		++s;
XX! 	}
XX  
XX! 	return (w);
XX  }
XX--- 608,631 ----
XX  /*------------------------------*/
XX  /*	width			*/
XX  /*------------------------------*/
XX! int width(s)
XX! register char *s;
XX  {
XX  
XX  /*
XX   *	compute width of character string
XX   */
XX  
XX!   register int w;
XX  
XX!   w = 0;
XX!   while (*s != EOS) {
XX! 	if (*s == '\b')
XX! 		--w;
XX! 	else if (*s != '\n' && *s != '\r')
XX! 		++w;
XX! 	++s;
XX!   }
XX  
XX!   return(w);
XX  }
X/
/
