echo x - Makefile.ansi
sed '/^X/s///' > Makefile.ansi << '/'
XCC=exec cc
XCFLAGS= -c -O -D_MINIX -D_POSIX_SOURCE
X
X
Xall:	
X	@$(CC) $(CFLAGS) *.c
X
X
Xclean:	
X	@rm -rf *.o *.s *.bak
X
/
echo x - Makefile.kr
sed '/^X/s///' > Makefile.kr << '/'
XCC=exec cc
XCFLAGS= -c -O -LIB -D_MINIX -D_POSIX_SOURCE
X
X
Xall:	
X	@$(CC) $(CFLAGS) _[a-l]*.c
X	@$(CC) $(CFLAGS) _[m-z]*.c
X
X
Xclean:	
X	@rm -rf *.o *.s *.bak
X
/
echo x - _access.c
sed '/^X/s///' > _access.c << '/'
X#include <lib.h>
X#define access	_access
X#include <unistd.h>
X
XPUBLIC int access(name, mode)
X_CONST char *name;
Xint mode;
X{
X  message m;
X
X  m.m3_i2 = mode;
X  _loadname(name, &m);
X  return(_syscall(FS, ACCESS, &m));
X}
/
echo x - _alarm.c
sed '/^X/s///' > _alarm.c << '/'
X#include <lib.h>
X#define alarm	_alarm
X#include <unistd.h>
X
XPUBLIC unsigned int alarm(sec)
Xunsigned int sec;
X{
X  message m;
X
X  m.m1_i1 = (int) sec;
X  return( (unsigned) _syscall(MM, ALARM, &m));
X}
/
echo x - _brk.c
sed '/^X/s///' > _brk.c << '/'
X#include <lib.h>
X#define brk	_brk
X#define sbrk	_sbrk
X#include <unistd.h>
X
Xextern char *_brksize;
X
X/* Both OSF/1 and SYSVR4 man pages specify that brk(2) returns int.
X * However, BSD4.3 specifies that brk() returns char*.  POSIX omits
X * discussion of brk() on the grounds that it imposes a memory
X * model on an architecture.
X */
XPUBLIC int brk(addr)
Xchar *addr;
X{
X  message m;
X
X  m.m1_p1 = addr;
X  if (_syscall(MM, BRK, &m) < 0) return(-1);
X  _brksize = m.m2_p1;
X  return(0);
X}
X
X
XPUBLIC char *sbrk(incr)
Xint incr;
X{
X  char *newsize, *oldsize;
X
X  oldsize = _brksize;
X  newsize = _brksize + incr;
X  if (incr > 0 && newsize < oldsize || incr < 0 && newsize > oldsize)
X	return( (char *) -1);
X  if (brk(newsize) == 0)
X	return(oldsize);
X  else
X	return( (char *) -1);
X}
/
echo x - _chdir.c
sed '/^X/s///' > _chdir.c << '/'
X#include <lib.h>
X#define chdir	_chdir
X#include <unistd.h>
X
XPUBLIC int chdir(name)
X_CONST char *name;
X{
X  message m;
X
X  _loadname(name, &m);
X  return(_syscall(FS, CHDIR, &m));
X}
/
echo x - _chmod.c
sed '/^X/s///' > _chmod.c << '/'
X#include <lib.h>
X#define chmod	_chmod
X#include <sys/stat.h>
X
XPUBLIC int chmod(name, mode)
X_CONST char *name;
XMode_t mode;
X{
X  message m;
X
X  m.m3_i2 = mode;
X  _loadname(name, &m);
X  return(_syscall(FS, CHMOD, &m));
X}
/
echo x - _chown.c
sed '/^X/s///' > _chown.c << '/'
X#include <lib.h>
X#define chown	_chown
X#include <string.h>
X#include <unistd.h>
X
XPUBLIC int chown(name, owner, grp)
X_CONST char *name;
XUid_t owner;
XGid_t grp;
X{
X  message m;
X
X  m.m1_i1 = strlen(name) + 1;
X  m.m1_i2 = owner;
X  m.m1_i3 = grp;
X  m.m1_p1 = (char *) name;
X  return(_syscall(FS, CHOWN, &m));
X}
/
echo x - _chroot.c
sed '/^X/s///' > _chroot.c << '/'
X#include <lib.h>
X#define chroot	_chroot
X#include <unistd.h>
X
XPUBLIC int chroot(name)
X_CONST char *name;
X{
X  message m;
X
X  _loadname(name, &m);
X  return(_syscall(FS, CHROOT, &m));
X}
/
echo x - _close.c
sed '/^X/s///' > _close.c << '/'
X#include <lib.h>
X#define close	_close
X#include <unistd.h>
X
XPUBLIC int close(fd)
Xint fd;
X{
X  message m;
X
X  m.m1_i1 = fd;
X  return(_syscall(FS, CLOSE, &m));
X}
/
echo x - _creat.c
sed '/^X/s///' > _creat.c << '/'
X#include <lib.h>
X#define creat	_creat
X#include <fcntl.h>
X
XPUBLIC int creat(name, mode)
X_CONST char *name;
XMode_t mode;
X{
X  message m;
X
X  m.m3_i2 = mode;
X  _loadname(name, &m);
X  return(_syscall(FS, CREAT, &m));
X}
/
echo x - _dup.c
sed '/^X/s///' > _dup.c << '/'
X#include <lib.h>
X#define dup	_dup
X#define fcntl	_fcntl
X#include <fcntl.h>
X#include <unistd.h>
X
XPUBLIC int dup(fd)
Xint fd;
X{
X  return(fcntl(fd, F_DUPFD, 0));
X}
/
echo x - _dup2.c
sed '/^X/s///' > _dup2.c << '/'
X#include <lib.h>
X#define close	_close
X#define dup2	_dup2
X#define fcntl	_fcntl
X#include <fcntl.h>
X#include <unistd.h>
X
XPUBLIC int dup2(fd, fd2)
Xint fd, fd2;
X{
X/* The behavior of dup2 is defined by POSIX in 6.2.1.2 as almost, but not
X * quite the same as fcntl.
X */
X
X  if (fd2 < 0 || fd2 > OPEN_MAX) {
X	errno = EBADF;
X	return(-1);
X  }
X
X  /* Check to see if fildes is valid. */
X  if (fcntl(fd, F_GETFL) < 0) {
X	/* 'fd' is not valid. */
X	return(-1);
X  } else {
X	/* 'fd' is valid. */
X	if (fd == fd2) return(fd2);
X	close(fd2);
X	return(fcntl(fd, F_DUPFD, fd2));
X  }
X}
/
echo x - _exec.c
sed '/^X/s///' > _exec.c << '/'
X#include <lib.h>
X#define execl	_execl
X#define execle	_execle
X#define execv	_execv
X#define execve	_execve
X#define sbrk	_sbrk
X#include <minix/minlib.h>
X#include <stdarg.h>
X#include <string.h>
X#include <unistd.h>
X
Xextern char **environ;
X
X#define	PTRSIZE	(sizeof(char *))
X
X#ifdef _ANSI
XPUBLIC int execl(const char *name, const char *arg, ...)
X#else
XPUBLIC int execl(name)
Xchar *name;
X#endif
X{
X  va_list argp;
X  int result;
X
X  va_start(argp, name);
X
X  /* The following cast of argp is not portable.  Doing it right by copying
X   * the args to a true array will cost as much as ARG_MAX bytes of space.
X   */
X  result = execve(name, (char **) argp, environ);
X  va_end(argp);
X  return(result);
X}
X
X
X#ifdef _ANSI
XPUBLIC int execle(const char *name, const char *arg, ...)
X#else
XPUBLIC int execle(name)
Xchar *name;
X#endif
X{
X  va_list argp;
X  char **p;
X  int result;
X
X  va_start(argp, name);
X  
X  /* The following cast of argp is not portable, as for execl(). */
X  p = (char **) argp;
X  while (*p++ != NIL_PTR)
X	;			/* null statement */
X  result = execve(name, (char **) argp, (char **) *p);
X  va_end(argp);
X  return(result);
X}
X
X
XPUBLIC int execv(name, argv)
X_CONST char *name;
Xchar * _CONST argv[];
X{
X  return(execve(name, argv, environ));
X}
X
X
XPUBLIC int execve(path, argv, envp)
X_CONST char *path;		/* pointer to name of file to be executed */
Xchar * _CONST argv[];		/* pointer to argument array */
Xchar * _CONST envp[];		/* pointer to environment */
X{
X  int i, j;
X
X  /* Count the argument pointers and environment pointers. */
X  i = 0;
X  while (argv[i] != NULL) i++;
X  j = 0;
X  while (envp[j] != NULL) j++;
X
X  return(__execve(path, argv, envp, i, j));
X}
X
X
XPUBLIC int __execve(path, argv, envp, nargs, nenvps)
X_CONST char *path;		/* pointer to name of file to be executed */
Xchar * _CONST argv[];		/* pointer to argument array */
Xchar * _CONST envp[];		/* pointer to environment */
Xint nargs;			/* number of args */
Xint nenvps;			/* number of environment strings */
X{
X/* This is split off from execve to be called from execvp, so execvp does not
X * have to allocate up to ARG_MAX bytes just to prepend "sh" to the arg array.
X */
X
X  char *hp, **ap, *p;
X  int i, stackbytes, npointers, overflow, temp;
X  char *stack;
X  message m;
X
X  /* Decide how big a stack is needed. Be paranoid about overflow. */
X  overflow = FALSE;
X  npointers = 1 + nargs + 1 + nenvps + 1;	/* 1's for argc and NULLs */
X  stackbytes = nargs + nenvps;		/* 1 byte for each null in strings */
X  if (nargs < 0 || nenvps < 0 || stackbytes < nargs || npointers < stackbytes)
X	overflow = TRUE;
X  for (i = PTRSIZE; i != 0; i--) {
X	temp = stackbytes + npointers;
X	if (temp < stackbytes) overflow = TRUE;
X	stackbytes = temp;
X  }
X  ap = (char **) argv;
X  for (i = 0; i < nargs; i++) {
X	temp = stackbytes + strlen(*ap++);
X	if (temp < stackbytes) overflow = TRUE;
X	stackbytes = temp;
X  }
X  ap = (char **) envp;
X  for (i = 0; i < nenvps; i++) {
X	temp = stackbytes + strlen(*ap++);
X	if (temp < stackbytes) overflow = TRUE;
X	stackbytes = temp;
X  }
X  temp = stackbytes + PTRSIZE - 1;
X  if (temp < stackbytes) overflow = TRUE;
X  stackbytes = (temp / PTRSIZE) * PTRSIZE;
X
X  /* Check for overflow before committing sbrk. */
X  if (overflow) {
X	errno = E2BIG;
X	return(-1);
X  }
X
X  /* Allocate the stack. */
X  stack = sbrk(stackbytes);
X  if (stack == (char *) -1) {
X	errno = E2BIG;
X	return(-1);
X  }
X
X  /* Prepare the stack vector and argc. */
X  ap = (char **) stack;
X  hp = &stack[npointers * PTRSIZE];
X  *ap++ = (char *) nargs;
X
X  /* Prepare the argument pointers and strings. */
X  for (i = 0; i < nargs; i++) {
X	*ap++ = (char *) (hp - stack);
X	p = *argv++;
X	while ( (*hp++ = *p++) != 0)
X		;
X  }
X  *ap++ = (char *) NULL;
X
X  /* Prepare the environment pointers and strings. */
X  for (i = 0; i < nenvps; i++) {
X	*ap++ = (char *) (hp - stack);
X	p = *envp++;
X	while ( (*hp++ = *p++) != 0)
X		;
X  }
X  *ap++ = (char *) NULL;
X
X  /* Do the real work. */
X  m.m1_i1 = strlen(path) + 1;
X  m.m1_i2 = stackbytes;
X  m.m1_p1 = (char *) path;
X  m.m1_p2 = stack;
X  (void) _syscall(MM, EXEC, &m);
X
X  /* The exec failed. */
X  sbrk(-stackbytes);
X  return(m.m_type);
X}
/
echo x - _execn.c
sed '/^X/s///' > _execn.c << '/'
X#include <lib.h>
X#include <string.h>
X
X#define	PTRSIZE	sizeof(char *)
X_PROTOTYPE( int _execn, (char * name));
X
XPUBLIC int _execn(name)
Xchar *name;			/* pointer to file to be exec'd */
X{
X/* Special version used when there are no args and no environment.  This call
X * is principally used by INIT, to avoid having to allocate ARG_MAX.
X */
X
X  PRIVATE char stack[3 * PTRSIZE];
X  message m;
X
X  m.m1_i1 = strlen(name) + 1;
X  m.m1_i2 = sizeof(stack);
X  m.m1_p1 = name;
X  m.m1_p2 = stack;
X  (void) _syscall(MM, EXEC, &m);
X}
/
echo x - _exit.c
sed '/^X/s///' > _exit.c << '/'
X#include <lib.h>
X#include <unistd.h>
X
XPUBLIC void _exit(status)
Xint status;
X{
X  message m;
X
X  m.m1_i1 = status;
X  _syscall(MM, EXIT, &m);
X}
/
echo x - _fcntl.c
sed '/^X/s///' > _fcntl.c << '/'
X#include <lib.h>
X#define fcntl _fcntl
X#include <fcntl.h>
X#include <stdarg.h>
X
X#if _ANSI
XPUBLIC int fcntl(int fd, int cmd, ...)
X#else
XPUBLIC int fcntl(fd, cmd)
Xint fd;
Xint cmd;
X#endif
X{
X  va_list argp;
X  message m;
X
X  va_start(argp, cmd);
X
X  /* Set up for the sensible case where there is no variable parameter.  This
X   * covers F_GETFD, F_GETFL and invalid commands.
X   */
X  m.m1_i3 = 0;
X  m.m1_p1 = NIL_PTR;
X
X  /* Adjust for the stupid cases. */
X  switch(cmd) {
X     case F_DUPFD:
X     case F_SETFD:
X     case F_SETFL:
X	m.m1_i3 = va_arg(argp, int);
X	break;
X     case F_GETLK:
X     case F_SETLK:
X     case F_SETLKW:
X	m.m1_p1 = (char *) va_arg(argp, struct flock *);
X	break;
X  }
X
X  /* Clean up and make the system call. */
X  va_end(argp);
X  m.m1_i1 = fd;
X  m.m1_i2 = cmd;
X  return(_syscall(FS, FCNTL, &m));
X}
/
echo x - _fork.c
sed '/^X/s///' > _fork.c << '/'
X#include <lib.h>
X#define fork	_fork
X#include <unistd.h>
X
XPUBLIC pid_t fork()
X{
X  message m;
X
X  return(_syscall(MM, FORK, &m));
X}
/
echo x - _fpathconf.c
sed '/^X/s///' > _fpathconf.c << '/'
X/* POSIX fpathconf (Sec. 5.7.1) 		Author: Andy Tanenbaum */
X
X#include <lib.h>
X#define fstat		_fstat
X#define fpathconf	_fpathconf
X#include <sys/stat.h>
X#include <errno.h>
X#include <limits.h>
X#include <unistd.h>
X
XPUBLIC long fpathconf(fd, name)
Xint fd;				/* file descriptor being interrogated */
Xint name;			/* property being inspected */
X{
X/* POSIX allows some of the values in <limits.h> to be increased at
X * run time.  The pathconf and fpathconf functions allow these values
X * to be checked at run time.  MINIX does not use this facility.
X * The run-time limits are those given in <limits.h>.
X */
X
X  struct stat stbuf;
X
X  switch(name) {
X	case _PC_LINK_MAX:
X		/* Fstat the file.  If that fails, return -1. */
X		if (fstat(fd, &stbuf) != 0) return(-1);
X		if (S_ISDIR(stbuf.st_mode))
X			return(1L);	/* no links to directories */
X		else
X			return( (long) LINK_MAX);
X
X	case _PC_MAX_CANON:
X		return( (long) MAX_CANON);
X
X	case _PC_MAX_INPUT:
X		return( (long) MAX_INPUT);
X
X	case _PC_NAME_MAX:
X		return( (long) NAME_MAX);
X
X	case _PC_PATH_MAX:
X		return( (long) PATH_MAX);
X
X	case _PC_PIPE_BUF:
X		return( (long) PIPE_BUF);
X
X	case _PC_CHOWN_RESTRICTED:
X		return( (long) _POSIX_CHOWN_RESTRICTED);
X
X	case _PC_NO_TRUNC:
X		return( (long) _POSIX_NO_TRUNC);
X
X	case _PC_VDISABLE:
X		return( (long) _POSIX_VDISABLE);
X
X	default:
X		errno = EINVAL;
X		return(-1);
X  }
X}
/
echo x - _fstat.c
sed '/^X/s///' > _fstat.c << '/'
X#include <lib.h>
X#define fstat	_fstat
X#include <sys/stat.h>
X
XPUBLIC int fstat(fd, buffer)
Xint fd;
Xstruct stat *buffer;
X{
X  message m;
X
X  m.m1_i1 = fd;
X  m.m1_p1 = (char *) buffer;
X  return(_syscall(FS, FSTAT, &m));
X}
/
echo x - _getcwd.c
sed '/^X/s///' > _getcwd.c << '/'
X/*  getcwd - get current working directory	Author: Terrence W. Holm */
X
X/* Directly derived from Adri Koppes' pwd(1).
X * Modified by Andy Tanenbaum for POSIX (29 Oct. 1989)
X */
X
X#include <lib.h>
X#define getcwd	_getcwd
X#include <sys/dir.h>
X#include <sys/stat.h>
X#include <fcntl.h>
X#include <string.h>
X#include <unistd.h>
X
X#define  DIRECT_SIZE  (sizeof (struct direct))
X
XFORWARD _PROTOTYPE( void go_back, (char *path) );
X
Xchar *getcwd(buffer, size)
Xchar *buffer;
Xsize_t size;
X/* Get current working directory. */
X{
X  int same_device, found, fd;
X  char *r, path[PATH_MAX + 1], temp_name[NAME_MAX + 1];
X  struct stat current, parent, dir_entry;
X  struct direct d;
X
X  if (buffer == (char *) NULL || size <= 0) {
X	errno = EINVAL;
X	return( (char *) NULL);
X  }
X  path[0] = '\0';
X
X  /* Get the inode for the current directory  */
X  if (stat(".", &current) < 0) return( (char *) NULL);
X  if ( (current.st_mode & S_IFMT) != S_IFDIR) return( (char *) NULL);
X
X  /* Run backwards up the directory tree, grabbing dir names on the way. */
X  while (1) {
X	same_device = 0;
X	found = 0;
X
X	/* Get the inode for the parent directory  */
X	if (chdir("..") < 0) return( (char *) NULL);
X	if (stat(".", &parent) < 0) return( (char *) NULL);
X	if ( (parent.st_mode & S_IFMT) != S_IFDIR) return( (char *) NULL);
X	if (current.st_dev == parent.st_dev) same_device = 1;
X
X	/* At the root, "." is the same as ".."  */
X	if (same_device && current.st_ino == parent.st_ino) break;
X
X	/* Search the parent directory for the current entry  */
X	if ( (fd = open(".", O_RDONLY)) < 0) return( (char *) NULL);
X	while (!found && read(fd, (char *)&d, DIRECT_SIZE) == DIRECT_SIZE) {
X		if (d.d_ino == 0L) continue;	/* empty slot */
X		if (same_device) {
X			if (current.st_ino == d.d_ino) found = 1;
X		} else {
X			temp_name[0] = '\0';
X			strncat(temp_name, d.d_name, NAME_MAX);
X			if (stat(temp_name, &dir_entry) < 0) {
X				close(fd);
X				go_back(path);
X				return( (char *) NULL);
X			}
X			if (current.st_dev == dir_entry.st_dev &&
X			    current.st_ino == dir_entry.st_ino)
X				found = 1;
X		}
X	}
X
X	close(fd);
X	if (!found) {
X		go_back(path);
X		return( (char *) NULL);
X	}
X	if (strlen(path) + NAME_MAX + 1 > PATH_MAX) {
X		errno = ERANGE;
X		go_back(path);
X		return( (char *) NULL);
X	}
X	strcat(path, "/");
X	strncat(path, d.d_name, NAME_MAX);
X	current.st_dev = parent.st_dev;
X	current.st_ino = parent.st_ino;
X  }
X
X  /* Copy the reversed path name into <buffer>  */
X  if (strlen(path) + 1 > size) {
X	errno = ERANGE;
X	go_back(path);
X	return( (char *) NULL);
X  }
X  if (strlen(path) == 0) {
X	strcpy(buffer, "/");
X	return(buffer);
X  }
X  *buffer = '\0';
X  while ( (r = strrchr(path, '/')) != (char *) NULL) {
X	strcat(buffer, r);
X	*r = '\0';
X  }
X  return(chdir(buffer) ? (char *) NULL : buffer);
X}
X
XPRIVATE void go_back(path)
Xchar *path;
X{
X/* If getcwd() gets in trouble and can't complete normally, reverse the
X * path built so far and change there so we end up in the directory that
X * we started in.
X */
X
X  char *r;
X
X  while ( (r = strrchr(path, '/')) != (char *) NULL) {
X	chdir(r+1);
X	*r = '\0';
X  }
X}
/
echo x - _getegid.c
sed '/^X/s///' > _getegid.c << '/'
X#include <lib.h>
X#define getegid	_getegid
X#include <unistd.h>
X
XPUBLIC gid_t getegid()
X{
X  message m;
X
X  /* POSIX says that this function is always successful and that no
X   * return value is reserved to indicate an error.  Minix syscalls
X   * are not always successful and Minix returns the unreserved value
X   * (gid_t) -1 when there is an error.
X   */
X  if (_syscall(MM, GETGID, &m) < 0) return ( (gid_t) -1);
X  return( (gid_t) m.m2_i1);
X}
/
echo x - _geteuid.c
sed '/^X/s///' > _geteuid.c << '/'
X#include <lib.h>
X#define geteuid	_geteuid
X#include <unistd.h>
X
XPUBLIC uid_t geteuid()
X{
X  message m;
X
X  /* POSIX says that this function is always successful and that no
X   * return value is reserved to indicate an error.  Minix syscalls
X   * are not always successful and Minix returns the unreserved value
X   * (uid_t) -1 when there is an error.
X   */
X  if (_syscall(MM, GETUID, &m) < 0) return ( (uid_t) -1);
X  return( (uid_t) m.m2_i1);
X}
/
echo x - _getgid.c
sed '/^X/s///' > _getgid.c << '/'
X#include <lib.h>
X#define getgid	_getgid
X#include <unistd.h>
X
XPUBLIC gid_t getgid()
X{
X  message m;
X
X  return( (gid_t) _syscall(MM, GETGID, &m));
X}
/
echo x - _getgroups.c
sed '/^X/s///' > _getgroups.c << '/'
X/* getgroups.c						POSIX 4.2.3
X *	int getgroups(gidsetsize, grouplist);
X *
X *	This call relates to suplementary group ids, which are not
X *	supported in MINIX.
X */
X
X#include <lib.h>
X#define getgroups _getgroups
X#include <unistd.h>
X#include <time.h>
X
XPUBLIC int getgroups(gidsetsize, grouplist)
Xint gidsetsize;
Xgid_t grouplist[];
X{
X  return(0);
X}
/
echo x - _getpid.c
sed '/^X/s///' > _getpid.c << '/'
X#include <lib.h>
X#define getpid	_getpid
X#include <unistd.h>
X
XPUBLIC pid_t getpid()
X{
X  message m;
X
X  return(_syscall(MM, GETPID, &m));
X}
/
echo x - _getppid.c
sed '/^X/s///' > _getppid.c << '/'
X#include <lib.h>
X#define getppid	_getppid
X#include <unistd.h>
X
XPUBLIC pid_t getppid()
X{
X  message m;
X
X  /* POSIX says that this function is always successful and that no
X   * return value is reserved to indicate an error.  Minix syscalls
X   * are not always successful and Minix returns the reserved value
X   * (pid_t) -1 when there is an error.
X   */
X  if (_syscall(MM, GETPID, &m) < 0) return ( (pid_t) -1);
X  return( (pid_t) m.m2_i1);
X}
/
echo x - _getuid.c
sed '/^X/s///' > _getuid.c << '/'
X#include <lib.h>
X#define getuid	_getuid
X#include <unistd.h>
X
XPUBLIC uid_t getuid()
X{
X  message m;
X
X  return( (uid_t) _syscall(MM, GETUID, &m));
X}
/
echo x - _gtty.c
sed '/^X/s///' > _gtty.c << '/'
X#include <lib.h>
X#define gtty	_gtty
X#define ioctl	_ioctl
X#include <sgtty.h>
X
XPUBLIC int gtty(fd, argp)
Xint fd;
Xstruct sgttyb *argp;
X{
X  return(ioctl(fd, TIOCGETP, argp));
X}
/
echo x - _ioctl.c
sed '/^X/s///' > _ioctl.c << '/'
X#include <lib.h>
X#define ioctl	_ioctl
X#include <minix/com.h>
X#include <sgtty.h>
X
XPUBLIC int ioctl(fd, request, argp)
Xint fd;
Xint request;
Xstruct sgttyb *argp;
X{
X  int n;
X  long erase, kill, intr, quit, xon, xoff, eof, brk, speed;
X  struct tchars *argt;
X  message m;
X
X  m.TTY_LINE = fd;
X  m.TTY_REQUEST = request;
X
X  switch(request) {
X     case TIOCSETP:
X	erase = argp->sg_erase & BYTE;
X	kill = argp->sg_kill & BYTE;
X	speed = ((argp->sg_ospeed & BYTE) << 8) | (argp->sg_ispeed & BYTE);
X	m.TTY_SPEK = (speed << 16) | (erase << 8) | kill;
X	m.TTY_FLAGS = argp->sg_flags;
X	return(_syscall(FS, IOCTL, &m));
X
X     case TIOCSETC:
X	argt = (struct tchars * /* kludge */) argp;
X  	intr = argt->t_intrc & BYTE;
X  	quit = argt->t_quitc & BYTE;
X  	xon  = argt->t_startc & BYTE;
X  	xoff = argt->t_stopc & BYTE;
X  	eof  = argt->t_eofc & BYTE;
X  	brk  = argt->t_brkc & BYTE;		/* not used at the moment */
X  	m.TTY_SPEK = (intr<<24) | (quit<<16) | (xon<<8) | (xoff<<0);
X  	m.TTY_FLAGS = (eof<<8) | (brk<<0);
X	return(_syscall(FS, IOCTL, &m));
X
X     case TIOCGETP:
X	n = _syscall(FS, IOCTL, &m);
X	argp->sg_erase = (m.TTY_SPEK >> 8) & BYTE;
X	argp->sg_kill  = (m.TTY_SPEK >> 0) & BYTE;
X  	argp->sg_flags = m.TTY_FLAGS & 0xFFFFL;
X	speed = (m.TTY_SPEK >> 16) & 0xFFFFL;
X	argp->sg_ispeed = speed & BYTE;
X	argp->sg_ospeed = (speed >> 8) & BYTE;
X  	return(n);
X
X     case TIOCGETC:
X  	n = _syscall(FS, IOCTL, &m);
X	argt = (struct tchars *) argp;
X  	argt->t_intrc  = (m.TTY_SPEK >> 24) & BYTE;
X  	argt->t_quitc  = (m.TTY_SPEK >> 16) & BYTE;
X  	argt->t_startc = (m.TTY_SPEK >>  8) & BYTE;
X  	argt->t_stopc  = (m.TTY_SPEK >>  0) & BYTE;
X  	argt->t_eofc   = (m.TTY_FLAGS >> 8) & BYTE;
X  	argt->t_brkc   = (m.TTY_FLAGS >> 0) & BYTE;
X  	return(n);
X
X     case TIOCFLUSH:
X	m.TTY_FLAGS = (int /* kludge */) argp;
X	return(_syscall(FS, IOCTL, &m));
X
X     default:
X	m.ADDRESS = (char *) argp;
X	return(_syscall(FS, IOCTL, &m));
X  }
X}
/
echo x - _isatty.c
sed '/^X/s///' > _isatty.c << '/'
X#include <lib.h>
X#define isatty	_isatty
X#include <sgtty.h>
X#include <minix/com.h>
X#include <unistd.h>
X
XPUBLIC int isatty(fd)
Xint fd;
X{
X  message m;
X
X  m.TTY_REQUEST = TIOCGETP;
X  m.TTY_LINE = fd;
X  if (_syscall(FS, IOCTL, &m) < 0) return(0);
X  return(1);
X}
/
echo x - _kill.c
sed '/^X/s///' > _kill.c << '/'
X#include <lib.h>
X#define kill	_kill
X#include <signal.h>
X
XPUBLIC int kill(proc, sig)
Xint proc;			/* which process is to be sent the signal */
Xint sig;			/* signal number */
X{
X  message m;
X
X  m.m1_i1 = proc;
X  m.m1_i2 = sig;
X  return(_syscall(MM, KILL, &m));
X}
/
echo x - _link.c
sed '/^X/s///' > _link.c << '/'
X#include <lib.h>
X#define link	_link
X#include <string.h>
X#include <unistd.h>
X
XPUBLIC int link(name, name2)
X_CONST char *name, *name2;
X{
X  message m;
X
X  m.m1_i1 = strlen(name) + 1;
X  m.m1_i2 = strlen(name2) + 1;
X  m.m1_p1 = (char *) name;
X  m.m1_p2 = (char *) name2;
X  return(_syscall(FS, LINK, &m));
X}
/
echo x - _lseek.c
sed '/^X/s///' > _lseek.c << '/'
X#include <lib.h>
X#define lseek	_lseek
X#include <unistd.h>
X
XPUBLIC off_t lseek(fd, offset, whence)
Xint fd;
Xoff_t offset;
Xint whence;
X{
X  message m;
X
X  m.m2_i1 = fd;
X  m.m2_l1 = offset;
X  m.m2_i2 = whence;
X  if (_syscall(FS, LSEEK, &m) < 0) return( (off_t) -1);
X  return( (off_t) m.m2_l1);
X}
/
echo x - _mkdir.c
sed '/^X/s///' > _mkdir.c << '/'
X#include <lib.h>
X#define mkdir	_mkdir
X#include <sys/stat.h>
X#include <string.h>
X
XPUBLIC int mkdir(name, mode)
X_CONST char *name;
XMode_t mode;
X{
X  message m;
X
X  m.m1_i1 = strlen(name) + 1;
X  m.m1_i2 = mode;
X  m.m1_p1 = (char *) name;
X  return(_syscall(FS, MKDIR, &m));
X}
/
echo x - _mkfifo.c
sed '/^X/s///' > _mkfifo.c << '/'
X#include <lib.h>
X#define mkfifo	_mkfifo
X#define mknod4	_mknod4
X#include <sys/stat.h>
X#include <unistd.h>
X
XPUBLIC int mkfifo(name, mode)
X_CONST char *name;
XMode_t mode;
X{
X  return mknod4(name, mode | S_IFIFO, (Dev_t) 0, (long) 0);
X}
/
echo x - _mknod.c
sed '/^X/s///' > _mknod.c << '/'
X#include <lib.h>
X#define mknod	_mknod
X#define mknod4	_mknod4
X#include <unistd.h>
X
XPUBLIC int mknod(name, mode, dev)
X_CONST char *name;
XMode_t mode;
XDev_t dev;
X{
X  return mknod4(name, mode, dev, (long) 0);
X}
/
echo x - _mknod4.c
sed '/^X/s///' > _mknod4.c << '/'
X#include <lib.h>
X#define mknod4	_mknod4
X#include <string.h>
X#include <stdlib.h>
X#include <unistd.h>
X
XPUBLIC int mknod4(name, mode, dev, size)
X_CONST char *name;
XMode_t mode;
XDev_t dev;
Xlong size;
X{
X  message m;
X
X  m.m1_i1 = strlen(name) + 1;
X  m.m1_i2 = mode;
X  m.m1_i3 = dev;
X  m.m1_p1 = (char *) name;
X  if (sizeof(char *) == 2 && size > 0xFFFF) size = 0;
X  m.m1_p2 = (char *) ((int) size);
X  return(_syscall(FS, MKNOD, &m));
X}
/
echo x - _mktemp.c
sed '/^X/s///' > _mktemp.c << '/'
X/* mktemp - make a name for a temporary file */
X
X#include <lib.h>
X#define access	_access
X#define getpid	_getpid
X#define mktemp	_mktemp
X#include <unistd.h>
X
XPUBLIC char *mktemp(template)
Xchar *template;
X{
X  register int k;
X  register char *p;
X  register pid_t pid;
X
X  pid = getpid();		/* get process id as semi-unique number */
X  p = template;
X  while (*p != 0) p++;		/* find end of string */
X
X  /* Replace XXXXXX at end of template with a letter, then as many of the
X   * trailing digits of the pid as fit.
X   */
X  while (*--p == 'X') {
X	*p = '0' + (pid % 10);
X	pid /= 10;
X  }
X  if (*++p != 0) {
X	for (k = 'a'; k <= 'z'; k++) {
X		*p = k;
X		if (access(template, F_OK) < 0) return(template);
X	}
X  }
X  return("/");
X}
/
echo x - _mount.c
sed '/^X/s///' > _mount.c << '/'
X#include <lib.h>
X#define mount	_mount
X#include <string.h>
X#include <unistd.h>
X
XPUBLIC int mount(special, name, rwflag)
Xchar *name, *special;
Xint rwflag;
X{
X  message m;
X
X  m.m1_i1 = strlen(special) + 1;
X  m.m1_i2 = strlen(name) + 1;
X  m.m1_i3 = rwflag;
X  m.m1_p1 = special;
X  m.m1_p2 = name;
X  return(_syscall(FS, MOUNT, &m));
X}
/
echo x - _open.c
sed '/^X/s///' > _open.c << '/'
X#include <lib.h>
X#define open	_open
X#include <fcntl.h>
X#include <stdarg.h>
X#include <string.h>
X
X#if _ANSI
XPUBLIC int open(const char *name, int flags, ...)
X#else
XPUBLIC int open(name, flags)
X_CONST char *name;
Xint flags;
X#endif
X{
X  va_list argp;
X  message m;
X
X  va_start(argp, flags);
X  if (flags & O_CREAT) {
X	m.m1_i1 = strlen(name) + 1;
X	m.m1_i2 = flags;
X	m.m1_i3 = va_arg(argp, Mode_t);
X	m.m1_p1 = (char *) name;
X  } else {
X	_loadname(name, &m);
X	m.m3_i2 = flags;
X  }
X  va_end(argp);
X  return (_syscall(FS, OPEN, &m));
X}
/
echo x - _pathconf.c
sed '/^X/s///' > _pathconf.c << '/'
X/* POSIX pathconf (Sec. 5.7.1) 		Author: Andy Tanenbaum */
X
X#include <lib.h>
X#define close		_close
X#define open		_open
X#define pathconf	_pathconf
X#include <fcntl.h>
X#include <errno.h>
X#include <unistd.h>
X
XPUBLIC long pathconf(path, name)
X_CONST char *path;		/* name of file being interrogated */
Xint name;			/* property being inspected */
X{
X/* POSIX allows some of the values in <limits.h> to be increased at
X * run time.  The pathconf and fpathconf functions allow these values
X * to be checked at run time.  MINIX does not use this facility.
X * The run-time limits are those given in <limits.h>.
X */
X
X  int fd;
X  long val;
X
X  if ( (fd = open(path, O_RDONLY)) < 0) return(-1L);
X  val = fpathconf(fd, name);
X  close(fd);
X  return(val);
X}
/
echo x - _pause.c
sed '/^X/s///' > _pause.c << '/'
X#include <lib.h>
X#define pause	_pause
X#include <unistd.h>
X
XPUBLIC int pause()
X{
X  message m;
X
X  return(_syscall(MM, PAUSE, &m));
X}
/
echo x - _pipe.c
sed '/^X/s///' > _pipe.c << '/'
X#include <lib.h>
X#define pipe	_pipe
X#include <unistd.h>
X
XPUBLIC int pipe(fild)
Xint fild[2];
X{
X  message m;
X
X  if (_syscall(FS, PIPE, &m) < 0) return(-1);
X  fild[0] = m.m1_i1;
X  fild[1] = m.m1_i2;
X  return(0);
X}
/
echo x - _ptrace.c
sed '/^X/s///' > _ptrace.c << '/'
X#include <lib.h>
X#define ptrace	_ptrace
X#include <unistd.h>
X
XPUBLIC long ptrace(req, pid, addr, data)
Xint req;
Xpid_t pid;
Xlong addr;
Xlong data;
X{
X  message m;
X
X  m.m2_i1 = pid;
X  m.m2_i2 = req;
X  m.m2_l1 = addr;
X  m.m2_l2 = data;
X  if (_syscall(MM, PTRACE, &m) < 0) return(-1);
X
X  /* There was no error, but -1 is a legal return value.  Clear errno if
X   * necessary to distinguish this case.  _syscall has set errno to nonzero
X   * for the error case.
X   */
X  if (m.m2_l2 == -1) errno = 0;
X  return(m.m2_l2);
X}
/
echo x - _read.c
sed '/^X/s///' > _read.c << '/'
X#include <lib.h>
X#define read	_read
X#include <unistd.h>
X
XPUBLIC ssize_t read(fd, buffer, nbytes)
Xint fd;
Xvoid *buffer;
Xsize_t nbytes;
X{
X  message m;
X
X  m.m1_i1 = fd;
X  m.m1_i2 = nbytes;
X  m.m1_p1 = (char *) buffer;
X  return(_syscall(FS, READ, &m));
X}
/
echo x - _rename.c
sed '/^X/s///' > _rename.c << '/'
X#include <lib.h>
X#define rename	_rename
X#include <string.h>
X#include <stdio.h>
X
XPUBLIC int rename(name, name2)
X_CONST char *name, *name2;
X{
X  message m;
X
X  m.m1_i1 = strlen(name) + 1;
X  m.m1_i2 = strlen(name2) + 1;
X  m.m1_p1 = (char *) name;
X  m.m1_p2 = (char *) name2;
X  return(_syscall(FS, RENAME, &m));
X}
/
echo x - _rmdir.c
sed '/^X/s///' > _rmdir.c << '/'
X#include <lib.h>
X#define rmdir	_rmdir
X#include <unistd.h>
X
XPUBLIC int rmdir(name)
X_CONST char *name;
X{
X  message m;
X
X  _loadname(name, &m);
X  return(_syscall(FS, RMDIR, &m));
X}
/
echo x - _setgid.c
sed '/^X/s///' > _setgid.c << '/'
X#include <lib.h>
X#define setgid	_setgid
X#include <unistd.h>
X
XPUBLIC int setgid(grp)
Xgid_t grp;
X{
X  message m;
X
X  m.m1_i1 = (int) grp;
X  return(_syscall(MM, SETGID, &m));
X}
/
echo x - _setuid.c
sed '/^X/s///' > _setuid.c << '/'
X#include <lib.h>
X#define setuid	_setuid
X#include <unistd.h>
X
XPUBLIC int setuid(usr)
XUid_t usr;
X{
X  message m;
X
X  m.m1_i1 = usr;
X  return(_syscall(MM, SETUID, &m));
X}
/
echo x - _sigaction.c
sed '/^X/s///' > _sigaction.c << '/'
X#include <lib.h>
X#define sigaction _sigaction
X#include <sys/sigcontext.h>
X#include <signal.h>
X
X_PROTOTYPE(int __sigreturn, (void));
X
XPUBLIC int sigaction(sig, act, oact)
Xint sig;
X_CONST struct sigaction *act;
Xstruct sigaction *oact;
X{
X  message m;
X
X  m.m1_i2 = sig;
X
X  /* XXX - yet more type puns because message struct is short of types. */
X  m.m1_p1 = (char *) act;
X  m.m1_p2 = (char *) oact;
X  m.m1_p3 = (char *) __sigreturn;
X
X  return(_syscall(MM, SIGACTION, &m));
X}
/
echo x - _sigpending.c
sed '/^X/s///' > _sigpending.c << '/'
X#include <lib.h>
X#define sigpending _sigpending
X#include <signal.h>
X
XPUBLIC int sigpending(set)
Xsigset_t *set;
X{
X  message m;
X
X  if (_syscall(MM, SIGPENDING, &m) < 0) return(-1);
X  *set = (sigset_t) m.m2_l1;
X  return(m.m_type);
X}
/
echo x - _sigprocmask.c
sed '/^X/s///' > _sigprocmask.c << '/'
X#include <lib.h>
X#define sigprocmask _sigprocmask
X#include <signal.h>
X
XPUBLIC int sigprocmask(how, set, oset)
Xint how;
X_CONST sigset_t *set;
Xsigset_t *oset;
X{
X  message m;
X
X  if (set == (sigset_t *) NULL) {
X	m.m2_i1 = SIG_INQUIRE;
X	m.m2_l1 = 0;
X  } else {
X	m.m2_i1 = how;
X	m.m2_l1 = (long) *set;
X  }
X  if (_syscall(MM, SIGPROCMASK, &m) < 0) return(-1);
X  if (oset != (sigset_t *) NULL) *oset = (sigset_t) (m.m2_l1);
X  return(m.m_type);
X}
/
echo x - _sigreturn.c
sed '/^X/s///' > _sigreturn.c << '/'
X#include <lib.h>
X#define sigfillset	_sigfillset
X#define sigjmp		_sigjmp
X#define sigprocmask	_sigprocmask
X#define sigreturn	_sigreturn
X#include <sys/sigcontext.h>
X#include <setjmp.h>
X#include <signal.h>
X
X_PROTOTYPE( int sigjmp, (jmp_buf jb, int retval));
X
X#if (_SETJMP_SAVES_REGS == 0)
X/* 'sigreturn' using a short format jmp_buf (no registers saved). */
XPUBLIC int sigjmp(jb, retval)
Xjmp_buf jb;
Xint retval;
X{
X  struct sigcontext sc;
X
X  sc.sc_flags = jb[0].__flags;
X  sc.sc_mask = jb[0].__mask;
X
X#if (CHIP == INTEL)
X  sc.sc_pc = (int) jb[0].__pc;
X  sc.sc_sp = (int) jb[0].__sp;
X  sc.sc_fp = (int) jb[0].__lb;
X#endif
X
X#if (CHIP == M68000)
X  sc.sc_pc = (long) jb[0].__pc;
X  sc.sc_sp = (long) jb[0].__sp;
X  sc.sc_fp = (long) jb[0].__lb;
X#endif
X
X  sc.sc_retreg = retval;
X  return sigreturn(&sc);
X}
X#endif
X
XPUBLIC int sigreturn(scp)
Xregister struct sigcontext *scp;
X{
X  sigset_t set;
X
X  /* The message can't be on the stack, because the stack will vanish out
X   * from under us.  The send part of sendrec will succeed, but when
X   * a message is sent to restart the current process, who knows what will
X   * be in the place formerly occupied by the message?
X   */
X  static message m;
X
X  /* Protect against race conditions by blocking all interrupts. */
X  sigfillset(&set);		/* splhi */
X  sigprocmask(SIG_SETMASK, &set, (sigset_t *) NULL);
X
X  m.m2_l1 = scp->sc_mask;
X  m.m2_i2 = scp->sc_flags;
X  m.m2_p1 = (char *) scp;
X  return(_syscall(MM, SIGRETURN, &m));	/* normally this doesn't return */
X}
/
echo x - _sigset.c
sed '/^X/s///' > _sigset.c << '/'
X#include <lib.h>
X/* XXX - these have to be hidden because signal() uses them and signal() is
X * ANSI and not POSIX.  It would be surely be better to use macros for the
X * library and system uses, and perhaps macros as well as functions for the
X * POSIX user interface.  The macros would not need underlines.  It may be
X * inconvenient to match the exact semantics of the current functions
X * because the interface is bloated by reporting errors.  For library and
X * system uses, the signal number is mostly already known to be valid
X * before the sigset-changing routines are called.
X */
X#define sigaddset	_sigaddset
X#define sigdelset	_sigdelset
X#define sigemptyset	_sigemptyset
X#define sigfillset	_sigfillset
X#define sigismember	_sigismember
X#include <signal.h>
X
X/* Low bit of signal masks. */
X#define SIGBIT_0	((sigset_t) 1)
X
X/* Mask of valid signals (0 - _NSIG).  Assume the shift doesn't overflow. */
X#define SIGMASK		((SIGBIT_0 << (_NSIG + 1)) - 1)
X
X#define sigisvalid(signo) ((unsigned) (signo) <= _NSIG)
X
XPUBLIC int sigaddset(set, signo)
Xsigset_t *set;
Xint signo;
X{
X  if (!sigisvalid(signo)) {
X  	errno = EINVAL;
X	return -1;
X  }
X  *set |= SIGBIT_0 << signo;
X  return 0;
X}
X
XPUBLIC int sigdelset(set, signo)
Xsigset_t *set;
Xint signo;
X{
X  if (!sigisvalid(signo)) {
X  	errno = EINVAL;
X	return -1;
X  }
X  *set &= ~(SIGBIT_0 << signo);
X  return 0;
X}
X
XPUBLIC int sigemptyset(set)
Xsigset_t *set;
X{
X  *set = 0;
X  return 0;
X}
X
XPUBLIC int sigfillset(set)
Xsigset_t *set;
X{
X  *set = SIGMASK;
X  return 0;
X}
X
XPUBLIC int sigismember(set, signo)
Xsigset_t *set;
Xint signo;
X{
X  if (!sigisvalid(signo)) {
X  	errno = EINVAL;
X	return -1;
X  }
X  if (*set & (SIGBIT_0 << signo))
X  	return 1;
X  return 0;
X}
/
echo x - _sigsetjmp.c
sed '/^X/s///' > _sigsetjmp.c << '/'
X#include <lib.h>
X#include <sys/sigcontext.h>
X#include <setjmp.h>
X
XPUBLIC void siglongjmp(env, val)
Xsigjmp_buf env;
Xint val;
X{
X  if (env[0].__flags & SC_SIGCONTEXT)
X	longjmp(env, val);
X  else
X	_longjmp(env, val);
X}
/
echo x - _sigsuspend.c
sed '/^X/s///' > _sigsuspend.c << '/'
X#include <lib.h>
X#define sigsuspend _sigsuspend
X#include <signal.h>
X
XPUBLIC int sigsuspend(set)
X_CONST sigset_t *set;
X{
X  message m;
X
X  m.m2_l1 = (long) *set;
X  return(_syscall(MM, SIGSUSPEND, &m));
X}
/
echo x - _sleep.c
sed '/^X/s///' > _sleep.c << '/'
X/*  sleep(3)
X *
X *  Sleep(n) pauses for 'n' seconds by scheduling an alarm interrupt.
X *
X *  Changed to conform with POSIX      Terrence W. Holm      Oct. 1988
X */
X
X#include <lib.h>
X#define sleep _sleep
X#include <signal.h>
X#include <unistd.h>
X
XFORWARD _PROTOTYPE( void _alfun, (int signo) );
X
XPRIVATE void _alfun(signo)
Xint signo;
X{
X/* Dummy signal handler used with sleep() below. */
X}
X
XPUBLIC unsigned sleep(secs)
Xunsigned secs;
X{
X  unsigned current_secs;
X  unsigned remaining_secs;
X  struct sigaction act, oact;
X  sigset_t ss;
X
X  if (secs == 0) return(0);
X
X  current_secs = alarm(0);	/* is there currently an alarm?  */
X
X  if (current_secs == 0 || current_secs > secs) {
X	act.sa_flags = 0;
X	act.sa_mask = 0;
X	act.sa_handler = _alfun;
X	sigaction(SIGALRM, &act, &oact);
X
X	alarm(secs);
X	sigemptyset(&ss);
X	sigsuspend(&ss);
X	remaining_secs = alarm(0);
X
X	sigaction(SIGALRM, &oact, (struct sigaction *) NULL);
X
X	if (current_secs > secs)
X		alarm(current_secs - (secs - remaining_secs));
X
X	return(remaining_secs);
X  }
X
X  /* Current_secs <= secs,  ie. alarm should occur before secs.  */
X
X  alarm(current_secs);
X  pause();
X  remaining_secs = alarm(0);
X
X  alarm(remaining_secs);
X
X  return(secs - (current_secs - remaining_secs));
X}
/
echo x - _stat.c
sed '/^X/s///' > _stat.c << '/'
X#include <lib.h>
X#define stat	_stat
X#include <sys/stat.h>
X#include <string.h>
X
XPUBLIC int stat(name, buffer)
X_CONST char *name;
Xstruct stat *buffer;
X{
X  message m;
X
X  m.m1_i1 = strlen(name) + 1;
X  m.m1_p1 = (char *) name;
X  m.m1_p2 = (char *) buffer;
X  return(_syscall(FS, STAT, &m));
X}
/
echo x - _stime.c
sed '/^X/s///' > _stime.c << '/'
X#include <lib.h>
X#define stime	_stime
X#include <minix/minlib.h>
X#include <time.h>
X
XPUBLIC int stime(top)
Xlong *top;
X{
X  message m;
X
X  m.m2_l1 = *top;
X  return(_syscall(FS, STIME, &m));
X}
/
echo x - _stty.c
sed '/^X/s///' > _stty.c << '/'
X#include <lib.h>
X#define ioctl	_ioctl
X#define stty	_stty
X#include <sgtty.h>
X
XPUBLIC int stty(fd, argp)
Xint fd;
Xstruct sgttyb *argp;
X{
X  return ioctl(fd, TIOCSETP, argp);
X}
/
echo x - _sync.c
sed '/^X/s///' > _sync.c << '/'
X#include <lib.h>
X#define sync	_sync
X#include <unistd.h>
X
XPUBLIC int sync()
X{
X  message m;
X
X  return(_syscall(FS, SYNC, &m));
X}
/
echo x - _time.c
sed '/^X/s///' > _time.c << '/'
X#include <lib.h>
X#define time	_time
X#include <time.h>
X
XPUBLIC time_t time(tp)
Xtime_t *tp;
X{
X  message m;
X
X  if (_syscall(FS, TIME, &m) < 0) return( (time_t) -1);
X  if (tp != (time_t *) 0) *tp = m.m2_l1;
X  return(m.m2_l1);
X}
/
echo x - _times.c
sed '/^X/s///' > _times.c << '/'
X#include <lib.h>
X#define times	_times
X#include <sys/times.h>
X#include <time.h>
X
XPUBLIC clock_t times(buf)
Xstruct tms *buf;
X{
X  message m;
X
X  m.m4_l5 = 0;			/* return this if system is pre-1.6 */
X  if (_syscall(FS, TIMES, &m) < 0) return( (clock_t) -1);
X  buf->tms_utime = m.m4_l1;
X  buf->tms_stime = m.m4_l2;
X  buf->tms_cutime = m.m4_l3;
X  buf->tms_cstime = m.m4_l4;
X  return(m.m4_l5);
X}
/
echo x - _umask.c
sed '/^X/s///' > _umask.c << '/'
X#include <lib.h>
X#define umask	_umask
X#include <sys/stat.h>
X
XPUBLIC mode_t umask(complmode)
XMode_t complmode;
X{
X  message m;
X
X  m.m1_i1 = complmode;
X  return( (mode_t) _syscall(FS, UMASK, &m));
X}
/
echo x - _umount.c
sed '/^X/s///' > _umount.c << '/'
X#include <lib.h>
X#define umount	_umount
X#include <unistd.h>
X
XPUBLIC int umount(name)
X_CONST char *name;
X{
X  message m;
X
X  _loadname(name, &m);
X  return(_syscall(FS, UMOUNT, &m));
X}
/
echo x - _uname.c
sed '/^X/s///' > _uname.c << '/'
X/*  uname - get system name			Author: Earl Chew */
X
X/* The system name is read from the file /etc/uname. This should be
X * world readable but only writeable by system administrators. The
X * file contains lines of text. Lines beginning with # are treated
X * as comments. All other lines contain information to be read into
X * the uname structure. The sequence of the lines matches the sequence
X * in which the structure components are declared:
X *
X *	system name		Minix
X *	node name		waddles
X *	release name		1.5
X *	version			10
X *	machine name		IBM_PC
X *	serial number		N/A
X */
X
X#include <lib.h>
X#include <fcntl.h>
X#include <string.h>
X#define uname _uname
X#include <unistd.h>
X#include <sys/utsname.h>
X
X
X#ifndef 	UFILENAME
X#define UFILENAME	"/etc/uname"
X#endif
X
Xstruct buffer {
X  char buf[1024];
X  char *bp;
X  char *ep;
X};
X
X_PROTOTYPE(int __upart, (int fd, struct buffer *b, char *s, size_t n));
X
X
Xint __upart(fd, b, s, n)
Xint fd;
Xstruct buffer *b;
Xchar *s;
Xsize_t n;
X{
X  register int c;
X  register char *p;
X  char *e;
X
X  e = &s[n];
X  do {
X	p = s;
X	do {
X		if (b->bp >= b->ep) {
X			if ((c = read(fd, b->buf, sizeof b->buf)) <= 0) {
X				if (p == s)
X					return -1;
X				else {
X					b->buf[0] = '\n';
X					c = 1;
X				}
X			}
X			b->bp = b->buf;
X			b->ep = b->buf + c;
X		}
X		c = *b->bp++;
X		if (p < e) *p++ = c;
X	} while (c != '\n');
X	p[-1] = 0;
X  } while (s[0] == '#');
X  return 0;
X}
X
Xint uname(up)
Xstruct utsname *up;
X{
X  static int ufd = -1;
X  int r;
X  struct buffer buf;
X
X  if (ufd != -1) {
X	errno = EBUSY;
X	return -1;
X  }
X  if ((ufd = open(UFILENAME, O_RDONLY)) < 0) {
X	errno = EACCES;
X	return -1;
X  }
X  r = 0;
X  buf.bp = buf.ep = buf.buf;
X  if (__upart(ufd, &buf, up->sysname,  sizeof(up->sysname))  ||
X      __upart(ufd, &buf, up->nodename, sizeof(up->nodename)) ||
X      __upart(ufd, &buf, up->release,  sizeof(up->release))  ||
X      __upart(ufd, &buf, up->version,  sizeof(up->version))  ||
X      __upart(ufd, &buf, up->machine,  sizeof(up->machine))  ||
X      __upart(ufd, &buf, up->idnumber, sizeof(up->idnumber))) {
X	errno = EIO;
X	r = -1;
X  }
X  (void) close(ufd);
X  ufd = -1;
X  return r;
X}
/
echo x - _unlink.c
sed '/^X/s///' > _unlink.c << '/'
X#include <lib.h>
X#define unlink	_unlink
X#include <unistd.h>
X
XPUBLIC int unlink(name)
X_CONST char *name;
X{
X  message m;
X
X  _loadname(name, &m);
X  return(_syscall(FS, UNLINK, &m));
X}
/
echo x - _utime.c
sed '/^X/s///' > _utime.c << '/'
X/* utime(2) for POSIX		Authors: Terrence W. Holm & Edwin L. Froese */
X
X#include <lib.h>
X#define time	_time
X#define utime	_utime
X#include <stddef.h>
X#include <string.h>
X#include <time.h>
X#include <utime.h>
X
XPUBLIC int utime(name, timp)
X_CONST char *name;
X_CONST struct utimbuf *timp;
X{
X  time_t current_time;
X  message m;
X
X  if (timp == (struct utimbuf *) NULL) {
X	current_time = time( (time_t *) NULL);
X	m.m2_l1 = current_time;
X	m.m2_l2 = current_time;
X  } else {
X	m.m2_l1 = timp->actime;
X	m.m2_l2 = timp->modtime;
X  }
X  m.m2_i1 = strlen(name) + 1;
X  m.m2_p1 = (char *) name;
X  return(_syscall(FS, UTIME, &m));
X}
/
echo x - _wait.c
sed '/^X/s///' > _wait.c << '/'
X#include <lib.h>
X#define wait	_wait
X#include <sys/wait.h>
X
XPUBLIC pid_t wait(status)
Xint *status;
X{
X  message m;
X
X  if (_syscall(MM, WAIT, &m) < 0) return(-1);
X  if (status != 0) *status = m.m2_i1;
X  return(m.m_type);
X}
/
echo x - _waitpid.c
sed '/^X/s///' > _waitpid.c << '/'
X#include <lib.h>
X#define waitpid	_waitpid
X#include <sys/wait.h>
X
XPUBLIC pid_t waitpid(pid, status, options)
Xpid_t pid;
Xint *status;
Xint options;
X{
X  message m;
X
X  m.m1_i1 = pid;
X  m.m1_i2 = options;
X  if (_syscall(MM, WAITPID, &m) < 0) return(-1);
X  if (status != 0) *status = m.m2_i1;
X  return m.m_type;
X}
/
echo x - _write.c
sed '/^X/s///' > _write.c << '/'
X#include <lib.h>
X#define write	_write
X#include <unistd.h>
X
XPUBLIC ssize_t write(fd, buffer, nbytes)
Xint fd;
X_CONST void *buffer;
Xsize_t nbytes;
X{
X  message m;
X
X  m.m1_i1 = fd;
X  m.m1_i2 = nbytes;
X  m.m1_p1 = (char *) buffer;
X  return(_syscall(FS, WRITE, &m));
X}
/
