echo x - fixbin.sh
sed '/^X/s///' > fixbin.sh << '/'
X#This shell script installs new binaries, changing sizes and modes
X#Call: fixbin src_dir dst_dir
X#Example: fixbin /usr/src/commands/bin /bin
X
X#Check for args
Xcase $# in
X2) ;;
X*) echo Usage: $0 src_dir dst_dir
X   exit 1
X   ;;
Xesac
X
Xsrc=$1
Xdst=$2
Xif test -d $src; then : ; else echo $src is not a directory; exit 1; fi
Xif test -d $dst; then : ; else echo $dst is not a directory; exit 1; fi
X
X#Is dst dir writable?
Xdate >$dst/$$
Xif test -r $dst/$$
X   then :
X   else echo $0: $dst is not writable
X        exit 1
Xfi
X
X#Is this script running as superuser?
Xif chown bin $dst/$$ >/dev/null 2>&1
X   then rm $dst/$$
X   else echo You must be superuser to run $0
X	rm $dst/$$
X	exit 1
Xfi
X	
X#Copy all the files into position if needed
Xif test $src = $dst
X   then :			# e.g., $0 /bin /bin
X   else cd $src
X	cp * $dst
Xfi
X	
X#Set owner
Xcd $dst
Xchown bin *
X
X#The following files are setuid root
Xchown root $dst/at
Xchown root $dst/df
Xchown root $dst/format
Xchown root $dst/login
Xchown root $dst/mail
Xchown root $dst/mv
Xchown root $dst/ncheck
Xchown root $dst/passwd
Xchown root $dst/recover
Xchown root $dst/su
X
Xchmod 4755 $dst/at
Xchmod 4755 $dst/df
Xchmod 4755 $dst/format
Xchmod 4755 $dst/login
Xchmod 4755 $dst/mail
Xchmod 4755 $dst/mv
Xchmod 4755 $dst/ncheck
Xchmod 4755 $dst/passwd
Xchmod 4755 $dst/recover
Xchmod 4755 $dst/su
X
X#Increase default stack size from 8K to more for selected programs
Xchmem =50000 $dst/ar
Xchmem =10000 $dst/cgrep
Xchmem =16000 $dst/cp
Xchmem =55000 $dst/cdiff
Xchmem =64000 $dst/compress
Xchmem =64000 $dst/cpdir
Xchmem =4096  $dst/cron
Xchmem =40000 $dst/dd
Xchmem =32000 $dst/du
Xchmem =55000 $dst/diff
Xchmem =50000 $dst/diskusage
Xchmem =60000 $dst/ed
Xchmem =20000 $dst/fgrep
Xchmem =50000 $dst/file
Xchmem =50000 $dst/find
Xchmem =60000 $dst/fix
Xchmem =60000 $dst/fsck
Xchmem =60000 $dst/fsck2
Xchmem =60000 $dst/indent
Xchmem =10000 $dst/last
Xchmem =30000 $dst/life
Xchmem =40000 $dst/ls
Xchmem =35000 $dst/make
Xchmem =10000 $dst/man
Xchmem =65000 $dst/mined
Xchmem =40000 $dst/mkfs
Xchmem =40000 $dst/mkproto
Xchmem =15000 $dst/mref
Xchmem =65000 $dst/nm
Xchmem =40000 $dst/ncheck
Xchmem =65000 $dst/nroff
Xchmem =65000 $dst/patch
Xchmem =32000 $dst/pr
Xchmem =30000 $dst/proto
Xchmem =16384 $dst/ps
Xchmem =50000 $dst/readfs
Xchmem =30000 $dst/rm
Xchmem =30000 $dst/rmdir
Xchmem =16000 $dst/roff
Xchmem =16384 $dst/sed
Xchmem =21000 $dst/sh
Xchmem =60000 $dst/sort
Xchmem =16000 $dst/strip
Xchmem =16000 $dst/strings
Xchmem =32000 $dst/tail
Xchmem =60000 $dst/tar
Xchmem =5120  $dst/term
Xchmem =60000 $dst/treecmp
Xchmem =20000 $dst/unshar
Xchmem =2560  $dst/update
X
X# remove old linked files and make new ones
Xrm -rf chip uncompress zcat ex vi cpdir
Xln machine chip
Xln compress uncompress
Xln compress zcat
Xln elvis ex
Xln elvis vi
Xln cp cpdir
X
Xif chip INTEL
Xthen
X   chown root $dst/readclock
X   chmod 4755 $dst/readclock
X
X   chmem =16000 $dst/ast
X   chmem =60000 $dst/asld
X   chmem =32000 $dst/dosread
X   chmem =64000 $dst/libpack
X   chmem =64000 $dst/libupack
X   chmem =60000 $dst/lorder
X   chmem =60000 $dst/tsort
X
X   rm -rf doswrite dosdir
X   ln dosread doswrite
X   ln dosread dosdir
Xfi
X
Xif chip M68000
Xthen
X   chmem =20000 $dst/anm
X   chmem =20000 $dst/cc
X#  chmem =20000 $dst/cv usr/lib !!!
X   chmem =25000 $dst/tos
X
X   rm -rf tosdir tosread toswrite 
X   ln tos tosdir
X   ln tos tosread
X   ln tos toswrite
Xfi
/
echo x - spell.sh
sed '/^X/s///' > spell.sh << '/'
Xprep $1 | sort -u | comm -23 - /usr/lib/dictionary
X
/
echo x - svclog.sh
sed '/^X/s///' > svclog.sh << '/'
X#!/bin/sh
X#
Xsvc=`basename $1 ,S`,S
Xif test \( ! -r $svc \) -a -d "SVC" ; then svc=SVC/$svc ; fi
Xgrep '^#\*\*\*SVC' $svc
X
/
echo x - true.sh
sed '/^X/s///' > true.sh << '/'
/
echo x - whatis.sh
sed '/^X/s///' > whatis.sh << '/'
X# whatis - look up name in a data base		Author: Andy Tanenbaum
X
XDATABASE=/usr/etc/whatis
X
Xcase $# in
X0)	echo Usage: whatis name ...
X	;;
Xesac
X
Xfor i
Xdo grep "^$i[ 	]" $DATABASE
Xdone
X
X
X
/
echo x - whereis.sh
sed '/^X/s///' > whereis.sh << '/'
X: List all system directories containing the argument
X: Author: Terrence W. Holm
Xif test $# -ne 1; then
X  echo "Usage:  whereis  name"
X  exit 1
Xfi
X
Xpath="/bin /lib /etc\
X      /usr/bin /usr/lib\
X      /usr/include /usr/include/sys"
X
Xfor dir in $path; do
X  for file in $dir/$1 $dir/$1.*; do
X    if test -f $file; then
X      echo $file 
X    elif test -d $file; then
X      echo $file/
X      fi
X    done
X  done
X
Xexit 0
/
