echo x - fdio.h
sed '/^X/s///' > fdio.h << '/'
X/* Data structures for disk ioctl */
X
Xstruct hparam {
X	unsigned char max_cyl;
X	unsigned char dense;	/* :6 */
X	unsigned char size;	/* :2 */
X	unsigned char sides;	/* :1 */
X	unsigned char slow;	/* :1 */
X};
X
X#define SIDES1	0x00		/* 1 side */
X#define SIDES2	0x01		/* 2 sides */
X#define FAST	0x00
X#define SLOW	0x01
X#define I3	0x00
X#define I5	0x01
X
Xstruct fparam {
X	int  sector_size;		/* sector size in bytes */
X	unsigned char sector_0;		/* first sector on a track */
X	unsigned char nr_sectors;	/* sectors per track */
X	unsigned char cylinder_0;	/* cylinder offset */
X	unsigned char nr_cylinders;	/* number of cylinders */
X	unsigned char nr_sides;		/* :1 single/double sided */
X	unsigned char density;		/* :3 density code */
X	unsigned char stepping;		/* :1 double stepping */
X	unsigned char autocf;		/* :1 autoconfig */
X};
X
X#define NSTP	0x00		/* normal stepping */
X#define DSTP	0x01		/* double stepping */
X#define DD	0x00		/* double density */
X#define	QD	0x01		/* hyper format */
X#define	HD	0x02		/* high density */
X#define DD5	0x03		/* normal density for 5.25'' */
X
X#define HARD	0x00		/* hard configuration */
X#define AUTO	0x01		/* auto configuration */
X
X#define DIOGETP 	(('d'<<8)|'G')
X#define DIOSETP 	(('d'<<8)|'S')
X#define DIOGETHP	(('d'<<8)|'g')
X#define DIOSETHP	(('d'<<8)|'s')
X#define DIOFMTLOCK 	(('d'<<8)|'L')
X#define DIOFMTFREE 	(('d'<<8)|'F')
/
echo x - hdio.h
sed '/^X/s///' > hdio.h << '/'
Xstruct scsi_cmd {
X	unsigned long size;
X	unsigned char *buf;
X	unsigned char cmd_cnt;
X	unsigned char *cmd;
X};
X
X#define SCSI_READ	(('S'<<8)|'R')
X#define SCSI_WRITE	(('S'<<8)|'W')
X
X/* Device types */
X#define SCSI_DISK	0
X#define SCSI_TAPE	1
X#define SCSI_PRINTER	2
X#define SCSI_CPU	3
X#define SCSI_WROM	4
X#define SCSI_CDROM	5
X
Xstruct dev_setup {
X	unsigned char scsi_lun;
X	unsigned char scsi_dev;
X};
/
echo x - ioctl.h
sed '/^X/s///' > ioctl.h << '/'
X/* The ioctl.h header is used for controlling network lines */
X
X#ifndef _IOCTL_H
X#define _IOCTL_H
X
X/* ioctl's have the command encoded in the low-order word, and the size
X * of the parameter in the high-order word. The 2 high bits of the high-
X * order word are used to encode the in/out status of the parameter.
X*/
X
X#define IOCPARM_MASK	0x3FFFL
X#define IOCTYPE_MASK	0xFFFFL
X#define IOC_IN		0x40000000L
X#define IOC_OUT		0x80000000L
X#define IOC_INOUT	(IOC_IN | IOC_OUT)
X
X#define _IO(x,y)	((x << 8) | y)
X#define _IOR(x,y,t)	((x << 8) | y  | ((sizeof(t) & IOCPARM_MASK) << 16) |\
X				IOC_IN)
X#define _IOW(x,y,t)	((x << 8) | y | ((sizeof(t) & IOCPARM_MASK) << 16) |\
X				IOC_OUT)
X#define _IORW(x,y,t)	((x << 8) | y | ((sizeof(t) & IOCPARM_MASK) << 16) |\
X				IOC_INOUT)
X
X
X#define NWIOSETHOPT	_IOR('n',1,struct nwio_ethopt)
X#define NWIOGETHOPT	_IOW('n',2,struct nwio_ethopt)
X#define NWIOGETHSTAT	_IOW('n',3,struct nwio_ethstat)
X
X#define NWIOSIPCONF	_IOR('n',16,struct nwio_ipconf)
X#define NWIOGIPCONF	_IOW('n',17,struct nwio_ipconf)
X#define NWIOSIPOPT	_IOR('n',18,struct nwio_ipopt)
X#define NWIOGIPOPT	_IOW('n',19,struct nwio_ipopt)
X
X#define NWIOSTCPOPT	_IOR('n',32,struct nwio_tcpopt)
X#define NWIOGTCPOPT	_IOW('n',33,struct nwio_tcpopt)
X#define NWIOTCPCONN	_IOR('n',34,struct nwio_tcpcl)
X#define NWIOTCPLISTEN	_IOR('n',35,struct nwio_tcpcl)
X#define NWIOTCPATTACH	_IOR('n',36,struct nwio_tcpatt)
X#define NWIOTCPSHUTDOWN	_IO('n', 37)
X
X#ifndef _ANSI_H
X#include <ansi.h>
X#endif
X
X_PROTOTYPE (int nwioctl, (int _fd, unsigned long _req,
X	_VOIDSTAR _data) );
X
X#endif /* _IOCTL_H */
/
echo x - mtio.h
sed '/^X/s///' > mtio.h << '/'
X/*
X * mtio.h  - defines for magtape device driver ioctls
X *		for aha_scsi, by James da Silva (jds@cs.umd.edu)
X *		slightly modified by Matthias Pfaller (leo@marco.de)
X */
X
X#define MTIOCTOP	(('m'<<8) | 1)	/* do operation */
X#define MTIOCGET	(('m'<<8) | 2)	/* get status (not implemented) */
X
X/* data struct for MTIOCTOP */
X
Xstruct mtop {
X	short mt_op;
X	int  mt_count;
X};
X
X/* values for the mt_op field */
X
X#define MTWEOF	0	/* write EOF marks */
X#define MTFSF	1	/* forward-space filemarks */
X#define MTBSF	2	/* back-space filemarks */
X#define MTFSR	3	/* forward-space records */
X#define MTBSR	4	/* back-space records */
X#define MTREW	5	/* rewind tape */
X#define MTOFFL	6	/* rewind tape and take it offline */
X#define MTNOP	7	/* no operation, sets status only */
X#define MTRETEN	8	/* retension operation */
X#define MTRET	8
X#define MTERASE	9	/* erase the entire tape */
X#define	MTEOM	10	/* position to end of media */
X#define MTAPP	10
X#define MTONL	11	/* put drive online */
X/* default tape device */
X
X#define DEFTAPE "/dev/nrst0"
X
/
echo x - ptrace.h
sed '/^X/s///' > ptrace.h << '/'
X/* <sys/ptrace.h>
X * definitions for ptrace(2) 
X */
X
X#ifndef _PTRACE_H
X#define _PTRACE_H
X
X#define T_OK		0	/* enable tracing by parent for this process */
X#define T_GETINS	1	/* return value from instruction space */
X#define T_GETDATA	2	/* return value from data space */
X#define T_GETUSER	3	/* return value from user process table */
X#define	T_SETINS	4	/* set value from instruction space */
X#define T_SETDATA	5	/* set value from data space */
X#define T_SETUSER	6	/* set value in user process table */
X#define T_RESUME	7	/* resume execution */
X#define T_EXIT		8	/* exit */
X#define T_STEP		9	/* set trace bit */
X
X/* Function Prototypes. */
X#ifndef _ANSI_H
X#include <ansi.h>
X#endif
X
X_PROTOTYPE( long ptrace, (int _req, pid_t _pid, long _addr, long _data) );
X
X#endif /* _PTRACE_H */
/
echo x - sigcontext.h
sed '/^X/s///' > sigcontext.h << '/'
X#ifndef _SIGCONTEXT_H
X#define _SIGCONTEXT_H
X
X/* The sigcontext structure is used by the sigreturn(2) system call.
X * sigreturn() is seldom called by user programs, but it is used internally
X * by the signal catching mechanism.
X */
X
X#ifndef _ANSI_H
X#include <ansi.h>
X#endif
X
X#ifndef _CONFIG_H
X#include <minix/config.h>
X#endif
X
X#if !defined(CHIP) || !defined(INTEL) || !defined(FP_FORMAT)
X#include "error, configuration is not known"	/* XXX */
X#endif
X
X/* The following structure should match the stackframe_s structure used
X * by the kernel's context switching code.  Floating point registers should
X * be added in a different struct.
X */
X#if (CHIP == INTEL)
Xstruct sigregs {  
X#if INTEL_32BITS
X  short sr_gs;
X  short sr_fs;
X#endif /* INTEL_32BITS */
X  short sr_es;
X  short sr_ds;
X  int sr_di;
X  int sr_si;
X  int sr_bp;
X  int sr_st;			/* stack top -- used in kernel */
X  int sr_bx;
X  int sr_dx;
X  int sr_cx;
X  int sr_retreg;
X  int sr_retadr;		/* return address to caller of save -- used
X  				 * in kernel */
X  int sr_pc;
X  int sr_cs;
X  int sr_psw;
X  int sr_sp;
X  int sr_ss;
X};
X#else
X#if (CHIP == M68000)
Xstruct sigregs {  
X  long sr_retreg;			/* d0 */
X  long sr_d1;
X  long sr_d2;
X  long sr_d3;
X  long sr_d4;
X  long sr_d5;
X  long sr_d6;
X  long sr_d7;
X  long sr_a0;
X  long sr_a1;
X  long sr_a2;
X  long sr_a3;
X  long sr_a4;
X  long sr_a5;
X  long sr_a6;
X  long sr_sp;			/* also known as a7 */
X  long sr_pc;
X  short sr_psw;
X  short sr_dummy;		/* make size multiple of 4 for system.c */
X};
X#else
X#include "error, CHIP is not supported"	/* XXX */
X#endif
X#endif /* CHIP == INTEL */
X
Xstruct sigcontext {
X  int sc_flags;			/* sigstack state to restore */
X  long sc_mask;			/* signal mask to restore */
X  struct sigregs sc_regs;	/* register set to restore */
X};
X
X#if (CHIP == INTEL)
X#if INTEL_32BITS
X#define sc_gs sc_regs.sr_gs
X#define sc_fs sc_regs.sr_fs
X#endif /* INTEL_32BITS */
X#define sc_es sc_regs.sr_es
X#define sc_ds sc_regs.sr_ds
X#define sc_di sc_regs.sr_di
X#define sc_si sc_regs.sr_si 
X#define sc_fp sc_regs.sr_bp
X#define sc_st sc_regs.sr_st		/* stack top -- used in kernel */
X#define sc_bx sc_regs.sr_bx
X#define sc_dx sc_regs.sr_dx
X#define sc_cx sc_regs.sr_cx
X#define sc_retreg sc_regs.sr_retreg
X#define sc_retadr sc_regs.sr_retadr	/* return address to caller of 
X					save -- used in kernel */
X#define sc_pc sc_regs.sr_pc
X#define sc_cs sc_regs.sr_cs
X#define sc_psw sc_regs.sr_psw
X#define sc_sp sc_regs.sr_sp
X#define sc_ss sc_regs.sr_ss
X#endif /* CHIP == INTEL */
X
X#if (CHIP == M68000)
X#define sc_retreg sc_regs.sr_retreg
X#define sc_d1 sc_regs.sr_d1
X#define sc_d2 sc_regs.sr_d2
X#define sc_d3 sc_regs.sr_d3
X#define sc_d4 sc_regs.sr_d4
X#define sc_d5 sc_regs.sr_d5
X#define sc_d6 sc_regs.sr_d6
X#define sc_d7 sc_regs.sr_d7
X#define sc_a0 sc_regs.sr_a0
X#define sc_a1 sc_regs.sr_a1
X#define sc_a2 sc_regs.sr_a2
X#define sc_a3 sc_regs.sr_a3
X#define sc_a4 sc_regs.sr_a4
X#define sc_a5 sc_regs.sr_a5
X#define sc_fp sc_regs.sr_a6
X#define sc_sp sc_regs.sr_sp
X#define sc_pc sc_regs.sr_pc
X#define sc_psw sc_regs.sr_psw
X#endif /* CHIP == M68000 */
X
X/* Values for sc_flags.  Must agree with <minix/jmp_buf.h>. */
X#define SC_SIGCONTEXT	2	/* nonzero when signal context is included */
X#define SC_NOREGLOCALS	4	/* nonzero when registers are not to be
X					saved and restored */
X
X_PROTOTYPE( int sigreturn, (struct sigcontext *_scp)			);
X
X#endif /* _SIGCONTEXT_H */
/
echo x - sys.cd
sed '/^X/s///' > sys.cd << '/'
Xecho x - dir.h.d
Xsed '/^X/s///' > dir.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/sys/dir.h  crc=03053    333	Wed Apr 18 00:24:52 1990
XX--- /home/top/ast/minix/1.6.25//include/sys/dir.h  crc=06891    262	Tue Nov  3 21:22:17 1992
XX***************
XX*** 3,16 ****
XX  #ifndef _DIR_H
XX  #define _DIR_H
XX  
XX- #ifndef _TYPES_H		/* not quite right */
XX- #include <sys/types.h>
XX- #endif
XX- 
XX  #define	DIRBLKSIZ	512	/* size of directory block */
XX  
XX  #ifndef DIRSIZ
XX! #define	DIRSIZ	14
XX  #endif
XX  
XX  struct direct {
XX--- 3,12 ----
XX  #ifndef _DIR_H
XX  #define _DIR_H
XX  
XX  #define	DIRBLKSIZ	512	/* size of directory block */
XX  
XX  #ifndef DIRSIZ
XX! #define DIRSIZ	14
XX  #endif
XX  
XX  struct direct {
X/
Xecho x - stat.h.d
Xsed '/^X/s///' > stat.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/sys/stat.h  crc=07105   2890	Wed Apr 18 00:24:52 1990
XX--- /home/top/ast/minix/1.6.25//include/sys/stat.h  crc=49644   3012	Tue Nov 10 19:32:59 1992
XX***************
XX*** 6,15 ****
XX  #ifndef _STAT_H
XX  #define _STAT_H
XX  
XX- #ifndef _TYPES_H		/* not quite right */
XX- #include <sys/types.h>
XX- #endif
XX- 
XX  struct stat {
XX    dev_t st_dev;			/* major/minor device number */
XX    ino_t st_ino;			/* i-node number */
XX--- 6,11 ----
XX***************
XX*** 25,32 ****
XX  };
XX  
XX  /* Traditional mask definitions for st_mode. */
XX! #define S_IFMT  0170000		/* type of file */
XX! #define S_IFREG 0100000		/* regular */
XX  #define S_IFBLK 0060000		/* block special */
XX  #define S_IFDIR 0040000  	/* directory */
XX  #define S_IFCHR 0020000		/* character special */
XX--- 21,31 ----
XX  };
XX  
XX  /* Traditional mask definitions for st_mode. */
XX! /* The ugly casts on only some of the definitions are to avoid suprising sign
XX!  * extensions such as S_IFREG != (mode_t) S_IFREG when ints are 32 bits.
XX!  */
XX! #define S_IFMT  ((mode_t) 0170000)	/* type of file */
XX! #define S_IFREG ((mode_t) 0100000)	/* regular */
XX  #define S_IFBLK 0060000		/* block special */
XX  #define S_IFDIR 0040000  	/* directory */
XX  #define S_IFCHR 0020000		/* character special */
XX***************
XX*** 52,63 ****
XX  #define S_IWOTH   00002		/* others: -------w- */
XX  #define S_IXOTH   00001		/* others: --------x */
XX  
XX! /* The following macros test st_mode (from POSIX Sec. 5.6.1.1. */
XX! #define S_ISREG(m)	((m & S_IFMT) == S_IFREG)	/* is a reg file */
XX! #define S_ISDIR(m)	((m & S_IFMT) == S_IFDIR)	/* is a directory */
XX! #define S_ISCHR(m)	((m & S_IFMT) == S_IFCHR)	/* is a char spec */
XX! #define S_ISBLK(m)	((m & S_IFMT) == S_IFBLK)	/* is a block spec */
XX! #define S_ISFIFO(m)	((m & S_IFMT) == S_IFIFO)	/* is a pipe/FIFO */
XX  
XX  
XX  /* Function Prototypes. */
XX--- 51,62 ----
XX  #define S_IWOTH   00002		/* others: -------w- */
XX  #define S_IXOTH   00001		/* others: --------x */
XX  
XX! /* The following macros test st_mode (from POSIX Sec. 5.6.1.1). */
XX! #define S_ISREG(m)	(((m) & S_IFMT) == S_IFREG)	/* is a reg file */
XX! #define S_ISDIR(m)	(((m) & S_IFMT) == S_IFDIR)	/* is a directory */
XX! #define S_ISCHR(m)	(((m) & S_IFMT) == S_IFCHR)	/* is a char spec */
XX! #define S_ISBLK(m)	(((m) & S_IFMT) == S_IFBLK)	/* is a block spec */
XX! #define S_ISFIFO(m)	(((m) & S_IFMT) == S_IFIFO)	/* is a pipe/FIFO */
XX  
XX  
XX  /* Function Prototypes. */
XX***************
XX*** 65,75 ****
XX  #include <ansi.h>
XX  #endif
XX  
XX! _PROTOTYPE( int chmod, (const char *_path, int _mode)			);
XX  _PROTOTYPE( int fstat, (int _fildes, struct stat *_buf)			);
XX! _PROTOTYPE( int mkdir, (const char *_path, int _mode)			);
XX! _PROTOTYPE( int mkfifo, (const char *_path, int _mode)			);
XX! _PROTOTYPE( int stat , (const char *_path, struct stat *_buf)		);
XX! _PROTOTYPE( mode_t umask, (int _cmask)					);
XX  
XX  #endif /* _STAT_H */
XX--- 64,74 ----
XX  #include <ansi.h>
XX  #endif
XX  
XX! _PROTOTYPE( int chmod, (const char *_path, Mode_t _mode)		);
XX  _PROTOTYPE( int fstat, (int _fildes, struct stat *_buf)			);
XX! _PROTOTYPE( int mkdir, (const char *_path, Mode_t _mode)		);
XX! _PROTOTYPE( int mkfifo, (const char *_path, Mode_t _mode)		);
XX! _PROTOTYPE( int stat, (const char *_path, struct stat *_buf)		);
XX! _PROTOTYPE( mode_t umask, (Mode_t _cmask)				);
XX  
XX  #endif /* _STAT_H */
X/
Xecho x - times.h.d
Xsed '/^X/s///' > times.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/sys/times.h  crc=11830    453	Wed Apr 18 00:24:52 1990
XX--- /home/top/ast/minix/1.6.25//include/sys/times.h  crc=33089    443	Tue Nov  3 21:22:18 1992
XX***************
XX*** 5,11 ****
XX  
XX  #ifndef _CLOCK_T
XX  #define _CLOCK_T
XX! typedef	long clock_t;		/* time in ticks since process started */
XX  #endif
XX  
XX  struct tms {
XX--- 5,11 ----
XX  
XX  #ifndef _CLOCK_T
XX  #define _CLOCK_T
XX! typedef long clock_t;		/* unit for system accounting */
XX  #endif
XX  
XX  struct tms {
XX***************
XX*** 14,20 ****
XX    clock_t tms_cutime;
XX    clock_t tms_cstime;
XX  };
XX- 
XX  
XX  /* Function Prototypes. */
XX  #ifndef _ANSI_H
XX--- 14,19 ----
X/
Xecho x - types.h.d
Xsed '/^X/s///' > types.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/sys/types.h  crc=54922   1347	Wed Apr 18 00:24:52 1990
XX--- /home/top/ast/minix/1.6.25//include/sys/types.h  crc=13540   3914	Tue Nov 10 19:32:59 1992
XX***************
XX*** 7,35 ****
XX  #ifndef _TYPES_H
XX  #define _TYPES_H
XX  
XX! /* The type size_t holds the result of the size_of operator.  At first glance,
XX   * it seems obvious that it should be an unsigned int, but this is not always 
XX   * the case. For example, MINIX-ST (68000) has 32-bit pointers and 16-bit
XX   * integers. When one asks for the size of a 70K struct or array, the result 
XX!  * requires 17 bits to express, so size_t must be a long type.
XX   */
XX  #ifndef _SIZE_T
XX  #define _SIZE_T
XX! typedef unsigned int size_t;	  /* type returned by sizeof */
XX  #endif
XX  
XX  #ifndef _TIME_T
XX  #define _TIME_T
XX! typedef long time_t;		/* time in sec since 1 Jan 1970 0000 GMT */
XX  #endif
XX  
XX! typedef unsigned short	dev_t;	  /* holds (major|minor) device pair */
XX! typedef unsigned char	gid_t;	  /* group id */
XX! typedef unsigned short	ino_t;	  /* i-node number */
XX! typedef unsigned short	mode_t;	  /* mode number within an i-node */
XX! typedef unsigned char	nlink_t;  /* number-of-links field within an i-node */
XX! typedef long		off_t;	  /* offsets within a file */
XX! typedef int		pid_t;	  /* type for pids (must be signed) */
XX! typedef unsigned short	uid_t;	  /* user id */
XX  
XX  #endif /* _TYPES_H */
XX--- 7,111 ----
XX  #ifndef _TYPES_H
XX  #define _TYPES_H
XX  
XX! /* The type size_t holds all results of the sizeof operator.  At first glance,
XX   * it seems obvious that it should be an unsigned int, but this is not always 
XX   * the case. For example, MINIX-ST (68000) has 32-bit pointers and 16-bit
XX   * integers. When one asks for the size of a 70K struct or array, the result 
XX!  * requires 17 bits to express, so size_t must be a long type.  The type 
XX!  * ssize_t is the signed version of size_t.
XX   */
XX  #ifndef _SIZE_T
XX  #define _SIZE_T
XX! typedef unsigned int size_t;
XX  #endif
XX  
XX+ #ifndef _SSIZE_T
XX+ #define _SSIZE_T
XX+ typedef int ssize_t;
XX+ #endif
XX+ 
XX  #ifndef _TIME_T
XX  #define _TIME_T
XX! typedef long time_t;		   /* time in sec since 1 Jan 1970 0000 GMT */
XX  #endif
XX  
XX! #ifndef _CLOCK_T
XX! #define _CLOCK_T
XX! typedef long clock_t;		   /* unit for system accounting */
XX! #endif
XX! 
XX! #ifndef _SIGSET_T
XX! #define _SIGSET_T
XX! typedef unsigned long sigset_t;
XX! #endif
XX! 
XX! /* Types used in disk, inode, etc. data structures. */
XX! typedef short          dev_t;	   /* holds (major|minor) device pair */
XX! typedef char           gid_t;	   /* group id */
XX! typedef unsigned short ino_t; 	   /* i-node number */
XX! typedef short 	      mode_t;	   /* file type and permissions bits */
XX! typedef char         nlink_t;	   /* number of links to a file */
XX! typedef unsigned long  off_t;	   /* offset within a file */
XX! typedef int            pid_t;	   /* process id (must be signed) */
XX! typedef short          uid_t;	   /* user id */
XX! typedef long          zone_t;	   /* zone number */
XX! typedef long         block_t;	   /* block number */
XX! typedef long           bit_t;	   /* bit number in a bit map */
XX! typedef unsigned short zone1_t;	   /* zone number for V1 file systems */
XX! typedef unsigned short bitchunk_t; /* collection of bits in a bitmap */
XX! 
XX! typedef unsigned char   u8_t;	   /* 8 bit type */
XX! typedef unsigned short u16_t;	   /* 16 bit type */
XX! typedef unsigned long  u32_t;	   /* 32 bit type */
XX! 
XX! /* The following types are needed because MINIX uses K&R style function
XX!  * definitions (for maximum portability).  When a short, such as dev_t, is
XX!  * passed to a function with a K&R definition, the compiler automatically
XX!  * promotes it to an int.  The prototype must contain an int as the parameter,
XX!  * not a short, because an int is what an old-style function definition
XX!  * expects.  Thus using dev_t in a prototype would be incorrect.  It would be
XX!  * sufficient to just use int instead of dev_t in the prototypes, but Dev_t
XX!  * is clearer.
XX!  */
XX! typedef int            Dev_t;
XX! typedef int 	       Gid_t;
XX! typedef int 	      Mode_t;
XX! typedef int 	     Nlink_t;
XX! typedef int 	       Uid_t;
XX! typedef int             U8_t;
XX! typedef unsigned long  U32_t;
XX! 
XX! /* ANSI C makes writing down the promotion of unsigned types very messy.  When
XX!  * sizeof(short) == sizeof(int), there is no promotion, so the type stays
XX!  * unsigned.  When the compiler is not ANSI, there is usually no loss of
XX!  * unsignedness, and there are usually no prototypes so the promoted type
XX!  * doesn't matter.  The use of types like Ino_t is an attempt to use ints
XX!  * (which are not promoted) while providing information to the reader.
XX!  */
XX! 
XX! #ifndef _ANSI_H
XX! #include <ansi.h>
XX! #endif
XX! 
XX! #if _EM_WSIZE == 2 || !defined(_ANSI)
XX! typedef unsigned int      Ino_t;
XX! typedef unsigned int    Zone1_t;
XX! typedef unsigned int Bitchunk_t;
XX! typedef unsigned int      U16_t;
XX! 
XX! #else /* _EM_WSIZE == 4, or _EM_WSIZE undefined, or _ANSI defined */
XX! typedef int	          Ino_t;
XX! typedef int 	        Zone1_t;
XX! typedef int	     Bitchunk_t;
XX! typedef int	          U16_t;
XX! 
XX! #endif /* _EM_WSIZE == 2, etc */
XX!  
XX! /* Signal handler type, e.g. SIG_IGN */
XX! #if defined(_ANSI)
XX! typedef void (*sighandler_t) (int);
XX! #else
XX! typedef void (*sighandler_t)();
XX! #endif
XX  
XX  #endif /* _TYPES_H */
X/
Xecho x - wait.h.d
Xsed '/^X/s///' > wait.h.d << '/'
XX*** /home/top/ast/minix/1.5/include/sys/wait.h  crc=61682   1439	Sat Apr 21 22:20:20 1990
XX--- /home/top/ast/minix/1.6.25//include/sys/wait.h  crc=06701   1368	Tue Nov  3 21:22:18 1992
XX***************
XX*** 16,25 ****
XX  #ifndef _WAIT_H
XX  #define _WAIT_H
XX  
XX- #ifndef _TYPES_H		/* not quite right */
XX- #include <sys/types.h>
XX- #endif
XX- 
XX  #define _LOW(v)		( (v) & 0377)
XX  #define _HIGH(v)	( ((v) >> 8) & 0377)
XX  
XX--- 16,21 ----
XX***************
XX*** 29,35 ****
XX  #define WIFEXITED(s)	(_LOW(s) == 0)			    /* normal exit */
XX  #define WEXITSTATUS(s)	(_HIGH(s))			    /* exit status */
XX  #define WTERMSIG(s)	(_LOW(s) & 0177)		    /* sig value */
XX! #define WIFSIGNALED(s)	(((unsigned int)(x)-1 & 0xFFFF) < 0xFF) /* signaled */
XX  #define WIFSTOPPED(s)	(_LOW(s) == 0177)		    /* stopped */
XX  #define WSTOPSIG(s)	(_HIGH(s) & 0377)		    /* stop signal */
XX  
XX--- 25,31 ----
XX  #define WIFEXITED(s)	(_LOW(s) == 0)			    /* normal exit */
XX  #define WEXITSTATUS(s)	(_HIGH(s))			    /* exit status */
XX  #define WTERMSIG(s)	(_LOW(s) & 0177)		    /* sig value */
XX! #define WIFSIGNALED(s)	(((unsigned int)(s)-1 & 0xFFFF) < 0xFF) /* signaled */
XX  #define WIFSTOPPED(s)	(_LOW(s) == 0177)		    /* stopped */
XX  #define WSTOPSIG(s)	(_HIGH(s) & 0377)		    /* stop signal */
XX  
X/
/
