/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
*/

static char	sccsid[]	= "@(#)filer.c	1.22 87/10/26";

/*
**	Process files from message received from network.
*/

#define	FILE_CONTROL
#define	STAT_CALL
#define	RECOVER
#define	STDIO

#include	"global.h"

#include	"Passwd.h"
#include	"address.h"
#include	"debug.h"
#include	"ftheader.h"
#include	"header.h"
#include	"spool.h"
#include	"sub_proto.h"

/*
**	Parameters set from arguments.
*/

bool	Broadcast;		/* Message has been everywhere */
char *	CommandsFile;		/* A list of data files */
char *	DupNode;		/* Node at which message may have been duplicated */
char *	HomeNode;		/* Name of this node */
char *	LinkNode;		/* Message arrived from this node */
char *	Message;		/* Message */
char *	Name;			/* Program invoked name */
char *	SourceNode;		/* Message originated at this node */
Time_t	StartTime;		/* Time message started at source */
int	Traceflag;		/* Global tracing control */

/*
**	Miscellaneous
*/

bool	Ack;			/* Acknowledgement of delivery received */
char *	DataName;		/* Used by ExpandArgs() */
FthFD_p*FilesList;		/* Sorted vector of file descriptors */
char *	Home_Address;		/* Address of this node */
int	Pid;			/* Used by UniqueName() in Exec...() */
char	ProtoType[2];		/* Header protocol type */
bool	Returned;		/* True if invoked for returned message */
int	RetVal;			/* Value returned by program */
char *	SenderName;		/* Used by ExpandArgs() */
Time_t	Time;			/* Used by UniqueName() in Exec...() */
char *	UserName;		/* Used by ExpandArgs() */

char *	AckMessage	= WORKDIR(ack....message);
char *	PostMaster	= POSTMASTER;

#define	Fprintf		(void)fprintf

extern char *		DateString();

void	finish(), mailem(), readfiles(), returnmsg(), recvack(), sendack(), sortfiles();
int	byname();



int
main(argc, argv)
	register int	argc;
	register char *	argv[];
{
	register int	fd;
	FthReason	reason;
	char *		cp;

	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	Pid = getpid();
	Time = time((long *)0);

	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'B':
					Broadcast = true;
					continue;

				case 'T':
					if ( (Traceflag = atol(++*argv)) == 0 )
						Traceflag = 1;
					break;

				case 'c':
					CommandsFile = ++*argv;
					goto break2;

				case 'd':
					DataLength = atol(++*argv);
					break;

				case 'e':
					HdrEnv = ++*argv;
					goto break2;

				case 'h':
					HomeNode = ++*argv;
					goto break2;

				case 'l':
					LinkNode = ++*argv;
					goto break2;

				case 's':
					SourceNode = ++*argv;
					goto break2;

				case 't':
					StartTime = Time - atol(++*argv);
					goto break2;

				default:
					Trace2(1, "unrecognised flag '%c'", c);
					goto break2;
				}

				while ( (c = **argv) <= '9' && c >= '0' )
					++*argv;
				--*argv;
			}

break2:			;
		}
		else
		if ( Message != NULLSTR )
			Error("only one message allowed");
		else
			Message = *argv;
	}

	Home_Address = concat(HomeNode, Hierarchy(), NULLSTR);

	if ( (cp = GetEnv(ENV_RETURNED)) != NULLSTR )
	{
		free(cp);
		Returned = true;
	}

	if ( (cp = GetEnv(ENV_ACK)) != NULLSTR )
	{
		free(cp);
		Ack = true;
	}

	DupNode = GetEnv(ENV_DUP);

	while ( (fd = open(Message, O_READ)) == SYSERROR )
		Syserror("Can't open \"%s\"", Message);

	if
	(
		(reason = ReadFtHeader(fd, DataLength, !Returned && !Ack)) != fth_ok
		||
		(reason = GetFthFiles()) != fth_ok
	)
		Error("File transfer header \"%s\" error", FTHREASON(reason));

	(void)close(fd);

	if ( Ack )
	{
		sortfiles();
		recvack();
	}
	else
	{
		readfiles();

		if ( NFthUsers > 0 )
		{
			sortfiles();
			mailem();
		}

		if ( RetVal )
			exit(RetVal);
	}

	exit(0);
}



/*
**	Called from the errors routines to cleanup
*/

void
finish(error)
	int	error;
{
	if ( Ack )
		(void)unlink(AckMessage);

	(void)exit(error);
}



/*
**	Read the file transfer header from the message containing the file(s),
**	check and acknowledge the data if requested,
**	identify any users at this host, and spool links to the
**	message in the holding directory for each user.
*/

void
readfiles()
{
	register FthUlist *	up;

	if ( Returned )
	{
		FthUsers = Talloc(FthUlist);
		FthUsers->u_next = (FthUlist *)0;
		FthUsers->u_name = FthFrom;
		NFthUsers = 1;
	}
	else
	if ( GetFthTo() == 0 )
	{
		Error("addressing error - no users at \"%s\" in list \"%s\"", Home_Address, FthTo);
		return;	/* No users at this node */
	}

	Recover(ert_return);

	for ( up = FthUsers ; up != (FthUlist *)0 ; up = up->u_next )
	{
		register char *	spoolname;
		char		uid[UID_LENGTH+UNIQUE_NAME_LENGTH+1];
		Passwd		to;

		if ( !GetUid(&to, up->u_name) )
		{
			if ( !Broadcast )
			{
				Error("User \"%s\" does not exist at %s", up->u_name, Home_Address);
				RetVal = 1;	/* Return message and reason to source */
			}

			up->u_name = NULLSTR;
			NFthUsers--;
			continue;
		}

		for ( spoolname = uid ; spoolname < &uid[sizeof uid - 1] ; )
			*spoolname++ = '.';
		*spoolname = '\0';
		
		(void)UniqueUid(uid, to.P_uid);

		spoolname = UniqueName
			    (
				concat(FILESDIR(), uid, NULLSTR),
				(long)0,
				Time
			    );

		if ( CommandsFile != NULLSTR )
		{
			register int	fd;

			/*
			**	Groan, must copy everything...
			*/

			while ( (fd = creat(spoolname, 0600)) == SYSERROR )
				Syserror("Can't creat \"%s\"", spoolname);
			
			CopyFromComFile(CommandsFile, fd, spoolname, NULLSTR);
			CopyFile(Message, fd, spoolname);
			(void)close(fd);
		}
		else
			while ( link(Message, spoolname) == SYSERROR )
				Syserror("Can't link \"%s\" to \"%s\"", Message, spoolname);
		
		free(spoolname);
	}

	if ( !Returned && (FthType[0] & FTH_ACK) && NFthUsers > 0 )
		sendack(NULLSTR);	/* send ack for each user here */

	Recover(ert_finish);
}


/*
**	Sort files in message
*/

void
sortfiles()
{
	register FthFD_p	fp;
	register FthFD_p *	fpp;

	FilesList = fpp = (FthFD_p*)Malloc(sizeof(FthFD_p)*NFthFiles);

	for ( fp = FthFiles ; fp != (FthFD_p)0 ; fp = fp->f_next )
		*fpp++ = fp;
	
	if ( NFthFiles > 1 )
		qsort((char *)FilesList, NFthFiles, sizeof(FthFD_p), byname);
}


/*
**	Alphabetically
*/

int
byname(fpp1, fpp2)
	char *	fpp1;
	char *	fpp2;
{
	return strcmp((*(FthFD_p *)fpp1)->f_name, (*(FthFD_p *)fpp2)->f_name);
}



/*
**	Mail identified users
*/

void
mailem()
{
	register FthUlist *	up;
	register FthFD_p *	fpp;
	register FILE *		fd;
	register int		i;
	register char *		errs;
	register int		nusers;
	VarArgs			va;

	if ( Returned )
		SenderName = PostMaster;
	else
		SenderName = FthFrom;

	Recover(ert_return);

	for ( up = FthUsers, nusers = NFthUsers ; nusers > 0 ; )
	{
		FIRSTARG(&va) = BINMAIL;

#		ifdef	BINMAILARGS
		{
			char *	savesource = SourceNode;

			if ( Returned )
				SourceNode = Home_Address;

			ExpandArgs(&va, BINMAILARGS, NULLSTR);

			SourceNode = savesource;
		}
#		endif	BINMAILARGS

		for
		(
			;
			NARGS(&va) < MAXVARARGS && up != (FthUlist *)0
			;
			up = up->u_next
		)
		{
			if ( up->u_name == NULLSTR )
				continue;

			NEXTARG(&va) = up->u_name;
			nusers--;
		}

		fd = ExecPipe(&va);

		Fprintf(fd, "From %s@%s %s", SenderName, SourceNode, ctime(&Time));
		Fprintf(fd, "To: %s\n", FthTo);

		if ( Returned )
			returnmsg(fd);
		else
		if ( NFthFiles > 1 )
			Fprintf
			(
				fd,
				"Subject: Files from %s at %s\n\n",
				FthFrom,
				SourceNode
			);
		else
			Fprintf
			(
				fd,
				"Subject: \"%s\" from %s at %s\n\n",
				FthFiles->f_name,
				FthFrom,
				SourceNode
			);

		if ( FthType[0] & FTH_ACK )
			Fprintf(fd, "(Acknowledged.)\n\n");

		if ( DupNode != NULLSTR )
			Fprintf
			(
				fd,
				"(%s:- %s may have been duplicated at \"%s\" due to link problems.)\n\n",
				PostMaster,
				NFthFiles>1?"These files":"This file",
				DupNode
			);

		Fprintf
		(
			fd,
			"The following %s been %s to you at %s:\n  Mode       Size   Modify time  Name\n",
			NFthFiles>1?"files have":"file has",
			Returned?"returned":"sent",
			Home_Address
		);

		for ( fpp = FilesList, i = NFthFiles ; --i >= 0 ; fpp++ )
		{
			char	date[13];

			Fprintf
			(
				fd,
				"  0%3o %10ld  %s  %s\n",
				(*fpp)->f_mode & FTH_MODES,
				(*fpp)->f_length,
				DateString((*fpp)->f_time, date),
				(*fpp)->f_name
			);
		}

		Fprintf
		(
			fd,
			"\nPlease use \"%s\" to retrieve %s,\n(otherwise %s liable to be deleted after %d days).\n\n",
			FILEGETTER,
			NFthFiles>1?"these files":"this file",
			NFthFiles>1?"they are":"it is",
			FILESEXPIREDAYS
		);

		if ( (errs = ExPipeClose(fd)) != NULLSTR )
		{
			sendack(errs);
			free(errs);
			break;
		}
	}

	Recover(ert_finish);
}



/*
**	Make up message for returned files.
*/

void
returnmsg(fd)
	FILE *		fd;
{
	register char *	cp;
	register int	i;

	Fprintf
	(
		fd, 
		"Subject: Undelivered file%s returned from %s\n\n",
		NFthFiles>1?"s":"",
		SourceNode
	);


	for ( i = 0 ; i < 79 ; i++ )
		putc('*', fd);

	Fprintf
	(
		fd,
		"\nFILE%s SENT TO \"%s\" RETURNED FROM \"%s\"\n",
		NFthFiles>1?"S":"",
		FthTo,
		SourceNode
	);

	if ( (cp = GetEnv(ENV_ERR1)) != NULLSTR )
	{
		Fprintf(fd, "\nFailure explanation follows :-\n");
		Fprintf(fd, "%s\n", cp);
		free(cp);
	}

	if ( (cp = GetEnv(ENV_TRUNC)) != NULLSTR )
	{
		Fprintf(fd, "\nMessage was truncated at \"%s\"\n", cp);
		free(cp);
	}

	for ( i = 0 ; i < 79 ; i++ )
		putc('*', fd);

	Fprintf(fd, "\n\n");
}



/*
**	Send an acknowledgement message to source.
*/

void
sendack(mesg)
	char *			mesg;
{
	register long		size;
	register char *		errs;
	int			fd;
	VarArgs			va;
	static bool		acksent;

	if ( acksent )
		return;
	
	acksent = true;

	HdrEnv = MakeEnv
		 (
			 ENV_ACK, NULLSTR,
			 ENV_NORET, NULLSTR,
			 mesg==NULLSTR?NULLSTR:ENV_ERR1, mesg,
			 NULLSTR
		 );

	HdrDest = SourceNode;
	HdrSource = HomeNode;
	HdrHandler = Name;

	SetFthFiles();
	SetFthTo();

	while ( (fd = creat(UniqueName(AckMessage, (long)0, Time), 0600)) == SYSERROR )
		Syserror("Can't creat \"%s\"", AckMessage);

	while ( (size = WriteFtHeader(fd, (long)0, false, false)) == SYSERROR )
		Syserror("Can't write \"%s\"", AckMessage);

	ProtoType[0] = FTP;
	HdrSubpt = ProtoType;

	while ( WriteHeader(fd, size, 0) == SYSERROR )
		Syserror("Can't write \"%s\"", AckMessage);
	
	(void)close(fd);

	FIRSTARG(&va) = RECEIVER;
	NEXTARG(&va) = concat("-h", HomeNode, NULLSTR);
	NEXTARG(&va) = AckMessage;

	if ( (errs = Execute(&va)) != NULLSTR )
	{
		Error("Acknowledgement failed, but files spooled ok;\n\t%s\n", errs);

		RetVal = 1;
		free(errs);
	}
}



/*
**	Receive an acknowledgement generated by 'sendack()'.
**
**	Notify sender of acknowledgement.
*/

void
recvack()
{
	register int		i;
	register FILE *		fd;
	register FthFD_p *	fpp;
	char *			errs;
	VarArgs			va;
	char			date[13];

	SenderName = FthTo;	/* Ack from receiver of files */

	FIRSTARG(&va) = BINMAIL;

#	ifdef	BINMAILARGS
	ExpandArgs(&va, BINMAILARGS, NULLSTR);
#	endif	BINMAILARGS

	NEXTARG(&va) = FthFrom;	/* Ack to original sender */

	fd = ExecPipe(&va);
	
	Fprintf(fd, "From %s %s", PostMaster, ctime(&Time));

	Fprintf
	(
		fd,
		"Subject: Acknowledgement received for %s sent to %s at %s\n\n",
		NFthFiles>1?"Files":FthFiles->f_name,
		FthTo,
		SourceNode
	);

	if ( (errs = GetEnv(ENV_ERR1)) != NULLSTR )
	{
		Fprintf
		(
			fd,
			"NEGATIVE ACKNOWLEDGEMENT!\n\"%s\" not informed of delivery for the following reason:-\n%s\n\n",
			FthTo,
			errs
		);

		free(errs);
	}

	Fprintf
	(
		fd,
		"The following %s delivered on %s to %s at %s:\n  Mode       Size   Modify time  Name\n",
		NFthFiles>1?"files were":"file was",
		DateString(StartTime, date),
		FthTo,
		SourceNode
	);

	for ( fpp = FilesList, i = NFthFiles ; --i >= 0 ; fpp++ )
	{
		Fprintf
		(
			fd,
			"  0%3o %10ld  %s  %s\n",
			(*fpp)->f_mode & FTH_MODES,
			(*fpp)->f_length,
			DateString((*fpp)->f_time, date),
			(*fpp)->f_name
		);
	}

	if ( (errs = ExPipeClose(fd)) != NULLSTR )
	{
		Error(errs);
		free(errs);
	}
}
