/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Malloc.c	1.2 86/03/20
*/

/*
**	Safe "malloc"
*/

#include	"global.h"

#if	LIBMALLOC
#include	"malloc.h"	/* System 5 malloc */
#endif	LIBMALLOC


char *
Malloc(size)
	int		size;
{
	register char *	cp;
#if	LIBMALLOC
	static int	MallocSet = 0;

	if (MallocSet == 0)
	{
		++MallocSet;
		(void) mallopt(M_MXFAST, 32);
		(void) mallopt(M_NLBLKS, 64);
	}
#endif	LIBMALLOC

	while ( (cp = malloc((unsigned)size)) == NULLSTR )
		Syserror("no memory for malloc(%d)", size);

	return cp;
}
