/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)RdStats.c	1.5 87/10/01
*/

/*
**	Save statistics file, make a new (empty) one, and read the old one.
*/

#define	FILE_CONTROL
#define	LOCKING
#define	STDIO

#include	"global.h"
#include	"stats.h"


static char *	StatsFile;

extern Time_t	Time;


void
RdStats(idp, funcp, move)
	char *		idp;
	bool		(*funcp)();
	bool		move;
{
	register FILE *	fd;

	if ( StatsFile == NULLSTR )
		StatsFile = STATSFILE;

	if
	(
		access(StatsFile, 0) == SYSERROR
		||
		(fd = fopen(StatsFile, move?"r+":"r")) == NULL
	)
		return;
	
	if ( move )
	{
		register int	ofd;
		char *		fn;
		static char *	totals = ACCSTATS;

		fn = UniqueName(newstr(STATSDIR(statsfile.back)), (long)0, Time);

#		if	AUTO_LOCKING == 1
		if ( (ofd = creat(fn, 0600)) == SYSERROR )
		{
			SysWarn(fn);
			(void)fclose(fd);
			free(fn);
			return;
		}

		if
		(
			unlink(StatsFile) == SYSERROR
			||
			MakeLock(StatsFile) == SYSERROR
		)
			SysWarn(StatsFile);

		CopyFd(fileno(fd), StatsFile, ofd, fn);
		(void)fclose(fd);
		fd = fdopen(ofd, "r");
		rewind(fd);

#		else	AUTO_LOCKING == 1

		Lock(StatsFile, fileno(fd), for_writing);

		if
		(
			link(StatsFile, fn) == SYSERROR
			||
			unlink(StatsFile) == SYSERROR
			||
			MakeLock(StatsFile) == SYSERROR
		)
		{
			SysWarn(StatsFile);
			UnLock(fileno(fd));
			(void)fclose(fd);
			free(fn);
			return;
		}

		UnLock(fileno(fd));
#		endif	AUTO_LOCKING == 1

		if ( (ofd = open(totals, O_WRITE)) != SYSERROR )
		{
#			if	AUTO_LOCKING != 1
			(void)Lock(totals, ofd, for_writing);
#			endif

			(void)lseek(ofd, (long)0, 2);

			CopyFd(fileno(fd), fn, ofd, totals);

#			if	AUTO_LOCKING != 1
			UnLock(ofd);
#			endif
			(void)close(ofd);
			(void)unlink(fn);
			rewind(fd);
		}

		free(fn);
	}

	Rstats(idp, funcp, fd);

	(void)fclose(fd);
}



void
NewStats(newfile)
	char *	newfile;
{
	StatsFile = newfile;
}
