/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)QuoteChars.c	1.1 84/06/12
*/

/*
**	Disable/enable any restricted characters within strings.
*/

#include	"global.h"



void
QuoteChars(cp, restricted)
	register char *	cp;
	register char *	restricted;
{
	while ( (cp = strpbrk(cp, restricted)) != NULLSTR )
		*cp++ |= 0200;
}



void
UnQuoteChars(cp, restricted)
	register char *	cp;
	register char *	restricted;
{
	register int	c;

	while ( c = *cp++ )
		if ( c & 0200 )
		{
			c &= 0177;

			if ( strchr(restricted, (char)c) != NULLSTR )
				cp[-1] = c;
		}
}
