/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ReadFile.c	1.2 84/07/16
*/

/*
**	Read in a file, and pass back a pointer to data.
**
**	Remove any trailing '\n',
**	and guarantee at least 1 byte exists beyond '\0'.
**
**	Size of data is exported in "RdFileSize".
*/

#define	FILE_CONTROL
#define	STAT_CALL

#include	"global.h"
#include	"debug.h"


#define	MAX_SIZE	32000	/* Maximum size of file we are prepared to read this way */

int		RdFileSize;



char *
ReadFile(file)
	register char *	file;
{
	register int	fd;
	struct stat	statb;

	if
	(
		(fd = open(file, O_READ)) == SYSERROR
		||
		fstat(fd, &statb) == SYSERROR
		||
		(RdFileSize = statb.st_size) > MAX_SIZE
		||
		RdFileSize <= 0
	)
		return NULLSTR;

	file = Malloc(RdFileSize+2);

	if ( read(fd, file, RdFileSize) != RdFileSize )
	{
		(void)close(fd);
		free(file);
		return NULLSTR;
	}

	(void)close(fd);

	if ( file[RdFileSize-1] == '\n' )
		RdFileSize--;
	file[RdFileSize] = '\0';
	
	return file;
}
