/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)command.h	1.2 84/06/20
*/

/*
**	Define shape of node-node daemon command files.
*/

#define	NNCFNZ		13			/* Length of last component of a node-node command file name */

/*
**	Each command file contains sequences of 3 fields:
**	1.	filename.
**	2.	number representing base of data in file.
**	3.	number representing amount of data in file.
*/

typedef enum { cs_fn, cs_base, cs_range }	Com_s;

/*
**	If field 3 is zero then:
**	  if field 2 is zero, field 1 is filename to be unlinked;
**	  otherwise field 2 is a timeout:
**	    if time_now > command_time + timeout, ignore data commands.
*/

/*
**	Limits on size of a command file
*/

#define	MINCOMZ	6
#define	MAXCOMZ	3000

/*
**	Structures used to hold memory images of command file.
*/

typedef struct Com_l *	ComEl_p;
typedef struct Com_l
{
	ComEl_p	ce_next;
	char *	ce_name;
	long	ce_base;
	long	ce_range;
}
	ComEl;

typedef struct
{
	ComEl *	ch_first;
	ComEl **ch_last;
	long	ch_size;
	Time_t	ch_mtime;
}
	ComHead;

/*
**	Operations on a ComHead performed by FreeCom().
*/

typedef enum
{
	init_ch, free_ch
}
	FreeCom_t;
