/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)SplitArg.c	1.4 85/08/01
*/

/*
**	Split argument into separate "VarArg" entries on white space.
**	White space (and quotes) may be quoted (single or double) or escaped.
**
**	(Based on a version from Michael Rourke.)
*/

#include	"global.h"



int
SplitArg(to, arg)
	VarArgs *	to;
	register char *	arg;
{
	register int	c;
	register int	quote;
	register char *	cp;
	char *		temp = Malloc(strlen(arg)+2);
	int		count = 0;

	for ( c = *arg++ ; c != '\0' ; )
	{
		cp = temp;
		quote = '\0';

		while ( c == ' ' || c == '\t' || c == '\n' )
			c = *arg++;

		for ( ; c != '\0' ; c = *arg++ )
		{
			if ( c == quote )
			{
				quote = '\0';
				continue;
			}

			switch ( c )
			{
			case ' ': case '\t': case '\n':
					if ( quote != '\0' )
						break;
					goto break2;

			case '\'': case '"':
					if ( c == quote )
						quote = '\0';
					else
						quote = c;
					continue;

			case '\\':	switch ( c = *arg++ )
					{
					case '\0':	arg--;
					default:	*cp++ = '\\';
					case '\\':	*cp++ = c;
							continue;

					case '\'': case '"':
							if ( quote && c != quote )
								*cp++ = '\\';
					case ' ': case '\t': case '\n':	;
					}
			}

			*cp++ = c;
		}

break2:
		if ( cp != temp )
		{
			*cp++ = '\0';

			if ( NARGS(to) < MAXVARARGS )
				NEXTARG(to) = newstr(temp);

			count++;
		}
	}

	free(temp);
	return count;
}
