/*
**	patterns and functions to call basser from fawnray
**
**	SCCSID @(#)fawnray.c	1.3 84/07/04
*/

#include	"global.h"
#include	"caller.h"
#include	"basser.q"

#ifndef	BASSER_PASSWD
#define	BASSER_PASSWD	""
#endif
#ifndef	CALLARGS
#define	CALLARGS	"callargs"
#endif

extern	int	Traceflag;

extern struct patlist	*current;

char
	*daemon1 = NNDAEMON,		/* standard daemon */
	*daemon2 = NN2DAEMON,		/* alternate protocol */
	*host	 = "fawnray",		/* connecting from fawnray */
	*target  = "basser",		/* connecting to basser */
	*hostflg = "-BC",		/* dialup, don't fork, cooked */
	*phoneno = "660-2876",		/* phone number to ring */
	*passwd  = BASSER_PASSWD,
	*device  = "/dev/net/dialler",
	*speed   = "1200",
	*retry	 = "60",		/* seconds between open attempts */
	*retries = "3",			/* times to attempt open */
	*delay	 = "15";		/* TIMEOUT every delay seconds */

int
	fcount	 = 0,	/* count of gross failures */
	tcount	 = 0,	/* count of timeouts */
	lcount	 = 0;	/* count of Unix login attempts */

char	*pump;		/* current string to prompt response from remote */

struct patlist *tostate;/* state to enter on timeout */

int
	eof(),
	failure(),
	gotdialler(),
	gotlogin(),
	gotpasswd(),
	slowhost(),
	started(),
	start2(),
	timeout(),
	tobasser();


struct patlist atdialler[] =
{
	{ "CDS \>", gotdialler },
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ 0, 0 }
};

struct patlist callbasser[] =
{
	{ "INITIATING", tobasser },
	{ "CALL FAILED", failure },
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ 0, 0 }
};

struct patlist atbasser[] =
{
	{ "login", gotlogin },
	{ "Login", gotlogin },
	{ "CALL FAILED", failure },
	{ "CDS \>", gotdialler },
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ 0, 0 }
};

struct patlist basserlogin[] =
{
	{ "password", gotpasswd },
	{ "Password", gotpasswd },
	{ STARTMSG, started},	/* some moron might have deleted passwd */
	{ START2MSG, start2 },	/* alternate protocol */
	{ "[Ll]ogin +[Ii]ncorrect", tobasser },
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ 0, 0 }
};

struct patlist daemonwait[] =
{
	{ STARTMSG, started},
	{ START2MSG, start2 },				/* alternate protocol */
	{ "[Ll]ogin +[Ii]ncorrect", tobasser },
	{ "[Ww]rong +[Pp]assword", tobasser },		/* cretins ! */
	{ TIMEOUT, slowhost },
	{ EOFSTR, eof },
	{ 0, 0 }
};



args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'd':
					device = ++*argv;
					goto break2;
				case 'l':
					host = ++*argv;
					goto break2;
				case 'p':
					phoneno = ++*argv;
					goto break2;
				case '1':
					daemon1 = ++*argv;
					goto break2;
				case '2':
					daemon2 = ++*argv;
					goto break2;
				case 'T':
#ifdef TRACE
					Traceflag = atoi(++*argv);
#endif
					goto break2;
				default:
					out("fail unexpected flag \"-");
					out(*argv);
					out("\" in ");
					out(CALLARGS);
					exit(1);
				}
			}
break2:			;
		}
		else
		{
			out("fail unexpected argument ");
			out(*argv);
			out(" in ");
			out(CALLARGS);
			exit(1);
		}
	}
}



init(argc, argv)
	int	argc;
	char	*argv[];
{
	(void)readargs(concat(SPOOLDIR(/), target, "/", CALLARGS, NULLSTR),
	    args);
	srand((getpid() << 3) + (int)time((long *)0));
	out("mode "); outend(hostflg);
	out("timeout "); outend(delay);
	out("retry "); out(retry); out(" "); outend(retries);
	out("opendial "); outend(device);
	outend("local");
	out("speed "); outend(speed);
	outend("read");
	tcount = 0;
	fcount = 0;
	pump = "\r";
	outend("write \r\r");
	tostate = atdialler;
	state(atdialler);
	getinput();
}

gotdialler()
{
	outend("remote");
	outend("sleep 2");
#ifdef	TRACE
	if (Traceflag)
		out("trace D "), out(phoneno), outend("\r");			/**/
#endif	TRACE
	out("write D "); out(phoneno); outend("\r");
	state(callbasser);
	getinput();
}


tobasser()
{
	if (++lcount >= 4) {
		outend("fail unable to login at basser");
		exit(1);
	}
	outend("sleep 10");
	outend("write \r");
	state(atbasser);
	getinput();
}

gotlogin()
{
#ifdef	TRACE
	if (Traceflag)
		out("trace "), out(host), outend("\r");			/**/
#endif	TRACE
	out("write "); out(host); outend("\r");
	pump = "\r";
	tostate = atbasser;
	state(basserlogin);
	getinput();
}


gotpasswd()
{
#ifdef	TRACE
	if (Traceflag)
		out("trace "), out("passwd"), outend("\r");		/**/
#endif	TRACE
	out("write "); out(passwd); outend("\r");
	state(daemonwait);
	getinput();
}


started()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon starting");	/**/
#endif	TRACE
	out("daemon "); outend(daemon1);
	out("succeed -B "); outend(target);
	exit(0);
}


start2()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon 2 starting");	/**/
#endif	TRACE
	out("daemon "); outend(daemon2);
	out("succeed "); out(hostflg); out(" "); outend(target);
	exit(0);
}


timeout()
{
	if (++tcount >= 3)
	{
		outend("fail timeout");
		exit(1);
	}
	out("write "); outend(pump);
	state(tostate);
	reset();
}


failure()
{
	if (++fcount >= 4) {
		outend("fail repeated failures");
		exit(1);
	}
	outend("close");
	sleep(((rand() >> 3) % (5 * 60)) + (5 * 60));
	out("retry "); out(retry); out(" "); outend(retries);
	out("opendial "); outend(device);
	out("speed "); outend(speed);
	outend("local");
	outend("read");
	tcount = 0;
	fcount = 0;
	pump = "\r";
	outend("write \r\r");
	tostate = atdialler;
	state(atdialler);
	getinput();
}

eof()
{
	outend("fail lost line to dailler");
	exit(1);
}

slowhost()
{
	if (++tcount >= 4) {
		outend("fail basser not responding");
		exit(1);
	}
	reset();
}
