/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)HomeAddress.c	1.7 85/06/19
*/

/*
**	Return true if address is us.
**
**	"hier" is set to 0 or a large number depending on whether domains
**	which we don't belong to, but which are in our hierarchy,
**	should be counted as "home".
*/

#include	"global.h"
#include	"address.h"
#include	"state.h"



bool
HomeAddress(s, handler, hier)
	char *		s;
	char **		handler;
	int		hier;
{
	int		loop;
	char		node[NODE_NAME_SIZE+1];
	NodeLink	nl;

	for ( loop = 0 ; loop < 2 ; loop++ )
	{
		if ( strchr(s, DOMAIN_SEP) != NULLSTR )
		{
			register Address *	address = SplitAddress(s);
			register char **	cpp;
			register int		i;
			char *			domhandler;

			for
			(
				i = address->ad_domains,
				cpp = &address->ad_strings[i],
				domhandler = NULLSTR ;
				i-- > 0 ;
			)
			{
				if ( !HomeDomain(*cpp--, &domhandler, i+hier) )
				{
					FreeAddress(address);
					return false;
				}

				if ( domhandler != NULLSTR && handler != (char **)0 )
				{
					*handler = domhandler;
					FreeAddress(address);
					return true;
				}
			}

			s = strncpy(node, address->ad_node, NODE_NAME_SIZE);
			node[NODE_NAME_SIZE] = '\0';

			FreeAddress(address);
		}

		if ( strccmp(s, HomeNode) == STREQUAL )
			return true;

		if ( FindNode(s, pt_msg, &nl) )
			return false;

		if ( HomeDomain(s, handler, EXCL_HIER) )
			return true;
		
		if ( (s = FindAlias(s)) == NULLSTR )
			break;
	}

	return false;
}
