/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Stats.c	1.2 84/11/05
*/

/*
**	Process statistics into state structures.
*/

#include	"global.h"
#include	"debug.h"

#include	"state.h"
#include	"node.h"

#include	<setjmp.h>

extern jmp_buf	NameErrJmp;
extern char *	HomeNode;



bool
Stats(type, time, size, from, to)
	Stats_t		type;
	ulong		time;
	long		size;
	char *		from;
	char *		to;
{
#	if	NODE_STATS == 1 || LINK_STATS == 1
	Entry *		fep;
	Entry *		tep;
	register Node *	fp;
	register Node *	tp;
	register Data *	dp;

	Trace6
	(
		3,
		"Stats typ %d tim %lu siz %ld fr %s to %s",
		type, time, size, from, to
	);

	if ( setjmp(NameErrJmp) )
		return false;
	
	if ( Home == (Entry *)0 )
		Home = Enter(HomeNode, NodeHash);

	fep = Enter(from, NodeHash);
	fp = fep->e_node;
	tep = Enter(to, NodeHash);
	tp = tep->e_node;

	switch ( type )
	{
	case st_link:
#		if	LINK_STATS == 1
		if ( size == 0 )
			break;

		dp = MakeLink(fep, tep);

		dp->d_time += time;
		dp->d_bytes += size;

		break;
#		else	LINK_STATS == 1
		return false;
#		endif	LINK_STATS == 1

	case st_from:
#		if	NODE_STATS == 1
		if ( time > fp->n_date )
			fp->n_date = time;

		if ( size == 0 )
			break;

		if ( Home == fep )
			break;
		else
		if ( Home == tep )
			fp->n_recvd += size;
		else
			fp->n_passfrom += size;

		break;
#		else	NODE_STATS == 1
		return false;
#		endif	NODE_STATS == 1

	case st_to:
#		if	NODE_STATS == 1
		if ( Home == fep )
			tp->n_sent += size;
		else
		if ( Home == tep )
			break;
		else
			tp->n_passto += size;

		break;
#		else	NODE_STATS == 1
		return false;
#		endif	NODE_STATS == 1
	}

	return true;
#	else	NODE_STATS == 1 || LINK_STATS == 1
	return false;
#	endif	NODE_STATS == 1 || LINK_STATS == 1
}
