.TH Alofi 1 "Release 1"  "AF Version 3"
.SH NAME
Alofi - a network-transparent audio server for LoFi
.SH SYNOPSIS
.PP
The AF audio server
is a network transparent  system developed at Digital CRL
for using LoFi audio hardware in a distributed environment.
.SH DESCRIPTION
.PP
Alofi is an AF server with LoFi/DECaudio device dependent support.
.SH STARTING UP
Alofi [:\fIportOffset\fP] [\fIoptions\fP] &
.SH OPTIONS
.TP
.B \-help
.IP 
Use the help switch to determine device independent arguments.
.TP
.B \-device \fIdevice\fP
.IP 
Specifies the name of the LoFi audio device.
If this switch is not used, the \fIAlofi\fP audio server will
default to the device specified by the
AUDIO_DEVICE environment variable or the \/dev\/lofi device.
(In general, \/dev\/lofi is a symbolic link to the \/dev\/lofi0 device
special file.)
.TP
.B \-ukernel \fIlodfile\fP
.IP 
Specifies an alternate DSP56001 absolute lodfile.
If \fIukernel\fP is not specified, the server 
checks for the AF_UKERNEL environment variable.
If neither the switch nor the AF_UKERNEL environment
is used, the server looks for 
the path DIR/main.lod
(Or DIR/mainteleport.lod in -teleport mode)
where DIR is the LODPATH environment variable if it
exists, otherise it is the config variable LODDIR.
.TP
.B \-pcoeff \fIcoeff_file\fP
.IP
Specifies an alternate set of X filter coefficients for
the primary/phone CODEC.
\fIcoeff_file\fP should be an ASCII file containing eight lines
with two bytes per line representing the X filter coefficients
for the AMD79C30A CODEC.  Here are the contents of an example file 
containing the default coefficients used on LoFi's telephone CODEC.

.DS L
  94 0F
  C2 AC
  94 FF
  22 AB
  36 EA
  4A B2
  A4 E2
  BC BA
.DE
.TP
.B \-teleport
.IP
When this switch is specified, the operation of the hifi parts of the
server are customized to work well with the Ariel Teleport DSP port
to telephone interface.  In this mode, device 2 is a 16 bit mono
path to Line 1 of the Teleport and device 3 is a 16 bit mono path
to Line 2 of the Teleport.  On device 2, the passthrough mode
controls the "line" or "local" setting of the local telephone set.
Device 2 also provides two "inputs".  Input 0 connects the interface
to the telephone line, while Input 1 connects the device to the
Teleport local battery circuit.  Along with -teleport, you must
specify "-mode ext" "-hrate xxx" and "-dspc xxx".
.IP
The Teleport mode replaces the low two client data bits on output with
inband signalling to the Teleport.  On input, the low two bits are
inband signalling from the Teleport, which are observed, but not
changed by the server.
.TP
.B \-nohifi
.IP
Disables HiFi support (devices 2, 3, and 4).
.TP
.B \-daa_gain {0,1}
.IP
Sets the state of the telephone DAA's gain control bit.  
Setting the bit to 1 (default)
disables the power limiting circuitry in the DAA.  Setting the bit to 0
enables the automatic power limiter.
.TP
.B \-mode {int,ext}
.IP
Sets the hi-fi operating mode:  \fIint\fP selects the
internal stereo DAC (44.1 kHz, two-channel output).  \fIext\fP selects an
external device connected to the DSP port.  NOTE:  make sure the switch on 
the back of the distribution box is set to match the operating mode.
Defaults to \fIint\fP.
.TP
.B \-hrate <#>
.IP
Informs the server of the hi-fi sample rate (in samples per second).  This
option does not set the rate for the hi-fi hardware.  The internal DAC runs
at 44100 samples per second.  External devices may have fixed sample rates,
be configurable with panel switches, or may be software configurable
(see the \fI-dspc\fP parameter below); consult the device's manual for 
details.  Defaults to 44100.
.TP
.B \-dspc <#>
.IP
Specifies a 3-bit DSP port value that sets the sample rate for some hi-fi
devices; consult the device's manual for details.  Only valid when the
external operating mode is selected.
.PP
.SH "AUDIO DEVICES"
.PP
The \fIAlofi\fP audio server presents five audio devices to client
applications.  These audio devices are the 8KHz mu-law telephone CODEC,
the 8KHz local audio CODEC, left and right stereo HiFi device, 
mono HiFi left channel device, and finally the mono HiFi right channel
device.  These audio devices have device numbers of 0 to 4.
In Teleport mode, there are 4 devices, numbered 0 to 3.
.SH "CONNECTION NAME"
.PP
From the user's prospective, every AF server has 
an \fIaudio connection\fP of the form:
.sp
.ce 1
\fIhostname:portOffset\fP
.sp
This information is used by the application to determine how it should
connect to the server.
.TP 8
.I hostname
The \fIhostname\fP specifies the name of the machine to which the 
audio device is physically connected.  
.TP 8
.I portOffset
The \fIportOffset\fP is used to identify
the audio server's port on \fIhostname\fP.
For example, to simultaneously run two audio servers on a given host,
you might select \fI0\fP or \fI1\fP for \fIportOffset\fP.
.PP
If the connection name to an audio server is not specified, 
then the environment variables \fIAUDIOFILE\fP or \fIDISPLAY\fP 
will be used.
.SH "ACCESS CONTROL"
The sample server provides two types of access control:  an authorization
protocol which provides a list of ``magic cookies'' clients can send to
request access, and a list of hosts from which connections are always
accepted.  
.SH "EXAMPLES"
.LP
Alofi has been used with the following three devices:
the Ariel ProPort Model 656, the Ariel Teleport Model 214, the Ariel DM-N 
Digital Microphone, and the Applied Speech Technologies A/D16.
.LP
A "-mode ext" option selects external operation (disabling the DECaudio's
built-in stereo DAC).  The "-dspc #" option sets bits on the DSP port 
to set the external device's sample rate in some device specific way.
The "-hrate #" informs the server of the sample rate (the actual sample
rate is usually set by the external device).

Ariel DM-N Digital Microphone settings:

        5.5 kHz:        Alofi -mode ext -dspc 3 -hrate 5500
        11.02 kHz:      Alofi -mode ext -dspc 2 -hrate 11020
        22.05 kHz:      Alofi -mode ext -dspc 1 -hrate 22050
        44.1 kHz:       Alofi -mode ext -dspc 7 -hrate 44100

Ariel ProPort Model 656 settings:

        8 kHz:          Alofi -mode ext -dspc 6 -hrate 8000
        11.025 kHz:     Alofi -mode ext -dspc 5 -hrate 11025
        16 kHz:         Alofi -mode ext -dspc 4 -hrate 16000
        32 kHz:         Alofi -mode ext -dspc 3 -hrate 32000
        44.1 kHz:       Alofi -mode ext -dspc 2 -hrate 44100
        48 kHz:         Alofi -mode ext -dspc 1 -hrate 48000

Applied Speech Technologies, A/D16: (fixed single channel, 16 kHz input)

        16 kHz:         Alofi -mode ext -hrate 16000

Ariel Teleport Model 214 settings:

        7.2 KHz:        Alofi -teleport -mode ext -dspc 2 -hrate 7200
        8.0 KHz:        Alofi -teleport -mode ext -dspc 1 -hrate 8000
        9.6 KHz:        Alofi -teleport -mode ext -dspc 0 -hrate 9600

.SH BUGS
DECaudio's built-in DAC will not work if there is an external device
plugged into the DSP port (regardless of the switch setting).
.PP
If you encounter a \fBrepeatable\fP bug, please 
submit a problem report to () and include the source code if possible.
.SH "SEE ALSO"
.PP
AF(1), Aaxp(1), Amaxine(1), Alofi(1), Ajv(1), Amsb(1), Aj300(1), aplay(1), arecord(1),
apass(1), aset(1), abrowse(1), afft(1), ahost(1), aphone(1), aprop(1), ahs(1),
axset(1), xpow(1), afxctl(1), aname2num(1), alsatoms(1), aevents(1), abob(1)
.SH COPYRIGHT
.PP
See the COPYRIGHTS file.
.sp
Copyright 1991-1994, Digital Equipment Corporation and
the Massachusetts Institute of Technology.
.SH AUTHORS
Digital Cambridge Research Lab

