.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.

.\" $Id: cstat.man,v 1.5 1994/01/27 10:45:51 misao Exp $
.TH CANNASTAT 1
.SH "NAME"
cannastat \- Display information about the Kana-Kanji conversion server
.SH "SYNOPSIS"
.B "cannastat [{\-cs|\-cannaserver} \fIcanna-server\fP"]
[\-p] [\-t] [\-a]
.SH "DESCRIPTION"
.PP
\fIcannastat(1)\fP displays information about the Kana-Kanji conversion
server \fIcannaserver(1M)\fP.  The information includes the
following: the name of the machine on which the connected server
exists, the \fIcannaserver(1M)\fP's version, the number of clients
connecting to the server, the name of the user connecting to the
server, its user number, the socket number, the number of contexts,
the time of connection to the server, the time of use of the server,
the idle time, the name of the host under which the client exists, and
the frequency of using each protocol.
.PP
If \fIcannastat(1)\fP is called without options, the following is
displayed:
.sp
.ft CW
.nf
  Connected to machine1
  Canna Server (Ver. 2.1)
  Total connecting clients 1
  USER_NAME    ID   NO U_CX          C_TIME   U_TIME   I_TIME  HOST_NAME
  kon           5    0    4  Tue 21  8:49am       11    12:48   machine2
.fi
.ft
.sp
.PP
The items represent the following:
.IP "USER_NAME" 16
User name
.IP "ID" 16
Socket number
.IP "NO" 16
User number
.IP "U_CX" 16
Context number
.IP "C_TIME" 16
Time of connection (h:min)
.IP "U_TIME" 16
User time (h:min:s)
.IP "I_TIME" 16
Idle time (h:min)
.IP "HOST_NAME" 16
Name of the host under which the client exists
.SH "OPTIONS"
.IP "\-cs \fIcanna-server\fP (or \-cannaserver \fIcanna-server\fP)" 12
Specifies the Kana-Kanji conversion server.
.IP "\-p" 12
Displays the frequency of using the protocol.
.IP "\-t" 12
Displays information about the user who started cannastat.  It
includes the frequency of using the protocol, as well as ID, NO, U_CX,
C_TIME, U_TIME, I_TIME, and HOST_NAME.
.IP "\-a" 12
Displays all information about all users.
.SH "FILES"
.IP @(cannaLibDir)/cannahost 36
Name of the host under which cannaserver is in operation.
.SH "SEE ALSO"
.PP
cannaserver(1M), cannakill(1M), cannacheck(1)
.PP
.SH "ENVIRONMENT"
.PP
.IP "CANNAHOST" 12
Specifies the name of the host under which \fIcannaserver(1M)\fP is in
operation.
