/*-------------------------------------------------------------*/
/*  File: footer.c 
 *
 *  Demonstrates the use of the FooterPanel widget.
 *
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/Caption.h>
#include <Xol/TextField.h>
#include <Xol/OblongButt.h>
#include <Xol/ControlAre.h>
#include <Xol/StaticText.h>
#include <Xol/FooterPane.h>

/* Labels for the Captions */
static char* fields[] = { "Directory:", "File:" };

/* Message for the footer area */
static char smsg[] = "Save suceeded\n";

/* Callback */
static void text_verify();
static void do_save();

/*-------------------------------------------------------------*/
Widget MakeWidgets(parent)
Widget parent;
{
    Widget w, control, cap, tf, b, st;
    int i;

/* Create the FooterPanel widget */    
    w = XtVaCreateManagedWidget("Footer",
                      footerPanelWidgetClass, parent,
                      NULL);

/* Create the ControlArea widget as the top child of the 
 * FooterPanel widget.
 */
    control = XtVaCreateManagedWidget("Control1",
                      controlAreaWidgetClass, w,
                      XtNlayoutType,       OL_FIXEDCOLS,
                      XtNmeasure,          1,
                      XtNalignCaptions,    True,
                      XtNtraversalManager, True,
                      XtNcenter,           True,
                      XtNsameSize,         OL_NONE,
                      NULL);

/* Add the Textfield widgets as children of the ControlArea */
    for(i = 0; i < XtNumber(fields); i++)
    {
        cap = XtVaCreateManagedWidget("caption",
                    captionWidgetClass, control,
                    XtNlabel,       fields[i],
                    NULL);

        tf = XtVaCreateManagedWidget("textfield",
                    textFieldWidgetClass, cap,
                    XtNwidth,       150,
                    XtNtraversalOn, True,
                    NULL);

        XtAddCallback(tf, XtNverification, text_verify,
                      (XtPointer)fields[i]);
    }

/* Add a button to the ControlArea widget */    
    b = XtVaCreateManagedWidget("saveButton",
                oblongButtonWidgetClass, control,
                XtNlabel,      "Save",
                NULL);

/* Add callback for the Save button */
    XtAddCallback(b, XtNselect, do_save, NULL);

/* Now create a StaticText widget as the bottom child of the
 * FooterPanel widget.
 */
    st = XtVaCreateManagedWidget("Stext", 
                      staticTextWidgetClass, w,
                      XtNstring,    smsg,
                      XtNheight,    30,
                      NULL);


    return w;
}
/*-------------------------------------------------------------*/
static void text_verify(w, client_data, call_data)
Widget    w;
XtPointer client_data, call_data;
{
    OlTextFieldVerifyPointer p_verify = 
                        (OlTextFieldVerifyPointer)call_data;
    
    printf("Field %s currently has: %s\n", (char*) client_data,
           p_verify->string);
}
/*-------------------------------------------------------------*/
static void do_save(w, client_data, call_data)
Widget    w;
XtPointer client_data, call_data;
{
/* Do whatever "Save" is supposed to do. This example exits
 * when the user presses the Save button.
 */
     XCloseDisplay(XtDisplay(w));
     exit(0);
}

