/*****************************************************************************
 * clipboard.c: A simple clipboard using X selections
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/StaticText.h>
#include <Xol/OblongButt.h>
#include <Xol/ControlAre.h>
#include <X11/Xatom.h>
#include "libXs.h"

void      grab_selection();
void      request_selection();
Boolean   convert_selection();
void      lose_selection();
void      show_selection();
void      toggle_type();

main(argc, argv)
    int             argc;
    char           *argv[];
{
  Widget   toplevel, selection, request, con, toggle, quit;

  toplevel = OlInitialize(argv[0], "Clipboard", NULL, 
                          0, &argc, argv);
  con = XtCreateManagedWidget("con", controlAreaWidgetClass,
                              toplevel, NULL, 0);

  /*
   * Create a button used to request the selection and
   * a text widget to display it.
   */
  request = XtCreateManagedWidget("getselection", 
                                  oblongButtonWidgetClass,
                                  con, NULL, 0); 

  selection = XtVaCreateManagedWidget("currentselection", 
                                      staticTextWidgetClass, con, 
                                      XtNstring, "staticText",
                                      NULL);

  XtAddCallback(request, XtNselect, request_selection, selection);
  XtAddEventHandler(selection, ButtonPress, FALSE,
                    grab_selection, NULL);
  
  XtRealizeWidget(toplevel);
  XtMainLoop();
}

void
request_selection(w, client_data, call_data)
  Widget     w;
  XtPointer  client_data, call_data;
{
  XtGetSelectionValue(w, XA_PRIMARY, XA_STRING,
                      show_selection, client_data, 
                      XtLastTimestampProcessed(XtDisplay(w)));
}

void
show_selection(w, client_data, selection, type, value, length, format)
  Widget         w;
  XtPointer      client_data;
  Atom          *selection, *type;
  XtPointer      value;
  unsigned long *length;
  int           *format;
{
  Arg wargs[2];
  if (*type == XA_STRING){
    xs_wprintf(client_data, "%s", value);
  }
}

void
grab_selection(w, client_data, event, continue_to_dispatch)
  Widget    w;
  XtPointer client_data;
  XEvent   *event;
  Boolean  *continue_to_dispatch;
{
  /*
   * Claim ownership of the PRIMARY selection.
   */
  Boolean result;

  if(event->xbutton.button == Button2) {
    if(result = XtOwnSelection(w, XA_PRIMARY, 
                    XtLastTimestampProcessed(XtDisplay(w)),
                    convert_selection,  /* handle requests */
                    lose_selection,     /* Give up selection*/
                    (XtSelectionDoneProc) NULL)) {
      xs_invert_widget(w);
      XtSetSensitive(w, FALSE);
    }
  }
}

Boolean
convert_selection(w, selection, target, type, value, length, format)
  Widget         w;
  Atom          *selection, *target, *type;
  XtPointer     *value;
  unsigned long *length;
  int           *format;
{
  Arg wargs[10];
  String str;
  static String savestr = NULL;

  if (*target == XA_STRING) {
    if(savestr == NULL) {
        XtSetArg(wargs[0], XtNstring, &str);
        XtGetValues(w, wargs, 1);
        savestr = XtNewString(str);
    }
    *type   = XA_STRING;
    *value  = (XtPointer)savestr;
    *length = strlen(*value);
    *format = 8;
    return(TRUE);
  } else
    return(FALSE);
}

void
lose_selection(w, selection)
  Widget   w;
  Atom    *selection;
{
  xs_invert_widget(w);
  XtSetSensitive(w, TRUE);
}
