/*****************************************************************************
 * pix_buttons.c: pixmap_browser functions
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xutil.h>
#include <Xol/OpenLook.h>
#include <Xol/Exclusives.h>
#include <Xol/RectButton.h>
#include "libXs.h"

Widget 
xs_create_pixmap_browser (parent,bitmaps,n_bmaps,callback,data,widgets)
  Widget     parent;         /* widget to manage the browser */
  xs_bitmap_struct *bitmaps; /* list of bitmaps              */
  int        n_bmaps;        /* how many bitmaps             */
  void      (*callback)();   /* invoked when state changes   */
  XtPointer  data;           /* data to be passed to callback*/
  WidgetList *widgets;
{
  Widget       browser;
  WidgetList   buttons;
  XImage     **images;
  int          i, n;
  Arg          wargs[3];

  /*
   * Malloc room for button widgets.
   */
  buttons = (WidgetList) XtMalloc(n_bmaps * sizeof(Widget));
  images = (XImage **) XtMalloc(n_bmaps * sizeof(XImage *));
  /*
   * Create an Exclusives widget.
   */
  n = 0;
  XtSetArg(wargs[n], XtNlayoutType, OL_FIXEDCOLS); n++;
  XtSetArg(wargs[n], XtNmeasure, 3); n++;
  browser = XtCreateManagedWidget("browser",
                                  exclusivesWidgetClass,
                                  parent, wargs, n);
  /*
   * Create a button for each tile. If a callback function
   * has been given, register it as an XtNselect
   */
  for(i=0;i< n_bmaps;i++) {
    images[i] = xs_create_image(parent, bitmaps[i].bitmap,
                                bitmaps[i].width,
                                bitmaps[i].height);

    buttons[i] = xs_create_pixmap_button(browser, images[i]);
    if(callback)
      XtAddCallback(buttons[i], XtNselect, callback, data);
  }
  /*
   * Manage all buttons and return the Exclusives widget
   */ 
  XtManageChildren(buttons, n_bmaps);
  if(widgets != NULL)
    *widgets = buttons;
  return(browser);
}

Widget
xs_create_pixmap_button(parent, image)
  Widget   parent;
  XImage  *image;
{
  Widget   button;
  Arg      wargs[10];
  int      n;

  /*
   * Display the XImage in the button and also store it
   * so it can be retrieved from the button later.
   */
  n = 0;
  XtSetArg(wargs[n], XtNlabelType,   OL_IMAGE); n++;
  XtSetArg(wargs[n], XtNlabelImage,  image); n++;
  XtSetArg(wargs[n], XtNuserData,    image); n++;
  button = XtCreateWidget("", rectButtonWidgetClass,
                          parent, wargs, n);
  /*
   * Return the unmanaged button.
   */
  return(button);
}

XImage *
xs_create_image(w, bits, width, height)
  Widget     w;
  char      *bits;
  Dimension  width, height;
{
  XImage *image;
  image = XCreateImage(XtDisplay(w),
                       OlVisualOfObject(w), 
                       1, XYBitmap, 0, 
                       bits, width, height, 32, 0);
  return(image);
}
