C  -------------------------------------------------------------------
C
C	Copyright (1990-1995) by Alexander Khibnik, Yuri Kuznetsov, and 
C	Eugene Nikolaev.
C
C The Locbif computation code in DsTool is distributed in the hope that it  
C will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty  
C of FITNESS FOR A PARTICULAR PURPOSE.  The software is provided as is without 
C any obligation on the part of Locbif authors, Cornell faculty, 
C Cornell staff or Cornell students to assist in its use, correction, 
C modification or enhancement. 
C
C  -------------------------------------------------------------------

      SUBROUTINE NEWTN (NX,NDIMM,NG,NFIX,NCAN,X0,EPS,EPSN,IT,IPR,FUN,
     A                  DFDX,DFUN,IER,ISTOP)
C     3.05.90.
c Rev.29.07.92 
C     18.11.92
C     15.06.94
C* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C*                                                                     *
C*    POPAMMA NEWTN PEHAHAEHA   TOHEH PEEH CCTEM     *
C*    HEHEHX YPABHEH  F(X) = 0  METOOM HTOHA, P KCPOBAH- *
C*    HOM HAEH EPEMEHHO  X(NFIX) = X0(NFIX).                     *
C*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*
C*    APAMETP:                                                       *
C*    =========                                                        *
C*    NX   - CO EPEMEHHX;                                         *
C*    NDIM - ABEHHA CTPOHA PAMEPHOCT MATP DFUN;             *
C*    NG   - HOMEP BEEHHO EPEMEHHO;                              *
C*    NFIX - HOMEP KCPOBAHHO EPEMEHHO;                           *
C*    X0   - HA BXOE POPAMM - HAAHOE PEHE K PEEH;     *
C*           HA BXOE - TOHEHHOE PEHE K PEEH C AAHHO   *
C*           TOHOCT.                                                *
C*    EPS  - TOHOCT METOA;                                          *
C*    EPSN - HA BXOE PEAHO OCTHTA TOHOCT.                   *
C*    IT   - HA BXOE POPAMM - MAKCMAHO OCTMOE CO TEPA;
C*           HA BXOE - CO CEAHHX TEPA;                     *
C*    IPR  - APAMETP PABEH EAT COOEH-POHO O HTOH  *
C*           BE A PAH;                                         *
C*    FUN  - M OPOPAMM BCEH PABX ACTE;                *
C*    DFDX - M POPAMM BCEH MATP ACTHX POBOHX;     *
C*    DFUN - BMEPH MACCB PAMEPHOCT NDIM*NX, COEPA MATP  *
C*           EPBX ACTHX POBOHX.                               *
C*    IER  - APAMETP OK:                                          *
C*             0-TEPA CEHO COC C TOHOCT EPS;             *
C*            -1-TPEEMA TOHOCT HE OCTHTA A ITC TEPA.     *
C*            -2-HA OEPEHO TEPA OPEETE HEHO CCTEM =0;
C*            -3-HE BCEH HAEH HK B HTOHOBCKOM POHOE;*
C*            -4-HE BCEHA MATPA ACTHX POBOHX;             *
C*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*
C*           BMAS - BCOMOATEH PAO MACCB.                    *
C*                                                                     *
C*           BBAEME OPOPAMM:                                  *
C*              DERN, FUN, JACOB.                                      *
C* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C*    P MEHEH MAKCMAHOO CA (NDIM) EPEMEHHX HEOXOMO   *
C*    MEHT PAMEPHOCT MACCBOB:   A(NDIM,NDIM), BMAS(NDIM),       *
C*                                     ARR1(NDIM,NDIM)                 *
C* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
      IMPLICIT REAL*8 (A-H,O-Z)
      IMPLICIT INTEGER*2 (I-N)
      include 'beetlebf.dim'
      EXTERNAL FUN, DFDX
      DIMENSION X0(1), DFUN(NDIMM,NX), BMAS(NDIM),DFNORM(NDIM)
C
      COMMON /CNWT1/ IPNT1
C
      COMMON /ADD6A/ XGMN, XGMX
      COMMON /ADD7A/ EPSNWT
      COMMON /ADD7B/ ITNWT
C
      COMMON /ALL3/  IBND
C
      COMMON /WORKBE/ ARR1(NDIM,NDIM), A(NDIM,NDIM)
C
      COMMON /MESSG/ MESSAG
C
      ISTOP = 0
      ITMAX = IT
      IT=0
      NFUN  = NX - 1
      EPSN  = 100.D0*EPSNWT
      DO 99 J=1,NX
         DFUN(NX,J) = 0.D0
 99   CONTINUE
      DFUN(NX,NFIX) = 1.D0
      XREM          = X0(NFIX)

C.... OPABM KCPOBAHH EPMEHH.
C
c         X0(NFIX) = XREM
C
C.... BCEM HAEH HK FUN B TOKE X0;
C     BCEHHE HAEH PAMEAEM B MACCBE BMAS.
C
        IER = 0
C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1021
 1021 FORMAT(/'    Determining system evaluation starting...')
      ENDIF
#endif
C***E

        CALL FUN (X0,BMAS,IER,ISTOP)

C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1022,IER,ISTOP
 1022 FORMAT(/'    Determining system evaluation completed with',
     *           ' IER=',I3,'  ISTOP=',I3)
      PRINT 1023,(BMAS(I),I=1,NX-1)
 1023 FORMAT('     Function values (BMAS)=',
     *     /('         ',3G23.15)) 
      ENDIF
#endif
C***E
        IF (ISTOP .NE. 0) RETURN
        IF (IER .NE. 0) THEN
            IER = -3
            RETURN
        ENDIF

      ANORMF=0.D0
      DO I=1,NX-1
        IF (ANORMF.LT.DABS(BMAS(I))) ANORMF=DABS(BMAS(I))
      ENDDO

        CALL SHOWIT(IT,EPSN,ANORMF)

      IF (IPNT1.EQ.0 .AND. ANORMF.GT.100.D0) THEN
            IER= -7
C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1025
 1025 FORMAT(/'    Function values too large: IER=-7')
      ENDIF
#endif
C***E
            RETURN
      ENDIF


C
C.... OPAHEM K O MAKCMAHOM C OCTMX TEPA.
C
      DO 440 IT = 1,ITMAX
C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1011,IT
 1011 FORMAT(//'    Corrector iteration ',I3)
      PRINT 1012,(X0(I),I=1,NX)
 1012 FORMAT(  '    Starting point (X0)=',
     *     /(  '         ',3G23.15)) 
      ENDIF
#endif
C***E
C
      IF (IPNT1 .EQ. 1)                      GOTO 101
      IF (IT.GT.ITNWT) GOTO 105
 101  CONTINUE
C
C.... BCEM MATP POBOHX DFUN.
C
      IER = 0
C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1031
 1031 FORMAT(/'    Jacobian evaluation starting...')
      ENDIF
#endif
C***E

      CALL JACOB (NX,NDIMM,X0,FUN,DFDX,DFUN,BMAS,IER,ISTOP)

C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1032,IER,ISTOP
 1032 FORMAT(/'    Jacobian evaluation completed with',
     *           ' IER=',I3,'  ISTOP=',I3)
      PRINT 1033, ((DFUN(I,J),J=1,NX),I=1,NX-1)
 1033 FORMAT('     Jacobian (DFUN)=',
     *     /('         ',3G23.15)) 
      ENDIF
#endif
C***E
      IF (ISTOP .NE. 0) RETURN
      IF (IER   .EQ. 0) GOTO 105
          IER = -4
          RETURN
 105  CONTINUE
C
C.... OPMPEM BEKTOP-CTOE (BMAS)  MATP (A).
C
         BMAS(NX)  = 0.D0
         DO 120 I=1,NX
            BMAS(I) =-BMAS(I)
	    DFNORM(I)=0.D0
            DO 110 J=1,NX
               A(I,J)=DFUN(I,J)
	       DFNORM(I)=DFNORM(I)+DABS(DFUN(I,J))
 110        CONTINUE
 120     CONTINUE
C
C.... PEAEM CCTEM HEHX PABHEH  A*Y = BMAS;
C     PEEHE Y PAMEAETC B MACCBE BMAS.
C
        IER = 0
C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1041
 1041 FORMAT(/'    Solving linear system...')
      ENDIF
#endif
C***E
        CALL LEQV (A,BMAS,NDIMM,NX,IER)
C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1042,IER
 1042 FORMAT(/'    Solving completed with IER=',I3)
      PRINT 1043,(BMAS(I),I=1,NX)
 1043 FORMAT('     Solution vector=',
     *     /('         ',3G23.15)) 
      ENDIF
#endif
C***E
        IF (IER .EQ. 0) GOTO 260
C
C.... MATPA A - BPOEHA.
C
           IER =-2
           RETURN
 260    CONTINUE
C
C.... HAXOM OEPEHOE PEHE.
C
        EPSN = 0.D0
        DO 320 I = 1,NX
           RR=X0(I)
           X0(I) = RR + BMAS(I)
           RR1   = DABS(BMAS(I))/(1.D0+DABS(RR))
	   IF (DABS(X0(I)).LT.1.D-5*RR1) X0(I)=0.D0
           IF(EPSN.LT.RR1) EPSN = RR1
 320    CONTINUE
C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1051
 1051 FORMAT(/'    Test of convergence:')
      PRINT 1052,(X0(I),I=1,NX)
 1052 FORMAT('     New point (X0)=',
     *     /('         ',3G23.15)) 
      PRINT 1053,EPSN
 1053 FORMAT('     Accuracy achieved (EPSN)=',G11.4)
      ENDIF
#endif
C***E
        IF (IBND .EQ. 0) GOTO 400
C
C.... COOEHE:POHO O HTOH BE A OCTME PAH.
C
        IWRT = 11
        IF (X0(NG) .LT. XGMN .OR. X0(NG) .GT. XGMX)
     A      CALL WRTOUT (IWRT,ISTEP,IPR,IT,IDIV,NCAN,NX,NDIMM,X0,DFUN)
C
C.... CEEHE HTOHOBCKOO POHOA O EPOCKOCT
C     X(NG) = XGMN ( X(NG) = XGMX)
C
        IF (X0(NG) .LT. XGMN) X0(NG) = XGMN
        IF (X0(NG) .GT. XGMX) X0(NG) = XGMX
C
C.... POBEPEM OEPEHOE PEHE HA TOHOCT.
C
 400  CONTINUE
C
C.... OPABM KCPOBAHH EPMEHH.
C
         X0(NFIX) = XREM
C
C.... BCEM HAEH HK FUN B TOKE X0;
C     BCEHHE HAEH PAMEAEM B MACCBE BMAS.
C
        IER = 0
C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1021
c 1021 FORMAT(/'    Determining system evaluation starting...')
      ENDIF
#endif
C***E

        CALL FUN (X0,BMAS,IER,ISTOP)

C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1022,IER,ISTOP
c 1022 FORMAT(/'    Determining system evaluation completed with',
c     *           ' IER=',I3,'  ISTOP=',I3)
      PRINT 1023,(BMAS(I),I=1,NX-1)
c 1023 FORMAT('     Function values (BMAS)=',
c     *     /('         ',3G23.15)) 
      ENDIF
#endif
C***E
        IF (ISTOP .NE. 0) RETURN
        IF (IER .NE. 0) THEN
            IER = -3
            RETURN
        ENDIF

      ANORMF=0.D0
      ANRMF1=0.D0
      DO I=1,NX-1
         R1=DABS(BMAS(I)/(1.D0+DFNORM(I)))
         IF (ANORMF.LT.DABS(BMAS(I))) ANORMF=DABS(BMAS(I))
         IF (ANRMF1.LT.R1) ANRMF1=R1
      ENDDO
C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1081,ANORMF,ANRMF1
 1081 FORMAT(/'    Function norms: ANORMF=',G11.4,'  ANRMF1=',G11.4)
      ENDIF
#endif
C***E

        CALL SHOWIT(IT,EPSN,ANORMF)

      IF (IPNT1.EQ.0 .AND. ANORMF.GT.100.D0) THEN
            IER= -7
C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1025
c 1025 FORMAT(/'    Function values too large: IER=-7')
      ENDIF
#endif
C***E
            RETURN
      ENDIF



C
        IF (EPSN .GT. EPS .OR. ANORMF.GT.EPS) GOTO 420
            IER = 0
            RETURN
 420    CONTINUE
        IF (IPNT1.EQ.0 .AND. EPSN.GT.10.D0) THEN
            IER= -5
C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1061
 1061 FORMAT(/'    Correction too large: IER=-5')
      ENDIF
#endif
C***E
            RETURN
        ENDIF
        IF (IT.GT.2 .AND. EPSN.GT. 10.0D0*EPSNOL) THEN
            IER= -6
C***B
#if defined(hib)
      IF (MESSAG.LE.-6) THEN
      PRINT 1071
 1071 FORMAT(/'    No progress in convergence: IER=-6')
      ENDIF
#endif
C***E
            RETURN
        ENDIF
        EPSNOL=EPSN
 440  CONTINUE
      IT  = ITMAX
      IER =-1
      RETURN
      END
