# include "mfile2"
/*
 *	Modified version of allo.c
 *
 */
/*
 *	Flag to mark a register temporarily busy
 */
# define TBUSY 01000
/*
 *	Resource nodes, used in allocation strategy
 */
#ifndef vulcan
NODE	resc[3];
#endif
/*
 *	Busy status of registers
 */
#if vulcan
int	busy[REGSZ] = { 0, };
#else
int     busy[REGSZ];
#endif
int     rdebug = 0;
#ifndef allo0
/*
 *	free everything
 */
allo0 ()
{
	register        i;
	REGLOOP (i)
		busy[i] = 0;
}
#endif
/*
 *	Called from order after a match in the code tables has been found.
 *	Allo returns the boolean telling if the registers are available
 *	for tree p.
 */
allo (p, q)
NODE *p;
struct optab   *q;
{
	register        i,
	                j;
	NEEDSZ		n;
	short		special = 0;
	n = q->needs;
	i = 0;
#ifdef ALLO_DEBUG
	if (rdebug > 1) {
		printf("allo( %o ), needs: ", p);
		prneeds(n);
		putchar('\n');
	}
#endif
	if (n & NXREG) {
		if (usable(p, n, FRx) == 0) {
			special++;
			goto cleanup;
		}
		resc[i].op = REG;
		resc[i].rval = FRx;
		resc[i].lval = 0;
		resc[i].name[0] = '\0';
		++i;
	}
	if (n & NIREG) {
		if (usable(p, n, Ri) == 0) {
			special++;
			goto cleanup;
		}
		resc[i].op = REG;
		resc[i].rval = Ri;
		resc[i].lval = 0;
		resc[i].name[0] = '\0';
		++i;
	}
	if (n & NDREG) {
		if (usable(p, n, Rd) == 0) {
			special++;
			goto cleanup;
		}
		resc[i].op = REG;
		resc[i].rval = Rd;
		resc[i].lval = 0;
		resc[i].name[0] = '\0';
		++i;
	}
	if (n & NACREG) {
		if (usable(p, n, Ra) == 0) {
			special++;
			goto cleanup;
		}
		resc[i].op = REG;
		resc[i].rval = Ra;
		resc[i].lval = 0;
		resc[i].name[0] = '\0';
		++i;
	}
	while (n & NINCOUNT) {
		resc[i].op = REG;
		resc[i].rval = freereg(p, n);
		resc[i].lval = 0;
		resc[i].name[0] = '\0';
		n -= NINREG;
		++i;
	}
	while (n & NACOUNT) {
		resc[i].op = REG;
		resc[i].rval = freereg (p, n);
		resc[i].lval = 0;
		resc[i].name[0] = '\0';
		n -= NAREG;
		++i;
	}
	if (n & NTMASK) {
		resc[i].op = OREG;
		resc[i].rval = TMPREG;
#ifdef STRUCT_TEMP
		if (p->op == STCALL || p->op == STARG || p->op == UNARY STCALL || p->op == STASG)
			resc[i].lval = freetemp ((SZCHAR * p->stsize + (SZINT - 1)) / SZINT);
		else
#endif
			resc[i].lval = freetemp ((n & NTMASK) / NTEMP);
		resc[i].name[0] = '\0';
		resc[i].lval = BITOOR (resc[i].lval);
		++i;
	}
cleanup:				/* entry for special allocations */
	/*
	 * turn off "temporarily busy" bit
	 */
	REGLOOP (j) {
		busy[j] & = ~TBUSY;
	}
	/*
	 * Couldn't get a register for a special class
	 */
	if (special)
		return(0);
	for (j = 0; j < i; ++j)
		if (resc[j].rval < 0)
			return (0);
	return (1);
}
/*
 * allocate k integers worth of temp space
 *
 * we also make the convention that, if the number of words is more than 1,
 * it must be aligned for storing doubles...
 */
freetemp (k)
{
# ifndef BACKTEMP
	int     t;
	if (k > 1) {
		SETOFF (tmpoff, ALDOUBLE);
	}
	t = tmpoff;
	tmpoff + = k * SZINT;
	if (tmpoff > maxoff)
		maxoff = tmpoff;
	if (tmpoff - baseoff > maxtemp)
		maxtemp = tmpoff - baseoff;
	return (t);
# else
#ifdef FREE_DEBUG
	if (rdebug > 2)
		printf("freetemp(%d)\n", k);
#endif
	tmpoff + = k * SZINT;
	if (k > 1) {
		SETOFF (tmpoff, ALDOUBLE);
	}
	if (tmpoff > maxoff)
		maxoff = tmpoff;
	if (tmpoff - baseoff > maxtemp)
		maxtemp = tmpoff - baseoff;
	return (-tmpoff);
# endif
}
/*
 * allocate a register of type n
 * p gives the type, if floating
 */
freereg (p, n)
NODE *p;
NEEDSZ	n;
{
	register        j;
#ifdef FREE_DEBUG
	if (rdebug > 2) {
		printf("freereg( %o, ", p);
		prneeds(n);
		printf(" ), rall = %o\n", p->rall);
	}
#endif
	/*
	 * not general; means that only one register (the result) OK for call
	 */
	if (callop (p->op)) {
		j = callreg (p);
		/*
		 * have allocated callreg first
		 */
		if (usable (p, n, j))
			return (j);
	}
	j = p->rall & ~MUSTDO;
	/*
	 * needed and not allocated
	 * special case: want an index register, if one's busy
	 *		 try the other one.
	 *
	 * Guard against the situation where we want a
	 * non-index register for j, but right now we
	 * are requesting an index register.  If we just
	 * blindly go ahead we might allocate j for the index
	 * register we really want.
	 */
	if (j != NOPREF && !((n & NINMASK) && !(rstatus[j] & SINREG))) {
		if (usable(p, n, j))
			return (j);
		else if (j == Ri && usable(p, n, Rj))
			return(Rj);
		else if (j == Rj && usable(p, n, Ri))
			return(Ri);
	}
	if (n & NINMASK) {
		if (usable(p, n, Ri))
			return (Ri);
		if (usable(p, n, Rj))
			return(Rj);
	} else if (n & NACOUNT) {
		for (j = Ra; j < Rk; ++j)
			if (rstatus[j] & SAREG)
				if (usable(p, n, j))
					return (j);
	}
	return (-1);
}
/*
 * decide if register r is usable in tree p to satisfy need n
 */
usable (p, n, r)
NODE *p;
NEEDSZ	n;
{
	register	*pr;
#ifdef FREE_DEBUG
	if (rdebug > 2) {
		printf("usable( %o, ", p);
		prneeds(n);
		printf(", %s), busy = %d\n", rnames[r], busy[r]);
	}
#endif
	/*
	 * Make sure the register being checked will satisfy one of
	 * the needs given, we assume that allo() will check in the
	 * correct order so that this code will make sense.
	 */
	switch(r) {
		case Ra:
			if (!(n & (NACREG|NAREG))) return(0);
			break;
		case Re:
			if (!(n & NAREG)) return(0);
			break;
		case Rd:
			if (!(n & NDREG)) return(0);
			break;
		case Ri:
			if (!(n & (NIREG|NINREG|NAREG))) return(0);
			break;
		case Rj:
			if (!(n & (NJREG|NINREG|NAREG))) return(0);
			break;
		case FRx:
			if (!(n & NXREG)) return(0);
			break;
		default:
			cerror("usable asked about register %d", r);
			/* NOTREACHED */
	}
	if (busy[r] > 1)
		return (0);
	if (busy[r] == 0) {
		busy[r] | = TBUSY;
		/*
		 * Account for overlapping registers
		 */
		if (r == Rd) {
	overlap:
			busy[Ra] |= TBUSY;
			busy[Re] |= TBUSY;
		} else if (r == Ra || r == Re)
			busy[Rd] |= TBUSY;
		return (1);
	}
	/*
	 * Check for sharing with the D register
	 */
	if (r == Rd) {		/* we know one of Ra and/or Re is busy */
		if ((busy[Ra] == 0 && shareit(p, Re, n)) ||
		    (busy[Re] == 0 && shareit(p, Ra, n))) {
			busy[Rd] |= TBUSY;
			goto overlap;
		}
		/*
		 * We let ushare check for the case where we have a
		 * straight share of the D register, i.e. no sharing
		 * via an overlap with the A or E register.
		 */
	}
	return(shareit(p, r, n));
}
/*
 * Can we make register r available by sharing frm p. given that
 * the need is n ?
 */
shareit(p, r, n)
NODE *p;
NEEDSZ	n;
{
	if ((n & NASL) && ushare(p, 'L', r))
		return(1);
	if ((n & NASR) && ushare(p, 'R', r))
		return(1);
	return(0);
}
/*
 * Can we find a register r to share on the left or right (as f == 'L' or 'R')
 *	of p ??
 *
 * Note that we have eliminated any chance of the D register floating down
 * here (as a share with the A or E registers) by the check in usable().
 */
ushare(p, f, r)
NODE *p;
char f;
{
	p = getlr(p, f);
	if (p->op == UNARY MUL)
		p = p->left;
	if (p->op == OREG || p->op == REG)
		return(r == p->rval);
	return(0);
}
recl2 (p)
register NODE	*p;
{
	register        r = p->rval;
	if (p->op == REG)
		rfree (r, p->type);
	else if (p->op == OREG)
		rfree (r, PTR + INT);
}
/*
 * mark register r free, if it is legal to do so
 * t is the type
 */
rfree (r, t)
TWORD t;
{
register int *pr;
	if (rdebug) {
		printf ("rfree( %s ), size %d\n", rnames[r], szty (t));
	}
	if (--busy[r] < 0)
		cerror ("register %s overfreed", rnames[r]);
	if (r == Rd) {
		if(--busy[Ra] < 0 || --busy[Re] < 0)
			cerror("overlap register overfreed");
	} else if (r == Ra || r == Re) {
		if (--busy[Rd] < 0)
			cerror("D register overfreed due to overlap");
	}
}
/*
 * mark register r busy
 * t is the type
 */
rbusy (r, t)
TWORD t;
{
register int *pr;
	if (rdebug) {
		printf ("rbusy( %s ), size %d\n", rnames[r], szty (t));
	}
	++busy[r];
	if (r == Rd) {
		++busy[Ra];
		++busy[Re];
	} else if (r == Re || r == Ra)
		++busy[Rd];
}
/*
 * print rewriting rule
 */
rwprint (rw)
{
	register        i,
	                flag;
	static char    *rwnames[] = {
		"RLEFT",
		"RRIGHT",
		"RESC1",
		"RESC2",
		"RESC3",
		0,
	};
	if (rw == RNULL) {
		printf ("RNULL");
		return;
	}
	if (rw == RNOP) {
		printf ("RNOP");
		return;
	}
	flag = 0;
	for (i = 0; rwnames[i]; ++i) {
		if (rw & (1 << i)) {
			if (flag)
				printf ("|");
			++flag;
			printf (rwnames[i]);
		}
	}
}
/*
 *	Reclaim resources after a template match or similar
 */
reclaim (p, rw, cookie)
NODE	*p;
COOKSZ	cookie;
{
	register NODE	**qq;
	register NODE	*q;
	register        i;
	NODE		*recres[5];
	struct respref	*r;
	/*
	 * get back stuff
	 */
	if (rdebug) {
		printf ("reclaim( %o, ", p);
		rwprint (rw);
		printf (", ");
		prcook (cookie);
		printf (" )\n");
	}
	if (rw == RNOP || (p->op == FREE && rw == RNULL))
		return;				 /* do nothing */
	walkf (p, recl2);
	if (callop (p->op)) {
		/*
		 * check that all scratch regs are free
		 *
		 * normally this is the same as allchk()
		 */
		callchk (p);
	}
	if (rw == RNULL || (cookie & FOREFF)) {
		/*
		 * totally clobber, leaving nothing
		 */
		tfree (p);
		return;
	}
	/*
	 * handle condition codes specially
	 */
	if ((cookie & FORCC) && (rw & RESCC)) {
		/*
		 * result is CC register
		 */
		tfree (p);
		p->op = CCODES;
		p->lval = 0;
		p->rval = 0;
		return;
	}
	/*
	 * locate results
	 */
	qq = recres;
	if (rw & RLEFT)
		*qq++ = getlr (p, 'L');
	if (rw & RRIGHT)
		*qq++ = getlr (p, 'R');
	if (rw & RESC1)
		*qq++ = &resc[0];
	if (rw & RESC2)
		*qq++ = &resc[1];
	if (rw & RESC3)
		*qq++ = &resc[2];
	if (qq == recres) {
		cerror ("illegal reclaim");
	}
	*qq = NIL;
	/*
	 * now, select the best result, based on the cookie
	 */
	for (r = respref; r->cform; ++r) {
		if (cookie & r->cform) {
			for (qq = recres; (q = *qq) != NIL; ++qq) {
				if (tshape (q, r->mform))
					goto gotit;
			}
		}
	}
	/*
	 * we can't do it; die
	 */
	cerror ("cannot reclaim");
gotit:
	/*
	 * STARGS are still STARGS
	 */
	if (p->op == STARG)
		p = p->left;
	/*
	 * to make multi-register allocations work
	 */
	q->type = p->type;
	/*
	 * maybe there is a better way !
	 */
	q = tcopy (q);
	tfree (p);
	p->op = q->op;
	p->lval = q->lval;
	p->rval = q->rval;
	for (i = 0; i < NCHNAM+1; ++i)
		p->name[i] = q->name[i];
	q->op = FREE;
	/*
	 * if the thing is in a register, adjust the type
	 */
	switch (p->op) {
		case REG:
			if (!rtyflg) {
				/*
				 * the C language requires intermediate results to change type
				 * this is inefficient or impossible on some machines
				 * the "T" command in match supresses this type changing
				 */
				if (p->type == CHAR || p->type == SHORT)
					p->type = INT;
				else if (p->type == UCHAR || p->type == USHORT)
					p->type = UNSIGNED;
				else if (p->type == FLOAT)
					p->type = DOUBLE;
			}
			/*
			 * unless necessary, ignore it
			 */
			if (!(p->rall & MUSTDO))
				return;
			i = p->rall & ~MUSTDO;
			if (i & NOPREF)
				return;
			if (i != p->rval) {
				if (busy[i]) {
					if (i == Ri && (p->rval == Rj || !busy[Rj]))
						i = Rj;
					else if (i == Rj && (p->rval == Ri || !busy[Ri]))
						i = Ri;
					else
						cerror ("faulty register move");
				}
				if (i != p->rval) {
					rbusy (i, p->type);
					rfree (p->rval, p->type);
					rmove (i, p->rval, p->type);
					p->rval = i;
				}
			}
		case OREG:
			if (busy[p->rval] > 1 && istreg(p->rval))
				cerror ("potential register overwrite");
	}
}
/*
 * copy the contents of p into q, without any feeling for
 *  the contents
 * this code assume that copying rval and lval does the job;
 *  in general, it might be necessary to special case the
 * operator types
 */
ncopy (q, p)
NODE *p, *q;
{
	register        i;
	q->op = p->op;
	q->rall = p->rall;
	q->type = p->type;
	q->lval = p->lval;
	q->rval = p->rval;
	for (i = 0; i < NCHNAM+1; ++i)
		q->name[i] = p->name[i];
}
/*
 * make a fresh copy of p
 */
NODE *
tcopy (p)
register        NODE *p;
{
	register        NODE *q;
	register        r;
	ncopy (q = talloc (), p);
	r = p->rval;
	if (p->op == REG)
		rbusy (r, p->type);
	else if (p->op == OREG)
		rbusy (r, PTR + INT);
	switch (optype (q->op)) {
		case BITYPE:
			q->right = tcopy (p->right);
		case UTYPE:
			q->left = tcopy (p->left);
	}
	return (q);
}
/*
 * check to ensure that all register are free
 */
allchk ()
{
	register        i;
	REGLOOP (i)
		if (istreg(i) && busy[i])
			cerror ("register allocation error");
}
/*
 * Pretty print needs from optab
 */
#if FREE_DEBUG | ALLO_DEBUG
prneeds(n)
NEEDSZ	n;
{
	register	flag = 0;
	if (n & NXREG)
		printf("NXREG"), flag++;
	if (n & NJREG) {
		if (flag++)
			putchar('+');
		printf("NJREG");
	}
	if (n & NIREG) {
		if (flag++)
			putchar('+');
		printf("NIREG");
	}
	if (n & NDREG) {
		if (flag++)
			putchar('+');
		printf("NDREG");
	}
	if (n & NBREG) {
		if (flag++)
			putchar('+');
		printf("NBREG");
	}
	if (n & NACREG) {
		if (flag++)
			putchar('+');
		printf("NACREG");
	}
	if (n & NINCOUNT) {
		if (flag++)
			putchar('+');
		printf("%d NINREG", (n & NINCOUNT) >> 4);
	}
	if (n & NACOUNT) {
		if (flag++)
			putchar('+');
		printf("%d NAREG", n & NACOUNT);
	}
	if (n & NTEMP) {
		if (flag++)
			putchar('+');
		printf("%d NTEMP", (n & NTMASK) / NTEMP);
	}
	if (n & NASR) {
		if (flag++)
			putchar('+');
		printf("NASR");
	}
	if (n & NASL) {
		if (flag++)
			putchar('+');
		printf("NASL");
	}
}
#endif
