/*	dr11.h		Jun 1 80	M02	*/

/*	DR-11 definitions */

/* command status */

#define	GO	0x0001		/* start DMA (write only) */
#define	FNCT1	0x0002		/* cmd to external device */
#define	FNCT2	0x0004		/* ditto */
#define	FNCT3	0x0008		/* double ditto */
#define	XBA16	0x0010		/* extended bus address (bit 17 of 18) */
#define	XBA17	0x0020		/* extended bus address (bit 18 of 18) */
#define	IE	0x0040		/* Interrupt enable */
#define	READY	0x0080		/* Ready - DMA done (read only) */
#define	CYCLE	0x0100		/* Force bus cycle (at GO) */
#define	DSTATC	0x0200		/* User device status (read only) */
#define	DSTATB	0x0400		/* ditto */
#define	DSTATA	0x0800		/* double ditto again */
#define	MAINT	0x1000		/* Maintanence mode */
#define	ATTN	0x2000		/* User device attention request (read only) */
#define	NEX	0x4000		/* non existant memory (read, or write 0) */
#define	ERROR	0x8000		/* error (incl NEX & ATTN) (read only) */

	/* ioctl interface */

#define	SETDRWC	((11<<8)|0)
#define	SETDRBA	((11<<8)|1)
#define	SETDRDB	((11<<8)|2)
#define	SETDRST	((11<<8)|3)
#define	GETDRWC	((11<<8)|4)
#define	GETDRBA	((11<<8)|5)
#define	GETDRDB	((11<<8)|6)
#define	GETDRST	((11<<8)|7)
#define	GETTIME	((11<<8)|8)
#define	DR11SET	((11<<8)|9)
#define	DR11GET	((11<<8)|10)
#define	WAKEDR11 ((11<<8)|11)
#define	WAITINTR ((11<<8)|12)

/* State bits */

#define	DROPEN	0x0001
#define	DRIO	0x0002
#define	DRINTR	0x0004
#define	DRWINTR	0x0008

/* flags bits */

#define	DRBDP	0x0001

/* ioctl buffer */

struct dr_iocb {
	short	sg_state;	/* driver internal state */
	short	sg_flags;	/* user settable flags */
	short	sg_drst;	/* cmd for next i/o */
	short	sg_drwc;	/* word count for next i/o (-'ve) */
	long	sg_drba;	/* user base address for next i/o */
	long	sg_tbase;	/* amnt to add to time if -'ve */
};
