#
/*
 * rm - unlinks files, recursively if called with -r flag
 */

#define	USAGE	"Usage is :  rm (-r) (-f) {directory or filename}\n"


struct stbuf	{
	int	dev;
	int	inum;
	int	mode;
	char	nlink;
	char	uid;
	char	gid;
	char	siz0;
	char	siz1;
	int	addr[8];
	int	adate[2];
	int	mdate[2];
	};


main(argc, argv)
char	*argv[];
	{
	char	*arg;
	int	i, fflag, rflag;

	argv++;    argc--;
	if ( argc == 0)  {
		printf( USAGE );
		exit();
		}

	fflag = 0;
	rflag = 0;
	for ( i=0; i<2; i++ )  {
		arg = *argv;
		if ( *arg++ == '-')
			if ( *arg == 'f')  {
				fflag++;
				argv++;    argc--;
				}
			else  if ( *arg == 'r')  {
				rflag++;
				argv++;    argc--;
				}
		}
	if ( argc == 0)  {
		printf( USAGE );
		exit();
		}

	while ( argc-- > 0)
		rm( *argv++, fflag, rflag);
	}


rm(arg, fflag, rflag)
char	arg[];
int	fflag, rflag;
	{
	char	*p;
	int	b, i, ccode, pid, newpid;
	struct	stbuf  buf;

	if ( stat(arg, &buf))  {
		printf("%s: non existent\n", arg);
		return;
		}
	if ((buf.mode & 060000) == 040000)  {
		if ( rflag )  {
			pid = getpid();
			if ( (newpid =fork()) == -1 )  {
				printf("%s: try again\n", arg);
				return;
				}
			if ( pid !=getpid() )  {
				if ( chdir(arg))  {
					printf("%s: cannot chdir\n", arg);
					exit(-1);
					}
				execl("/etc/glob", "glob", "-q", "rm", "-r",
					fflag? "-f": "*", fflag? "*": 0, 0);
				printf("%s: no glob\n", arg);
				exit(-1);
				}
			while ( wait(&ccode) !=newpid );
			return;
			}
		printf("%s: directory\n", arg);
		return;
		}

	if ( !fflag )  {
		if ((getuid()&0377) == buf.uid)
			b = 0200;
			else	b = 2;
		if ((buf.mode & b) == 0 && ttyn(0) != 'x')  {
			printf("%s: %o mode ", arg, buf.mode);
			i = b = getchar();
			while ( b !='\n' && b !='\0')
				b = getchar();
			if ( i !='y')
				return;
			}
		}
	if ( unlink(arg) )
		printf("%s: not removed\n", arg);
	}

putchar(c)
	{
	write(1, &c, 1);
	}

getchar()
	{
	char	c;
	if ( read(0, &c,1 ) != 1)
		return(0);
	return(c);
	}
