#

/*
 * Stripped down LP-11 Line printer driver
 */

#include "../param.h"
#include "../conf.h"
#include "../user.h"

#define	LPADDR	0177514

#define	IENABLE	0100
#define	DONE	0200

#define	LPPRI	10
#define	LPLWAT	50
#define	LPHWAT	100

struct	{
	int	lpsr;
	int	lpbuf;
	};

struct  {
	int	cc;
	int	cf;
	int	cl;
	int	flag;
	} lp11;

extern int	lbolt;


lpopen( dev, flag )
int	dev, flag;
	{

	if ( lp11.flag  ||  LPADDR->lpsr < 0 )  {
		u.u_error = EIO;
		return;
		};
	lp11.flag++;
	LPADDR->lpsr =| IENABLE;
	}



lpclose( dev, flag )
int	dev, flag;
	{
	lp11.flag = 0;
	}



lpwrite()
	{
	register int	c;

	while ( (c= cpass()) >= 0 )  {
		spl5();
		while ( lp11.cc > LPHWAT )  {
			lpstart();
			sleep( &lp11, LPPRI );
			}
		spl0();
		while ( putc( c, &lp11) )
			sleep( &lbolt, LPPRI );
		}
	spl5();
	lpstart();
	spl0();
	}



lpstart()
	{
	register int	c;

	while ( LPADDR->lpsr &DONE  &&  (c= getc(&lp11)) >= 0 )
		LPADDR->lpbuf = c;
	}



lpint()
	{

	lpstart();
	if ( lp11.cc == LPLWAT  ||  lp11.cc == 0 )
		wakeup( &lp11 );
	}
