#
/* 	Graphics library package for Unix	*/
/*      A classical hack - July 23rd 1975 2m's  */


/*	ginit()		must be called initially to set up raw mode etc
	gend()		should be called at the end to restore cooked mode etc
	gmoveto(x,y)	move to x,y
	gpointo(x,y)	move to x,y and display point
	gline(dx,dy)	draw line from current position dx,dy
	gdots(dx,dy)	as above, but line drawn dotted
	gbegtx()	precedes text displayed at current position
	gendtx()	closes above mode
	gtext(str)	displays string at current position
	gopen(frame)	opens frame (in range 1 - 95)
	gclose()	closes currently open frame
	gdelete(frame)	deletes frame
	gclear()	clears screen
	grepos(frame,x,y)	repositions frame to x,y
	gdrag(frame)	drags frame
	gpenin(&x,&y)	puts current pen press position into x a,d y,
			(returns : 	esc if valid point
					-1 if invalid point
					and a character if a character is typed)


*/


#define off 0
#define on 02000

#define absolute 04000

#define normal 0
#define dotted 1

#define mag 01777
#define neg 02000
#define pos 0

#define delfrm 041
#define addframe 042
#define clearscreen 043
#define reposframe 044
#define dragframe 045

#define eot 04
#define esc 033
#define graphcode 034
#define dotcode 036
#define endtextcode 036
#define textcode 0100
#define gescode 040



#define raw 040
#define echo 010
#define itt 0100000



ginit()
{
	int stat[3];
	gtty(1,stat);
	stat[2] =| raw;
	stat[2] =& ~itt;
        stat[2] =& ~echo;
	stty(1,stat);
};

gend()
{
	int stat[3];
	gdrag(0);
	gtty(1,stat);
	stat[2] =& ~raw;
	stat[2] =| itt;
	stat[2] =| echo;
	stty(1,stat);
};

gmoveto(x,y)
int x,y;
{
	dabs(x,y,off);
};


gpointo(x,y)
int x,y;
{
	dabs(x,y,on);
};

dabs(xc,yc,intensify)
int xc,yc;
int intensify;
{
	if (xc <0 || xc > 1023) return;
	if (yc <0 || yc > 1023) return;
	sendn(xc); sendn(yc+intensify+absolute);
};

gline(x,y)
int x,y;
{
	drel(x,y,off);
};

gdots(x,y)
int x,y;
{
	drel(x,y,dotted);
};

gbegtx()
{
	dsend(textcode);
};

gendtx()
{
	dsend(endtextcode);
};

gtext(str)
char *str;
{
	gbegtx();
	while (*str != 0) dsend(*str++);
	gendtx();
};

drel(xi,yi,line_type)
int xi,yi;
int line_type;
{
	if (xi > 1023 || xi < -1023) return;
	if (yi > 1023 || yi < -1023) return;
	if (line_type == dotted) dsend(dotcode);
	sendn(signmag(xi));
	sendn(signmag(yi));
};

gopen(frame)
int frame;
{
	if (frame < 0 || frame > 95) return;
	dsend(graphcode); dsend(frame+gescode); dsend(addframe);
};

gclose()
{
	dsend(graphcode);
};

gdelete(frame)
int frame;
{
	if (frame < 1 || frame > 96) return;
	/* this is to circumnaviagte an imsys bug which causes imsys
		to crash if we delete an empty frame drat it
	*/
	gopen(frame);gmoveto(100,100);gclose();
	dsend(graphcode); dsend(gescode+frame); dsend(delfrm); dsend(graphcode);
};

gclear()
{
	dsend(graphcode);dsend(gescode);dsend(clearscreen);
};

greposition(frame,x,y)
int frame,x,y;
{
	if (frame < 0 || frame > 96) return;
	dsend(graphcode);dsend(gescode+frame);dsend(reposframe);
	sendn(x);sendn(y+absolute);
};

gdrag(frame)
int frame;
{
	if (frame < 0 || frame > 96) return;
	dsend(graphcode);dsend(gescode+frame);dsend(dragframe);
};

signmag(num)
int num;
{
	return (((num < 0 ? -num:num) & mag) | (num < 0 ? neg:pos));
};

sendn(num)
int num;
{
	char ms,ls;
	ms = (num>>6) + 040; ls = (num&077) + 040;
	dsend(ms); dsend(ls);
};

dsend(ch)
char ch;
{
	char data;
	data = ch;
	write(1,&data,1);
};

gpenin(x,y)
int *x,*y;
{
	register c;
	char data;
	while ((c = read(0,&data,1)) <= 0) printf("'");
	if (data == eot) { gend(); exit(); };
	return ((data != '#') ? data : readpos(x,y));
};

readpos(x,y)
int *x,*y;
{
	char data[5];
	register i,c;
	for (i=0;i<5;i++)
		{ c=read(0,&data[i],1);
		   if (c<=0) { i--;printf("!");} else
		   if (data[i] == eot) { gend(); exit(); };
		};
	if (data[4] != esc )
		{ while (data[4] != esc)
			{ while ((c=read(0,&data[4],1))<=0);
			   write(1,&data[4],1);
			   if (data[4] == eot)
				{ gend();
				   exit();
				};
			};
		   printf(" bad position received\n\r");
		   return -1;
		};
	*x = ((data[0]-040)<<5) + (data[1]-040);
	*y = ((data[2]-040)<<5) + (data[3]-040);
	return esc;
};

