#
/* Compatible with UCLA tty driver */
/*
 * getty -- adapt to terminal speed on dialup, and call login
 */

/*
 * tty flags
 */
#define	HUPCL 01
#define	XTABS	02
#define	LCASE	04
#define	ECHO	010
#define	CRMOD	020
#define	RAW	040
#define	ODDP	0100
#define	EVENP	0200
#define	ANYP	0300
#define	SCOPE	0400
#define	INDCTL	01000
#define	USRBRK	02000
#define	ALL8	04000
#define	ITT	0100000

/*
 * Delay algorithms
 */
#define	CR1	010000
#define	CR2	020000
#define	CR3	030000
#define	NL1	000400
#define	NL2	001000
#define	NL3	001400
#define	TAB1	002000
#define	TAB2	004000
#define	TAB3	006000
#define	FF1	040000

#define	ERASE	0177
#define	KILL	025	/* ctrl-u */

/*
 * speeds
 */
#define	B110	3
#define	B150	5
#define	B300	7
#define	B1200	9
#define	B9600	13

#define	SIGINT	2
#define	SIGQIT	3

struct	sgtty {
	char	sgispd, sgospd;
	char	sgerase, sgkill;
	int	sgflag;
} tmode;

/* the following structure is for the "terms"
 * call for the ucla driver
 */

struct {
	int m_speed;
	char m_erase, m_kill;
	int m_flags;
	char m_nldelay, m_crdelay;
	char m_tbdelay, m_vtdelay;
	char m_width, m_length;
	int m_brk[8];
} sterms;

struct	tab {
	int	tname;		/* this table name */
	int	nname;		/* successor table name */
	int	iflags;		/* initial flags */
	int	fflags;		/* final flags */
	int	delays;		/* delays needed */
	int	ispeed;		/* input speed */
	int	ospeed;		/* output speed */
	char	*message;	/* login message */
	int	length;		/* height of screen */
	int	width;		/* width of screen */
} itab[] {

/* table '0'-1-2 300,150,110 */
/*

	'0', 1,
	ANYP+RAW+NL1+CR1, ANYP+ECHO+CR1,
	B300, B300,
	"\n\r\033;\007Login: ",

	1, 2,
	ANYP+RAW+NL1+CR1, EVENP+ECHO+FF1+CR2+TAB1+NL1,
	B150, B150,
	"\n\r\033:\006\006\017Login: ",

	2, '0',
	ANYP+RAW+NL1+CR1, ANYP+ECHO+CRMOD+XTABS+LCASE+CR1,
	B110, B110,
	"\n\rLogin: ",

 */
/* table '-' -- Console TTY 300 DECwriter II */
	'-', '-',
	ANYP+RAW+NL1+CR1, ANYP+ECHO+CRMOD+XTABS, 0,
	B300, B300,
	"\n\rLogin: ",
	0,0,

/* table '1' -- 150 - dial-in line */
	'1', '1',
	ANYP+RAW+NL1+CR1, EVENP+ECHO+ITT, FF1+CR2+TAB1+NL1,
	B150, B150,
	"\n\r\033:\006\006\017Login: ",
	0, 0,

/* table '2' -- 9600 - ITT terminals */
	'2', '2',
	ANYP+RAW+NL1+CR1, ANYP+XTABS+ECHO+CRMOD+ITT, 0,
	B9600, B9600,
	"\n\r\033;\007Login: ",
	18,80,

/* table '3' -- Tiger's line without echo */
	'3', '3',
	ANYP+RAW+NL1+CR1, ANYP+XTABS+CRMOD+ITT, 0,
	B9600, B9600,
	"\n\r\033;\007Login: ",
	0,0,

/* table '4' -- ASR 33 Teletype (AI Group) */
	'4', '4',
	ANYP+RAW+NL1+CR1, EVENP+XTABS+CRMOD+ECHO, TAB1+FF1,
	B110, B110,
	"\n\r\033;\007Login: ",
	0,70,

/* table '5' -- Small Newbury terminal */

	'5', '5',
	ANYP+RAW+NL1+CR1, ANYP+ECHO+XTABS+CRMOD+SCOPE, 0,
	B9600, B9600,
	"\n\r\007Login: ",
	24, 80,

/* table '6' -- Large Newbury terminal */

	'6', '6',
	ANYP+RAW+NL1+CR1, ANYP+ECHO+XTABS+CRMOD+SCOPE, 0,
	B9600,B9600,
	"\n\r\007Login: ",
	20,80,

/* table '7' -- Qume terminal */

	'7', '7',
	ANYP+RAW+NL1+CR1, ANYP+ECHO+CRMOD, 0,
	B1200, B1200,
	"\n\r\007Login: ",
	0, 0,
};

#define	NITAB	sizeof itab/sizeof itab[0]

char	name[16];
int	crmod;
int	upper;
int	lower;

main(argc, argv)
char **argv;
{
	register struct tab *tabp;
	register tname;

/*
	signal(SIGINT, 1);
	signal(SIGQIT, 0);
*/
	tname = '0';
	if (argc > 1)
		tname = *argv[1];
	for (;;) {
		for(tabp = itab; tabp < &itab[NITAB]; tabp++)
			if(tabp->tname == tname)
				break;
		if(tabp >= &itab[NITAB])
			tabp = itab;
		tmode.sgispd = tabp->ispeed;
		tmode.sgospd = tabp->ospeed;
		tmode.sgflag = tabp->iflags;
		stty(0, &tmode);
		puts(tabp->message);
		if(getname()) {
			terms(1, '\002t', &sterms);
			sterms.m_erase = tmode.sgerase = ERASE;
			sterms.m_kill = tmode.sgkill = KILL;
			sterms.m_flags = tabp->fflags;
			if(crmod)
				sterms.m_flags =| CRMOD;
			if(upper)
				sterms.m_flags =| LCASE;
			if(lower)
				sterms.m_flags =& ~LCASE;
			tmode.sgflag = sterms.m_flags & (0377 | ITT);
			tmode.sgflag =| tabp->delays;
			sterms.m_length = tabp->length;
			sterms.m_width = tabp->width;
			terms(1, '\003t', &sterms);
			stty(0, &tmode);
			execl("/bin/login", "login", name, 0);
			exit(1);
		}
		tname = tabp->nname;
	}
}

getname()
{
	register char *np;
	register c;
	static cs;

	crmod = 0;
	upper = 0;
	lower = 0;
	np = name;
	do {
		if (read(0, &cs, 1) <= 0)
			exit(0);
		if ((c = cs&0177) == 0)
			return(0);
		write(1, &cs, 1);
		if (c>='a' && c <='z')
			lower++;
		else if (c>='A' && c<='Z') {
			upper++;
			c =+ 'a'-'A';
		} else if (c==ERASE) {
			if (np > name)
				np--;
			continue;
		} else if (c==KILL) {
			np = name;
			continue;
		}
		*np++ = c;
	} while (c!='\n' && c!='\r' && np <= &name[16]);
	*--np = 0;
	if (c == '\r') {
		write(1, "\n", 1);
		crmod++;
	} else
		write(1, "\r", 1);
	return(1);
}

puts(as)
char *as;
{
	register char *s;

	s = as;
	while (*s)
		write(1, s++, 1);
}
