#include	"pop.h"

extern popout;
extern char ctab[];

/* Draws border of hchar and vchar chars
 * around the outside of popid.
 * 4 phases are performed.
 *
 * Because this is not a
 * 'standard' function, the
 * storing of the characters has
 * to take place in a rather
 * awkward manner - see below.
 */

pborder(popid,hchar,vchar)
char hchar, vchar;
{
register pop *p;
register h,v;
int n;

	/* Ensure that POP char class of
	 * border characters are normal printers
	 * which move the cursor forward
	 * one position to the right.
	 */

	if ((do_check(hchar) == -1) || (do_check(vchar) == -1))
		return(-1);

	if ((p = do_get(popid)) == -1)
		return(-1);

	/* start with top line */

	h = p->hmin;
	v = p->vmin;
	if (v != 1) {
		v--;
		if (h != 1)
			h--;
		n = p->hmax - h + 1;
		if (p->hmax != NCHARS)
			n++;
		s_cursor(h,v);
		while (n--) {
			do_push(hchar);
			m_cstore(hchar,h++,v);
		}
	}

	/* now bottom line */
	h = p->hmin;
	v = p->vmax;
	if (v != NLINES) {
		v++;
		if (h != 1)
			h--;
		n = p->hmax - h + 1;
		if (p->hmax != NCHARS)
			n++;
		s_cursor(h,v);
		while (n--) {
			do_push(hchar);
			m_cstore(hchar,h++,v);
		}
	}

	/* then the left hand side */
	h = p->hmin;
	v = p->vmin;
	if (h != 1) {
		h--;
		if (v != 1)
			v--;
		while (v <= p->vmax) {
			s_cursor(h,v);
			do_push(vchar);
			m_cstore(vchar,h,v++);
		}
		if (v <= NLINES) {
			s_cursor(h,v);
			do_push(vchar);
			m_cstore(vchar,h,v);
		}
	}

	/* and finally the right hand side */
	h = p->hmax;
	v = p->vmin;
	if (h != NCHARS) {
		h++;
		if (v != 1)
			v--;
		while (v <= p->vmax) {
			s_cursor(h,v);
			do_push(vchar);
			m_cstore(vchar,h,v++);
		}
		if (v <= NLINES) {
			s_cursor(h,v);
			do_push(vchar);
			m_cstore(vchar,h,v);
		}
	}
	pselect(popout);
	return(0);
}


do_check(c)
char c;
{

	switch (ctab[c&0177]) {
	case NL:
	case CR:
	case IGN:
	case TAB:
	case BELL:
	case LEFT:
	case RIGHT:
		return(-1);
	}

	return(0);
}
