#
/*
 *      File opser.c: control independent backround processes
 *                              written by Bob Greenberg
 */

# define N 7    /* number of processes + 1 */

# define CREATE 1
# define KILL 2
# define SEND 3
# define DISPLAY 4
# define CLOSE 5
# define WAIT 6
# define EXIT 7
# define STATUS 8
# define CONNCT 9
# define HELP 10
# define ENTER 11
# define USE 12
# define INTRP 13
# define QUIT 14

char buf[102], *name, *ptr, colonf;
char *newname "Pr000";
int sig13;
int p1[2], p2[2], curproc;
struct procs { int id; char iport; char oport; char *name; } proc[N];
extern int intrp(), quit(), awake(), pipesig();
int input;

char *cmnds[] {
	"create",       CREATE,
	"kill",         KILL,
	"send",         SEND,
	"display",      DISPLAY,
	"close",        CLOSE,
	"wait",         WAIT,
	"exit",         EXIT,
	"status",       STATUS,
	"connect",      CONNCT,
	"help",         HELP,
	"enter",        ENTER,
	"use",          USE,
	"interrupt",    INTRP,
	"quit",         QUIT,

	0 };

main()
{
	register int n, p, pout;
	char enterf;
	int eofcnt, helpst, stat;

	printf("\nOPSER\n");
	for (n=3; n <= 15; n++) close(n);
	signal(1,1);
	signal(2,&intrp);
	signal(3,&quit);
	signal(13,&pipesig);
	proc[0].id = 1; /* don't allow the 0th one! */
	proc[0].name = "all";
	eofcnt = 0;
	helpst = 0;
	setexit();
	if (input) { close(input); input = 0; }
	for (;;)
	{
		if (helpst)
		{
			free(helpst);
			helpst = 0;
		}
		if (input == 0) printf("* ");
		if ((n=read(input,buf,100)) == 0)
		{
			if (input) reset();
			if (++eofcnt >= 3) goto exit1;
			printf("(type `exit' to exit)\n");
			reset();
		}
		else eofcnt = 0;
		buf[n] = '\n';
		if (input != 2)
		{
			for (p=0; buf[p++] != '\n';);
			if (p > n)
			{
				printf("?Line too long in file.\n");
				reset();
			}
			seek(input,p-n,1);
		}
		n = buf;
reenter:        switch (p = cmnd(n)) {
		  case ENTER:
			enterf = 1;
			goto crt1;
		  case CREATE:
			enterf = 0;
	crt1:           pout = 0;
			if (colon() || (n=arg()) == 0) pout = n = newproc();
			for (p=0; p<N; p++)
				if (equalx(n,proc[p].name))
				{
					printf("?Duplicate name: `%s'.\n",n);
					goto crt2;
				}
			if ((p=create(n)) == 0)
			{
				printf("?Can't do create.\n");
	crt2:                   if (pout) --newname[4];
				reset();
			}
			enter(p);
			if (!enterf) break;
			n = curproc;
			goto con1;
		  case KILL:
		  case INTRP:
		  case QUIT:
			signal(2,1);
			if (n=gproc(1)) pwait(n,p);
			signal(2,&intrp);
			break;
		  case SEND:
			if ((n=gproc(0)) == 0) break;
			if ((p = proc[n].oport) < 0)
			{
				printf("?Already closed %s.\n",proc[n].name);
				reset();
			}
			if (colon())
			{
				sendln(p);
				break;
			}
			if (pout = arg())
				if ((n=open(pout,0)) == -1)
				{
					printf("?Can't read `%s'.\n",pout);
					reset();
				}
				else
				{
					while (pout=read(n,buf,100))
						dowrite(p,buf,pout);
					close(n);
				}
			else for (;;)
			{
				if ((n=read(input,buf,100)) == 0)
					if (input) break; else eofp(p);
				else dowrite(p,buf,n);
			}
			break;
/* NON-RBGUNIX way: while(n=read()) write(); */
		  case DISPLAY:
			if ((n=gproc(0)) == 0) break;
			p = proc[n].iport;
			if (empty(p)) printf("No output.");
				else while (!empty(p)) write(1,buf,doread(p));
			printf("\n");
			break;
		  case CLOSE:
			if (n=gproc(1)) pwait(n,CLOSE);
			if (n <= 0) break;
			goto con1;
		  case WAIT:
			if ((n=wait(&stat)) != -1) pkill(n);
			break;
		  case EXIT:
	exit1:          cleanup();
			exit();
		  case STATUS:
			n = gproc(2);
			if (n>0) pstatus(n);
			if (n<0) for (n=1; n<N; n++) pstatus(n);
			break;
		  case CONNCT:
			if ((n=gproc(0)) == 0) break;
			if (input)
			{
				printf("?Can't connect from a file.\n");
				reset();
			}
	con1:           if (input) break;
			p = proc[n].iport;
			pout = proc[n].oport;
	loop:           while (!empty(p)) write(1,buf,doread(p));
			if (empty(0)) goto loop;
			n = read(0,buf,100);
/* NON-RBGUNIX way:     if ((n=read(0,buf,100)) == 0) break;    */
			if (pout >= 0)
			{
				if (n) dowrite(pout,buf,n); else eofp(pout);
				goto loop;
			}
			printf("?Already closed %s.\n",proc[curproc].name);
			reset();
		  case HELP:
			printf("You are about to enter `l':\n");
			helpst = n = cpy("enter help l /doc/opser.help\n");
			goto reenter;
		  case USE:
			if (input)
			{
				printf("?Can't nest USE cmnd.\n");
				reset();
			}
			if ((n=arg()) == 0)
			{
				printf("?Must specify a file name.\n");
				reset();
			}
			if ((p=open(n,0)) > 0) input = p;
			else
			{
				printf("?Can't open `%s'.\n",n);
				reset();
			}
			break;
		}
	}
}

create(x)
{
	register int n, *p;
	register char *nm;
	int args[10];

	if ((name=x) == 0) return(0);
	if (pipe(p1) == -1) return(0);
	if (pipe(p2) == -1)
	{
		close(p1[0]);
		close(p1[1]);
		return(0);
	}
	if ((n=sfork()) == -1) return(0);
	if (n==0)
	{
		signal(1,0);    /* signal 2,3,13 will also be reset */
		for (n=0; n <= 15; n++)
			     if (n != 2 && n != p1[1] && n != p2[0]) close(n);
		dup(p2[0]);
		close(p2[0]);
		dup(p1[1]);
		close(p1[1]);
		if (nm = arg())
		{
			p = args;
			*p++ = nm;
			while (*p++ = arg());
			execv(nm,args);
			execv(nm = concat("/bin/",nm),args);
			execv(concat("/usr",nm),args);
			printf("\n{%s couldn't run `%s'}\n",name,&nm[5]);
			exit();
		}
		else execl("/bin/sh",concat("- (opser shell for ",
							  concat(x,")")),0);
		printf("\n{%s couldn't exec a shell}\n",name);
		exit();
	}
	return(n);
}
/* NON-RBGUNIX version:
1. Uses fork instead of sfork.
2. Replaces signal(1,0) with signal(2,1); signal(3,1).
3. No "- " in the execl concat call.
*/

enter(x)
{
	register int n;
	register struct procs *p;

	for (n=0; n<N; n++) if (proc[n].id == 0) goto entry;
	printf("?Table overflow.\n");
	reset();
entry:  p = &proc[n];
	p->id = x;
	p->iport = p1[0];
	p->oport = p2[1];
	p->name = cpy(name);
	curproc = n;
	close(p1[1]);
	close(p2[0]);
}

sendln(port)
{
	register char *p;
	register int n;

	p = ptr;
	n = 1;
	while (*p++ != '\n') ++n;
	dowrite(port,ptr,n);
}

newproc()
{
	register char *p;

	p = &newname[5];
	while (p > &newname[1])
	{
		++(*--p);
		if (*p != '9'+1) break;
		*p = '0';
	}
	printf("(Using name `%s'.)\n",newname);
	return(newname);
}

cmnd(q)
{
	register int *n;
	register char *p;

	p = q;
	while (*p++ == ' ');
	if (*--p == '\n') return(0);
	for (n=cmnds; *n; n++) if (ptr=equal(*n++,p)) return(*n);
	ptr = q;
	if (n = arg()) printf("?Command `%s' not recognized.\n",n);
	else printf("?Command not recognized.\n");
	reset();
}

equal(a,b)
char *a, *b;
{
	register char *x, *y;
	x = a;
	y = b;
	while (*x++ == *y++);
	if (*--x == 0) return(--y);
	if ((x-a) > 1) if (*--y == ' ' || *y == '\n' || *y == ':') return(y);
			  else printf("Mismatching char: %c ",*y);
	return(0);
}

arg()
{
	register char *p, *p3;

	colonf = 0;
	p = ptr;
	while (*p++ == ' ');
	if (*--p == '\n' || *p == ':') return(0);
	p3 = p;
	while (*p >= '-' && *p <= 'z' && *p != ':') p++;
	if (*p != ' ' && *p != '\n' && *p != ':')
	{
		printf("Bad char: %c.\n",*p);
		return(0);
	}
	if (*p == '\n') *(p+1) = '\n';
	if (*p == ':') colonf = 1;
	*p++ = 0;
	ptr = p;
	return(p3);
}

colon()
{
	register char *p;
	register int n;

	if (colonf)
	{
		colonf = 0;
		if (*ptr == ' ') ++ptr;
		return(1);
	}
	n = 0;
	p = ptr;
	while (*p++ == ' ');
	if (*(p-1) != ':')
	{
		ptr = p-1;
		return(0);
	}
	if (*p == ' ') ++p;
	ptr = p;
	return(1);
}

/*
 *   0: must specify 1 process or use last one;
 *   1: will accept `all';
 *   2: no spec implies all
 */

gproc(x)
{
	register char *s;
	register int n;

	if ((s=arg()) == 0)
		if (x==2) return(-1);
		   else if (curproc && proc[curproc].id) return(curproc);
			else {printf("?No proc specified.\n"); reset();}
	for (n=0; n<N; n++) if (equalx(s,proc[n].name)) goto match;
	printf("? `%s' not recognized.\n",s);
	reset();
match:  if (n == 0 && x == 0)
	{
		printf("? `all' option not allowed.\n");
		reset();
	}
	if (n != 0) return(curproc=n);
	curproc = 0;
	return(-1);
}

equalx(a,b)
{
	register char *x, *y;
	x = a;
	y = b;
	while (*x++ == *y) if (*y++ == 0) return(1);
	return(0);
}

cpy(a)
char *a;
{
	return(concat(a,""));
}

concat(a,b)
{
	register char *x, *y;
	register int n;

	n = 1;
	x = a;
	while (*x++) n++;
	x = b;
	while (*x++) n++;
	n = y = alloc(n);
	x = a;
	while (*y++ = *x++);
	--y;
	x = b;
	while (*y++ = *x++);
	return(n);
}

doread(p)
{
	register int n;
	if (n=read(p,buf,100)) return(n);
	death();
}

dowrite(port,buff,n)
{
	sig13 = 0;
	if (write(port,buff,n) == n && !sig13) return;
	death();
}

death()
{
	register int n, n2;
	int stat;

	n2 = proc[curproc].id;
	printf("\nDeath!\n");
	if (n2 == 0) return;
	do if ((n = wait(&stat)) == -1) break; else pkill(n);
	   while (n != n2);
	reset();
}

pwait(indx,flag)
{
	register int n, savn;
	int stat;

	if (indx == 0) return;
	if (indx == -1)
	{
		for (n=1; n<N; n++) if (proc[n].id) pwait(n,flag);
		return;
	}
	n = proc[indx].id;
	switch (flag) {
	  case CLOSE:
		close(proc[indx].oport);
		proc[indx].oport = -1;
		break;
	  case KILL:
		skill(savn = n,9);
		do if ((n = wait(&stat)) == -1) return; else pkill(n);
		while (n != savn);
		break;
	  case INTRP:
		skill(n,2);
		break;
	  case QUIT:
		skill(n,3);
		break;
	}
}

pkill(n)
{
	register int i;
	register char *p, c;

	for (i=1; i<N; i++) if (proc[i].id == n) goto good;
	printf("? %d just killed?!\n",n);
	return;
good:   p = proc[i].name;
	c = *p++;
	printf("%c%s killed.\n",(c >= 'a' && c <= 'z')? (c&~040) : c, p);
	free(p-1);
	proc[i].id = proc[i].name = 0;
	close(proc[i].iport);
	close(proc[i].oport);
}

pstatus(n)
{
	if (proc[n].id == 0) return;
	printf("%s:\t%s",proc[n].name,
			empty(proc[n].iport)? "no output" : "output waiting");
	if (proc[n].oport < 0) printf(" (closed)");
	printf(".\n");
}

cleanup()
{
	register int p;
	struct {int inode; char nam[15];} dir;

	dir.nam[14] = 0;
	p = open(".",0);
	while (read(p,&dir,16)) if (dir.inode != 0 && match(dir.nam)) goto x;
	printf("?Couldn't find opser file.\n");
	return;
x:      unlink(dir.nam);
	return;
}

match(s)
{
	register char *p, *p3;
	p = s;
	p3 = "opser.";
	while (*p3) if (*p++ != *p3++) return(0);
	return(atoi(p) == getpid());
}

intrp()
{
	signal(2,&intrp);
	reset();
}

quit()
{
	signal(2,1);
	signal(3,1);
	signal(1,&awake);
	for (;;) sleep(12*3600);
}

awake()
{
	signal(1,1);
	signal(2,&intrp);
	signal(3,&quit);
	reset();
}

pipesig()
{
	signal(13,&pipesig);
	++sig13;
}





