/ C library-- floating output

.globl	fltused
.globl	pfloat
.globl	pscien
.globl	_ecvt
.globl	_fcvt

fltused:		/ force loading
pfloat:
	mov	r0,_ndigit
	tst	r2
	jne	0f
	mov	$6,_ndigit
0:
	mov	(r4)+,ac0
	mov	(r4)+,2+ac0
	mov	(r4)+,4+ac0
	mov	(r4)+,6+ac0
	jsr	pc,fcvt

/	Sign.
	tst	r1
	jeq	0f
	movb	$'-,(r3)+
0:

/	Part to left of decimal point.
	mov	r2,r1
	jgt	0f
	movb	$'0,(r3)+
	jbr	1f
0:
	jsr	pc,movedig
	sob	r1,0b
1:

/	Decimal point (if any).
	mov	_ndigit,r1
	jle	2f
	movb	$'.,(r3)+

/	Leading zeroes.
	neg	r2
	jle	1f
0:
	movb	$'0,(r3)+
	dec	r1
	jle	2f
	sob	r2,0b

/	Fractional part.
1:
	jsr	pc,movedig
	sob	r1,1b
2:
	rts	pc

pscien:
	mov	r0,_ndigit
	tst	r2
	jne	0f
	mov	$6,_ndigit
0:
	mov	(r4)+,ac0
	mov	(r4)+,2+ac0
	mov	(r4)+,4+ac0
	mov	(r4)+,6+ac0
	jsr	pc,ecvt

/	Sign.
	tst	r1
	jeq	0f
	movb	$'-,(r3)+
0:

/	Leading digit and decimal point.
	jsr	pc,movedig
	movb	$'.,(r3)+
	mov	_ndigit,r1
	dec	r1		/In %w.de, d controls total # of digits.
				/(which is at variance with documentation).
	jle	1f
2:
	jsr	pc,movedig
	sob	r1,2b
1:
	movb	$'e,(r3)+
	dec	r2
	mov	r2,r1
	jge	1f
	movb	$'-,(r3)+
	neg	r1
	br	2f
1:
	movb	$'+,(r3)+
2:
	clr	r0
	div	$10.,r0
	add	$'0,r0
	movb	r0,(r3)+
	add	$'0,r1
	movb	r1,(r3)+
	rts	pc

movedig:
	movb	(r0)+,(r3)+
	jne	0f
	dec	r0
	movb	$'0,-1(r3)
0:
	rts	pc

_ecvt:
	mov     r5,-(sp)
	mov     sp,r5
	mov     r2,-(sp)
	mov	4(r5),ac0
	mov	6(r5),2+ac0
	mov	10(r5),4+ac0
	mov	12(r5),6+ac0
	mov     14(r5),_ndigit
	jsr     pc,ecvt
	br      1f

_fcvt:
	mov     r5,-(sp)
	mov     sp,r5
	mov     r2,-(sp)
	mov	4(r5),ac0
	mov	6(r5),2+ac0
	mov	10(r5),4+ac0
	mov	12(r5),6+ac0
	mov     14(r5),_ndigit
	jsr     pc,fcvt
1:
	mov     r2,*16(r5)
	mov     r1,*20(r5)
	mov     (sp)+,r2
	mov     (sp)+,r5
	rts     pc

ecvt:
	mov	pc,eflag
	jbr	0f
fcvt:
	clr	eflag
0:
	mov	r4,-(sp)
	mov	r3,-(sp)
	clr	-(sp)
	mov	6+ac0,r3
	mov	4+ac0,r2
	mov	2+ac0,r1
	mov	ac0,r0
	jeq	scaled
	bic	$!0000177,r0
	bis	$0000200,r0
	jsr	pc,norm
	mov	ac0,r4
	asl	r4
	clrb	r4
	swab	r4
	sub	$128.,r4
	jgt	1f
0:
	jsr	pc,mul10
	dec	(sp)
	jsr	pc,norm
	tst	r4
	jle	0b
1:
	jsr	pc,div10
	inc	(sp)
	jsr	pc,norm
	tst	r4
	jgt	1b
	jeq	scaled
0:
	jsr	pc,right
	inc	r4
	jne	0b
scaled:
	mov	$buf,r4
0:
	jsr	pc,mul10
	mov	r0,-(sp)
	ash	$-12.,r0
	bic	$!017,r0
	add	$'0,r0
	movb	r0,(r4)+
	mov	(sp)+,r0
	bic	$0170000,r0
	cmp	r4,$buftop
	jlo	0b
	mov	$buf,r0
	add	_ndigit,r0
	tst	eflag
	jne	0f
	add	(sp),r0
0:
	cmp	r0,$buftop
	jhis	done
	cmp	r0,$buf
	jlo	done
	movb	(r0),r3
	add	$5,r3
	movb	r3,(r0)
0:
	cmpb	(r0),$'9
	jle	done
	movb	$'0,(r0)
	cmp	r0,$buf
	jlos	0f
	incb	-(r0)
	jbr	0b
0:
	movb	$'1,(r0)
	inc	(sp)
done:
	mov	_ndigit,r0
	tst	eflag
	jne	0f
	add	(sp),r0
0:
	cmp	r0,$buftop
	jhis	0f
	cmp	r0,$buf
	jlo	0f
	clrb	buf(r0)
0:
	mov	(sp)+,r2
	mov	(sp)+,r3
	mov	(sp)+,r4
	clr	r1
	tst	ac0
	jpl	0f
	inc	r1
0:
	mov	$buf,r0
	rts	pc
.bss
.even
eflag:		.=.+2
_ndigit:	.=.+2
buf:		.=.+40.
buftop:		.=.+2	/always zero;terminates an absolutely full buffer
ac0:		.=.+8.
.text

norm:
0:
	cmp	r0,$0004000
	jhis	0f
	jsr	pc,left
	dec	r4
	jbr	0b
0:
	cmp	r0,$0010000
	jlo	0f
	jsr	pc,right
	inc	r4
	jbr	0b
0:
	rts	pc

div10:
	mov	r1,savedr1
	mov	r0,r1
	clr	r0
	div	$10.,r0
	mov	r0,-(sp)
	mov	r1,r0
	mov	savedr1,r1
	div	$20.,r0
	mov	r0,-(sp)
	mov	r1,r0
	mov	r2,r1
	div	$40.,r0
	mov	r0,r2
	mov	r1,r0
	mov	r3,r1
	div	$80.,r0
	mov	r0,r3

/	Set r0 to r1/10 (rounded)
	clr	r0
	div	$5.,r0
	inc	r0
	asr	r0
/
	mov	(sp)+,r1
	asl	r3
	ashc	$2.,r2
	rol	r1
	add	r0,r3
	adc	r2
	adc	r1
	mov	(sp)+,r0
	adc	r0
	rts	pc
.bss
.even
savedr1:	.=.+2
.text

mul10:
	jsr	pc,left
	mov	r0,-(sp)
	mov	r1,-(sp)
	mov	r2,-(sp)
	mov	r3,-(sp)
	jsr	pc,left
	jsr	pc,left
	add	(sp)+,r3
	adc	r2
	adc	r1
	adc	r0
	add	(sp)+,r2
	adc	r1
	adc	r0
	add	(sp)+,r1
	adc	r0
	add	(sp)+,r0
	rts	pc

left:
	asl	r3
	rol	r2
	rol	r1
	rol	r0
	rts	pc

right:
	clc
	ror	r0
	ror	r1
	ror	r2
	ror	r3
	rts	pc
