#
#include "../h/param.h"
#include "../h/user.h"
/*
 * crash	format a post mortem dump of unix
 *	synopsis:	crash [aps] [-s sfile] [-c cfile]
 *	It examines a dump of unix which it looks for in the file
 *	sysdump.  It prints out the contents of the general
 *	registers, the kernel stack and a traceback through the
 *	kernel stack.  If an aps is specified, the ps and pc at
 *	time of interrupt are also printed out.  The dump of the
 *	stack commences from a "reasonable" address and all addresses
 *	are relocated to virtual addresses by using the value of
 *	kdsa6 found in the dump.
 *	  If the -s argument is found the following argument is taken
 *	to be the name of a file, containing a symbol table which
 *	should be used in interpreting text addresses.  The default
 *	is "/unix".  If the -c argument is found, the following argument
 *	is taken to be the name of a file which should be used instead
 *	of "sysdump".
 *
 *	problems:	It does not currently support formatted dumps
 *	of the active (or any other) user area.
 *	
 */

	int buf[256];
	struct syment {
		char name[8];
		int flags;
		int value;
		} ;
	struct syment *symtab;
	struct syment *maxsym;
	char *corref {"sysdump"};
	char *symref {"/unix"};
	int stroct();
	int bflg 0;			/* brief flag -- u only */

main(argc,argv)
 int argc;
 char **argv;
{
	register int i;
	register int j;
	register int core;

	int sym;
	int trapstack;
	int	u_addr;					/* u block number */
	int	u_death;				/* death u */
	int sp;
	int r5;

	trapstack = 0;
	u_addr = 0;
	/* parse off the arguments and do what I can with them */
	for(i=1; i<argc; i++)
		if ((*argv[i] == '-') && (((i+1) < argc) || (argv[i][1] == 'b')))
		{	if (argv[i][1] == 'c')
			{	corref = argv[++i];
				continue;
			} else if (argv[i][1] == 's')
			{	symref = argv[++i];
				continue;
			} else if (argv[i][1] == 'u')
			{	u_addr = stroct(argv[++i]);
				continue;
			} else if (argv[i][1] == 'b')
			{	bflg++;
				continue;
			}
			else printf("Bad argument: %s\n",
					argv[i]);
		}
		else
		{	trapstack = stroct(argv[i]);
			if (trapstack == 0)
				printf("Bad argument: %s\n",argv[i]);
		}

	core = open(corref,0);
	if (core < 0)
	{	printf("Unable to open %s\n",corref);
		exit(-1);
	}

	sym = open(symref,0);
	if (sym < 0)
	{	printf("Unable to open %s\n",symref);
		exit(1);
	}
	else
	{	read(sym,buf,020);
		if (buf[0]!=0407 && buf[0]!=0410 && buf[0]!=0411)
		{	printf("Format error in %s\n",symref);
			exit(1);
		}
		seek(sym, (buf[1]>>1) & 077777, 1);
		seek(sym, (buf[1]>>1) & 077777, 1);
		seek(sym, (buf[2]>>1) & 077777, 1);
		seek(sym, (buf[2]>>1) & 077777, 1);
		if (buf[7] != 1)
		{	seek(sym, (buf[1]>>1) & 077777, 1);
			seek(sym, (buf[1]>>1) & 077777, 1);
			seek(sym, (buf[2]>>1) & 077777, 1);
			seek(sym, (buf[2]>>1) & 077777, 1);
		}
		i = buf[4];
		i = buf[4]/12;
		j = i*12;
		if (i == 0)
		{	printf("No namelist in %s\n",symref);
			exit(1);
		}
		symtab = sbrk(j);
		read(sym,symtab,j);
		maxsym = symtab + i;
		close(sym);
	}


	/*	dump the registers	*/
	printf("\tThe registers\n");
	seek(core,4,0);
	read(core,buf,16);
	printf("\nr0: "); octout(buf[0]);
	printf("\tr1: "); octout(buf[1]);
	printf("\tr2: "); octout(buf[2]);
	printf("\nr3: "); octout(buf[3]);
	printf("\tr4: "); octout(buf[4]);
	printf("\tr5: "); octout(buf[5]);
	printf("\nsp: "); octout(buf[6]);
	printf("\tksda: "); octout(buf[7]);
	sp = buf[6] & 0177760;
	r5 = buf[5];

	u_death = buf[7];
	if (u_addr) buf[7] = u_addr;				/* u addr */
	seek(core,buf[7]>>3,3);	/* do a seek to beginning of stack */
	seek(core,(buf[7]&07)<<6,1); /* space using a wierd identity */
	if (u_addr)
	{
		read (core, &u, sizeof (u));
		seek (core, -sizeof (u), 1);			/* and back up */

		if (u_addr != u_death)
		{
			sp = u.u_rsav[0];
			r5 = u.u_rsav[1];
		}

		printf ("\n\n u at %o, r5 = %o, sp = %o\n\n",u_addr, r5, sp);
printf ("seg err uid gid rud rgd ifg hsy sep  procp  tsize  dsize  ssize\n");
printf ("%3d %3d %3d %3d %3d %3d %3d %3d %3d %6d %6d %6d %6d \n\n",
u.u_segflg, u.u_error, u.u_uid, u.u_gid, u.u_ruid, u.u_rgid, u.u_intflg, 
u.u_hsyscalls, u.u_sep, u.u_procp, u.u_tsize, u.u_dsize, u.u_ssize);
printf ("nseg npiu fpiu lpiu piu0 piu1 piu2 piu3 piu4 piu5 pui6 piu7\n");
printf ("%4d %4d %4d %4d %4d %4d %4d %4d %4d %4d %4d %4d \n\n",
u.u_nsegs, u.u_npiu, u.u_fpiu, u.u_lpiu, u.u_piu[0], u.u_piu[1], u.u_piu[2], u.u_piu[3], u.u_piu[4], u.u_piu[5], u.u_piu[6], u.u_piu[7]);
printf ("    m0     m1     m2     m3     m4     m5     m6     m7\n");
printf ("%6o %6o %6o %6o %6o %6o %6o %6o \n",
u.u_segmap[0], u.u_segmap[1], u.u_segmap[2], u.u_segmap[3], u.u_segmap[4],
u.u_segmap[5], u.u_segmap[6], u.u_segmap[7]);
if (bflg)
	exit();
	}


	if ((sp < 0140000) || (sp > 0141756))
	{	printf("\n\tsp is unreasonable, 0140000 assumed\n");
		sp = 0140000;
		/* since sp is bad, give him whole user area */
	}

	/*	If an aps was specified, give ps, pc, sp at trap time */
	if (trapstack == 0) trapstack = sp;	/* temporary */
	if (trapstack)
	{
		seek(core,trapstack-0140000,1);
		read(core,buf,4);
		printf("\n\n\timmediately prior to the trap:\n");
		printf("\nsp: "); octout(trapstack+4);
		printf("\tps: "); octout(buf[1]);
		printf("\tpc: "); octout(buf[0]);
		symbol(buf[0]);
		seek(core,sp-(trapstack+4),1);
	}
	else	seek(core,sp-0140000,1);

	/* now give a dump of the stack, relocating as we go */
	printf("\n\n\n\tThe stack\n\n");
	printf("  loc   loc+00 loc+02 loc+04 loc+06   loc+10");
	printf(" loc+12 loc+14 loc+16\n");

	for(i=sp; i < 0142000; i =+ 16)
	{
		read(core,buf,16);
		printf("\n"); octout(i);
		printf(": "); octout(buf[0]);
		printf(" "); octout(buf[1]);
		printf(" "); octout(buf[2]);
		printf(" "); octout(buf[3]);
		printf("   "); octout(buf[4]);
		printf(" "); octout(buf[5]);
		printf(" "); octout(buf[6]);
		printf(" "); octout(buf[7]);
	}

	/* go back to beginning of stack space and give trace */
	seek(core,sp-i,1);
	printf("\n\n\n\tTrace-back through stack\n\n");

	printf("  loc    old r2  old r3  old r4  old r5  old pc\n");
	i = sp;
	while((r5 > i) && (r5 < 0142000))
	{	if (r5 == 0141756) break;
		seek(core,(r5-i)-6,1);
		read(core,buf,10);
		printf("\n"); octout(r5);
		printf(":  "); octout(buf[0]);
		printf("  "); octout(buf[1]);
		printf("  "); octout(buf[2]);
		printf("  "); octout(buf[3]);
		printf("  "); octout(buf[4]);
		symbol(buf[4]);
		i = r5 + 4;
		r5 = buf[3];
	}
	if (r5 != 0141756)
		printf("\n\tThe dynamic chain is broken\n");
	printf("\n\tEnd of trace-back\n");
}



/*
 *	stroct		Mark Kampe	7/2/75
 *	returns:	int
 *	takes:		*char
 *	it does:	If string represents an octal integer,
 *			the value of that integer is returned.
 *			If not, a zero is returned.
 *			The string should be null terminated and
 *			contain no non-octal-numerics.
 */
int stroct(s1)
	char *s1;
{
	register char *p;
	register char thisn;
	register int value;

	p = s1;
	value = 0;
	while (thisn = *p++)
		if ((thisn >= '0') && (thisn <= '7'))
		{	value =<< 3;
			value =+ thisn - '0';
		}
		else return(0);

	return(value);
}



/*
 *	octout		Mark Kampe	7/2/75
 *	returns:	nothing
 *	takes:		int
 *	it does:	print the integer as a six digit
 *			octal number with leading zeroes
 *			as required.  I wrote this because
 *			I found the octal output produced
 *			by printf to be very hard to read.
 *			maybe I'm a pervert, but I like the leading
 *			zeroes.  If you dont, replace this
 *			routine with "printf("%6o",arg);"
 *
 */
octout(value)
 int value;
{
	register int v;
	char outbuf[6];
	register char *c;
	register int i;

	v = value;
	c = &outbuf[5];

	for(i = 0; i<6; i++)
	{	*c-- = (v & 07) + '0';
		v =>> 3;
	}
	if (v == -1) *outbuf = '1'; /* damned arithmetic shifts */

	write(1,outbuf,6);
	return;
}



/*
 *	symbol		mark kampe	11/17/75
 *	takes:		int (an address)
 *	returns:	int (address of symbol table entry)
 *	it does:	find the global text symbol whose
 *			value is the nearest less than or
 *			equal to the passed address.  It then
 *			prints out a field of the form
 *			(<symbol>+<offset>).  The value
 *			the value returned is the address of
 *			the symbol table entry for that symbol.
 */
symbol(val)
 int val;
{
	register int v;
	register struct syment *i;
	register int mindif;
	int minptr;
	int thisdif;

	v = val;
	mindif = 077777;
	minptr = 0;
	for(i=symtab; i<maxsym; i++)
	{	if ((i->flags & 077) != 042) continue;
		if (compare(i->value , v) > 0) continue;
		thisdif = v - i->value;
		if (compare(thisdif, mindif) >= 0) continue;
		mindif = thisdif;
		minptr = i;
	}
	if (minptr == 0) return(0);
	write(1," (",2);
	write(1,minptr->name,8);
	if (mindif) printf("+%d",mindif);
	write(1,")",1);
	return(minptr);
}



